/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KustoAttachedDatabaseConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#cluster_name KustoAttachedDatabaseConfiguration#cluster_name}
    */
    readonly clusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#cluster_resource_id KustoAttachedDatabaseConfiguration#cluster_resource_id}
    */
    readonly clusterResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#database_name KustoAttachedDatabaseConfiguration#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#default_principal_modification_kind KustoAttachedDatabaseConfiguration#default_principal_modification_kind}
    */
    readonly defaultPrincipalModificationKind?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#id KustoAttachedDatabaseConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#location KustoAttachedDatabaseConfiguration#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#name KustoAttachedDatabaseConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#resource_group_name KustoAttachedDatabaseConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * sharing block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#sharing KustoAttachedDatabaseConfiguration#sharing}
    */
    readonly sharing?: KustoAttachedDatabaseConfigurationSharing;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#timeouts KustoAttachedDatabaseConfiguration#timeouts}
    */
    readonly timeouts?: KustoAttachedDatabaseConfigurationTimeouts;
}
export interface KustoAttachedDatabaseConfigurationSharing {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#external_tables_to_exclude KustoAttachedDatabaseConfiguration#external_tables_to_exclude}
    */
    readonly externalTablesToExclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#external_tables_to_include KustoAttachedDatabaseConfiguration#external_tables_to_include}
    */
    readonly externalTablesToInclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#materialized_views_to_exclude KustoAttachedDatabaseConfiguration#materialized_views_to_exclude}
    */
    readonly materializedViewsToExclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#materialized_views_to_include KustoAttachedDatabaseConfiguration#materialized_views_to_include}
    */
    readonly materializedViewsToInclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#tables_to_exclude KustoAttachedDatabaseConfiguration#tables_to_exclude}
    */
    readonly tablesToExclude?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#tables_to_include KustoAttachedDatabaseConfiguration#tables_to_include}
    */
    readonly tablesToInclude?: string[];
}
export declare function kustoAttachedDatabaseConfigurationSharingToTerraform(struct?: KustoAttachedDatabaseConfigurationSharingOutputReference | KustoAttachedDatabaseConfigurationSharing): any;
export declare function kustoAttachedDatabaseConfigurationSharingToHclTerraform(struct?: KustoAttachedDatabaseConfigurationSharingOutputReference | KustoAttachedDatabaseConfigurationSharing): any;
export declare class KustoAttachedDatabaseConfigurationSharingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KustoAttachedDatabaseConfigurationSharing | undefined;
    set internalValue(value: KustoAttachedDatabaseConfigurationSharing | undefined);
    private _externalTablesToExclude?;
    get externalTablesToExclude(): string[];
    set externalTablesToExclude(value: string[]);
    resetExternalTablesToExclude(): void;
    get externalTablesToExcludeInput(): string[] | undefined;
    private _externalTablesToInclude?;
    get externalTablesToInclude(): string[];
    set externalTablesToInclude(value: string[]);
    resetExternalTablesToInclude(): void;
    get externalTablesToIncludeInput(): string[] | undefined;
    private _materializedViewsToExclude?;
    get materializedViewsToExclude(): string[];
    set materializedViewsToExclude(value: string[]);
    resetMaterializedViewsToExclude(): void;
    get materializedViewsToExcludeInput(): string[] | undefined;
    private _materializedViewsToInclude?;
    get materializedViewsToInclude(): string[];
    set materializedViewsToInclude(value: string[]);
    resetMaterializedViewsToInclude(): void;
    get materializedViewsToIncludeInput(): string[] | undefined;
    private _tablesToExclude?;
    get tablesToExclude(): string[];
    set tablesToExclude(value: string[]);
    resetTablesToExclude(): void;
    get tablesToExcludeInput(): string[] | undefined;
    private _tablesToInclude?;
    get tablesToInclude(): string[];
    set tablesToInclude(value: string[]);
    resetTablesToInclude(): void;
    get tablesToIncludeInput(): string[] | undefined;
}
export interface KustoAttachedDatabaseConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#create KustoAttachedDatabaseConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#delete KustoAttachedDatabaseConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#read KustoAttachedDatabaseConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#update KustoAttachedDatabaseConfiguration#update}
    */
    readonly update?: string;
}
export declare function kustoAttachedDatabaseConfigurationTimeoutsToTerraform(struct?: KustoAttachedDatabaseConfigurationTimeouts | cdktf.IResolvable): any;
export declare function kustoAttachedDatabaseConfigurationTimeoutsToHclTerraform(struct?: KustoAttachedDatabaseConfigurationTimeouts | cdktf.IResolvable): any;
export declare class KustoAttachedDatabaseConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KustoAttachedDatabaseConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KustoAttachedDatabaseConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration azurerm_kusto_attached_database_configuration}
*/
export declare class KustoAttachedDatabaseConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kusto_attached_database_configuration";
    /**
    * Generates CDKTF code for importing a KustoAttachedDatabaseConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KustoAttachedDatabaseConfiguration to import
    * @param importFromId The id of the existing KustoAttachedDatabaseConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KustoAttachedDatabaseConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kusto_attached_database_configuration azurerm_kusto_attached_database_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KustoAttachedDatabaseConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: KustoAttachedDatabaseConfigurationConfig);
    get attachedDatabaseNames(): string[];
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    get clusterNameInput(): string | undefined;
    private _clusterResourceId?;
    get clusterResourceId(): string;
    set clusterResourceId(value: string);
    get clusterResourceIdInput(): string | undefined;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _defaultPrincipalModificationKind?;
    get defaultPrincipalModificationKind(): string;
    set defaultPrincipalModificationKind(value: string);
    resetDefaultPrincipalModificationKind(): void;
    get defaultPrincipalModificationKindInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sharing;
    get sharing(): KustoAttachedDatabaseConfigurationSharingOutputReference;
    putSharing(value: KustoAttachedDatabaseConfigurationSharing): void;
    resetSharing(): void;
    get sharingInput(): KustoAttachedDatabaseConfigurationSharing | undefined;
    private _timeouts;
    get timeouts(): KustoAttachedDatabaseConfigurationTimeoutsOutputReference;
    putTimeouts(value: KustoAttachedDatabaseConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KustoAttachedDatabaseConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
