/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MobileNetworkServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#id MobileNetworkService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#location MobileNetworkService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#mobile_network_id MobileNetworkService#mobile_network_id}
    */
    readonly mobileNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#name MobileNetworkService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#service_precedence MobileNetworkService#service_precedence}
    */
    readonly servicePrecedence: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#tags MobileNetworkService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * pcc_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#pcc_rule MobileNetworkService#pcc_rule}
    */
    readonly pccRule: MobileNetworkServicePccRule[] | cdktf.IResolvable;
    /**
    * service_qos_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#service_qos_policy MobileNetworkService#service_qos_policy}
    */
    readonly serviceQosPolicy?: MobileNetworkServiceServiceQosPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#timeouts MobileNetworkService#timeouts}
    */
    readonly timeouts?: MobileNetworkServiceTimeouts;
}
export interface MobileNetworkServicePccRuleQosPolicyGuaranteedBitRate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#downlink MobileNetworkService#downlink}
    */
    readonly downlink: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#uplink MobileNetworkService#uplink}
    */
    readonly uplink: string;
}
export declare function mobileNetworkServicePccRuleQosPolicyGuaranteedBitRateToTerraform(struct?: MobileNetworkServicePccRuleQosPolicyGuaranteedBitRateOutputReference | MobileNetworkServicePccRuleQosPolicyGuaranteedBitRate): any;
export declare function mobileNetworkServicePccRuleQosPolicyGuaranteedBitRateToHclTerraform(struct?: MobileNetworkServicePccRuleQosPolicyGuaranteedBitRateOutputReference | MobileNetworkServicePccRuleQosPolicyGuaranteedBitRate): any;
export declare class MobileNetworkServicePccRuleQosPolicyGuaranteedBitRateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkServicePccRuleQosPolicyGuaranteedBitRate | undefined;
    set internalValue(value: MobileNetworkServicePccRuleQosPolicyGuaranteedBitRate | undefined);
    private _downlink?;
    get downlink(): string;
    set downlink(value: string);
    get downlinkInput(): string | undefined;
    private _uplink?;
    get uplink(): string;
    set uplink(value: string);
    get uplinkInput(): string | undefined;
}
export interface MobileNetworkServicePccRuleQosPolicyMaximumBitRate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#downlink MobileNetworkService#downlink}
    */
    readonly downlink: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#uplink MobileNetworkService#uplink}
    */
    readonly uplink: string;
}
export declare function mobileNetworkServicePccRuleQosPolicyMaximumBitRateToTerraform(struct?: MobileNetworkServicePccRuleQosPolicyMaximumBitRateOutputReference | MobileNetworkServicePccRuleQosPolicyMaximumBitRate): any;
export declare function mobileNetworkServicePccRuleQosPolicyMaximumBitRateToHclTerraform(struct?: MobileNetworkServicePccRuleQosPolicyMaximumBitRateOutputReference | MobileNetworkServicePccRuleQosPolicyMaximumBitRate): any;
export declare class MobileNetworkServicePccRuleQosPolicyMaximumBitRateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkServicePccRuleQosPolicyMaximumBitRate | undefined;
    set internalValue(value: MobileNetworkServicePccRuleQosPolicyMaximumBitRate | undefined);
    private _downlink?;
    get downlink(): string;
    set downlink(value: string);
    get downlinkInput(): string | undefined;
    private _uplink?;
    get uplink(): string;
    set uplink(value: string);
    get uplinkInput(): string | undefined;
}
export interface MobileNetworkServicePccRuleQosPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#allocation_and_retention_priority_level MobileNetworkService#allocation_and_retention_priority_level}
    */
    readonly allocationAndRetentionPriorityLevel?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#preemption_capability MobileNetworkService#preemption_capability}
    */
    readonly preemptionCapability?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#preemption_vulnerability MobileNetworkService#preemption_vulnerability}
    */
    readonly preemptionVulnerability?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#qos_indicator MobileNetworkService#qos_indicator}
    */
    readonly qosIndicator: number;
    /**
    * guaranteed_bit_rate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#guaranteed_bit_rate MobileNetworkService#guaranteed_bit_rate}
    */
    readonly guaranteedBitRate?: MobileNetworkServicePccRuleQosPolicyGuaranteedBitRate;
    /**
    * maximum_bit_rate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#maximum_bit_rate MobileNetworkService#maximum_bit_rate}
    */
    readonly maximumBitRate: MobileNetworkServicePccRuleQosPolicyMaximumBitRate;
}
export declare function mobileNetworkServicePccRuleQosPolicyToTerraform(struct?: MobileNetworkServicePccRuleQosPolicyOutputReference | MobileNetworkServicePccRuleQosPolicy): any;
export declare function mobileNetworkServicePccRuleQosPolicyToHclTerraform(struct?: MobileNetworkServicePccRuleQosPolicyOutputReference | MobileNetworkServicePccRuleQosPolicy): any;
export declare class MobileNetworkServicePccRuleQosPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkServicePccRuleQosPolicy | undefined;
    set internalValue(value: MobileNetworkServicePccRuleQosPolicy | undefined);
    private _allocationAndRetentionPriorityLevel?;
    get allocationAndRetentionPriorityLevel(): number;
    set allocationAndRetentionPriorityLevel(value: number);
    resetAllocationAndRetentionPriorityLevel(): void;
    get allocationAndRetentionPriorityLevelInput(): number | undefined;
    private _preemptionCapability?;
    get preemptionCapability(): string;
    set preemptionCapability(value: string);
    resetPreemptionCapability(): void;
    get preemptionCapabilityInput(): string | undefined;
    private _preemptionVulnerability?;
    get preemptionVulnerability(): string;
    set preemptionVulnerability(value: string);
    resetPreemptionVulnerability(): void;
    get preemptionVulnerabilityInput(): string | undefined;
    private _qosIndicator?;
    get qosIndicator(): number;
    set qosIndicator(value: number);
    get qosIndicatorInput(): number | undefined;
    private _guaranteedBitRate;
    get guaranteedBitRate(): MobileNetworkServicePccRuleQosPolicyGuaranteedBitRateOutputReference;
    putGuaranteedBitRate(value: MobileNetworkServicePccRuleQosPolicyGuaranteedBitRate): void;
    resetGuaranteedBitRate(): void;
    get guaranteedBitRateInput(): MobileNetworkServicePccRuleQosPolicyGuaranteedBitRate | undefined;
    private _maximumBitRate;
    get maximumBitRate(): MobileNetworkServicePccRuleQosPolicyMaximumBitRateOutputReference;
    putMaximumBitRate(value: MobileNetworkServicePccRuleQosPolicyMaximumBitRate): void;
    get maximumBitRateInput(): MobileNetworkServicePccRuleQosPolicyMaximumBitRate | undefined;
}
export interface MobileNetworkServicePccRuleServiceDataFlowTemplate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#direction MobileNetworkService#direction}
    */
    readonly direction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#name MobileNetworkService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#ports MobileNetworkService#ports}
    */
    readonly ports?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#protocol MobileNetworkService#protocol}
    */
    readonly protocol: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#remote_ip_list MobileNetworkService#remote_ip_list}
    */
    readonly remoteIpList: string[];
}
export declare function mobileNetworkServicePccRuleServiceDataFlowTemplateToTerraform(struct?: MobileNetworkServicePccRuleServiceDataFlowTemplate | cdktf.IResolvable): any;
export declare function mobileNetworkServicePccRuleServiceDataFlowTemplateToHclTerraform(struct?: MobileNetworkServicePccRuleServiceDataFlowTemplate | cdktf.IResolvable): any;
export declare class MobileNetworkServicePccRuleServiceDataFlowTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MobileNetworkServicePccRuleServiceDataFlowTemplate | cdktf.IResolvable | undefined;
    set internalValue(value: MobileNetworkServicePccRuleServiceDataFlowTemplate | cdktf.IResolvable | undefined);
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ports?;
    get ports(): string[];
    set ports(value: string[]);
    resetPorts(): void;
    get portsInput(): string[] | undefined;
    private _protocol?;
    get protocol(): string[];
    set protocol(value: string[]);
    get protocolInput(): string[] | undefined;
    private _remoteIpList?;
    get remoteIpList(): string[];
    set remoteIpList(value: string[]);
    get remoteIpListInput(): string[] | undefined;
}
export declare class MobileNetworkServicePccRuleServiceDataFlowTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MobileNetworkServicePccRuleServiceDataFlowTemplate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MobileNetworkServicePccRuleServiceDataFlowTemplateOutputReference;
}
export interface MobileNetworkServicePccRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#name MobileNetworkService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#precedence MobileNetworkService#precedence}
    */
    readonly precedence: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#traffic_control_enabled MobileNetworkService#traffic_control_enabled}
    */
    readonly trafficControlEnabled?: boolean | cdktf.IResolvable;
    /**
    * qos_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#qos_policy MobileNetworkService#qos_policy}
    */
    readonly qosPolicy?: MobileNetworkServicePccRuleQosPolicy;
    /**
    * service_data_flow_template block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#service_data_flow_template MobileNetworkService#service_data_flow_template}
    */
    readonly serviceDataFlowTemplate: MobileNetworkServicePccRuleServiceDataFlowTemplate[] | cdktf.IResolvable;
}
export declare function mobileNetworkServicePccRuleToTerraform(struct?: MobileNetworkServicePccRule | cdktf.IResolvable): any;
export declare function mobileNetworkServicePccRuleToHclTerraform(struct?: MobileNetworkServicePccRule | cdktf.IResolvable): any;
export declare class MobileNetworkServicePccRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MobileNetworkServicePccRule | cdktf.IResolvable | undefined;
    set internalValue(value: MobileNetworkServicePccRule | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _precedence?;
    get precedence(): number;
    set precedence(value: number);
    get precedenceInput(): number | undefined;
    private _trafficControlEnabled?;
    get trafficControlEnabled(): boolean | cdktf.IResolvable;
    set trafficControlEnabled(value: boolean | cdktf.IResolvable);
    resetTrafficControlEnabled(): void;
    get trafficControlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _qosPolicy;
    get qosPolicy(): MobileNetworkServicePccRuleQosPolicyOutputReference;
    putQosPolicy(value: MobileNetworkServicePccRuleQosPolicy): void;
    resetQosPolicy(): void;
    get qosPolicyInput(): MobileNetworkServicePccRuleQosPolicy | undefined;
    private _serviceDataFlowTemplate;
    get serviceDataFlowTemplate(): MobileNetworkServicePccRuleServiceDataFlowTemplateList;
    putServiceDataFlowTemplate(value: MobileNetworkServicePccRuleServiceDataFlowTemplate[] | cdktf.IResolvable): void;
    get serviceDataFlowTemplateInput(): cdktf.IResolvable | MobileNetworkServicePccRuleServiceDataFlowTemplate[] | undefined;
}
export declare class MobileNetworkServicePccRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MobileNetworkServicePccRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MobileNetworkServicePccRuleOutputReference;
}
export interface MobileNetworkServiceServiceQosPolicyMaximumBitRate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#downlink MobileNetworkService#downlink}
    */
    readonly downlink: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#uplink MobileNetworkService#uplink}
    */
    readonly uplink: string;
}
export declare function mobileNetworkServiceServiceQosPolicyMaximumBitRateToTerraform(struct?: MobileNetworkServiceServiceQosPolicyMaximumBitRateOutputReference | MobileNetworkServiceServiceQosPolicyMaximumBitRate): any;
export declare function mobileNetworkServiceServiceQosPolicyMaximumBitRateToHclTerraform(struct?: MobileNetworkServiceServiceQosPolicyMaximumBitRateOutputReference | MobileNetworkServiceServiceQosPolicyMaximumBitRate): any;
export declare class MobileNetworkServiceServiceQosPolicyMaximumBitRateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkServiceServiceQosPolicyMaximumBitRate | undefined;
    set internalValue(value: MobileNetworkServiceServiceQosPolicyMaximumBitRate | undefined);
    private _downlink?;
    get downlink(): string;
    set downlink(value: string);
    get downlinkInput(): string | undefined;
    private _uplink?;
    get uplink(): string;
    set uplink(value: string);
    get uplinkInput(): string | undefined;
}
export interface MobileNetworkServiceServiceQosPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#allocation_and_retention_priority_level MobileNetworkService#allocation_and_retention_priority_level}
    */
    readonly allocationAndRetentionPriorityLevel?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#preemption_capability MobileNetworkService#preemption_capability}
    */
    readonly preemptionCapability?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#preemption_vulnerability MobileNetworkService#preemption_vulnerability}
    */
    readonly preemptionVulnerability?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#qos_indicator MobileNetworkService#qos_indicator}
    */
    readonly qosIndicator?: number;
    /**
    * maximum_bit_rate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#maximum_bit_rate MobileNetworkService#maximum_bit_rate}
    */
    readonly maximumBitRate: MobileNetworkServiceServiceQosPolicyMaximumBitRate;
}
export declare function mobileNetworkServiceServiceQosPolicyToTerraform(struct?: MobileNetworkServiceServiceQosPolicyOutputReference | MobileNetworkServiceServiceQosPolicy): any;
export declare function mobileNetworkServiceServiceQosPolicyToHclTerraform(struct?: MobileNetworkServiceServiceQosPolicyOutputReference | MobileNetworkServiceServiceQosPolicy): any;
export declare class MobileNetworkServiceServiceQosPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkServiceServiceQosPolicy | undefined;
    set internalValue(value: MobileNetworkServiceServiceQosPolicy | undefined);
    private _allocationAndRetentionPriorityLevel?;
    get allocationAndRetentionPriorityLevel(): number;
    set allocationAndRetentionPriorityLevel(value: number);
    resetAllocationAndRetentionPriorityLevel(): void;
    get allocationAndRetentionPriorityLevelInput(): number | undefined;
    private _preemptionCapability?;
    get preemptionCapability(): string;
    set preemptionCapability(value: string);
    resetPreemptionCapability(): void;
    get preemptionCapabilityInput(): string | undefined;
    private _preemptionVulnerability?;
    get preemptionVulnerability(): string;
    set preemptionVulnerability(value: string);
    resetPreemptionVulnerability(): void;
    get preemptionVulnerabilityInput(): string | undefined;
    private _qosIndicator?;
    get qosIndicator(): number;
    set qosIndicator(value: number);
    resetQosIndicator(): void;
    get qosIndicatorInput(): number | undefined;
    private _maximumBitRate;
    get maximumBitRate(): MobileNetworkServiceServiceQosPolicyMaximumBitRateOutputReference;
    putMaximumBitRate(value: MobileNetworkServiceServiceQosPolicyMaximumBitRate): void;
    get maximumBitRateInput(): MobileNetworkServiceServiceQosPolicyMaximumBitRate | undefined;
}
export interface MobileNetworkServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#create MobileNetworkService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#delete MobileNetworkService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#read MobileNetworkService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#update MobileNetworkService#update}
    */
    readonly update?: string;
}
export declare function mobileNetworkServiceTimeoutsToTerraform(struct?: MobileNetworkServiceTimeouts | cdktf.IResolvable): any;
export declare function mobileNetworkServiceTimeoutsToHclTerraform(struct?: MobileNetworkServiceTimeouts | cdktf.IResolvable): any;
export declare class MobileNetworkServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MobileNetworkServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MobileNetworkServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service azurerm_mobile_network_service}
*/
export declare class MobileNetworkService extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mobile_network_service";
    /**
    * Generates CDKTF code for importing a MobileNetworkService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MobileNetworkService to import
    * @param importFromId The id of the existing MobileNetworkService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MobileNetworkService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mobile_network_service azurerm_mobile_network_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MobileNetworkServiceConfig
    */
    constructor(scope: Construct, id: string, config: MobileNetworkServiceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mobileNetworkId?;
    get mobileNetworkId(): string;
    set mobileNetworkId(value: string);
    get mobileNetworkIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _servicePrecedence?;
    get servicePrecedence(): number;
    set servicePrecedence(value: number);
    get servicePrecedenceInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _pccRule;
    get pccRule(): MobileNetworkServicePccRuleList;
    putPccRule(value: MobileNetworkServicePccRule[] | cdktf.IResolvable): void;
    get pccRuleInput(): cdktf.IResolvable | MobileNetworkServicePccRule[] | undefined;
    private _serviceQosPolicy;
    get serviceQosPolicy(): MobileNetworkServiceServiceQosPolicyOutputReference;
    putServiceQosPolicy(value: MobileNetworkServiceServiceQosPolicy): void;
    resetServiceQosPolicy(): void;
    get serviceQosPolicyInput(): MobileNetworkServiceServiceQosPolicy | undefined;
    private _timeouts;
    get timeouts(): MobileNetworkServiceTimeoutsOutputReference;
    putTimeouts(value: MobileNetworkServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MobileNetworkServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
