/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlVirtualMachineGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#id MssqlVirtualMachineGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#location MssqlVirtualMachineGroup#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#name MssqlVirtualMachineGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#resource_group_name MssqlVirtualMachineGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#sql_image_offer MssqlVirtualMachineGroup#sql_image_offer}
    */
    readonly sqlImageOffer: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#sql_image_sku MssqlVirtualMachineGroup#sql_image_sku}
    */
    readonly sqlImageSku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#tags MssqlVirtualMachineGroup#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#timeouts MssqlVirtualMachineGroup#timeouts}
    */
    readonly timeouts?: MssqlVirtualMachineGroupTimeouts;
    /**
    * wsfc_domain_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#wsfc_domain_profile MssqlVirtualMachineGroup#wsfc_domain_profile}
    */
    readonly wsfcDomainProfile: MssqlVirtualMachineGroupWsfcDomainProfile;
}
export interface MssqlVirtualMachineGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#create MssqlVirtualMachineGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#delete MssqlVirtualMachineGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#read MssqlVirtualMachineGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#update MssqlVirtualMachineGroup#update}
    */
    readonly update?: string;
}
export declare function mssqlVirtualMachineGroupTimeoutsToTerraform(struct?: MssqlVirtualMachineGroupTimeouts | cdktf.IResolvable): any;
export declare function mssqlVirtualMachineGroupTimeoutsToHclTerraform(struct?: MssqlVirtualMachineGroupTimeouts | cdktf.IResolvable): any;
export declare class MssqlVirtualMachineGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MssqlVirtualMachineGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface MssqlVirtualMachineGroupWsfcDomainProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#cluster_bootstrap_account_name MssqlVirtualMachineGroup#cluster_bootstrap_account_name}
    */
    readonly clusterBootstrapAccountName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#cluster_operator_account_name MssqlVirtualMachineGroup#cluster_operator_account_name}
    */
    readonly clusterOperatorAccountName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#cluster_subnet_type MssqlVirtualMachineGroup#cluster_subnet_type}
    */
    readonly clusterSubnetType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#fqdn MssqlVirtualMachineGroup#fqdn}
    */
    readonly fqdn: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#organizational_unit_path MssqlVirtualMachineGroup#organizational_unit_path}
    */
    readonly organizationalUnitPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#sql_service_account_name MssqlVirtualMachineGroup#sql_service_account_name}
    */
    readonly sqlServiceAccountName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#storage_account_primary_key MssqlVirtualMachineGroup#storage_account_primary_key}
    */
    readonly storageAccountPrimaryKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#storage_account_url MssqlVirtualMachineGroup#storage_account_url}
    */
    readonly storageAccountUrl?: string;
}
export declare function mssqlVirtualMachineGroupWsfcDomainProfileToTerraform(struct?: MssqlVirtualMachineGroupWsfcDomainProfileOutputReference | MssqlVirtualMachineGroupWsfcDomainProfile): any;
export declare function mssqlVirtualMachineGroupWsfcDomainProfileToHclTerraform(struct?: MssqlVirtualMachineGroupWsfcDomainProfileOutputReference | MssqlVirtualMachineGroupWsfcDomainProfile): any;
export declare class MssqlVirtualMachineGroupWsfcDomainProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlVirtualMachineGroupWsfcDomainProfile | undefined;
    set internalValue(value: MssqlVirtualMachineGroupWsfcDomainProfile | undefined);
    private _clusterBootstrapAccountName?;
    get clusterBootstrapAccountName(): string;
    set clusterBootstrapAccountName(value: string);
    resetClusterBootstrapAccountName(): void;
    get clusterBootstrapAccountNameInput(): string | undefined;
    private _clusterOperatorAccountName?;
    get clusterOperatorAccountName(): string;
    set clusterOperatorAccountName(value: string);
    resetClusterOperatorAccountName(): void;
    get clusterOperatorAccountNameInput(): string | undefined;
    private _clusterSubnetType?;
    get clusterSubnetType(): string;
    set clusterSubnetType(value: string);
    get clusterSubnetTypeInput(): string | undefined;
    private _fqdn?;
    get fqdn(): string;
    set fqdn(value: string);
    get fqdnInput(): string | undefined;
    private _organizationalUnitPath?;
    get organizationalUnitPath(): string;
    set organizationalUnitPath(value: string);
    resetOrganizationalUnitPath(): void;
    get organizationalUnitPathInput(): string | undefined;
    private _sqlServiceAccountName?;
    get sqlServiceAccountName(): string;
    set sqlServiceAccountName(value: string);
    resetSqlServiceAccountName(): void;
    get sqlServiceAccountNameInput(): string | undefined;
    private _storageAccountPrimaryKey?;
    get storageAccountPrimaryKey(): string;
    set storageAccountPrimaryKey(value: string);
    resetStorageAccountPrimaryKey(): void;
    get storageAccountPrimaryKeyInput(): string | undefined;
    private _storageAccountUrl?;
    get storageAccountUrl(): string;
    set storageAccountUrl(value: string);
    resetStorageAccountUrl(): void;
    get storageAccountUrlInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group azurerm_mssql_virtual_machine_group}
*/
export declare class MssqlVirtualMachineGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_virtual_machine_group";
    /**
    * Generates CDKTF code for importing a MssqlVirtualMachineGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MssqlVirtualMachineGroup to import
    * @param importFromId The id of the existing MssqlVirtualMachineGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MssqlVirtualMachineGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/mssql_virtual_machine_group azurerm_mssql_virtual_machine_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlVirtualMachineGroupConfig
    */
    constructor(scope: Construct, id: string, config: MssqlVirtualMachineGroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sqlImageOffer?;
    get sqlImageOffer(): string;
    set sqlImageOffer(value: string);
    get sqlImageOfferInput(): string | undefined;
    private _sqlImageSku?;
    get sqlImageSku(): string;
    set sqlImageSku(value: string);
    get sqlImageSkuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): MssqlVirtualMachineGroupTimeoutsOutputReference;
    putTimeouts(value: MssqlVirtualMachineGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MssqlVirtualMachineGroupTimeouts | undefined;
    private _wsfcDomainProfile;
    get wsfcDomainProfile(): MssqlVirtualMachineGroupWsfcDomainProfileOutputReference;
    putWsfcDomainProfile(value: MssqlVirtualMachineGroupWsfcDomainProfile): void;
    get wsfcDomainProfileInput(): MssqlVirtualMachineGroupWsfcDomainProfile | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
