/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetappVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#account_name NetappVolume#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#azure_vmware_data_store_enabled NetappVolume#azure_vmware_data_store_enabled}
    */
    readonly azureVmwareDataStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#create_from_snapshot_resource_id NetappVolume#create_from_snapshot_resource_id}
    */
    readonly createFromSnapshotResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#encryption_key_source NetappVolume#encryption_key_source}
    */
    readonly encryptionKeySource?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#id NetappVolume#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Enable to allow Kerberos secured volumes. Requires appropriate export rules as well as the parent `azurerm_netapp_account` having a defined AD connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#kerberos_enabled NetappVolume#kerberos_enabled}
    */
    readonly kerberosEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#key_vault_private_endpoint_id NetappVolume#key_vault_private_endpoint_id}
    */
    readonly keyVaultPrivateEndpointId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#location NetappVolume#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#name NetappVolume#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#network_features NetappVolume#network_features}
    */
    readonly networkFeatures?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#pool_name NetappVolume#pool_name}
    */
    readonly poolName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#protocols NetappVolume#protocols}
    */
    readonly protocols?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#resource_group_name NetappVolume#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#security_style NetappVolume#security_style}
    */
    readonly securityStyle?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#service_level NetappVolume#service_level}
    */
    readonly serviceLevel: string;
    /**
    * SMB3 encryption option should be used only for SMB/DualProtocol volumes. Using it for any other workloads is not supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#smb3_protocol_encryption_enabled NetappVolume#smb3_protocol_encryption_enabled}
    */
    readonly smb3ProtocolEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enable access based enumeration setting for SMB/Dual Protocol volume. When enabled, users who do not have permission to access a shared folder or file underneath it, do not see that shared resource displayed in their environment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#smb_access_based_enumeration_enabled NetappVolume#smb_access_based_enumeration_enabled}
    */
    readonly smbAccessBasedEnumerationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Continuous availability option should be used only for SQL and FSLogix workloads. Using it for any other SMB workloads is not supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#smb_continuous_availability_enabled NetappVolume#smb_continuous_availability_enabled}
    */
    readonly smbContinuousAvailabilityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Enable non browsable share setting for SMB/Dual Protocol volume. When enabled, it restricts windows clients to browse the share
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#smb_non_browsable_enabled NetappVolume#smb_non_browsable_enabled}
    */
    readonly smbNonBrowsableEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#snapshot_directory_visible NetappVolume#snapshot_directory_visible}
    */
    readonly snapshotDirectoryVisible?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#storage_quota_in_gb NetappVolume#storage_quota_in_gb}
    */
    readonly storageQuotaInGb: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#subnet_id NetappVolume#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#tags NetappVolume#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#throughput_in_mibps NetappVolume#throughput_in_mibps}
    */
    readonly throughputInMibps?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#volume_path NetappVolume#volume_path}
    */
    readonly volumePath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#zone NetappVolume#zone}
    */
    readonly zone?: string;
    /**
    * data_protection_backup_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#data_protection_backup_policy NetappVolume#data_protection_backup_policy}
    */
    readonly dataProtectionBackupPolicy?: NetappVolumeDataProtectionBackupPolicy;
    /**
    * data_protection_replication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#data_protection_replication NetappVolume#data_protection_replication}
    */
    readonly dataProtectionReplication?: NetappVolumeDataProtectionReplication;
    /**
    * data_protection_snapshot_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#data_protection_snapshot_policy NetappVolume#data_protection_snapshot_policy}
    */
    readonly dataProtectionSnapshotPolicy?: NetappVolumeDataProtectionSnapshotPolicy;
    /**
    * export_policy_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#export_policy_rule NetappVolume#export_policy_rule}
    */
    readonly exportPolicyRule?: NetappVolumeExportPolicyRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#timeouts NetappVolume#timeouts}
    */
    readonly timeouts?: NetappVolumeTimeouts;
}
export interface NetappVolumeDataProtectionBackupPolicy {
    /**
    * The ID of the backup policy to associate with this volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#backup_policy_id NetappVolume#backup_policy_id}
    */
    readonly backupPolicyId: string;
    /**
    * The ID of the backup vault to associate with this volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#backup_vault_id NetappVolume#backup_vault_id}
    */
    readonly backupVaultId: string;
    /**
    * If set to false, the backup policy will not be enabled on this volume, thus disabling scheduled backups.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#policy_enabled NetappVolume#policy_enabled}
    */
    readonly policyEnabled?: boolean | cdktf.IResolvable;
}
export declare function netappVolumeDataProtectionBackupPolicyToTerraform(struct?: NetappVolumeDataProtectionBackupPolicyOutputReference | NetappVolumeDataProtectionBackupPolicy): any;
export declare function netappVolumeDataProtectionBackupPolicyToHclTerraform(struct?: NetappVolumeDataProtectionBackupPolicyOutputReference | NetappVolumeDataProtectionBackupPolicy): any;
export declare class NetappVolumeDataProtectionBackupPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappVolumeDataProtectionBackupPolicy | undefined;
    set internalValue(value: NetappVolumeDataProtectionBackupPolicy | undefined);
    private _backupPolicyId?;
    get backupPolicyId(): string;
    set backupPolicyId(value: string);
    get backupPolicyIdInput(): string | undefined;
    private _backupVaultId?;
    get backupVaultId(): string;
    set backupVaultId(value: string);
    get backupVaultIdInput(): string | undefined;
    private _policyEnabled?;
    get policyEnabled(): boolean | cdktf.IResolvable;
    set policyEnabled(value: boolean | cdktf.IResolvable);
    resetPolicyEnabled(): void;
    get policyEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface NetappVolumeDataProtectionReplication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#endpoint_type NetappVolume#endpoint_type}
    */
    readonly endpointType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#remote_volume_location NetappVolume#remote_volume_location}
    */
    readonly remoteVolumeLocation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#remote_volume_resource_id NetappVolume#remote_volume_resource_id}
    */
    readonly remoteVolumeResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#replication_frequency NetappVolume#replication_frequency}
    */
    readonly replicationFrequency: string;
}
export declare function netappVolumeDataProtectionReplicationToTerraform(struct?: NetappVolumeDataProtectionReplicationOutputReference | NetappVolumeDataProtectionReplication): any;
export declare function netappVolumeDataProtectionReplicationToHclTerraform(struct?: NetappVolumeDataProtectionReplicationOutputReference | NetappVolumeDataProtectionReplication): any;
export declare class NetappVolumeDataProtectionReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappVolumeDataProtectionReplication | undefined;
    set internalValue(value: NetappVolumeDataProtectionReplication | undefined);
    private _endpointType?;
    get endpointType(): string;
    set endpointType(value: string);
    resetEndpointType(): void;
    get endpointTypeInput(): string | undefined;
    private _remoteVolumeLocation?;
    get remoteVolumeLocation(): string;
    set remoteVolumeLocation(value: string);
    get remoteVolumeLocationInput(): string | undefined;
    private _remoteVolumeResourceId?;
    get remoteVolumeResourceId(): string;
    set remoteVolumeResourceId(value: string);
    get remoteVolumeResourceIdInput(): string | undefined;
    private _replicationFrequency?;
    get replicationFrequency(): string;
    set replicationFrequency(value: string);
    get replicationFrequencyInput(): string | undefined;
}
export interface NetappVolumeDataProtectionSnapshotPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#snapshot_policy_id NetappVolume#snapshot_policy_id}
    */
    readonly snapshotPolicyId: string;
}
export declare function netappVolumeDataProtectionSnapshotPolicyToTerraform(struct?: NetappVolumeDataProtectionSnapshotPolicyOutputReference | NetappVolumeDataProtectionSnapshotPolicy): any;
export declare function netappVolumeDataProtectionSnapshotPolicyToHclTerraform(struct?: NetappVolumeDataProtectionSnapshotPolicyOutputReference | NetappVolumeDataProtectionSnapshotPolicy): any;
export declare class NetappVolumeDataProtectionSnapshotPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappVolumeDataProtectionSnapshotPolicy | undefined;
    set internalValue(value: NetappVolumeDataProtectionSnapshotPolicy | undefined);
    private _snapshotPolicyId?;
    get snapshotPolicyId(): string;
    set snapshotPolicyId(value: string);
    get snapshotPolicyIdInput(): string | undefined;
}
export interface NetappVolumeExportPolicyRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#allowed_clients NetappVolume#allowed_clients}
    */
    readonly allowedClients: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#kerberos_5_read_only_enabled NetappVolume#kerberos_5_read_only_enabled}
    */
    readonly kerberos5ReadOnlyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#kerberos_5_read_write_enabled NetappVolume#kerberos_5_read_write_enabled}
    */
    readonly kerberos5ReadWriteEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#kerberos_5i_read_only_enabled NetappVolume#kerberos_5i_read_only_enabled}
    */
    readonly kerberos5IReadOnlyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#kerberos_5i_read_write_enabled NetappVolume#kerberos_5i_read_write_enabled}
    */
    readonly kerberos5IReadWriteEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#kerberos_5p_read_only_enabled NetappVolume#kerberos_5p_read_only_enabled}
    */
    readonly kerberos5PReadOnlyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#kerberos_5p_read_write_enabled NetappVolume#kerberos_5p_read_write_enabled}
    */
    readonly kerberos5PReadWriteEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#protocols_enabled NetappVolume#protocols_enabled}
    */
    readonly protocolsEnabled?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#root_access_enabled NetappVolume#root_access_enabled}
    */
    readonly rootAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#rule_index NetappVolume#rule_index}
    */
    readonly ruleIndex: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#unix_read_only NetappVolume#unix_read_only}
    */
    readonly unixReadOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#unix_read_write NetappVolume#unix_read_write}
    */
    readonly unixReadWrite?: boolean | cdktf.IResolvable;
}
export declare function netappVolumeExportPolicyRuleToTerraform(struct?: NetappVolumeExportPolicyRule | cdktf.IResolvable): any;
export declare function netappVolumeExportPolicyRuleToHclTerraform(struct?: NetappVolumeExportPolicyRule | cdktf.IResolvable): any;
export declare class NetappVolumeExportPolicyRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetappVolumeExportPolicyRule | cdktf.IResolvable | undefined;
    set internalValue(value: NetappVolumeExportPolicyRule | cdktf.IResolvable | undefined);
    private _allowedClients?;
    get allowedClients(): string[];
    set allowedClients(value: string[]);
    get allowedClientsInput(): string[] | undefined;
    private _kerberos5ReadOnlyEnabled?;
    get kerberos5ReadOnlyEnabled(): boolean | cdktf.IResolvable;
    set kerberos5ReadOnlyEnabled(value: boolean | cdktf.IResolvable);
    resetKerberos5ReadOnlyEnabled(): void;
    get kerberos5ReadOnlyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberos5ReadWriteEnabled?;
    get kerberos5ReadWriteEnabled(): boolean | cdktf.IResolvable;
    set kerberos5ReadWriteEnabled(value: boolean | cdktf.IResolvable);
    resetKerberos5ReadWriteEnabled(): void;
    get kerberos5ReadWriteEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberos5IReadOnlyEnabled?;
    get kerberos5IReadOnlyEnabled(): boolean | cdktf.IResolvable;
    set kerberos5IReadOnlyEnabled(value: boolean | cdktf.IResolvable);
    resetKerberos5IReadOnlyEnabled(): void;
    get kerberos5IReadOnlyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberos5IReadWriteEnabled?;
    get kerberos5IReadWriteEnabled(): boolean | cdktf.IResolvable;
    set kerberos5IReadWriteEnabled(value: boolean | cdktf.IResolvable);
    resetKerberos5IReadWriteEnabled(): void;
    get kerberos5IReadWriteEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberos5PReadOnlyEnabled?;
    get kerberos5PReadOnlyEnabled(): boolean | cdktf.IResolvable;
    set kerberos5PReadOnlyEnabled(value: boolean | cdktf.IResolvable);
    resetKerberos5PReadOnlyEnabled(): void;
    get kerberos5PReadOnlyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _kerberos5PReadWriteEnabled?;
    get kerberos5PReadWriteEnabled(): boolean | cdktf.IResolvable;
    set kerberos5PReadWriteEnabled(value: boolean | cdktf.IResolvable);
    resetKerberos5PReadWriteEnabled(): void;
    get kerberos5PReadWriteEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _protocolsEnabled?;
    get protocolsEnabled(): string[];
    set protocolsEnabled(value: string[]);
    resetProtocolsEnabled(): void;
    get protocolsEnabledInput(): string[] | undefined;
    private _rootAccessEnabled?;
    get rootAccessEnabled(): boolean | cdktf.IResolvable;
    set rootAccessEnabled(value: boolean | cdktf.IResolvable);
    resetRootAccessEnabled(): void;
    get rootAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ruleIndex?;
    get ruleIndex(): number;
    set ruleIndex(value: number);
    get ruleIndexInput(): number | undefined;
    private _unixReadOnly?;
    get unixReadOnly(): boolean | cdktf.IResolvable;
    set unixReadOnly(value: boolean | cdktf.IResolvable);
    resetUnixReadOnly(): void;
    get unixReadOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _unixReadWrite?;
    get unixReadWrite(): boolean | cdktf.IResolvable;
    set unixReadWrite(value: boolean | cdktf.IResolvable);
    resetUnixReadWrite(): void;
    get unixReadWriteInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class NetappVolumeExportPolicyRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetappVolumeExportPolicyRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetappVolumeExportPolicyRuleOutputReference;
}
export interface NetappVolumeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#create NetappVolume#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#delete NetappVolume#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#read NetappVolume#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#update NetappVolume#update}
    */
    readonly update?: string;
}
export declare function netappVolumeTimeoutsToTerraform(struct?: NetappVolumeTimeouts | cdktf.IResolvable): any;
export declare function netappVolumeTimeoutsToHclTerraform(struct?: NetappVolumeTimeouts | cdktf.IResolvable): any;
export declare class NetappVolumeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetappVolumeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetappVolumeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume azurerm_netapp_volume}
*/
export declare class NetappVolume extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_netapp_volume";
    /**
    * Generates CDKTF code for importing a NetappVolume resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetappVolume to import
    * @param importFromId The id of the existing NetappVolume that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetappVolume to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/netapp_volume azurerm_netapp_volume} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetappVolumeConfig
    */
    constructor(scope: Construct, id: string, config: NetappVolumeConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _azureVmwareDataStoreEnabled?;
    get azureVmwareDataStoreEnabled(): boolean | cdktf.IResolvable;
    set azureVmwareDataStoreEnabled(value: boolean | cdktf.IResolvable);
    resetAzureVmwareDataStoreEnabled(): void;
    get azureVmwareDataStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _createFromSnapshotResourceId?;
    get createFromSnapshotResourceId(): string;
    set createFromSnapshotResourceId(value: string);
    resetCreateFromSnapshotResourceId(): void;
    get createFromSnapshotResourceIdInput(): string | undefined;
    private _encryptionKeySource?;
    get encryptionKeySource(): string;
    set encryptionKeySource(value: string);
    resetEncryptionKeySource(): void;
    get encryptionKeySourceInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kerberosEnabled?;
    get kerberosEnabled(): boolean | cdktf.IResolvable;
    set kerberosEnabled(value: boolean | cdktf.IResolvable);
    resetKerberosEnabled(): void;
    get kerberosEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVaultPrivateEndpointId?;
    get keyVaultPrivateEndpointId(): string;
    set keyVaultPrivateEndpointId(value: string);
    resetKeyVaultPrivateEndpointId(): void;
    get keyVaultPrivateEndpointIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get mountIpAddresses(): string[];
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkFeatures?;
    get networkFeatures(): string;
    set networkFeatures(value: string);
    resetNetworkFeatures(): void;
    get networkFeaturesInput(): string | undefined;
    private _poolName?;
    get poolName(): string;
    set poolName(value: string);
    get poolNameInput(): string | undefined;
    private _protocols?;
    get protocols(): string[];
    set protocols(value: string[]);
    resetProtocols(): void;
    get protocolsInput(): string[] | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _securityStyle?;
    get securityStyle(): string;
    set securityStyle(value: string);
    resetSecurityStyle(): void;
    get securityStyleInput(): string | undefined;
    private _serviceLevel?;
    get serviceLevel(): string;
    set serviceLevel(value: string);
    get serviceLevelInput(): string | undefined;
    private _smb3ProtocolEncryptionEnabled?;
    get smb3ProtocolEncryptionEnabled(): boolean | cdktf.IResolvable;
    set smb3ProtocolEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetSmb3ProtocolEncryptionEnabled(): void;
    get smb3ProtocolEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _smbAccessBasedEnumerationEnabled?;
    get smbAccessBasedEnumerationEnabled(): boolean | cdktf.IResolvable;
    set smbAccessBasedEnumerationEnabled(value: boolean | cdktf.IResolvable);
    resetSmbAccessBasedEnumerationEnabled(): void;
    get smbAccessBasedEnumerationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _smbContinuousAvailabilityEnabled?;
    get smbContinuousAvailabilityEnabled(): boolean | cdktf.IResolvable;
    set smbContinuousAvailabilityEnabled(value: boolean | cdktf.IResolvable);
    resetSmbContinuousAvailabilityEnabled(): void;
    get smbContinuousAvailabilityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _smbNonBrowsableEnabled?;
    get smbNonBrowsableEnabled(): boolean | cdktf.IResolvable;
    set smbNonBrowsableEnabled(value: boolean | cdktf.IResolvable);
    resetSmbNonBrowsableEnabled(): void;
    get smbNonBrowsableEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _snapshotDirectoryVisible?;
    get snapshotDirectoryVisible(): boolean | cdktf.IResolvable;
    set snapshotDirectoryVisible(value: boolean | cdktf.IResolvable);
    resetSnapshotDirectoryVisible(): void;
    get snapshotDirectoryVisibleInput(): boolean | cdktf.IResolvable | undefined;
    private _storageQuotaInGb?;
    get storageQuotaInGb(): number;
    set storageQuotaInGb(value: number);
    get storageQuotaInGbInput(): number | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _throughputInMibps?;
    get throughputInMibps(): number;
    set throughputInMibps(value: number);
    resetThroughputInMibps(): void;
    get throughputInMibpsInput(): number | undefined;
    private _volumePath?;
    get volumePath(): string;
    set volumePath(value: string);
    get volumePathInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _dataProtectionBackupPolicy;
    get dataProtectionBackupPolicy(): NetappVolumeDataProtectionBackupPolicyOutputReference;
    putDataProtectionBackupPolicy(value: NetappVolumeDataProtectionBackupPolicy): void;
    resetDataProtectionBackupPolicy(): void;
    get dataProtectionBackupPolicyInput(): NetappVolumeDataProtectionBackupPolicy | undefined;
    private _dataProtectionReplication;
    get dataProtectionReplication(): NetappVolumeDataProtectionReplicationOutputReference;
    putDataProtectionReplication(value: NetappVolumeDataProtectionReplication): void;
    resetDataProtectionReplication(): void;
    get dataProtectionReplicationInput(): NetappVolumeDataProtectionReplication | undefined;
    private _dataProtectionSnapshotPolicy;
    get dataProtectionSnapshotPolicy(): NetappVolumeDataProtectionSnapshotPolicyOutputReference;
    putDataProtectionSnapshotPolicy(value: NetappVolumeDataProtectionSnapshotPolicy): void;
    resetDataProtectionSnapshotPolicy(): void;
    get dataProtectionSnapshotPolicyInput(): NetappVolumeDataProtectionSnapshotPolicy | undefined;
    private _exportPolicyRule;
    get exportPolicyRule(): NetappVolumeExportPolicyRuleList;
    putExportPolicyRule(value: NetappVolumeExportPolicyRule[] | cdktf.IResolvable): void;
    resetExportPolicyRule(): void;
    get exportPolicyRuleInput(): cdktf.IResolvable | NetappVolumeExportPolicyRule[] | undefined;
    private _timeouts;
    get timeouts(): NetappVolumeTimeoutsOutputReference;
    putTimeouts(value: NetappVolumeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetappVolumeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
