/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OracleAutonomousDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#admin_password OracleAutonomousDatabase#admin_password}
    */
    readonly adminPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#auto_scaling_enabled OracleAutonomousDatabase#auto_scaling_enabled}
    */
    readonly autoScalingEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#auto_scaling_for_storage_enabled OracleAutonomousDatabase#auto_scaling_for_storage_enabled}
    */
    readonly autoScalingForStorageEnabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#backup_retention_period_in_days OracleAutonomousDatabase#backup_retention_period_in_days}
    */
    readonly backupRetentionPeriodInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#character_set OracleAutonomousDatabase#character_set}
    */
    readonly characterSet: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#compute_count OracleAutonomousDatabase#compute_count}
    */
    readonly computeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#compute_model OracleAutonomousDatabase#compute_model}
    */
    readonly computeModel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#customer_contacts OracleAutonomousDatabase#customer_contacts}
    */
    readonly customerContacts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#data_storage_size_in_tbs OracleAutonomousDatabase#data_storage_size_in_tbs}
    */
    readonly dataStorageSizeInTbs: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#db_version OracleAutonomousDatabase#db_version}
    */
    readonly dbVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#db_workload OracleAutonomousDatabase#db_workload}
    */
    readonly dbWorkload: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#display_name OracleAutonomousDatabase#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#id OracleAutonomousDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#license_model OracleAutonomousDatabase#license_model}
    */
    readonly licenseModel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#location OracleAutonomousDatabase#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#mtls_connection_required OracleAutonomousDatabase#mtls_connection_required}
    */
    readonly mtlsConnectionRequired: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#name OracleAutonomousDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#national_character_set OracleAutonomousDatabase#national_character_set}
    */
    readonly nationalCharacterSet: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#resource_group_name OracleAutonomousDatabase#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#subnet_id OracleAutonomousDatabase#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#tags OracleAutonomousDatabase#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#virtual_network_id OracleAutonomousDatabase#virtual_network_id}
    */
    readonly virtualNetworkId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#timeouts OracleAutonomousDatabase#timeouts}
    */
    readonly timeouts?: OracleAutonomousDatabaseTimeouts;
}
export interface OracleAutonomousDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#create OracleAutonomousDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#delete OracleAutonomousDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#read OracleAutonomousDatabase#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#update OracleAutonomousDatabase#update}
    */
    readonly update?: string;
}
export declare function oracleAutonomousDatabaseTimeoutsToTerraform(struct?: OracleAutonomousDatabaseTimeouts | cdktf.IResolvable): any;
export declare function oracleAutonomousDatabaseTimeoutsToHclTerraform(struct?: OracleAutonomousDatabaseTimeouts | cdktf.IResolvable): any;
export declare class OracleAutonomousDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OracleAutonomousDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: OracleAutonomousDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database azurerm_oracle_autonomous_database}
*/
export declare class OracleAutonomousDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_oracle_autonomous_database";
    /**
    * Generates CDKTF code for importing a OracleAutonomousDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OracleAutonomousDatabase to import
    * @param importFromId The id of the existing OracleAutonomousDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OracleAutonomousDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_autonomous_database azurerm_oracle_autonomous_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OracleAutonomousDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: OracleAutonomousDatabaseConfig);
    private _adminPassword?;
    get adminPassword(): string;
    set adminPassword(value: string);
    get adminPasswordInput(): string | undefined;
    private _autoScalingEnabled?;
    get autoScalingEnabled(): boolean | cdktf.IResolvable;
    set autoScalingEnabled(value: boolean | cdktf.IResolvable);
    get autoScalingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoScalingForStorageEnabled?;
    get autoScalingForStorageEnabled(): boolean | cdktf.IResolvable;
    set autoScalingForStorageEnabled(value: boolean | cdktf.IResolvable);
    get autoScalingForStorageEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _backupRetentionPeriodInDays?;
    get backupRetentionPeriodInDays(): number;
    set backupRetentionPeriodInDays(value: number);
    get backupRetentionPeriodInDaysInput(): number | undefined;
    private _characterSet?;
    get characterSet(): string;
    set characterSet(value: string);
    get characterSetInput(): string | undefined;
    private _computeCount?;
    get computeCount(): number;
    set computeCount(value: number);
    get computeCountInput(): number | undefined;
    private _computeModel?;
    get computeModel(): string;
    set computeModel(value: string);
    get computeModelInput(): string | undefined;
    private _customerContacts?;
    get customerContacts(): string[];
    set customerContacts(value: string[]);
    resetCustomerContacts(): void;
    get customerContactsInput(): string[] | undefined;
    private _dataStorageSizeInTbs?;
    get dataStorageSizeInTbs(): number;
    set dataStorageSizeInTbs(value: number);
    get dataStorageSizeInTbsInput(): number | undefined;
    private _dbVersion?;
    get dbVersion(): string;
    set dbVersion(value: string);
    get dbVersionInput(): string | undefined;
    private _dbWorkload?;
    get dbWorkload(): string;
    set dbWorkload(value: string);
    get dbWorkloadInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _licenseModel?;
    get licenseModel(): string;
    set licenseModel(value: string);
    get licenseModelInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _mtlsConnectionRequired?;
    get mtlsConnectionRequired(): boolean | cdktf.IResolvable;
    set mtlsConnectionRequired(value: boolean | cdktf.IResolvable);
    get mtlsConnectionRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nationalCharacterSet?;
    get nationalCharacterSet(): string;
    set nationalCharacterSet(value: string);
    get nationalCharacterSetInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    get virtualNetworkIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): OracleAutonomousDatabaseTimeoutsOutputReference;
    putTimeouts(value: OracleAutonomousDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | OracleAutonomousDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
