/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OracleCloudVmClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#backup_subnet_cidr OracleCloudVmCluster#backup_subnet_cidr}
    */
    readonly backupSubnetCidr?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#cloud_exadata_infrastructure_id OracleCloudVmCluster#cloud_exadata_infrastructure_id}
    */
    readonly cloudExadataInfrastructureId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#cluster_name OracleCloudVmCluster#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#cpu_core_count OracleCloudVmCluster#cpu_core_count}
    */
    readonly cpuCoreCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#data_storage_percentage OracleCloudVmCluster#data_storage_percentage}
    */
    readonly dataStoragePercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#data_storage_size_in_tbs OracleCloudVmCluster#data_storage_size_in_tbs}
    */
    readonly dataStorageSizeInTbs?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#db_node_storage_size_in_gbs OracleCloudVmCluster#db_node_storage_size_in_gbs}
    */
    readonly dbNodeStorageSizeInGbs?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#db_servers OracleCloudVmCluster#db_servers}
    */
    readonly dbServers: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#display_name OracleCloudVmCluster#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#domain OracleCloudVmCluster#domain}
    */
    readonly domain?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#gi_version OracleCloudVmCluster#gi_version}
    */
    readonly giVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#hostname OracleCloudVmCluster#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#id OracleCloudVmCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#license_model OracleCloudVmCluster#license_model}
    */
    readonly licenseModel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#local_backup_enabled OracleCloudVmCluster#local_backup_enabled}
    */
    readonly localBackupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#location OracleCloudVmCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#memory_size_in_gbs OracleCloudVmCluster#memory_size_in_gbs}
    */
    readonly memorySizeInGbs?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#name OracleCloudVmCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#resource_group_name OracleCloudVmCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#scan_listener_port_tcp OracleCloudVmCluster#scan_listener_port_tcp}
    */
    readonly scanListenerPortTcp?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#scan_listener_port_tcp_ssl OracleCloudVmCluster#scan_listener_port_tcp_ssl}
    */
    readonly scanListenerPortTcpSsl?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#sparse_diskgroup_enabled OracleCloudVmCluster#sparse_diskgroup_enabled}
    */
    readonly sparseDiskgroupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#ssh_public_keys OracleCloudVmCluster#ssh_public_keys}
    */
    readonly sshPublicKeys: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#subnet_id OracleCloudVmCluster#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#tags OracleCloudVmCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#time_zone OracleCloudVmCluster#time_zone}
    */
    readonly timeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#virtual_network_id OracleCloudVmCluster#virtual_network_id}
    */
    readonly virtualNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#zone_id OracleCloudVmCluster#zone_id}
    */
    readonly zoneId?: string;
    /**
    * data_collection_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#data_collection_options OracleCloudVmCluster#data_collection_options}
    */
    readonly dataCollectionOptions?: OracleCloudVmClusterDataCollectionOptions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#timeouts OracleCloudVmCluster#timeouts}
    */
    readonly timeouts?: OracleCloudVmClusterTimeouts;
}
export interface OracleCloudVmClusterDataCollectionOptions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#diagnostics_events_enabled OracleCloudVmCluster#diagnostics_events_enabled}
    */
    readonly diagnosticsEventsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#health_monitoring_enabled OracleCloudVmCluster#health_monitoring_enabled}
    */
    readonly healthMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#incident_logs_enabled OracleCloudVmCluster#incident_logs_enabled}
    */
    readonly incidentLogsEnabled?: boolean | cdktf.IResolvable;
}
export declare function oracleCloudVmClusterDataCollectionOptionsToTerraform(struct?: OracleCloudVmClusterDataCollectionOptionsOutputReference | OracleCloudVmClusterDataCollectionOptions): any;
export declare function oracleCloudVmClusterDataCollectionOptionsToHclTerraform(struct?: OracleCloudVmClusterDataCollectionOptionsOutputReference | OracleCloudVmClusterDataCollectionOptions): any;
export declare class OracleCloudVmClusterDataCollectionOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OracleCloudVmClusterDataCollectionOptions | undefined;
    set internalValue(value: OracleCloudVmClusterDataCollectionOptions | undefined);
    private _diagnosticsEventsEnabled?;
    get diagnosticsEventsEnabled(): boolean | cdktf.IResolvable;
    set diagnosticsEventsEnabled(value: boolean | cdktf.IResolvable);
    resetDiagnosticsEventsEnabled(): void;
    get diagnosticsEventsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _healthMonitoringEnabled?;
    get healthMonitoringEnabled(): boolean | cdktf.IResolvable;
    set healthMonitoringEnabled(value: boolean | cdktf.IResolvable);
    resetHealthMonitoringEnabled(): void;
    get healthMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _incidentLogsEnabled?;
    get incidentLogsEnabled(): boolean | cdktf.IResolvable;
    set incidentLogsEnabled(value: boolean | cdktf.IResolvable);
    resetIncidentLogsEnabled(): void;
    get incidentLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OracleCloudVmClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#create OracleCloudVmCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#delete OracleCloudVmCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#read OracleCloudVmCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#update OracleCloudVmCluster#update}
    */
    readonly update?: string;
}
export declare function oracleCloudVmClusterTimeoutsToTerraform(struct?: OracleCloudVmClusterTimeouts | cdktf.IResolvable): any;
export declare function oracleCloudVmClusterTimeoutsToHclTerraform(struct?: OracleCloudVmClusterTimeouts | cdktf.IResolvable): any;
export declare class OracleCloudVmClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OracleCloudVmClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: OracleCloudVmClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster azurerm_oracle_cloud_vm_cluster}
*/
export declare class OracleCloudVmCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_oracle_cloud_vm_cluster";
    /**
    * Generates CDKTF code for importing a OracleCloudVmCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OracleCloudVmCluster to import
    * @param importFromId The id of the existing OracleCloudVmCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OracleCloudVmCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/oracle_cloud_vm_cluster azurerm_oracle_cloud_vm_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OracleCloudVmClusterConfig
    */
    constructor(scope: Construct, id: string, config: OracleCloudVmClusterConfig);
    private _backupSubnetCidr?;
    get backupSubnetCidr(): string;
    set backupSubnetCidr(value: string);
    resetBackupSubnetCidr(): void;
    get backupSubnetCidrInput(): string | undefined;
    private _cloudExadataInfrastructureId?;
    get cloudExadataInfrastructureId(): string;
    set cloudExadataInfrastructureId(value: string);
    get cloudExadataInfrastructureIdInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    private _cpuCoreCount?;
    get cpuCoreCount(): number;
    set cpuCoreCount(value: number);
    get cpuCoreCountInput(): number | undefined;
    private _dataStoragePercentage?;
    get dataStoragePercentage(): number;
    set dataStoragePercentage(value: number);
    resetDataStoragePercentage(): void;
    get dataStoragePercentageInput(): number | undefined;
    private _dataStorageSizeInTbs?;
    get dataStorageSizeInTbs(): number;
    set dataStorageSizeInTbs(value: number);
    resetDataStorageSizeInTbs(): void;
    get dataStorageSizeInTbsInput(): number | undefined;
    private _dbNodeStorageSizeInGbs?;
    get dbNodeStorageSizeInGbs(): number;
    set dbNodeStorageSizeInGbs(value: number);
    resetDbNodeStorageSizeInGbs(): void;
    get dbNodeStorageSizeInGbsInput(): number | undefined;
    private _dbServers?;
    get dbServers(): string[];
    set dbServers(value: string[]);
    get dbServersInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _giVersion?;
    get giVersion(): string;
    set giVersion(value: string);
    get giVersionInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    get hostnameActual(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _licenseModel?;
    get licenseModel(): string;
    set licenseModel(value: string);
    get licenseModelInput(): string | undefined;
    private _localBackupEnabled?;
    get localBackupEnabled(): boolean | cdktf.IResolvable;
    set localBackupEnabled(value: boolean | cdktf.IResolvable);
    resetLocalBackupEnabled(): void;
    get localBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _memorySizeInGbs?;
    get memorySizeInGbs(): number;
    set memorySizeInGbs(value: number);
    resetMemorySizeInGbs(): void;
    get memorySizeInGbsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get ocid(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _scanListenerPortTcp?;
    get scanListenerPortTcp(): number;
    set scanListenerPortTcp(value: number);
    resetScanListenerPortTcp(): void;
    get scanListenerPortTcpInput(): number | undefined;
    private _scanListenerPortTcpSsl?;
    get scanListenerPortTcpSsl(): number;
    set scanListenerPortTcpSsl(value: number);
    resetScanListenerPortTcpSsl(): void;
    get scanListenerPortTcpSslInput(): number | undefined;
    private _sparseDiskgroupEnabled?;
    get sparseDiskgroupEnabled(): boolean | cdktf.IResolvable;
    set sparseDiskgroupEnabled(value: boolean | cdktf.IResolvable);
    resetSparseDiskgroupEnabled(): void;
    get sparseDiskgroupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sshPublicKeys?;
    get sshPublicKeys(): string[];
    set sshPublicKeys(value: string[]);
    get sshPublicKeysInput(): string[] | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    get virtualNetworkIdInput(): string | undefined;
    private _zoneId?;
    get zoneId(): string;
    set zoneId(value: string);
    resetZoneId(): void;
    get zoneIdInput(): string | undefined;
    private _dataCollectionOptions;
    get dataCollectionOptions(): OracleCloudVmClusterDataCollectionOptionsOutputReference;
    putDataCollectionOptions(value: OracleCloudVmClusterDataCollectionOptions): void;
    resetDataCollectionOptions(): void;
    get dataCollectionOptionsInput(): OracleCloudVmClusterDataCollectionOptions | undefined;
    private _timeouts;
    get timeouts(): OracleCloudVmClusterTimeoutsOutputReference;
    putTimeouts(value: OracleCloudVmClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | OracleCloudVmClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
