/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivateEndpointApplicationSecurityGroupAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/private_endpoint_application_security_group_association#application_security_group_id PrivateEndpointApplicationSecurityGroupAssociation#application_security_group_id}
    */
    readonly applicationSecurityGroupId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/private_endpoint_application_security_group_association#id PrivateEndpointApplicationSecurityGroupAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/private_endpoint_application_security_group_association#private_endpoint_id PrivateEndpointApplicationSecurityGroupAssociation#private_endpoint_id}
    */
    readonly privateEndpointId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/private_endpoint_application_security_group_association#timeouts PrivateEndpointApplicationSecurityGroupAssociation#timeouts}
    */
    readonly timeouts?: PrivateEndpointApplicationSecurityGroupAssociationTimeouts;
}
export interface PrivateEndpointApplicationSecurityGroupAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/private_endpoint_application_security_group_association#create PrivateEndpointApplicationSecurityGroupAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/private_endpoint_application_security_group_association#delete PrivateEndpointApplicationSecurityGroupAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/private_endpoint_application_security_group_association#read PrivateEndpointApplicationSecurityGroupAssociation#read}
    */
    readonly read?: string;
}
export declare function privateEndpointApplicationSecurityGroupAssociationTimeoutsToTerraform(struct?: PrivateEndpointApplicationSecurityGroupAssociationTimeouts | cdktf.IResolvable): any;
export declare function privateEndpointApplicationSecurityGroupAssociationTimeoutsToHclTerraform(struct?: PrivateEndpointApplicationSecurityGroupAssociationTimeouts | cdktf.IResolvable): any;
export declare class PrivateEndpointApplicationSecurityGroupAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivateEndpointApplicationSecurityGroupAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PrivateEndpointApplicationSecurityGroupAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/private_endpoint_application_security_group_association azurerm_private_endpoint_application_security_group_association}
*/
export declare class PrivateEndpointApplicationSecurityGroupAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_private_endpoint_application_security_group_association";
    /**
    * Generates CDKTF code for importing a PrivateEndpointApplicationSecurityGroupAssociation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PrivateEndpointApplicationSecurityGroupAssociation to import
    * @param importFromId The id of the existing PrivateEndpointApplicationSecurityGroupAssociation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/private_endpoint_application_security_group_association#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PrivateEndpointApplicationSecurityGroupAssociation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/private_endpoint_application_security_group_association azurerm_private_endpoint_application_security_group_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivateEndpointApplicationSecurityGroupAssociationConfig
    */
    constructor(scope: Construct, id: string, config: PrivateEndpointApplicationSecurityGroupAssociationConfig);
    private _applicationSecurityGroupId?;
    get applicationSecurityGroupId(): string;
    set applicationSecurityGroupId(value: string);
    get applicationSecurityGroupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _privateEndpointId?;
    get privateEndpointId(): string;
    set privateEndpointId(value: string);
    get privateEndpointIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): PrivateEndpointApplicationSecurityGroupAssociationTimeoutsOutputReference;
    putTimeouts(value: PrivateEndpointApplicationSecurityGroupAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PrivateEndpointApplicationSecurityGroupAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
