/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RedhatOpenshiftClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#id RedhatOpenshiftCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#location RedhatOpenshiftCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#name RedhatOpenshiftCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#resource_group_name RedhatOpenshiftCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#tags RedhatOpenshiftCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * api_server_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#api_server_profile RedhatOpenshiftCluster#api_server_profile}
    */
    readonly apiServerProfile: RedhatOpenshiftClusterApiServerProfile;
    /**
    * cluster_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#cluster_profile RedhatOpenshiftCluster#cluster_profile}
    */
    readonly clusterProfile: RedhatOpenshiftClusterClusterProfile;
    /**
    * ingress_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#ingress_profile RedhatOpenshiftCluster#ingress_profile}
    */
    readonly ingressProfile: RedhatOpenshiftClusterIngressProfile;
    /**
    * main_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#main_profile RedhatOpenshiftCluster#main_profile}
    */
    readonly mainProfile: RedhatOpenshiftClusterMainProfile;
    /**
    * network_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#network_profile RedhatOpenshiftCluster#network_profile}
    */
    readonly networkProfile: RedhatOpenshiftClusterNetworkProfile;
    /**
    * service_principal block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#service_principal RedhatOpenshiftCluster#service_principal}
    */
    readonly servicePrincipal: RedhatOpenshiftClusterServicePrincipal;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#timeouts RedhatOpenshiftCluster#timeouts}
    */
    readonly timeouts?: RedhatOpenshiftClusterTimeouts;
    /**
    * worker_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#worker_profile RedhatOpenshiftCluster#worker_profile}
    */
    readonly workerProfile: RedhatOpenshiftClusterWorkerProfile;
}
export interface RedhatOpenshiftClusterApiServerProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#visibility RedhatOpenshiftCluster#visibility}
    */
    readonly visibility: string;
}
export declare function redhatOpenshiftClusterApiServerProfileToTerraform(struct?: RedhatOpenshiftClusterApiServerProfileOutputReference | RedhatOpenshiftClusterApiServerProfile): any;
export declare function redhatOpenshiftClusterApiServerProfileToHclTerraform(struct?: RedhatOpenshiftClusterApiServerProfileOutputReference | RedhatOpenshiftClusterApiServerProfile): any;
export declare class RedhatOpenshiftClusterApiServerProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedhatOpenshiftClusterApiServerProfile | undefined;
    set internalValue(value: RedhatOpenshiftClusterApiServerProfile | undefined);
    get ipAddress(): string;
    get url(): string;
    private _visibility?;
    get visibility(): string;
    set visibility(value: string);
    get visibilityInput(): string | undefined;
}
export interface RedhatOpenshiftClusterClusterProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#domain RedhatOpenshiftCluster#domain}
    */
    readonly domain: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#fips_enabled RedhatOpenshiftCluster#fips_enabled}
    */
    readonly fipsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#managed_resource_group_name RedhatOpenshiftCluster#managed_resource_group_name}
    */
    readonly managedResourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#pull_secret RedhatOpenshiftCluster#pull_secret}
    */
    readonly pullSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#version RedhatOpenshiftCluster#version}
    */
    readonly version: string;
}
export declare function redhatOpenshiftClusterClusterProfileToTerraform(struct?: RedhatOpenshiftClusterClusterProfileOutputReference | RedhatOpenshiftClusterClusterProfile): any;
export declare function redhatOpenshiftClusterClusterProfileToHclTerraform(struct?: RedhatOpenshiftClusterClusterProfileOutputReference | RedhatOpenshiftClusterClusterProfile): any;
export declare class RedhatOpenshiftClusterClusterProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedhatOpenshiftClusterClusterProfile | undefined;
    set internalValue(value: RedhatOpenshiftClusterClusterProfile | undefined);
    private _domain?;
    get domain(): string;
    set domain(value: string);
    get domainInput(): string | undefined;
    private _fipsEnabled?;
    get fipsEnabled(): boolean | cdktf.IResolvable;
    set fipsEnabled(value: boolean | cdktf.IResolvable);
    resetFipsEnabled(): void;
    get fipsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _managedResourceGroupName?;
    get managedResourceGroupName(): string;
    set managedResourceGroupName(value: string);
    resetManagedResourceGroupName(): void;
    get managedResourceGroupNameInput(): string | undefined;
    private _pullSecret?;
    get pullSecret(): string;
    set pullSecret(value: string);
    resetPullSecret(): void;
    get pullSecretInput(): string | undefined;
    get resourceGroupId(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
}
export interface RedhatOpenshiftClusterIngressProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#visibility RedhatOpenshiftCluster#visibility}
    */
    readonly visibility: string;
}
export declare function redhatOpenshiftClusterIngressProfileToTerraform(struct?: RedhatOpenshiftClusterIngressProfileOutputReference | RedhatOpenshiftClusterIngressProfile): any;
export declare function redhatOpenshiftClusterIngressProfileToHclTerraform(struct?: RedhatOpenshiftClusterIngressProfileOutputReference | RedhatOpenshiftClusterIngressProfile): any;
export declare class RedhatOpenshiftClusterIngressProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedhatOpenshiftClusterIngressProfile | undefined;
    set internalValue(value: RedhatOpenshiftClusterIngressProfile | undefined);
    get ipAddress(): string;
    get name(): string;
    private _visibility?;
    get visibility(): string;
    set visibility(value: string);
    get visibilityInput(): string | undefined;
}
export interface RedhatOpenshiftClusterMainProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#disk_encryption_set_id RedhatOpenshiftCluster#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#encryption_at_host_enabled RedhatOpenshiftCluster#encryption_at_host_enabled}
    */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#subnet_id RedhatOpenshiftCluster#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#vm_size RedhatOpenshiftCluster#vm_size}
    */
    readonly vmSize: string;
}
export declare function redhatOpenshiftClusterMainProfileToTerraform(struct?: RedhatOpenshiftClusterMainProfileOutputReference | RedhatOpenshiftClusterMainProfile): any;
export declare function redhatOpenshiftClusterMainProfileToHclTerraform(struct?: RedhatOpenshiftClusterMainProfileOutputReference | RedhatOpenshiftClusterMainProfile): any;
export declare class RedhatOpenshiftClusterMainProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedhatOpenshiftClusterMainProfile | undefined;
    set internalValue(value: RedhatOpenshiftClusterMainProfile | undefined);
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _encryptionAtHostEnabled?;
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionAtHostEnabled(): void;
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
}
export interface RedhatOpenshiftClusterNetworkProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#outbound_type RedhatOpenshiftCluster#outbound_type}
    */
    readonly outboundType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#pod_cidr RedhatOpenshiftCluster#pod_cidr}
    */
    readonly podCidr: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#preconfigured_network_security_group_enabled RedhatOpenshiftCluster#preconfigured_network_security_group_enabled}
    */
    readonly preconfiguredNetworkSecurityGroupEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#service_cidr RedhatOpenshiftCluster#service_cidr}
    */
    readonly serviceCidr: string;
}
export declare function redhatOpenshiftClusterNetworkProfileToTerraform(struct?: RedhatOpenshiftClusterNetworkProfileOutputReference | RedhatOpenshiftClusterNetworkProfile): any;
export declare function redhatOpenshiftClusterNetworkProfileToHclTerraform(struct?: RedhatOpenshiftClusterNetworkProfileOutputReference | RedhatOpenshiftClusterNetworkProfile): any;
export declare class RedhatOpenshiftClusterNetworkProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedhatOpenshiftClusterNetworkProfile | undefined;
    set internalValue(value: RedhatOpenshiftClusterNetworkProfile | undefined);
    private _outboundType?;
    get outboundType(): string;
    set outboundType(value: string);
    resetOutboundType(): void;
    get outboundTypeInput(): string | undefined;
    private _podCidr?;
    get podCidr(): string;
    set podCidr(value: string);
    get podCidrInput(): string | undefined;
    private _preconfiguredNetworkSecurityGroupEnabled?;
    get preconfiguredNetworkSecurityGroupEnabled(): boolean | cdktf.IResolvable;
    set preconfiguredNetworkSecurityGroupEnabled(value: boolean | cdktf.IResolvable);
    resetPreconfiguredNetworkSecurityGroupEnabled(): void;
    get preconfiguredNetworkSecurityGroupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceCidr?;
    get serviceCidr(): string;
    set serviceCidr(value: string);
    get serviceCidrInput(): string | undefined;
}
export interface RedhatOpenshiftClusterServicePrincipal {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#client_id RedhatOpenshiftCluster#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#client_secret RedhatOpenshiftCluster#client_secret}
    */
    readonly clientSecret: string;
}
export declare function redhatOpenshiftClusterServicePrincipalToTerraform(struct?: RedhatOpenshiftClusterServicePrincipalOutputReference | RedhatOpenshiftClusterServicePrincipal): any;
export declare function redhatOpenshiftClusterServicePrincipalToHclTerraform(struct?: RedhatOpenshiftClusterServicePrincipalOutputReference | RedhatOpenshiftClusterServicePrincipal): any;
export declare class RedhatOpenshiftClusterServicePrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedhatOpenshiftClusterServicePrincipal | undefined;
    set internalValue(value: RedhatOpenshiftClusterServicePrincipal | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
}
export interface RedhatOpenshiftClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#create RedhatOpenshiftCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#delete RedhatOpenshiftCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#read RedhatOpenshiftCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#update RedhatOpenshiftCluster#update}
    */
    readonly update?: string;
}
export declare function redhatOpenshiftClusterTimeoutsToTerraform(struct?: RedhatOpenshiftClusterTimeouts | cdktf.IResolvable): any;
export declare function redhatOpenshiftClusterTimeoutsToHclTerraform(struct?: RedhatOpenshiftClusterTimeouts | cdktf.IResolvable): any;
export declare class RedhatOpenshiftClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedhatOpenshiftClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: RedhatOpenshiftClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface RedhatOpenshiftClusterWorkerProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#disk_encryption_set_id RedhatOpenshiftCluster#disk_encryption_set_id}
    */
    readonly diskEncryptionSetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#disk_size_gb RedhatOpenshiftCluster#disk_size_gb}
    */
    readonly diskSizeGb: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#encryption_at_host_enabled RedhatOpenshiftCluster#encryption_at_host_enabled}
    */
    readonly encryptionAtHostEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#node_count RedhatOpenshiftCluster#node_count}
    */
    readonly nodeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#subnet_id RedhatOpenshiftCluster#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#vm_size RedhatOpenshiftCluster#vm_size}
    */
    readonly vmSize: string;
}
export declare function redhatOpenshiftClusterWorkerProfileToTerraform(struct?: RedhatOpenshiftClusterWorkerProfileOutputReference | RedhatOpenshiftClusterWorkerProfile): any;
export declare function redhatOpenshiftClusterWorkerProfileToHclTerraform(struct?: RedhatOpenshiftClusterWorkerProfileOutputReference | RedhatOpenshiftClusterWorkerProfile): any;
export declare class RedhatOpenshiftClusterWorkerProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RedhatOpenshiftClusterWorkerProfile | undefined;
    set internalValue(value: RedhatOpenshiftClusterWorkerProfile | undefined);
    private _diskEncryptionSetId?;
    get diskEncryptionSetId(): string;
    set diskEncryptionSetId(value: string);
    resetDiskEncryptionSetId(): void;
    get diskEncryptionSetIdInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    get diskSizeGbInput(): number | undefined;
    private _encryptionAtHostEnabled?;
    get encryptionAtHostEnabled(): boolean | cdktf.IResolvable;
    set encryptionAtHostEnabled(value: boolean | cdktf.IResolvable);
    resetEncryptionAtHostEnabled(): void;
    get encryptionAtHostEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    get nodeCountInput(): number | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _vmSize?;
    get vmSize(): string;
    set vmSize(value: string);
    get vmSizeInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster azurerm_redhat_openshift_cluster}
*/
export declare class RedhatOpenshiftCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_redhat_openshift_cluster";
    /**
    * Generates CDKTF code for importing a RedhatOpenshiftCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RedhatOpenshiftCluster to import
    * @param importFromId The id of the existing RedhatOpenshiftCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RedhatOpenshiftCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/redhat_openshift_cluster azurerm_redhat_openshift_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RedhatOpenshiftClusterConfig
    */
    constructor(scope: Construct, id: string, config: RedhatOpenshiftClusterConfig);
    get consoleUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _apiServerProfile;
    get apiServerProfile(): RedhatOpenshiftClusterApiServerProfileOutputReference;
    putApiServerProfile(value: RedhatOpenshiftClusterApiServerProfile): void;
    get apiServerProfileInput(): RedhatOpenshiftClusterApiServerProfile | undefined;
    private _clusterProfile;
    get clusterProfile(): RedhatOpenshiftClusterClusterProfileOutputReference;
    putClusterProfile(value: RedhatOpenshiftClusterClusterProfile): void;
    get clusterProfileInput(): RedhatOpenshiftClusterClusterProfile | undefined;
    private _ingressProfile;
    get ingressProfile(): RedhatOpenshiftClusterIngressProfileOutputReference;
    putIngressProfile(value: RedhatOpenshiftClusterIngressProfile): void;
    get ingressProfileInput(): RedhatOpenshiftClusterIngressProfile | undefined;
    private _mainProfile;
    get mainProfile(): RedhatOpenshiftClusterMainProfileOutputReference;
    putMainProfile(value: RedhatOpenshiftClusterMainProfile): void;
    get mainProfileInput(): RedhatOpenshiftClusterMainProfile | undefined;
    private _networkProfile;
    get networkProfile(): RedhatOpenshiftClusterNetworkProfileOutputReference;
    putNetworkProfile(value: RedhatOpenshiftClusterNetworkProfile): void;
    get networkProfileInput(): RedhatOpenshiftClusterNetworkProfile | undefined;
    private _servicePrincipal;
    get servicePrincipal(): RedhatOpenshiftClusterServicePrincipalOutputReference;
    putServicePrincipal(value: RedhatOpenshiftClusterServicePrincipal): void;
    get servicePrincipalInput(): RedhatOpenshiftClusterServicePrincipal | undefined;
    private _timeouts;
    get timeouts(): RedhatOpenshiftClusterTimeoutsOutputReference;
    putTimeouts(value: RedhatOpenshiftClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | RedhatOpenshiftClusterTimeouts | undefined;
    private _workerProfile;
    get workerProfile(): RedhatOpenshiftClusterWorkerProfileOutputReference;
    putWorkerProfile(value: RedhatOpenshiftClusterWorkerProfile): void;
    get workerProfileInput(): RedhatOpenshiftClusterWorkerProfile | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
