/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudDevToolPortalConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#application_accelerator_enabled SpringCloudDevToolPortal#application_accelerator_enabled}
    */
    readonly applicationAcceleratorEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#application_live_view_enabled SpringCloudDevToolPortal#application_live_view_enabled}
    */
    readonly applicationLiveViewEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#id SpringCloudDevToolPortal#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#name SpringCloudDevToolPortal#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#public_network_access_enabled SpringCloudDevToolPortal#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#spring_cloud_service_id SpringCloudDevToolPortal#spring_cloud_service_id}
    */
    readonly springCloudServiceId: string;
    /**
    * sso block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#sso SpringCloudDevToolPortal#sso}
    */
    readonly sso?: SpringCloudDevToolPortalSso;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#timeouts SpringCloudDevToolPortal#timeouts}
    */
    readonly timeouts?: SpringCloudDevToolPortalTimeouts;
}
export interface SpringCloudDevToolPortalSso {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#client_id SpringCloudDevToolPortal#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#client_secret SpringCloudDevToolPortal#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#metadata_url SpringCloudDevToolPortal#metadata_url}
    */
    readonly metadataUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#scope SpringCloudDevToolPortal#scope}
    */
    readonly scope?: string[];
}
export declare function springCloudDevToolPortalSsoToTerraform(struct?: SpringCloudDevToolPortalSsoOutputReference | SpringCloudDevToolPortalSso): any;
export declare function springCloudDevToolPortalSsoToHclTerraform(struct?: SpringCloudDevToolPortalSsoOutputReference | SpringCloudDevToolPortalSso): any;
export declare class SpringCloudDevToolPortalSsoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudDevToolPortalSso | undefined;
    set internalValue(value: SpringCloudDevToolPortalSso | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _metadataUrl?;
    get metadataUrl(): string;
    set metadataUrl(value: string);
    resetMetadataUrl(): void;
    get metadataUrlInput(): string | undefined;
    private _scope?;
    get scope(): string[];
    set scope(value: string[]);
    resetScope(): void;
    get scopeInput(): string[] | undefined;
}
export interface SpringCloudDevToolPortalTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#create SpringCloudDevToolPortal#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#delete SpringCloudDevToolPortal#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#read SpringCloudDevToolPortal#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#update SpringCloudDevToolPortal#update}
    */
    readonly update?: string;
}
export declare function springCloudDevToolPortalTimeoutsToTerraform(struct?: SpringCloudDevToolPortalTimeouts | cdktf.IResolvable): any;
export declare function springCloudDevToolPortalTimeoutsToHclTerraform(struct?: SpringCloudDevToolPortalTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudDevToolPortalTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudDevToolPortalTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudDevToolPortalTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal azurerm_spring_cloud_dev_tool_portal}
*/
export declare class SpringCloudDevToolPortal extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_dev_tool_portal";
    /**
    * Generates CDKTF code for importing a SpringCloudDevToolPortal resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SpringCloudDevToolPortal to import
    * @param importFromId The id of the existing SpringCloudDevToolPortal that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SpringCloudDevToolPortal to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/spring_cloud_dev_tool_portal azurerm_spring_cloud_dev_tool_portal} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudDevToolPortalConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudDevToolPortalConfig);
    private _applicationAcceleratorEnabled?;
    get applicationAcceleratorEnabled(): boolean | cdktf.IResolvable;
    set applicationAcceleratorEnabled(value: boolean | cdktf.IResolvable);
    resetApplicationAcceleratorEnabled(): void;
    get applicationAcceleratorEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _applicationLiveViewEnabled?;
    get applicationLiveViewEnabled(): boolean | cdktf.IResolvable;
    set applicationLiveViewEnabled(value: boolean | cdktf.IResolvable);
    resetApplicationLiveViewEnabled(): void;
    get applicationLiveViewEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _springCloudServiceId?;
    get springCloudServiceId(): string;
    set springCloudServiceId(value: string);
    get springCloudServiceIdInput(): string | undefined;
    private _sso;
    get sso(): SpringCloudDevToolPortalSsoOutputReference;
    putSso(value: SpringCloudDevToolPortalSso): void;
    resetSso(): void;
    get ssoInput(): SpringCloudDevToolPortalSso | undefined;
    private _timeouts;
    get timeouts(): SpringCloudDevToolPortalTimeoutsOutputReference;
    putTimeouts(value: SpringCloudDevToolPortalTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudDevToolPortalTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
