/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualDesktopScalingPlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#description VirtualDesktopScalingPlan#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#exclusion_tag VirtualDesktopScalingPlan#exclusion_tag}
    */
    readonly exclusionTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#friendly_name VirtualDesktopScalingPlan#friendly_name}
    */
    readonly friendlyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#id VirtualDesktopScalingPlan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#location VirtualDesktopScalingPlan#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#name VirtualDesktopScalingPlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#resource_group_name VirtualDesktopScalingPlan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#tags VirtualDesktopScalingPlan#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#time_zone VirtualDesktopScalingPlan#time_zone}
    */
    readonly timeZone: string;
    /**
    * host_pool block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#host_pool VirtualDesktopScalingPlan#host_pool}
    */
    readonly hostPool?: VirtualDesktopScalingPlanHostPool[] | cdktf.IResolvable;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#schedule VirtualDesktopScalingPlan#schedule}
    */
    readonly schedule: VirtualDesktopScalingPlanSchedule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#timeouts VirtualDesktopScalingPlan#timeouts}
    */
    readonly timeouts?: VirtualDesktopScalingPlanTimeouts;
}
export interface VirtualDesktopScalingPlanHostPool {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#hostpool_id VirtualDesktopScalingPlan#hostpool_id}
    */
    readonly hostpoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#scaling_plan_enabled VirtualDesktopScalingPlan#scaling_plan_enabled}
    */
    readonly scalingPlanEnabled: boolean | cdktf.IResolvable;
}
export declare function virtualDesktopScalingPlanHostPoolToTerraform(struct?: VirtualDesktopScalingPlanHostPool | cdktf.IResolvable): any;
export declare function virtualDesktopScalingPlanHostPoolToHclTerraform(struct?: VirtualDesktopScalingPlanHostPool | cdktf.IResolvable): any;
export declare class VirtualDesktopScalingPlanHostPoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualDesktopScalingPlanHostPool | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualDesktopScalingPlanHostPool | cdktf.IResolvable | undefined);
    private _hostpoolId?;
    get hostpoolId(): string;
    set hostpoolId(value: string);
    get hostpoolIdInput(): string | undefined;
    private _scalingPlanEnabled?;
    get scalingPlanEnabled(): boolean | cdktf.IResolvable;
    set scalingPlanEnabled(value: boolean | cdktf.IResolvable);
    get scalingPlanEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class VirtualDesktopScalingPlanHostPoolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualDesktopScalingPlanHostPool[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualDesktopScalingPlanHostPoolOutputReference;
}
export interface VirtualDesktopScalingPlanSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#days_of_week VirtualDesktopScalingPlan#days_of_week}
    */
    readonly daysOfWeek: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#name VirtualDesktopScalingPlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#off_peak_load_balancing_algorithm VirtualDesktopScalingPlan#off_peak_load_balancing_algorithm}
    */
    readonly offPeakLoadBalancingAlgorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#off_peak_start_time VirtualDesktopScalingPlan#off_peak_start_time}
    */
    readonly offPeakStartTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#peak_load_balancing_algorithm VirtualDesktopScalingPlan#peak_load_balancing_algorithm}
    */
    readonly peakLoadBalancingAlgorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#peak_start_time VirtualDesktopScalingPlan#peak_start_time}
    */
    readonly peakStartTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_down_capacity_threshold_percent VirtualDesktopScalingPlan#ramp_down_capacity_threshold_percent}
    */
    readonly rampDownCapacityThresholdPercent: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_down_force_logoff_users VirtualDesktopScalingPlan#ramp_down_force_logoff_users}
    */
    readonly rampDownForceLogoffUsers: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_down_load_balancing_algorithm VirtualDesktopScalingPlan#ramp_down_load_balancing_algorithm}
    */
    readonly rampDownLoadBalancingAlgorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_down_minimum_hosts_percent VirtualDesktopScalingPlan#ramp_down_minimum_hosts_percent}
    */
    readonly rampDownMinimumHostsPercent: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_down_notification_message VirtualDesktopScalingPlan#ramp_down_notification_message}
    */
    readonly rampDownNotificationMessage: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_down_start_time VirtualDesktopScalingPlan#ramp_down_start_time}
    */
    readonly rampDownStartTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_down_stop_hosts_when VirtualDesktopScalingPlan#ramp_down_stop_hosts_when}
    */
    readonly rampDownStopHostsWhen: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_down_wait_time_minutes VirtualDesktopScalingPlan#ramp_down_wait_time_minutes}
    */
    readonly rampDownWaitTimeMinutes: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_up_capacity_threshold_percent VirtualDesktopScalingPlan#ramp_up_capacity_threshold_percent}
    */
    readonly rampUpCapacityThresholdPercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_up_load_balancing_algorithm VirtualDesktopScalingPlan#ramp_up_load_balancing_algorithm}
    */
    readonly rampUpLoadBalancingAlgorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_up_minimum_hosts_percent VirtualDesktopScalingPlan#ramp_up_minimum_hosts_percent}
    */
    readonly rampUpMinimumHostsPercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#ramp_up_start_time VirtualDesktopScalingPlan#ramp_up_start_time}
    */
    readonly rampUpStartTime: string;
}
export declare function virtualDesktopScalingPlanScheduleToTerraform(struct?: VirtualDesktopScalingPlanSchedule | cdktf.IResolvable): any;
export declare function virtualDesktopScalingPlanScheduleToHclTerraform(struct?: VirtualDesktopScalingPlanSchedule | cdktf.IResolvable): any;
export declare class VirtualDesktopScalingPlanScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualDesktopScalingPlanSchedule | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualDesktopScalingPlanSchedule | cdktf.IResolvable | undefined);
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    get daysOfWeekInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _offPeakLoadBalancingAlgorithm?;
    get offPeakLoadBalancingAlgorithm(): string;
    set offPeakLoadBalancingAlgorithm(value: string);
    get offPeakLoadBalancingAlgorithmInput(): string | undefined;
    private _offPeakStartTime?;
    get offPeakStartTime(): string;
    set offPeakStartTime(value: string);
    get offPeakStartTimeInput(): string | undefined;
    private _peakLoadBalancingAlgorithm?;
    get peakLoadBalancingAlgorithm(): string;
    set peakLoadBalancingAlgorithm(value: string);
    get peakLoadBalancingAlgorithmInput(): string | undefined;
    private _peakStartTime?;
    get peakStartTime(): string;
    set peakStartTime(value: string);
    get peakStartTimeInput(): string | undefined;
    private _rampDownCapacityThresholdPercent?;
    get rampDownCapacityThresholdPercent(): number;
    set rampDownCapacityThresholdPercent(value: number);
    get rampDownCapacityThresholdPercentInput(): number | undefined;
    private _rampDownForceLogoffUsers?;
    get rampDownForceLogoffUsers(): boolean | cdktf.IResolvable;
    set rampDownForceLogoffUsers(value: boolean | cdktf.IResolvable);
    get rampDownForceLogoffUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _rampDownLoadBalancingAlgorithm?;
    get rampDownLoadBalancingAlgorithm(): string;
    set rampDownLoadBalancingAlgorithm(value: string);
    get rampDownLoadBalancingAlgorithmInput(): string | undefined;
    private _rampDownMinimumHostsPercent?;
    get rampDownMinimumHostsPercent(): number;
    set rampDownMinimumHostsPercent(value: number);
    get rampDownMinimumHostsPercentInput(): number | undefined;
    private _rampDownNotificationMessage?;
    get rampDownNotificationMessage(): string;
    set rampDownNotificationMessage(value: string);
    get rampDownNotificationMessageInput(): string | undefined;
    private _rampDownStartTime?;
    get rampDownStartTime(): string;
    set rampDownStartTime(value: string);
    get rampDownStartTimeInput(): string | undefined;
    private _rampDownStopHostsWhen?;
    get rampDownStopHostsWhen(): string;
    set rampDownStopHostsWhen(value: string);
    get rampDownStopHostsWhenInput(): string | undefined;
    private _rampDownWaitTimeMinutes?;
    get rampDownWaitTimeMinutes(): number;
    set rampDownWaitTimeMinutes(value: number);
    get rampDownWaitTimeMinutesInput(): number | undefined;
    private _rampUpCapacityThresholdPercent?;
    get rampUpCapacityThresholdPercent(): number;
    set rampUpCapacityThresholdPercent(value: number);
    resetRampUpCapacityThresholdPercent(): void;
    get rampUpCapacityThresholdPercentInput(): number | undefined;
    private _rampUpLoadBalancingAlgorithm?;
    get rampUpLoadBalancingAlgorithm(): string;
    set rampUpLoadBalancingAlgorithm(value: string);
    get rampUpLoadBalancingAlgorithmInput(): string | undefined;
    private _rampUpMinimumHostsPercent?;
    get rampUpMinimumHostsPercent(): number;
    set rampUpMinimumHostsPercent(value: number);
    resetRampUpMinimumHostsPercent(): void;
    get rampUpMinimumHostsPercentInput(): number | undefined;
    private _rampUpStartTime?;
    get rampUpStartTime(): string;
    set rampUpStartTime(value: string);
    get rampUpStartTimeInput(): string | undefined;
}
export declare class VirtualDesktopScalingPlanScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualDesktopScalingPlanSchedule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualDesktopScalingPlanScheduleOutputReference;
}
export interface VirtualDesktopScalingPlanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#create VirtualDesktopScalingPlan#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#delete VirtualDesktopScalingPlan#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#read VirtualDesktopScalingPlan#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#update VirtualDesktopScalingPlan#update}
    */
    readonly update?: string;
}
export declare function virtualDesktopScalingPlanTimeoutsToTerraform(struct?: VirtualDesktopScalingPlanTimeouts | cdktf.IResolvable): any;
export declare function virtualDesktopScalingPlanTimeoutsToHclTerraform(struct?: VirtualDesktopScalingPlanTimeouts | cdktf.IResolvable): any;
export declare class VirtualDesktopScalingPlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualDesktopScalingPlanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualDesktopScalingPlanTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan azurerm_virtual_desktop_scaling_plan}
*/
export declare class VirtualDesktopScalingPlan extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_desktop_scaling_plan";
    /**
    * Generates CDKTF code for importing a VirtualDesktopScalingPlan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualDesktopScalingPlan to import
    * @param importFromId The id of the existing VirtualDesktopScalingPlan that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualDesktopScalingPlan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/virtual_desktop_scaling_plan azurerm_virtual_desktop_scaling_plan} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualDesktopScalingPlanConfig
    */
    constructor(scope: Construct, id: string, config: VirtualDesktopScalingPlanConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _exclusionTag?;
    get exclusionTag(): string;
    set exclusionTag(value: string);
    resetExclusionTag(): void;
    get exclusionTagInput(): string | undefined;
    private _friendlyName?;
    get friendlyName(): string;
    set friendlyName(value: string);
    resetFriendlyName(): void;
    get friendlyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
    private _hostPool;
    get hostPool(): VirtualDesktopScalingPlanHostPoolList;
    putHostPool(value: VirtualDesktopScalingPlanHostPool[] | cdktf.IResolvable): void;
    resetHostPool(): void;
    get hostPoolInput(): cdktf.IResolvable | VirtualDesktopScalingPlanHostPool[] | undefined;
    private _schedule;
    get schedule(): VirtualDesktopScalingPlanScheduleList;
    putSchedule(value: VirtualDesktopScalingPlanSchedule[] | cdktf.IResolvable): void;
    get scheduleInput(): cdktf.IResolvable | VirtualDesktopScalingPlanSchedule[] | undefined;
    private _timeouts;
    get timeouts(): VirtualDesktopScalingPlanTimeoutsOutputReference;
    putTimeouts(value: VirtualDesktopScalingPlanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualDesktopScalingPlanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
