/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VmwareNetappVolumeAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/vmware_netapp_volume_attachment#id VmwareNetappVolumeAttachment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/vmware_netapp_volume_attachment#name VmwareNetappVolumeAttachment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/vmware_netapp_volume_attachment#netapp_volume_id VmwareNetappVolumeAttachment#netapp_volume_id}
    */
    readonly netappVolumeId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/vmware_netapp_volume_attachment#vmware_cluster_id VmwareNetappVolumeAttachment#vmware_cluster_id}
    */
    readonly vmwareClusterId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/vmware_netapp_volume_attachment#timeouts VmwareNetappVolumeAttachment#timeouts}
    */
    readonly timeouts?: VmwareNetappVolumeAttachmentTimeouts;
}
export interface VmwareNetappVolumeAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/vmware_netapp_volume_attachment#create VmwareNetappVolumeAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/vmware_netapp_volume_attachment#delete VmwareNetappVolumeAttachment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/vmware_netapp_volume_attachment#read VmwareNetappVolumeAttachment#read}
    */
    readonly read?: string;
}
export declare function vmwareNetappVolumeAttachmentTimeoutsToTerraform(struct?: VmwareNetappVolumeAttachmentTimeouts | cdktf.IResolvable): any;
export declare function vmwareNetappVolumeAttachmentTimeoutsToHclTerraform(struct?: VmwareNetappVolumeAttachmentTimeouts | cdktf.IResolvable): any;
export declare class VmwareNetappVolumeAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VmwareNetappVolumeAttachmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VmwareNetappVolumeAttachmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/vmware_netapp_volume_attachment azurerm_vmware_netapp_volume_attachment}
*/
export declare class VmwareNetappVolumeAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_vmware_netapp_volume_attachment";
    /**
    * Generates CDKTF code for importing a VmwareNetappVolumeAttachment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VmwareNetappVolumeAttachment to import
    * @param importFromId The id of the existing VmwareNetappVolumeAttachment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/vmware_netapp_volume_attachment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VmwareNetappVolumeAttachment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/vmware_netapp_volume_attachment azurerm_vmware_netapp_volume_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VmwareNetappVolumeAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: VmwareNetappVolumeAttachmentConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _netappVolumeId?;
    get netappVolumeId(): string;
    set netappVolumeId(value: string);
    get netappVolumeIdInput(): string | undefined;
    private _vmwareClusterId?;
    get vmwareClusterId(): string;
    set vmwareClusterId(value: string);
    get vmwareClusterIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): VmwareNetappVolumeAttachmentTimeoutsOutputReference;
    putTimeouts(value: VmwareNetappVolumeAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VmwareNetappVolumeAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
