/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WindowsWebAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#app_settings WindowsWebApp#app_settings}
    */
    readonly appSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_affinity_enabled WindowsWebApp#client_affinity_enabled}
    */
    readonly clientAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_certificate_enabled WindowsWebApp#client_certificate_enabled}
    */
    readonly clientCertificateEnabled?: boolean | cdktf.IResolvable;
    /**
    * Paths to exclude when using client certificates, separated by ;
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_certificate_exclusion_paths WindowsWebApp#client_certificate_exclusion_paths}
    */
    readonly clientCertificateExclusionPaths?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_certificate_mode WindowsWebApp#client_certificate_mode}
    */
    readonly clientCertificateMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#enabled WindowsWebApp#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#ftp_publish_basic_authentication_enabled WindowsWebApp#ftp_publish_basic_authentication_enabled}
    */
    readonly ftpPublishBasicAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#https_only WindowsWebApp#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#id WindowsWebApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#key_vault_reference_identity_id WindowsWebApp#key_vault_reference_identity_id}
    */
    readonly keyVaultReferenceIdentityId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#location WindowsWebApp#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#name WindowsWebApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#public_network_access_enabled WindowsWebApp#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#resource_group_name WindowsWebApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#service_plan_id WindowsWebApp#service_plan_id}
    */
    readonly servicePlanId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#tags WindowsWebApp#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#virtual_network_subnet_id WindowsWebApp#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#webdeploy_publish_basic_authentication_enabled WindowsWebApp#webdeploy_publish_basic_authentication_enabled}
    */
    readonly webdeployPublishBasicAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * The local path and filename of the Zip packaged application to deploy to this Windows Web App. **Note:** Using this value requires either `WEBSITE_RUN_FROM_PACKAGE=1` or `SCM_DO_BUILD_DURING_DEPLOYMENT=true` to be set on the App in `app_settings`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#zip_deploy_file WindowsWebApp#zip_deploy_file}
    */
    readonly zipDeployFile?: string;
    /**
    * auth_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#auth_settings WindowsWebApp#auth_settings}
    */
    readonly authSettings?: WindowsWebAppAuthSettings;
    /**
    * auth_settings_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#auth_settings_v2 WindowsWebApp#auth_settings_v2}
    */
    readonly authSettingsV2?: WindowsWebAppAuthSettingsV2;
    /**
    * backup block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#backup WindowsWebApp#backup}
    */
    readonly backup?: WindowsWebAppBackup;
    /**
    * connection_string block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#connection_string WindowsWebApp#connection_string}
    */
    readonly connectionString?: WindowsWebAppConnectionString[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#identity WindowsWebApp#identity}
    */
    readonly identity?: WindowsWebAppIdentity;
    /**
    * logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#logs WindowsWebApp#logs}
    */
    readonly logs?: WindowsWebAppLogs;
    /**
    * site_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#site_config WindowsWebApp#site_config}
    */
    readonly siteConfig: WindowsWebAppSiteConfig;
    /**
    * sticky_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#sticky_settings WindowsWebApp#sticky_settings}
    */
    readonly stickySettings?: WindowsWebAppStickySettings;
    /**
    * storage_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#storage_account WindowsWebApp#storage_account}
    */
    readonly storageAccount?: WindowsWebAppStorageAccount[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#timeouts WindowsWebApp#timeouts}
    */
    readonly timeouts?: WindowsWebAppTimeouts;
}
export interface WindowsWebAppSiteCredential {
}
export declare function windowsWebAppSiteCredentialToTerraform(struct?: WindowsWebAppSiteCredential): any;
export declare function windowsWebAppSiteCredentialToHclTerraform(struct?: WindowsWebAppSiteCredential): any;
export declare class WindowsWebAppSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSiteCredential | undefined;
    set internalValue(value: WindowsWebAppSiteCredential | undefined);
    get name(): string;
    get password(): string;
}
export declare class WindowsWebAppSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSiteCredentialOutputReference;
}
export interface WindowsWebAppAuthSettingsActiveDirectory {
    /**
    * Specifies a list of Allowed audience values to consider when validating JWTs issued by Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#allowed_audiences WindowsWebApp#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The ID of the Client to use to authenticate with Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_id WindowsWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret for the Client ID. Cannot be used with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret WindowsWebApp#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The App Setting name that contains the client secret of the Client. Cannot be used with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret_setting_name WindowsWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
}
export declare function windowsWebAppAuthSettingsActiveDirectoryToTerraform(struct?: WindowsWebAppAuthSettingsActiveDirectoryOutputReference | WindowsWebAppAuthSettingsActiveDirectory): any;
export declare function windowsWebAppAuthSettingsActiveDirectoryToHclTerraform(struct?: WindowsWebAppAuthSettingsActiveDirectoryOutputReference | WindowsWebAppAuthSettingsActiveDirectory): any;
export declare class WindowsWebAppAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsActiveDirectory | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
}
export interface WindowsWebAppAuthSettingsFacebook {
    /**
    * The App ID of the Facebook app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#app_id WindowsWebApp#app_id}
    */
    readonly appId: string;
    /**
    * The App Secret of the Facebook app used for Facebook Login. Cannot be specified with `app_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#app_secret WindowsWebApp#app_secret}
    */
    readonly appSecret?: string;
    /**
    * The app setting name that contains the `app_secret` value used for Facebook Login. Cannot be specified with `app_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#app_secret_setting_name WindowsWebApp#app_secret_setting_name}
    */
    readonly appSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes to be requested as part of Facebook Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#oauth_scopes WindowsWebApp#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsWebAppAuthSettingsFacebookToTerraform(struct?: WindowsWebAppAuthSettingsFacebookOutputReference | WindowsWebAppAuthSettingsFacebook): any;
export declare function windowsWebAppAuthSettingsFacebookToHclTerraform(struct?: WindowsWebAppAuthSettingsFacebookOutputReference | WindowsWebAppAuthSettingsFacebook): any;
export declare class WindowsWebAppAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsFacebook | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsFacebook | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecret?;
    get appSecret(): string;
    set appSecret(value: string);
    resetAppSecret(): void;
    get appSecretInput(): string | undefined;
    private _appSecretSettingName?;
    get appSecretSettingName(): string;
    set appSecretSettingName(value: string);
    resetAppSecretSettingName(): void;
    get appSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsWebAppAuthSettingsGithub {
    /**
    * The ID of the GitHub app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_id WindowsWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The Client Secret of the GitHub app used for GitHub Login. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret WindowsWebApp#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for GitHub Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret_setting_name WindowsWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#oauth_scopes WindowsWebApp#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsWebAppAuthSettingsGithubToTerraform(struct?: WindowsWebAppAuthSettingsGithubOutputReference | WindowsWebAppAuthSettingsGithub): any;
export declare function windowsWebAppAuthSettingsGithubToHclTerraform(struct?: WindowsWebAppAuthSettingsGithubOutputReference | WindowsWebAppAuthSettingsGithub): any;
export declare class WindowsWebAppAuthSettingsGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsGithub | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsGithub | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsWebAppAuthSettingsGoogle {
    /**
    * The OpenID Connect Client ID for the Google web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_id WindowsWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The client secret associated with the Google web application.  Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret WindowsWebApp#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name that contains the `client_secret` value used for Google Login. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret_setting_name WindowsWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication. If not specified, "openid", "profile", and "email" are used as default scopes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#oauth_scopes WindowsWebApp#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsWebAppAuthSettingsGoogleToTerraform(struct?: WindowsWebAppAuthSettingsGoogleOutputReference | WindowsWebAppAuthSettingsGoogle): any;
export declare function windowsWebAppAuthSettingsGoogleToHclTerraform(struct?: WindowsWebAppAuthSettingsGoogleOutputReference | WindowsWebAppAuthSettingsGoogle): any;
export declare class WindowsWebAppAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsGoogle | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsGoogle | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsWebAppAuthSettingsMicrosoft {
    /**
    * The OAuth 2.0 client ID that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_id WindowsWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret WindowsWebApp#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication. Cannot be specified with `client_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret_setting_name WindowsWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * The list of OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication. If not specified, `wl.basic` is used as the default scope.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#oauth_scopes WindowsWebApp#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function windowsWebAppAuthSettingsMicrosoftToTerraform(struct?: WindowsWebAppAuthSettingsMicrosoftOutputReference | WindowsWebAppAuthSettingsMicrosoft): any;
export declare function windowsWebAppAuthSettingsMicrosoftToHclTerraform(struct?: WindowsWebAppAuthSettingsMicrosoftOutputReference | WindowsWebAppAuthSettingsMicrosoft): any;
export declare class WindowsWebAppAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsMicrosoft | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsMicrosoft | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface WindowsWebAppAuthSettingsTwitter {
    /**
    * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#consumer_key WindowsWebApp#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * The OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret_setting_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#consumer_secret WindowsWebApp#consumer_secret}
    */
    readonly consumerSecret?: string;
    /**
    * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in. Cannot be specified with `consumer_secret`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#consumer_secret_setting_name WindowsWebApp#consumer_secret_setting_name}
    */
    readonly consumerSecretSettingName?: string;
}
export declare function windowsWebAppAuthSettingsTwitterToTerraform(struct?: WindowsWebAppAuthSettingsTwitterOutputReference | WindowsWebAppAuthSettingsTwitter): any;
export declare function windowsWebAppAuthSettingsTwitterToHclTerraform(struct?: WindowsWebAppAuthSettingsTwitterOutputReference | WindowsWebAppAuthSettingsTwitter): any;
export declare class WindowsWebAppAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsTwitter | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsTwitter | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    get consumerSecret(): string;
    set consumerSecret(value: string);
    resetConsumerSecret(): void;
    get consumerSecretInput(): string | undefined;
    private _consumerSecretSettingName?;
    get consumerSecretSettingName(): string;
    set consumerSecretSettingName(value: string);
    resetConsumerSecretSettingName(): void;
    get consumerSecretSettingNameInput(): string | undefined;
}
export interface WindowsWebAppAuthSettings {
    /**
    * Specifies a map of Login Parameters to send to the OpenID Connect authorization endpoint when a user logs in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#additional_login_parameters WindowsWebApp#additional_login_parameters}
    */
    readonly additionalLoginParameters?: {
        [key: string]: string;
    };
    /**
    * Specifies a list of External URLs that can be redirected to as part of logging in or logging out of the Windows Web App.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#allowed_external_redirect_urls WindowsWebApp#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * The default authentication provider to use when multiple providers are configured. Possible values include: `AzureActiveDirectory`, `Facebook`, `Google`, `MicrosoftAccount`, `Twitter`, `Github`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#default_provider WindowsWebApp#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * Should the Authentication / Authorization feature be enabled?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#enabled WindowsWebApp#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * The OpenID Connect Issuer URI that represents the entity which issues access tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#issuer WindowsWebApp#issuer}
    */
    readonly issuer?: string;
    /**
    * The RuntimeVersion of the Authentication / Authorization feature in use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#runtime_version WindowsWebApp#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The number of hours after session token expiration that a session token can be used to call the token refresh API. Defaults to `72` hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#token_refresh_extension_hours WindowsWebApp#token_refresh_extension_hours}
    */
    readonly tokenRefreshExtensionHours?: number;
    /**
    * Should the Windows Web App durably store platform-specific security tokens that are obtained during login flows? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#token_store_enabled WindowsWebApp#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * The action to take when an unauthenticated client attempts to access the app. Possible values include: `RedirectToLoginPage`, `AllowAnonymous`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#unauthenticated_client_action WindowsWebApp#unauthenticated_client_action}
    */
    readonly unauthenticatedClientAction?: string;
    /**
    * active_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#active_directory WindowsWebApp#active_directory}
    */
    readonly activeDirectory?: WindowsWebAppAuthSettingsActiveDirectory;
    /**
    * facebook block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#facebook WindowsWebApp#facebook}
    */
    readonly facebook?: WindowsWebAppAuthSettingsFacebook;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#github WindowsWebApp#github}
    */
    readonly github?: WindowsWebAppAuthSettingsGithub;
    /**
    * google block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#google WindowsWebApp#google}
    */
    readonly google?: WindowsWebAppAuthSettingsGoogle;
    /**
    * microsoft block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#microsoft WindowsWebApp#microsoft}
    */
    readonly microsoft?: WindowsWebAppAuthSettingsMicrosoft;
    /**
    * twitter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#twitter WindowsWebApp#twitter}
    */
    readonly twitter?: WindowsWebAppAuthSettingsTwitter;
}
export declare function windowsWebAppAuthSettingsToTerraform(struct?: WindowsWebAppAuthSettingsOutputReference | WindowsWebAppAuthSettings): any;
export declare function windowsWebAppAuthSettingsToHclTerraform(struct?: WindowsWebAppAuthSettingsOutputReference | WindowsWebAppAuthSettings): any;
export declare class WindowsWebAppAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettings | undefined;
    set internalValue(value: WindowsWebAppAuthSettings | undefined);
    private _additionalLoginParameters?;
    get additionalLoginParameters(): {
        [key: string]: string;
    };
    set additionalLoginParameters(value: {
        [key: string]: string;
    });
    resetAdditionalLoginParameters(): void;
    get additionalLoginParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    get tokenRefreshExtensionHours(): number;
    set tokenRefreshExtensionHours(value: number);
    resetTokenRefreshExtensionHours(): void;
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    get unauthenticatedClientAction(): string;
    set unauthenticatedClientAction(value: string);
    resetUnauthenticatedClientAction(): void;
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    get activeDirectory(): WindowsWebAppAuthSettingsActiveDirectoryOutputReference;
    putActiveDirectory(value: WindowsWebAppAuthSettingsActiveDirectory): void;
    resetActiveDirectory(): void;
    get activeDirectoryInput(): WindowsWebAppAuthSettingsActiveDirectory | undefined;
    private _facebook;
    get facebook(): WindowsWebAppAuthSettingsFacebookOutputReference;
    putFacebook(value: WindowsWebAppAuthSettingsFacebook): void;
    resetFacebook(): void;
    get facebookInput(): WindowsWebAppAuthSettingsFacebook | undefined;
    private _github;
    get github(): WindowsWebAppAuthSettingsGithubOutputReference;
    putGithub(value: WindowsWebAppAuthSettingsGithub): void;
    resetGithub(): void;
    get githubInput(): WindowsWebAppAuthSettingsGithub | undefined;
    private _google;
    get google(): WindowsWebAppAuthSettingsGoogleOutputReference;
    putGoogle(value: WindowsWebAppAuthSettingsGoogle): void;
    resetGoogle(): void;
    get googleInput(): WindowsWebAppAuthSettingsGoogle | undefined;
    private _microsoft;
    get microsoft(): WindowsWebAppAuthSettingsMicrosoftOutputReference;
    putMicrosoft(value: WindowsWebAppAuthSettingsMicrosoft): void;
    resetMicrosoft(): void;
    get microsoftInput(): WindowsWebAppAuthSettingsMicrosoft | undefined;
    private _twitter;
    get twitter(): WindowsWebAppAuthSettingsTwitterOutputReference;
    putTwitter(value: WindowsWebAppAuthSettingsTwitter): void;
    resetTwitter(): void;
    get twitterInput(): WindowsWebAppAuthSettingsTwitter | undefined;
}
export interface WindowsWebAppAuthSettingsV2ActiveDirectoryV2 {
    /**
    * The list of allowed Applications for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#allowed_applications WindowsWebApp#allowed_applications}
    */
    readonly allowedApplications?: string[];
    /**
    * Specifies a list of Allowed audience values to consider when validating JWTs issued by Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#allowed_audiences WindowsWebApp#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The list of allowed Group Names for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#allowed_groups WindowsWebApp#allowed_groups}
    */
    readonly allowedGroups?: string[];
    /**
    * The list of allowed Identities for the Default Authorisation Policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#allowed_identities WindowsWebApp#allowed_identities}
    */
    readonly allowedIdentities?: string[];
    /**
    * The ID of the Client to use to authenticate with Azure Active Directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_id WindowsWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The thumbprint of the certificate used for signing purposes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret_certificate_thumbprint WindowsWebApp#client_secret_certificate_thumbprint}
    */
    readonly clientSecretCertificateThumbprint?: string;
    /**
    * The App Setting name that contains the client secret of the Client.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret_setting_name WindowsWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName?: string;
    /**
    * A list of Allowed Client Applications in the JWT Claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#jwt_allowed_client_applications WindowsWebApp#jwt_allowed_client_applications}
    */
    readonly jwtAllowedClientApplications?: string[];
    /**
    * A list of Allowed Groups in the JWT Claim.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#jwt_allowed_groups WindowsWebApp#jwt_allowed_groups}
    */
    readonly jwtAllowedGroups?: string[];
    /**
    * A map of key-value pairs to send to the Authorisation Endpoint when a user logs in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#login_parameters WindowsWebApp#login_parameters}
    */
    readonly loginParameters?: {
        [key: string]: string;
    };
    /**
    * The Azure Tenant Endpoint for the Authenticating Tenant. e.g. `https://login.microsoftonline.com/v2.0/{tenant-guid}/`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#tenant_auth_endpoint WindowsWebApp#tenant_auth_endpoint}
    */
    readonly tenantAuthEndpoint: string;
    /**
    * Should the www-authenticate provider should be omitted from the request? Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#www_authentication_disabled WindowsWebApp#www_authentication_disabled}
    */
    readonly wwwAuthenticationDisabled?: boolean | cdktf.IResolvable;
}
export declare function windowsWebAppAuthSettingsV2ActiveDirectoryV2ToTerraform(struct?: WindowsWebAppAuthSettingsV2ActiveDirectoryV2OutputReference | WindowsWebAppAuthSettingsV2ActiveDirectoryV2): any;
export declare function windowsWebAppAuthSettingsV2ActiveDirectoryV2ToHclTerraform(struct?: WindowsWebAppAuthSettingsV2ActiveDirectoryV2OutputReference | WindowsWebAppAuthSettingsV2ActiveDirectoryV2): any;
export declare class WindowsWebAppAuthSettingsV2ActiveDirectoryV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsV2ActiveDirectoryV2 | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsV2ActiveDirectoryV2 | undefined);
    private _allowedApplications?;
    get allowedApplications(): string[];
    set allowedApplications(value: string[]);
    resetAllowedApplications(): void;
    get allowedApplicationsInput(): string[] | undefined;
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _allowedGroups?;
    get allowedGroups(): string[];
    set allowedGroups(value: string[]);
    resetAllowedGroups(): void;
    get allowedGroupsInput(): string[] | undefined;
    private _allowedIdentities?;
    get allowedIdentities(): string[];
    set allowedIdentities(value: string[]);
    resetAllowedIdentities(): void;
    get allowedIdentitiesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretCertificateThumbprint?;
    get clientSecretCertificateThumbprint(): string;
    set clientSecretCertificateThumbprint(value: string);
    resetClientSecretCertificateThumbprint(): void;
    get clientSecretCertificateThumbprintInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    resetClientSecretSettingName(): void;
    get clientSecretSettingNameInput(): string | undefined;
    private _jwtAllowedClientApplications?;
    get jwtAllowedClientApplications(): string[];
    set jwtAllowedClientApplications(value: string[]);
    resetJwtAllowedClientApplications(): void;
    get jwtAllowedClientApplicationsInput(): string[] | undefined;
    private _jwtAllowedGroups?;
    get jwtAllowedGroups(): string[];
    set jwtAllowedGroups(value: string[]);
    resetJwtAllowedGroups(): void;
    get jwtAllowedGroupsInput(): string[] | undefined;
    private _loginParameters?;
    get loginParameters(): {
        [key: string]: string;
    };
    set loginParameters(value: {
        [key: string]: string;
    });
    resetLoginParameters(): void;
    get loginParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _tenantAuthEndpoint?;
    get tenantAuthEndpoint(): string;
    set tenantAuthEndpoint(value: string);
    get tenantAuthEndpointInput(): string | undefined;
    private _wwwAuthenticationDisabled?;
    get wwwAuthenticationDisabled(): boolean | cdktf.IResolvable;
    set wwwAuthenticationDisabled(value: boolean | cdktf.IResolvable);
    resetWwwAuthenticationDisabled(): void;
    get wwwAuthenticationDisabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsWebAppAuthSettingsV2AppleV2 {
    /**
    * The OpenID Connect Client ID for the Apple web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_id WindowsWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for Apple Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret_setting_name WindowsWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
}
export declare function windowsWebAppAuthSettingsV2AppleV2ToTerraform(struct?: WindowsWebAppAuthSettingsV2AppleV2OutputReference | WindowsWebAppAuthSettingsV2AppleV2): any;
export declare function windowsWebAppAuthSettingsV2AppleV2ToHclTerraform(struct?: WindowsWebAppAuthSettingsV2AppleV2OutputReference | WindowsWebAppAuthSettingsV2AppleV2): any;
export declare class WindowsWebAppAuthSettingsV2AppleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsV2AppleV2 | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsV2AppleV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    get loginScopes(): string[];
}
export interface WindowsWebAppAuthSettingsV2AzureStaticWebAppV2 {
    /**
    * The ID of the Client to use to authenticate with Azure Static Web App Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_id WindowsWebApp#client_id}
    */
    readonly clientId: string;
}
export declare function windowsWebAppAuthSettingsV2AzureStaticWebAppV2ToTerraform(struct?: WindowsWebAppAuthSettingsV2AzureStaticWebAppV2OutputReference | WindowsWebAppAuthSettingsV2AzureStaticWebAppV2): any;
export declare function windowsWebAppAuthSettingsV2AzureStaticWebAppV2ToHclTerraform(struct?: WindowsWebAppAuthSettingsV2AzureStaticWebAppV2OutputReference | WindowsWebAppAuthSettingsV2AzureStaticWebAppV2): any;
export declare class WindowsWebAppAuthSettingsV2AzureStaticWebAppV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsV2AzureStaticWebAppV2 | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsV2AzureStaticWebAppV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
}
export interface WindowsWebAppAuthSettingsV2CustomOidcV2 {
    /**
    * The ID of the Client to use to authenticate with this Custom OIDC.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_id WindowsWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The name of the Custom OIDC Authentication Provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#name WindowsWebApp#name}
    */
    readonly name: string;
    /**
    * The name of the claim that contains the users name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#name_claim_type WindowsWebApp#name_claim_type}
    */
    readonly nameClaimType?: string;
    /**
    * The endpoint that contains all the configuration endpoints for this Custom OIDC provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#openid_configuration_endpoint WindowsWebApp#openid_configuration_endpoint}
    */
    readonly openidConfigurationEndpoint: string;
    /**
    * The list of the scopes that should be requested while authenticating.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#scopes WindowsWebApp#scopes}
    */
    readonly scopes?: string[];
}
export declare function windowsWebAppAuthSettingsV2CustomOidcV2ToTerraform(struct?: WindowsWebAppAuthSettingsV2CustomOidcV2 | cdktf.IResolvable): any;
export declare function windowsWebAppAuthSettingsV2CustomOidcV2ToHclTerraform(struct?: WindowsWebAppAuthSettingsV2CustomOidcV2 | cdktf.IResolvable): any;
export declare class WindowsWebAppAuthSettingsV2CustomOidcV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppAuthSettingsV2CustomOidcV2 | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsV2CustomOidcV2 | cdktf.IResolvable | undefined);
    get authorisationEndpoint(): string;
    get certificationUri(): string;
    get clientCredentialMethod(): string;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    get clientSecretSettingName(): string;
    get issuerEndpoint(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nameClaimType?;
    get nameClaimType(): string;
    set nameClaimType(value: string);
    resetNameClaimType(): void;
    get nameClaimTypeInput(): string | undefined;
    private _openidConfigurationEndpoint?;
    get openidConfigurationEndpoint(): string;
    set openidConfigurationEndpoint(value: string);
    get openidConfigurationEndpointInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    get tokenEndpoint(): string;
}
export declare class WindowsWebAppAuthSettingsV2CustomOidcV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppAuthSettingsV2CustomOidcV2OutputReference;
}
export interface WindowsWebAppAuthSettingsV2FacebookV2 {
    /**
    * The App ID of the Facebook app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#app_id WindowsWebApp#app_id}
    */
    readonly appId: string;
    /**
    * The app setting name that contains the `app_secret` value used for Facebook Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#app_secret_setting_name WindowsWebApp#app_secret_setting_name}
    */
    readonly appSecretSettingName: string;
    /**
    * The version of the Facebook API to be used while logging in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#graph_api_version WindowsWebApp#graph_api_version}
    */
    readonly graphApiVersion?: string;
    /**
    * Specifies a list of scopes to be requested as part of Facebook Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#login_scopes WindowsWebApp#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsWebAppAuthSettingsV2FacebookV2ToTerraform(struct?: WindowsWebAppAuthSettingsV2FacebookV2OutputReference | WindowsWebAppAuthSettingsV2FacebookV2): any;
export declare function windowsWebAppAuthSettingsV2FacebookV2ToHclTerraform(struct?: WindowsWebAppAuthSettingsV2FacebookV2OutputReference | WindowsWebAppAuthSettingsV2FacebookV2): any;
export declare class WindowsWebAppAuthSettingsV2FacebookV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsV2FacebookV2 | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsV2FacebookV2 | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecretSettingName?;
    get appSecretSettingName(): string;
    set appSecretSettingName(value: string);
    get appSecretSettingNameInput(): string | undefined;
    private _graphApiVersion?;
    get graphApiVersion(): string;
    set graphApiVersion(value: string);
    resetGraphApiVersion(): void;
    get graphApiVersionInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsWebAppAuthSettingsV2GithubV2 {
    /**
    * The ID of the GitHub app used for login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_id WindowsWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for GitHub Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret_setting_name WindowsWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * Specifies a list of OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#login_scopes WindowsWebApp#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsWebAppAuthSettingsV2GithubV2ToTerraform(struct?: WindowsWebAppAuthSettingsV2GithubV2OutputReference | WindowsWebAppAuthSettingsV2GithubV2): any;
export declare function windowsWebAppAuthSettingsV2GithubV2ToHclTerraform(struct?: WindowsWebAppAuthSettingsV2GithubV2OutputReference | WindowsWebAppAuthSettingsV2GithubV2): any;
export declare class WindowsWebAppAuthSettingsV2GithubV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsV2GithubV2 | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsV2GithubV2 | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsWebAppAuthSettingsV2GoogleV2 {
    /**
    * Specifies a list of Allowed Audiences that will be requested as part of Google Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#allowed_audiences WindowsWebApp#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The OpenID Connect Client ID for the Google web application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_id WindowsWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name that contains the `client_secret` value used for Google Login.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret_setting_name WindowsWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * Specifies a list of Login scopes that will be requested as part of Google Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#login_scopes WindowsWebApp#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsWebAppAuthSettingsV2GoogleV2ToTerraform(struct?: WindowsWebAppAuthSettingsV2GoogleV2OutputReference | WindowsWebAppAuthSettingsV2GoogleV2): any;
export declare function windowsWebAppAuthSettingsV2GoogleV2ToHclTerraform(struct?: WindowsWebAppAuthSettingsV2GoogleV2OutputReference | WindowsWebAppAuthSettingsV2GoogleV2): any;
export declare class WindowsWebAppAuthSettingsV2GoogleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsV2GoogleV2 | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsV2GoogleV2 | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsWebAppAuthSettingsV2Login {
    /**
    * External URLs that can be redirected to as part of logging in or logging out of the app. This is an advanced setting typically only needed by Windows Store application backends. **Note:** URLs within the current domain are always implicitly allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#allowed_external_redirect_urls WindowsWebApp#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * The method by which cookies expire. Possible values include: `FixedTime`, and `IdentityProviderDerived`. Defaults to `FixedTime`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#cookie_expiration_convention WindowsWebApp#cookie_expiration_convention}
    */
    readonly cookieExpirationConvention?: string;
    /**
    * The time after the request is made when the session cookie should expire. Defaults to `08:00:00`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#cookie_expiration_time WindowsWebApp#cookie_expiration_time}
    */
    readonly cookieExpirationTime?: string;
    /**
    * The endpoint to which logout requests should be made.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#logout_endpoint WindowsWebApp#logout_endpoint}
    */
    readonly logoutEndpoint?: string;
    /**
    * The time after the request is made when the nonce should expire. Defaults to `00:05:00`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#nonce_expiration_time WindowsWebApp#nonce_expiration_time}
    */
    readonly nonceExpirationTime?: string;
    /**
    * Should the fragments from the request be preserved after the login request is made. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#preserve_url_fragments_for_logins WindowsWebApp#preserve_url_fragments_for_logins}
    */
    readonly preserveUrlFragmentsForLogins?: boolean | cdktf.IResolvable;
    /**
    * The number of hours after session token expiration that a session token can be used to call the token refresh API. Defaults to `72` hours.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#token_refresh_extension_time WindowsWebApp#token_refresh_extension_time}
    */
    readonly tokenRefreshExtensionTime?: number;
    /**
    * Should the Token Store configuration Enabled. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#token_store_enabled WindowsWebApp#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * The directory path in the App Filesystem in which the tokens will be stored.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#token_store_path WindowsWebApp#token_store_path}
    */
    readonly tokenStorePath?: string;
    /**
    * The name of the app setting which contains the SAS URL of the blob storage containing the tokens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#token_store_sas_setting_name WindowsWebApp#token_store_sas_setting_name}
    */
    readonly tokenStoreSasSettingName?: string;
    /**
    * Should the nonce be validated while completing the login flow. Defaults to `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#validate_nonce WindowsWebApp#validate_nonce}
    */
    readonly validateNonce?: boolean | cdktf.IResolvable;
}
export declare function windowsWebAppAuthSettingsV2LoginToTerraform(struct?: WindowsWebAppAuthSettingsV2LoginOutputReference | WindowsWebAppAuthSettingsV2Login): any;
export declare function windowsWebAppAuthSettingsV2LoginToHclTerraform(struct?: WindowsWebAppAuthSettingsV2LoginOutputReference | WindowsWebAppAuthSettingsV2Login): any;
export declare class WindowsWebAppAuthSettingsV2LoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsV2Login | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsV2Login | undefined);
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _cookieExpirationConvention?;
    get cookieExpirationConvention(): string;
    set cookieExpirationConvention(value: string);
    resetCookieExpirationConvention(): void;
    get cookieExpirationConventionInput(): string | undefined;
    private _cookieExpirationTime?;
    get cookieExpirationTime(): string;
    set cookieExpirationTime(value: string);
    resetCookieExpirationTime(): void;
    get cookieExpirationTimeInput(): string | undefined;
    private _logoutEndpoint?;
    get logoutEndpoint(): string;
    set logoutEndpoint(value: string);
    resetLogoutEndpoint(): void;
    get logoutEndpointInput(): string | undefined;
    private _nonceExpirationTime?;
    get nonceExpirationTime(): string;
    set nonceExpirationTime(value: string);
    resetNonceExpirationTime(): void;
    get nonceExpirationTimeInput(): string | undefined;
    private _preserveUrlFragmentsForLogins?;
    get preserveUrlFragmentsForLogins(): boolean | cdktf.IResolvable;
    set preserveUrlFragmentsForLogins(value: boolean | cdktf.IResolvable);
    resetPreserveUrlFragmentsForLogins(): void;
    get preserveUrlFragmentsForLoginsInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenRefreshExtensionTime?;
    get tokenRefreshExtensionTime(): number;
    set tokenRefreshExtensionTime(value: number);
    resetTokenRefreshExtensionTime(): void;
    get tokenRefreshExtensionTimeInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tokenStorePath?;
    get tokenStorePath(): string;
    set tokenStorePath(value: string);
    resetTokenStorePath(): void;
    get tokenStorePathInput(): string | undefined;
    private _tokenStoreSasSettingName?;
    get tokenStoreSasSettingName(): string;
    set tokenStoreSasSettingName(value: string);
    resetTokenStoreSasSettingName(): void;
    get tokenStoreSasSettingNameInput(): string | undefined;
    private _validateNonce?;
    get validateNonce(): boolean | cdktf.IResolvable;
    set validateNonce(value: boolean | cdktf.IResolvable);
    resetValidateNonce(): void;
    get validateNonceInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsWebAppAuthSettingsV2MicrosoftV2 {
    /**
    * Specifies a list of Allowed Audiences that will be requested as part of Microsoft Sign-In authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#allowed_audiences WindowsWebApp#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The OAuth 2.0 client ID that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_id WindowsWebApp#client_id}
    */
    readonly clientId: string;
    /**
    * The app setting name containing the OAuth 2.0 client secret that was created for the app used for authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#client_secret_setting_name WindowsWebApp#client_secret_setting_name}
    */
    readonly clientSecretSettingName: string;
    /**
    * The list of Login scopes that will be requested as part of Microsoft Account authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#login_scopes WindowsWebApp#login_scopes}
    */
    readonly loginScopes?: string[];
}
export declare function windowsWebAppAuthSettingsV2MicrosoftV2ToTerraform(struct?: WindowsWebAppAuthSettingsV2MicrosoftV2OutputReference | WindowsWebAppAuthSettingsV2MicrosoftV2): any;
export declare function windowsWebAppAuthSettingsV2MicrosoftV2ToHclTerraform(struct?: WindowsWebAppAuthSettingsV2MicrosoftV2OutputReference | WindowsWebAppAuthSettingsV2MicrosoftV2): any;
export declare class WindowsWebAppAuthSettingsV2MicrosoftV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsV2MicrosoftV2 | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsV2MicrosoftV2 | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecretSettingName?;
    get clientSecretSettingName(): string;
    set clientSecretSettingName(value: string);
    get clientSecretSettingNameInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
}
export interface WindowsWebAppAuthSettingsV2TwitterV2 {
    /**
    * The OAuth 1.0a consumer key of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#consumer_key WindowsWebApp#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * The app setting name that contains the OAuth 1.0a consumer secret of the Twitter application used for sign-in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#consumer_secret_setting_name WindowsWebApp#consumer_secret_setting_name}
    */
    readonly consumerSecretSettingName: string;
}
export declare function windowsWebAppAuthSettingsV2TwitterV2ToTerraform(struct?: WindowsWebAppAuthSettingsV2TwitterV2OutputReference | WindowsWebAppAuthSettingsV2TwitterV2): any;
export declare function windowsWebAppAuthSettingsV2TwitterV2ToHclTerraform(struct?: WindowsWebAppAuthSettingsV2TwitterV2OutputReference | WindowsWebAppAuthSettingsV2TwitterV2): any;
export declare class WindowsWebAppAuthSettingsV2TwitterV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsV2TwitterV2 | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsV2TwitterV2 | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecretSettingName?;
    get consumerSecretSettingName(): string;
    set consumerSecretSettingName(value: string);
    get consumerSecretSettingNameInput(): string | undefined;
}
export interface WindowsWebAppAuthSettingsV2 {
    /**
    * Should the AuthV2 Settings be enabled. Defaults to `false`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#auth_enabled WindowsWebApp#auth_enabled}
    */
    readonly authEnabled?: boolean | cdktf.IResolvable;
    /**
    * The path to the App Auth settings. **Note:** Relative Paths are evaluated from the Site Root directory.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#config_file_path WindowsWebApp#config_file_path}
    */
    readonly configFilePath?: string;
    /**
    * The Default Authentication Provider to use when the `unauthenticated_action` is set to `RedirectToLoginPage`. Possible values include: `apple`, `azureactivedirectory`, `facebook`, `github`, `google`, `twitter` and the `name` of your `custom_oidc_v2` provider.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#default_provider WindowsWebApp#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * The paths which should be excluded from the `unauthenticated_action` when it is set to `RedirectToLoginPage`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#excluded_paths WindowsWebApp#excluded_paths}
    */
    readonly excludedPaths?: string[];
    /**
    * The convention used to determine the url of the request made. Possible values include `ForwardProxyConventionNoProxy`, `ForwardProxyConventionStandard`, `ForwardProxyConventionCustom`. Defaults to `ForwardProxyConventionNoProxy`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#forward_proxy_convention WindowsWebApp#forward_proxy_convention}
    */
    readonly forwardProxyConvention?: string;
    /**
    * The name of the header containing the host of the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#forward_proxy_custom_host_header_name WindowsWebApp#forward_proxy_custom_host_header_name}
    */
    readonly forwardProxyCustomHostHeaderName?: string;
    /**
    * The name of the header containing the scheme of the request.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#forward_proxy_custom_scheme_header_name WindowsWebApp#forward_proxy_custom_scheme_header_name}
    */
    readonly forwardProxyCustomSchemeHeaderName?: string;
    /**
    * The prefix that should precede all the authentication and authorisation paths. Defaults to `/.auth`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#http_route_api_prefix WindowsWebApp#http_route_api_prefix}
    */
    readonly httpRouteApiPrefix?: string;
    /**
    * Should the authentication flow be used for all requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#require_authentication WindowsWebApp#require_authentication}
    */
    readonly requireAuthentication?: boolean | cdktf.IResolvable;
    /**
    * Should HTTPS be required on connections? Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#require_https WindowsWebApp#require_https}
    */
    readonly requireHttps?: boolean | cdktf.IResolvable;
    /**
    * The Runtime Version of the Authentication and Authorisation feature of this App. Defaults to `~1`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#runtime_version WindowsWebApp#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The action to take for requests made without authentication. Possible values include `RedirectToLoginPage`, `AllowAnonymous`, `Return401`, and `Return403`. Defaults to `RedirectToLoginPage`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#unauthenticated_action WindowsWebApp#unauthenticated_action}
    */
    readonly unauthenticatedAction?: string;
    /**
    * active_directory_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#active_directory_v2 WindowsWebApp#active_directory_v2}
    */
    readonly activeDirectoryV2?: WindowsWebAppAuthSettingsV2ActiveDirectoryV2;
    /**
    * apple_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#apple_v2 WindowsWebApp#apple_v2}
    */
    readonly appleV2?: WindowsWebAppAuthSettingsV2AppleV2;
    /**
    * azure_static_web_app_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#azure_static_web_app_v2 WindowsWebApp#azure_static_web_app_v2}
    */
    readonly azureStaticWebAppV2?: WindowsWebAppAuthSettingsV2AzureStaticWebAppV2;
    /**
    * custom_oidc_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#custom_oidc_v2 WindowsWebApp#custom_oidc_v2}
    */
    readonly customOidcV2?: WindowsWebAppAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable;
    /**
    * facebook_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#facebook_v2 WindowsWebApp#facebook_v2}
    */
    readonly facebookV2?: WindowsWebAppAuthSettingsV2FacebookV2;
    /**
    * github_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#github_v2 WindowsWebApp#github_v2}
    */
    readonly githubV2?: WindowsWebAppAuthSettingsV2GithubV2;
    /**
    * google_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#google_v2 WindowsWebApp#google_v2}
    */
    readonly googleV2?: WindowsWebAppAuthSettingsV2GoogleV2;
    /**
    * login block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#login WindowsWebApp#login}
    */
    readonly login: WindowsWebAppAuthSettingsV2Login;
    /**
    * microsoft_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#microsoft_v2 WindowsWebApp#microsoft_v2}
    */
    readonly microsoftV2?: WindowsWebAppAuthSettingsV2MicrosoftV2;
    /**
    * twitter_v2 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#twitter_v2 WindowsWebApp#twitter_v2}
    */
    readonly twitterV2?: WindowsWebAppAuthSettingsV2TwitterV2;
}
export declare function windowsWebAppAuthSettingsV2ToTerraform(struct?: WindowsWebAppAuthSettingsV2OutputReference | WindowsWebAppAuthSettingsV2): any;
export declare function windowsWebAppAuthSettingsV2ToHclTerraform(struct?: WindowsWebAppAuthSettingsV2OutputReference | WindowsWebAppAuthSettingsV2): any;
export declare class WindowsWebAppAuthSettingsV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppAuthSettingsV2 | undefined;
    set internalValue(value: WindowsWebAppAuthSettingsV2 | undefined);
    private _authEnabled?;
    get authEnabled(): boolean | cdktf.IResolvable;
    set authEnabled(value: boolean | cdktf.IResolvable);
    resetAuthEnabled(): void;
    get authEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _configFilePath?;
    get configFilePath(): string;
    set configFilePath(value: string);
    resetConfigFilePath(): void;
    get configFilePathInput(): string | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _excludedPaths?;
    get excludedPaths(): string[];
    set excludedPaths(value: string[]);
    resetExcludedPaths(): void;
    get excludedPathsInput(): string[] | undefined;
    private _forwardProxyConvention?;
    get forwardProxyConvention(): string;
    set forwardProxyConvention(value: string);
    resetForwardProxyConvention(): void;
    get forwardProxyConventionInput(): string | undefined;
    private _forwardProxyCustomHostHeaderName?;
    get forwardProxyCustomHostHeaderName(): string;
    set forwardProxyCustomHostHeaderName(value: string);
    resetForwardProxyCustomHostHeaderName(): void;
    get forwardProxyCustomHostHeaderNameInput(): string | undefined;
    private _forwardProxyCustomSchemeHeaderName?;
    get forwardProxyCustomSchemeHeaderName(): string;
    set forwardProxyCustomSchemeHeaderName(value: string);
    resetForwardProxyCustomSchemeHeaderName(): void;
    get forwardProxyCustomSchemeHeaderNameInput(): string | undefined;
    private _httpRouteApiPrefix?;
    get httpRouteApiPrefix(): string;
    set httpRouteApiPrefix(value: string);
    resetHttpRouteApiPrefix(): void;
    get httpRouteApiPrefixInput(): string | undefined;
    private _requireAuthentication?;
    get requireAuthentication(): boolean | cdktf.IResolvable;
    set requireAuthentication(value: boolean | cdktf.IResolvable);
    resetRequireAuthentication(): void;
    get requireAuthenticationInput(): boolean | cdktf.IResolvable | undefined;
    private _requireHttps?;
    get requireHttps(): boolean | cdktf.IResolvable;
    set requireHttps(value: boolean | cdktf.IResolvable);
    resetRequireHttps(): void;
    get requireHttpsInput(): boolean | cdktf.IResolvable | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _unauthenticatedAction?;
    get unauthenticatedAction(): string;
    set unauthenticatedAction(value: string);
    resetUnauthenticatedAction(): void;
    get unauthenticatedActionInput(): string | undefined;
    private _activeDirectoryV2;
    get activeDirectoryV2(): WindowsWebAppAuthSettingsV2ActiveDirectoryV2OutputReference;
    putActiveDirectoryV2(value: WindowsWebAppAuthSettingsV2ActiveDirectoryV2): void;
    resetActiveDirectoryV2(): void;
    get activeDirectoryV2Input(): WindowsWebAppAuthSettingsV2ActiveDirectoryV2 | undefined;
    private _appleV2;
    get appleV2(): WindowsWebAppAuthSettingsV2AppleV2OutputReference;
    putAppleV2(value: WindowsWebAppAuthSettingsV2AppleV2): void;
    resetAppleV2(): void;
    get appleV2Input(): WindowsWebAppAuthSettingsV2AppleV2 | undefined;
    private _azureStaticWebAppV2;
    get azureStaticWebAppV2(): WindowsWebAppAuthSettingsV2AzureStaticWebAppV2OutputReference;
    putAzureStaticWebAppV2(value: WindowsWebAppAuthSettingsV2AzureStaticWebAppV2): void;
    resetAzureStaticWebAppV2(): void;
    get azureStaticWebAppV2Input(): WindowsWebAppAuthSettingsV2AzureStaticWebAppV2 | undefined;
    private _customOidcV2;
    get customOidcV2(): WindowsWebAppAuthSettingsV2CustomOidcV2List;
    putCustomOidcV2(value: WindowsWebAppAuthSettingsV2CustomOidcV2[] | cdktf.IResolvable): void;
    resetCustomOidcV2(): void;
    get customOidcV2Input(): cdktf.IResolvable | WindowsWebAppAuthSettingsV2CustomOidcV2[] | undefined;
    private _facebookV2;
    get facebookV2(): WindowsWebAppAuthSettingsV2FacebookV2OutputReference;
    putFacebookV2(value: WindowsWebAppAuthSettingsV2FacebookV2): void;
    resetFacebookV2(): void;
    get facebookV2Input(): WindowsWebAppAuthSettingsV2FacebookV2 | undefined;
    private _githubV2;
    get githubV2(): WindowsWebAppAuthSettingsV2GithubV2OutputReference;
    putGithubV2(value: WindowsWebAppAuthSettingsV2GithubV2): void;
    resetGithubV2(): void;
    get githubV2Input(): WindowsWebAppAuthSettingsV2GithubV2 | undefined;
    private _googleV2;
    get googleV2(): WindowsWebAppAuthSettingsV2GoogleV2OutputReference;
    putGoogleV2(value: WindowsWebAppAuthSettingsV2GoogleV2): void;
    resetGoogleV2(): void;
    get googleV2Input(): WindowsWebAppAuthSettingsV2GoogleV2 | undefined;
    private _login;
    get login(): WindowsWebAppAuthSettingsV2LoginOutputReference;
    putLogin(value: WindowsWebAppAuthSettingsV2Login): void;
    get loginInput(): WindowsWebAppAuthSettingsV2Login | undefined;
    private _microsoftV2;
    get microsoftV2(): WindowsWebAppAuthSettingsV2MicrosoftV2OutputReference;
    putMicrosoftV2(value: WindowsWebAppAuthSettingsV2MicrosoftV2): void;
    resetMicrosoftV2(): void;
    get microsoftV2Input(): WindowsWebAppAuthSettingsV2MicrosoftV2 | undefined;
    private _twitterV2;
    get twitterV2(): WindowsWebAppAuthSettingsV2TwitterV2OutputReference;
    putTwitterV2(value: WindowsWebAppAuthSettingsV2TwitterV2): void;
    resetTwitterV2(): void;
    get twitterV2Input(): WindowsWebAppAuthSettingsV2TwitterV2 | undefined;
}
export interface WindowsWebAppBackupSchedule {
    /**
    * How often the backup should be executed (e.g. for weekly backup, this should be set to `7` and `frequency_unit` should be set to `Day`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#frequency_interval WindowsWebApp#frequency_interval}
    */
    readonly frequencyInterval: number;
    /**
    * The unit of time for how often the backup should take place. Possible values include: `Day` and `Hour`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#frequency_unit WindowsWebApp#frequency_unit}
    */
    readonly frequencyUnit: string;
    /**
    * Should the service keep at least one backup, regardless of age of backup. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#keep_at_least_one_backup WindowsWebApp#keep_at_least_one_backup}
    */
    readonly keepAtLeastOneBackup?: boolean | cdktf.IResolvable;
    /**
    * After how many days backups should be deleted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#retention_period_days WindowsWebApp#retention_period_days}
    */
    readonly retentionPeriodDays?: number;
    /**
    * When the schedule should start working in RFC-3339 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#start_time WindowsWebApp#start_time}
    */
    readonly startTime?: string;
}
export declare function windowsWebAppBackupScheduleToTerraform(struct?: WindowsWebAppBackupScheduleOutputReference | WindowsWebAppBackupSchedule): any;
export declare function windowsWebAppBackupScheduleToHclTerraform(struct?: WindowsWebAppBackupScheduleOutputReference | WindowsWebAppBackupSchedule): any;
export declare class WindowsWebAppBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppBackupSchedule | undefined;
    set internalValue(value: WindowsWebAppBackupSchedule | undefined);
    private _frequencyInterval?;
    get frequencyInterval(): number;
    set frequencyInterval(value: number);
    get frequencyIntervalInput(): number | undefined;
    private _frequencyUnit?;
    get frequencyUnit(): string;
    set frequencyUnit(value: string);
    get frequencyUnitInput(): string | undefined;
    private _keepAtLeastOneBackup?;
    get keepAtLeastOneBackup(): boolean | cdktf.IResolvable;
    set keepAtLeastOneBackup(value: boolean | cdktf.IResolvable);
    resetKeepAtLeastOneBackup(): void;
    get keepAtLeastOneBackupInput(): boolean | cdktf.IResolvable | undefined;
    get lastExecutionTime(): string;
    private _retentionPeriodDays?;
    get retentionPeriodDays(): number;
    set retentionPeriodDays(value: number);
    resetRetentionPeriodDays(): void;
    get retentionPeriodDaysInput(): number | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
}
export interface WindowsWebAppBackup {
    /**
    * Should this backup job be enabled?
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#enabled WindowsWebApp#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The name which should be used for this Backup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#name WindowsWebApp#name}
    */
    readonly name: string;
    /**
    * The SAS URL to the container.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#storage_account_url WindowsWebApp#storage_account_url}
    */
    readonly storageAccountUrl: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#schedule WindowsWebApp#schedule}
    */
    readonly schedule: WindowsWebAppBackupSchedule;
}
export declare function windowsWebAppBackupToTerraform(struct?: WindowsWebAppBackupOutputReference | WindowsWebAppBackup): any;
export declare function windowsWebAppBackupToHclTerraform(struct?: WindowsWebAppBackupOutputReference | WindowsWebAppBackup): any;
export declare class WindowsWebAppBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppBackup | undefined;
    set internalValue(value: WindowsWebAppBackup | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountUrl?;
    get storageAccountUrl(): string;
    set storageAccountUrl(value: string);
    get storageAccountUrlInput(): string | undefined;
    private _schedule;
    get schedule(): WindowsWebAppBackupScheduleOutputReference;
    putSchedule(value: WindowsWebAppBackupSchedule): void;
    get scheduleInput(): WindowsWebAppBackupSchedule | undefined;
}
export interface WindowsWebAppConnectionString {
    /**
    * The name which should be used for this Connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#name WindowsWebApp#name}
    */
    readonly name: string;
    /**
    * Type of database. Possible values include: `MySQL`, `SQLServer`, `SQLAzure`, `Custom`, `NotificationHub`, `ServiceBus`, `EventHub`, `APIHub`, `DocDb`, `RedisCache`, and `PostgreSQL`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#type WindowsWebApp#type}
    */
    readonly type: string;
    /**
    * The connection string value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#value WindowsWebApp#value}
    */
    readonly value: string;
}
export declare function windowsWebAppConnectionStringToTerraform(struct?: WindowsWebAppConnectionString | cdktf.IResolvable): any;
export declare function windowsWebAppConnectionStringToHclTerraform(struct?: WindowsWebAppConnectionString | cdktf.IResolvable): any;
export declare class WindowsWebAppConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppConnectionString | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppConnectionString | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class WindowsWebAppConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppConnectionString[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppConnectionStringOutputReference;
}
export interface WindowsWebAppIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#identity_ids WindowsWebApp#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#type WindowsWebApp#type}
    */
    readonly type: string;
}
export declare function windowsWebAppIdentityToTerraform(struct?: WindowsWebAppIdentityOutputReference | WindowsWebAppIdentity): any;
export declare function windowsWebAppIdentityToHclTerraform(struct?: WindowsWebAppIdentityOutputReference | WindowsWebAppIdentity): any;
export declare class WindowsWebAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppIdentity | undefined;
    set internalValue(value: WindowsWebAppIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface WindowsWebAppLogsApplicationLogsAzureBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#level WindowsWebApp#level}
    */
    readonly level: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#retention_in_days WindowsWebApp#retention_in_days}
    */
    readonly retentionInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#sas_url WindowsWebApp#sas_url}
    */
    readonly sasUrl: string;
}
export declare function windowsWebAppLogsApplicationLogsAzureBlobStorageToTerraform(struct?: WindowsWebAppLogsApplicationLogsAzureBlobStorageOutputReference | WindowsWebAppLogsApplicationLogsAzureBlobStorage): any;
export declare function windowsWebAppLogsApplicationLogsAzureBlobStorageToHclTerraform(struct?: WindowsWebAppLogsApplicationLogsAzureBlobStorageOutputReference | WindowsWebAppLogsApplicationLogsAzureBlobStorage): any;
export declare class WindowsWebAppLogsApplicationLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppLogsApplicationLogsAzureBlobStorage | undefined;
    set internalValue(value: WindowsWebAppLogsApplicationLogsAzureBlobStorage | undefined);
    private _level?;
    get level(): string;
    set level(value: string);
    get levelInput(): string | undefined;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    get sasUrl(): string;
    set sasUrl(value: string);
    get sasUrlInput(): string | undefined;
}
export interface WindowsWebAppLogsApplicationLogs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#file_system_level WindowsWebApp#file_system_level}
    */
    readonly fileSystemLevel: string;
    /**
    * azure_blob_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#azure_blob_storage WindowsWebApp#azure_blob_storage}
    */
    readonly azureBlobStorage?: WindowsWebAppLogsApplicationLogsAzureBlobStorage;
}
export declare function windowsWebAppLogsApplicationLogsToTerraform(struct?: WindowsWebAppLogsApplicationLogsOutputReference | WindowsWebAppLogsApplicationLogs): any;
export declare function windowsWebAppLogsApplicationLogsToHclTerraform(struct?: WindowsWebAppLogsApplicationLogsOutputReference | WindowsWebAppLogsApplicationLogs): any;
export declare class WindowsWebAppLogsApplicationLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppLogsApplicationLogs | undefined;
    set internalValue(value: WindowsWebAppLogsApplicationLogs | undefined);
    private _fileSystemLevel?;
    get fileSystemLevel(): string;
    set fileSystemLevel(value: string);
    get fileSystemLevelInput(): string | undefined;
    private _azureBlobStorage;
    get azureBlobStorage(): WindowsWebAppLogsApplicationLogsAzureBlobStorageOutputReference;
    putAzureBlobStorage(value: WindowsWebAppLogsApplicationLogsAzureBlobStorage): void;
    resetAzureBlobStorage(): void;
    get azureBlobStorageInput(): WindowsWebAppLogsApplicationLogsAzureBlobStorage | undefined;
}
export interface WindowsWebAppLogsHttpLogsAzureBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#retention_in_days WindowsWebApp#retention_in_days}
    */
    readonly retentionInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#sas_url WindowsWebApp#sas_url}
    */
    readonly sasUrl: string;
}
export declare function windowsWebAppLogsHttpLogsAzureBlobStorageToTerraform(struct?: WindowsWebAppLogsHttpLogsAzureBlobStorageOutputReference | WindowsWebAppLogsHttpLogsAzureBlobStorage): any;
export declare function windowsWebAppLogsHttpLogsAzureBlobStorageToHclTerraform(struct?: WindowsWebAppLogsHttpLogsAzureBlobStorageOutputReference | WindowsWebAppLogsHttpLogsAzureBlobStorage): any;
export declare class WindowsWebAppLogsHttpLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppLogsHttpLogsAzureBlobStorage | undefined;
    set internalValue(value: WindowsWebAppLogsHttpLogsAzureBlobStorage | undefined);
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    resetRetentionInDays(): void;
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    get sasUrl(): string;
    set sasUrl(value: string);
    get sasUrlInput(): string | undefined;
}
export interface WindowsWebAppLogsHttpLogsFileSystem {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#retention_in_days WindowsWebApp#retention_in_days}
    */
    readonly retentionInDays: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#retention_in_mb WindowsWebApp#retention_in_mb}
    */
    readonly retentionInMb: number;
}
export declare function windowsWebAppLogsHttpLogsFileSystemToTerraform(struct?: WindowsWebAppLogsHttpLogsFileSystemOutputReference | WindowsWebAppLogsHttpLogsFileSystem): any;
export declare function windowsWebAppLogsHttpLogsFileSystemToHclTerraform(struct?: WindowsWebAppLogsHttpLogsFileSystemOutputReference | WindowsWebAppLogsHttpLogsFileSystem): any;
export declare class WindowsWebAppLogsHttpLogsFileSystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppLogsHttpLogsFileSystem | undefined;
    set internalValue(value: WindowsWebAppLogsHttpLogsFileSystem | undefined);
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    get retentionInDaysInput(): number | undefined;
    private _retentionInMb?;
    get retentionInMb(): number;
    set retentionInMb(value: number);
    get retentionInMbInput(): number | undefined;
}
export interface WindowsWebAppLogsHttpLogs {
    /**
    * azure_blob_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#azure_blob_storage WindowsWebApp#azure_blob_storage}
    */
    readonly azureBlobStorage?: WindowsWebAppLogsHttpLogsAzureBlobStorage;
    /**
    * file_system block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#file_system WindowsWebApp#file_system}
    */
    readonly fileSystem?: WindowsWebAppLogsHttpLogsFileSystem;
}
export declare function windowsWebAppLogsHttpLogsToTerraform(struct?: WindowsWebAppLogsHttpLogsOutputReference | WindowsWebAppLogsHttpLogs): any;
export declare function windowsWebAppLogsHttpLogsToHclTerraform(struct?: WindowsWebAppLogsHttpLogsOutputReference | WindowsWebAppLogsHttpLogs): any;
export declare class WindowsWebAppLogsHttpLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppLogsHttpLogs | undefined;
    set internalValue(value: WindowsWebAppLogsHttpLogs | undefined);
    private _azureBlobStorage;
    get azureBlobStorage(): WindowsWebAppLogsHttpLogsAzureBlobStorageOutputReference;
    putAzureBlobStorage(value: WindowsWebAppLogsHttpLogsAzureBlobStorage): void;
    resetAzureBlobStorage(): void;
    get azureBlobStorageInput(): WindowsWebAppLogsHttpLogsAzureBlobStorage | undefined;
    private _fileSystem;
    get fileSystem(): WindowsWebAppLogsHttpLogsFileSystemOutputReference;
    putFileSystem(value: WindowsWebAppLogsHttpLogsFileSystem): void;
    resetFileSystem(): void;
    get fileSystemInput(): WindowsWebAppLogsHttpLogsFileSystem | undefined;
}
export interface WindowsWebAppLogs {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#detailed_error_messages WindowsWebApp#detailed_error_messages}
    */
    readonly detailedErrorMessages?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#failed_request_tracing WindowsWebApp#failed_request_tracing}
    */
    readonly failedRequestTracing?: boolean | cdktf.IResolvable;
    /**
    * application_logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#application_logs WindowsWebApp#application_logs}
    */
    readonly applicationLogs?: WindowsWebAppLogsApplicationLogs;
    /**
    * http_logs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#http_logs WindowsWebApp#http_logs}
    */
    readonly httpLogs?: WindowsWebAppLogsHttpLogs;
}
export declare function windowsWebAppLogsToTerraform(struct?: WindowsWebAppLogsOutputReference | WindowsWebAppLogs): any;
export declare function windowsWebAppLogsToHclTerraform(struct?: WindowsWebAppLogsOutputReference | WindowsWebAppLogs): any;
export declare class WindowsWebAppLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppLogs | undefined;
    set internalValue(value: WindowsWebAppLogs | undefined);
    private _detailedErrorMessages?;
    get detailedErrorMessages(): boolean | cdktf.IResolvable;
    set detailedErrorMessages(value: boolean | cdktf.IResolvable);
    resetDetailedErrorMessages(): void;
    get detailedErrorMessagesInput(): boolean | cdktf.IResolvable | undefined;
    private _failedRequestTracing?;
    get failedRequestTracing(): boolean | cdktf.IResolvable;
    set failedRequestTracing(value: boolean | cdktf.IResolvable);
    resetFailedRequestTracing(): void;
    get failedRequestTracingInput(): boolean | cdktf.IResolvable | undefined;
    private _applicationLogs;
    get applicationLogs(): WindowsWebAppLogsApplicationLogsOutputReference;
    putApplicationLogs(value: WindowsWebAppLogsApplicationLogs): void;
    resetApplicationLogs(): void;
    get applicationLogsInput(): WindowsWebAppLogsApplicationLogs | undefined;
    private _httpLogs;
    get httpLogs(): WindowsWebAppLogsHttpLogsOutputReference;
    putHttpLogs(value: WindowsWebAppLogsHttpLogs): void;
    resetHttpLogs(): void;
    get httpLogsInput(): WindowsWebAppLogsHttpLogs | undefined;
}
export interface WindowsWebAppSiteConfigApplicationStack {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#current_stack WindowsWebApp#current_stack}
    */
    readonly currentStack?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#docker_image_name WindowsWebApp#docker_image_name}
    */
    readonly dockerImageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#docker_registry_password WindowsWebApp#docker_registry_password}
    */
    readonly dockerRegistryPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#docker_registry_url WindowsWebApp#docker_registry_url}
    */
    readonly dockerRegistryUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#docker_registry_username WindowsWebApp#docker_registry_username}
    */
    readonly dockerRegistryUsername?: string;
    /**
    * The version of DotNetCore to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#dotnet_core_version WindowsWebApp#dotnet_core_version}
    */
    readonly dotnetCoreVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#dotnet_version WindowsWebApp#dotnet_version}
    */
    readonly dotnetVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#java_container WindowsWebApp#java_container}
    */
    readonly javaContainer?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#java_container_version WindowsWebApp#java_container_version}
    */
    readonly javaContainerVersion?: string;
    /**
    * Should the application use the embedded web server for the version of Java in use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#java_embedded_server_enabled WindowsWebApp#java_embedded_server_enabled}
    */
    readonly javaEmbeddedServerEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#java_version WindowsWebApp#java_version}
    */
    readonly javaVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#node_version WindowsWebApp#node_version}
    */
    readonly nodeVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#php_version WindowsWebApp#php_version}
    */
    readonly phpVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#python WindowsWebApp#python}
    */
    readonly python?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#tomcat_version WindowsWebApp#tomcat_version}
    */
    readonly tomcatVersion?: string;
}
export declare function windowsWebAppSiteConfigApplicationStackToTerraform(struct?: WindowsWebAppSiteConfigApplicationStackOutputReference | WindowsWebAppSiteConfigApplicationStack): any;
export declare function windowsWebAppSiteConfigApplicationStackToHclTerraform(struct?: WindowsWebAppSiteConfigApplicationStackOutputReference | WindowsWebAppSiteConfigApplicationStack): any;
export declare class WindowsWebAppSiteConfigApplicationStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSiteConfigApplicationStack | undefined;
    set internalValue(value: WindowsWebAppSiteConfigApplicationStack | undefined);
    private _currentStack?;
    get currentStack(): string;
    set currentStack(value: string);
    resetCurrentStack(): void;
    get currentStackInput(): string | undefined;
    private _dockerImageName?;
    get dockerImageName(): string;
    set dockerImageName(value: string);
    resetDockerImageName(): void;
    get dockerImageNameInput(): string | undefined;
    private _dockerRegistryPassword?;
    get dockerRegistryPassword(): string;
    set dockerRegistryPassword(value: string);
    resetDockerRegistryPassword(): void;
    get dockerRegistryPasswordInput(): string | undefined;
    private _dockerRegistryUrl?;
    get dockerRegistryUrl(): string;
    set dockerRegistryUrl(value: string);
    resetDockerRegistryUrl(): void;
    get dockerRegistryUrlInput(): string | undefined;
    private _dockerRegistryUsername?;
    get dockerRegistryUsername(): string;
    set dockerRegistryUsername(value: string);
    resetDockerRegistryUsername(): void;
    get dockerRegistryUsernameInput(): string | undefined;
    private _dotnetCoreVersion?;
    get dotnetCoreVersion(): string;
    set dotnetCoreVersion(value: string);
    resetDotnetCoreVersion(): void;
    get dotnetCoreVersionInput(): string | undefined;
    private _dotnetVersion?;
    get dotnetVersion(): string;
    set dotnetVersion(value: string);
    resetDotnetVersion(): void;
    get dotnetVersionInput(): string | undefined;
    private _javaContainer?;
    get javaContainer(): string;
    set javaContainer(value: string);
    resetJavaContainer(): void;
    get javaContainerInput(): string | undefined;
    private _javaContainerVersion?;
    get javaContainerVersion(): string;
    set javaContainerVersion(value: string);
    resetJavaContainerVersion(): void;
    get javaContainerVersionInput(): string | undefined;
    private _javaEmbeddedServerEnabled?;
    get javaEmbeddedServerEnabled(): boolean | cdktf.IResolvable;
    set javaEmbeddedServerEnabled(value: boolean | cdktf.IResolvable);
    resetJavaEmbeddedServerEnabled(): void;
    get javaEmbeddedServerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _javaVersion?;
    get javaVersion(): string;
    set javaVersion(value: string);
    resetJavaVersion(): void;
    get javaVersionInput(): string | undefined;
    private _nodeVersion?;
    get nodeVersion(): string;
    set nodeVersion(value: string);
    resetNodeVersion(): void;
    get nodeVersionInput(): string | undefined;
    private _phpVersion?;
    get phpVersion(): string;
    set phpVersion(value: string);
    resetPhpVersion(): void;
    get phpVersionInput(): string | undefined;
    private _python?;
    get python(): boolean | cdktf.IResolvable;
    set python(value: boolean | cdktf.IResolvable);
    resetPython(): void;
    get pythonInput(): boolean | cdktf.IResolvable | undefined;
    private _tomcatVersion?;
    get tomcatVersion(): string;
    set tomcatVersion(value: string);
    resetTomcatVersion(): void;
    get tomcatVersionInput(): string | undefined;
}
export interface WindowsWebAppSiteConfigAutoHealSettingActionCustomAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#executable WindowsWebApp#executable}
    */
    readonly executable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#parameters WindowsWebApp#parameters}
    */
    readonly parameters?: string;
}
export declare function windowsWebAppSiteConfigAutoHealSettingActionCustomActionToTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingActionCustomActionOutputReference | WindowsWebAppSiteConfigAutoHealSettingActionCustomAction): any;
export declare function windowsWebAppSiteConfigAutoHealSettingActionCustomActionToHclTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingActionCustomActionOutputReference | WindowsWebAppSiteConfigAutoHealSettingActionCustomAction): any;
export declare class WindowsWebAppSiteConfigAutoHealSettingActionCustomActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSiteConfigAutoHealSettingActionCustomAction | undefined;
    set internalValue(value: WindowsWebAppSiteConfigAutoHealSettingActionCustomAction | undefined);
    private _executable?;
    get executable(): string;
    set executable(value: string);
    get executableInput(): string | undefined;
    private _parameters?;
    get parameters(): string;
    set parameters(value: string);
    resetParameters(): void;
    get parametersInput(): string | undefined;
}
export interface WindowsWebAppSiteConfigAutoHealSettingAction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#action_type WindowsWebApp#action_type}
    */
    readonly actionType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#minimum_process_execution_time WindowsWebApp#minimum_process_execution_time}
    */
    readonly minimumProcessExecutionTime?: string;
    /**
    * custom_action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#custom_action WindowsWebApp#custom_action}
    */
    readonly customAction?: WindowsWebAppSiteConfigAutoHealSettingActionCustomAction;
}
export declare function windowsWebAppSiteConfigAutoHealSettingActionToTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingActionOutputReference | WindowsWebAppSiteConfigAutoHealSettingAction): any;
export declare function windowsWebAppSiteConfigAutoHealSettingActionToHclTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingActionOutputReference | WindowsWebAppSiteConfigAutoHealSettingAction): any;
export declare class WindowsWebAppSiteConfigAutoHealSettingActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSiteConfigAutoHealSettingAction | undefined;
    set internalValue(value: WindowsWebAppSiteConfigAutoHealSettingAction | undefined);
    private _actionType?;
    get actionType(): string;
    set actionType(value: string);
    get actionTypeInput(): string | undefined;
    private _minimumProcessExecutionTime?;
    get minimumProcessExecutionTime(): string;
    set minimumProcessExecutionTime(value: string);
    resetMinimumProcessExecutionTime(): void;
    get minimumProcessExecutionTimeInput(): string | undefined;
    private _customAction;
    get customAction(): WindowsWebAppSiteConfigAutoHealSettingActionCustomActionOutputReference;
    putCustomAction(value: WindowsWebAppSiteConfigAutoHealSettingActionCustomAction): void;
    resetCustomAction(): void;
    get customActionInput(): WindowsWebAppSiteConfigAutoHealSettingActionCustomAction | undefined;
}
export interface WindowsWebAppSiteConfigAutoHealSettingTriggerRequests {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#count WindowsWebApp#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#interval WindowsWebApp#interval}
    */
    readonly interval: string;
}
export declare function windowsWebAppSiteConfigAutoHealSettingTriggerRequestsToTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference | WindowsWebAppSiteConfigAutoHealSettingTriggerRequests): any;
export declare function windowsWebAppSiteConfigAutoHealSettingTriggerRequestsToHclTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference | WindowsWebAppSiteConfigAutoHealSettingTriggerRequests): any;
export declare class WindowsWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSiteConfigAutoHealSettingTriggerRequests | undefined;
    set internalValue(value: WindowsWebAppSiteConfigAutoHealSettingTriggerRequests | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
}
export interface WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#count WindowsWebApp#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#interval WindowsWebApp#interval}
    */
    readonly interval: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#time_taken WindowsWebApp#time_taken}
    */
    readonly timeTaken: string;
}
export declare function windowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestToTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference | WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest): any;
export declare function windowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestToHclTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference | WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest): any;
export declare class WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined;
    set internalValue(value: WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _timeTaken?;
    get timeTaken(): string;
    set timeTaken(value: string);
    get timeTakenInput(): string | undefined;
}
export interface WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#count WindowsWebApp#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#interval WindowsWebApp#interval}
    */
    readonly interval: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#path WindowsWebApp#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#time_taken WindowsWebApp#time_taken}
    */
    readonly timeTaken: string;
}
export declare function windowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathToTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath | cdktf.IResolvable): any;
export declare function windowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathToHclTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath | cdktf.IResolvable): any;
export declare class WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _timeTaken?;
    get timeTaken(): string;
    set timeTaken(value: string);
    get timeTakenInput(): string | undefined;
}
export declare class WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathOutputReference;
}
export interface WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#count WindowsWebApp#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#interval WindowsWebApp#interval}
    */
    readonly interval: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#path WindowsWebApp#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#status_code_range WindowsWebApp#status_code_range}
    */
    readonly statusCodeRange: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#sub_status WindowsWebApp#sub_status}
    */
    readonly subStatus?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#win32_status_code WindowsWebApp#win32_status_code}
    */
    readonly win32StatusCode?: number;
}
export declare function windowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeToTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable): any;
export declare function windowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeToHclTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable): any;
export declare class WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode | cdktf.IResolvable | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _interval?;
    get interval(): string;
    set interval(value: string);
    get intervalInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _statusCodeRange?;
    get statusCodeRange(): string;
    set statusCodeRange(value: string);
    get statusCodeRangeInput(): string | undefined;
    private _subStatus?;
    get subStatus(): number;
    set subStatus(value: number);
    resetSubStatus(): void;
    get subStatusInput(): number | undefined;
    private _win32StatusCode?;
    get win32StatusCode(): number;
    set win32StatusCode(value: number);
    resetWin32StatusCode(): void;
    get win32StatusCodeInput(): number | undefined;
}
export declare class WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeOutputReference;
}
export interface WindowsWebAppSiteConfigAutoHealSettingTrigger {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#private_memory_kb WindowsWebApp#private_memory_kb}
    */
    readonly privateMemoryKb?: number;
    /**
    * requests block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#requests WindowsWebApp#requests}
    */
    readonly requests?: WindowsWebAppSiteConfigAutoHealSettingTriggerRequests;
    /**
    * slow_request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#slow_request WindowsWebApp#slow_request}
    */
    readonly slowRequest?: WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest;
    /**
    * slow_request_with_path block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#slow_request_with_path WindowsWebApp#slow_request_with_path}
    */
    readonly slowRequestWithPath?: WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath[] | cdktf.IResolvable;
    /**
    * status_code block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#status_code WindowsWebApp#status_code}
    */
    readonly statusCode?: WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable;
}
export declare function windowsWebAppSiteConfigAutoHealSettingTriggerToTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingTriggerOutputReference | WindowsWebAppSiteConfigAutoHealSettingTrigger): any;
export declare function windowsWebAppSiteConfigAutoHealSettingTriggerToHclTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingTriggerOutputReference | WindowsWebAppSiteConfigAutoHealSettingTrigger): any;
export declare class WindowsWebAppSiteConfigAutoHealSettingTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSiteConfigAutoHealSettingTrigger | undefined;
    set internalValue(value: WindowsWebAppSiteConfigAutoHealSettingTrigger | undefined);
    private _privateMemoryKb?;
    get privateMemoryKb(): number;
    set privateMemoryKb(value: number);
    resetPrivateMemoryKb(): void;
    get privateMemoryKbInput(): number | undefined;
    private _requests;
    get requests(): WindowsWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference;
    putRequests(value: WindowsWebAppSiteConfigAutoHealSettingTriggerRequests): void;
    resetRequests(): void;
    get requestsInput(): WindowsWebAppSiteConfigAutoHealSettingTriggerRequests | undefined;
    private _slowRequest;
    get slowRequest(): WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference;
    putSlowRequest(value: WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest): void;
    resetSlowRequest(): void;
    get slowRequestInput(): WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined;
    private _slowRequestWithPath;
    get slowRequestWithPath(): WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPathList;
    putSlowRequestWithPath(value: WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath[] | cdktf.IResolvable): void;
    resetSlowRequestWithPath(): void;
    get slowRequestWithPathInput(): cdktf.IResolvable | WindowsWebAppSiteConfigAutoHealSettingTriggerSlowRequestWithPath[] | undefined;
    private _statusCode;
    get statusCode(): WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCodeList;
    putStatusCode(value: WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode[] | cdktf.IResolvable): void;
    resetStatusCode(): void;
    get statusCodeInput(): cdktf.IResolvable | WindowsWebAppSiteConfigAutoHealSettingTriggerStatusCode[] | undefined;
}
export interface WindowsWebAppSiteConfigAutoHealSetting {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#action WindowsWebApp#action}
    */
    readonly action: WindowsWebAppSiteConfigAutoHealSettingAction;
    /**
    * trigger block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#trigger WindowsWebApp#trigger}
    */
    readonly trigger: WindowsWebAppSiteConfigAutoHealSettingTrigger;
}
export declare function windowsWebAppSiteConfigAutoHealSettingToTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingOutputReference | WindowsWebAppSiteConfigAutoHealSetting): any;
export declare function windowsWebAppSiteConfigAutoHealSettingToHclTerraform(struct?: WindowsWebAppSiteConfigAutoHealSettingOutputReference | WindowsWebAppSiteConfigAutoHealSetting): any;
export declare class WindowsWebAppSiteConfigAutoHealSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSiteConfigAutoHealSetting | undefined;
    set internalValue(value: WindowsWebAppSiteConfigAutoHealSetting | undefined);
    private _action;
    get action(): WindowsWebAppSiteConfigAutoHealSettingActionOutputReference;
    putAction(value: WindowsWebAppSiteConfigAutoHealSettingAction): void;
    get actionInput(): WindowsWebAppSiteConfigAutoHealSettingAction | undefined;
    private _trigger;
    get trigger(): WindowsWebAppSiteConfigAutoHealSettingTriggerOutputReference;
    putTrigger(value: WindowsWebAppSiteConfigAutoHealSettingTrigger): void;
    get triggerInput(): WindowsWebAppSiteConfigAutoHealSettingTrigger | undefined;
}
export interface WindowsWebAppSiteConfigCors {
    /**
    * Specifies a list of origins that should be allowed to make cross-origin calls.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#allowed_origins WindowsWebApp#allowed_origins}
    */
    readonly allowedOrigins?: string[];
    /**
    * Are credentials allowed in CORS requests? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#support_credentials WindowsWebApp#support_credentials}
    */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function windowsWebAppSiteConfigCorsToTerraform(struct?: WindowsWebAppSiteConfigCorsOutputReference | WindowsWebAppSiteConfigCors): any;
export declare function windowsWebAppSiteConfigCorsToHclTerraform(struct?: WindowsWebAppSiteConfigCorsOutputReference | WindowsWebAppSiteConfigCors): any;
export declare class WindowsWebAppSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSiteConfigCors | undefined;
    set internalValue(value: WindowsWebAppSiteConfigCors | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    resetAllowedOrigins(): void;
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    get supportCredentials(): boolean | cdktf.IResolvable;
    set supportCredentials(value: boolean | cdktf.IResolvable);
    resetSupportCredentials(): void;
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WindowsWebAppSiteConfigHandlerMapping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#arguments WindowsWebApp#arguments}
    */
    readonly arguments?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#extension WindowsWebApp#extension}
    */
    readonly extension: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#script_processor_path WindowsWebApp#script_processor_path}
    */
    readonly scriptProcessorPath: string;
}
export declare function windowsWebAppSiteConfigHandlerMappingToTerraform(struct?: WindowsWebAppSiteConfigHandlerMapping | cdktf.IResolvable): any;
export declare function windowsWebAppSiteConfigHandlerMappingToHclTerraform(struct?: WindowsWebAppSiteConfigHandlerMapping | cdktf.IResolvable): any;
export declare class WindowsWebAppSiteConfigHandlerMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSiteConfigHandlerMapping | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSiteConfigHandlerMapping | cdktf.IResolvable | undefined);
    private _arguments?;
    get arguments(): string;
    set arguments(value: string);
    resetArguments(): void;
    get argumentsInput(): string | undefined;
    private _extension?;
    get extension(): string;
    set extension(value: string);
    get extensionInput(): string | undefined;
    private _scriptProcessorPath?;
    get scriptProcessorPath(): string;
    set scriptProcessorPath(value: string);
    get scriptProcessorPathInput(): string | undefined;
}
export declare class WindowsWebAppSiteConfigHandlerMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSiteConfigHandlerMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSiteConfigHandlerMappingOutputReference;
}
export interface WindowsWebAppSiteConfigIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#x_azure_fdid WindowsWebApp#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#x_fd_health_probe WindowsWebApp#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#x_forwarded_for WindowsWebApp#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#x_forwarded_host WindowsWebApp#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function windowsWebAppSiteConfigIpRestrictionHeadersToTerraform(struct?: WindowsWebAppSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare function windowsWebAppSiteConfigIpRestrictionHeadersToHclTerraform(struct?: WindowsWebAppSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class WindowsWebAppSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class WindowsWebAppSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSiteConfigIpRestrictionHeadersOutputReference;
}
export interface WindowsWebAppSiteConfigIpRestriction {
    /**
    * The action to take. Possible values are `Allow` or `Deny`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#action WindowsWebApp#action}
    */
    readonly action?: string;
    /**
    * The description of the IP restriction rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#description WindowsWebApp#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#headers WindowsWebApp#headers}
    */
    readonly headers?: WindowsWebAppSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * The CIDR notation of the IP or IP Range to match. For example: `10.0.0.0/24` or `192.168.10.1/32` or `fe80::/64` or `13.107.6.152/31,13.107.128.0/22`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#ip_address WindowsWebApp#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The name which should be used for this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#name WindowsWebApp#name}
    */
    readonly name?: string;
    /**
    * The priority value of this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#priority WindowsWebApp#priority}
    */
    readonly priority?: number;
    /**
    * The Service Tag used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#service_tag WindowsWebApp#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * The Virtual Network Subnet ID used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#virtual_network_subnet_id WindowsWebApp#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function windowsWebAppSiteConfigIpRestrictionToTerraform(struct?: WindowsWebAppSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare function windowsWebAppSiteConfigIpRestrictionToHclTerraform(struct?: WindowsWebAppSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare class WindowsWebAppSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSiteConfigIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSiteConfigIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _headers;
    get headers(): WindowsWebAppSiteConfigIpRestrictionHeadersList;
    putHeaders(value: WindowsWebAppSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | WindowsWebAppSiteConfigIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class WindowsWebAppSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSiteConfigIpRestrictionOutputReference;
}
export interface WindowsWebAppSiteConfigScmIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#x_azure_fdid WindowsWebApp#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#x_fd_health_probe WindowsWebApp#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#x_forwarded_for WindowsWebApp#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#x_forwarded_host WindowsWebApp#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function windowsWebAppSiteConfigScmIpRestrictionHeadersToTerraform(struct?: WindowsWebAppSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare function windowsWebAppSiteConfigScmIpRestrictionHeadersToHclTerraform(struct?: WindowsWebAppSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class WindowsWebAppSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class WindowsWebAppSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface WindowsWebAppSiteConfigScmIpRestriction {
    /**
    * The action to take. Possible values are `Allow` or `Deny`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#action WindowsWebApp#action}
    */
    readonly action?: string;
    /**
    * The description of the IP restriction rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#description WindowsWebApp#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#headers WindowsWebApp#headers}
    */
    readonly headers?: WindowsWebAppSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * The CIDR notation of the IP or IP Range to match. For example: `10.0.0.0/24` or `192.168.10.1/32` or `fe80::/64` or `13.107.6.152/31,13.107.128.0/22`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#ip_address WindowsWebApp#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The name which should be used for this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#name WindowsWebApp#name}
    */
    readonly name?: string;
    /**
    * The priority value of this `ip_restriction`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#priority WindowsWebApp#priority}
    */
    readonly priority?: number;
    /**
    * The Service Tag used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#service_tag WindowsWebApp#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * The Virtual Network Subnet ID used for this IP Restriction.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#virtual_network_subnet_id WindowsWebApp#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function windowsWebAppSiteConfigScmIpRestrictionToTerraform(struct?: WindowsWebAppSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare function windowsWebAppSiteConfigScmIpRestrictionToHclTerraform(struct?: WindowsWebAppSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare class WindowsWebAppSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSiteConfigScmIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSiteConfigScmIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _headers;
    get headers(): WindowsWebAppSiteConfigScmIpRestrictionHeadersList;
    putHeaders(value: WindowsWebAppSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | WindowsWebAppSiteConfigScmIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class WindowsWebAppSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSiteConfigScmIpRestrictionOutputReference;
}
export interface WindowsWebAppSiteConfigVirtualApplicationVirtualDirectory {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#physical_path WindowsWebApp#physical_path}
    */
    readonly physicalPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#virtual_path WindowsWebApp#virtual_path}
    */
    readonly virtualPath?: string;
}
export declare function windowsWebAppSiteConfigVirtualApplicationVirtualDirectoryToTerraform(struct?: WindowsWebAppSiteConfigVirtualApplicationVirtualDirectory | cdktf.IResolvable): any;
export declare function windowsWebAppSiteConfigVirtualApplicationVirtualDirectoryToHclTerraform(struct?: WindowsWebAppSiteConfigVirtualApplicationVirtualDirectory | cdktf.IResolvable): any;
export declare class WindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSiteConfigVirtualApplicationVirtualDirectory | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSiteConfigVirtualApplicationVirtualDirectory | cdktf.IResolvable | undefined);
    private _physicalPath?;
    get physicalPath(): string;
    set physicalPath(value: string);
    resetPhysicalPath(): void;
    get physicalPathInput(): string | undefined;
    private _virtualPath?;
    get virtualPath(): string;
    set virtualPath(value: string);
    resetVirtualPath(): void;
    get virtualPathInput(): string | undefined;
}
export declare class WindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSiteConfigVirtualApplicationVirtualDirectory[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryOutputReference;
}
export interface WindowsWebAppSiteConfigVirtualApplication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#physical_path WindowsWebApp#physical_path}
    */
    readonly physicalPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#preload WindowsWebApp#preload}
    */
    readonly preload: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#virtual_path WindowsWebApp#virtual_path}
    */
    readonly virtualPath: string;
    /**
    * virtual_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#virtual_directory WindowsWebApp#virtual_directory}
    */
    readonly virtualDirectory?: WindowsWebAppSiteConfigVirtualApplicationVirtualDirectory[] | cdktf.IResolvable;
}
export declare function windowsWebAppSiteConfigVirtualApplicationToTerraform(struct?: WindowsWebAppSiteConfigVirtualApplication | cdktf.IResolvable): any;
export declare function windowsWebAppSiteConfigVirtualApplicationToHclTerraform(struct?: WindowsWebAppSiteConfigVirtualApplication | cdktf.IResolvable): any;
export declare class WindowsWebAppSiteConfigVirtualApplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppSiteConfigVirtualApplication | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppSiteConfigVirtualApplication | cdktf.IResolvable | undefined);
    private _physicalPath?;
    get physicalPath(): string;
    set physicalPath(value: string);
    get physicalPathInput(): string | undefined;
    private _preload?;
    get preload(): boolean | cdktf.IResolvable;
    set preload(value: boolean | cdktf.IResolvable);
    get preloadInput(): boolean | cdktf.IResolvable | undefined;
    private _virtualPath?;
    get virtualPath(): string;
    set virtualPath(value: string);
    get virtualPathInput(): string | undefined;
    private _virtualDirectory;
    get virtualDirectory(): WindowsWebAppSiteConfigVirtualApplicationVirtualDirectoryList;
    putVirtualDirectory(value: WindowsWebAppSiteConfigVirtualApplicationVirtualDirectory[] | cdktf.IResolvable): void;
    resetVirtualDirectory(): void;
    get virtualDirectoryInput(): cdktf.IResolvable | WindowsWebAppSiteConfigVirtualApplicationVirtualDirectory[] | undefined;
}
export declare class WindowsWebAppSiteConfigVirtualApplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppSiteConfigVirtualApplication[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppSiteConfigVirtualApplicationOutputReference;
}
export interface WindowsWebAppSiteConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#always_on WindowsWebApp#always_on}
    */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#api_definition_url WindowsWebApp#api_definition_url}
    */
    readonly apiDefinitionUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#api_management_api_id WindowsWebApp#api_management_api_id}
    */
    readonly apiManagementApiId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#app_command_line WindowsWebApp#app_command_line}
    */
    readonly appCommandLine?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#container_registry_managed_identity_client_id WindowsWebApp#container_registry_managed_identity_client_id}
    */
    readonly containerRegistryManagedIdentityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#container_registry_use_managed_identity WindowsWebApp#container_registry_use_managed_identity}
    */
    readonly containerRegistryUseManagedIdentity?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#default_documents WindowsWebApp#default_documents}
    */
    readonly defaultDocuments?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#ftps_state WindowsWebApp#ftps_state}
    */
    readonly ftpsState?: string;
    /**
    * The amount of time in minutes that a node is unhealthy before being removed from the load balancer. Possible values are between `2` and `10`. Only valid in conjunction with `health_check_path`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#health_check_eviction_time_in_min WindowsWebApp#health_check_eviction_time_in_min}
    */
    readonly healthCheckEvictionTimeInMin?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#health_check_path WindowsWebApp#health_check_path}
    */
    readonly healthCheckPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#http2_enabled WindowsWebApp#http2_enabled}
    */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#ip_restriction_default_action WindowsWebApp#ip_restriction_default_action}
    */
    readonly ipRestrictionDefaultAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#load_balancing_mode WindowsWebApp#load_balancing_mode}
    */
    readonly loadBalancingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#local_mysql_enabled WindowsWebApp#local_mysql_enabled}
    */
    readonly localMysqlEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#managed_pipeline_mode WindowsWebApp#managed_pipeline_mode}
    */
    readonly managedPipelineMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#minimum_tls_version WindowsWebApp#minimum_tls_version}
    */
    readonly minimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#remote_debugging_enabled WindowsWebApp#remote_debugging_enabled}
    */
    readonly remoteDebuggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#remote_debugging_version WindowsWebApp#remote_debugging_version}
    */
    readonly remoteDebuggingVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#scm_ip_restriction_default_action WindowsWebApp#scm_ip_restriction_default_action}
    */
    readonly scmIpRestrictionDefaultAction?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#scm_minimum_tls_version WindowsWebApp#scm_minimum_tls_version}
    */
    readonly scmMinimumTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#scm_use_main_ip_restriction WindowsWebApp#scm_use_main_ip_restriction}
    */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#use_32_bit_worker WindowsWebApp#use_32_bit_worker}
    */
    readonly use32BitWorker?: boolean | cdktf.IResolvable;
    /**
    * Should all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied? Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#vnet_route_all_enabled WindowsWebApp#vnet_route_all_enabled}
    */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#websockets_enabled WindowsWebApp#websockets_enabled}
    */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#worker_count WindowsWebApp#worker_count}
    */
    readonly workerCount?: number;
    /**
    * application_stack block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#application_stack WindowsWebApp#application_stack}
    */
    readonly applicationStack?: WindowsWebAppSiteConfigApplicationStack;
    /**
    * auto_heal_setting block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#auto_heal_setting WindowsWebApp#auto_heal_setting}
    */
    readonly autoHealSetting?: WindowsWebAppSiteConfigAutoHealSetting;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#cors WindowsWebApp#cors}
    */
    readonly cors?: WindowsWebAppSiteConfigCors;
    /**
    * handler_mapping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#handler_mapping WindowsWebApp#handler_mapping}
    */
    readonly handlerMapping?: WindowsWebAppSiteConfigHandlerMapping[] | cdktf.IResolvable;
    /**
    * ip_restriction block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#ip_restriction WindowsWebApp#ip_restriction}
    */
    readonly ipRestriction?: WindowsWebAppSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * scm_ip_restriction block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#scm_ip_restriction WindowsWebApp#scm_ip_restriction}
    */
    readonly scmIpRestriction?: WindowsWebAppSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * virtual_application block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#virtual_application WindowsWebApp#virtual_application}
    */
    readonly virtualApplication?: WindowsWebAppSiteConfigVirtualApplication[] | cdktf.IResolvable;
}
export declare function windowsWebAppSiteConfigToTerraform(struct?: WindowsWebAppSiteConfigOutputReference | WindowsWebAppSiteConfig): any;
export declare function windowsWebAppSiteConfigToHclTerraform(struct?: WindowsWebAppSiteConfigOutputReference | WindowsWebAppSiteConfig): any;
export declare class WindowsWebAppSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppSiteConfig | undefined;
    set internalValue(value: WindowsWebAppSiteConfig | undefined);
    private _alwaysOn?;
    get alwaysOn(): boolean | cdktf.IResolvable;
    set alwaysOn(value: boolean | cdktf.IResolvable);
    resetAlwaysOn(): void;
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _apiDefinitionUrl?;
    get apiDefinitionUrl(): string;
    set apiDefinitionUrl(value: string);
    resetApiDefinitionUrl(): void;
    get apiDefinitionUrlInput(): string | undefined;
    private _apiManagementApiId?;
    get apiManagementApiId(): string;
    set apiManagementApiId(value: string);
    resetApiManagementApiId(): void;
    get apiManagementApiIdInput(): string | undefined;
    private _appCommandLine?;
    get appCommandLine(): string;
    set appCommandLine(value: string);
    resetAppCommandLine(): void;
    get appCommandLineInput(): string | undefined;
    private _containerRegistryManagedIdentityClientId?;
    get containerRegistryManagedIdentityClientId(): string;
    set containerRegistryManagedIdentityClientId(value: string);
    resetContainerRegistryManagedIdentityClientId(): void;
    get containerRegistryManagedIdentityClientIdInput(): string | undefined;
    private _containerRegistryUseManagedIdentity?;
    get containerRegistryUseManagedIdentity(): boolean | cdktf.IResolvable;
    set containerRegistryUseManagedIdentity(value: boolean | cdktf.IResolvable);
    resetContainerRegistryUseManagedIdentity(): void;
    get containerRegistryUseManagedIdentityInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultDocuments?;
    get defaultDocuments(): string[];
    set defaultDocuments(value: string[]);
    resetDefaultDocuments(): void;
    get defaultDocumentsInput(): string[] | undefined;
    get detailedErrorLoggingEnabled(): cdktf.IResolvable;
    private _ftpsState?;
    get ftpsState(): string;
    set ftpsState(value: string);
    resetFtpsState(): void;
    get ftpsStateInput(): string | undefined;
    private _healthCheckEvictionTimeInMin?;
    get healthCheckEvictionTimeInMin(): number;
    set healthCheckEvictionTimeInMin(value: number);
    resetHealthCheckEvictionTimeInMin(): void;
    get healthCheckEvictionTimeInMinInput(): number | undefined;
    private _healthCheckPath?;
    get healthCheckPath(): string;
    set healthCheckPath(value: string);
    resetHealthCheckPath(): void;
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    get http2Enabled(): boolean | cdktf.IResolvable;
    set http2Enabled(value: boolean | cdktf.IResolvable);
    resetHttp2Enabled(): void;
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestrictionDefaultAction?;
    get ipRestrictionDefaultAction(): string;
    set ipRestrictionDefaultAction(value: string);
    resetIpRestrictionDefaultAction(): void;
    get ipRestrictionDefaultActionInput(): string | undefined;
    get linuxFxVersion(): string;
    private _loadBalancingMode?;
    get loadBalancingMode(): string;
    set loadBalancingMode(value: string);
    resetLoadBalancingMode(): void;
    get loadBalancingModeInput(): string | undefined;
    private _localMysqlEnabled?;
    get localMysqlEnabled(): boolean | cdktf.IResolvable;
    set localMysqlEnabled(value: boolean | cdktf.IResolvable);
    resetLocalMysqlEnabled(): void;
    get localMysqlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _managedPipelineMode?;
    get managedPipelineMode(): string;
    set managedPipelineMode(value: string);
    resetManagedPipelineMode(): void;
    get managedPipelineModeInput(): string | undefined;
    private _minimumTlsVersion?;
    get minimumTlsVersion(): string;
    set minimumTlsVersion(value: string);
    resetMinimumTlsVersion(): void;
    get minimumTlsVersionInput(): string | undefined;
    private _remoteDebuggingEnabled?;
    get remoteDebuggingEnabled(): boolean | cdktf.IResolvable;
    set remoteDebuggingEnabled(value: boolean | cdktf.IResolvable);
    resetRemoteDebuggingEnabled(): void;
    get remoteDebuggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _remoteDebuggingVersion?;
    get remoteDebuggingVersion(): string;
    set remoteDebuggingVersion(value: string);
    resetRemoteDebuggingVersion(): void;
    get remoteDebuggingVersionInput(): string | undefined;
    private _scmIpRestrictionDefaultAction?;
    get scmIpRestrictionDefaultAction(): string;
    set scmIpRestrictionDefaultAction(value: string);
    resetScmIpRestrictionDefaultAction(): void;
    get scmIpRestrictionDefaultActionInput(): string | undefined;
    private _scmMinimumTlsVersion?;
    get scmMinimumTlsVersion(): string;
    set scmMinimumTlsVersion(value: string);
    resetScmMinimumTlsVersion(): void;
    get scmMinimumTlsVersionInput(): string | undefined;
    get scmType(): string;
    private _scmUseMainIpRestriction?;
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    resetScmUseMainIpRestriction(): void;
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorker?;
    get use32BitWorker(): boolean | cdktf.IResolvable;
    set use32BitWorker(value: boolean | cdktf.IResolvable);
    resetUse32BitWorker(): void;
    get use32BitWorkerInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    resetVnetRouteAllEnabled(): void;
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    resetWebsocketsEnabled(): void;
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get windowsFxVersion(): string;
    private _workerCount?;
    get workerCount(): number;
    set workerCount(value: number);
    resetWorkerCount(): void;
    get workerCountInput(): number | undefined;
    private _applicationStack;
    get applicationStack(): WindowsWebAppSiteConfigApplicationStackOutputReference;
    putApplicationStack(value: WindowsWebAppSiteConfigApplicationStack): void;
    resetApplicationStack(): void;
    get applicationStackInput(): WindowsWebAppSiteConfigApplicationStack | undefined;
    private _autoHealSetting;
    get autoHealSetting(): WindowsWebAppSiteConfigAutoHealSettingOutputReference;
    putAutoHealSetting(value: WindowsWebAppSiteConfigAutoHealSetting): void;
    resetAutoHealSetting(): void;
    get autoHealSettingInput(): WindowsWebAppSiteConfigAutoHealSetting | undefined;
    private _cors;
    get cors(): WindowsWebAppSiteConfigCorsOutputReference;
    putCors(value: WindowsWebAppSiteConfigCors): void;
    resetCors(): void;
    get corsInput(): WindowsWebAppSiteConfigCors | undefined;
    private _handlerMapping;
    get handlerMapping(): WindowsWebAppSiteConfigHandlerMappingList;
    putHandlerMapping(value: WindowsWebAppSiteConfigHandlerMapping[] | cdktf.IResolvable): void;
    resetHandlerMapping(): void;
    get handlerMappingInput(): cdktf.IResolvable | WindowsWebAppSiteConfigHandlerMapping[] | undefined;
    private _ipRestriction;
    get ipRestriction(): WindowsWebAppSiteConfigIpRestrictionList;
    putIpRestriction(value: WindowsWebAppSiteConfigIpRestriction[] | cdktf.IResolvable): void;
    resetIpRestriction(): void;
    get ipRestrictionInput(): cdktf.IResolvable | WindowsWebAppSiteConfigIpRestriction[] | undefined;
    private _scmIpRestriction;
    get scmIpRestriction(): WindowsWebAppSiteConfigScmIpRestrictionList;
    putScmIpRestriction(value: WindowsWebAppSiteConfigScmIpRestriction[] | cdktf.IResolvable): void;
    resetScmIpRestriction(): void;
    get scmIpRestrictionInput(): cdktf.IResolvable | WindowsWebAppSiteConfigScmIpRestriction[] | undefined;
    private _virtualApplication;
    get virtualApplication(): WindowsWebAppSiteConfigVirtualApplicationList;
    putVirtualApplication(value: WindowsWebAppSiteConfigVirtualApplication[] | cdktf.IResolvable): void;
    resetVirtualApplication(): void;
    get virtualApplicationInput(): cdktf.IResolvable | WindowsWebAppSiteConfigVirtualApplication[] | undefined;
}
export interface WindowsWebAppStickySettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#app_setting_names WindowsWebApp#app_setting_names}
    */
    readonly appSettingNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#connection_string_names WindowsWebApp#connection_string_names}
    */
    readonly connectionStringNames?: string[];
}
export declare function windowsWebAppStickySettingsToTerraform(struct?: WindowsWebAppStickySettingsOutputReference | WindowsWebAppStickySettings): any;
export declare function windowsWebAppStickySettingsToHclTerraform(struct?: WindowsWebAppStickySettingsOutputReference | WindowsWebAppStickySettings): any;
export declare class WindowsWebAppStickySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppStickySettings | undefined;
    set internalValue(value: WindowsWebAppStickySettings | undefined);
    private _appSettingNames?;
    get appSettingNames(): string[];
    set appSettingNames(value: string[]);
    resetAppSettingNames(): void;
    get appSettingNamesInput(): string[] | undefined;
    private _connectionStringNames?;
    get connectionStringNames(): string[];
    set connectionStringNames(value: string[]);
    resetConnectionStringNames(): void;
    get connectionStringNamesInput(): string[] | undefined;
}
export interface WindowsWebAppStorageAccount {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#access_key WindowsWebApp#access_key}
    */
    readonly accessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#account_name WindowsWebApp#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#mount_path WindowsWebApp#mount_path}
    */
    readonly mountPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#name WindowsWebApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#share_name WindowsWebApp#share_name}
    */
    readonly shareName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#type WindowsWebApp#type}
    */
    readonly type: string;
}
export declare function windowsWebAppStorageAccountToTerraform(struct?: WindowsWebAppStorageAccount | cdktf.IResolvable): any;
export declare function windowsWebAppStorageAccountToHclTerraform(struct?: WindowsWebAppStorageAccount | cdktf.IResolvable): any;
export declare class WindowsWebAppStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): WindowsWebAppStorageAccount | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppStorageAccount | cdktf.IResolvable | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    get accessKeyInput(): string | undefined;
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class WindowsWebAppStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: WindowsWebAppStorageAccount[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): WindowsWebAppStorageAccountOutputReference;
}
export interface WindowsWebAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#create WindowsWebApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#delete WindowsWebApp#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#read WindowsWebApp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#update WindowsWebApp#update}
    */
    readonly update?: string;
}
export declare function windowsWebAppTimeoutsToTerraform(struct?: WindowsWebAppTimeouts | cdktf.IResolvable): any;
export declare function windowsWebAppTimeoutsToHclTerraform(struct?: WindowsWebAppTimeouts | cdktf.IResolvable): any;
export declare class WindowsWebAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WindowsWebAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WindowsWebAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app azurerm_windows_web_app}
*/
export declare class WindowsWebApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_windows_web_app";
    /**
    * Generates CDKTF code for importing a WindowsWebApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the WindowsWebApp to import
    * @param importFromId The id of the existing WindowsWebApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the WindowsWebApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/windows_web_app azurerm_windows_web_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WindowsWebAppConfig
    */
    constructor(scope: Construct, id: string, config: WindowsWebAppConfig);
    private _appSettings?;
    get appSettings(): {
        [key: string]: string;
    };
    set appSettings(value: {
        [key: string]: string;
    });
    resetAppSettings(): void;
    get appSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _clientAffinityEnabled?;
    get clientAffinityEnabled(): boolean | cdktf.IResolvable;
    set clientAffinityEnabled(value: boolean | cdktf.IResolvable);
    resetClientAffinityEnabled(): void;
    get clientAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateEnabled?;
    get clientCertificateEnabled(): boolean | cdktf.IResolvable;
    set clientCertificateEnabled(value: boolean | cdktf.IResolvable);
    resetClientCertificateEnabled(): void;
    get clientCertificateEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertificateExclusionPaths?;
    get clientCertificateExclusionPaths(): string;
    set clientCertificateExclusionPaths(value: string);
    resetClientCertificateExclusionPaths(): void;
    get clientCertificateExclusionPathsInput(): string | undefined;
    private _clientCertificateMode?;
    get clientCertificateMode(): string;
    set clientCertificateMode(value: string);
    resetClientCertificateMode(): void;
    get clientCertificateModeInput(): string | undefined;
    get customDomainVerificationId(): string;
    get defaultHostname(): string;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ftpPublishBasicAuthenticationEnabled?;
    get ftpPublishBasicAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set ftpPublishBasicAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetFtpPublishBasicAuthenticationEnabled(): void;
    get ftpPublishBasicAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get hostingEnvironmentId(): string;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultReferenceIdentityId?;
    get keyVaultReferenceIdentityId(): string;
    set keyVaultReferenceIdentityId(value: string);
    resetKeyVaultReferenceIdentityId(): void;
    get keyVaultReferenceIdentityIdInput(): string | undefined;
    get kind(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _servicePlanId?;
    get servicePlanId(): string;
    set servicePlanId(value: string);
    get servicePlanIdInput(): string | undefined;
    private _siteCredential;
    get siteCredential(): WindowsWebAppSiteCredentialList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
    private _webdeployPublishBasicAuthenticationEnabled?;
    get webdeployPublishBasicAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set webdeployPublishBasicAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetWebdeployPublishBasicAuthenticationEnabled(): void;
    get webdeployPublishBasicAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _zipDeployFile?;
    get zipDeployFile(): string;
    set zipDeployFile(value: string);
    resetZipDeployFile(): void;
    get zipDeployFileInput(): string | undefined;
    private _authSettings;
    get authSettings(): WindowsWebAppAuthSettingsOutputReference;
    putAuthSettings(value: WindowsWebAppAuthSettings): void;
    resetAuthSettings(): void;
    get authSettingsInput(): WindowsWebAppAuthSettings | undefined;
    private _authSettingsV2;
    get authSettingsV2(): WindowsWebAppAuthSettingsV2OutputReference;
    putAuthSettingsV2(value: WindowsWebAppAuthSettingsV2): void;
    resetAuthSettingsV2(): void;
    get authSettingsV2Input(): WindowsWebAppAuthSettingsV2 | undefined;
    private _backup;
    get backup(): WindowsWebAppBackupOutputReference;
    putBackup(value: WindowsWebAppBackup): void;
    resetBackup(): void;
    get backupInput(): WindowsWebAppBackup | undefined;
    private _connectionString;
    get connectionString(): WindowsWebAppConnectionStringList;
    putConnectionString(value: WindowsWebAppConnectionString[] | cdktf.IResolvable): void;
    resetConnectionString(): void;
    get connectionStringInput(): cdktf.IResolvable | WindowsWebAppConnectionString[] | undefined;
    private _identity;
    get identity(): WindowsWebAppIdentityOutputReference;
    putIdentity(value: WindowsWebAppIdentity): void;
    resetIdentity(): void;
    get identityInput(): WindowsWebAppIdentity | undefined;
    private _logs;
    get logs(): WindowsWebAppLogsOutputReference;
    putLogs(value: WindowsWebAppLogs): void;
    resetLogs(): void;
    get logsInput(): WindowsWebAppLogs | undefined;
    private _siteConfig;
    get siteConfig(): WindowsWebAppSiteConfigOutputReference;
    putSiteConfig(value: WindowsWebAppSiteConfig): void;
    get siteConfigInput(): WindowsWebAppSiteConfig | undefined;
    private _stickySettings;
    get stickySettings(): WindowsWebAppStickySettingsOutputReference;
    putStickySettings(value: WindowsWebAppStickySettings): void;
    resetStickySettings(): void;
    get stickySettingsInput(): WindowsWebAppStickySettings | undefined;
    private _storageAccount;
    get storageAccount(): WindowsWebAppStorageAccountList;
    putStorageAccount(value: WindowsWebAppStorageAccount[] | cdktf.IResolvable): void;
    resetStorageAccount(): void;
    get storageAccountInput(): cdktf.IResolvable | WindowsWebAppStorageAccount[] | undefined;
    private _timeouts;
    get timeouts(): WindowsWebAppTimeoutsOutputReference;
    putTimeouts(value: WindowsWebAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WindowsWebAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
