# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AnalyticsInstanceCapacity',
    'AnalyticsInstanceNetworkEndpointDetails',
    'AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn',
    'AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZone',
    'AnalyticsInstancePrivateAccessChannelPrivateSourceScanHost',
    'GetAnalyticsInstanceCapacityResult',
    'GetAnalyticsInstanceNetworkEndpointDetailResult',
    'GetAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult',
    'GetAnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneResult',
    'GetAnalyticsInstancePrivateAccessChannelPrivateSourceScanHostResult',
    'GetAnalyticsInstancesAnalyticsInstanceResult',
    'GetAnalyticsInstancesAnalyticsInstanceCapacityResult',
    'GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailResult',
    'GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult',
    'GetAnalyticsInstancesFilterResult',
]

@pulumi.output_type
class AnalyticsInstanceCapacity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityType":
            suggest = "capacity_type"
        elif key == "capacityValue":
            suggest = "capacity_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsInstanceCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsInstanceCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsInstanceCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_type: str,
                 capacity_value: int):
        """
        :param str capacity_type: The capacity model to use.
        :param int capacity_value: (Updatable) The capacity value selected (OLPU count, number of users, ...etc...). This parameter affects the number of CPUs, amount of memory or other resources allocated to the instance.
        """
        pulumi.set(__self__, "capacity_type", capacity_type)
        pulumi.set(__self__, "capacity_value", capacity_value)

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> str:
        """
        The capacity model to use.
        """
        return pulumi.get(self, "capacity_type")

    @property
    @pulumi.getter(name="capacityValue")
    def capacity_value(self) -> int:
        """
        (Updatable) The capacity value selected (OLPU count, number of users, ...etc...). This parameter affects the number of CPUs, amount of memory or other resources allocated to the instance.
        """
        return pulumi.get(self, "capacity_value")


@pulumi.output_type
class AnalyticsInstanceNetworkEndpointDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkEndpointType":
            suggest = "network_endpoint_type"
        elif key == "networkSecurityGroupIds":
            suggest = "network_security_group_ids"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vcnId":
            suggest = "vcn_id"
        elif key == "whitelistedIps":
            suggest = "whitelisted_ips"
        elif key == "whitelistedServices":
            suggest = "whitelisted_services"
        elif key == "whitelistedVcns":
            suggest = "whitelisted_vcns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsInstanceNetworkEndpointDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsInstanceNetworkEndpointDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsInstanceNetworkEndpointDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_endpoint_type: str,
                 network_security_group_ids: Optional[Sequence[str]] = None,
                 subnet_id: Optional[str] = None,
                 vcn_id: Optional[str] = None,
                 whitelisted_ips: Optional[Sequence[str]] = None,
                 whitelisted_services: Optional[Sequence[str]] = None,
                 whitelisted_vcns: Optional[Sequence['outputs.AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn']] = None):
        """
        :param str network_endpoint_type: The type of network endpoint.
        :param Sequence[str] network_security_group_ids: Network Security Group OCIDs for an Analytics instance.
        :param str subnet_id: The subnet OCID for the private endpoint.
        :param str vcn_id: The VCN OCID for the private endpoint.
        :param Sequence[str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        :param Sequence[str] whitelisted_services: Oracle Cloud Services that are allowed to access this Analytics instance.
        :param Sequence['AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcnArgs'] whitelisted_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        """
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        if network_security_group_ids is not None:
            pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vcn_id is not None:
            pulumi.set(__self__, "vcn_id", vcn_id)
        if whitelisted_ips is not None:
            pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)
        if whitelisted_services is not None:
            pulumi.set(__self__, "whitelisted_services", whitelisted_services)
        if whitelisted_vcns is not None:
            pulumi.set(__self__, "whitelisted_vcns", whitelisted_vcns)

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Optional[Sequence[str]]:
        """
        Network Security Group OCIDs for an Analytics instance.
        """
        return pulumi.get(self, "network_security_group_ids")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        The subnet OCID for the private endpoint.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> Optional[str]:
        """
        The VCN OCID for the private endpoint.
        """
        return pulumi.get(self, "vcn_id")

    @property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Optional[Sequence[str]]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")

    @property
    @pulumi.getter(name="whitelistedServices")
    def whitelisted_services(self) -> Optional[Sequence[str]]:
        """
        Oracle Cloud Services that are allowed to access this Analytics instance.
        """
        return pulumi.get(self, "whitelisted_services")

    @property
    @pulumi.getter(name="whitelistedVcns")
    def whitelisted_vcns(self) -> Optional[Sequence['outputs.AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn']]:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "whitelisted_vcns")


@pulumi.output_type
class AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "whitelistedIps":
            suggest = "whitelisted_ips"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 whitelisted_ips: Optional[Sequence[str]] = None):
        """
        :param str id: The Virtual Cloud Network OCID.
        :param Sequence[str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if whitelisted_ips is not None:
            pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Optional[Sequence[str]]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")


@pulumi.output_type
class AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsZone":
            suggest = "dns_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsInstancePrivateAccessChannelPrivateSourceDnsZone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_zone: str,
                 description: Optional[str] = None):
        """
        :param str dns_zone: (Updatable) Private Source DNS Zone. Ex: example-vcn.oraclevcn.com, corp.example.com.
        :param str description: (Updatable) Description of private source dns zone.
        """
        pulumi.set(__self__, "dns_zone", dns_zone)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> str:
        """
        (Updatable) Private Source DNS Zone. Ex: example-vcn.oraclevcn.com, corp.example.com.
        """
        return pulumi.get(self, "dns_zone")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        (Updatable) Description of private source dns zone.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class AnalyticsInstancePrivateAccessChannelPrivateSourceScanHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scanHostname":
            suggest = "scan_hostname"
        elif key == "scanPort":
            suggest = "scan_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnalyticsInstancePrivateAccessChannelPrivateSourceScanHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnalyticsInstancePrivateAccessChannelPrivateSourceScanHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnalyticsInstancePrivateAccessChannelPrivateSourceScanHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scan_hostname: str,
                 scan_port: int,
                 description: Optional[str] = None):
        """
        :param str scan_hostname: (Updatable) Private Source Scan hostname. Ex: db01-scan.corp.example.com, prd-db01-scan.mycompany.com.
        :param int scan_port: (Updatable) Private Source Scan host port. This is the source port where SCAN protocol will get connected (e.g. 1521).
        :param str description: (Updatable) Description of private source scan host zone.
        """
        pulumi.set(__self__, "scan_hostname", scan_hostname)
        pulumi.set(__self__, "scan_port", scan_port)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="scanHostname")
    def scan_hostname(self) -> str:
        """
        (Updatable) Private Source Scan hostname. Ex: db01-scan.corp.example.com, prd-db01-scan.mycompany.com.
        """
        return pulumi.get(self, "scan_hostname")

    @property
    @pulumi.getter(name="scanPort")
    def scan_port(self) -> int:
        """
        (Updatable) Private Source Scan host port. This is the source port where SCAN protocol will get connected (e.g. 1521).
        """
        return pulumi.get(self, "scan_port")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        (Updatable) Description of private source scan host zone.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetAnalyticsInstanceCapacityResult(dict):
    def __init__(__self__, *,
                 capacity_type: str,
                 capacity_value: int):
        """
        :param str capacity_type: The capacity model to use.
        :param int capacity_value: The capacity value selected (OLPU count, number of users, ...etc...). This parameter affects the number of CPUs, amount of memory or other resources allocated to the instance.
        """
        pulumi.set(__self__, "capacity_type", capacity_type)
        pulumi.set(__self__, "capacity_value", capacity_value)

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> str:
        """
        The capacity model to use.
        """
        return pulumi.get(self, "capacity_type")

    @property
    @pulumi.getter(name="capacityValue")
    def capacity_value(self) -> int:
        """
        The capacity value selected (OLPU count, number of users, ...etc...). This parameter affects the number of CPUs, amount of memory or other resources allocated to the instance.
        """
        return pulumi.get(self, "capacity_value")


@pulumi.output_type
class GetAnalyticsInstanceNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 network_endpoint_type: str,
                 network_security_group_ids: Sequence[str],
                 subnet_id: str,
                 vcn_id: str,
                 whitelisted_ips: Sequence[str],
                 whitelisted_services: Sequence[str],
                 whitelisted_vcns: Sequence['outputs.GetAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult']):
        """
        :param str network_endpoint_type: The type of network endpoint.
        :param Sequence[str] network_security_group_ids: Network Security Group OCIDs for an Analytics instance.
        :param str subnet_id: OCID of the customer subnet connected to private access channel.
        :param str vcn_id: OCID of the customer VCN peered with private access channel.
        :param Sequence[str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        :param Sequence[str] whitelisted_services: Oracle Cloud Services that are allowed to access this Analytics instance.
        :param Sequence['GetAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnArgs'] whitelisted_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        """
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)
        pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)
        pulumi.set(__self__, "whitelisted_services", whitelisted_services)
        pulumi.set(__self__, "whitelisted_vcns", whitelisted_vcns)

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[str]:
        """
        Network Security Group OCIDs for an Analytics instance.
        """
        return pulumi.get(self, "network_security_group_ids")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        OCID of the customer subnet connected to private access channel.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        OCID of the customer VCN peered with private access channel.
        """
        return pulumi.get(self, "vcn_id")

    @property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Sequence[str]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")

    @property
    @pulumi.getter(name="whitelistedServices")
    def whitelisted_services(self) -> Sequence[str]:
        """
        Oracle Cloud Services that are allowed to access this Analytics instance.
        """
        return pulumi.get(self, "whitelisted_services")

    @property
    @pulumi.getter(name="whitelistedVcns")
    def whitelisted_vcns(self) -> Sequence['outputs.GetAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "whitelisted_vcns")


@pulumi.output_type
class GetAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult(dict):
    def __init__(__self__, *,
                 id: str,
                 whitelisted_ips: Sequence[str]):
        """
        :param str id: The Virtual Cloud Network OCID.
        :param Sequence[str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Sequence[str]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")


@pulumi.output_type
class GetAnalyticsInstancePrivateAccessChannelPrivateSourceDnsZoneResult(dict):
    def __init__(__self__, *,
                 description: str,
                 dns_zone: str):
        """
        :param str description: Description of private source scan host zone.
        :param str dns_zone: Private Source DNS Zone. Ex: example-vcn.oraclevcn.com, corp.example.com.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dns_zone", dns_zone)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of private source scan host zone.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> str:
        """
        Private Source DNS Zone. Ex: example-vcn.oraclevcn.com, corp.example.com.
        """
        return pulumi.get(self, "dns_zone")


@pulumi.output_type
class GetAnalyticsInstancePrivateAccessChannelPrivateSourceScanHostResult(dict):
    def __init__(__self__, *,
                 description: str,
                 scan_hostname: str,
                 scan_port: int):
        """
        :param str description: Description of private source scan host zone.
        :param str scan_hostname: Private Source Scan hostname. Ex: db01-scan.corp.example.com, prd-db01-scan.mycompany.com.
        :param int scan_port: Private Source Scan host port. This is the source port where SCAN protocol will get connected (e.g. 1521).
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "scan_hostname", scan_hostname)
        pulumi.set(__self__, "scan_port", scan_port)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of private source scan host zone.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="scanHostname")
    def scan_hostname(self) -> str:
        """
        Private Source Scan hostname. Ex: db01-scan.corp.example.com, prd-db01-scan.mycompany.com.
        """
        return pulumi.get(self, "scan_hostname")

    @property
    @pulumi.getter(name="scanPort")
    def scan_port(self) -> int:
        """
        Private Source Scan host port. This is the source port where SCAN protocol will get connected (e.g. 1521).
        """
        return pulumi.get(self, "scan_port")


@pulumi.output_type
class GetAnalyticsInstancesAnalyticsInstanceResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceCapacityResult'],
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 email_notification: str,
                 feature_set: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 idcs_access_token: str,
                 kms_key_id: str,
                 license_type: str,
                 name: str,
                 network_endpoint_details: Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailResult'],
                 service_url: str,
                 state: str,
                 time_created: str,
                 time_updated: str):
        """
        :param Sequence['GetAnalyticsInstancesAnalyticsInstanceCapacityArgs'] capacities: Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        :param str compartment_id: The OCID of the compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: Description of the vanity url.
        :param str email_notification: Email address receiving notifications.
        :param str feature_set: A filter to only return resources matching the feature set. Values are case-insensitive.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: The Virtual Cloud Network OCID.
        :param str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        :param str license_type: The license used for the service.
        :param str name: A filter to return only resources that match the given name exactly.
        :param Sequence['GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailArgs'] network_endpoint_details: Base representation of a network endpoint.
        :param str service_url: URL of the Analytics service.
        :param str state: A filter to only return resources matching the lifecycle state. The state value is case-insensitive.
        :param str time_created: The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param str time_updated: The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "email_notification", email_notification)
        pulumi.set(__self__, "feature_set", feature_set)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "idcs_access_token", idcs_access_token)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "license_type", license_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_endpoint_details", network_endpoint_details)
        pulumi.set(__self__, "service_url", service_url)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceCapacityResult']:
        """
        Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the vanity url.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> str:
        """
        Email address receiving notifications.
        """
        return pulumi.get(self, "email_notification")

    @property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> str:
        """
        A filter to only return resources matching the feature set. Values are case-insensitive.
        """
        return pulumi.get(self, "feature_set")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> str:
        return pulumi.get(self, "idcs_access_token")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. A null value indicates Oracle managed default encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> str:
        """
        The license used for the service.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailResult']:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> str:
        """
        URL of the Analytics service.
        """
        return pulumi.get(self, "service_url")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to only return resources matching the lifecycle state. The state value is case-insensitive.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetAnalyticsInstancesAnalyticsInstanceCapacityResult(dict):
    def __init__(__self__, *,
                 capacity_type: str,
                 capacity_value: int):
        """
        :param str capacity_type: A filter to only return resources matching the capacity type enum. Values are case-insensitive.
        :param int capacity_value: The capacity value selected (OLPU count, number of users, ...etc...). This parameter affects the number of CPUs, amount of memory or other resources allocated to the instance.
        """
        pulumi.set(__self__, "capacity_type", capacity_type)
        pulumi.set(__self__, "capacity_value", capacity_value)

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> str:
        """
        A filter to only return resources matching the capacity type enum. Values are case-insensitive.
        """
        return pulumi.get(self, "capacity_type")

    @property
    @pulumi.getter(name="capacityValue")
    def capacity_value(self) -> int:
        """
        The capacity value selected (OLPU count, number of users, ...etc...). This parameter affects the number of CPUs, amount of memory or other resources allocated to the instance.
        """
        return pulumi.get(self, "capacity_value")


@pulumi.output_type
class GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailResult(dict):
    def __init__(__self__, *,
                 network_endpoint_type: str,
                 network_security_group_ids: Sequence[str],
                 subnet_id: str,
                 vcn_id: str,
                 whitelisted_ips: Sequence[str],
                 whitelisted_services: Sequence[str],
                 whitelisted_vcns: Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult']):
        """
        :param str network_endpoint_type: The type of network endpoint.
        :param Sequence[str] network_security_group_ids: Network Security Group OCIDs for an Analytics instance.
        :param str subnet_id: OCID of the customer subnet connected to private access channel.
        :param str vcn_id: OCID of the customer VCN peered with private access channel.
        :param Sequence[str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        :param Sequence[str] whitelisted_services: Oracle Cloud Services that are allowed to access this Analytics instance.
        :param Sequence['GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnArgs'] whitelisted_vcns: Virtual Cloud Networks allowed to access this network endpoint.
        """
        pulumi.set(__self__, "network_endpoint_type", network_endpoint_type)
        pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)
        pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)
        pulumi.set(__self__, "whitelisted_services", whitelisted_services)
        pulumi.set(__self__, "whitelisted_vcns", whitelisted_vcns)

    @property
    @pulumi.getter(name="networkEndpointType")
    def network_endpoint_type(self) -> str:
        """
        The type of network endpoint.
        """
        return pulumi.get(self, "network_endpoint_type")

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Sequence[str]:
        """
        Network Security Group OCIDs for an Analytics instance.
        """
        return pulumi.get(self, "network_security_group_ids")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        OCID of the customer subnet connected to private access channel.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        OCID of the customer VCN peered with private access channel.
        """
        return pulumi.get(self, "vcn_id")

    @property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Sequence[str]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")

    @property
    @pulumi.getter(name="whitelistedServices")
    def whitelisted_services(self) -> Sequence[str]:
        """
        Oracle Cloud Services that are allowed to access this Analytics instance.
        """
        return pulumi.get(self, "whitelisted_services")

    @property
    @pulumi.getter(name="whitelistedVcns")
    def whitelisted_vcns(self) -> Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult']:
        """
        Virtual Cloud Networks allowed to access this network endpoint.
        """
        return pulumi.get(self, "whitelisted_vcns")


@pulumi.output_type
class GetAnalyticsInstancesAnalyticsInstanceNetworkEndpointDetailWhitelistedVcnResult(dict):
    def __init__(__self__, *,
                 id: str,
                 whitelisted_ips: Sequence[str]):
        """
        :param str id: The Virtual Cloud Network OCID.
        :param Sequence[str] whitelisted_ips: Source IP addresses or IP address ranges in ingress rules.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "whitelisted_ips", whitelisted_ips)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Virtual Cloud Network OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="whitelistedIps")
    def whitelisted_ips(self) -> Sequence[str]:
        """
        Source IP addresses or IP address ranges in ingress rules.
        """
        return pulumi.get(self, "whitelisted_ips")


@pulumi.output_type
class GetAnalyticsInstancesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the given name exactly.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


