# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceApplicationScheduleArgs', 'WorkspaceApplicationSchedule']

@pulumi.input_type
class WorkspaceApplicationScheduleArgs:
    def __init__(__self__, *,
                 application_key: pulumi.Input[str],
                 identifier: pulumi.Input[str],
                 workspace_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 frequency_details: Optional[pulumi.Input['WorkspaceApplicationScheduleFrequencyDetailsArgs']] = None,
                 is_daylight_adjustment_enabled: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 object_version: Optional[pulumi.Input[int]] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceApplicationScheduleRegistryMetadataArgs']] = None,
                 timezone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WorkspaceApplicationSchedule resource.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input['WorkspaceApplicationScheduleFrequencyDetailsArgs'] frequency_details: (Updatable) The model that holds the frequency details.
        :param pulumi.Input[bool] is_daylight_adjustment_enabled: (Updatable) A flag to indicate whether daylight adjustment should be considered or not.
        :param pulumi.Input[str] key: (Updatable) Generated key that can be used in API calls to identify schedule. On scenarios where reference to the schedule is needed, a value can be passed in create.
        :param pulumi.Input[str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input['WorkspaceApplicationScheduleRegistryMetadataArgs'] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[str] timezone: (Updatable) The timezone for the schedule.
        """
        pulumi.set(__self__, "application_key", application_key)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if frequency_details is not None:
            pulumi.set(__self__, "frequency_details", frequency_details)
        if is_daylight_adjustment_enabled is not None:
            pulumi.set(__self__, "is_daylight_adjustment_enabled", is_daylight_adjustment_enabled)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Input[str]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_key", value)

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Input[str]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "workspace_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="frequencyDetails")
    def frequency_details(self) -> Optional[pulumi.Input['WorkspaceApplicationScheduleFrequencyDetailsArgs']]:
        """
        (Updatable) The model that holds the frequency details.
        """
        return pulumi.get(self, "frequency_details")

    @frequency_details.setter
    def frequency_details(self, value: Optional[pulumi.Input['WorkspaceApplicationScheduleFrequencyDetailsArgs']]):
        pulumi.set(self, "frequency_details", value)

    @property
    @pulumi.getter(name="isDaylightAdjustmentEnabled")
    def is_daylight_adjustment_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A flag to indicate whether daylight adjustment should be considered or not.
        """
        return pulumi.get(self, "is_daylight_adjustment_enabled")

    @is_daylight_adjustment_enabled.setter
    def is_daylight_adjustment_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_daylight_adjustment_enabled", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Generated key that can be used in API calls to identify schedule. On scenarios where reference to the schedule is needed, a value can be passed in create.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_status", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_version", value)

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceApplicationScheduleRegistryMetadataArgs']]:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceApplicationScheduleRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The timezone for the schedule.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)


@pulumi.input_type
class _WorkspaceApplicationScheduleState:
    def __init__(__self__, *,
                 application_key: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 frequency_details: Optional[pulumi.Input['WorkspaceApplicationScheduleFrequencyDetailsArgs']] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 is_daylight_adjustment_enabled: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 metadatas: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationScheduleMetadataArgs']]]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 object_version: Optional[pulumi.Input[int]] = None,
                 parent_reves: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationScheduleParentRefArgs']]]] = None,
                 registry_metadata: Optional[pulumi.Input['WorkspaceApplicationScheduleRegistryMetadataArgs']] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceApplicationSchedule resources.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input['WorkspaceApplicationScheduleFrequencyDetailsArgs'] frequency_details: (Updatable) The model that holds the frequency details.
        :param pulumi.Input[str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[bool] is_daylight_adjustment_enabled: (Updatable) A flag to indicate whether daylight adjustment should be considered or not.
        :param pulumi.Input[str] key: (Updatable) Generated key that can be used in API calls to identify schedule. On scenarios where reference to the schedule is needed, a value can be passed in create.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationScheduleMetadataArgs']]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[str] model_type: The type of the object.
        :param pulumi.Input[str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationScheduleParentRefArgs']]] parent_reves: A reference to the object's parent.
        :param pulumi.Input['WorkspaceApplicationScheduleRegistryMetadataArgs'] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[str] timezone: (Updatable) The timezone for the schedule.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if application_key is not None:
            pulumi.set(__self__, "application_key", application_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if frequency_details is not None:
            pulumi.set(__self__, "frequency_details", frequency_details)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if is_daylight_adjustment_enabled is not None:
            pulumi.set(__self__, "is_daylight_adjustment_enabled", is_daylight_adjustment_enabled)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if metadatas is not None:
            pulumi.set(__self__, "metadatas", metadatas)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_status is not None:
            pulumi.set(__self__, "object_status", object_status)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)
        if parent_reves is not None:
            pulumi.set(__self__, "parent_reves", parent_reves)
        if registry_metadata is not None:
            pulumi.set(__self__, "registry_metadata", registry_metadata)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> Optional[pulumi.Input[str]]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @application_key.setter
    def application_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_key", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="frequencyDetails")
    def frequency_details(self) -> Optional[pulumi.Input['WorkspaceApplicationScheduleFrequencyDetailsArgs']]:
        """
        (Updatable) The model that holds the frequency details.
        """
        return pulumi.get(self, "frequency_details")

    @frequency_details.setter
    def frequency_details(self, value: Optional[pulumi.Input['WorkspaceApplicationScheduleFrequencyDetailsArgs']]):
        pulumi.set(self, "frequency_details", value)

    @property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "identifier", value)

    @property
    @pulumi.getter(name="isDaylightAdjustmentEnabled")
    def is_daylight_adjustment_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A flag to indicate whether daylight adjustment should be considered or not.
        """
        return pulumi.get(self, "is_daylight_adjustment_enabled")

    @is_daylight_adjustment_enabled.setter
    def is_daylight_adjustment_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_daylight_adjustment_enabled", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Generated key that can be used in API calls to identify schedule. On scenarios where reference to the schedule is needed, a value can be passed in create.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def metadatas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationScheduleMetadataArgs']]]]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @metadatas.setter
    def metadatas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationScheduleMetadataArgs']]]]):
        pulumi.set(self, "metadatas", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the object.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @object_status.setter
    def object_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_status", value)

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @object_version.setter
    def object_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "object_version", value)

    @property
    @pulumi.getter(name="parentReves")
    def parent_reves(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationScheduleParentRefArgs']]]]:
        """
        A reference to the object's parent.
        """
        return pulumi.get(self, "parent_reves")

    @parent_reves.setter
    def parent_reves(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkspaceApplicationScheduleParentRefArgs']]]]):
        pulumi.set(self, "parent_reves", value)

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> Optional[pulumi.Input['WorkspaceApplicationScheduleRegistryMetadataArgs']]:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @registry_metadata.setter
    def registry_metadata(self, value: Optional[pulumi.Input['WorkspaceApplicationScheduleRegistryMetadataArgs']]):
        pulumi.set(self, "registry_metadata", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The timezone for the schedule.
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[str]]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace_id", value)


class WorkspaceApplicationSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_key: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 frequency_details: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleFrequencyDetailsArgs']]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 is_daylight_adjustment_enabled: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 object_version: Optional[pulumi.Input[int]] = None,
                 registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleRegistryMetadataArgs']]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Workspace Application Schedule resource in Oracle Cloud Infrastructure Data Integration service.

        Endpoint to create a new schedule

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_application_schedule = oci.data_integration.WorkspaceApplicationSchedule("test_workspace_application_schedule",
            application_key=workspace_application_schedule_application_key,
            identifier=workspace_application_schedule_identifier,
            name=workspace_application_schedule_name,
            workspace_id=test_workspace["id"],
            description=workspace_application_schedule_description,
            frequency_details=oci.data_integration.WorkspaceApplicationScheduleFrequencyDetailsArgs(
                model_type=workspace_application_schedule_frequency_details_model_type,
                custom_expression=workspace_application_schedule_frequency_details_custom_expression,
                day_of_week=workspace_application_schedule_frequency_details_day_of_week,
                days=workspace_application_schedule_frequency_details_days,
                frequency=workspace_application_schedule_frequency_details_frequency,
                interval=workspace_application_schedule_frequency_details_interval,
                time=oci.data_integration.WorkspaceApplicationScheduleFrequencyDetailsTimeArgs(
                    hour=workspace_application_schedule_frequency_details_time_hour,
                    minute=workspace_application_schedule_frequency_details_time_minute,
                    second=workspace_application_schedule_frequency_details_time_second,
                ),
                week_of_month=workspace_application_schedule_frequency_details_week_of_month,
            ),
            is_daylight_adjustment_enabled=workspace_application_schedule_is_daylight_adjustment_enabled,
            key=workspace_application_schedule_key,
            model_version=workspace_application_schedule_model_version,
            object_status=workspace_application_schedule_object_status,
            object_version=workspace_application_schedule_object_version,
            registry_metadata=oci.data_integration.WorkspaceApplicationScheduleRegistryMetadataArgs(
                aggregator_key=workspace_application_schedule_registry_metadata_aggregator_key,
                is_favorite=workspace_application_schedule_registry_metadata_is_favorite,
                key=workspace_application_schedule_registry_metadata_key,
                labels=workspace_application_schedule_registry_metadata_labels,
                registry_version=workspace_application_schedule_registry_metadata_registry_version,
            ),
            timezone=workspace_application_schedule_timezone)
        ```

        ## Import

        WorkspaceApplicationSchedules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceApplicationSchedule:WorkspaceApplicationSchedule test_workspace_application_schedule "workspaces/{workspaceId}/applications/{applicationKey}/schedules/{scheduleKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleFrequencyDetailsArgs']] frequency_details: (Updatable) The model that holds the frequency details.
        :param pulumi.Input[str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[bool] is_daylight_adjustment_enabled: (Updatable) A flag to indicate whether daylight adjustment should be considered or not.
        :param pulumi.Input[str] key: (Updatable) Generated key that can be used in API calls to identify schedule. On scenarios where reference to the schedule is needed, a value can be passed in create.
        :param pulumi.Input[str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleRegistryMetadataArgs']] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[str] timezone: (Updatable) The timezone for the schedule.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceApplicationScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Workspace Application Schedule resource in Oracle Cloud Infrastructure Data Integration service.

        Endpoint to create a new schedule

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_workspace_application_schedule = oci.data_integration.WorkspaceApplicationSchedule("test_workspace_application_schedule",
            application_key=workspace_application_schedule_application_key,
            identifier=workspace_application_schedule_identifier,
            name=workspace_application_schedule_name,
            workspace_id=test_workspace["id"],
            description=workspace_application_schedule_description,
            frequency_details=oci.data_integration.WorkspaceApplicationScheduleFrequencyDetailsArgs(
                model_type=workspace_application_schedule_frequency_details_model_type,
                custom_expression=workspace_application_schedule_frequency_details_custom_expression,
                day_of_week=workspace_application_schedule_frequency_details_day_of_week,
                days=workspace_application_schedule_frequency_details_days,
                frequency=workspace_application_schedule_frequency_details_frequency,
                interval=workspace_application_schedule_frequency_details_interval,
                time=oci.data_integration.WorkspaceApplicationScheduleFrequencyDetailsTimeArgs(
                    hour=workspace_application_schedule_frequency_details_time_hour,
                    minute=workspace_application_schedule_frequency_details_time_minute,
                    second=workspace_application_schedule_frequency_details_time_second,
                ),
                week_of_month=workspace_application_schedule_frequency_details_week_of_month,
            ),
            is_daylight_adjustment_enabled=workspace_application_schedule_is_daylight_adjustment_enabled,
            key=workspace_application_schedule_key,
            model_version=workspace_application_schedule_model_version,
            object_status=workspace_application_schedule_object_status,
            object_version=workspace_application_schedule_object_version,
            registry_metadata=oci.data_integration.WorkspaceApplicationScheduleRegistryMetadataArgs(
                aggregator_key=workspace_application_schedule_registry_metadata_aggregator_key,
                is_favorite=workspace_application_schedule_registry_metadata_is_favorite,
                key=workspace_application_schedule_registry_metadata_key,
                labels=workspace_application_schedule_registry_metadata_labels,
                registry_version=workspace_application_schedule_registry_metadata_registry_version,
            ),
            timezone=workspace_application_schedule_timezone)
        ```

        ## Import

        WorkspaceApplicationSchedules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataIntegration/workspaceApplicationSchedule:WorkspaceApplicationSchedule test_workspace_application_schedule "workspaces/{workspaceId}/applications/{applicationKey}/schedules/{scheduleKey}"
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceApplicationScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceApplicationScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_key: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 frequency_details: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleFrequencyDetailsArgs']]] = None,
                 identifier: Optional[pulumi.Input[str]] = None,
                 is_daylight_adjustment_enabled: Optional[pulumi.Input[bool]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_status: Optional[pulumi.Input[int]] = None,
                 object_version: Optional[pulumi.Input[int]] = None,
                 registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleRegistryMetadataArgs']]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 workspace_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceApplicationScheduleArgs.__new__(WorkspaceApplicationScheduleArgs)

            if application_key is None and not opts.urn:
                raise TypeError("Missing required property 'application_key'")
            __props__.__dict__["application_key"] = application_key
            __props__.__dict__["description"] = description
            __props__.__dict__["frequency_details"] = frequency_details
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["is_daylight_adjustment_enabled"] = is_daylight_adjustment_enabled
            __props__.__dict__["key"] = key
            __props__.__dict__["model_version"] = model_version
            __props__.__dict__["name"] = name
            __props__.__dict__["object_status"] = object_status
            __props__.__dict__["object_version"] = object_version
            __props__.__dict__["registry_metadata"] = registry_metadata
            __props__.__dict__["timezone"] = timezone
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["metadatas"] = None
            __props__.__dict__["model_type"] = None
            __props__.__dict__["parent_reves"] = None
        super(WorkspaceApplicationSchedule, __self__).__init__(
            'oci:DataIntegration/workspaceApplicationSchedule:WorkspaceApplicationSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_key: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            frequency_details: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleFrequencyDetailsArgs']]] = None,
            identifier: Optional[pulumi.Input[str]] = None,
            is_daylight_adjustment_enabled: Optional[pulumi.Input[bool]] = None,
            key: Optional[pulumi.Input[str]] = None,
            metadatas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleMetadataArgs']]]]] = None,
            model_type: Optional[pulumi.Input[str]] = None,
            model_version: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            object_status: Optional[pulumi.Input[int]] = None,
            object_version: Optional[pulumi.Input[int]] = None,
            parent_reves: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleParentRefArgs']]]]] = None,
            registry_metadata: Optional[pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleRegistryMetadataArgs']]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            workspace_id: Optional[pulumi.Input[str]] = None) -> 'WorkspaceApplicationSchedule':
        """
        Get an existing WorkspaceApplicationSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_key: The application key.
        :param pulumi.Input[str] description: (Updatable) Detailed description for the object.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleFrequencyDetailsArgs']] frequency_details: (Updatable) The model that holds the frequency details.
        :param pulumi.Input[str] identifier: (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        :param pulumi.Input[bool] is_daylight_adjustment_enabled: (Updatable) A flag to indicate whether daylight adjustment should be considered or not.
        :param pulumi.Input[str] key: (Updatable) Generated key that can be used in API calls to identify schedule. On scenarios where reference to the schedule is needed, a value can be passed in create.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleMetadataArgs']]]] metadatas: A summary type containing information about the object including its key, name and when/who created/updated it.
        :param pulumi.Input[str] model_type: The type of the object.
        :param pulumi.Input[str] model_version: (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        :param pulumi.Input[str] name: (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        :param pulumi.Input[int] object_status: (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        :param pulumi.Input[int] object_version: (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleParentRefArgs']]]] parent_reves: A reference to the object's parent.
        :param pulumi.Input[pulumi.InputType['WorkspaceApplicationScheduleRegistryMetadataArgs']] registry_metadata: (Updatable) Information about the object and its parent.
        :param pulumi.Input[str] timezone: (Updatable) The timezone for the schedule.
        :param pulumi.Input[str] workspace_id: The workspace ID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceApplicationScheduleState.__new__(_WorkspaceApplicationScheduleState)

        __props__.__dict__["application_key"] = application_key
        __props__.__dict__["description"] = description
        __props__.__dict__["frequency_details"] = frequency_details
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["is_daylight_adjustment_enabled"] = is_daylight_adjustment_enabled
        __props__.__dict__["key"] = key
        __props__.__dict__["metadatas"] = metadatas
        __props__.__dict__["model_type"] = model_type
        __props__.__dict__["model_version"] = model_version
        __props__.__dict__["name"] = name
        __props__.__dict__["object_status"] = object_status
        __props__.__dict__["object_version"] = object_version
        __props__.__dict__["parent_reves"] = parent_reves
        __props__.__dict__["registry_metadata"] = registry_metadata
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceApplicationSchedule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> pulumi.Output[str]:
        """
        The application key.
        """
        return pulumi.get(self, "application_key")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Detailed description for the object.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="frequencyDetails")
    def frequency_details(self) -> pulumi.Output['outputs.WorkspaceApplicationScheduleFrequencyDetails']:
        """
        (Updatable) The model that holds the frequency details.
        """
        return pulumi.get(self, "frequency_details")

    @property
    @pulumi.getter
    def identifier(self) -> pulumi.Output[str]:
        """
        (Updatable) Value can only contain upper case letters, underscore, and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="isDaylightAdjustmentEnabled")
    def is_daylight_adjustment_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) A flag to indicate whether daylight adjustment should be considered or not.
        """
        return pulumi.get(self, "is_daylight_adjustment_enabled")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        (Updatable) Generated key that can be used in API calls to identify schedule. On scenarios where reference to the schedule is needed, a value can be passed in create.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def metadatas(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationScheduleMetadata']]:
        """
        A summary type containing information about the object including its key, name and when/who created/updated it.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Output[str]:
        """
        The type of the object.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> pulumi.Output[str]:
        """
        (Updatable) This is a version number that is used by the service to upgrade objects if needed through releases of the service.
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectStatus")
    def object_status(self) -> pulumi.Output[int]:
        """
        (Updatable) The status of an object that can be set to value 1 for shallow references across objects, other values reserved.
        """
        return pulumi.get(self, "object_status")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> pulumi.Output[int]:
        """
        (Updatable) This is used by the service for optimistic locking of the object, to prevent multiple users from simultaneously updating the object.
        """
        return pulumi.get(self, "object_version")

    @property
    @pulumi.getter(name="parentReves")
    def parent_reves(self) -> pulumi.Output[Sequence['outputs.WorkspaceApplicationScheduleParentRef']]:
        """
        A reference to the object's parent.
        """
        return pulumi.get(self, "parent_reves")

    @property
    @pulumi.getter(name="registryMetadata")
    def registry_metadata(self) -> pulumi.Output['outputs.WorkspaceApplicationScheduleRegistryMetadata']:
        """
        (Updatable) Information about the object and its parent.
        """
        return pulumi.get(self, "registry_metadata")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[str]:
        """
        (Updatable) The timezone for the schedule.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[str]:
        """
        The workspace ID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workspace_id")

