# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDomainsResult',
    'AwaitableGetDomainsResult',
    'get_domains',
    'get_domains_output',
]

@pulumi.output_type
class GetDomainsResult:
    """
    A collection of values returned by getDomains.
    """
    def __init__(__self__, compartment_id=None, display_name=None, domains=None, filters=None, home_region_url=None, id=None, is_hidden_on_login=None, license_type=None, name=None, state=None, type=None, url=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if home_region_url and not isinstance(home_region_url, str):
            raise TypeError("Expected argument 'home_region_url' to be a str")
        pulumi.set(__self__, "home_region_url", home_region_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_hidden_on_login and not isinstance(is_hidden_on_login, bool):
            raise TypeError("Expected argument 'is_hidden_on_login' to be a bool")
        pulumi.set(__self__, "is_hidden_on_login", is_hidden_on_login)
        if license_type and not isinstance(license_type, str):
            raise TypeError("Expected argument 'license_type' to be a str")
        pulumi.set(__self__, "license_type", license_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the domain.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The mutable display name of the domain
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def domains(self) -> Sequence['outputs.GetDomainsDomainResult']:
        """
        The list of domains.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDomainsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="homeRegionUrl")
    def home_region_url(self) -> Optional[str]:
        """
        Region specific domain URL.
        """
        return pulumi.get(self, "home_region_url")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isHiddenOnLogin")
    def is_hidden_on_login(self) -> Optional[bool]:
        """
        Indicates whether domain is hidden on login screen or not.
        """
        return pulumi.get(self, "is_hidden_on_login")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[str]:
        """
        The License type of Domain
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the domain.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        Region agnostic domain URL.
        """
        return pulumi.get(self, "url")


class AwaitableGetDomainsResult(GetDomainsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            domains=self.domains,
            filters=self.filters,
            home_region_url=self.home_region_url,
            id=self.id,
            is_hidden_on_login=self.is_hidden_on_login,
            license_type=self.license_type,
            name=self.name,
            state=self.state,
            type=self.type,
            url=self.url)


def get_domains(compartment_id: Optional[str] = None,
                display_name: Optional[str] = None,
                filters: Optional[Sequence[pulumi.InputType['GetDomainsFilterArgs']]] = None,
                home_region_url: Optional[str] = None,
                is_hidden_on_login: Optional[bool] = None,
                license_type: Optional[str] = None,
                name: Optional[str] = None,
                state: Optional[str] = None,
                type: Optional[str] = None,
                url: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainsResult:
    """
    This data source provides the list of Domains in Oracle Cloud Infrastructure Identity service.

    List all domains that are homed or have a replica region in current region.
    - If any internal error occurs, return 500 INTERNAL SERVER ERROR.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_domains = oci.Identity.get_domains(compartment_id=compartment_id,
        display_name=domain_display_name,
        home_region_url=domain_home_region_url,
        is_hidden_on_login=domain_is_hidden_on_login,
        license_type=domain_license_type,
        name=domain_name,
        state=domain_state,
        type=domain_type,
        url=domain_url)
    ```


    :param str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param str display_name: The mutable display name of the domain
    :param str home_region_url: The region specific domain URL
    :param bool is_hidden_on_login: Indicate if the domain is visible at login screen or not
    :param str license_type: The domain license type
    :param str name: A filter to only return resources that match the given name exactly.
    :param str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    :param str type: The domain type
    :param str url: The region agnostic domain URL
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['homeRegionUrl'] = home_region_url
    __args__['isHiddenOnLogin'] = is_hidden_on_login
    __args__['licenseType'] = license_type
    __args__['name'] = name
    __args__['state'] = state
    __args__['type'] = type
    __args__['url'] = url
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getDomains:getDomains', __args__, opts=opts, typ=GetDomainsResult).value

    return AwaitableGetDomainsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        domains=pulumi.get(__ret__, 'domains'),
        filters=pulumi.get(__ret__, 'filters'),
        home_region_url=pulumi.get(__ret__, 'home_region_url'),
        id=pulumi.get(__ret__, 'id'),
        is_hidden_on_login=pulumi.get(__ret__, 'is_hidden_on_login'),
        license_type=pulumi.get(__ret__, 'license_type'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        type=pulumi.get(__ret__, 'type'),
        url=pulumi.get(__ret__, 'url'))


@_utilities.lift_output_func(get_domains)
def get_domains_output(compartment_id: Optional[pulumi.Input[str]] = None,
                       display_name: Optional[pulumi.Input[Optional[str]]] = None,
                       filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDomainsFilterArgs']]]]] = None,
                       home_region_url: Optional[pulumi.Input[Optional[str]]] = None,
                       is_hidden_on_login: Optional[pulumi.Input[Optional[bool]]] = None,
                       license_type: Optional[pulumi.Input[Optional[str]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       state: Optional[pulumi.Input[Optional[str]]] = None,
                       type: Optional[pulumi.Input[Optional[str]]] = None,
                       url: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDomainsResult]:
    """
    This data source provides the list of Domains in Oracle Cloud Infrastructure Identity service.

    List all domains that are homed or have a replica region in current region.
    - If any internal error occurs, return 500 INTERNAL SERVER ERROR.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_domains = oci.Identity.get_domains(compartment_id=compartment_id,
        display_name=domain_display_name,
        home_region_url=domain_home_region_url,
        is_hidden_on_login=domain_is_hidden_on_login,
        license_type=domain_license_type,
        name=domain_name,
        state=domain_state,
        type=domain_type,
        url=domain_url)
    ```


    :param str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    :param str display_name: The mutable display name of the domain
    :param str home_region_url: The region specific domain URL
    :param bool is_hidden_on_login: Indicate if the domain is visible at login screen or not
    :param str license_type: The domain license type
    :param str name: A filter to only return resources that match the given name exactly.
    :param str state: A filter to only return resources that match the given lifecycle state.  The state value is case-insensitive.
    :param str type: The domain type
    :param str url: The region agnostic domain URL
    """
    ...
