# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetOpensearchVersionsResult',
    'AwaitableGetOpensearchVersionsResult',
    'get_opensearch_versions',
    'get_opensearch_versions_output',
]

@pulumi.output_type
class GetOpensearchVersionsResult:
    """
    A collection of values returned by getOpensearchVersions.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, opensearch_versions_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if opensearch_versions_collections and not isinstance(opensearch_versions_collections, list):
            raise TypeError("Expected argument 'opensearch_versions_collections' to be a list")
        pulumi.set(__self__, "opensearch_versions_collections", opensearch_versions_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetOpensearchVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="opensearchVersionsCollections")
    def opensearch_versions_collections(self) -> Sequence['outputs.GetOpensearchVersionsOpensearchVersionsCollectionResult']:
        """
        The list of opensearch_versions_collection.
        """
        return pulumi.get(self, "opensearch_versions_collections")


class AwaitableGetOpensearchVersionsResult(GetOpensearchVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpensearchVersionsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            opensearch_versions_collections=self.opensearch_versions_collections)


def get_opensearch_versions(compartment_id: Optional[str] = None,
                            filters: Optional[Sequence[pulumi.InputType['GetOpensearchVersionsFilterArgs']]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpensearchVersionsResult:
    """
    This data source provides the list of Opensearch Versions in Oracle Cloud Infrastructure Opensearch service.

    Lists the supported Opensearch versions

    ## Prerequisites

    The below policies must be created in compartment before creating OpensearchCluster

    ##### {Compartment-Name} - Name of  your compartment

    For latest documentation on OpenSearch use please refer to https://docs.oracle.com/en-us/iaas/Content/search-opensearch/home.htm\\
    Required permissions: https://docs.oracle.com/en-us/iaas/Content/search-opensearch/Concepts/ocisearchpermissions.htm

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opensearch_versions = oci.Opensearch.get_opensearch_versions(compartment_id=compartment_id)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opensearch/getOpensearchVersions:getOpensearchVersions', __args__, opts=opts, typ=GetOpensearchVersionsResult).value

    return AwaitableGetOpensearchVersionsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        opensearch_versions_collections=pulumi.get(__ret__, 'opensearch_versions_collections'))


@_utilities.lift_output_func(get_opensearch_versions)
def get_opensearch_versions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetOpensearchVersionsFilterArgs']]]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOpensearchVersionsResult]:
    """
    This data source provides the list of Opensearch Versions in Oracle Cloud Infrastructure Opensearch service.

    Lists the supported Opensearch versions

    ## Prerequisites

    The below policies must be created in compartment before creating OpensearchCluster

    ##### {Compartment-Name} - Name of  your compartment

    For latest documentation on OpenSearch use please refer to https://docs.oracle.com/en-us/iaas/Content/search-opensearch/home.htm\\
    Required permissions: https://docs.oracle.com/en-us/iaas/Content/search-opensearch/Concepts/ocisearchpermissions.htm

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opensearch_versions = oci.Opensearch.get_opensearch_versions(compartment_id=compartment_id)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    """
    ...
