# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetConfigurationResult',
    'AwaitableGetConfigurationResult',
    'get_configuration',
    'get_configuration_output',
]

@pulumi.output_type
class GetConfigurationResult:
    """
    A collection of values returned by getConfiguration.
    """
    def __init__(__self__, compartment_id=None, configuration_details=None, configuration_id=None, db_configuration_overrides=None, db_version=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, instance_memory_size_in_gbs=None, instance_ocpu_count=None, lifecycle_details=None, shape=None, state=None, system_tags=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_details and not isinstance(configuration_details, list):
            raise TypeError("Expected argument 'configuration_details' to be a list")
        pulumi.set(__self__, "configuration_details", configuration_details)
        if configuration_id and not isinstance(configuration_id, str):
            raise TypeError("Expected argument 'configuration_id' to be a str")
        pulumi.set(__self__, "configuration_id", configuration_id)
        if db_configuration_overrides and not isinstance(db_configuration_overrides, list):
            raise TypeError("Expected argument 'db_configuration_overrides' to be a list")
        pulumi.set(__self__, "db_configuration_overrides", db_configuration_overrides)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_memory_size_in_gbs and not isinstance(instance_memory_size_in_gbs, int):
            raise TypeError("Expected argument 'instance_memory_size_in_gbs' to be a int")
        pulumi.set(__self__, "instance_memory_size_in_gbs", instance_memory_size_in_gbs)
        if instance_ocpu_count and not isinstance(instance_ocpu_count, int):
            raise TypeError("Expected argument 'instance_ocpu_count' to be a int")
        pulumi.set(__self__, "instance_ocpu_count", instance_ocpu_count)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if shape and not isinstance(shape, str):
            raise TypeError("Expected argument 'shape' to be a str")
        pulumi.set(__self__, "shape", shape)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the configuration.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationDetails")
    def configuration_details(self) -> Sequence['outputs.GetConfigurationConfigurationDetailResult']:
        """
        List of configuration details.
        """
        return pulumi.get(self, "configuration_details")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> str:
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter(name="dbConfigurationOverrides")
    def db_configuration_overrides(self) -> Sequence['outputs.GetConfigurationDbConfigurationOverrideResult']:
        return pulumi.get(self, "db_configuration_overrides")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> str:
        """
        Version of the PostgreSQL database.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description for the configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly display name for the configuration. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A unique identifier for the configuration. Immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceMemorySizeInGbs")
    def instance_memory_size_in_gbs(self) -> int:
        """
        Memory size in gigabytes with 1GB increment.
        """
        return pulumi.get(self, "instance_memory_size_in_gbs")

    @property
    @pulumi.getter(name="instanceOcpuCount")
    def instance_ocpu_count(self) -> int:
        """
        CPU core count.
        """
        return pulumi.get(self, "instance_ocpu_count")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        The name of the shape for the configuration. Example: `VM.Standard.E4.Flex`
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the configuration.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time that the configuration was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetConfigurationResult(GetConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationResult(
            compartment_id=self.compartment_id,
            configuration_details=self.configuration_details,
            configuration_id=self.configuration_id,
            db_configuration_overrides=self.db_configuration_overrides,
            db_version=self.db_version,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            instance_memory_size_in_gbs=self.instance_memory_size_in_gbs,
            instance_ocpu_count=self.instance_ocpu_count,
            lifecycle_details=self.lifecycle_details,
            shape=self.shape,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created)


def get_configuration(configuration_id: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationResult:
    """
    This data source provides details about a specific Configuration resource in Oracle Cloud Infrastructure Psql service.

    Gets a configuration by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_configuration = oci.Psql.get_configuration(configuration_id=test_configuration_oci_psql_configuration["id"])
    ```


    :param str configuration_id: A unique identifier for the configuration.
    """
    __args__ = dict()
    __args__['configurationId'] = configuration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Psql/getConfiguration:getConfiguration', __args__, opts=opts, typ=GetConfigurationResult).value

    return AwaitableGetConfigurationResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configuration_details=pulumi.get(__ret__, 'configuration_details'),
        configuration_id=pulumi.get(__ret__, 'configuration_id'),
        db_configuration_overrides=pulumi.get(__ret__, 'db_configuration_overrides'),
        db_version=pulumi.get(__ret__, 'db_version'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        instance_memory_size_in_gbs=pulumi.get(__ret__, 'instance_memory_size_in_gbs'),
        instance_ocpu_count=pulumi.get(__ret__, 'instance_ocpu_count'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        shape=pulumi.get(__ret__, 'shape'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_configuration)
def get_configuration_output(configuration_id: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConfigurationResult]:
    """
    This data source provides details about a specific Configuration resource in Oracle Cloud Infrastructure Psql service.

    Gets a configuration by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_configuration = oci.Psql.get_configuration(configuration_id=test_configuration_oci_psql_configuration["id"])
    ```


    :param str configuration_id: A unique identifier for the configuration.
    """
    ...
