# -*- coding: utf-8 -*-
# (c) Copyright 2020 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.5.1
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class SensorBridgeCmdI2cTransceiveBase(ShdlcCommand):
    """
    SHDLC command 0x11: "I2c Transceive".
    """

    def __init__(self, *args, **kwargs):
        super(SensorBridgeCmdI2cTransceiveBase, self).__init__(
            0x11, *args, **kwargs)


class SensorBridgeCmdFirstTransceive(SensorBridgeCmdI2cTransceiveBase):

    def __init__(self, port, i2c_address, tx_length, rx_length, timeout_us, tx_data):
        """
        First Transceive Command

        First frame of a transceive command.

        :param int port:
            The port where the transceive should be executed:

            -  0x00: Port 1
            -  0x01: Port 2
        :param int i2c_address:
            I2C address of the targeted device.
        :param int tx_length:
            Number of bytes to send. This amount of bytes has to be attached to
            the command. Set to zero if only read header is needed.
        :param int rx_length:
            Number of bytes to receive. This amount of bytes are returned as
            response. Set to zero if no read operation is needed.
        :param int timeout_us:
            I2C timeout in microseconds when reading bytes. If a frame is
            NACK'd it will be retried up to the timeout value. Same applies for
            clock stretching.
        :param bytes tx_data:
            Bytes to send (if any).
        """
        super(SensorBridgeCmdFirstTransceive, self).__init__(
            data=b"".join([bytes(bytearray([0x00])),
                           pack(">B", port),
                           pack(">B", i2c_address),
                           pack(">I", tx_length),
                           pack(">I", rx_length),
                           pack(">I", timeout_us),
                           bytes(bytearray(tx_data))]),
            max_response_time=10.0,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=255
        )

    @staticmethod
    def interpret_response(data):
        """
        :return: If needed/available, the bytes from the I2C read are returned.
        :rtype: bytes
        """
        rx_data = bytes(data[0:])  # bytearray
        return rx_data


class SensorBridgeCmdSubsequentTransceive(SensorBridgeCmdI2cTransceiveBase):

    def __init__(self, port, tx_data):
        """
        Subsequent Transceive Command

        Subsequent frame of a transceive command.

        :param int port:
            The port where the transceive should be executed:

            -  0x00: Port 1
            -  0x01: Port 2
        :param bytes tx_data:
            Bytes to send (if any).
        """
        super(SensorBridgeCmdSubsequentTransceive, self).__init__(
            data=b"".join([bytes(bytearray([0x01])),
                           pack(">B", port),
                           bytes(bytearray(tx_data))]),
            max_response_time=10.0,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=255
        )

    @staticmethod
    def interpret_response(data):
        """
        :return: If needed/available, the bytes from the I2C read are returned.
        :rtype: bytes
        """
        rx_data = bytes(data[0:])  # bytearray
        return rx_data
