# -*- coding: utf-8 -*-
# (c) Copyright 2020 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.5.1
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class SensorBridgeCmdSlaveAddressBase(ShdlcCommand):
    """
    SHDLC command 0x90: "Slave Address".
    """

    def __init__(self, *args, **kwargs):
        super(SensorBridgeCmdSlaveAddressBase, self).__init__(
            0x90, *args, **kwargs)


class SensorBridgeCmdSetSlaveAddress(SensorBridgeCmdSlaveAddressBase):

    def __init__(self, slave_address):
        """
        Set Slave Address Command

        Set the SHDLC slave address of the device.

        .. note:: The slave address is stored in non-volatile memory of the
                  device and thus persists after a device reset. So the next
                  time connecting to the device, you have to use the new
                  address. When changing the address of a slave, make sure
                  there isn't already a slave with that address on the same
                  bus! In that case you would get communication issues which
                  can only be fixed by disconnecting one of the slaves.

        :param int slave_address:
            The new slave address. The address 255 is reserved for broadcasts.
        """
        super(SensorBridgeCmdSetSlaveAddress, self).__init__(
            data=b"".join([pack(">B", slave_address)]),
            max_response_time=0.5,
            post_processing_time=0.0,
            min_response_length=1,
            max_response_length=1
        )

    @staticmethod
    def interpret_response(data):
        """
        :return: The new slave address.
        :rtype: int
        """
        slave_address = int(unpack(">B", data[0:1])[0])  # uint8
        return slave_address
