# -*- coding: utf-8 -*-
# (c) Copyright 2020 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.5.1
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class SensorBridgeCmdSpiConfigBase(ShdlcCommand):
    """
    SHDLC command 0x60: "Spi Config".
    """

    def __init__(self, *args, **kwargs):
        super(SensorBridgeCmdSpiConfigBase, self).__init__(
            0x60, *args, **kwargs)


class SensorBridgeCmdSpiConfig(SensorBridgeCmdSpiConfigBase):

    def __init__(self, port, mode, frequency):
        """
        Spi Config Command

        Sets the SPI mode and frequency.

        :param int port:
            The port(s) which should be configured:

            -  0x00: Port 1
            -  0x01: Port 2
            -  0xFF: All ports
        :param int mode:
            The SPI mode to use:

            -  0x00: Mode 0
            -  0x01: Mode 1
            -  0x02: Mode 2
            -  0x03: Mode 3
        :param int frequency:
            The frequency to set:

            -  0x00: 330kHz
            -  0x01: 600kHz
            -  0x02: 1MHz
            -  0x03: 5MHz
            -  0x04: 10MHz
            -  0x05: 21MHz
        """
        super(SensorBridgeCmdSpiConfig, self).__init__(
            data=b"".join([pack(">B", port),
                           pack(">B", mode),
                           pack(">B", frequency)]),
            max_response_time=0.1,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=0
        )
