# -*- coding: utf-8 -*-
# (c) Copyright 2020 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.5.1
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class SensorBridgeCmdStopRepeatedTransceiveBase(ShdlcCommand):
    """
    SHDLC command 0x51: "Stop Repeated Transceive".
    """

    def __init__(self, *args, **kwargs):
        super(SensorBridgeCmdStopRepeatedTransceiveBase, self).__init__(
            0x51, *args, **kwargs)


class SensorBridgeCmdStopRepeatedTransceive(SensorBridgeCmdStopRepeatedTransceiveBase):

    def __init__(self, handle):
        """
        Stop Repeated Transceive Command

        Stops a repeated transceive operation.

        :param int handle:
            The handle of the repeated transceive which should be stopped. Pass
            0xFF to stop all repeated transceives.
        """
        super(SensorBridgeCmdStopRepeatedTransceive, self).__init__(
            data=b"".join([pack(">B", handle)]),
            max_response_time=0.05,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=0
        )
