# -*- coding: utf-8 -*-
# (c) Copyright 2020 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.5.1
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class SensorBridgeCmdI2cScanBase(ShdlcCommand):
    """
    SHDLC command 0x10: "I2c Scan".
    """

    def __init__(self, *args, **kwargs):
        super(SensorBridgeCmdI2cScanBase, self).__init__(
            0x10, *args, **kwargs)


class SensorBridgeCmdI2cScan(SensorBridgeCmdI2cScanBase):

    def __init__(self, port, first_address, last_address):
        """
        I2c Scan Command

        Scans for I2C devices on a specific port within a certain address
        range.

        :param int port:
            The port where the scan should be executed:

            -  0x00: Port 1
            -  0x01: Port 2
        :param int first_address:
            First address to scan (1..127).
        :param int last_address:
            Last address to scan (1..127 and >= first address).
        """
        super(SensorBridgeCmdI2cScan, self).__init__(
            data=b"".join([pack(">B", port),
                           pack(">B", first_address),
                           pack(">B", last_address)]),
            max_response_time=0.1,
            post_processing_time=0.0,
            min_response_length=0,
            max_response_length=255
        )

    @staticmethod
    def interpret_response(data):
        """
        :return: Array of bytes containing all addresses from devices which
                 responded to the scan.
        :rtype: bytes
        """
        present_device_addresses = bytes(data[0:])  # bytearray
        return present_device_addresses
