# -*- coding: utf-8 -*-
# (c) Copyright 2020 Sensirion AG, Switzerland

##############################################################################
##############################################################################
#                 _____         _    _ _______ _____ ____  _   _
#                / ____|   /\  | |  | |__   __|_   _/ __ \| \ | |
#               | |       /  \ | |  | |  | |    | || |  | |  \| |
#               | |      / /\ \| |  | |  | |    | || |  | | . ` |
#               | |____ / ____ \ |__| |  | |   _| || |__| | |\  |
#                \_____/_/    \_\____/   |_|  |_____\____/|_| \_|
#
#     THIS FILE IS AUTOMATICALLY GENERATED AND MUST NOT BE EDITED MANUALLY!
#
# Generator:    sensirion-shdlc-interface-generator 0.5.1
# Product:      Sensor Bridge
# Version:      0.1.0
#
##############################################################################
##############################################################################

# flake8: noqa

from __future__ import absolute_import, division, print_function
from sensirion_shdlc_driver.command import ShdlcCommand
from struct import pack, unpack

import logging
log = logging.getLogger(__name__)


class SensorBridgeCmdReadBufferBase(ShdlcCommand):
    """
    SHDLC command 0x50: "Read Buffer".
    """

    def __init__(self, *args, **kwargs):
        super(SensorBridgeCmdReadBufferBase, self).__init__(
            0x50, *args, **kwargs)


class SensorBridgeCmdReadBuffer(SensorBridgeCmdReadBufferBase):

    def __init__(self, handle):
        """
        Read Buffer Command

        Reads data stored in the buffer of a repeated transceive.

        :param int handle:
            The handle of the repeated transceive from which the data should be
            returned.
        """
        super(SensorBridgeCmdReadBuffer, self).__init__(
            data=b"".join([pack(">B", handle)]),
            max_response_time=0.05,
            post_processing_time=0.0,
            min_response_length=8,
            max_response_length=255
        )

    @staticmethod
    def interpret_response(data):
        """
        :return:
            - lost_bytes (int) -
              Number of bytes lost due to buffer overrun.
            - remaining_bytes (int) -
              Number of bytes remaining in the buffer.
            - rx_data (bytes) -
              Buffered values. The data is returned in
              ``n*[header][readI2cDataOfOneTransceive]`` where header:

              -  0: valid data
              -  1: NACK from Sensor (not available)
              -  2: Timeout in Read Operation
              -  3: Timing Error. Hardware and/or Sensor can not provide the
                 requested data rate
        :rtype: tuple
        """
        lost_bytes = int(unpack(">I", data[0:4])[0])  # uint32
        remaining_bytes = int(unpack(">I", data[4:8])[0])  # uint32
        rx_data = bytes(data[8:])  # bytearray
        return lost_bytes,\
            remaining_bytes,\
            rx_data
