# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from .fdx_order_group_order import FDXOrderGroupOrder
from .grouptype import Grouptype
from typing import Optional, Set
from typing_extensions import Self

class FDXBrokerOrderGroup(BaseModel):
    """
    FDX-style order group schema for multi-order workflows.  Represents groups of related orders (OCO, OTO, Bracket, etc.).
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, alias="_id")
    order_group_id: StrictStr = Field(description="Group identifier", alias="orderGroupId")
    connection_id: StrictStr = Field(description="User-broker connection identifier", alias="connectionId")
    group_type: Optional[Grouptype] = Field(default=None, alias="groupType")
    group_status: Optional[StrictStr] = Field(default=None, alias="groupStatus")
    orders: Optional[List[FDXOrderGroupOrder]] = Field(default=None, description="Orders in this group")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")
    completed_at: Optional[datetime] = Field(default=None, alias="completedAt")
    metadata: Optional[Dict[str, Any]] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["_id", "orderGroupId", "connectionId", "groupType", "groupStatus", "orders", "createdAt", "updatedAt", "completedAt", "metadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDXBrokerOrderGroup from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of group_type
        if self.group_type:
            _dict['groupType'] = self.group_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in orders (list)
        _items = []
        if self.orders:
            for _item_orders in self.orders:
                if _item_orders:
                    _items.append(_item_orders.to_dict())
            _dict['orders'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if group_type (nullable) is None
        # and model_fields_set contains the field
        if self.group_type is None and "group_type" in self.model_fields_set:
            _dict['groupType'] = None

        # set to None if group_status (nullable) is None
        # and model_fields_set contains the field
        if self.group_status is None and "group_status" in self.model_fields_set:
            _dict['groupStatus'] = None

        # set to None if created_at (nullable) is None
        # and model_fields_set contains the field
        if self.created_at is None and "created_at" in self.model_fields_set:
            _dict['createdAt'] = None

        # set to None if updated_at (nullable) is None
        # and model_fields_set contains the field
        if self.updated_at is None and "updated_at" in self.model_fields_set:
            _dict['updatedAt'] = None

        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict['completedAt'] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict['metadata'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDXBrokerOrderGroup from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_id": obj.get("_id"),
            "orderGroupId": obj.get("orderGroupId"),
            "connectionId": obj.get("connectionId"),
            "groupType": Grouptype.from_dict(obj["groupType"]) if obj.get("groupType") is not None else None,
            "groupStatus": obj.get("groupStatus"),
            "orders": [FDXOrderGroupOrder.from_dict(_item) for _item in obj["orders"]] if obj.get("orders") is not None else None,
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "completedAt": obj.get("completedAt"),
            "metadata": obj.get("metadata")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


