# coding: utf-8

"""
    Finatic FastAPI Backend

    FinaticAPI REST API

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from .fdx_order_leg import FDXOrderLeg
from typing import Optional, Set
from typing_extensions import Self

class FDXOrderGroupOrder(BaseModel):
    """
    Order reference within an order group.
    """ # noqa: E501
    order_id: StrictStr = Field(description="Order identifier", alias="orderId")
    broker_order_id: Optional[StrictStr] = Field(default=None, alias="brokerOrderId")
    status: StrictStr = Field(description="Order status")
    order_type: Optional[StrictStr] = Field(default=None, alias="orderType")
    symbol: Optional[StrictStr] = None
    legs: Optional[List[FDXOrderLeg]] = Field(default=None, description="Order legs")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["orderId", "brokerOrderId", "status", "orderType", "symbol", "legs"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDXOrderGroupOrder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in legs (list)
        _items = []
        if self.legs:
            for _item_legs in self.legs:
                if _item_legs:
                    _items.append(_item_legs.to_dict())
            _dict['legs'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if broker_order_id (nullable) is None
        # and model_fields_set contains the field
        if self.broker_order_id is None and "broker_order_id" in self.model_fields_set:
            _dict['brokerOrderId'] = None

        # set to None if order_type (nullable) is None
        # and model_fields_set contains the field
        if self.order_type is None and "order_type" in self.model_fields_set:
            _dict['orderType'] = None

        # set to None if symbol (nullable) is None
        # and model_fields_set contains the field
        if self.symbol is None and "symbol" in self.model_fields_set:
            _dict['symbol'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDXOrderGroupOrder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderId": obj.get("orderId"),
            "brokerOrderId": obj.get("brokerOrderId"),
            "status": obj.get("status"),
            "orderType": obj.get("orderType"),
            "symbol": obj.get("symbol"),
            "legs": [FDXOrderLeg.from_dict(_item) for _item in obj["legs"]] if obj.get("legs") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


