"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from .responsemessage import ResponseMessage
from .servicelevelwithparent import ServiceLevelWithParent
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from enum import Enum
from shippo import utils
from typing import List, Optional


class Attributes(str, Enum):
    BESTVALUE = 'BESTVALUE'
    CHEAPEST = 'CHEAPEST'
    FASTEST = 'FASTEST'


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class Rate:
    amount: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('amount') }})
    r"""Final Rate price, expressed in the currency used in the sender's country."""
    amount_local: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('amount_local') }})
    r"""Final Rate price, expressed in the currency used in the recipient's country."""
    currency: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('currency') }})
    r"""Currency used in the sender's country, refers to `amount`.
    The <a href=\"http://www.xe.com/iso4217.php\">official ISO 4217</a> currency codes are used, e.g. `USD` or `EUR`.
    """
    currency_local: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('currency_local') }})
    r"""Currency used in the recipient's country, refers to `amount_local`.
    The <a href=\"http://www.xe.com/iso4217.php\">official ISO 4217</a> currency codes are used, e.g. `USD` or \"EUR\".
    """
    attributes: List[Attributes] = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('attributes') }})
    r"""An array containing specific attributes of this Rate in context of the entire shipment.
    Attributes can be assigned `CHEAPEST`, `FASTEST`, or `BESTVALUE`.
    """
    carrier_account: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('carrier_account') }})
    r"""Object ID of the carrier account that has been used to retrieve the rate."""
    object_created: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_created'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""Date and time of Rate creation."""
    object_id: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_id') }})
    r"""Unique identifier of the given Rate object."""
    object_owner: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_owner') }})
    r"""Username of the user who created the rate object."""
    provider: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('provider') }})
    r"""Carrier offering the rate, e.g., `FedEx` or `Deutsche Post DHL`."""
    servicelevel: ServiceLevelWithParent = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('servicelevel') }})
    shipment: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('shipment') }})
    arrives_by: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('arrives_by'), 'exclude': lambda f: f is None }})
    r"""Predicted time the carrier will deliver the package in the destination's local time zone. In the format `HH:MM:SS`."""
    duration_terms: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('duration_terms'), 'exclude': lambda f: f is None }})
    r"""Further clarification of the transit times.
    Often, this includes notes that the transit time as given in \"days\" is only an average, not a guaranteed time.
    """
    estimated_days: Optional[int] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('estimated_days'), 'exclude': lambda f: f is None }})
    r"""Estimated transit time (duration) in days of the Parcel at the given servicelevel.
    Please note that this is not binding, but only an average value as given by the provider. 
    Shippo is not able to guarantee any transit times.
    """
    included_insurance_price: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('included_insurance_price'), 'exclude': lambda f: f is None }})
    r"""Cost to the user to insure the Rate for the requested amount of coverage, if insurance coverage was requested.
    Expressed in the currency used in the sender's country. Will be null if no insurance coverage was requested, or if insurance is requested from a non-standard insurance provider. 
    Please note this price is already included in the `amount` and `amount_local` fields on the Rate. Do not add this field to them.
    """
    messages: Optional[List[ResponseMessage]] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('messages'), 'exclude': lambda f: f is None }})
    provider_image_75: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('provider_image_75'), 'exclude': lambda f: f is None }})
    r"""URL to the provider logo with max. dimensions of 75*75px.
    Please refer to the provider's Logo Usage Guidelines before using the logo.
    """
    provider_image_200: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('provider_image_200'), 'exclude': lambda f: f is None }})
    r"""URL to the provider logo with max. dimensions of 200*200px.
    Please refer to the provider's Logo Usage Guidelines before using the logo.
    """
    test: Optional[bool] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('test'), 'exclude': lambda f: f is None }})
    r"""Indicates whether the object has been created in test mode."""
    zone: Optional[str] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('zone'), 'exclude': lambda f: f is None }})
    r"""The parcel's transit zone token. These tokens can vary depending on the provider."""
    

