"""Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT."""

from __future__ import annotations
import dataclasses
import dateutil.parser
from dataclasses_json import Undefined, dataclass_json
from datetime import datetime
from enum import Enum
from shippo import utils
from typing import List, Optional


class ManifestStatus(str, Enum):
    r"""Indicates the status of the manifest."""
    QUEUED = 'QUEUED'
    SUCCESS = 'SUCCESS'
    ERROR = 'ERROR'


@dataclass_json(undefined=Undefined.EXCLUDE)
@dataclasses.dataclass
class Manifest:
    carrier_account: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('carrier_account') }})
    r"""ID of carrier account"""
    shipment_date: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('shipment_date') }})
    r"""All shipments to be submitted on this day will be closed out.
    Must be in the format `2014-01-18T00:35:03.463Z` (ISO 8601 date).
    """
    address_from: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('address_from') }})
    r"""ID of the Address object that should be used as pickup address for the scan form.
    The USPS will validate this address before creating the scan form.
    """
    documents: List[str] = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('documents') }})
    r"""An array containing the URLs to all returned manifest documents."""
    object_created: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_created'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""Date and time of object creation."""
    object_id: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_id') }})
    r"""Unique identifier of the given object."""
    object_owner: str = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_owner') }})
    r"""Username of the user who created the object."""
    object_updated: datetime = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('object_updated'), 'encoder': utils.datetimeisoformat(False), 'decoder': dateutil.parser.isoparse }})
    r"""Date and time of last object update."""
    status: ManifestStatus = dataclasses.field(metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('status') }})
    r"""Indicates the status of the manifest."""
    transactions: Optional[List[str]] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('transactions'), 'exclude': lambda f: f is None }})
    r"""IDs transactions to use. If you set this to null or not send this parameter,
    Shippo will automatically assign all applicable transactions.
    """
    errors: Optional[List[str]] = dataclasses.field(default=None, metadata={'dataclasses_json': { 'letter_case': utils.get_field_name('errors'), 'exclude': lambda f: f is None }})
    r"""An array of codes and messages describing the error that occurred if any."""
    

