# Generated by Django 4.0.10 on 2024-03-21 13:45

import multiselectfield.db.fields

from django.db import migrations


class Migration(migrations.Migration):
    dependencies = [
        ("structures", "0004_improve_localization"),
    ]

    operations = [
        migrations.AlterField(
            model_name="webhook",
            name="notification_types",
            field=multiselectfield.db.fields.MultiSelectField(
                choices=[
                    ("OwnershipTransferred", "Upwell structure ownership transferred"),
                    ("StructureAnchoring", "Upwell structure anchoring"),
                    ("StructureDestroyed", "Upwell structure destroyed"),
                    ("StructureFuelAlert", "Upwell structure fuel alert"),
                    ("StructureJumpFuelAlert", "Upwell structure jump fuel alert"),
                    ("StructureLostArmor", "Upwell structure lost armor"),
                    ("StructureLostShields", "Upwell structure lost shields"),
                    ("StructureOnline", "Upwell structure went online"),
                    ("StructureRefueledExtra", "Upwell structure refueled"),
                    (
                        "StructuresReinforcementChanged",
                        "Upwell structure reinforcement time changed",
                    ),
                    (
                        "StructureServicesOffline",
                        "Upwell structure services went offline",
                    ),
                    ("StructureUnanchoring", "Upwell structure unanchoring"),
                    ("StructureUnderAttack", "Upwell structure is under attack"),
                    ("StructureWentHighPower", "Upwell structure went high power"),
                    ("StructureWentLowPower", "Upwell structure went low power"),
                    ("OrbitalAttacked", "Customs office attacked"),
                    ("OrbitalReinforced", "Customs office reinforced"),
                    ("TowerAlertMsg", "Starbase attacked"),
                    ("TowerResourceAlertMsg", "Starbase fuel alert"),
                    ("TowerRefueledExtra", "Starbase refueled (BETA)"),
                    ("TowerReinforcedExtra", "Starbase reinforced (BETA)"),
                    (
                        "MoonminingAutomaticFracture",
                        "Moon mining automatic fracture triggered",
                    ),
                    (
                        "MoonminingExtractionCancelled",
                        "Moon mining extraction cancelled",
                    ),
                    ("MoonminingExtractionFinished", "Moon mining extraction finished"),
                    ("MoonminingExtractionStarted", "Moon mining extraction started"),
                    ("MoonminingLaserFired", "Moonmining laser fired"),
                    ("SovAllClaimAquiredMsg", "Sovereignty claim acknowledgment"),
                    ("SovAllClaimLostMsg", "Sovereignty lost"),
                    ("AllAnchoringMsg", "Structure anchoring in alliance space"),
                    ("EntosisCaptureStarted", "Sovereignty entosis capture started"),
                    ("SovStructureDestroyed", "Sovereignty structure destroyed"),
                    ("SovStructureReinforced", "Sovereignty structure reinforced"),
                    (
                        "SovCommandNodeEventStarted",
                        "Sovereignty command node event started",
                    ),
                    ("AcceptedAlly", "War accepted ally"),
                    (
                        "AllWarCorpJoinedAllianceMsg",
                        "Alliance war corporation joined alliance message",
                    ),
                    ("AllWarSurrenderMsg", "Alliance war surrender message"),
                    ("AllyJoinedWarAggressorMsg", "War ally joined aggressor"),
                    ("AllyJoinedWarAllyMsg", "War ally joined ally"),
                    ("AllyJoinedWarDefenderMsg", "War ally joined defender"),
                    ("CorpWarSurrenderMsg", "War party surrendered"),
                    ("CorpBecameWarEligible", "War corporation became eligible"),
                    ("CorpNoLongerWarEligible", "War corporation no longer eligible"),
                    ("DeclareWar", "War declared"),
                    ("WarHQRemovedFromSpace", "War HQ removed from space"),
                    ("WarInvalid", "War invalid"),
                    (
                        "MercOfferedNegotiationMsg",
                        "War mercenary offered negotiation message",
                    ),
                    ("MercOfferRetractedMsg", "War mercenary offer retracted message"),
                    ("OfferedSurrender", "War offered surrender"),
                    ("OfferedToAlly", "War offered to become ally"),
                    ("WarAdopted", "War adopted"),
                    ("WarDeclared", "War declared"),
                    ("WarInherited", "War inherited"),
                    ("WarRetractedByConcord", "War retracted by Concord"),
                    ("WarSurrenderOfferMsg", "War surrender offered"),
                    ("CharAppAcceptMsg", "Character joins corporation"),
                    ("CorpAppInvitedMsg", "Character invited to join corporation"),
                    ("CorpAppNewMsg", "Character submitted application"),
                    ("CharAppRejectMsg", "Corp application rejected message"),
                    (
                        "CorpAppRejectCustomMsg",
                        "Corp application rejected custom message",
                    ),
                    ("CharAppWithdrawMsg", "Character withdrew application"),
                    ("CharLeftCorpMsg", "Character leaves corporation"),
                    ("CorpAllBillMsg", "Corp alliance billing message"),
                    ("BillOutOfMoneyMsg", "Bill out of money"),
                    (
                        "InfrastructureHubBillAboutToExpire",
                        "I-HUB bill about to expire",
                    ),
                    ("IHubDestroyedByBillFailure", "I_HUB destroyed by bill failure"),
                ],
                default=[
                    "StructureAnchoring",
                    "StructureDestroyed",
                    "StructureFuelAlert",
                    "StructureLostArmor",
                    "StructureLostShields",
                    "StructureOnline",
                    "StructureServicesOffline",
                    "StructureUnderAttack",
                    "StructureWentHighPower",
                    "StructureWentLowPower",
                    "OrbitalAttacked",
                    "OrbitalReinforced",
                    "TowerAlertMsg",
                    "TowerResourceAlertMsg",
                    "SovStructureReinforced",
                    "SovStructureDestroyed",
                ],
                help_text="Select which type of notifications should be forwarded to this webhook",
                max_length=1338,
                verbose_name="notification types",
            ),
        ),
    ]
