/*
 * Decompiled with CFR 0.152.
 */
package io.ray.runtime.runner;

import io.ray.runtime.config.RayConfig;
import io.ray.shaded.com.google.common.base.Joiner;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunManager.class);
    private static final Pattern pattern = Pattern.compile("--address='([^']+)'");

    public static void startRayHead(RayConfig rayConfig) {
        String output;
        LOGGER.debug("Starting ray runtime @ {}.", (Object)rayConfig.nodeIp);
        ArrayList<String> command = new ArrayList<String>();
        command.add("ray");
        command.add("start");
        command.add("--head");
        command.add("--redis-password");
        command.add(rayConfig.redisPassword);
        command.addAll(rayConfig.headArgs);
        try {
            output = RunManager.runCommand(command);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start Ray runtime.", e);
        }
        Matcher matcher = pattern.matcher(output);
        if (!matcher.find()) {
            throw new RuntimeException("Redis address is not found. output: " + output);
        }
        String bootstrapAddress = matcher.group(1);
        rayConfig.setBootstrapAddress(bootstrapAddress);
        LOGGER.info("Ray runtime started @ {}.", (Object)rayConfig.nodeIp);
    }

    public static void stopRay() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("ray");
        command.add("stop");
        command.add("--force");
        try {
            RunManager.runCommand(command);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop ray.", e);
        }
    }

    public static String runCommand(List<String> command) throws IOException, InterruptedException {
        return RunManager.runCommand(command, 30L, TimeUnit.SECONDS);
    }

    public static String runCommand(List<String> command, long timeout, TimeUnit unit) throws IOException, InterruptedException {
        LOGGER.info("Starting process with command: {}", (Object)Joiner.on(" ").join(command));
        ProcessBuilder builder = new ProcessBuilder(command).redirectErrorStream(true);
        Process p = builder.start();
        boolean exited = p.waitFor(timeout, unit);
        if (!exited) {
            String output = IOUtils.toString(p.getInputStream(), Charset.defaultCharset());
            throw new RuntimeException("The process was not exited in time. output:\n" + output);
        }
        String output = IOUtils.toString(p.getInputStream(), Charset.defaultCharset());
        if (p.exitValue() != 0) {
            String sb = "The exit value of the process is " + p.exitValue() + ". Command: " + Joiner.on(" ").join(command) + "\noutput:\n" + output;
            throw new RuntimeException(sb);
        }
        return output;
    }
}

