/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;

public class SocketUtil {
    public static final int PORT_RANGE_MAX = 65535;

    public static int findAvailableTcpPort(int minPort) {
        int portRange = 65535 - minPort;
        int candidatePort = minPort;
        int searchCounter = 0;
        while (!SocketUtil.isPortAvailable(candidatePort)) {
            ++candidatePort;
            if (++searchCounter <= portRange) continue;
            throw new IllegalStateException(String.format("Could not find an available tcp port in the range [%d, %d] after %d attempts.", minPort, 65535, searchCounter));
        }
        return candidatePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortAvailable(int port) {
        ServerSocket socket;
        try {
            socket = new ServerSocket();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create ServerSocket.", e);
        }
        try {
            InetSocketAddress sa = new InetSocketAddress(port);
            socket.bind(sa);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

