/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.util.Date;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.utils.SignatureUtils;

public class Version {
    private static final String version = "1.2023.11";

    public static String versionString() {
        return version;
    }

    public static String fullDescription() {
        return "PlantUML version " + Version.versionString() + " (" + Version.compileTimeString() + ")";
    }

    public static String versionString(int size) {
        StringBuilder sb = new StringBuilder(Version.versionString());
        while (sb.length() < size) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static int beta() {
        int x = version.indexOf("beta");
        if (x == -1) {
            return 0;
        }
        return Integer.parseInt(version.substring(x + "beta".length()));
    }

    public static String etag() {
        return SignatureUtils.getMD5Hex(version);
    }

    public static String turningId() {
        return Version.etag();
    }

    public static long compileTime() {
        return 1694629593289L;
    }

    public static String compileTimeString() {
        if (version.contains("beta")) {
            return "Unknown compile time";
        }
        return new Date(Version.compileTime()).toString();
    }

    public static String getJarPath() {
        try {
            ClassLoader loader = Version.class.getClassLoader();
            if (loader == null) {
                return "No ClassLoader?";
            }
            SURL url = SURL.create(loader.getResource("net/sourceforge/plantuml/version/Version.class"));
            if (url == null) {
                return "No URL?";
            }
            String fullpath = url.toString();
            fullpath = fullpath.replaceAll("net/sourceforge/plantuml/version/Version\\.class", "");
            return fullpath;
        }
        catch (Throwable t) {
            Logme.error(t);
            return t.toString();
        }
    }
}

