# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from ..core.serialization import FieldMetadata
from .invite_with_analytics import InviteWithAnalytics
from .project_analysis import ProjectAnalysis
from .project_config import ProjectConfig
from .project_conversation_config import ProjectConversationConfig
from .project_status import ProjectStatus


class ProjectWithAnalytics(UniversalBaseModel):
    id: str
    created_at: typing_extensions.Annotated[str, FieldMetadata(alias="createdAt")]
    updated_at: typing_extensions.Annotated[str, FieldMetadata(alias="updatedAt")]
    name: str
    description: typing.Optional[str] = None
    status: ProjectStatus
    created_by_id: typing_extensions.Annotated[str, FieldMetadata(alias="createdById")]
    org_id: typing_extensions.Annotated[str, FieldMetadata(alias="orgId")]
    moderator_id: typing_extensions.Annotated[str, FieldMetadata(alias="moderatorId")]
    config: ProjectConfig
    conversation_config: typing_extensions.Annotated[
        ProjectConversationConfig, FieldMetadata(alias="conversationConfig")
    ]
    analysis: typing.Optional[ProjectAnalysis] = None
    created_by: typing_extensions.Annotated[typing.Optional["User"], FieldMetadata(alias="createdBy")] = None
    org: typing.Optional["Org"] = None
    moderator: typing.Optional["Moderator"] = None
    invites: typing.List[InviteWithAnalytics]
    chat_sessions: typing_extensions.Annotated[
        typing.Optional[typing.List["ChatSession"]], FieldMetadata(alias="chatSessions")
    ] = None
    project_files: typing_extensions.Annotated[
        typing.Optional[typing.List["ProjectFile"]], FieldMetadata(alias="projectFiles")
    ] = None
    threads: typing.Optional[typing.List["Thread"]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .call import Call  # noqa: E402, F401, I001
from .call_event import CallEvent  # noqa: E402, F401, I001
from .chat_message import ChatMessage  # noqa: E402, F401, I001
from .chat_session import ChatSession  # noqa: E402, F401, I001
from .conversation_message import ConversationMessage  # noqa: E402, F401, I001
from .conversation_message_topic import ConversationMessageTopic  # noqa: E402, F401, I001
from .file import File  # noqa: E402, F401, I001
from .invite import Invite  # noqa: E402, F401, I001
from .invite_response import InviteResponse  # noqa: E402, F401, I001
from .moderator import Moderator  # noqa: E402, F401, I001
from .org import Org  # noqa: E402, F401, I001
from .participant import Participant  # noqa: E402, F401, I001
from .participant_invite import ParticipantInvite  # noqa: E402, F401, I001
from .project import Project  # noqa: E402, F401, I001
from .project_file import ProjectFile  # noqa: E402, F401, I001
from .thread import Thread  # noqa: E402, F401, I001
from .thread_file import ThreadFile  # noqa: E402, F401, I001
from .user import User  # noqa: E402, F401, I001

update_forward_refs(ProjectWithAnalytics)
