# This file was automatically generated by SWIG (http://www.swig.org).
# Version 2.0.9
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.


"""
Biomechanical ToolKit (BTK) for Python
High level classes and functions to open, edit and modify biomechanical acquisitions.
"""


from sys import version_info
if version_info >= (2,6,0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_btk', [dirname(__file__)])
        except ImportError:
            import _btk
            return _btk
        if fp is not None:
            try:
                _mod = imp.load_module('_btk', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _btk = swig_import_helper()
    del swig_import_helper
else:
    import _btk
del version_info
try:
    _swig_property = property
except NameError:
    pass # Python < 2.2 doesn't have 'property'.
def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "thisown"): return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    if (name == "thisown"): return self.this.own()
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError(name)

def _swig_repr(self):
    try: strthis = "proxy of " + self.this.__repr__()
    except: strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0


def Iterate(c):
    """
    Python generator to iterate through a collection of BTK objects (Points, Analogs, Events and Metadata).
    
    For example:
  
    for i in btk.Iterate(acq.GetPoints()):
        print i.GetLabel()
    """
    i = c.Begin()
    while i != c.End():
        yield i.value()
        i.incr()

class SwigPyIterator(_object):
    """Proxy of C++ swig::SwigPyIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)
    def __init__(self, *args, **kwargs): raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _btk.delete_SwigPyIterator
    __del__ = lambda self : None;
    def value(self):
        """value(self) -> PyObject *"""
        return _btk.SwigPyIterator_value(self)

    def incr(self, n=1):
        """
        incr(self, n=1) -> SwigPyIterator
        incr(self) -> SwigPyIterator
        """
        return _btk.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        """
        decr(self, n=1) -> SwigPyIterator
        decr(self) -> SwigPyIterator
        """
        return _btk.SwigPyIterator_decr(self, n)

    def distance(self, *args):
        """distance(self, x) -> ptrdiff_t"""
        return _btk.SwigPyIterator_distance(self, *args)

    def equal(self, *args):
        """equal(self, x) -> bool"""
        return _btk.SwigPyIterator_equal(self, *args)

    def copy(self):
        """copy(self) -> SwigPyIterator"""
        return _btk.SwigPyIterator_copy(self)

    def next(self):
        """next(self) -> PyObject *"""
        return _btk.SwigPyIterator_next(self)

    def __next__(self):
        """__next__(self) -> PyObject *"""
        return _btk.SwigPyIterator___next__(self)

    def previous(self):
        """previous(self) -> PyObject *"""
        return _btk.SwigPyIterator_previous(self)

    def advance(self, *args):
        """advance(self, n) -> SwigPyIterator"""
        return _btk.SwigPyIterator_advance(self, *args)

    def __eq__(self, *args):
        """__eq__(self, x) -> bool"""
        return _btk.SwigPyIterator___eq__(self, *args)

    def __ne__(self, *args):
        """__ne__(self, x) -> bool"""
        return _btk.SwigPyIterator___ne__(self, *args)

    def __iadd__(self, *args):
        """__iadd__(self, n) -> SwigPyIterator"""
        return _btk.SwigPyIterator___iadd__(self, *args)

    def __isub__(self, *args):
        """__isub__(self, n) -> SwigPyIterator"""
        return _btk.SwigPyIterator___isub__(self, *args)

    def __add__(self, *args):
        """__add__(self, n) -> SwigPyIterator"""
        return _btk.SwigPyIterator___add__(self, *args)

    def __sub__(self, *args):
        """
        __sub__(self, n) -> SwigPyIterator
        __sub__(self, x) -> ptrdiff_t
        """
        return _btk.SwigPyIterator___sub__(self, *args)

    def __iter__(self): return self
SwigPyIterator_swigregister = _btk.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

class btkEvent(_object):
    """
    An event is defined as:
     - a label (string);
     - a time (double);
     - a frame (integer);
     - a context (string);
     - a detection flag (integer);
     - a description (string);
     - an ID (integer).
     
    The detection flag has a limited range of possible values and are listed in the following enumeration:
     - btk.btkEvent.Unknown: Unknown method used to detect the event;
     - btk.btkEvent.Manual: Event detected manually;
     - btk.btkEvent.Automatic: Automatic method used to detect the event;
     - btk.btkEvent.FromForcePlatform: Method based on force platform data to detect the event.

    Note: Even if there is no rule for the id value, these 3 next values are used in Vicon Workstation and Nexus to distinguish events' type:
     - The value 0 is for general event;
     - Value 1 corresponds to the foot strike event;
     - Value 2 for the foot off. Without the use of these values.
    It is known that Workstation and Nexus put all events in general (default value is 0). 
    For Polygon, one user reported that some points had their values set to 0.

    For example, a Heel Strike event on the left leg or the subject John Doe at frame 143 can be set by
    evt = btk.btkEvent('FootStrike', 143, 'Right', btk.btkEvent.Manual, 'John Doe', 'Heel strike event', 2)
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkEvent, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkEvent, name)
    __repr__ = _swig_repr
    Unknown = _btk.btkEvent_Unknown
    Manual = _btk.btkEvent_Manual
    Automatic = _btk.btkEvent_Automatic
    FromForcePlatform = _btk.btkEvent_FromForcePlatform
    def __init__(self, *args): 
        """
        __init__(self) -> btkEvent
        __init__(self, label, t, context="", detectionFlags=Unknown, subject="", desc="", id=0) -> btkEvent
        __init__(self, label, t, context="", detectionFlags=Unknown, subject="", desc="") -> btkEvent
        __init__(self, label, t, context="", detectionFlags=Unknown, subject="") -> btkEvent
        __init__(self, label, t, context="", detectionFlags=Unknown) -> btkEvent
        __init__(self, label, t, context="") -> btkEvent
        __init__(self, label, t) -> btkEvent
        __init__(self, label, f, context="", detectionFlags=Unknown, subject="", desc="", id=0) -> btkEvent
        __init__(self, label, f, context="", detectionFlags=Unknown, subject="", desc="") -> btkEvent
        __init__(self, label, f, context="", detectionFlags=Unknown, subject="") -> btkEvent
        __init__(self, label, f, context="", detectionFlags=Unknown) -> btkEvent
        __init__(self, label, f, context="") -> btkEvent
        __init__(self, label, f) -> btkEvent
        __init__(self, label, t, f, context="", detectionFlags=Unknown, subject="", desc="", id=0) -> btkEvent
        __init__(self, label, t, f, context="", detectionFlags=Unknown, subject="", desc="") -> btkEvent
        __init__(self, label, t, f, context="", detectionFlags=Unknown, subject="") -> btkEvent
        __init__(self, label, t, f, context="", detectionFlags=Unknown) -> btkEvent
        __init__(self, label, t, f, context="") -> btkEvent
        __init__(self, label, t, f) -> btkEvent

        An event is defined as:
         - a label (string);
         - a time (double);
         - a frame (integer);
         - a context (string);
         - a detection flag (integer);
         - a description (string);
         - an ID (integer).
         
        The detection flag has a limited range of possible values and are listed in the following enumeration:
         - btk.btkEvent.Unknown: Unknown method used to detect the event;
         - btk.btkEvent.Manual: Event detected manually;
         - btk.btkEvent.Automatic: Automatic method used to detect the event;
         - btk.btkEvent.FromForcePlatform: Method based on force platform data to detect the event.

        Note: Even if there is no rule for the id value, these 3 next values are used in Vicon Workstation and Nexus to distinguish events' type:
         - The value 0 is for general event;
         - Value 1 corresponds to the foot strike event;
         - Value 2 for the foot off. Without the use of these values.
        It is known that Workstation and Nexus put all events in general (default value is 0). 
        For Polygon, one user reported that some points had their values set to 0.

        For example, a Heel Strike event on the left leg or the subject John Doe at frame 143 can be set by
        evt = btk.btkEvent('FootStrike', 143, 'Right', btk.btkEvent.Manual, 'John Doe', 'Heel strike event', 2)
        """
        this = _btk.new_btkEvent(*args)
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkEvent

        Deep copy of the object.
        """
        return _btk.btkEvent_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkEvent_impl *"""
        return _btk.btkEvent___deref__(self)

    __swig_destroy__ = _btk.delete_btkEvent
    __del__ = lambda self : None;
    def GetLabel(self):
        """
        GetLabel(self) -> std::string const &

        Returns the event's label.
        """
        return _btk.btkEvent_GetLabel(self)

    def SetLabel(self, *args):
        """
        SetLabel(self, string)

        Sets the event's label.
        """
        return _btk.btkEvent_SetLabel(self, *args)

    def GetDescription(self):
        """
        GetDescription(self) -> std::string const &

        Returns the event's description.
        """
        return _btk.btkEvent_GetDescription(self)

    def SetDescription(self, *args):
        """
        SetDescription(self, string)

        Sets the event's description.
        """
        return _btk.btkEvent_SetDescription(self, *args)

    def GetContext(self):
        """
        GetContext(self) -> std::string const &

        Returns the event's context.
        """
        return _btk.btkEvent_GetContext(self)

    def SetContext(self, *args):
        """
        SetContext(self, string)

        Sets the event's context.
        """
        return _btk.btkEvent_SetContext(self, *args)

    def GetSubject(self):
        """
        GetSubject(self) -> std::string const &

        Returns the event's subject.
        """
        return _btk.btkEvent_GetSubject(self)

    def SetSubject(self, *args):
        """
        SetSubject(self, string)

        Sets the event's subject.
        """
        return _btk.btkEvent_SetSubject(self, *args)

    def GetTime(self):
        """
        GetTime(self) -> double const

        Returns the event's time.
        """
        return _btk.btkEvent_GetTime(self)

    def SetTime(self, *args):
        """
        SetTime(self, double)

        Sets the event's time.
        """
        return _btk.btkEvent_SetTime(self, *args)

    def GetFrame(self):
        """
        GetFrame(self) -> int const

        Returns the event's frame.
        """
        return _btk.btkEvent_GetFrame(self)

    def SetFrame(self, *args):
        """
        SetFrame(self, int)

        Sets the event's frame.
        """
        return _btk.btkEvent_SetFrame(self, *args)

    def GetDetectionFlags(self):
        """
        GetDetectionFlags(self) -> int const

        Returns the event's detection flags.
        """
        return _btk.btkEvent_GetDetectionFlags(self)

    def SetDetectionFlags(self, *args):
        """
        SetDetectionFlags(self, int)

        Sets the event's detection flags
        """
        return _btk.btkEvent_SetDetectionFlags(self, *args)

    def HasDetectionFlag(self, *args):
        """
        HasDetectionFlag(self, DetectionFlag) -> bool

        Check if the event has the given detection flag.
        """
        return _btk.btkEvent_HasDetectionFlag(self, *args)

    def GetId(self):
        """
        GetId(self) -> int const

        Returns the event's ID.
        """
        return _btk.btkEvent_GetId(self)

    def SetId(self, *args):
        """
        SetId(self, int)

        Sets the event's ID.
        """
        return _btk.btkEvent_SetId(self, *args)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkEvent_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkEvent_GetTimestamp(self)

btkEvent_swigregister = _btk.btkEvent_swigregister
btkEvent_swigregister(btkEvent)

class btkAnalog(_object):
    """
    An analog channel is defined as:
     - an array of double containing the samples (NumPy array);
     - a unit (string);
     - a scale (double);
     - an offset (integer);
     - a gain (integer).

    The gain has a limited range of possible values and are listed in the following enumeration:
     - btk.btkAnalog.Unknown: unknwon gain;
     - btk.btkAnalog.PlusMinus10: gain for the range +/- 10 volts;
     - btk.btkAnalog.PlusMinus5: gain for the range +/- 5 volts;
     - btk.btkAnalog.PlusMinus2Dot5: gain for the range +/- 2.5 volts;
     - btk.btkAnalog.PlusMinus1Dot25: gain for the range +/- 1.25 volts;
     - btk.btkAnalog.PlusMinus1: gain for the range +/- 1 volts;.

    Note: The informations associated (unit, scale, offset, gain) are useful for other classes/methods. 
    For example, when you save an acquisition in a file, analog's data are generally unscaled and written as integer, 
    then the scale and offset are important.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkAnalog, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkAnalog, name)
    __repr__ = _swig_repr
    Unknown = _btk.btkAnalog_Unknown
    PlusMinus10 = _btk.btkAnalog_PlusMinus10
    PlusMinus5 = _btk.btkAnalog_PlusMinus5
    PlusMinus2Dot5 = _btk.btkAnalog_PlusMinus2Dot5
    PlusMinus1Dot25 = _btk.btkAnalog_PlusMinus1Dot25
    PlusMinus1 = _btk.btkAnalog_PlusMinus1
    PlusMinus0Dot5 = _btk.btkAnalog_PlusMinus0Dot5
    PlusMinus0Dot25 = _btk.btkAnalog_PlusMinus0Dot25
    PlusMinus0Dot1 = _btk.btkAnalog_PlusMinus0Dot1
    PlusMinus0Dot05 = _btk.btkAnalog_PlusMinus0Dot05
    def __init__(self, *args): 
        """
        __init__(self, label="", desc="") -> btkAnalog
        __init__(self, label="") -> btkAnalog
        __init__(self) -> btkAnalog
        __init__(self, frameNumber) -> btkAnalog
        __init__(self, label, frameNumber) -> btkAnalog

        An analog channel is defined as:
         - an array of double containing the samples (NumPy array);
         - a unit (string);
         - a scale (double);
         - an offset (integer);
         - a gain (integer).

        The gain has a limited range of possible values and are listed in the following enumeration:
         - btk.btkAnalog.Unknown: unknwon gain;
         - btk.btkAnalog.PlusMinus10: gain for the range +/- 10 volts;
         - btk.btkAnalog.PlusMinus5: gain for the range +/- 5 volts;
         - btk.btkAnalog.PlusMinus2Dot5: gain for the range +/- 2.5 volts;
         - btk.btkAnalog.PlusMinus1Dot25: gain for the range +/- 1.25 volts;
         - btk.btkAnalog.PlusMinus1: gain for the range +/- 1 volts;.

        Note: The informations associated (unit, scale, offset, gain) are useful for other classes/methods. 
        For example, when you save an acquisition in a file, analog's data are generally unscaled and written as integer, 
        then the scale and offset are important.
        """
        this = _btk.new_btkAnalog(*args)
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkAnalog

        Deep copy of the object.
        """
        return _btk.btkAnalog_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkAnalog_impl *"""
        return _btk.btkAnalog___deref__(self)

    def GetValue(self, *args):
        """
        GetValue(self, idx) -> double

        Returns only one sample.
        """
        return _btk.btkAnalog_GetValue(self, *args)

    def SetValue(self, *args):
        """
        SetValue(self, int, double)

        Sets only one sample.
        """
        return _btk.btkAnalog_SetValue(self, *args)

    __swig_destroy__ = _btk.delete_btkAnalog
    __del__ = lambda self : None;
    def GetLabel(self):
        """
        GetLabel(self) -> std::string const &

        Returns the analog's label.
        """
        return _btk.btkAnalog_GetLabel(self)

    def SetLabel(self, *args):
        """
        SetLabel(self, string)

        Sets the analog's label.
        """
        return _btk.btkAnalog_SetLabel(self, *args)

    def GetDescription(self):
        """
        GetDescription(self) -> std::string const &

        Returns the analog's description.
        """
        return _btk.btkAnalog_GetDescription(self)

    def SetDescription(self, *args):
        """
        SetDescription(self, string)

        Sets the analog's description.
        """
        return _btk.btkAnalog_SetDescription(self, *args)

    def GetValues(self):
        """
        GetValues(self) -> array (NumPy)

        Returns the analog's samples.
        WARNING:You cannot set values using this method. Use the methods SetValues of SetValue for that.
        """
        return _btk.btkAnalog_GetValues(self)

    def SetValues(self, *args):
        """
        SetValues(self, array)

        Sets the analog's samples.
        """
        return _btk.btkAnalog_SetValues(self, *args)

    def GetFrameNumber(self):
        """
        GetFrameNumber(self) -> int const

        Returns the number of frames.
        """
        return _btk.btkAnalog_GetFrameNumber(self)

    def SetFrameNumber(self, *args):
        """
        SetFrameNumber(self, int)

        Sets the number of frames.
        """
        return _btk.btkAnalog_SetFrameNumber(self, *args)

    def GetUnit(self):
        """
        GetUnit(self) -> std::string const &

        Returns the analog's unit.
        """
        return _btk.btkAnalog_GetUnit(self)

    def SetUnit(self, *args):
        """
        SetUnit(self, string)

        Sets the analog's unit.
        """
        return _btk.btkAnalog_SetUnit(self, *args)

    def GetGain(self):
        """
        GetGain(self) -> btkAnalog_impl::Gain const

        Returns the analog's gain.
        """
        return _btk.btkAnalog_GetGain(self)

    def SetGain(self, *args):
        """
        SetGain(self, int)

        Sets the analog's gain.
        """
        return _btk.btkAnalog_SetGain(self, *args)

    def GetOffset(self):
        """GetOffset(self) -> int const"""
        return _btk.btkAnalog_GetOffset(self)

    def SetOffset(self, *args):
        """SetOffset(self, arg2)"""
        return _btk.btkAnalog_SetOffset(self, *args)

    def GetScale(self):
        """GetScale(self) -> double const"""
        return _btk.btkAnalog_GetScale(self)

    def SetScale(self, *args):
        """SetScale(self, arg2)"""
        return _btk.btkAnalog_SetScale(self, *args)

    def SetDataSlice(self, *args):
        """SetDataSlice(self, arg2, arg3)"""
        return _btk.btkAnalog_SetDataSlice(self, *args)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkAnalog_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkAnalog_GetTimestamp(self)

btkAnalog_swigregister = _btk.btkAnalog_swigregister
btkAnalog_swigregister(btkAnalog)

class btkPoint(_object):
    """
    The coordinates of the point are generally measured by an acquisition system. For each frame, the
    3D value has a residual. It can provide informations on the quality of these 3D data 
    (residual associated with the reconstruction of the marker). 

    This class is also used to represent angles, forces, moments, powers and scalars. 
    To know/set the type of the point, you can use the methods GetType() and SetType(). 

    The type has a limited range of possible values and are listed in the following enumeration:
     - btk.btkPoint.Marker: Set the point object as a marker;
     - btk.btkPoint.Angle: Set the point object as an angle;
     - btk.btkPoint.Force: Set the point object as a force;
     - btk.btkPoint.Moment: Set the point object as a moment;
     - btk.btkPoint.Power: Set the point object as a power;
     - btk.btkPoint.Scalar: Set the point object as a scalar along the time;
     - btk.btkPoint.Reaction: Special type to indicate the point corresponds to one part of a wrench (not really used);

    Note: In some case the values at specific frames are invalid (mainly due to marker's occlusion).
    To detect if the frame is invalid, you can check the residual which will be 
    set to the value -1. It is the same thing if you want to set the frame as invalid. You can set
    the values of the frames to 0 and the associated residual to -1.

    Note: A residual with a value equal to 0 means that this frame has been post-processed (interpolation, filtering, etc.).
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkPoint, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkPoint, name)
    __repr__ = _swig_repr
    Marker = _btk.btkPoint_Marker
    Angle = _btk.btkPoint_Angle
    Force = _btk.btkPoint_Force
    Moment = _btk.btkPoint_Moment
    Power = _btk.btkPoint_Power
    Scalar = _btk.btkPoint_Scalar
    Reaction = _btk.btkPoint_Reaction
    def __init__(self, *args): 
        """
        __init__(self, frameNumber) -> btkPoint
        __init__(self, label, frameNumber, t=Marker, desc="") -> btkPoint
        __init__(self, label, frameNumber, t=Marker) -> btkPoint
        __init__(self, label, frameNumber) -> btkPoint

        The coordinates of the point are generally measured by an acquisition system. For each frame, the
        3D value has a residual. It can provide informations on the quality of these 3D data 
        (residual associated with the reconstruction of the marker). 

        This class is also used to represent angles, forces, moments, powers and scalars. 
        To know/set the type of the point, you can use the methods GetType() and SetType(). 

        The type has a limited range of possible values and are listed in the following enumeration:
         - btk.btkPoint.Marker: Set the point object as a marker;
         - btk.btkPoint.Angle: Set the point object as an angle;
         - btk.btkPoint.Force: Set the point object as a force;
         - btk.btkPoint.Moment: Set the point object as a moment;
         - btk.btkPoint.Power: Set the point object as a power;
         - btk.btkPoint.Scalar: Set the point object as a scalar along the time;
         - btk.btkPoint.Reaction: Special type to indicate the point corresponds to one part of a wrench (not really used);

        Note: In some case the values at specific frames are invalid (mainly due to marker's occlusion).
        To detect if the frame is invalid, you can check the residual which will be 
        set to the value -1. It is the same thing if you want to set the frame as invalid. You can set
        the values of the frames to 0 and the associated residual to -1.

        Note: A residual with a value equal to 0 means that this frame has been post-processed (interpolation, filtering, etc.).
        """
        this = _btk.new_btkPoint(*args)
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkPoint

        Deep copy of the object.
        """
        return _btk.btkPoint_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkPoint_impl *"""
        return _btk.btkPoint___deref__(self)

    def GetValue(self, *args):
        """
        GetValue(self, row, col) -> double

        Returns only one value for the given component and frame.
        """
        return _btk.btkPoint_GetValue(self, *args)

    def SetValue(self, *args):
        """
        SetValue(self, int, double)

        Sets only one value for the given component and frame.
        """
        return _btk.btkPoint_SetValue(self, *args)

    def GetResidual(self, *args):
        """
        GetResidual(self, idx) -> double

        Returns only one residual for the given frame.
        """
        return _btk.btkPoint_GetResidual(self, *args)

    def SetResidual(self, *args):
        """
        SetResidual(self, int, double)

        Sets only one residual for the given frame.
        """
        return _btk.btkPoint_SetResidual(self, *args)

    __swig_destroy__ = _btk.delete_btkPoint
    __del__ = lambda self : None;
    def GetLabel(self):
        """
        GetLabel(self) -> std::string const &

        Returns the point's label.
        """
        return _btk.btkPoint_GetLabel(self)

    def SetLabel(self, *args):
        """
        SetLabel(self, string)

        Sets the point's label.
        """
        return _btk.btkPoint_SetLabel(self, *args)

    def GetDescription(self):
        """
        GetDescription(self) -> std::string const &

        Returns the point's description.
        """
        return _btk.btkPoint_GetDescription(self)

    def SetDescription(self, *args):
        """
        SetDescription(self, string)

        Sets the point's description.
        """
        return _btk.btkPoint_SetDescription(self, *args)

    def GetValues(self):
        """
        GetValues(self) -> array (NumPy)

        Returns the point's values.
        WARNING:You cannot set values using this method. Use the methods SetValues of SetValue for that.
        """
        return _btk.btkPoint_GetValues(self)

    def SetValues(self, *args):
        """
        SetValues(self, array)

        Sets the point's values.
        """
        return _btk.btkPoint_SetValues(self, *args)

    def GetResiduals(self):
        """
        GetResiduals(self) -> array (NumPy)

        Returns the point's residuals.
        """
        return _btk.btkPoint_GetResiduals(self)

    def SetResiduals(self, *args):
        """
        SetResiduals(self, array)

        Sets the point's residuals.
        """
        return _btk.btkPoint_SetResiduals(self, *args)

    def GetFrameNumber(self):
        """
        GetFrameNumber(self) -> int const

        Returns the number of frames.
        """
        return _btk.btkPoint_GetFrameNumber(self)

    def SetFrameNumber(self, *args):
        """
        SetFrameNumber(self, int)

        Sets the number of frames.
        """
        return _btk.btkPoint_SetFrameNumber(self, *args)

    def GetType(self):
        """
        GetType(self) -> btkPoint_impl::Type const

        Returns the point's type.
        """
        return _btk.btkPoint_GetType(self)

    def SetType(self, *args):
        """
        SetUnit(self, int)

        Sets the point's type.
        """
        return _btk.btkPoint_SetType(self, *args)

    def SetDataSlice(self, *args):
        """
        SetDataSlice(self, arg2, arg3, arg4, arg5, res=0.0)
        SetDataSlice(self, arg2, arg3, arg4, arg5)

        Convenient method to easily set the coordinates x,y,z and the residual for the given frame.
        WARNING: This function is not safe. There is no checking to determine if the frame is out of range or not. It has the advantage to be faster.
        """
        return _btk.btkPoint_SetDataSlice(self, *args)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkPoint_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkPoint_GetTimestamp(self)

btkPoint_swigregister = _btk.btkPoint_swigregister
btkPoint_swigregister(btkPoint)

class btkForcePlatform(_object):
    """
    This class is generic and doesn't know its type, nor the number of analog channels used.
    To use predefined force platform as proposed in the documentation of the C3D file format, check the following classes:
     - btk::ForcePlatformType1: 6 channels (FX, FY, FZ, PX, PY, MZ);
     - btk::ForcePlatformType2: 6 channels (FX, FY, FZ, MX, MY, MZ);
     - btk::ForcePlatformType3: 8 channels (FZ1, FZ2, FZ3, FZ4, FX12, FX34, FY14, FY23);
     - btk::ForcePlatformType4: Same as Type-2 + calibration matrix 6 (columns) by 6 (rows);
     - btk::ForcePlatformType5: Same as Type-3 + calibration matrix 6 (columns) by 8 (rows);
     - btk::ForcePlatformType6: 12 channels (FX[1,2,3,4], FY[1,2,3,4], FZ[1,2,3,4] + calibration matrix 12 by 12).
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkForcePlatform, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkForcePlatform, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkForcePlatform

        This class is generic and doesn't know its type, nor the number of analog channels used.
        To use predefined force platform as proposed in the documentation of the C3D file format, check the following classes:
         - btk::ForcePlatformType1: 6 channels (FX, FY, FZ, PX, PY, MZ);
         - btk::ForcePlatformType2: 6 channels (FX, FY, FZ, MX, MY, MZ);
         - btk::ForcePlatformType3: 8 channels (FZ1, FZ2, FZ3, FZ4, FX12, FX34, FY14, FY23);
         - btk::ForcePlatformType4: Same as Type-2 + calibration matrix 6 (columns) by 6 (rows);
         - btk::ForcePlatformType5: Same as Type-3 + calibration matrix 6 (columns) by 8 (rows);
         - btk::ForcePlatformType6: 12 channels (FX[1,2,3,4], FY[1,2,3,4], FZ[1,2,3,4] + calibration matrix 12 by 12).
        """
        this = _btk.new_btkForcePlatform()
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkForcePlatform

        Deep copy of the object.
        """
        return _btk.btkForcePlatform_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkForcePlatform_impl *"""
        return _btk.btkForcePlatform___deref__(self)

    __swig_destroy__ = _btk.delete_btkForcePlatform
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkAnalogIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkForcePlatform_Begin(self)

    def End(self):
        """
        End(self) -> btkAnalogIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkForcePlatform_End(self)

    def GetChannelNumber(self):
        """
        GetChannelNumber(self) -> int

        Returns the number of analog channels used by the force platform.
        """
        return _btk.btkForcePlatform_GetChannelNumber(self)

    def GetChannel(self, *args):
        """
        GetChannel(self, int) -> btkAnalog)

        Returns the analog channel for the given index.
        """
        return _btk.btkForcePlatform_GetChannel(self, *args)

    def SetChannel(self, *args):
        """
        SetChannel(self, int , btkAnalog)

        Sets the analog channel for the given index.
        """
        return _btk.btkForcePlatform_SetChannel(self, *args)

    def GetChannels(self):
        """
        GetChannels(self) -> btkAnalogCollection

        Returns force platform's channels.
        """
        return _btk.btkForcePlatform_GetChannels(self)

    def GetOrigin(self):
        """
        GetOrigin(self) -> array (NumPy)

        Returns the origin of the force platform.
        """
        return _btk.btkForcePlatform_GetOrigin(self)

    def SetOrigin(self, *args):
        """
        SetOrigin(self, array)
        SetOrigin(self, double, double, double)

        Sets the origin.
        """
        return _btk.btkForcePlatform_SetOrigin(self, *args)

    def GetCorner(self, *args):
        """
        GetCorner(self, int) -> array (NumPy)

        Returns the corner for the given index.
        """
        return _btk.btkForcePlatform_GetCorner(self, *args)

    def SetCorner(self, *args):
        """
        SetCorner(self, int, int, double)
        SetCorner(self, int, double, double, double)
        SetCorner(self, int, array)

        Sets the corner for the given index.
        """
        return _btk.btkForcePlatform_SetCorner(self, *args)

    def GetCorners(self):
        """
        GetCorners(self) -> array (NumPy)

        Returns corners' coordinates.
        """
        return _btk.btkForcePlatform_GetCorners(self)

    def SetCorners(self, *args):
        """
        SetCorners(self, array)

        Sets corners' coordinates.
        """
        return _btk.btkForcePlatform_SetCorners(self, *args)

    def GetCalMatrix(self):
        """
        GetCalMatrix(self) -> array (NumPy)

        Returns the calibration matrix.
        """
        return _btk.btkForcePlatform_GetCalMatrix(self)

    def SetCalMatrix(self, *args):
        """
        SetCalMatrix(self, array)

        Sets the calibration matrix.
        """
        return _btk.btkForcePlatform_SetCalMatrix(self, *args)

    def GetType(self):
        """
        GetType(self) -> int

        Returns the type of the force platform.
        """
        return _btk.btkForcePlatform_GetType(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkForcePlatform_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatform_GetTimestamp(self)

btkForcePlatform_swigregister = _btk.btkForcePlatform_swigregister
btkForcePlatform_swigregister(btkForcePlatform)

class btkForcePlatformType1(btkForcePlatform):
    """
    Force platform composed of 6 channels:
     - FX: Horizontal forces on the axis X of the platform;
     - FY: Horizontal forces on the axis Y of the platform;
     - FZ: Vertical forces on the axis Z of the platform;
     - PX: Position of the centre of pressure (CoP) on the axis X of the platform;
     - PY: Position of the centre of pressure (CoP) on the axis Y of the platform;
     - MZ: Vertical moment on the axis Z of the platform.
    """
    __swig_setmethods__ = {}
    for _s in [btkForcePlatform]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkForcePlatformType1, name, value)
    __swig_getmethods__ = {}
    for _s in [btkForcePlatform]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkForcePlatformType1, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkForcePlatformType1
        __init__(self, toCopy) -> btkForcePlatformType1

        Force platform composed of 6 channels:
         - FX: Horizontal forces on the axis X of the platform;
         - FY: Horizontal forces on the axis Y of the platform;
         - FZ: Vertical forces on the axis Z of the platform;
         - PX: Position of the centre of pressure (CoP) on the axis X of the platform;
         - PY: Position of the centre of pressure (CoP) on the axis Y of the platform;
         - MZ: Vertical moment on the axis Z of the platform.
        """
        this = _btk.new_btkForcePlatformType1(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkForcePlatformType1_impl *"""
        return _btk.btkForcePlatformType1___deref__(self)

    __swig_destroy__ = _btk.delete_btkForcePlatformType1
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkAnalogIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkForcePlatformType1_Begin(self)

    def End(self):
        """
        End(self) -> btkAnalogIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkForcePlatformType1_End(self)

    def GetChannelNumber(self):
        """
        GetChannelNumber(self) -> int

        Returns the number of analog channels used by the force platform.
        """
        return _btk.btkForcePlatformType1_GetChannelNumber(self)

    def GetChannel(self, *args):
        """
        GetChannel(self, int) -> btkAnalog)

        Returns the analog channel for the given index.
        """
        return _btk.btkForcePlatformType1_GetChannel(self, *args)

    def SetChannel(self, *args):
        """
        SetChannel(self, int , btkAnalog)

        Sets the analog channel for the given index.
        """
        return _btk.btkForcePlatformType1_SetChannel(self, *args)

    def GetChannels(self):
        """
        GetChannels(self) -> btkAnalogCollection

        Returns force platform's channels.
        """
        return _btk.btkForcePlatformType1_GetChannels(self)

    def GetOrigin(self):
        """
        GetOrigin(self) -> array (NumPy)

        Returns the origin of the force platform.
        """
        return _btk.btkForcePlatformType1_GetOrigin(self)

    def SetOrigin(self, *args):
        """
        SetOrigin(self, array)
        SetOrigin(self, double, double, double)

        Sets the origin.
        """
        return _btk.btkForcePlatformType1_SetOrigin(self, *args)

    def GetCorner(self, *args):
        """
        GetCorner(self, int) -> array (NumPy)

        Returns the corner for the given index.
        """
        return _btk.btkForcePlatformType1_GetCorner(self, *args)

    def SetCorner(self, *args):
        """
        SetCorner(self, int, int, double)
        SetCorner(self, int, double, double, double)
        SetCorner(self, int, array)

        Sets the corner for the given index.
        """
        return _btk.btkForcePlatformType1_SetCorner(self, *args)

    def GetCorners(self):
        """
        GetCorners(self) -> array (NumPy)

        Returns corners' coordinates.
        """
        return _btk.btkForcePlatformType1_GetCorners(self)

    def SetCorners(self, *args):
        """
        SetCorners(self, array)

        Sets corners' coordinates.
        """
        return _btk.btkForcePlatformType1_SetCorners(self, *args)

    def GetCalMatrix(self):
        """
        GetCalMatrix(self) -> array (NumPy)

        Returns the calibration matrix.
        """
        return _btk.btkForcePlatformType1_GetCalMatrix(self)

    def SetCalMatrix(self, *args):
        """
        SetCalMatrix(self, array)

        Sets the calibration matrix.
        """
        return _btk.btkForcePlatformType1_SetCalMatrix(self, *args)

    def GetType(self):
        """
        GetType(self) -> int

        Returns the type of the force platform.
        """
        return _btk.btkForcePlatformType1_GetType(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkForcePlatformType1_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformType1_GetTimestamp(self)

btkForcePlatformType1_swigregister = _btk.btkForcePlatformType1_swigregister
btkForcePlatformType1_swigregister(btkForcePlatformType1)

class btkForcePlatformType2(btkForcePlatform):
    """
    Force platform composed of 6 channels:
     - FX: Horizontal forces on the axis X of the platform;
     - FY: Horizontal forces on the axis Y of the platform;
     - FZ: Vertical forces on the axis Z of the platform;
     - MX: Horizontal moment on the axis X of the platform;
     - MY: Horizontal moment on the axis Y of the platform;
     - MZ: Vertical moment on the axis Z of the platform.
    """
    __swig_setmethods__ = {}
    for _s in [btkForcePlatform]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkForcePlatformType2, name, value)
    __swig_getmethods__ = {}
    for _s in [btkForcePlatform]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkForcePlatformType2, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkForcePlatformType2
        __init__(self, toCopy) -> btkForcePlatformType2

        Force platform composed of 6 channels:
         - FX: Horizontal forces on the axis X of the platform;
         - FY: Horizontal forces on the axis Y of the platform;
         - FZ: Vertical forces on the axis Z of the platform;
         - MX: Horizontal moment on the axis X of the platform;
         - MY: Horizontal moment on the axis Y of the platform;
         - MZ: Vertical moment on the axis Z of the platform.
        """
        this = _btk.new_btkForcePlatformType2(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkForcePlatformType2_impl *"""
        return _btk.btkForcePlatformType2___deref__(self)

    __swig_destroy__ = _btk.delete_btkForcePlatformType2
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkAnalogIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkForcePlatformType2_Begin(self)

    def End(self):
        """
        End(self) -> btkAnalogIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkForcePlatformType2_End(self)

    def GetChannelNumber(self):
        """
        GetChannelNumber(self) -> int

        Returns the number of analog channels used by the force platform.
        """
        return _btk.btkForcePlatformType2_GetChannelNumber(self)

    def GetChannel(self, *args):
        """
        GetChannel(self, int) -> btkAnalog)

        Returns the analog channel for the given index.
        """
        return _btk.btkForcePlatformType2_GetChannel(self, *args)

    def SetChannel(self, *args):
        """
        SetChannel(self, int , btkAnalog)

        Sets the analog channel for the given index.
        """
        return _btk.btkForcePlatformType2_SetChannel(self, *args)

    def GetChannels(self):
        """
        GetChannels(self) -> btkAnalogCollection

        Returns force platform's channels.
        """
        return _btk.btkForcePlatformType2_GetChannels(self)

    def GetOrigin(self):
        """
        GetOrigin(self) -> array (NumPy)

        Returns the origin of the force platform.
        """
        return _btk.btkForcePlatformType2_GetOrigin(self)

    def SetOrigin(self, *args):
        """
        SetOrigin(self, array)
        SetOrigin(self, double, double, double)

        Sets the origin.
        """
        return _btk.btkForcePlatformType2_SetOrigin(self, *args)

    def GetCorner(self, *args):
        """
        GetCorner(self, int) -> array (NumPy)

        Returns the corner for the given index.
        """
        return _btk.btkForcePlatformType2_GetCorner(self, *args)

    def SetCorner(self, *args):
        """
        SetCorner(self, int, int, double)
        SetCorner(self, int, double, double, double)
        SetCorner(self, int, array)

        Sets the corner for the given index.
        """
        return _btk.btkForcePlatformType2_SetCorner(self, *args)

    def GetCorners(self):
        """
        GetCorners(self) -> array (NumPy)

        Returns corners' coordinates.
        """
        return _btk.btkForcePlatformType2_GetCorners(self)

    def SetCorners(self, *args):
        """
        SetCorners(self, array)

        Sets corners' coordinates.
        """
        return _btk.btkForcePlatformType2_SetCorners(self, *args)

    def GetCalMatrix(self):
        """
        GetCalMatrix(self) -> array (NumPy)

        Returns the calibration matrix.
        """
        return _btk.btkForcePlatformType2_GetCalMatrix(self)

    def SetCalMatrix(self, *args):
        """
        SetCalMatrix(self, array)

        Sets the calibration matrix.
        """
        return _btk.btkForcePlatformType2_SetCalMatrix(self, *args)

    def GetType(self):
        """
        GetType(self) -> int

        Returns the type of the force platform.
        """
        return _btk.btkForcePlatformType2_GetType(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkForcePlatformType2_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformType2_GetTimestamp(self)

btkForcePlatformType2_swigregister = _btk.btkForcePlatformType2_swigregister
btkForcePlatformType2_swigregister(btkForcePlatformType2)

class btkForcePlatformType3(btkForcePlatform):
    """
    Force platform composed of 8 channels:
     - FZ1: Vertical forces measured by the sensor on the corner 1;
     - FZ2: Vertical forces measured by the sensor on the corner 2;
     - FZ3: Vertical forces measured by the sensor on the corner 3;
     - FZ4: Vertical forces measured by the sensor on the corner 4;
     - FX12: Horizontal forces measured by the sensors 1 & 2;
     - FX34: Horizontal forces measured by the sensors 3 & 4;
     - FY14: Horizontal forces measured by the sensors 1 & 4;
     - FY23: Horizontal forces measured by the sensors 2 & 3.

    """
    __swig_setmethods__ = {}
    for _s in [btkForcePlatform]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkForcePlatformType3, name, value)
    __swig_getmethods__ = {}
    for _s in [btkForcePlatform]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkForcePlatformType3, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkForcePlatformType3
        __init__(self, toCopy) -> btkForcePlatformType3

        Force platform composed of 8 channels:
         - FZ1: Vertical forces measured by the sensor on the corner 1;
         - FZ2: Vertical forces measured by the sensor on the corner 2;
         - FZ3: Vertical forces measured by the sensor on the corner 3;
         - FZ4: Vertical forces measured by the sensor on the corner 4;
         - FX12: Horizontal forces measured by the sensors 1 & 2;
         - FX34: Horizontal forces measured by the sensors 3 & 4;
         - FY14: Horizontal forces measured by the sensors 1 & 4;
         - FY23: Horizontal forces measured by the sensors 2 & 3.

        """
        this = _btk.new_btkForcePlatformType3(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkForcePlatformType3_impl *"""
        return _btk.btkForcePlatformType3___deref__(self)

    __swig_destroy__ = _btk.delete_btkForcePlatformType3
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkAnalogIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkForcePlatformType3_Begin(self)

    def End(self):
        """
        End(self) -> btkAnalogIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkForcePlatformType3_End(self)

    def GetChannelNumber(self):
        """
        GetChannelNumber(self) -> int

        Returns the number of analog channels used by the force platform.
        """
        return _btk.btkForcePlatformType3_GetChannelNumber(self)

    def GetChannel(self, *args):
        """
        GetChannel(self, int) -> btkAnalog)

        Returns the analog channel for the given index.
        """
        return _btk.btkForcePlatformType3_GetChannel(self, *args)

    def SetChannel(self, *args):
        """
        SetChannel(self, int , btkAnalog)

        Sets the analog channel for the given index.
        """
        return _btk.btkForcePlatformType3_SetChannel(self, *args)

    def GetChannels(self):
        """
        GetChannels(self) -> btkAnalogCollection

        Returns force platform's channels.
        """
        return _btk.btkForcePlatformType3_GetChannels(self)

    def GetOrigin(self):
        """
        GetOrigin(self) -> array (NumPy)

        Returns the origin of the force platform.
        """
        return _btk.btkForcePlatformType3_GetOrigin(self)

    def SetOrigin(self, *args):
        """
        SetOrigin(self, array)
        SetOrigin(self, double, double, double)

        Sets the origin.
        """
        return _btk.btkForcePlatformType3_SetOrigin(self, *args)

    def GetCorner(self, *args):
        """
        GetCorner(self, int) -> array (NumPy)

        Returns the corner for the given index.
        """
        return _btk.btkForcePlatformType3_GetCorner(self, *args)

    def SetCorner(self, *args):
        """
        SetCorner(self, int, int, double)
        SetCorner(self, int, double, double, double)
        SetCorner(self, int, array)

        Sets the corner for the given index.
        """
        return _btk.btkForcePlatformType3_SetCorner(self, *args)

    def GetCorners(self):
        """
        GetCorners(self) -> array (NumPy)

        Returns corners' coordinates.
        """
        return _btk.btkForcePlatformType3_GetCorners(self)

    def SetCorners(self, *args):
        """
        SetCorners(self, array)

        Sets corners' coordinates.
        """
        return _btk.btkForcePlatformType3_SetCorners(self, *args)

    def GetCalMatrix(self):
        """
        GetCalMatrix(self) -> array (NumPy)

        Returns the calibration matrix.
        """
        return _btk.btkForcePlatformType3_GetCalMatrix(self)

    def SetCalMatrix(self, *args):
        """
        SetCalMatrix(self, array)

        Sets the calibration matrix.
        """
        return _btk.btkForcePlatformType3_SetCalMatrix(self, *args)

    def GetType(self):
        """
        GetType(self) -> int

        Returns the type of the force platform.
        """
        return _btk.btkForcePlatformType3_GetType(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkForcePlatformType3_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformType3_GetTimestamp(self)

btkForcePlatformType3_swigregister = _btk.btkForcePlatformType3_swigregister
btkForcePlatformType3_swigregister(btkForcePlatformType3)

class btkForcePlatformType4(btkForcePlatform):
    """
    Force platform composed of 6 channels and a 6 columns by 6 rows calibration matrix. 
    The definition of the channels are the same than the force platform Type 2.
    """
    __swig_setmethods__ = {}
    for _s in [btkForcePlatform]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkForcePlatformType4, name, value)
    __swig_getmethods__ = {}
    for _s in [btkForcePlatform]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkForcePlatformType4, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkForcePlatformType4
        __init__(self, toCopy) -> btkForcePlatformType4

        Force platform composed of 6 channels and a 6 columns by 6 rows calibration matrix. 
        The definition of the channels are the same than the force platform Type 2.
        """
        this = _btk.new_btkForcePlatformType4(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkForcePlatformType4_impl *"""
        return _btk.btkForcePlatformType4___deref__(self)

    __swig_destroy__ = _btk.delete_btkForcePlatformType4
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkAnalogIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkForcePlatformType4_Begin(self)

    def End(self):
        """
        End(self) -> btkAnalogIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkForcePlatformType4_End(self)

    def GetChannelNumber(self):
        """
        GetChannelNumber(self) -> int

        Returns the number of analog channels used by the force platform.
        """
        return _btk.btkForcePlatformType4_GetChannelNumber(self)

    def GetChannel(self, *args):
        """
        GetChannel(self, int) -> btkAnalog)

        Returns the analog channel for the given index.
        """
        return _btk.btkForcePlatformType4_GetChannel(self, *args)

    def SetChannel(self, *args):
        """
        SetChannel(self, int , btkAnalog)

        Sets the analog channel for the given index.
        """
        return _btk.btkForcePlatformType4_SetChannel(self, *args)

    def GetChannels(self):
        """
        GetChannels(self) -> btkAnalogCollection

        Returns force platform's channels.
        """
        return _btk.btkForcePlatformType4_GetChannels(self)

    def GetOrigin(self):
        """
        GetOrigin(self) -> array (NumPy)

        Returns the origin of the force platform.
        """
        return _btk.btkForcePlatformType4_GetOrigin(self)

    def SetOrigin(self, *args):
        """
        SetOrigin(self, array)
        SetOrigin(self, double, double, double)

        Sets the origin.
        """
        return _btk.btkForcePlatformType4_SetOrigin(self, *args)

    def GetCorner(self, *args):
        """
        GetCorner(self, int) -> array (NumPy)

        Returns the corner for the given index.
        """
        return _btk.btkForcePlatformType4_GetCorner(self, *args)

    def SetCorner(self, *args):
        """
        SetCorner(self, int, int, double)
        SetCorner(self, int, double, double, double)
        SetCorner(self, int, array)

        Sets the corner for the given index.
        """
        return _btk.btkForcePlatformType4_SetCorner(self, *args)

    def GetCorners(self):
        """
        GetCorners(self) -> array (NumPy)

        Returns corners' coordinates.
        """
        return _btk.btkForcePlatformType4_GetCorners(self)

    def SetCorners(self, *args):
        """
        SetCorners(self, array)

        Sets corners' coordinates.
        """
        return _btk.btkForcePlatformType4_SetCorners(self, *args)

    def GetCalMatrix(self):
        """
        GetCalMatrix(self) -> array (NumPy)

        Returns the calibration matrix.
        """
        return _btk.btkForcePlatformType4_GetCalMatrix(self)

    def SetCalMatrix(self, *args):
        """
        SetCalMatrix(self, array)

        Sets the calibration matrix.
        """
        return _btk.btkForcePlatformType4_SetCalMatrix(self, *args)

    def GetType(self):
        """
        GetType(self) -> int

        Returns the type of the force platform.
        """
        return _btk.btkForcePlatformType4_GetType(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkForcePlatformType4_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformType4_GetTimestamp(self)

btkForcePlatformType4_swigregister = _btk.btkForcePlatformType4_swigregister
btkForcePlatformType4_swigregister(btkForcePlatformType4)

class btkForcePlatformType5(btkForcePlatform):
    """
    Force platform composed of 8 channels and a 8 columns by 6 rows calibration matrix. 
    The definition of the channels are the same than the force platform Type 3.
    """
    __swig_setmethods__ = {}
    for _s in [btkForcePlatform]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkForcePlatformType5, name, value)
    __swig_getmethods__ = {}
    for _s in [btkForcePlatform]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkForcePlatformType5, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkForcePlatformType5
        __init__(self, toCopy) -> btkForcePlatformType5

        Force platform composed of 8 channels and a 8 columns by 6 rows calibration matrix. 
        The definition of the channels are the same than the force platform Type 3.
        """
        this = _btk.new_btkForcePlatformType5(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkForcePlatformType5_impl *"""
        return _btk.btkForcePlatformType5___deref__(self)

    __swig_destroy__ = _btk.delete_btkForcePlatformType5
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkAnalogIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkForcePlatformType5_Begin(self)

    def End(self):
        """
        End(self) -> btkAnalogIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkForcePlatformType5_End(self)

    def GetChannelNumber(self):
        """
        GetChannelNumber(self) -> int

        Returns the number of analog channels used by the force platform.
        """
        return _btk.btkForcePlatformType5_GetChannelNumber(self)

    def GetChannel(self, *args):
        """
        GetChannel(self, int) -> btkAnalog)

        Returns the analog channel for the given index.
        """
        return _btk.btkForcePlatformType5_GetChannel(self, *args)

    def SetChannel(self, *args):
        """
        SetChannel(self, int , btkAnalog)

        Sets the analog channel for the given index.
        """
        return _btk.btkForcePlatformType5_SetChannel(self, *args)

    def GetChannels(self):
        """
        GetChannels(self) -> btkAnalogCollection

        Returns force platform's channels.
        """
        return _btk.btkForcePlatformType5_GetChannels(self)

    def GetOrigin(self):
        """
        GetOrigin(self) -> array (NumPy)

        Returns the origin of the force platform.
        """
        return _btk.btkForcePlatformType5_GetOrigin(self)

    def SetOrigin(self, *args):
        """
        SetOrigin(self, array)
        SetOrigin(self, double, double, double)

        Sets the origin.
        """
        return _btk.btkForcePlatformType5_SetOrigin(self, *args)

    def GetCorner(self, *args):
        """
        GetCorner(self, int) -> array (NumPy)

        Returns the corner for the given index.
        """
        return _btk.btkForcePlatformType5_GetCorner(self, *args)

    def SetCorner(self, *args):
        """
        SetCorner(self, int, int, double)
        SetCorner(self, int, double, double, double)
        SetCorner(self, int, array)

        Sets the corner for the given index.
        """
        return _btk.btkForcePlatformType5_SetCorner(self, *args)

    def GetCorners(self):
        """
        GetCorners(self) -> array (NumPy)

        Returns corners' coordinates.
        """
        return _btk.btkForcePlatformType5_GetCorners(self)

    def SetCorners(self, *args):
        """
        SetCorners(self, array)

        Sets corners' coordinates.
        """
        return _btk.btkForcePlatformType5_SetCorners(self, *args)

    def GetCalMatrix(self):
        """
        GetCalMatrix(self) -> array (NumPy)

        Returns the calibration matrix.
        """
        return _btk.btkForcePlatformType5_GetCalMatrix(self)

    def SetCalMatrix(self, *args):
        """
        SetCalMatrix(self, array)

        Sets the calibration matrix.
        """
        return _btk.btkForcePlatformType5_SetCalMatrix(self, *args)

    def GetType(self):
        """
        GetType(self) -> int

        Returns the type of the force platform.
        """
        return _btk.btkForcePlatformType5_GetType(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkForcePlatformType5_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformType5_GetTimestamp(self)

btkForcePlatformType5_swigregister = _btk.btkForcePlatformType5_swigregister
btkForcePlatformType5_swigregister(btkForcePlatformType5)

class btkForcePlatformType6(btkForcePlatform):
    """
    Force platform composed of 12 channels and a 12 columns by 12 rows calibration matrix:
     - FX1: Horizontal forces measured by the sensor on the corner 1;
     - FX2: Horizontal forces measured by the sensor on the corner 2;
     - FX3: Horizontal forces measured by the sensor on the corner 3;
     - FX4: Horizontal forces measured by the sensor on the corner 4;
     - FY1: Horizontal forces measured by the sensor on the corner 1;
     - FY2: Horizontal forces measured by the sensor on the corner 2;
     - FY3: Horizontal forces measured by the sensor on the corner 3;
     - FY4: Horizontal forces measured by the sensor on the corner 4;
     - FZ1: Vertical forces measured by the sensor on the corner 1;
     - FZ2: Vertical forces measured by the sensor on the corner 2;
     - FZ3: Vertical forces measured by the sensor on the corner 3;
     - FZ4: Vertical forces measured by the sensor on the corner 4.
    """
    __swig_setmethods__ = {}
    for _s in [btkForcePlatform]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkForcePlatformType6, name, value)
    __swig_getmethods__ = {}
    for _s in [btkForcePlatform]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkForcePlatformType6, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkForcePlatformType6
        __init__(self, toCopy) -> btkForcePlatformType6

        Force platform composed of 12 channels and a 12 columns by 12 rows calibration matrix:
         - FX1: Horizontal forces measured by the sensor on the corner 1;
         - FX2: Horizontal forces measured by the sensor on the corner 2;
         - FX3: Horizontal forces measured by the sensor on the corner 3;
         - FX4: Horizontal forces measured by the sensor on the corner 4;
         - FY1: Horizontal forces measured by the sensor on the corner 1;
         - FY2: Horizontal forces measured by the sensor on the corner 2;
         - FY3: Horizontal forces measured by the sensor on the corner 3;
         - FY4: Horizontal forces measured by the sensor on the corner 4;
         - FZ1: Vertical forces measured by the sensor on the corner 1;
         - FZ2: Vertical forces measured by the sensor on the corner 2;
         - FZ3: Vertical forces measured by the sensor on the corner 3;
         - FZ4: Vertical forces measured by the sensor on the corner 4.
        """
        this = _btk.new_btkForcePlatformType6(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkForcePlatformType6_impl *"""
        return _btk.btkForcePlatformType6___deref__(self)

    __swig_destroy__ = _btk.delete_btkForcePlatformType6
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkAnalogIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkForcePlatformType6_Begin(self)

    def End(self):
        """
        End(self) -> btkAnalogIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkForcePlatformType6_End(self)

    def GetChannelNumber(self):
        """
        GetChannelNumber(self) -> int

        Returns the number of analog channels used by the force platform.
        """
        return _btk.btkForcePlatformType6_GetChannelNumber(self)

    def GetChannel(self, *args):
        """
        GetChannel(self, int) -> btkAnalog)

        Returns the analog channel for the given index.
        """
        return _btk.btkForcePlatformType6_GetChannel(self, *args)

    def SetChannel(self, *args):
        """
        SetChannel(self, int , btkAnalog)

        Sets the analog channel for the given index.
        """
        return _btk.btkForcePlatformType6_SetChannel(self, *args)

    def GetChannels(self):
        """
        GetChannels(self) -> btkAnalogCollection

        Returns force platform's channels.
        """
        return _btk.btkForcePlatformType6_GetChannels(self)

    def GetOrigin(self):
        """
        GetOrigin(self) -> array (NumPy)

        Returns the origin of the force platform.
        """
        return _btk.btkForcePlatformType6_GetOrigin(self)

    def SetOrigin(self, *args):
        """
        SetOrigin(self, array)
        SetOrigin(self, double, double, double)

        Sets the origin.
        """
        return _btk.btkForcePlatformType6_SetOrigin(self, *args)

    def GetCorner(self, *args):
        """
        GetCorner(self, int) -> array (NumPy)

        Returns the corner for the given index.
        """
        return _btk.btkForcePlatformType6_GetCorner(self, *args)

    def SetCorner(self, *args):
        """
        SetCorner(self, int, int, double)
        SetCorner(self, int, double, double, double)
        SetCorner(self, int, array)

        Sets the corner for the given index.
        """
        return _btk.btkForcePlatformType6_SetCorner(self, *args)

    def GetCorners(self):
        """
        GetCorners(self) -> array (NumPy)

        Returns corners' coordinates.
        """
        return _btk.btkForcePlatformType6_GetCorners(self)

    def SetCorners(self, *args):
        """
        SetCorners(self, array)

        Sets corners' coordinates.
        """
        return _btk.btkForcePlatformType6_SetCorners(self, *args)

    def GetCalMatrix(self):
        """
        GetCalMatrix(self) -> array (NumPy)

        Returns the calibration matrix.
        """
        return _btk.btkForcePlatformType6_GetCalMatrix(self)

    def SetCalMatrix(self, *args):
        """
        SetCalMatrix(self, array)

        Sets the calibration matrix.
        """
        return _btk.btkForcePlatformType6_SetCalMatrix(self, *args)

    def GetType(self):
        """
        GetType(self) -> int

        Returns the type of the force platform.
        """
        return _btk.btkForcePlatformType6_GetType(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkForcePlatformType6_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformType6_GetTimestamp(self)

btkForcePlatformType6_swigregister = _btk.btkForcePlatformType6_swigregister
btkForcePlatformType6_swigregister(btkForcePlatformType6)

class btkWrench(_object):
    """
    Represents a wrench as position, force and moment varying during the time.

    This class is mainly used to have a compact way to store forces and moment acting (or reacting) at a given position.
    The moment should be expressed at the position as it is defined in general mechanics.

    By default, the label used for the forces and the moments corresponds to the given label followed by the suffix '.F' and '.M' respectively.

    Warning: The call of the constructor btkWrench(label) must be followed by the use of the method btkWrench::SetFrameNumber as it creates a null matrix for the values.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkWrench, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkWrench, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, label="") -> btkWrench
        __init__(self) -> btkWrench
        __init__(self, frameNumber) -> btkWrench
        __init__(self, label, frameNumber) -> btkWrench

        Represents a wrench as position, force and moment varying during the time.

        This class is mainly used to have a compact way to store forces and moment acting (or reacting) at a given position.
        The moment should be expressed at the position as it is defined in general mechanics.

        By default, the label used for the forces and the moments corresponds to the given label followed by the suffix '.F' and '.M' respectively.

        Warning: The call of the constructor btkWrench(label) must be followed by the use of the method btkWrench::SetFrameNumber as it creates a null matrix for the values.
        """
        this = _btk.new_btkWrench(*args)
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """Clone(self) -> btkWrench"""
        return _btk.btkWrench_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkWrench_impl *"""
        return _btk.btkWrench___deref__(self)

    __swig_destroy__ = _btk.delete_btkWrench
    __del__ = lambda self : None;
    def GetPosition(self):
        """
        GetPosition(self) -> btkPoint

        Returns the wrench's position.
        """
        return _btk.btkWrench_GetPosition(self)

    def SetPosition(self, *args):
        """
        SetPosition(self, btkPoint)

        Sets the wrench's position.
        """
        return _btk.btkWrench_SetPosition(self, *args)

    def GetForce(self):
        """
        GetForce(self) -> btkPoint

        Returns the wrench's force.
        """
        return _btk.btkWrench_GetForce(self)

    def SetForce(self, *args):
        """
        SetForce(self, btkPoint)

        Sets the wrench's moment.
        """
        return _btk.btkWrench_SetForce(self, *args)

    def GetMoment(self):
        """
        GetMoment(self) -> btkPoint

        Returns the wrench's moment.
        """
        return _btk.btkWrench_GetMoment(self)

    def SetMoment(self, *args):
        """SetMoment(self, btkPoint)"""
        return _btk.btkWrench_SetMoment(self, *args)

    def GetComponent(self, *args):
        """
        GetComponent(self, int) -> btkPoint)

        Returns the component with the given index. The possible value for the index are: 0: Returns the position, 1: Returns the force, 2: Returns the moment. Any other value will trigger an exception.
        """
        return _btk.btkWrench_GetComponent(self, *args)

    def SetFrameNumber(self, *args):
        """
        SetFrameNumber(self, int)

        Set the number of frames in the wrenches. The given number of frames must be greater than 0.
        """
        return _btk.btkWrench_SetFrameNumber(self, *args)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkWrench_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkWrench_GetTimestamp(self)

btkWrench_swigregister = _btk.btkWrench_swigregister
btkWrench_swigregister(btkWrench)

class btkIMU(_object):
    """
    Container of analog channels representing an inertial measurement unit (IMU).

    This class proposes to store any number of analog channels but the 6 first channels could be 
    used for 3 accelerometers and 3 gyroscopes as some convenient methods are proposed in this way
    (see SetChannels(), GetAccelerometerX(), GetAccelerometerY(), GetAccelerometerZ(), GetGyroscopeX(), GetGyroscopeY(), GetGyroscopeZ()).

    The storage of the channel is done using an ID and not an array index. You can then use the same ID for some kind of sensor even if other are missing (i.e. IMU with accelerometers disabled or configured with 1 acc, and 2 gyros., etc.).

    Note: This class is still experimental and could be modified in the next release.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkIMU, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkIMU, name)
    __repr__ = _swig_repr
    def __init__(self, label="IMU", desc=""): 
        """
        __init__(self, label="IMU", desc="") -> btkIMU
        __init__(self, label="IMU") -> btkIMU
        __init__(self) -> btkIMU

        Container of analog channels representing an inertial measurement unit (IMU).

        This class proposes to store any number of analog channels but the 6 first channels could be 
        used for 3 accelerometers and 3 gyroscopes as some convenient methods are proposed in this way
        (see SetChannels(), GetAccelerometerX(), GetAccelerometerY(), GetAccelerometerZ(), GetGyroscopeX(), GetGyroscopeY(), GetGyroscopeZ()).

        The storage of the channel is done using an ID and not an array index. You can then use the same ID for some kind of sensor even if other are missing (i.e. IMU with accelerometers disabled or configured with 1 acc, and 2 gyros., etc.).

        Note: This class is still experimental and could be modified in the next release.
        """
        this = _btk.new_btkIMU(label, desc)
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkIMU

        Deep copy of the object
        """
        return _btk.btkIMU_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkIMU_impl *"""
        return _btk.btkIMU___deref__(self)

    __swig_destroy__ = _btk.delete_btkIMU
    __del__ = lambda self : None;
    def GetLabel(self):
        """GetLabel(self) -> std::string const &"""
        return _btk.btkIMU_GetLabel(self)

    def SetLabel(self, *args):
        """SetLabel(self, arg2)"""
        return _btk.btkIMU_SetLabel(self, *args)

    def GetDescription(self):
        """GetDescription(self) -> std::string const &"""
        return _btk.btkIMU_GetDescription(self)

    def SetDescription(self, *args):
        """SetDescription(self, arg2)"""
        return _btk.btkIMU_SetDescription(self, *args)

    def SetChannels(self, *args):
        """
        SetChannels(self, btkAnalog, btkAnalog, btkAnalog, btkAnalog, btkAnalog, btkAnalog)

        Sets the 6 first channels of the IMUs with the analog channels @a accX, @a accY, @a accZ, @a gyroX, @a gyroY, @a gyroZ.
        """
        return _btk.btkIMU_SetChannels(self, *args)

    def GetChannels(self):
        """
        GetChannels(self) -> btkAnalogCollection

        Returns the analog channels of the IMU in a collection. The analog channels are pushed in the collection by using their ID.
        """
        return _btk.btkIMU_GetChannels(self)

    def SetChannel(self, *args):
        """
        SetChannel(self, id, btkAnalog)

        Sets an analog channel to the given ID. If an analog channel is already set to this ID, then it is replaced.
        """
        return _btk.btkIMU_SetChannel(self, *args)

    def GetChannel(self, *args):
        """
        GetChannel(self, id) -> btkAnalog
        GetChannel(self, arg2) -> btkAnalog

        Returns the analog channel with the given ID or label. If there is no analog channel with the given ID, then an exception is thrown.
        """
        return _btk.btkIMU_GetChannel(self, *args)

    def GetFrameNumber(self):
        """
        GetFrameNumber(self) -> int

        Returns the number of frames set in this IMU.
        """
        return _btk.btkIMU_GetFrameNumber(self)

    def SetFrameNumber(self, *args):
        """
        SetFrameNumber(self, fn)

        Set the number of frames for the IMU and modify also the number of frames for the channels.
        """
        return _btk.btkIMU_SetFrameNumber(self, *args)

    def GetFrequency(self):
        """
        GetFrequency(self) -> double

        Returns the frequency set to the IMU. (by default it is 0 Hz).
        """
        return _btk.btkIMU_GetFrequency(self)

    def SetFrequency(self, *args):
        """
        SetFrequency(self, f)

        Sets the acquisition sample rate associated to the IMU.
        """
        return _btk.btkIMU_SetFrequency(self, *args)

    def GetAccelerometerX(self):
        """
        GetAccelerometerX(self) -> btkAnalog

        Convenient method to return the analog channel with the ID 0 (which should correspond to an accelerometer measuring data on the X axis of the IMU).
        """
        return _btk.btkIMU_GetAccelerometerX(self)

    def GetAccelerometerY(self):
        """
        GetAccelerometerY(self) -> btkAnalog

        Convenient method to return the analog channel with the ID 1 (which should correspond to an accelerometer measuring data on the Y axis of the IMU).
        """
        return _btk.btkIMU_GetAccelerometerY(self)

    def GetAccelerometerZ(self):
        """
        GetAccelerometerZ(self) -> btkAnalog

        Convenient method to return the analog channel with the ID 2 (which should correspond to an accelerometer measuring data on the Z axis of the IMU).
        """
        return _btk.btkIMU_GetAccelerometerZ(self)

    def GetGyroscopeX(self):
        """
        GetGyroscopeX(self) -> btkAnalog

        Convenient method to return the analog channel with the ID 3 (which should correspond to a gyroscope measuring data on the X axis of the IMU).
        """
        return _btk.btkIMU_GetGyroscopeX(self)

    def GetGyroscopeY(self):
        """
        GetGyroscopeY(self) -> btkAnalog

        Convenient method to return the analog channel with the ID 4 (which should correspond to a gyroscope measuring data on the Y axis of the IMU).
        """
        return _btk.btkIMU_GetGyroscopeY(self)

    def GetGyroscopeZ(self):
        """
        GetGyroscopeZ(self) -> btkAnalog

        Convenient method to return the analog channel with the ID 5 (which should correspond to a gyroscope measuring data on the Z axis of the IMU).
        """
        return _btk.btkIMU_GetGyroscopeZ(self)

    def Rotate(self, *args):
        """
        Rotate(self, arg2)

        Convenient method to rotate the analog channels with the IDs 0-5. This method handles the case where some of these analog channels are missing.
        """
        return _btk.btkIMU_Rotate(self, *args)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkIMU_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkIMU_GetTimestamp(self)

btkIMU_swigregister = _btk.btkIMU_swigregister
btkIMU_swigregister(btkIMU)

class btkEventCollectionIterator(_object):
    """Proxy of C++ btkEventCollectionIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkEventCollectionIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkEventCollectionIterator, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> btkEventCollectionIterator"""
        this = _btk.new_btkEventCollectionIterator()
        try: self.this.append(this)
        except: self.this = this
    def incr(self):
        """incr(self)"""
        return _btk.btkEventCollectionIterator_incr(self)

    def decr(self):
        """decr(self)"""
        return _btk.btkEventCollectionIterator_decr(self)

    def value(self):
        """value(self) -> btkEvent"""
        return _btk.btkEventCollectionIterator_value(self)

    def __eq__(self, *args):
        """__eq__(self, rhs) -> bool"""
        return _btk.btkEventCollectionIterator___eq__(self, *args)

    def __ne__(self, *args):
        """__ne__(self, rhs) -> bool"""
        return _btk.btkEventCollectionIterator___ne__(self, *args)

    __swig_destroy__ = _btk.delete_btkEventCollectionIterator
    __del__ = lambda self : None;
btkEventCollectionIterator_swigregister = _btk.btkEventCollectionIterator_swigregister
btkEventCollectionIterator_swigregister(btkEventCollectionIterator)

class btkEventCollection(_object):
    """
    Collection of events stored in a list.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkEventCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkEventCollection, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkEventCollection

        Collection of events stored in a list.
        """
        this = _btk.new_btkEventCollection()
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkEventCollection

        Deep copy of the object
        """
        return _btk.btkEventCollection_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkEventCollection_impl *"""
        return _btk.btkEventCollection___deref__(self)

    __swig_destroy__ = _btk.delete_btkEventCollection
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkEventIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkEventCollection_Begin(self)

    def End(self):
        """
        End(self) -> btkEventIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkEventCollection_End(self)

    def IsEmpty(self):
        """
        IsEmpty(self) -> bool

        Returns true if the collection is empty.
        """
        return _btk.btkEventCollection_IsEmpty(self)

    def GetItemNumber(self):
        """
        GetItemNumber(self) -> int

        Returns the number of events
        """
        return _btk.btkEventCollection_GetItemNumber(self)

    def SetItemNumber(self, *args):
        """
        SetItemNumber(self, arg2)

        Sets the number of events
        """
        return _btk.btkEventCollection_SetItemNumber(self, *args)

    def GetIndexOf(self, *args):
        """
        GetIndexOf(self, int) -> btkEvent

        Returns the index of the given item.
        """
        return _btk.btkEventCollection_GetIndexOf(self, *args)

    def GetItem(self, *args):
        """
        GetItem(self, int) -> btkEvent

        Returns the event for the given index.
        """
        return _btk.btkEventCollection_GetItem(self, *args)

    def InsertItem(self, *args):
        """
        InsertItem(self, btkEventIterator, btkEvent) -> bool
        InsertItem(self, int, btkEvent) -> bool
        InsertItem(self, btkEvent) -> bool

        Inserts an event in the list.
        """
        return _btk.btkEventCollection_InsertItem(self, *args)

    def SetItem(self, *args):
        """
        SetItem(self, int) -> btkEvent

        Sets an event.
        """
        return _btk.btkEventCollection_SetItem(self, *args)

    def RemoveItem(self, *args):
        """
        RemoveItem(self, btkEventIterator) -> btkEventIterator
        RemoveItem(self, int)

        Removes an event.
        """
        return _btk.btkEventCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        """
        TakeItem(self, btkEventIterator) -> btkEvent
        TakeItem(self, int) -> btkEvent

        Removes an event and return it.
        """
        return _btk.btkEventCollection_TakeItem(self, *args)

    def Clear(self):
        """
        Clear(self)

        Clear the contents of the collection.
        """
        return _btk.btkEventCollection_Clear(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkEventCollection_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkEventCollection_GetTimestamp(self)

btkEventCollection_swigregister = _btk.btkEventCollection_swigregister
btkEventCollection_swigregister(btkEventCollection)

class btkAnalogCollectionIterator(_object):
    """Proxy of C++ btkAnalogCollectionIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkAnalogCollectionIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkAnalogCollectionIterator, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> btkAnalogCollectionIterator"""
        this = _btk.new_btkAnalogCollectionIterator()
        try: self.this.append(this)
        except: self.this = this
    def incr(self):
        """incr(self)"""
        return _btk.btkAnalogCollectionIterator_incr(self)

    def decr(self):
        """decr(self)"""
        return _btk.btkAnalogCollectionIterator_decr(self)

    def value(self):
        """value(self) -> btkAnalog"""
        return _btk.btkAnalogCollectionIterator_value(self)

    def __eq__(self, *args):
        """__eq__(self, rhs) -> bool"""
        return _btk.btkAnalogCollectionIterator___eq__(self, *args)

    def __ne__(self, *args):
        """__ne__(self, rhs) -> bool"""
        return _btk.btkAnalogCollectionIterator___ne__(self, *args)

    __swig_destroy__ = _btk.delete_btkAnalogCollectionIterator
    __del__ = lambda self : None;
btkAnalogCollectionIterator_swigregister = _btk.btkAnalogCollectionIterator_swigregister
btkAnalogCollectionIterator_swigregister(btkAnalogCollectionIterator)

class btkAnalogCollection(_object):
    """
    Collection of analog channels stored in a list.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkAnalogCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkAnalogCollection, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkAnalogCollection

        Collection of analog channels stored in a list.
        """
        this = _btk.new_btkAnalogCollection()
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkAnalogCollection

        Deep copy of the object
        """
        return _btk.btkAnalogCollection_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkAnalogCollection_impl *"""
        return _btk.btkAnalogCollection___deref__(self)

    __swig_destroy__ = _btk.delete_btkAnalogCollection
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkAnalogIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkAnalogCollection_Begin(self)

    def End(self):
        """
        End(self) -> btkAnalogIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkAnalogCollection_End(self)

    def IsEmpty(self):
        """
        IsEmpty(self) -> bool

        Returns true if the collection is empty.
        """
        return _btk.btkAnalogCollection_IsEmpty(self)

    def GetItemNumber(self):
        """
        GetItemNumber(self) -> int

        Returns the number of analog channels
        """
        return _btk.btkAnalogCollection_GetItemNumber(self)

    def SetItemNumber(self, *args):
        """
        SetItemNumber(self, arg2)

        Sets the number of analog channels
        """
        return _btk.btkAnalogCollection_SetItemNumber(self, *args)

    def GetIndexOf(self, *args):
        """
        GetIndexOf(self, int) -> btkAnalog

        Returns the index of the given item.
        """
        return _btk.btkAnalogCollection_GetIndexOf(self, *args)

    def GetItem(self, *args):
        """
        GetItem(self, int) -> btkAnalog

        Returns the analog channel for the given index.
        """
        return _btk.btkAnalogCollection_GetItem(self, *args)

    def InsertItem(self, *args):
        """
        InsertItem(self, btkAnalogIterator, btkAnalog) -> bool
        InsertItem(self, int, btkAnalog) -> bool
        InsertItem(self, btkAnalog) -> bool

        Inserts an analog channel in the list.
        """
        return _btk.btkAnalogCollection_InsertItem(self, *args)

    def SetItem(self, *args):
        """
        SetItem(self, int) -> btkAnalog

        Sets an analog channel.
        """
        return _btk.btkAnalogCollection_SetItem(self, *args)

    def RemoveItem(self, *args):
        """
        RemoveItem(self, btkAnalogIterator) -> btkAnalogIterator
        RemoveItem(self, int)

        Removes an analog channel.
        """
        return _btk.btkAnalogCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        """
        TakeItem(self, btkAnalogIterator) -> btkAnalog
        TakeItem(self, int) -> btkAnalog

        Removes an analog channel and return it.
        """
        return _btk.btkAnalogCollection_TakeItem(self, *args)

    def Clear(self):
        """
        Clear(self)

        Clear the contents of the collection.
        """
        return _btk.btkAnalogCollection_Clear(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkAnalogCollection_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkAnalogCollection_GetTimestamp(self)

btkAnalogCollection_swigregister = _btk.btkAnalogCollection_swigregister
btkAnalogCollection_swigregister(btkAnalogCollection)

class btkPointCollectionIterator(_object):
    """Proxy of C++ btkPointCollectionIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkPointCollectionIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkPointCollectionIterator, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> btkPointCollectionIterator"""
        this = _btk.new_btkPointCollectionIterator()
        try: self.this.append(this)
        except: self.this = this
    def incr(self):
        """incr(self)"""
        return _btk.btkPointCollectionIterator_incr(self)

    def decr(self):
        """decr(self)"""
        return _btk.btkPointCollectionIterator_decr(self)

    def value(self):
        """value(self) -> btkPoint"""
        return _btk.btkPointCollectionIterator_value(self)

    def __eq__(self, *args):
        """__eq__(self, rhs) -> bool"""
        return _btk.btkPointCollectionIterator___eq__(self, *args)

    def __ne__(self, *args):
        """__ne__(self, rhs) -> bool"""
        return _btk.btkPointCollectionIterator___ne__(self, *args)

    __swig_destroy__ = _btk.delete_btkPointCollectionIterator
    __del__ = lambda self : None;
btkPointCollectionIterator_swigregister = _btk.btkPointCollectionIterator_swigregister
btkPointCollectionIterator_swigregister(btkPointCollectionIterator)

class btkPointCollection(_object):
    """
    Collection of point stored in a list.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkPointCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkPointCollection, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkPointCollection

        Collection of point stored in a list.
        """
        this = _btk.new_btkPointCollection()
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkPointCollection

        Deep copy of the object
        """
        return _btk.btkPointCollection_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkPointCollection_impl *"""
        return _btk.btkPointCollection___deref__(self)

    __swig_destroy__ = _btk.delete_btkPointCollection
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkPointIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkPointCollection_Begin(self)

    def End(self):
        """
        End(self) -> btkPointIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkPointCollection_End(self)

    def IsEmpty(self):
        """
        IsEmpty(self) -> bool

        Returns true if the collection is empty.
        """
        return _btk.btkPointCollection_IsEmpty(self)

    def GetItemNumber(self):
        """
        GetItemNumber(self) -> int

        Returns the number of points
        """
        return _btk.btkPointCollection_GetItemNumber(self)

    def SetItemNumber(self, *args):
        """
        SetItemNumber(self, arg2)

        Sets the number of points
        """
        return _btk.btkPointCollection_SetItemNumber(self, *args)

    def GetIndexOf(self, *args):
        """
        GetIndexOf(self, int) -> btkPoint

        Returns the index of the given item.
        """
        return _btk.btkPointCollection_GetIndexOf(self, *args)

    def GetItem(self, *args):
        """
        GetItem(self, int) -> btkPoint

        Returns the point for the given index.
        """
        return _btk.btkPointCollection_GetItem(self, *args)

    def InsertItem(self, *args):
        """
        InsertItem(self, btkPointIterator, btkPoint) -> bool
        InsertItem(self, int, btkPoint) -> bool
        InsertItem(self, btkPoint) -> bool

        Inserts a point in the list.
        """
        return _btk.btkPointCollection_InsertItem(self, *args)

    def SetItem(self, *args):
        """
        SetItem(self, int) -> btkPoint

        Sets a point.
        """
        return _btk.btkPointCollection_SetItem(self, *args)

    def RemoveItem(self, *args):
        """
        RemoveItem(self, btkPointIterator) -> btkPointIterator
        RemoveItem(self, int)

        Removes a point.
        """
        return _btk.btkPointCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        """
        TakeItem(self, btkPointIterator) -> btkPoint
        TakeItem(self, int) -> btkPoint

        Removes a point and return it.
        """
        return _btk.btkPointCollection_TakeItem(self, *args)

    def Clear(self):
        """
        Clear(self)

        Clear the contents of the collection.
        """
        return _btk.btkPointCollection_Clear(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkPointCollection_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkPointCollection_GetTimestamp(self)

btkPointCollection_swigregister = _btk.btkPointCollection_swigregister
btkPointCollection_swigregister(btkPointCollection)

class btkForcePlatformCollectionIterator(_object):
    """Proxy of C++ btkForcePlatformCollectionIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkForcePlatformCollectionIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkForcePlatformCollectionIterator, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> btkForcePlatformCollectionIterator"""
        this = _btk.new_btkForcePlatformCollectionIterator()
        try: self.this.append(this)
        except: self.this = this
    def incr(self):
        """incr(self)"""
        return _btk.btkForcePlatformCollectionIterator_incr(self)

    def decr(self):
        """decr(self)"""
        return _btk.btkForcePlatformCollectionIterator_decr(self)

    def value(self):
        """value(self) -> btkForcePlatform"""
        return _btk.btkForcePlatformCollectionIterator_value(self)

    def __eq__(self, *args):
        """__eq__(self, rhs) -> bool"""
        return _btk.btkForcePlatformCollectionIterator___eq__(self, *args)

    def __ne__(self, *args):
        """__ne__(self, rhs) -> bool"""
        return _btk.btkForcePlatformCollectionIterator___ne__(self, *args)

    __swig_destroy__ = _btk.delete_btkForcePlatformCollectionIterator
    __del__ = lambda self : None;
btkForcePlatformCollectionIterator_swigregister = _btk.btkForcePlatformCollectionIterator_swigregister
btkForcePlatformCollectionIterator_swigregister(btkForcePlatformCollectionIterator)

class btkForcePlatformCollection(_object):
    """
    Collection of force platforms stored in a list.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkForcePlatformCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkForcePlatformCollection, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkForcePlatformCollection

        Collection of force platforms stored in a list.
        """
        this = _btk.new_btkForcePlatformCollection()
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkForcePlatformCollection

        Deep copy of the object
        """
        return _btk.btkForcePlatformCollection_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkForcePlatformCollection_impl *"""
        return _btk.btkForcePlatformCollection___deref__(self)

    __swig_destroy__ = _btk.delete_btkForcePlatformCollection
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkForcePlatformIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkForcePlatformCollection_Begin(self)

    def End(self):
        """
        End(self) -> btkForcePlatformIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkForcePlatformCollection_End(self)

    def IsEmpty(self):
        """
        IsEmpty(self) -> bool

        Returns true if the collection is empty.
        """
        return _btk.btkForcePlatformCollection_IsEmpty(self)

    def GetItemNumber(self):
        """
        GetItemNumber(self) -> int

        Returns the number of force platforms
        """
        return _btk.btkForcePlatformCollection_GetItemNumber(self)

    def SetItemNumber(self, *args):
        """
        SetItemNumber(self, arg2)

        Sets the number of force platforms
        """
        return _btk.btkForcePlatformCollection_SetItemNumber(self, *args)

    def GetIndexOf(self, *args):
        """
        GetIndexOf(self, int) -> btkForcePlatform

        Returns the index of the given item.
        """
        return _btk.btkForcePlatformCollection_GetIndexOf(self, *args)

    def GetItem(self, *args):
        """
        GetItem(self, int) -> btkForcePlatform

        Returns the force platform for the given index.
        """
        return _btk.btkForcePlatformCollection_GetItem(self, *args)

    def InsertItem(self, *args):
        """
        InsertItem(self, btkForcePlatformIterator, btkForcePlatform) -> bool
        InsertItem(self, int, btkForcePlatform) -> bool
        InsertItem(self, btkForcePlatform) -> bool

        Inserts a force platform in the list.
        """
        return _btk.btkForcePlatformCollection_InsertItem(self, *args)

    def SetItem(self, *args):
        """
        SetItem(self, int) -> btkForcePlatform

        Sets a force platform.
        """
        return _btk.btkForcePlatformCollection_SetItem(self, *args)

    def RemoveItem(self, *args):
        """
        RemoveItem(self, btkForcePlatformIterator) -> btkForcePlatformIterator
        RemoveItem(self, int)

        Removes a force platform.
        """
        return _btk.btkForcePlatformCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        """
        TakeItem(self, btkForcePlatformIterator) -> btkForcePlatform
        TakeItem(self, int) -> btkForcePlatform

        Removes a force platform and return it.
        """
        return _btk.btkForcePlatformCollection_TakeItem(self, *args)

    def Clear(self):
        """
        Clear(self)

        Clear the contents of the collection.
        """
        return _btk.btkForcePlatformCollection_Clear(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkForcePlatformCollection_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformCollection_GetTimestamp(self)

btkForcePlatformCollection_swigregister = _btk.btkForcePlatformCollection_swigregister
btkForcePlatformCollection_swigregister(btkForcePlatformCollection)

class btkWrenchCollectionIterator(_object):
    """Proxy of C++ btkWrenchCollectionIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkWrenchCollectionIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkWrenchCollectionIterator, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> btkWrenchCollectionIterator"""
        this = _btk.new_btkWrenchCollectionIterator()
        try: self.this.append(this)
        except: self.this = this
    def incr(self):
        """incr(self)"""
        return _btk.btkWrenchCollectionIterator_incr(self)

    def decr(self):
        """decr(self)"""
        return _btk.btkWrenchCollectionIterator_decr(self)

    def value(self):
        """value(self) -> btkWrench"""
        return _btk.btkWrenchCollectionIterator_value(self)

    def __eq__(self, *args):
        """__eq__(self, rhs) -> bool"""
        return _btk.btkWrenchCollectionIterator___eq__(self, *args)

    def __ne__(self, *args):
        """__ne__(self, rhs) -> bool"""
        return _btk.btkWrenchCollectionIterator___ne__(self, *args)

    __swig_destroy__ = _btk.delete_btkWrenchCollectionIterator
    __del__ = lambda self : None;
btkWrenchCollectionIterator_swigregister = _btk.btkWrenchCollectionIterator_swigregister
btkWrenchCollectionIterator_swigregister(btkWrenchCollectionIterator)

class btkWrenchCollection(_object):
    """
    Collection of wrenchs stored in a list.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkWrenchCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkWrenchCollection, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkWrenchCollection

        Collection of wrenchs stored in a list.
        """
        this = _btk.new_btkWrenchCollection()
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkWrenchCollection

        Deep copy of the object
        """
        return _btk.btkWrenchCollection_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkWrenchCollection_impl *"""
        return _btk.btkWrenchCollection___deref__(self)

    __swig_destroy__ = _btk.delete_btkWrenchCollection
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkWrenchIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkWrenchCollection_Begin(self)

    def End(self):
        """
        End(self) -> btkWrenchIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkWrenchCollection_End(self)

    def IsEmpty(self):
        """
        IsEmpty(self) -> bool

        Returns true if the collection is empty.
        """
        return _btk.btkWrenchCollection_IsEmpty(self)

    def GetItemNumber(self):
        """
        GetItemNumber(self) -> int

        Returns the number of wrenches
        """
        return _btk.btkWrenchCollection_GetItemNumber(self)

    def SetItemNumber(self, *args):
        """
        SetItemNumber(self, arg2)

        Sets the number of wrenches
        """
        return _btk.btkWrenchCollection_SetItemNumber(self, *args)

    def GetIndexOf(self, *args):
        """
        GetIndexOf(self, int) -> btkWrench

        Returns the index of the given item.
        """
        return _btk.btkWrenchCollection_GetIndexOf(self, *args)

    def GetItem(self, *args):
        """
        GetItem(self, int) -> btkWrench

        Returns the wrench for the given index.
        """
        return _btk.btkWrenchCollection_GetItem(self, *args)

    def InsertItem(self, *args):
        """
        InsertItem(self, btkWrenchIterator, btkWrench) -> bool
        InsertItem(self, int, btkWrench) -> bool
        InsertItem(self, btkWrench) -> bool

        Inserts a wrench in the list.
        """
        return _btk.btkWrenchCollection_InsertItem(self, *args)

    def SetItem(self, *args):
        """
        SetItem(self, int) -> btkWrench

        Sets a wrench.
        """
        return _btk.btkWrenchCollection_SetItem(self, *args)

    def RemoveItem(self, *args):
        """
        RemoveItem(self, btkWrenchIterator) -> btkWrenchIterator
        RemoveItem(self, int)

        Removes a wrench.
        """
        return _btk.btkWrenchCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        """
        TakeItem(self, btkWrenchIterator) -> btkWrench
        TakeItem(self, int) -> btkWrench

        Removes a wrench and return it.
        """
        return _btk.btkWrenchCollection_TakeItem(self, *args)

    def Clear(self):
        """
        Clear(self)

        Clear the contents of the collection.
        """
        return _btk.btkWrenchCollection_Clear(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkWrenchCollection_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkWrenchCollection_GetTimestamp(self)

btkWrenchCollection_swigregister = _btk.btkWrenchCollection_swigregister
btkWrenchCollection_swigregister(btkWrenchCollection)

class btkIMUCollectionIterator(_object):
    """Proxy of C++ btkIMUCollectionIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkIMUCollectionIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkIMUCollectionIterator, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> btkIMUCollectionIterator"""
        this = _btk.new_btkIMUCollectionIterator()
        try: self.this.append(this)
        except: self.this = this
    def incr(self):
        """incr(self)"""
        return _btk.btkIMUCollectionIterator_incr(self)

    def decr(self):
        """decr(self)"""
        return _btk.btkIMUCollectionIterator_decr(self)

    def value(self):
        """value(self) -> btkIMU"""
        return _btk.btkIMUCollectionIterator_value(self)

    def __eq__(self, *args):
        """__eq__(self, rhs) -> bool"""
        return _btk.btkIMUCollectionIterator___eq__(self, *args)

    def __ne__(self, *args):
        """__ne__(self, rhs) -> bool"""
        return _btk.btkIMUCollectionIterator___ne__(self, *args)

    __swig_destroy__ = _btk.delete_btkIMUCollectionIterator
    __del__ = lambda self : None;
btkIMUCollectionIterator_swigregister = _btk.btkIMUCollectionIterator_swigregister
btkIMUCollectionIterator_swigregister(btkIMUCollectionIterator)

class btkIMUCollection(_object):
    """
    Collection of IMUs stored in a list.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkIMUCollection, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkIMUCollection, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkIMUCollection

        Collection of IMUs stored in a list.
        """
        this = _btk.new_btkIMUCollection()
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkIMUCollection

        Deep copy of the object
        """
        return _btk.btkIMUCollection_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkIMUCollection_impl *"""
        return _btk.btkIMUCollection___deref__(self)

    __swig_destroy__ = _btk.delete_btkIMUCollection
    __del__ = lambda self : None;
    def Begin(self):
        """
        Begin(self) -> btkIMUIterator

        Returns an iterator to the beginning of the list of items.
        """
        return _btk.btkIMUCollection_Begin(self)

    def End(self):
        """
        End(self) -> btkIMUIterator

        Returns an iterator just past the last item.
        """
        return _btk.btkIMUCollection_End(self)

    def IsEmpty(self):
        """
        IsEmpty(self) -> bool

        Returns true if the collection is empty.
        """
        return _btk.btkIMUCollection_IsEmpty(self)

    def GetItemNumber(self):
        """
        GetItemNumber(self) -> int

        Returns the number of IMUs
        """
        return _btk.btkIMUCollection_GetItemNumber(self)

    def SetItemNumber(self, *args):
        """
        SetItemNumber(self, arg2)

        Sets the number of IMUs
        """
        return _btk.btkIMUCollection_SetItemNumber(self, *args)

    def GetIndexOf(self, *args):
        """
        GetIndexOf(self, int) -> btkIMU

        Returns the index of the given item.
        """
        return _btk.btkIMUCollection_GetIndexOf(self, *args)

    def GetItem(self, *args):
        """
        GetItem(self, int) -> btkIMU

        Returns the IMU for the given index.
        """
        return _btk.btkIMUCollection_GetItem(self, *args)

    def InsertItem(self, *args):
        """
        InsertItem(self, btkIMUIterator, btkIMU) -> bool
        InsertItem(self, int, btkIMU) -> bool
        InsertItem(self, btkIMU) -> bool

        Inserts an IMU in the list.
        """
        return _btk.btkIMUCollection_InsertItem(self, *args)

    def SetItem(self, *args):
        """
        SetItem(self, int) -> btkIMU

        Sets an IMU.
        """
        return _btk.btkIMUCollection_SetItem(self, *args)

    def RemoveItem(self, *args):
        """
        RemoveItem(self, btkIMUIterator) -> btkIMUIterator
        RemoveItem(self, int)

        Removes a IMU.
        """
        return _btk.btkIMUCollection_RemoveItem(self, *args)

    def TakeItem(self, *args):
        """
        TakeItem(self, btkIMUIterator) -> btkIMU
        TakeItem(self, int) -> btkIMU

        Removes an IMU and return it.
        """
        return _btk.btkIMUCollection_TakeItem(self, *args)

    def Clear(self):
        """
        Clear(self)

        Clear the contents of the collection.
        """
        return _btk.btkIMUCollection_Clear(self)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkIMUCollection_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkIMUCollection_GetTimestamp(self)

btkIMUCollection_swigregister = _btk.btkIMUCollection_swigregister
btkIMUCollection_swigregister(btkIMUCollection)

class btkStringArray(_object):
    """Proxy of C++ std::vector<(std::string)> class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkStringArray, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkStringArray, name)
    __repr__ = _swig_repr
    def iterator(self):
        """iterator(self) -> SwigPyIterator"""
        return _btk.btkStringArray_iterator(self)

    def __iter__(self): return self.iterator()
    def __nonzero__(self):
        """__nonzero__(self) -> bool"""
        return _btk.btkStringArray___nonzero__(self)

    def __bool__(self):
        """__bool__(self) -> bool"""
        return _btk.btkStringArray___bool__(self)

    def __len__(self):
        """__len__(self) -> std::vector< std::string >::size_type"""
        return _btk.btkStringArray___len__(self)

    def pop(self):
        """pop(self) -> std::vector< std::string >::value_type"""
        return _btk.btkStringArray_pop(self)

    def __getslice__(self, *args):
        """__getslice__(self, i, j) -> btkStringArray"""
        return _btk.btkStringArray___getslice__(self, *args)

    def __setslice__(self, *args):
        """
        __setslice__(self, i, j, v=std::vector< std::string,std::allocator< std::string > >())
        __setslice__(self, i, j)
        """
        return _btk.btkStringArray___setslice__(self, *args)

    def __delslice__(self, *args):
        """__delslice__(self, i, j)"""
        return _btk.btkStringArray___delslice__(self, *args)

    def __delitem__(self, *args):
        """
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _btk.btkStringArray___delitem__(self, *args)

    def __getitem__(self, *args):
        """
        __getitem__(self, slice) -> btkStringArray
        __getitem__(self, i) -> std::vector< std::string >::value_type const &
        """
        return _btk.btkStringArray___getitem__(self, *args)

    def __setitem__(self, *args):
        """
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _btk.btkStringArray___setitem__(self, *args)

    def append(self, *args):
        """append(self, x)"""
        return _btk.btkStringArray_append(self, *args)

    def empty(self):
        """empty(self) -> bool"""
        return _btk.btkStringArray_empty(self)

    def size(self):
        """size(self) -> std::vector< std::string >::size_type"""
        return _btk.btkStringArray_size(self)

    def clear(self):
        """clear(self)"""
        return _btk.btkStringArray_clear(self)

    def swap(self, *args):
        """swap(self, v)"""
        return _btk.btkStringArray_swap(self, *args)

    def get_allocator(self):
        """get_allocator(self) -> std::vector< std::string >::allocator_type"""
        return _btk.btkStringArray_get_allocator(self)

    def begin(self):
        """begin(self) -> std::vector< std::string >::iterator"""
        return _btk.btkStringArray_begin(self)

    def end(self):
        """end(self) -> std::vector< std::string >::iterator"""
        return _btk.btkStringArray_end(self)

    def rbegin(self):
        """rbegin(self) -> std::vector< std::string >::reverse_iterator"""
        return _btk.btkStringArray_rbegin(self)

    def rend(self):
        """rend(self) -> std::vector< std::string >::reverse_iterator"""
        return _btk.btkStringArray_rend(self)

    def pop_back(self):
        """pop_back(self)"""
        return _btk.btkStringArray_pop_back(self)

    def erase(self, *args):
        """
        erase(self, pos) -> std::vector< std::string >::iterator
        erase(self, first, last) -> std::vector< std::string >::iterator
        """
        return _btk.btkStringArray_erase(self, *args)

    def __init__(self, *args): 
        """
        __init__(self) -> btkStringArray
        __init__(self, arg2) -> btkStringArray
        __init__(self, size) -> btkStringArray
        __init__(self, size, value) -> btkStringArray
        """
        this = _btk.new_btkStringArray(*args)
        try: self.this.append(this)
        except: self.this = this
    def push_back(self, *args):
        """push_back(self, x)"""
        return _btk.btkStringArray_push_back(self, *args)

    def front(self):
        """front(self) -> std::vector< std::string >::value_type const &"""
        return _btk.btkStringArray_front(self)

    def back(self):
        """back(self) -> std::vector< std::string >::value_type const &"""
        return _btk.btkStringArray_back(self)

    def assign(self, *args):
        """assign(self, n, x)"""
        return _btk.btkStringArray_assign(self, *args)

    def resize(self, *args):
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _btk.btkStringArray_resize(self, *args)

    def insert(self, *args):
        """
        insert(self, pos, x) -> std::vector< std::string >::iterator
        insert(self, pos, n, x)
        """
        return _btk.btkStringArray_insert(self, *args)

    def reserve(self, *args):
        """reserve(self, n)"""
        return _btk.btkStringArray_reserve(self, *args)

    def capacity(self):
        """capacity(self) -> std::vector< std::string >::size_type"""
        return _btk.btkStringArray_capacity(self)

    __swig_destroy__ = _btk.delete_btkStringArray
    __del__ = lambda self : None;
btkStringArray_swigregister = _btk.btkStringArray_swigregister
btkStringArray_swigregister(btkStringArray)

class btkIntArray(_object):
    """Proxy of C++ std::vector<(int)> class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkIntArray, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkIntArray, name)
    __repr__ = _swig_repr
    def iterator(self):
        """iterator(self) -> SwigPyIterator"""
        return _btk.btkIntArray_iterator(self)

    def __iter__(self): return self.iterator()
    def __nonzero__(self):
        """__nonzero__(self) -> bool"""
        return _btk.btkIntArray___nonzero__(self)

    def __bool__(self):
        """__bool__(self) -> bool"""
        return _btk.btkIntArray___bool__(self)

    def __len__(self):
        """__len__(self) -> std::vector< int >::size_type"""
        return _btk.btkIntArray___len__(self)

    def pop(self):
        """pop(self) -> std::vector< int >::value_type"""
        return _btk.btkIntArray_pop(self)

    def __getslice__(self, *args):
        """__getslice__(self, i, j) -> btkIntArray"""
        return _btk.btkIntArray___getslice__(self, *args)

    def __setslice__(self, *args):
        """
        __setslice__(self, i, j, v=std::vector< int,std::allocator< int > >())
        __setslice__(self, i, j)
        """
        return _btk.btkIntArray___setslice__(self, *args)

    def __delslice__(self, *args):
        """__delslice__(self, i, j)"""
        return _btk.btkIntArray___delslice__(self, *args)

    def __delitem__(self, *args):
        """
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _btk.btkIntArray___delitem__(self, *args)

    def __getitem__(self, *args):
        """
        __getitem__(self, slice) -> btkIntArray
        __getitem__(self, i) -> std::vector< int >::value_type const &
        """
        return _btk.btkIntArray___getitem__(self, *args)

    def __setitem__(self, *args):
        """
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _btk.btkIntArray___setitem__(self, *args)

    def append(self, *args):
        """append(self, x)"""
        return _btk.btkIntArray_append(self, *args)

    def empty(self):
        """empty(self) -> bool"""
        return _btk.btkIntArray_empty(self)

    def size(self):
        """size(self) -> std::vector< int >::size_type"""
        return _btk.btkIntArray_size(self)

    def clear(self):
        """clear(self)"""
        return _btk.btkIntArray_clear(self)

    def swap(self, *args):
        """swap(self, v)"""
        return _btk.btkIntArray_swap(self, *args)

    def get_allocator(self):
        """get_allocator(self) -> std::vector< int >::allocator_type"""
        return _btk.btkIntArray_get_allocator(self)

    def begin(self):
        """begin(self) -> std::vector< int >::iterator"""
        return _btk.btkIntArray_begin(self)

    def end(self):
        """end(self) -> std::vector< int >::iterator"""
        return _btk.btkIntArray_end(self)

    def rbegin(self):
        """rbegin(self) -> std::vector< int >::reverse_iterator"""
        return _btk.btkIntArray_rbegin(self)

    def rend(self):
        """rend(self) -> std::vector< int >::reverse_iterator"""
        return _btk.btkIntArray_rend(self)

    def pop_back(self):
        """pop_back(self)"""
        return _btk.btkIntArray_pop_back(self)

    def erase(self, *args):
        """
        erase(self, pos) -> std::vector< int >::iterator
        erase(self, first, last) -> std::vector< int >::iterator
        """
        return _btk.btkIntArray_erase(self, *args)

    def __init__(self, *args): 
        """
        __init__(self) -> btkIntArray
        __init__(self, arg2) -> btkIntArray
        __init__(self, size) -> btkIntArray
        __init__(self, size, value) -> btkIntArray
        """
        this = _btk.new_btkIntArray(*args)
        try: self.this.append(this)
        except: self.this = this
    def push_back(self, *args):
        """push_back(self, x)"""
        return _btk.btkIntArray_push_back(self, *args)

    def front(self):
        """front(self) -> std::vector< int >::value_type const &"""
        return _btk.btkIntArray_front(self)

    def back(self):
        """back(self) -> std::vector< int >::value_type const &"""
        return _btk.btkIntArray_back(self)

    def assign(self, *args):
        """assign(self, n, x)"""
        return _btk.btkIntArray_assign(self, *args)

    def resize(self, *args):
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _btk.btkIntArray_resize(self, *args)

    def insert(self, *args):
        """
        insert(self, pos, x) -> std::vector< int >::iterator
        insert(self, pos, n, x)
        """
        return _btk.btkIntArray_insert(self, *args)

    def reserve(self, *args):
        """reserve(self, n)"""
        return _btk.btkIntArray_reserve(self, *args)

    def capacity(self):
        """capacity(self) -> std::vector< int >::size_type"""
        return _btk.btkIntArray_capacity(self)

    __swig_destroy__ = _btk.delete_btkIntArray
    __del__ = lambda self : None;
btkIntArray_swigregister = _btk.btkIntArray_swigregister
btkIntArray_swigregister(btkIntArray)

class btkDoubleArray(_object):
    """Proxy of C++ std::vector<(double)> class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkDoubleArray, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkDoubleArray, name)
    __repr__ = _swig_repr
    def iterator(self):
        """iterator(self) -> SwigPyIterator"""
        return _btk.btkDoubleArray_iterator(self)

    def __iter__(self): return self.iterator()
    def __nonzero__(self):
        """__nonzero__(self) -> bool"""
        return _btk.btkDoubleArray___nonzero__(self)

    def __bool__(self):
        """__bool__(self) -> bool"""
        return _btk.btkDoubleArray___bool__(self)

    def __len__(self):
        """__len__(self) -> std::vector< double >::size_type"""
        return _btk.btkDoubleArray___len__(self)

    def pop(self):
        """pop(self) -> std::vector< double >::value_type"""
        return _btk.btkDoubleArray_pop(self)

    def __getslice__(self, *args):
        """__getslice__(self, i, j) -> btkDoubleArray"""
        return _btk.btkDoubleArray___getslice__(self, *args)

    def __setslice__(self, *args):
        """
        __setslice__(self, i, j, v=std::vector< double,std::allocator< double > >())
        __setslice__(self, i, j)
        """
        return _btk.btkDoubleArray___setslice__(self, *args)

    def __delslice__(self, *args):
        """__delslice__(self, i, j)"""
        return _btk.btkDoubleArray___delslice__(self, *args)

    def __delitem__(self, *args):
        """
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _btk.btkDoubleArray___delitem__(self, *args)

    def __getitem__(self, *args):
        """
        __getitem__(self, slice) -> btkDoubleArray
        __getitem__(self, i) -> std::vector< double >::value_type const &
        """
        return _btk.btkDoubleArray___getitem__(self, *args)

    def __setitem__(self, *args):
        """
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _btk.btkDoubleArray___setitem__(self, *args)

    def append(self, *args):
        """append(self, x)"""
        return _btk.btkDoubleArray_append(self, *args)

    def empty(self):
        """empty(self) -> bool"""
        return _btk.btkDoubleArray_empty(self)

    def size(self):
        """size(self) -> std::vector< double >::size_type"""
        return _btk.btkDoubleArray_size(self)

    def clear(self):
        """clear(self)"""
        return _btk.btkDoubleArray_clear(self)

    def swap(self, *args):
        """swap(self, v)"""
        return _btk.btkDoubleArray_swap(self, *args)

    def get_allocator(self):
        """get_allocator(self) -> std::vector< double >::allocator_type"""
        return _btk.btkDoubleArray_get_allocator(self)

    def begin(self):
        """begin(self) -> std::vector< double >::iterator"""
        return _btk.btkDoubleArray_begin(self)

    def end(self):
        """end(self) -> std::vector< double >::iterator"""
        return _btk.btkDoubleArray_end(self)

    def rbegin(self):
        """rbegin(self) -> std::vector< double >::reverse_iterator"""
        return _btk.btkDoubleArray_rbegin(self)

    def rend(self):
        """rend(self) -> std::vector< double >::reverse_iterator"""
        return _btk.btkDoubleArray_rend(self)

    def pop_back(self):
        """pop_back(self)"""
        return _btk.btkDoubleArray_pop_back(self)

    def erase(self, *args):
        """
        erase(self, pos) -> std::vector< double >::iterator
        erase(self, first, last) -> std::vector< double >::iterator
        """
        return _btk.btkDoubleArray_erase(self, *args)

    def __init__(self, *args): 
        """
        __init__(self) -> btkDoubleArray
        __init__(self, arg2) -> btkDoubleArray
        __init__(self, size) -> btkDoubleArray
        __init__(self, size, value) -> btkDoubleArray
        """
        this = _btk.new_btkDoubleArray(*args)
        try: self.this.append(this)
        except: self.this = this
    def push_back(self, *args):
        """push_back(self, x)"""
        return _btk.btkDoubleArray_push_back(self, *args)

    def front(self):
        """front(self) -> std::vector< double >::value_type const &"""
        return _btk.btkDoubleArray_front(self)

    def back(self):
        """back(self) -> std::vector< double >::value_type const &"""
        return _btk.btkDoubleArray_back(self)

    def assign(self, *args):
        """assign(self, n, x)"""
        return _btk.btkDoubleArray_assign(self, *args)

    def resize(self, *args):
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _btk.btkDoubleArray_resize(self, *args)

    def insert(self, *args):
        """
        insert(self, pos, x) -> std::vector< double >::iterator
        insert(self, pos, n, x)
        """
        return _btk.btkDoubleArray_insert(self, *args)

    def reserve(self, *args):
        """reserve(self, n)"""
        return _btk.btkDoubleArray_reserve(self, *args)

    def capacity(self):
        """capacity(self) -> std::vector< double >::size_type"""
        return _btk.btkDoubleArray_capacity(self)

    __swig_destroy__ = _btk.delete_btkDoubleArray
    __del__ = lambda self : None;
btkDoubleArray_swigregister = _btk.btkDoubleArray_swigregister
btkDoubleArray_swigregister(btkDoubleArray)

class btkMetaDataInfo(_object):
    """
    Container class to store data of a MetaData object.

    You can store integer value(s), real or string. This class has also methods to convert the native type into other, like integer into string.

    Even if the data extracted are set as native Python type, the internal type are different and set as:
     - btk.btkMetaDataInfo.Char: Type for the string;
     - btk.btkMetaDataInfo.Byte: Signed integer type stored only on 8 bit. Possible values between -127 and 128;
     - btk.btkMetaDataInfo.Integer: Signed integer type stored only on 16 bit. Possible values between -32767 and 32768;
     - btk.btkMetaDataInfo.Real: Float type. Precision limited to 1e-5.
     
    Note: The format btk.btkMetaDataInfo.Byte cannot be set using the method SetValues() do the impossibility to differentiate an integer. You need to use explicitly the method SetFormat().
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkMetaDataInfo, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkMetaDataInfo, name)
    __repr__ = _swig_repr
    Char = _btk.btkMetaDataInfo_Char
    Byte = _btk.btkMetaDataInfo_Byte
    Integer = _btk.btkMetaDataInfo_Integer
    Real = _btk.btkMetaDataInfo_Real
    def __init__(self, *args): 
        """
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, val) -> btkMetaDataInfo
        __init__(self, dim, val) -> btkMetaDataInfo
        __init__(self, dim, val) -> btkMetaDataInfo
        __init__(self, dim, val) -> btkMetaDataInfo

        Container class to store data of a MetaData object.

        You can store integer value(s), real or string. This class has also methods to convert the native type into other, like integer into string.

        Even if the data extracted are set as native Python type, the internal type are different and set as:
         - btk.btkMetaDataInfo.Char: Type for the string;
         - btk.btkMetaDataInfo.Byte: Signed integer type stored only on 8 bit. Possible values between -127 and 128;
         - btk.btkMetaDataInfo.Integer: Signed integer type stored only on 16 bit. Possible values between -32767 and 32768;
         - btk.btkMetaDataInfo.Real: Float type. Precision limited to 1e-5.
         
        Note: The format btk.btkMetaDataInfo.Byte cannot be set using the method SetValues() do the impossibility to differentiate an integer. You need to use explicitly the method SetFormat().
        """
        this = _btk.new_btkMetaDataInfo(*args)
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkMetaDataInfo

        Deep copy of the object
        """
        return _btk.btkMetaDataInfo_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkMetaDataInfo_impl *"""
        return _btk.btkMetaDataInfo___deref__(self)

    def GetDimension(self, *args):
        """GetDimension(self, idx) -> int"""
        return _btk.btkMetaDataInfo_GetDimension(self, *args)

    def SetDimension(self, *args):
        """SetDimension(self, idx, val)"""
        return _btk.btkMetaDataInfo_SetDimension(self, *args)

    def GetDimensions(self):
        """GetDimensions(self) -> btkIntArray"""
        return _btk.btkMetaDataInfo_GetDimensions(self)

    def SetDimensions(self, *args):
        """SetDimensions(self, dims)"""
        return _btk.btkMetaDataInfo_SetDimensions(self, *args)

    def GetValueNumber(self):
        """GetValueNumber(self) -> int"""
        return _btk.btkMetaDataInfo_GetValueNumber(self)

    def SetValue(self, *args):
        """
        SetValue(self, idx, val)
        SetValue(self, idx, val)
        SetValue(self, idx, val)
        """
        return _btk.btkMetaDataInfo_SetValue(self, *args)

    def SetValues(self, *args):
        """
        SetValues(self, val)
        SetValues(self, val)
        SetValues(self, val)
        SetValues(self, val)
        SetValues(self, val)
        SetValues(self, val)
        SetValues(self, dims, val)
        SetValues(self, dims, val)
        SetValues(self, dims, val)
        """
        return _btk.btkMetaDataInfo_SetValues(self, *args)

    def __eq__(self, *args):
        """__eq__(self, rRHS) -> bool"""
        return _btk.btkMetaDataInfo___eq__(self, *args)

    def __ne__(self, *args):
        """__ne__(self, rRHS) -> bool"""
        return _btk.btkMetaDataInfo___ne__(self, *args)

    __swig_destroy__ = _btk.delete_btkMetaDataInfo
    __del__ = lambda self : None;
    def GetFormat(self):
        """
        GetFormat(self) -> btkMetaDataInfo_impl::Format

        Returns the internal format of the values.
        """
        return _btk.btkMetaDataInfo_GetFormat(self)

    def GetFormatAsString(self):
        """
        GetFormatAsString(self) -> std::string

        Returns the format of the values as a string.
        """
        return _btk.btkMetaDataInfo_GetFormatAsString(self)

    def SetFormat(self, *args):
        """
        SetFormat(self, btk.btkMetaDataInfo.Format)

        Sets the format of the values and adapt the values. This method erases the values and set default values ('0' or a string with white spaces).
        """
        return _btk.btkMetaDataInfo_SetFormat(self, *args)

    def GetDimensionsProduct(self, start=0):
        """
        GetDimensionsProduct(self, start=0) -> int
        GetDimensionsProduct(self) -> int

        Compute the product of the dimensions from the given start index.
        """
        return _btk.btkMetaDataInfo_GetDimensionsProduct(self, start)

    def ResizeDimensions(self, *args):
        """
        ResizeDimensions(self, nb)

        Resize the dimensions and adapt the values and their structure. If the number of dimensions is greater, then the new dimensions are equal to 1. If the number of dimensions is lower, then the value are shrunken.
        """
        return _btk.btkMetaDataInfo_ResizeDimensions(self, *args)

    def ToString(self, *args):
        """
        ToString(self, idx) -> std::string const
        ToString(self) -> btkStringArray

        Convert stored value(s) into string(s).
        """
        return _btk.btkMetaDataInfo_ToString(self, *args)

    def ToInt(self, *args):
        """
        ToInt(self, idx) -> int
        ToInt(self) -> btkIntArray

        Convert stored value(s) into integer(s).
        """
        return _btk.btkMetaDataInfo_ToInt(self, *args)

    def ToDouble(self, *args):
        """
        ToDouble(self, idx) -> double
        ToDouble(self) -> btkDoubleArray

        Convert stored value(s) into double(s).
        """
        return _btk.btkMetaDataInfo_ToDouble(self, *args)

btkMetaDataInfo_swigregister = _btk.btkMetaDataInfo_swigregister
btkMetaDataInfo_swigregister(btkMetaDataInfo)

class btkMetaData(_object):
    """
    Store data which cannot be embedded within timeseries data (calibration matrix, subject informations, ...).

    Each object can store children metadata. Theoretically, the number of sub-level is infinite. However, the main common use of the metadata is to use 2 levels. This use was introduced in the C3D format.
    The values in a metadata are stored in a MetaDataInfo object and are accessible using the method GetInfo().

    The unlock member accessible using the methods GetUnlock() and SetUnlock() doesn't affect the setting of the values, but is used only to inform the user/developer.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkMetaData, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkMetaData, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, label) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, val, desc="") -> btkMetaData
        __init__(self, label, val) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, val, desc="") -> btkMetaData
        __init__(self, label, val) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, val, desc="") -> btkMetaData
        __init__(self, label, val) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, val, desc="") -> btkMetaData
        __init__(self, label, val) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, val, desc="") -> btkMetaData
        __init__(self, label, val) -> btkMetaData
        __init__(self, label, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, val, desc="") -> btkMetaData
        __init__(self, label, val) -> btkMetaData
        __init__(self, label, dim, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, dim, val, desc="") -> btkMetaData
        __init__(self, label, dim, val) -> btkMetaData
        __init__(self, label, dim, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, dim, val, desc="") -> btkMetaData
        __init__(self, label, dim, val) -> btkMetaData
        __init__(self, label, dim, val, desc="", isUnlocked=True) -> btkMetaData
        __init__(self, label, dim, val, desc="") -> btkMetaData
        __init__(self, label, dim, val) -> btkMetaData

        Store data which cannot be embedded within timeseries data (calibration matrix, subject informations, ...).

        Each object can store children metadata. Theoretically, the number of sub-level is infinite. However, the main common use of the metadata is to use 2 levels. This use was introduced in the C3D format.
        The values in a metadata are stored in a MetaDataInfo object and are accessible using the method GetInfo().

        The unlock member accessible using the methods GetUnlock() and SetUnlock() doesn't affect the setting of the values, but is used only to inform the user/developer.
        """
        this = _btk.new_btkMetaData(*args)
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkMetaData

        Deep copy of the object
        """
        return _btk.btkMetaData_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkMetaData_impl *"""
        return _btk.btkMetaData___deref__(self)

    def __eq__(self, *args):
        """__eq__(self, rRHS) -> bool"""
        return _btk.btkMetaData___eq__(self, *args)

    def __ne__(self, *args):
        """__ne__(self, rRHS) -> bool"""
        return _btk.btkMetaData___ne__(self, *args)

    __swig_destroy__ = _btk.delete_btkMetaData
    __del__ = lambda self : None;
    def GetLabel(self):
        """GetLabel(self) -> std::string const &"""
        return _btk.btkMetaData_GetLabel(self)

    def SetLabel(self, *args):
        """
        SetLabel(self, string)

        Sets the label of the entry. If label already exist in the parent's list, then an exception is thrown.
        """
        return _btk.btkMetaData_SetLabel(self, *args)

    def GetDescription(self):
        """GetDescription(self) -> std::string const &"""
        return _btk.btkMetaData_GetDescription(self)

    def SetDescription(self, *args):
        """SetDescription(self, string)"""
        return _btk.btkMetaData_SetDescription(self, *args)

    def GetUnlockState(self):
        """
        GetUnlockState(self) -> bool const

        Gets the unlock state of the entry.
        """
        return _btk.btkMetaData_GetUnlockState(self)

    def SetUnlockState(self, *args):
        """
        SetUnlockState(self, arg2)

        Sets the unlock state of the entry.
        """
        return _btk.btkMetaData_SetUnlockState(self, *args)

    def GetInfo(self):
        """
        GetInfo(self) -> btkMetaDataInfo

        Gets the btkMetaDataInfo associated to the entry.
        """
        return _btk.btkMetaData_GetInfo(self)

    def SetInfo(self, *args):
        """
        SetInfo(self, arg2)

        Sets the btkMetaDataInfo associated to the entry.
        """
        return _btk.btkMetaData_SetInfo(self, *args)

    def HasInfo(self):
        """
        HasInfo(self) -> bool

        Checks if a btkMetaDataInfo is associated with the entry.
        """
        return _btk.btkMetaData_HasInfo(self)

    def ExtractChildInfo(self, *args):
        """
        ExtractChildInfo(self, label, format, numdims, noPossibleEmptyValue = True) -> btkMetaDataInfo
        ExtractChildInfo(self, label, format, numdims, noPossibleEmptyValue = True) -> btkMetaDataInfo

        Check if a child exists with the given label and correspond to the given format plus the number of dimensions with or without values (noPossibleEmptyValue). The informations of the metadata are extracted if all the checks are ok. Otherwise, the methods return an empty pointer.
        """
        return _btk.btkMetaData_ExtractChildInfo(self, *args)

    def HasMetaDataAsParent(self):
        """
        HasMetaDataAsParent(self) -> bool

        Checks if this object has a MetaData object as parents.
        """
        return _btk.btkMetaData_HasMetaDataAsParent(self)

    def Begin(self):
        """
        Begin(self) -> btkMetaDataIterator

        Returns an iterator to the beginning of the list of children.
        """
        return _btk.btkMetaData_Begin(self)

    def End(self):
        """
        End(self) -> btkMetaDataIterator

        Returns an iterator just past the last child.
        """
        return _btk.btkMetaData_End(self)

    def GetChild(self, *args):
        """
        GetChild(self, index) -> btkMetaData
        GetChild(self, index) -> btkMetaData

        Gets the entry for the given index or label. An exception is thrown is the given input doesn't correspond to any entry.
        """
        return _btk.btkMetaData_GetChild(self, *args)

    def AppendChild(self, *args):
        """
        AppendChild(self, arg2) -> bool

        Append the child entry. If entry has a label which already exists in the parent's list, then it is not inserted. Returns True if child has been inserted or False.
        """
        return _btk.btkMetaData_AppendChild(self, *args)

    def InsertChild(self, *args):
        """
        InsertChild(self, btkMetaDataIterator, btkMetaData) -> bool
        InsertChild(self, int, btkMetaData) -> bool

        Insert the child entry for the given location. If the entry has a label which already exists in the parent's list, then it is not inserted. Returns True if child has been inserted or False.
        """
        return _btk.btkMetaData_InsertChild(self, *args)

    def SetChild(self, *args):
        """
        SetChild(self, int, btkMetaData)

        Sets the child entry for the given index
        """
        return _btk.btkMetaData_SetChild(self, *args)

    def TakeChild(self, *args):
        """
        TakeChild(self, btkMetaDataIterator) -> btkMetaData
        TakeChild(self, int) -> btkMetaData
        TakeChild(self, string) -> btkMetaData

        Removes the child entry which has the given index, label or corresponding iterator. If there is no child with the specified label, then an empty pointer is returned.
        """
        return _btk.btkMetaData_TakeChild(self, *args)

    def RemoveChild(self, *args):
        """
        RemoveChild(self, btkMetaDataIterator) -> btkMetaDataIterator
        RemoveChild(self, int)
        RemoveChild(self, arg2)

        Removes the child entry which has the given index, label or corresponding iterator.
        """
        return _btk.btkMetaData_RemoveChild(self, *args)

    def ClearChildren(self):
        """
        ClearChildren(self)

        Removes every children.
        """
        return _btk.btkMetaData_ClearChildren(self)

    def HasChildren(self):
        """
        HasChildren(self) -> bool

        Checks if the entry has children 
        """
        return _btk.btkMetaData_HasChildren(self)

    def GetChildNumber(self):
        """
        GetChildNumber(self) -> int

        Returns the number of children 
        """
        return _btk.btkMetaData_GetChildNumber(self)

    def FindChild(self, *args):
        """
        FindChild(self, label) -> btkMetaDataIterator

        Finds the children which has the given label and return it as an iterator.
        """
        return _btk.btkMetaData_FindChild(self, *args)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkMetaData_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkMetaData_GetTimestamp(self)

btkMetaData_swigregister = _btk.btkMetaData_swigregister
btkMetaData_swigregister(btkMetaData)

class btkMetaDataIterator(_object):
    """Proxy of C++ btkMetaDataIterator class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkMetaDataIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkMetaDataIterator, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> btkMetaDataIterator"""
        this = _btk.new_btkMetaDataIterator()
        try: self.this.append(this)
        except: self.this = this
    def incr(self):
        """incr(self)"""
        return _btk.btkMetaDataIterator_incr(self)

    def decr(self):
        """decr(self)"""
        return _btk.btkMetaDataIterator_decr(self)

    def value(self):
        """value(self) -> btkMetaData"""
        return _btk.btkMetaDataIterator_value(self)

    def __eq__(self, *args):
        """__eq__(self, rhs) -> bool"""
        return _btk.btkMetaDataIterator___eq__(self, *args)

    def __ne__(self, *args):
        """__ne__(self, rhs) -> bool"""
        return _btk.btkMetaDataIterator___ne__(self, *args)

    __swig_destroy__ = _btk.delete_btkMetaDataIterator
    __del__ = lambda self : None;
btkMetaDataIterator_swigregister = _btk.btkMetaDataIterator_swigregister
btkMetaDataIterator_swigregister(btkMetaDataIterator)


def btkMetaDataCreateChild(*args):
  """
    btkMetaDataCreateChild(parent, label) -> btkMetaData
    btkMetaDataCreateChild(parent , label , int )
    btkMetaDataCreateChild(parent , label , double )
    btkMetaDataCreateChild(parent , label , string )
    btkMetaDataCreateChild(parent , label , btkIntArray)
    btkMetaDataCreateChild(parent , label , btkDoubleArray)
    btkMetaDataCreateChild(parent , label , btkStringArray)
    btkMetaDataCreateChild(parent , label , btkIntArray , numCol)
    btkMetaDataCreateChild(parent , label , btkDoubleArray , numCol)
    btkMetaDataCreateChild(parent , label , btkStringArray , numCol)

    Function to create/set easily a metadata containing a 2D array as value, from a given label into a given parent.
    """
  return _btk.btkMetaDataCreateChild(*args)

def btkMetaDataCollapseChildrenValuesInt(*args):
  """
    btkMetaDataCollapseChildrenValuesInt(parent, baselabel, targetFinalSize=-1, blankReplacement=0) -> btkIntArray
    btkMetaDataCollapseChildrenValuesInt(parent, baselabel, targetFinalSize=-1) -> btkIntArray
    btkMetaDataCollapseChildrenValuesInt(parent, baselabel) -> btkIntArray

    Convenient method to extract the values of a metadata as an array of integers.
    Collapse the parent children entries' values starting with the string 'baselabel' and incrementing (for example: LABELS, LABELS2, LABELS3).
    """
  return _btk.btkMetaDataCollapseChildrenValuesInt(*args)

def btkMetaDataCollapseChildrenValuesDouble(*args):
  """
    btkMetaDataCollapseChildrenValuesDouble(parent, baselabel, targetFinalSize=-1, blankReplacement=0.0) -> btkDoubleArray
    btkMetaDataCollapseChildrenValuesDouble(parent, baselabel, targetFinalSize=-1) -> btkDoubleArray
    btkMetaDataCollapseChildrenValuesDouble(parent, baselabel) -> btkDoubleArray

    Convenient method to extract the values of a metadata as an array of doubles.
    Collapse the parent children entries' values starting with the string 'baselabel' and incrementing (for example: LABELS, LABELS2, LABELS3).
    """
  return _btk.btkMetaDataCollapseChildrenValuesDouble(*args)

def btkMetaDataCollapseChildrenValuesString(*args):
  """
    btkMetaDataCollapseChildrenValuesString(parent, baselabel, targetFinalSize=-1, blankReplacement="") -> btkStringArray
    btkMetaDataCollapseChildrenValuesString(parent, baselabel, targetFinalSize=-1) -> btkStringArray
    btkMetaDataCollapseChildrenValuesString(parent, baselabel) -> btkStringArray

    Convenient method to extract the values of a metadata as an array of strings.
    Collapse the parent children entries' values starting with the string 'baselabel' and incrementing (for example: LABELS, LABELS2, LABELS3).
    """
  return _btk.btkMetaDataCollapseChildrenValuesString(*args)
class btkAcquisition(_object):
    """
    Contains the data related to a biomechanical acquisition.

    A biomechanical acquisition can contains:
      - 3D data (makers, points, forces, moments, ...) ;
      - analog channels (force platform, emg, ...) ;
      - events
      - acquisition's setup ;
      - subject's informations.
      
    By default, the first frame is set to 1, the analog resolution is set to 12-bit, the maximum interpolation gap to 10 frames and the units are:
     - Marker: millimeters ;
     - Angle: degrees ;
     - Force: newtons ;
     - Moment: millimeter-newtons ;
     - Power: watts ;
     - Scalar: millimeters ;
     - Reaction: (nothing).
     
    After the creation of the acquisition, you should use the Init() method to populate the acquisition. 
     
    The member used for the maximum interpolation gap is only for information and is not used in the acquisition. It could be used later in a filter to fill gap.

    The analog resolution can be set to the following values:
     - btk.btkAcquisition.Bit8 ;
     - btk.btkAcquisition.Bit10 ;
     - btk.btkAcquisition.Bit12 ;
     - btk.btkAcquisition.Bit14 ;
     - btk.btkAcquisition.Bit16.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkAcquisition, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkAcquisition, name)
    __repr__ = _swig_repr
    Bit8 = _btk.btkAcquisition_Bit8
    Bit10 = _btk.btkAcquisition_Bit10
    Bit12 = _btk.btkAcquisition_Bit12
    Bit14 = _btk.btkAcquisition_Bit14
    Bit16 = _btk.btkAcquisition_Bit16
    def __init__(self): 
        """
        __init__(self) -> btkAcquisition

        Contains the data related to a biomechanical acquisition.

        A biomechanical acquisition can contains:
          - 3D data (makers, points, forces, moments, ...) ;
          - analog channels (force platform, emg, ...) ;
          - events
          - acquisition's setup ;
          - subject's informations.
          
        By default, the first frame is set to 1, the analog resolution is set to 12-bit, the maximum interpolation gap to 10 frames and the units are:
         - Marker: millimeters ;
         - Angle: degrees ;
         - Force: newtons ;
         - Moment: millimeter-newtons ;
         - Power: watts ;
         - Scalar: millimeters ;
         - Reaction: (nothing).
         
        After the creation of the acquisition, you should use the Init() method to populate the acquisition. 
         
        The member used for the maximum interpolation gap is only for information and is not used in the acquisition. It could be used later in a filter to fill gap.

        The analog resolution can be set to the following values:
         - btk.btkAcquisition.Bit8 ;
         - btk.btkAcquisition.Bit10 ;
         - btk.btkAcquisition.Bit12 ;
         - btk.btkAcquisition.Bit14 ;
         - btk.btkAcquisition.Bit16.
        """
        this = _btk.new_btkAcquisition()
        try: self.this.append(this)
        except: self.this = this
    def Clone(self):
        """
        Clone(self) -> btkAcquisition

        Deep copy of the object
        """
        return _btk.btkAcquisition_Clone(self)

    def __deref__(self):
        """__deref__(self) -> btkAcquisition_impl *"""
        return _btk.btkAcquisition___deref__(self)

    __swig_destroy__ = _btk.delete_btkAcquisition
    __del__ = lambda self : None;
    def BeginMetaData(self):
        """
        BeginMetaData(self) -> btkMetaDataIterator

        Returns an iterator to the beginning of the list of metadata.
        """
        return _btk.btkAcquisition_BeginMetaData(self)

    def EndMetaData(self):
        """
        EndMetaData(self) -> btkMetaDataIterator

        Returns an iterator just past the last metadata.
        """
        return _btk.btkAcquisition_EndMetaData(self)

    def GetMetaData(self):
        """
        GetMetaData(self) -> btkMetaData

        Returns the metadata.
        """
        return _btk.btkAcquisition_GetMetaData(self)

    def SetMetaData(self, *args):
        """
        SetMetaData(self, btkMetaData)

        Sets the metadata of the acquisition.
        """
        return _btk.btkAcquisition_SetMetaData(self, *args)

    def BeginEvent(self):
        """
        BeginEvent(self) -> btkEventCollectionIterator

        Returns an iterator to the beginning of the list of events.
        """
        return _btk.btkAcquisition_BeginEvent(self)

    def EndEvent(self):
        """
        EndEvent(self) -> btkEventCollectionIterator

        Returns a const iterator just past the last event.
        """
        return _btk.btkAcquisition_EndEvent(self)

    def GetEvent(self, *args):
        """
        GetEvent(self, int) -> btkEvent

        Gets the event at the given index.
        """
        return _btk.btkAcquisition_GetEvent(self, *args)

    def SetEvent(self, *args):
        """
        SetEvent(self, int, btkEvent)

        Sets the content of event at the given index.
        """
        return _btk.btkAcquisition_SetEvent(self, *args)

    def GetEvents(self):
        """
        GetEvents(self) -> btkEventCollection

        Returns the collection of events.
        """
        return _btk.btkAcquisition_GetEvents(self)

    def SetEvents(self, *args):
        """
        SetEvents(self, btkEventCollection)

        Sets events for this acquisition.
        """
        return _btk.btkAcquisition_SetEvents(self, *args)

    def IsEmptyEvent(self):
        """
        IsEmptyEvent(self) -> bool

        Checks if the events' list is empty.
        """
        return _btk.btkAcquisition_IsEmptyEvent(self)

    def GetEventNumber(self):
        """
        GetEventNumber(self) -> int

        Returns the number of events.
        """
        return _btk.btkAcquisition_GetEventNumber(self)

    def SetEventNumber(self, *args):
        """
        SetEventNumber(self, int)

        Sets the number of events.
        """
        return _btk.btkAcquisition_SetEventNumber(self, *args)

    def ClearEvents(self):
        """
        ClearEvents(self)

        Clear events.
        """
        return _btk.btkAcquisition_ClearEvents(self)

    def FindEvent(self, *args):
        """
        FindEvent(self, string) -> btkEventIterator

        Finds the event with the proposed label and returns the iterator associated with it.
        If no event has the given label, an iterator pointing to the end of the collection is returned.
        """
        return _btk.btkAcquisition_FindEvent(self, *args)

    def AppendEvent(self, *args):
        """
        AppendEvent(self, btkEvent)

        Appends the given event in the acquisition.
        """
        return _btk.btkAcquisition_AppendEvent(self, *args)

    def RemoveEvent(self, *args):
        """
        RemoveAnalog(self, int)
        RemoveEvent(self, btkEventCollectionIterator) -> btkEventCollectionIterator

        Removes the event associated with the given index or the given iterator.
        """
        return _btk.btkAcquisition_RemoveEvent(self, *args)

    def BeginPoint(self):
        """
        BeginPoint(self) -> btkPointCollectionIterator

        Returns an iterator to the beginning of the list of points.
        """
        return _btk.btkAcquisition_BeginPoint(self)

    def EndPoint(self):
        """
        EndPoint(self) -> btkPointCollectionIterator

        Returns an iterator just past the last point.
        """
        return _btk.btkAcquisition_EndPoint(self)

    def GetPoint(self, *args):
        """
        GetPoint(self, int) -> btkPoint
        GetPoint(self, string) -> btkPoint

        Gets the point at the given index or label. If no Point exists, then an exception is thrown.
        """
        return _btk.btkAcquisition_GetPoint(self, *args)

    def SetPoint(self, *args):
        """
        SetPoint(self, int, btkPoint)

        Sets the content of a point at the given index.
        """
        return _btk.btkAcquisition_SetPoint(self, *args)

    def GetPoints(self):
        """
        GetPoints(self) -> btkPointCollection

        Returns the collection of points.
        """
        return _btk.btkAcquisition_GetPoints(self)

    def SetPoints(self, *args):
        """
        SetPoints(self, btkPointCollection)

        Sets points for this acquisition.
        """
        return _btk.btkAcquisition_SetPoints(self, *args)

    def IsEmptyPoint(self):
        """
        IsEmptyPoint(self) -> bool

        Checks if the points' list is empty.
        """
        return _btk.btkAcquisition_IsEmptyPoint(self)

    def GetPointNumber(self):
        """
        GetPointNumber(self) -> int

        Returns the number of points.
        """
        return _btk.btkAcquisition_GetPointNumber(self)

    def SetPointNumber(self, *args):
        """
        SetPointNumber(self, int)

        Sets the number of points.
        """
        return _btk.btkAcquisition_SetPointNumber(self, *args)

    def ClearPoints(self):
        """
        ClearPoints(self)

        Clear points.
        """
        return _btk.btkAcquisition_ClearPoints(self)

    def FindPoint(self, *args):
        """
        FindPoint(self, string) -> btkPointIterator

        Finds the point with the proposed label and returns the iterator associated with it.
        If no point has the given label, an iterator pointing to the end of the collection is returned.
        """
        return _btk.btkAcquisition_FindPoint(self, *args)

    def AppendPoint(self, *args):
        """
        AppendPoint(self, btkPoint)

        Convenient method to append a point in the acquisition. This method also resizes the frame number of the inserted point if necessary.
        """
        return _btk.btkAcquisition_AppendPoint(self, *args)

    def RemovePoint(self, *args):
        """
        RemovePoint(self, string)
        RemovePoint(self, int)
        RemovePoint(self, btkPointCollectionIterator) -> btkPointCollectionIterator

        Convenient method to delete a point from the acquisition.
        """
        return _btk.btkAcquisition_RemovePoint(self, *args)

    def BeginAnalog(self):
        """
        BeginAnalog(self) -> btkAnalogCollectionIterator

        Returns an iterator to the beginning of the list of analog channels.
        """
        return _btk.btkAcquisition_BeginAnalog(self)

    def EndAnalog(self):
        """
        EndAnalog(self) -> btkAnalogCollectionIterator

        Returns an iterator just past the last analog channel.
        """
        return _btk.btkAcquisition_EndAnalog(self)

    def IsEmptyAnalog(self):
        """
        IsEmptyAnalog(self) -> bool

        Checks if the analogs' list is empty.
        """
        return _btk.btkAcquisition_IsEmptyAnalog(self)

    def GetAnalogNumber(self):
        """
        GetAnalogNumber(self) -> int

        Returns the number of analog channels.
        """
        return _btk.btkAcquisition_GetAnalogNumber(self)

    def SetAnalogNumber(self, *args):
        """
        SetAnalogNumber(self, int)

        Sets the number of analog channels.
        """
        return _btk.btkAcquisition_SetAnalogNumber(self, *args)

    def GetAnalog(self, *args):
        """
        GetAnalog(self, int) -> btkAnalog
        GetAnalog(self, string) -> btkAnalog

        Gets the analog channel at the given index or label. If no Analog exists, then an exception is thrown.
        """
        return _btk.btkAcquisition_GetAnalog(self, *args)

    def SetAnalog(self, *args):
        """
        SetAnalog(self, int, btkAnalog)

        Sets the analog channel at the given index by the content of the given analog channel.
        """
        return _btk.btkAcquisition_SetAnalog(self, *args)

    def GetAnalogs(self):
        """
        GetAnalogs(self) -> btkAnalogCollection

        Returns the collection of analog channels.
        """
        return _btk.btkAcquisition_GetAnalogs(self)

    def SetAnalogs(self, *args):
        """
        SetAnalogs(self, btkAnalogCollection)

        Sets analog channels for this acquisition.
        """
        return _btk.btkAcquisition_SetAnalogs(self, *args)

    def ClearAnalogs(self):
        """
        ClearAnalogs(self)

        Clear analogs channels.
        """
        return _btk.btkAcquisition_ClearAnalogs(self)

    def FindAnalog(self, *args):
        """
        FindAnalog(self, string) -> btkAnalogIterator

        Finds the analog channel with the proposed label and returns the iterator associated with it.
        If no analog channel has the given label, an iterator pointing to the end of the collection is returned.
        """
        return _btk.btkAcquisition_FindAnalog(self, *args)

    def AppendAnalog(self, *args):
        """
        AppendAnalog(self, btkAnalog)

        Append the analog channel ac in the acquisition This method also resizes the frame number of the inserted analog channel if necessary.
        """
        return _btk.btkAcquisition_AppendAnalog(self, *args)

    def RemoveAnalog(self, *args):
        """
        RemoveAnalog(self, string)
        RemoveAnalog(self, int)
        RemoveAnalog(self, btkAnalogCollectionIterator) -> btkAnalogCollectionIterator

        Convenient method to delete an analog channel from the acquisition.
        """
        return _btk.btkAcquisition_RemoveAnalog(self, *args)

    def Init(self, *args):
        """
        Init(self, pointNumber, frameNumber, analogNumber = 0, , analogSampleNumberPerPointFrame = 1)
        Init(self, pointNumber, frameNumber, analogNumber = 0)
        Init(self, pointNumber, frameNumber)

        Initialize the acquisition with the given number of point which have each the given number of frames.
        You can set also the number of analog channels and their number of frames corresponds to the given integer factor multiplied by the number of frames for the points.
        This method label added points and analog channels using the string 'uname*' concatenated with the index of the channel.
        """
        return _btk.btkAcquisition_Init(self, *args)

    def Resize(self, *args):
        """
        Resize(self, pointNumber, frameNumber, analogNumber = 0, , analogSampleNumberPerPointFrame = 1)
        Resize(self, pointNumber, frameNumber, analogNumber = 0)
        Resize(self, pointNumber, frameNumber)

        Resize the acquisition. Same as the method Init(), but does not label added points and analog channels
        """
        return _btk.btkAcquisition_Resize(self, *args)

    def ResizePointNumber(self, *args):
        """
        ResizeFrameNumber(self, int)

        Resize the number of points.
        """
        return _btk.btkAcquisition_ResizePointNumber(self, *args)

    def ResizeAnalogNumber(self, *args):
        """
        ResizeAnalogNumber(self, int)

        Resize the number of analog channels.
        """
        return _btk.btkAcquisition_ResizeAnalogNumber(self, *args)

    def ResizeFrameNumber(self, *args):
        """
        ResizeFrameNumber(self, int)

        Resize the number of frames.
        """
        return _btk.btkAcquisition_ResizeFrameNumber(self, *args)

    def ResizeFrameNumberFromEnd(self, *args):
        """
        ResizeFrameNumber(self, int)

        Resize the number of frames by adding the new frames at the beginning of the acquisition and set automatically the new first frame index.
        """
        return _btk.btkAcquisition_ResizeFrameNumberFromEnd(self, *args)

    def Reset(self):
        """
        Reset(self)

        Resets the acquisition as an empty acquisition.
        To re-populate this acquisition, you need to re-use the Init() method to set the point and analog number and their frame number.
        """
        return _btk.btkAcquisition_Reset(self)

    def GetDuration(self):
        """
        GetDuration(self) -> double

        Returns the duration of the acquisition. The duration is computed as the multiplication of the points' frequency with the points frame number.
        """
        return _btk.btkAcquisition_GetDuration(self)

    def GetFirstFrame(self):
        """
        GetFirstFrame(self) -> int

        Return the first frame index of the acquisition.
        """
        return _btk.btkAcquisition_GetFirstFrame(self)

    def SetFirstFrame(self, *args):
        """
        SetFirstFrame(self, int)

        Sets the first frame index.
        """
        return _btk.btkAcquisition_SetFirstFrame(self, *args)

    def GetLastFrame(self):
        """
        GetLastFrame(self) -> int

        Returns the last frame index of the acquisition base on the first frame index and the frame number.
        """
        return _btk.btkAcquisition_GetLastFrame(self)

    def GetPointUnit(self, *args):
        """
        GetPointUnit(self) -> std::string const
        GetPointUnit(self, arg2) -> std::string const

        Returns the unit for points which have the given type.
        """
        return _btk.btkAcquisition_GetPointUnit(self, *args)

    def SetPointUnit(self, *args):
        """
        SetPointUnit(self, units="mm")
        SetPointUnit(self)
        SetPointUnit(self, arg2, arg3)

        Sets the point's unit for the given point's type. The type btk.btkPoint.Reaction cannot have any unit. You cannot set it.
        """
        return _btk.btkAcquisition_SetPointUnit(self, *args)

    def GetPointFrameNumber(self):
        """
        GetPointFrameNumber(self) -> int

        Returns the number of frames for the points.
        """
        return _btk.btkAcquisition_GetPointFrameNumber(self)

    def GetPointFrequency(self):
        """
        GetPointFrequency(self) -> double

        Returns the point's frequency.
        """
        return _btk.btkAcquisition_GetPointFrequency(self)

    def SetPointFrequency(self, *args):
        """
        SetPointFrequency(self, double)

        Sets the points sample rate.
        """
        return _btk.btkAcquisition_SetPointFrequency(self, *args)

    def GetAnalogFrameNumber(self):
        """
        GetAnalogFrameNumber(self) -> int

        Returns the number of frames for the analog channels.
        """
        return _btk.btkAcquisition_GetAnalogFrameNumber(self)

    def GetNumberAnalogSamplePerFrame(self):
        """
        GetNumberAnalogSamplePerFrame(self) -> int

        Returns the number of analog sample (acquired by each channel) per point frame.
        """
        return _btk.btkAcquisition_GetNumberAnalogSamplePerFrame(self)

    def GetAnalogFrequency(self):
        """
        GetAnalogFrequency(self) -> double

        Returns the analogs sample rate.
        """
        return _btk.btkAcquisition_GetAnalogFrequency(self)

    def GetAnalogResolution(self):
        """
        GetAnalogResolution(self) -> btk.btkAcquisition.AnalogResolution

        Returns the analog resolution.
        """
        return _btk.btkAcquisition_GetAnalogResolution(self)

    def SetAnalogResolution(self, *args):
        """
        SetAnalogResolution(self, btk.btkAcquisition.AnalogResolution)

        Sets the analog resolution.
        """
        return _btk.btkAcquisition_SetAnalogResolution(self, *args)

    def GetMaxInterpolationGap(self):
        """
        GetMaxInterpolationGap(self) -> int

        Gets the maximum gap length that any interpolation method would fill for the 3D point data.
        Warning: Only for information. Could be use later by a filter to fill gap 3D trajectories.
        """
        return _btk.btkAcquisition_GetMaxInterpolationGap(self)

    def SetMaxInterpolationGap(self, *args):
        """
        SetMaxInterpolationGap(self, int)

        Sets the maximum gap length that any interpolation method would fill for the 3D point data.
        Warning: Only for information. Could be use later by a filter to fill gap 3D trajectories.
        """
        return _btk.btkAcquisition_SetMaxInterpolationGap(self, *args)

    def Update(self):
        """
        Update(self)

        Updates the ProcessObject associated with this DataObject.
        """
        return _btk.btkAcquisition_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkAcquisition_GetTimestamp(self)

btkAcquisition_swigregister = _btk.btkAcquisition_swigregister
btkAcquisition_swigregister(btkAcquisition)

class btkAcquisitionFileIO(_object):
    """
    Interface to read/write acquisition's files, cannot be instanced.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkAcquisitionFileIO, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkAcquisitionFileIO, name)
    __repr__ = _swig_repr
    TypeNotApplicable = _btk.btkAcquisitionFileIO_TypeNotApplicable
    ASCII = _btk.btkAcquisitionFileIO_ASCII
    Binary = _btk.btkAcquisitionFileIO_Binary
    OrderNotApplicable = _btk.btkAcquisitionFileIO_OrderNotApplicable
    IEEE_LittleEndian = _btk.btkAcquisitionFileIO_IEEE_LittleEndian
    VAX_LittleEndian = _btk.btkAcquisitionFileIO_VAX_LittleEndian
    IEEE_BigEndian = _btk.btkAcquisitionFileIO_IEEE_BigEndian
    StorageNotApplicable = _btk.btkAcquisitionFileIO_StorageNotApplicable
    Float = _btk.btkAcquisitionFileIO_Float
    Integer = _btk.btkAcquisitionFileIO_Integer
    def __init__(self, *args): 
        """
        __init__(self, toCopy) -> btkAcquisitionFileIO

        Interface to read/write acquisition's files, cannot be instanced.
        """
        this = _btk.new_btkAcquisitionFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkAcquisitionFileIO_impl *"""
        return _btk.btkAcquisitionFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkAcquisitionFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkAcquisitionFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkAcquisitionFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkAcquisitionFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkAcquisitionFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkAcquisitionFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkAcquisitionFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkAcquisitionFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkAcquisitionFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkAcquisitionFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkAcquisitionFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkAcquisitionFileIO_Write(self, *args)

btkAcquisitionFileIO_swigregister = _btk.btkAcquisitionFileIO_swigregister
btkAcquisitionFileIO_swigregister(btkAcquisitionFileIO)

class btkAcquisitionFileReader(_object):
    """
    Reader for files which contain acquisition data (C3D, TRC, ...).
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkAcquisitionFileReader, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkAcquisitionFileReader, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkAcquisitionFileReader

        Reader for files which contain acquisition data (C3D, TRC, ...).
        """
        this = _btk.new_btkAcquisitionFileReader()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkAcquisitionFileReader_impl *"""
        return _btk.btkAcquisitionFileReader___deref__(self)

    def GetAcquisitionIO(self):
        """
        GetAcquisitionIO(self) -> btkAcquisitionFileIO

        Returns the btkAcquisitionIO used to read the given file.
        """
        return _btk.btkAcquisitionFileReader_GetAcquisitionIO(self)

    __swig_destroy__ = _btk.delete_btkAcquisitionFileReader
    __del__ = lambda self : None;
    def GetOutput(self):
        """
        GetOutput(self) -> btkAcquisition

        Returns the btkAcquisition read from the btkAcquisitionIO helper class.
        """
        return _btk.btkAcquisitionFileReader_GetOutput(self)

    def GetDisableFilenameExceptionState(self):
        """
        GetDisableFilenameExceptionState(self) -> bool

        Returns state of the disabling of the exception for missing filename.
        """
        return _btk.btkAcquisitionFileReader_GetDisableFilenameExceptionState(self)

    def SetDisableFilenameExceptionState(self, *args):
        """
        SetDisableFilenameExceptionState(self, bool)

        Enable/disable exception for the missing of the filename.
        """
        return _btk.btkAcquisitionFileReader_SetDisableFilenameExceptionState(self, *args)

    def GetFilename(self):
        """
        GetFilename(self) -> std::string const &

        Gets the filename of the file to read.
        """
        return _btk.btkAcquisitionFileReader_GetFilename(self)

    def SetFilename(self, *args):
        """
        SetFilename(self, string)

        Specifies the file to read. This is forwarded to the IO instance.
        """
        return _btk.btkAcquisitionFileReader_SetFilename(self, *args)

    def SetAcquisitionIO(self, *args):
        """
        SetAcquisitionIO(self, io=btkAcquisitionFileIO())
        SetAcquisitionIO(self)

        Set the btkAcquisitionIO helper class. This method forces the btkAcquisitionIO to be used to read a particular file.
        The btkAcquisitionIO is ofently created via the object factory mechanism that determines whether a particular btkAcquisitionIO can read a certain file.
        """
        return _btk.btkAcquisitionFileReader_SetAcquisitionIO(self, *args)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkAcquisitionFileReader_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkAcquisitionFileReader_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkAcquisitionFileReader_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkAcquisitionFileReader_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkAcquisitionFileReader_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkAcquisitionFileReader_GetTimestamp(self)

btkAcquisitionFileReader_swigregister = _btk.btkAcquisitionFileReader_swigregister
btkAcquisitionFileReader_swigregister(btkAcquisitionFileReader)

class btkAcquisitionFileWriter(_object):
    """
    Writer of acquisition data into acquisition file (C3D, TRC, ...).
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkAcquisitionFileWriter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkAcquisitionFileWriter, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkAcquisitionFileWriter

        Writer of acquisition data into acquisition file (C3D, TRC, ...).
        """
        this = _btk.new_btkAcquisitionFileWriter()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkAcquisitionFileWriter_impl *"""
        return _btk.btkAcquisitionFileWriter___deref__(self)

    def GetAcquisitionIO(self):
        """
        GetAcquisitionIO(self) -> btkAcquisitionFileIO

        Returns the btkAcquisitionIO used to write the given acquisition
        """
        return _btk.btkAcquisitionFileWriter_GetAcquisitionIO(self)

    __swig_destroy__ = _btk.delete_btkAcquisitionFileWriter
    __del__ = lambda self : None;
    def GetInput(self):
        """
        GetInput(self) -> btkAcquisition

        Returns the btkAcquisition to write by a btkAcquisitionIO helper class
        """
        return _btk.btkAcquisitionFileWriter_GetInput(self)

    def SetInput(self, *args):
        """
        SetInput(self, arg2)

        Sets the btkAcquisition to write by a btkAcquisitionIO helper class
        """
        return _btk.btkAcquisitionFileWriter_SetInput(self, *args)

    def GetFilename(self):
        """
        GetFilename(self) -> std::string const &

        Gets the filename of the file to write.
        """
        return _btk.btkAcquisitionFileWriter_GetFilename(self)

    def SetFilename(self, *args):
        """
        SetFilename(self, arg2)

        Specifies the file to write. This is forwarded to the IO instance.
        """
        return _btk.btkAcquisitionFileWriter_SetFilename(self, *args)

    def SetAcquisitionIO(self, *args):
        """
        SetAcquisitionIO(self, io=btkAcquisitionFileIO())
        SetAcquisitionIO(self)

        Set the btkAcquisitionIO helper class. This method forces the btkAcquisitionIO to be used to write a particular file.
        The btkAcquisitionIO is ofently created via the object factory mechanism that determines whether a particular btkAcquisitionIO can write a certain file
        """
        return _btk.btkAcquisitionFileWriter_SetAcquisitionIO(self, *args)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkAcquisitionFileWriter_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkAcquisitionFileWriter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkAcquisitionFileWriter_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkAcquisitionFileWriter_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkAcquisitionFileWriter_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkAcquisitionFileWriter_GetTimestamp(self)

btkAcquisitionFileWriter_swigregister = _btk.btkAcquisitionFileWriter_swigregister
btkAcquisitionFileWriter_swigregister(btkAcquisitionFileWriter)

class btkC3DFileIO(btkAcquisitionFileIO):
    """
    Interface to read/write C3D files.
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkC3DFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkC3DFileIO, name)
    __repr__ = _swig_repr
    Signed = _btk.btkC3DFileIO_Signed
    Unsigned = _btk.btkC3DFileIO_Unsigned
    None_ = _btk.btkC3DFileIO_None_
    ScalesFromDataUpdate = _btk.btkC3DFileIO_ScalesFromDataUpdate
    ScalesFromMetaDataUpdate = _btk.btkC3DFileIO_ScalesFromMetaDataUpdate
    MetaDataFromDataUpdate = _btk.btkC3DFileIO_MetaDataFromDataUpdate
    CompatibleVicon = _btk.btkC3DFileIO_CompatibleVicon
    def __init__(self, *args): 
        """
        __init__(self) -> btkC3DFileIO
        __init__(self, toCopy) -> btkC3DFileIO

        Interface to read/write C3D files.
        """
        this = _btk.new_btkC3DFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkC3DFileIO_impl *"""
        return _btk.btkC3DFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkC3DFileIO
    __del__ = lambda self : None;
    def GetPointScale(self):
        """
        GetPointScale(self) -> double

        Returns the scale for the points obtains from the POINT:SCALE parameter or from its determination for a created acquisition.
        """
        return _btk.btkC3DFileIO_GetPointScale(self)

    def SetPointScale(self, *args):
        """
        SetPointScale(self, s)

        Sets the scale for the points.
        """
        return _btk.btkC3DFileIO_SetPointScale(self, *args)

    def GetAnalogIntegerFormat(self):
        """
        GetAnalogIntegerFormat(self) -> btkC3DFileIO_impl::AnalogIntegerFormat

        Return the integer format (signed/unsigned).
        """
        return _btk.btkC3DFileIO_GetAnalogIntegerFormat(self)

    def SetAnalogIntegerFormat(self, *args):
        """
        SetAnalogIntegerFormat(self, f)

        Sets the integer format used to store analog channels data.
        """
        return _btk.btkC3DFileIO_SetAnalogIntegerFormat(self, *args)

    def GetAnalogChannelScale(self):
        """
        GetAnalogChannelScale(self) -> btkDoubleArray

        Returns the vector of scales used for the analog channels' scaling (parameter ANALOG:SCALE).
        """
        return _btk.btkC3DFileIO_GetAnalogChannelScale(self)

    def SetAnalogChannelScale(self, *args):
        """
        SetAnalogChannelScale(self, s)

        Sets the vector of scales used for the analog channels' scaling.
        """
        return _btk.btkC3DFileIO_SetAnalogChannelScale(self, *args)

    def GetAnalogZeroOffset(self):
        """
        GetAnalogZeroOffset(self) -> btkIntArray

        Returns the vector of offsets used for the analog channels' scaling (parameter ANALOG:OFFSET).
        """
        return _btk.btkC3DFileIO_GetAnalogZeroOffset(self)

    def SetAnalogZeroOffset(self, *args):
        """
        SetAnalogZeroOffset(self, s)

        Sets the vector of offsets used for the analog channels' scaling.
        """
        return _btk.btkC3DFileIO_SetAnalogZeroOffset(self, *args)

    def GetAnalogUniversalScale(self):
        """
        GetAnalogUniversalScale(self) -> double

        Returns the universal scale factor used to scale analog channels (parameter ANALOG:GEN_SCALE).
        """
        return _btk.btkC3DFileIO_GetAnalogUniversalScale(self)

    def SetAnalogUniversalScale(self, *args):
        """
        SetAnalogUniversalScale(self, s)

        Sets Returns the universal scale factor used to scale analog channels.
        """
        return _btk.btkC3DFileIO_SetAnalogUniversalScale(self, *args)

    def GetWritingFlags(self):
        """
        GetWritingFlags(self) -> int

        Returns the flags to use during the acquisition's exportation into a C3D files.
        """
        return _btk.btkC3DFileIO_GetWritingFlags(self)

    def SetWritingFlags(self, *args):
        """
        SetWritingFlags(self, flags)

        Sets the flags to use during the acquisition's exportation into a C3D files.
        """
        return _btk.btkC3DFileIO_SetWritingFlags(self, *args)

    def HasWritingFlag(self, *args):
        """
        HasWritingFlag(self, flag) -> bool

        Detects if the given flag is activated.
        """
        return _btk.btkC3DFileIO_HasWritingFlag(self, *args)

    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkC3DFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkC3DFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkC3DFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkC3DFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkC3DFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkC3DFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkC3DFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkC3DFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkC3DFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkC3DFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkC3DFileIO_Write(self, *args)

btkC3DFileIO_swigregister = _btk.btkC3DFileIO_swigregister
btkC3DFileIO_swigregister(btkC3DFileIO)

class btkANBFileIO(btkAcquisitionFileIO):
    """
    Interface to read/write ANB files (Motion Analysis Corp.).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkANBFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkANBFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkANBFileIO
        __init__(self, toCopy) -> btkANBFileIO

        Interface to read/write ANB files (Motion Analysis Corp.).
        """
        this = _btk.new_btkANBFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkANBFileIO_impl *"""
        return _btk.btkANBFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkANBFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkANBFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkANBFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkANBFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkANBFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkANBFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkANBFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkANBFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkANBFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkANBFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkANBFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkANBFileIO_Write(self, *args)

btkANBFileIO_swigregister = _btk.btkANBFileIO_swigregister
btkANBFileIO_swigregister(btkANBFileIO)

class btkANCFileIO(btkAcquisitionFileIO):
    """
    Interface to read/write ANC files (Motion Analysis Corp.).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkANCFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkANCFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkANCFileIO
        __init__(self, toCopy) -> btkANCFileIO

        Interface to read/write ANC files (Motion Analysis Corp.).
        """
        this = _btk.new_btkANCFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkANCFileIO_impl *"""
        return _btk.btkANCFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkANCFileIO
    __del__ = lambda self : None;
    def GetFileGeneration(self):
        """
        GetFileGeneration(self) -> int

        Returns the generation of the ANC file.
        """
        return _btk.btkANCFileIO_GetFileGeneration(self)

    def SetFileGeneration(self, *args):
        """
        SetFileGeneration(self, gen)

        Set the generation of the ANC file.
        """
        return _btk.btkANCFileIO_SetFileGeneration(self, *args)

    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkANCFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkANCFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkANCFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkANCFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkANCFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkANCFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkANCFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkANCFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkANCFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkANCFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkANCFileIO_Write(self, *args)

btkANCFileIO_swigregister = _btk.btkANCFileIO_swigregister
btkANCFileIO_swigregister(btkANCFileIO)

class btkANGFileIO(btkAcquisitionFileIO):
    """
    Interface to read ANG files (Elite - BTS Bioengineering).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkANGFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkANGFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkANGFileIO
        __init__(self, toCopy) -> btkANGFileIO

        Interface to read ANG files (Elite - BTS Bioengineering).
        """
        this = _btk.new_btkANGFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkANGFileIO_impl *"""
        return _btk.btkANGFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkANGFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkANGFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkANGFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkANGFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkANGFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkANGFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkANGFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkANGFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkANGFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkANGFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkANGFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkANGFileIO_Write(self, *args)

btkANGFileIO_swigregister = _btk.btkANGFileIO_swigregister
btkANGFileIO_swigregister(btkANGFileIO)

class btkCALForcePlateFileIO(btkAcquisitionFileIO):
    """
    Interface to read/write force platform calibration CAL files (Motion Analysis Corp.).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkCALForcePlateFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkCALForcePlateFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkCALForcePlateFileIO
        __init__(self, toCopy) -> btkCALForcePlateFileIO

        Interface to read/write force platform calibration CAL files (Motion Analysis Corp.).
        """
        this = _btk.new_btkCALForcePlateFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkCALForcePlateFileIO_impl *"""
        return _btk.btkCALForcePlateFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkCALForcePlateFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkCALForcePlateFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkCALForcePlateFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkCALForcePlateFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkCALForcePlateFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkCALForcePlateFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkCALForcePlateFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkCALForcePlateFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkCALForcePlateFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkCALForcePlateFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkCALForcePlateFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkCALForcePlateFileIO_Write(self, *args)

btkCALForcePlateFileIO_swigregister = _btk.btkCALForcePlateFileIO_swigregister
btkCALForcePlateFileIO_swigregister(btkCALForcePlateFileIO)

class btkCLBFileIO(btkAcquisitionFileIO):
    """
    Interface to read CLB files (Contec Inc.).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkCLBFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkCLBFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkCLBFileIO
        __init__(self, toCopy) -> btkCLBFileIO

        Interface to read CLB files (Contec Inc.).
        """
        this = _btk.new_btkCLBFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkCLBFileIO_impl *"""
        return _btk.btkCLBFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkCLBFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkCLBFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkCLBFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkCLBFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkCLBFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkCLBFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkCLBFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkCLBFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkCLBFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkCLBFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkCLBFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkCLBFileIO_Write(self, *args)

btkCLBFileIO_swigregister = _btk.btkCLBFileIO_swigregister
btkCLBFileIO_swigregister(btkCLBFileIO)

class btkDelsysEMGFileIO(btkAcquisitionFileIO):
    """
    Interface to read EMG file (Delsys Inc.).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkDelsysEMGFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkDelsysEMGFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkDelsysEMGFileIO
        __init__(self, toCopy) -> btkDelsysEMGFileIO

        Interface to read EMG file (Delsys Inc.).
        """
        this = _btk.new_btkDelsysEMGFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkDelsysEMGFileIO_impl *"""
        return _btk.btkDelsysEMGFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkDelsysEMGFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkDelsysEMGFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkDelsysEMGFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkDelsysEMGFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkDelsysEMGFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkDelsysEMGFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkDelsysEMGFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkDelsysEMGFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkDelsysEMGFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkDelsysEMGFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkDelsysEMGFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkDelsysEMGFileIO_Write(self, *args)

btkDelsysEMGFileIO_swigregister = _btk.btkDelsysEMGFileIO_swigregister
btkDelsysEMGFileIO_swigregister(btkDelsysEMGFileIO)

class btkMDFFileIO(btkAcquisitionFileIO):
    """
    Interface to read MDF files (Codamotion).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkMDFFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkMDFFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkMDFFileIO
        __init__(self, toCopy) -> btkMDFFileIO

        Interface to read MDF files (Codamotion).
        """
        this = _btk.new_btkMDFFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkMDFFileIO_impl *"""
        return _btk.btkMDFFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkMDFFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkMDFFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkMDFFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkMDFFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkMDFFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkMDFFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkMDFFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkMDFFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkMDFFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkMDFFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkMDFFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkMDFFileIO_Write(self, *args)

btkMDFFileIO_swigregister = _btk.btkMDFFileIO_swigregister
btkMDFFileIO_swigregister(btkMDFFileIO)

class btkEMFFileIO(btkAcquisitionFileIO):
    """
    Interface to read EMF files (Ascension Technology Corporation).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkEMFFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkEMFFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkEMFFileIO
        __init__(self, toCopy) -> btkEMFFileIO

        Interface to read EMF files (Ascension Technology Corporation).
        """
        this = _btk.new_btkEMFFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkEMFFileIO_impl *"""
        return _btk.btkEMFFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkEMFFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkEMFFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkEMFFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkEMFFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkEMFFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkEMFFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkEMFFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkEMFFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkEMFFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkEMFFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkEMFFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkEMFFileIO_Write(self, *args)

btkEMFFileIO_swigregister = _btk.btkEMFFileIO_swigregister
btkEMFFileIO_swigregister(btkEMFFileIO)

class btkEMxFileIO(btkAcquisitionFileIO):
    """
    Interface to read EMG files (Elite - BTS Bioengineering).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkEMxFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkEMxFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkEMxFileIO
        __init__(self, toCopy) -> btkEMxFileIO

        Interface to read EMG files (Elite - BTS Bioengineering).
        """
        this = _btk.new_btkEMxFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkEMxFileIO_impl *"""
        return _btk.btkEMxFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkEMxFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkEMxFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkEMxFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkEMxFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkEMxFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkEMxFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkEMxFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkEMxFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkEMxFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkEMxFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkEMxFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkEMxFileIO_Write(self, *args)

btkEMxFileIO_swigregister = _btk.btkEMxFileIO_swigregister
btkEMxFileIO_swigregister(btkEMxFileIO)

class btkGRxFileIO(btkAcquisitionFileIO):
    """
    Interface to read GR* (GR1, GR2, ...) files (Elite - BTS Bioengineering).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkGRxFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkGRxFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkGRxFileIO
        __init__(self, toCopy) -> btkGRxFileIO

        Interface to read GR* (GR1, GR2, ...) files (Elite - BTS Bioengineering).
        """
        this = _btk.new_btkGRxFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkGRxFileIO_impl *"""
        return _btk.btkGRxFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkGRxFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkGRxFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkGRxFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkGRxFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkGRxFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkGRxFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkGRxFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkGRxFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkGRxFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkGRxFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkGRxFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkGRxFileIO_Write(self, *args)

btkGRxFileIO_swigregister = _btk.btkGRxFileIO_swigregister
btkGRxFileIO_swigregister(btkGRxFileIO)

class btkMOMFileIO(btkAcquisitionFileIO):
    """
    Interface to read MOM files (Elite - BTS Bioengineering).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkMOMFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkMOMFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkMOMFileIO
        __init__(self, toCopy) -> btkMOMFileIO

        Interface to read MOM files (Elite - BTS Bioengineering).
        """
        this = _btk.new_btkMOMFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkMOMFileIO_impl *"""
        return _btk.btkMOMFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkMOMFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkMOMFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkMOMFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkMOMFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkMOMFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkMOMFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkMOMFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkMOMFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkMOMFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkMOMFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkMOMFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkMOMFileIO_Write(self, *args)

btkMOMFileIO_swigregister = _btk.btkMOMFileIO_swigregister
btkMOMFileIO_swigregister(btkMOMFileIO)

class btkPWRFileIO(btkAcquisitionFileIO):
    """
    Interface to read PWR files (Elite - BTS Bioengineering).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkPWRFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkPWRFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkPWRFileIO
        __init__(self, toCopy) -> btkPWRFileIO

        Interface to read PWR files (Elite - BTS Bioengineering).
        """
        this = _btk.new_btkPWRFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkPWRFileIO_impl *"""
        return _btk.btkPWRFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkPWRFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkPWRFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkPWRFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkPWRFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkPWRFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkPWRFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkPWRFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkPWRFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkPWRFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkPWRFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkPWRFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkPWRFileIO_Write(self, *args)

btkPWRFileIO_swigregister = _btk.btkPWRFileIO_swigregister
btkPWRFileIO_swigregister(btkPWRFileIO)

class btkRAxFileIO(btkAcquisitionFileIO):
    """
    Interface to read RAW, RAH files (Elite - BTS Bioengineering).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkRAxFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkRAxFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkRAxFileIO
        __init__(self, toCopy) -> btkRAxFileIO

        Interface to read RAW, RAH files (Elite - BTS Bioengineering).
        """
        this = _btk.new_btkRAxFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkRAxFileIO_impl *"""
        return _btk.btkRAxFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkRAxFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkRAxFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkRAxFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkRAxFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkRAxFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkRAxFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkRAxFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkRAxFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkRAxFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkRAxFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkRAxFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkRAxFileIO_Write(self, *args)

btkRAxFileIO_swigregister = _btk.btkRAxFileIO_swigregister
btkRAxFileIO_swigregister(btkRAxFileIO)

class btkRICFileIO(btkAcquisitionFileIO):
    """
    Interface to read RIC files (Elite - BTS Bioengineering).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkRICFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkRICFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkRICFileIO
        __init__(self, toCopy) -> btkRICFileIO

        Interface to read RIC files (Elite - BTS Bioengineering).
        """
        this = _btk.new_btkRICFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkRICFileIO_impl *"""
        return _btk.btkRICFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkRICFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkRICFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkRICFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkRICFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkRICFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkRICFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkRICFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkRICFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkRICFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkRICFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkRICFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkRICFileIO_Write(self, *args)

btkRICFileIO_swigregister = _btk.btkRICFileIO_swigregister
btkRICFileIO_swigregister(btkRICFileIO)

class btkTDFFileIO(btkAcquisitionFileIO):
    """
    Interface to read TDF files (BTS Bioengineering).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkTDFFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkTDFFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkTDFFileIO
        __init__(self, toCopy) -> btkTDFFileIO

        Interface to read TDF files (BTS Bioengineering).
        """
        this = _btk.new_btkTDFFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkTDFFileIO_impl *"""
        return _btk.btkTDFFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkTDFFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkTDFFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkTDFFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkTDFFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkTDFFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkTDFFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkTDFFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkTDFFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkTDFFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkTDFFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkTDFFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkTDFFileIO_Write(self, *args)

btkTDFFileIO_swigregister = _btk.btkTDFFileIO_swigregister
btkTDFFileIO_swigregister(btkTDFFileIO)

class btkTRBFileIO(btkAcquisitionFileIO):
    """
    Interface to read/write TRB files (Motion Analysis Corp.).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkTRBFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkTRBFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkTRBFileIO
        __init__(self, toCopy) -> btkTRBFileIO

        Interface to read/write TRB files (Motion Analysis Corp.).
        """
        this = _btk.new_btkTRBFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkTRBFileIO_impl *"""
        return _btk.btkTRBFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkTRBFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkTRBFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkTRBFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkTRBFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkTRBFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkTRBFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkTRBFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkTRBFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkTRBFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkTRBFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkTRBFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkTRBFileIO_Write(self, *args)

btkTRBFileIO_swigregister = _btk.btkTRBFileIO_swigregister
btkTRBFileIO_swigregister(btkTRBFileIO)

class btkTRCFileIO(btkAcquisitionFileIO):
    """
    Interface to read/write TRC files (Motion Analysis Corp.).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkTRCFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkTRCFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkTRCFileIO
        __init__(self, toCopy) -> btkTRCFileIO

        Interface to read/write TRC files (Motion Analysis Corp.).
        """
        this = _btk.new_btkTRCFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkTRCFileIO_impl *"""
        return _btk.btkTRCFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkTRCFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkTRCFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkTRCFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkTRCFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkTRCFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkTRCFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkTRCFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkTRCFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkTRCFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkTRCFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkTRCFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkTRCFileIO_Write(self, *args)

btkTRCFileIO_swigregister = _btk.btkTRCFileIO_swigregister
btkTRCFileIO_swigregister(btkTRCFileIO)

class btkXLSOrthoTrakFileIO(btkAcquisitionFileIO):
    """
    Interface to read XLS OrthoTrak files (Motion Analysis Corp.).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkXLSOrthoTrakFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkXLSOrthoTrakFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkXLSOrthoTrakFileIO
        __init__(self, toCopy) -> btkXLSOrthoTrakFileIO

        Interface to read XLS OrthoTrak files (Motion Analysis Corp.).
        """
        this = _btk.new_btkXLSOrthoTrakFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkXLSOrthoTrakFileIO_impl *"""
        return _btk.btkXLSOrthoTrakFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkXLSOrthoTrakFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkXLSOrthoTrakFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkXLSOrthoTrakFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkXLSOrthoTrakFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkXLSOrthoTrakFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkXLSOrthoTrakFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkXLSOrthoTrakFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkXLSOrthoTrakFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkXLSOrthoTrakFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkXLSOrthoTrakFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkXLSOrthoTrakFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkXLSOrthoTrakFileIO_Write(self, *args)

btkXLSOrthoTrakFileIO_swigregister = _btk.btkXLSOrthoTrakFileIO_swigregister
btkXLSOrthoTrakFileIO_swigregister(btkXLSOrthoTrakFileIO)

class btkXMOVEFileIO(btkAcquisitionFileIO):
    """
    Interface to read XMOVE files (Codamotion).
    """
    __swig_setmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_setmethods__.update(getattr(_s,'__swig_setmethods__',{}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkXMOVEFileIO, name, value)
    __swig_getmethods__ = {}
    for _s in [btkAcquisitionFileIO]: __swig_getmethods__.update(getattr(_s,'__swig_getmethods__',{}))
    __getattr__ = lambda self, name: _swig_getattr(self, btkXMOVEFileIO, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self) -> btkXMOVEFileIO
        __init__(self, toCopy) -> btkXMOVEFileIO

        Interface to read XMOVE files (Codamotion).
        """
        this = _btk.new_btkXMOVEFileIO(*args)
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkXMOVEFileIO_impl *"""
        return _btk.btkXMOVEFileIO___deref__(self)

    __swig_destroy__ = _btk.delete_btkXMOVEFileIO
    __del__ = lambda self : None;
    def GetFileType(self):
        """
        GetFileType(self) -> btkAcquisitionFileIO_impl::FileType

        Gets the type of the file.
        """
        return _btk.btkXMOVEFileIO_GetFileType(self)

    def GetByteOrder(self):
        """
        GetByteOrder(self) -> btkAcquisitionFileIO_impl::ByteOrder

        Gets the byte order of the file (only for binary file).
        """
        return _btk.btkXMOVEFileIO_GetByteOrder(self)

    def GetByteOrderAsString(self):
        """
        GetByteOrderAsString(self) -> std::string

        Gets the byte order as a string.
        """
        return _btk.btkXMOVEFileIO_GetByteOrderAsString(self)

    def SetByteOrder(self, *args):
        """
        SetByteOrder(self, b)

        Sets the byte order of the file.
        """
        return _btk.btkXMOVEFileIO_SetByteOrder(self, *args)

    def GetStorageFormat(self):
        """
        GetStorageFormat(self) -> btkAcquisitionFileIO_impl::StorageFormat

        Return the format used to store points and analog channels.
        """
        return _btk.btkXMOVEFileIO_GetStorageFormat(self)

    def GetStorageFormatAsString(self):
        """
        GetStorageFormatAsString(self) -> std::string

        Gets the storage format as a string.
        """
        return _btk.btkXMOVEFileIO_GetStorageFormatAsString(self)

    def SetStorageFormat(self, *args):
        """
        SetStorageFormat(self, s)

        Set the format used to store points and analog channels.
        """
        return _btk.btkXMOVEFileIO_SetStorageFormat(self, *args)

    def CanReadFile(self, *args):
        """
        CanReadFile(self, filename) -> bool

        Checks if the given filename can be read by this AcquisitionFileIO. This methods should try to read the file header instead to check the file's suffix.
        """
        return _btk.btkXMOVEFileIO_CanReadFile(self, *args)

    def CanWriteFile(self, *args):
        """
        CanWriteFile(self, filename) -> bool

        Checks if the given filename can be write by this AcquisitionFileIO. 
        This method should try to determine if the file's suffix corresponds to one of the supported file's suffixes by this btkAcquisitionFileIO.
        """
        return _btk.btkXMOVEFileIO_CanWriteFile(self, *args)

    def Read(self, *args):
        """
        Read(self, filename, output)

        Read the file designated by the given filename and fill the given btkAcquisition
        """
        return _btk.btkXMOVEFileIO_Read(self, *args)

    def Write(self, *args):
        """
        Write(self, filename, input)

        Write the file designated by the given filename with the content of the given btkAcquisition.
        """
        return _btk.btkXMOVEFileIO_Write(self, *args)

btkXMOVEFileIO_swigregister = _btk.btkXMOVEFileIO_swigregister
btkXMOVEFileIO_swigregister(btkXMOVEFileIO)

class btkAcquisitionUnitConverter(_object):
    """
    This filter can convert units for trajectory, force, moment, angle and power.
    The known unit for the trajectory (length) are:
     - meter (m);
     - decimeter (dm);
     - centimeter (cm)
     - millimeter (mm)
     - inch (in)
    The known unit for the force are:
     - newton (N);
    The known unit for the moment are:
     - newton by meter (Nm);
     - newton by decimeter (Ndm);
     - newton by centimeter (Ncm);
     - newton by millimeter (Nmm);
     - newton by inch (Nin);
    The known unit for the angle are:
     - radian (rad);
     - degree (deg);
    The known unit for the power are:
     - watt (W);
    Moreover, the metadata known to be influenced by these unit (FORCE_PLATFORM, 
    SEG) are also converted. The metadata POINT:*UNITS are not updated as they are not
    used in BTK (instead, you can use the method btkAcquisition::GetPointUnit()).

    Use the method btkAcquisitionUnitConverter::SetUnit() with the following enumeration 
    value to select the wanted units:
     - btk.btkAcquisitionUnitConverter.Length
     - btk.btkAcquisitionUnitConverter.Angle
     - btk.btkAcquisitionUnitConverter.Force
     - btk.btkAcquisitionUnitConverter.Moment
     - btk.btkAcquisitionUnitConverter.Power

    By default, the data will be converted in millimeter, newton, newton by millimeter, 
    degree and watt. Even if you could convert trajectories and moments with the desired 
    units, it is recommended to use the same length unit (i.e. mm and Nmm or m with Nm).
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkAcquisitionUnitConverter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkAcquisitionUnitConverter, name)
    __repr__ = _swig_repr
    Length = _btk.btkAcquisitionUnitConverter_Length
    Angle = _btk.btkAcquisitionUnitConverter_Angle
    Force = _btk.btkAcquisitionUnitConverter_Force
    Moment = _btk.btkAcquisitionUnitConverter_Moment
    Power = _btk.btkAcquisitionUnitConverter_Power
    def __init__(self): 
        """
        __init__(self) -> btkAcquisitionUnitConverter

        This filter can convert units for trajectory, force, moment, angle and power.
        The known unit for the trajectory (length) are:
         - meter (m);
         - decimeter (dm);
         - centimeter (cm)
         - millimeter (mm)
         - inch (in)
        The known unit for the force are:
         - newton (N);
        The known unit for the moment are:
         - newton by meter (Nm);
         - newton by decimeter (Ndm);
         - newton by centimeter (Ncm);
         - newton by millimeter (Nmm);
         - newton by inch (Nin);
        The known unit for the angle are:
         - radian (rad);
         - degree (deg);
        The known unit for the power are:
         - watt (W);
        Moreover, the metadata known to be influenced by these unit (FORCE_PLATFORM, 
        SEG) are also converted. The metadata POINT:*UNITS are not updated as they are not
        used in BTK (instead, you can use the method btkAcquisition::GetPointUnit()).

        Use the method btkAcquisitionUnitConverter::SetUnit() with the following enumeration 
        value to select the wanted units:
         - btk.btkAcquisitionUnitConverter.Length
         - btk.btkAcquisitionUnitConverter.Angle
         - btk.btkAcquisitionUnitConverter.Force
         - btk.btkAcquisitionUnitConverter.Moment
         - btk.btkAcquisitionUnitConverter.Power

        By default, the data will be converted in millimeter, newton, newton by millimeter, 
        degree and watt. Even if you could convert trajectories and moments with the desired 
        units, it is recommended to use the same length unit (i.e. mm and Nmm or m with Nm).
        """
        this = _btk.new_btkAcquisitionUnitConverter()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkAcquisitionUnitConverter_impl *"""
        return _btk.btkAcquisitionUnitConverter___deref__(self)

    __swig_destroy__ = _btk.delete_btkAcquisitionUnitConverter
    __del__ = lambda self : None;
    def GetInput(self):
        """
        GetInput(self) -> btkAcquisition

        Gets the input registered with this process.
        """
        return _btk.btkAcquisitionUnitConverter_GetInput(self)

    def SetInput(self, *args):
        """
        SetInput(self, btkAcquisition)

        Sets the input required with this process.
        """
        return _btk.btkAcquisitionUnitConverter_SetInput(self, *args)

    def GetOutput(self):
        """
        GetOutput(self) -> btkAcquisition

        Returns the output created with this process.
        """
        return _btk.btkAcquisitionUnitConverter_GetOutput(self)

    def SetUnit(self, *args):
        """
        SetUnit(self, btk.btkAcquisitionUnitConverter.Unit, string)

        Set the given unit with the given string
        """
        return _btk.btkAcquisitionUnitConverter_SetUnit(self, *args)

    def GetUnit(self, *args):
        """
        GetUnit(self, btk.btkAcquisitionUnitConverter.Unit) -> string

        Returns the string corresponding to the given unit
        """
        return _btk.btkAcquisitionUnitConverter_GetUnit(self, *args)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkAcquisitionUnitConverter_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkAcquisitionUnitConverter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkAcquisitionUnitConverter_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkAcquisitionUnitConverter_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkAcquisitionUnitConverter_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkAcquisitionUnitConverter_GetTimestamp(self)

btkAcquisitionUnitConverter_swigregister = _btk.btkAcquisitionUnitConverter_swigregister
btkAcquisitionUnitConverter_swigregister(btkAcquisitionUnitConverter)

class btkAnalogOffsetRemover(_object):
    """
    Remove a possible analog offset to the selected analog channels

    Based on the given offset input (see the method SetOffsetInput()), each analog signals
    are averaged and removed from the raw input (see the method SetRawInput()). The analog signals set in the raw input which
    are not given to the offset input are not processed but will be available in the output.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkAnalogOffsetRemover, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkAnalogOffsetRemover, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkAnalogOffsetRemover

        Remove a possible analog offset to the selected analog channels

        Based on the given offset input (see the method SetOffsetInput()), each analog signals
        are averaged and removed from the raw input (see the method SetRawInput()). The analog signals set in the raw input which
        are not given to the offset input are not processed but will be available in the output.
        """
        this = _btk.new_btkAnalogOffsetRemover()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkAnalogOffsetRemover_impl *"""
        return _btk.btkAnalogOffsetRemover___deref__(self)

    __swig_destroy__ = _btk.delete_btkAnalogOffsetRemover
    __del__ = lambda self : None;
    def SetRawInput(self, *args):
        """
        SetRawInput(self, btkAcquisition)

        Sets the input required with this process which is used as the input to process.
        """
        return _btk.btkAnalogOffsetRemover_SetRawInput(self, *args)

    def GetRawInput(self):
        """
        GetRawInput(self) -> btkAcquisition

        Gets the input registered with this process which is used as the input to process.
        """
        return _btk.btkAnalogOffsetRemover_GetRawInput(self)

    def SetOffsetInput(self, *args):
        """
        SetOffsetInput(self, btkAcquisition)

        Sets the input required with this process which corresponds to the offsets to remove.
        """
        return _btk.btkAnalogOffsetRemover_SetOffsetInput(self, *args)

    def GetOffsetInput(self):
        """
        GetOffsetInput(self) -> btkAcquisition

        Gets the input registered with this process which corresponds to the offsets to remove.
        """
        return _btk.btkAnalogOffsetRemover_GetOffsetInput(self)

    def GetOutput(self):
        """
        GetOutput(self) -> btkAcquisition

        Returns the output created with this process.
        """
        return _btk.btkAnalogOffsetRemover_GetOutput(self)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkAnalogOffsetRemover_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkAnalogOffsetRemover_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkAnalogOffsetRemover_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkAnalogOffsetRemover_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkAnalogOffsetRemover_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkAnalogOffsetRemover_GetTimestamp(self)

btkAnalogOffsetRemover_swigregister = _btk.btkAnalogOffsetRemover_swigregister
btkAnalogOffsetRemover_swigregister(btkAnalogOffsetRemover)

class btkWrenchDownsampleFilter(_object):
    """
    Downsample data stored in a wrench

    To downsample data, you need to set the up/down sample ratio using the method SetUpDownRatio().
    The given value is an integer corresponding to the ratio used to extract only the value of interest.
    For example, if you have 200 frames and a ratio of 10, then 20 frames will be extracted (one frame each 10 frames).
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkWrenchDownsampleFilter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkWrenchDownsampleFilter, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkWrenchDownsampleFilter

        Downsample data stored in a wrench

        To downsample data, you need to set the up/down sample ratio using the method SetUpDownRatio().
        The given value is an integer corresponding to the ratio used to extract only the value of interest.
        For example, if you have 200 frames and a ratio of 10, then 20 frames will be extracted (one frame each 10 frames).
        """
        this = _btk.new_btkWrenchDownsampleFilter()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkWrenchDownsampleFilter_impl *"""
        return _btk.btkWrenchDownsampleFilter___deref__(self)

    __swig_destroy__ = _btk.delete_btkWrenchDownsampleFilter
    __del__ = lambda self : None;
    def GetInput(self):
        """
        GetInput(self) -> btkWrench

        Gets the input registered with this process.
        """
        return _btk.btkWrenchDownsampleFilter_GetInput(self)

    def SetInput(self, *args):
        """
        SetInput(self, btkWrench)

        Sets the input required with this process.
        """
        return _btk.btkWrenchDownsampleFilter_SetInput(self, *args)

    def GetOutput(self):
        """
        GetOutput(self) -> btkWrench

        Returns the output created with this process.
        """
        return _btk.btkWrenchDownsampleFilter_GetOutput(self)

    def GetUpDownRatio(self):
        """
        GetUpDownRatio(self) -> int

        Gets the ratio used to downsample the data.
        """
        return _btk.btkWrenchDownsampleFilter_GetUpDownRatio(self)

    def SetUpDownRatio(self, *args):
        """
        SetUpDownRatio(self, int)

        Sets the ratio used to downsample the data.
        """
        return _btk.btkWrenchDownsampleFilter_SetUpDownRatio(self, *args)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkWrenchDownsampleFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkWrenchDownsampleFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkWrenchDownsampleFilter_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkWrenchDownsampleFilter_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkWrenchDownsampleFilter_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkWrenchDownsampleFilter_GetTimestamp(self)

btkWrenchDownsampleFilter_swigregister = _btk.btkWrenchDownsampleFilter_swigregister
btkWrenchDownsampleFilter_swigregister(btkWrenchDownsampleFilter)

class btkWrenchCollectionDownsampleFilter(_object):
    """
    Downsample data stored in a collection of wrenches.

    To downsample data, you need to set the up/down sample ratio using the method SetUpDownRatio().
    The given value is an integer corresponding to the ratio used to extract only the value of interest.
    For example, if you have 200 frames and a ratio of 10, then 20 frames will be extracted (one frame each 10 frames).
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkWrenchCollectionDownsampleFilter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkWrenchCollectionDownsampleFilter, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkWrenchCollectionDownsampleFilter

        Downsample data stored in a collection of wrenches.

        To downsample data, you need to set the up/down sample ratio using the method SetUpDownRatio().
        The given value is an integer corresponding to the ratio used to extract only the value of interest.
        For example, if you have 200 frames and a ratio of 10, then 20 frames will be extracted (one frame each 10 frames).
        """
        this = _btk.new_btkWrenchCollectionDownsampleFilter()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkWrenchCollectionDownsampleFilter_impl *"""
        return _btk.btkWrenchCollectionDownsampleFilter___deref__(self)

    __swig_destroy__ = _btk.delete_btkWrenchCollectionDownsampleFilter
    __del__ = lambda self : None;
    def GetInput(self):
        """
        GetInput(self) -> btkWrenchCollection

        Gets the input registered with this process.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetInput(self)

    def SetInput(self, *args):
        """
        SetInput(self, btkWrenchCollection)

        Sets the input required with this process.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_SetInput(self, *args)

    def GetOutput(self):
        """
        GetOutput(self) -> btkWrenchCollection

        Returns the output created with this process.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetOutput(self)

    def GetUpDownRatio(self):
        """
        GetUpDownRatio(self) -> int

        Gets the ratio used to downsample the data.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetUpDownRatio(self)

    def SetUpDownRatio(self, *args):
        """
        SetUpDownRatio(self, int)

        Sets the ratio used to downsample the data.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_SetUpDownRatio(self, *args)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkWrenchCollectionDownsampleFilter_GetTimestamp(self)

btkWrenchCollectionDownsampleFilter_swigregister = _btk.btkWrenchCollectionDownsampleFilter_swigregister
btkWrenchCollectionDownsampleFilter_swigregister(btkWrenchCollectionDownsampleFilter)

class btkForcePlatformsExtractor(_object):
    """
    Based on the content of the metadata FORCE_PLATFORM and the analog channels stored in the given 
    acquisition, this filter creates a collection of btkForcePlatform returned in the output.

    Depending of the type of the force platform, the analog channels' data are transformed to take into account a calibration matrix.

    The metadata FORCE_PLATFORM must be structured as the following:
     - FORCE_PLATFORM:USED: single integer storing the number of force plates ;
     - FORCE_PLATFORM:TYPE: 1D array of integer containing the type of force plates contained in the acquisition (see below for the supported types) ;
     - FORCE_PLATFORM:CHANNEL: 2D array of integer containing of 1-based indices of the analog channels used ;
     - FORCE_PLATFORM:LABELS: 1D array of strings containing the force plates' label ;
     - FORCE_PLATFORM:DESCRIPTIONS: 1D array of strings containing the force plates' description ;
     - FORCE_PLATFORM:ORIGIN: 2D array of reals (float) containing the coordinates of the origin of the surface of each force platform expressed in their frame ;
     - FORCE_PLATFORM:CORNERS: 3D array of reals containing the coordinates of the corners. The third dimensions corresponds to the number of force platforms ;
     - FORCE_PLATFORM:CAL_MATRIX: (could be optional, depend on the FP type). 3D array containing the calibration to transform the volts into forces and moments ;
    You can have more details on each metadata by following this link: http://www.c3d.org/HTML/theforceplatformgroup.htm

    This filter is able to manage the following force platform's type:
     - Type 1: 6 channels with Forces X,Y,Z Position X,Y of the COP, and Moment Z around the COP ;
     - Type 2: 6 channels (FX, FY, FZ, MX, MY, MZ) ;
     - Type 3: 8 channels (FZ1, FZ2, FZ3, FZ4, FX12, FX34, FY14, FY23) ;
     - Type 4: Same as Type-2 + calibration matrix 6 (columns) by 6 (rows) ;
     - Type 5: Same as Type-3 + calibration matrix 6 (columns) by 8 (rows).

    However, some other types are not yet supported due to the lack of information and data on them:
     - Type 6: 12 channels (FX[1,2,3,4], FY[1,2,3,4], FZ[1,2,3,4]) + calibration matrix 12 by 12 ;
     - Type 7: 8 channels (FZ1, FZ2, FZ3, FZ4, FX12, FX34, FY14, FY23) + calibration matrix 8 by 8 ;
     - Type 11: Kistler Split Belt Treadmill: 8 channels + calibration matrix 8X8 + polynomial correction matrix 2x6 + COP translation + COP rotation ;
     - Type 12: Gaitway treadmill: 8 channels (Fz11, Fz12, Fz13, Fz14, Fz21, Fz22, Fz23, and Fz24) + calibration matrix 8X8 ;
     - Type 21: AMTI-Stairs: 2 force plates with 6 channels + a calibration matrix 6x6 + data to locate the corners of the 4 steps.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkForcePlatformsExtractor, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkForcePlatformsExtractor, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkForcePlatformsExtractor

        Based on the content of the metadata FORCE_PLATFORM and the analog channels stored in the given 
        acquisition, this filter creates a collection of btkForcePlatform returned in the output.

        Depending of the type of the force platform, the analog channels' data are transformed to take into account a calibration matrix.

        The metadata FORCE_PLATFORM must be structured as the following:
         - FORCE_PLATFORM:USED: single integer storing the number of force plates ;
         - FORCE_PLATFORM:TYPE: 1D array of integer containing the type of force plates contained in the acquisition (see below for the supported types) ;
         - FORCE_PLATFORM:CHANNEL: 2D array of integer containing of 1-based indices of the analog channels used ;
         - FORCE_PLATFORM:LABELS: 1D array of strings containing the force plates' label ;
         - FORCE_PLATFORM:DESCRIPTIONS: 1D array of strings containing the force plates' description ;
         - FORCE_PLATFORM:ORIGIN: 2D array of reals (float) containing the coordinates of the origin of the surface of each force platform expressed in their frame ;
         - FORCE_PLATFORM:CORNERS: 3D array of reals containing the coordinates of the corners. The third dimensions corresponds to the number of force platforms ;
         - FORCE_PLATFORM:CAL_MATRIX: (could be optional, depend on the FP type). 3D array containing the calibration to transform the volts into forces and moments ;
        You can have more details on each metadata by following this link: http://www.c3d.org/HTML/theforceplatformgroup.htm

        This filter is able to manage the following force platform's type:
         - Type 1: 6 channels with Forces X,Y,Z Position X,Y of the COP, and Moment Z around the COP ;
         - Type 2: 6 channels (FX, FY, FZ, MX, MY, MZ) ;
         - Type 3: 8 channels (FZ1, FZ2, FZ3, FZ4, FX12, FX34, FY14, FY23) ;
         - Type 4: Same as Type-2 + calibration matrix 6 (columns) by 6 (rows) ;
         - Type 5: Same as Type-3 + calibration matrix 6 (columns) by 8 (rows).

        However, some other types are not yet supported due to the lack of information and data on them:
         - Type 6: 12 channels (FX[1,2,3,4], FY[1,2,3,4], FZ[1,2,3,4]) + calibration matrix 12 by 12 ;
         - Type 7: 8 channels (FZ1, FZ2, FZ3, FZ4, FX12, FX34, FY14, FY23) + calibration matrix 8 by 8 ;
         - Type 11: Kistler Split Belt Treadmill: 8 channels + calibration matrix 8X8 + polynomial correction matrix 2x6 + COP translation + COP rotation ;
         - Type 12: Gaitway treadmill: 8 channels (Fz11, Fz12, Fz13, Fz14, Fz21, Fz22, Fz23, and Fz24) + calibration matrix 8X8 ;
         - Type 21: AMTI-Stairs: 2 force plates with 6 channels + a calibration matrix 6x6 + data to locate the corners of the 4 steps.
        """
        this = _btk.new_btkForcePlatformsExtractor()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkForcePlatformsExtractor_impl *"""
        return _btk.btkForcePlatformsExtractor___deref__(self)

    __swig_destroy__ = _btk.delete_btkForcePlatformsExtractor
    __del__ = lambda self : None;
    def GetInput(self):
        """
        GetInput(self) -> btkAcquisition

        Gets the input registered with this process.
        """
        return _btk.btkForcePlatformsExtractor_GetInput(self)

    def SetInput(self, *args):
        """
        SetInput(self, arg2)

        Sets the input required with this process.
        """
        return _btk.btkForcePlatformsExtractor_SetInput(self, *args)

    def GetOutput(self):
        """
        GetOutput(self) -> btkForcePlatformCollection

        Returns the output created with this process.
        """
        return _btk.btkForcePlatformsExtractor_GetOutput(self)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkForcePlatformsExtractor_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkForcePlatformsExtractor_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkForcePlatformsExtractor_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkForcePlatformsExtractor_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkForcePlatformsExtractor_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformsExtractor_GetTimestamp(self)

btkForcePlatformsExtractor_swigregister = _btk.btkForcePlatformsExtractor_swigregister
btkForcePlatformsExtractor_swigregister(btkForcePlatformsExtractor)

class btkForcePlatformWrenchFilter(_object):
    """
    Based on the given collection of forceplate set in input, this filter transform the associated analog channels in forces and moments.
    This transformation take into account the type of each force platform.

    You can use the method btkForcePlatformWrenchFilter::SetTransformToGlobalFrame() to have the wrench expressed in the frame of the force platform.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkForcePlatformWrenchFilter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkForcePlatformWrenchFilter, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkForcePlatformWrenchFilter

        Based on the given collection of forceplate set in input, this filter transform the associated analog channels in forces and moments.
        This transformation take into account the type of each force platform.

        You can use the method btkForcePlatformWrenchFilter::SetTransformToGlobalFrame() to have the wrench expressed in the frame of the force platform.
        """
        this = _btk.new_btkForcePlatformWrenchFilter()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkForcePlatformWrenchFilter_impl *"""
        return _btk.btkForcePlatformWrenchFilter___deref__(self)

    __swig_destroy__ = _btk.delete_btkForcePlatformWrenchFilter
    __del__ = lambda self : None;
    def GetInput(self):
        """
        GetInput(self) -> btkForcePlatformCollection

        Gets the input registered with this process.
        """
        return _btk.btkForcePlatformWrenchFilter_GetInput(self)

    def SetInput(self, *args):
        """
        SetInput(self, btkForcePlatform)
        SetInput(self, btkForcePlatformCollection)

        Sets the input required with this process.
        """
        return _btk.btkForcePlatformWrenchFilter_SetInput(self, *args)

    def GetOutput(self):
        """
        GetOutput(self) -> btkWrenchCollection

        Returns the output created with this process.
        """
        return _btk.btkForcePlatformWrenchFilter_GetOutput(self)

    def SetTransformToGlobalFrame(self, activation=False):
        """
        SetTransformToGlobalFrame(self, activation=False)
        SetTransformToGlobalFrame(self)

        Activate or deactivate the computation of the wrenches in the global frame.
        """
        return _btk.btkForcePlatformWrenchFilter_SetTransformToGlobalFrame(self, activation)

    def GetTransformToGlobalFrame(self):
        """
        GetTransformToGlobalFrame(self) -> bool

        Returns the state of the activation for the computation of the wrenches in the global frame.
        """
        return _btk.btkForcePlatformWrenchFilter_GetTransformToGlobalFrame(self)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkForcePlatformWrenchFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkForcePlatformWrenchFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkForcePlatformWrenchFilter_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkForcePlatformWrenchFilter_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkForcePlatformWrenchFilter_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkForcePlatformWrenchFilter_GetTimestamp(self)

btkForcePlatformWrenchFilter_swigregister = _btk.btkForcePlatformWrenchFilter_swigregister
btkForcePlatformWrenchFilter_swigregister(btkForcePlatformWrenchFilter)

class btkGroundReactionWrenchFilter(_object):
    """
    Transform force platform data into ground reaction wrenches.

    Theses wrenches are expressed in the global frame. The point of application (PWA)
    of each wrench is calculated from the paper of Shimba (1984). 
    Compared to the center of pressure (COP), the PWA take into account all the forces
    and moments (and does not assume any null forces).

    Note: For gait analysis, the COP and PWA are very similar.
    Because the computation of the PWA (as the COP) is sensitive to small (vertical) forces, the methods 
    SetThresholdValue and SetThresholdState() are provided to not compute the PWA if the vertical forces is
    the threshold. You first need to set the value and then activate the threshold method.
    By default, this threshold is not activated and the values is set to 0.

    # Example
    grwf = btk.btkGroundReactionWrenchFilter()
    grwf.SetThresholdValue(5.0); # 5 newtons
    grwf.SetThresholdState(true);

    Finally, you can also use the method btkGroundReactionWrenchFilter::SetTransformToGlobalFrame() to have the wrench expressed in the frame of the force platform.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkGroundReactionWrenchFilter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkGroundReactionWrenchFilter, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkGroundReactionWrenchFilter

        Transform force platform data into ground reaction wrenches.

        Theses wrenches are expressed in the global frame. The point of application (PWA)
        of each wrench is calculated from the paper of Shimba (1984). 
        Compared to the center of pressure (COP), the PWA take into account all the forces
        and moments (and does not assume any null forces).

        Note: For gait analysis, the COP and PWA are very similar.
        Because the computation of the PWA (as the COP) is sensitive to small (vertical) forces, the methods 
        SetThresholdValue and SetThresholdState() are provided to not compute the PWA if the vertical forces is
        the threshold. You first need to set the value and then activate the threshold method.
        By default, this threshold is not activated and the values is set to 0.

        # Example
        grwf = btk.btkGroundReactionWrenchFilter()
        grwf.SetThresholdValue(5.0); # 5 newtons
        grwf.SetThresholdState(true);

        Finally, you can also use the method btkGroundReactionWrenchFilter::SetTransformToGlobalFrame() to have the wrench expressed in the frame of the force platform.
        """
        this = _btk.new_btkGroundReactionWrenchFilter()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkGroundReactionWrenchFilter_impl *"""
        return _btk.btkGroundReactionWrenchFilter___deref__(self)

    __swig_destroy__ = _btk.delete_btkGroundReactionWrenchFilter
    __del__ = lambda self : None;
    def GetInput(self):
        """
        GetInput(self) -> btkForcePlatformCollection

        Gets the input registered with this process.
        """
        return _btk.btkGroundReactionWrenchFilter_GetInput(self)

    def SetInput(self, *args):
        """
        SetInput(self, btkForcePlatform)
        SetInput(self, btkForcePlatformCollection)

        Sets the input required with this process.
        """
        return _btk.btkGroundReactionWrenchFilter_SetInput(self, *args)

    def GetOutput(self):
        """
        GetOutput(self) -> btkWrenchCollection

        Returns the output created with this process.
        """
        return _btk.btkGroundReactionWrenchFilter_GetOutput(self)

    def SetTransformToGlobalFrame(self, activation=False):
        """
        SetTransformToGlobalFrame(self, activation=False)
        SetTransformToGlobalFrame(self)

        Activate or deactivate the computation of the wrenches in the global frame.
        """
        return _btk.btkGroundReactionWrenchFilter_SetTransformToGlobalFrame(self, activation)

    def GetTransformToGlobalFrame(self):
        """
        GetTransformToGlobalFrame(self) -> bool

        Returns the state of the activation for the computation of the wrenches in the global frame.
        """
        return _btk.btkGroundReactionWrenchFilter_GetTransformToGlobalFrame(self)

    def GetThresholdState(self):
        """
        GetThresholdState(self) -> bool

        Returns the state of the threshold used to suppress false PWA.
        """
        return _btk.btkGroundReactionWrenchFilter_GetThresholdState(self)

    def SetThresholdState(self, activated=False):
        """
        SetThresholdState(self, activated=False)
        SetThresholdState(self)

        Sets the threshold state.
        """
        return _btk.btkGroundReactionWrenchFilter_SetThresholdState(self, activated)

    def GetThresholdValue(self):
        """
        GetThresholdValue(self) -> double

        Returns the value used to suppress PWA computed with a Fz value lower or equal than it.
        """
        return _btk.btkGroundReactionWrenchFilter_GetThresholdValue(self)

    def SetThresholdValue(self, *args):
        """
        SetThresholdValue(self, double)

        Sets the threshold value.
        """
        return _btk.btkGroundReactionWrenchFilter_SetThresholdValue(self, *args)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkGroundReactionWrenchFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkGroundReactionWrenchFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkGroundReactionWrenchFilter_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkGroundReactionWrenchFilter_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkGroundReactionWrenchFilter_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkGroundReactionWrenchFilter_GetTimestamp(self)

btkGroundReactionWrenchFilter_swigregister = _btk.btkGroundReactionWrenchFilter_swigregister
btkGroundReactionWrenchFilter_swigregister(btkGroundReactionWrenchFilter)

class btkIMUsExtractor(_object):
    """
    Extracts inertial measurement units (IMUs) from a btkAcquisition object. 

    Based on the content of the metadata IMU and the analog channels stored in the given acquisition(s),
    this filter creates a collection of btkIMU returned in the output.

    The metadata IMU must be structured as the following:
     - IMU:USED: single integer storing the number of IMUs ;
     - IMU:TYPE: 1D array of integer containing the type of IMU contained in the acquisition (see below for the supported types) ;
     - IMU:CHANNEL: 2D array of integer containing of 1-based indices of the analog channels used ;
     - IMU:LABELS: 1D array of strings containing the force plates' label ;
     - IMU:DESCRIPTIONS: 1D array of strings containing the force plates' description ;

    The supported types are the following:
     - Type 1: 6D IMU with a 3D accelerometer and 3D gyroscope.

    Note: This class is still experimental and could be modified in the next release.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkIMUsExtractor, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkIMUsExtractor, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkIMUsExtractor

        Extracts inertial measurement units (IMUs) from a btkAcquisition object. 

        Based on the content of the metadata IMU and the analog channels stored in the given acquisition(s),
        this filter creates a collection of btkIMU returned in the output.

        The metadata IMU must be structured as the following:
         - IMU:USED: single integer storing the number of IMUs ;
         - IMU:TYPE: 1D array of integer containing the type of IMU contained in the acquisition (see below for the supported types) ;
         - IMU:CHANNEL: 2D array of integer containing of 1-based indices of the analog channels used ;
         - IMU:LABELS: 1D array of strings containing the force plates' label ;
         - IMU:DESCRIPTIONS: 1D array of strings containing the force plates' description ;

        The supported types are the following:
         - Type 1: 6D IMU with a 3D accelerometer and 3D gyroscope.

        Note: This class is still experimental and could be modified in the next release.
        """
        this = _btk.new_btkIMUsExtractor()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkIMUsExtractor_impl *"""
        return _btk.btkIMUsExtractor___deref__(self)

    __swig_destroy__ = _btk.delete_btkIMUsExtractor
    __del__ = lambda self : None;
    def GetInput(self, *args):
        """
        GetInput(self) -> btkAcquisition
        GetInput(self, int) -> btkAcquisition

        Gets the input registered with this process.
        """
        return _btk.btkIMUsExtractor_GetInput(self, *args)

    def SetInput(self, *args):
        """
        SetInput(self, btkAcquisition)
        SetInput(self, int, btkAcquisition)

        Sets the input required with this process.
        """
        return _btk.btkIMUsExtractor_SetInput(self, *args)

    def GetOutput(self):
        """
        GetOutput(self) -> btkIMUCollection

        Returns the output created with this process.
        """
        return _btk.btkIMUsExtractor_GetOutput(self)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkIMUsExtractor_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkIMUsExtractor_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkIMUsExtractor_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkIMUsExtractor_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkIMUsExtractor_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkIMUsExtractor_GetTimestamp(self)

btkIMUsExtractor_swigregister = _btk.btkIMUsExtractor_swigregister
btkIMUsExtractor_swigregister(btkIMUsExtractor)

class btkMergeAcquisitionFilter(_object):
    """
    Merges or concatenates two or more btkAcquisition objects into a single new one.

    The difference between the merging or the concatenating depends of the acquisitions' informations.

    If the acquisitions are exactly the same (same label for points and analog channels) and the first 
    frame of the n+1th acquisition corresponds to the last frame of the nth acquisition, then the 
    acquisitions are merged, otherwise, the data are concatenated. Merged acquisitions means that the 
    output will have the same number of points, analog channels, events than each output but the number
    of frames corresponds to the sum of the input's frame number. 

    Rules to merge/concatenate acquisitions are:
     - Must have the same acquisition frequency (or 0).
     - Must have the same number of analog samples per point frame (if there are points and analog channels).
     - Must have the same analog resolution.
     - Must have the same units (Use btkAcquisitionUnitConvert to convert them).
     - Must have the same global frame orientation (check POINT:X_SCREEN and POINT:Y_SCREEN)
     - The first input which has a non-zero acquisition frequency is used.
     - The first input which has analog channels is used to set the analog resolution of the output.

    Actions during the merging/concatenation:
     - If the first frame of the nth acquisition correspond to the last frame + 1 of the nth-1 acquisition, 
       AND the points / analog channels correspond exactly, then acquisitions are truncated.
     - If the first frame of two inputs are not the same, the final acquisition is adapted to contain the number of frames plus
       the difference between the first frame of each input.
     - If points have the same label (and the first frames doesn't correspond), then, the second and more are incremented (i.e. from Heel to Heel_2).
     - Idem for the analog channels.
     - Events with the same label, context, id and time are merged.
     - Metadata (if number of inputs greater than 1):
        - Only metadata defined by the user are inserted (i.e. POINT, ANALOG, EVENTS, etc. are not inserted as they are only used in a C3D file.).
        - If metadata are equivalent or equal, then they are merged, else the metadata is appended with a suffix
          (i.e. from STATIC_CALIBRATION:USED to STATIC_CALIBRATION:USED_2)

    Moreover, you can set a rule to keep only the data from the higher or the lower first frame.
    Use the method SetFirstFrameRule() with the values KeepAllFrames or KeepFromHighestFirstFrame.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkMergeAcquisitionFilter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkMergeAcquisitionFilter, name)
    __repr__ = _swig_repr
    KeepAllFrames = _btk.btkMergeAcquisitionFilter_KeepAllFrames
    KeepFromHighestFirstFrame = _btk.btkMergeAcquisitionFilter_KeepFromHighestFirstFrame
    def __init__(self): 
        """
        __init__(self) -> btkMergeAcquisitionFilter

        Merges or concatenates two or more btkAcquisition objects into a single new one.

        The difference between the merging or the concatenating depends of the acquisitions' informations.

        If the acquisitions are exactly the same (same label for points and analog channels) and the first 
        frame of the n+1th acquisition corresponds to the last frame of the nth acquisition, then the 
        acquisitions are merged, otherwise, the data are concatenated. Merged acquisitions means that the 
        output will have the same number of points, analog channels, events than each output but the number
        of frames corresponds to the sum of the input's frame number. 

        Rules to merge/concatenate acquisitions are:
         - Must have the same acquisition frequency (or 0).
         - Must have the same number of analog samples per point frame (if there are points and analog channels).
         - Must have the same analog resolution.
         - Must have the same units (Use btkAcquisitionUnitConvert to convert them).
         - Must have the same global frame orientation (check POINT:X_SCREEN and POINT:Y_SCREEN)
         - The first input which has a non-zero acquisition frequency is used.
         - The first input which has analog channels is used to set the analog resolution of the output.

        Actions during the merging/concatenation:
         - If the first frame of the nth acquisition correspond to the last frame + 1 of the nth-1 acquisition, 
           AND the points / analog channels correspond exactly, then acquisitions are truncated.
         - If the first frame of two inputs are not the same, the final acquisition is adapted to contain the number of frames plus
           the difference between the first frame of each input.
         - If points have the same label (and the first frames doesn't correspond), then, the second and more are incremented (i.e. from Heel to Heel_2).
         - Idem for the analog channels.
         - Events with the same label, context, id and time are merged.
         - Metadata (if number of inputs greater than 1):
            - Only metadata defined by the user are inserted (i.e. POINT, ANALOG, EVENTS, etc. are not inserted as they are only used in a C3D file.).
            - If metadata are equivalent or equal, then they are merged, else the metadata is appended with a suffix
              (i.e. from STATIC_CALIBRATION:USED to STATIC_CALIBRATION:USED_2)

        Moreover, you can set a rule to keep only the data from the higher or the lower first frame.
        Use the method SetFirstFrameRule() with the values KeepAllFrames or KeepFromHighestFirstFrame.
        """
        this = _btk.new_btkMergeAcquisitionFilter()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkMergeAcquisitionFilter_impl *"""
        return _btk.btkMergeAcquisitionFilter___deref__(self)

    __swig_destroy__ = _btk.delete_btkMergeAcquisitionFilter
    __del__ = lambda self : None;
    def GetFirstFrameRule(self):
        """
        GetFirstFrameRule(self) -> int

        Sets the rule for the first frame kept. Two rules are available:
         - KeepAllFrames: Use the lower first frame;
         - KeepFromHighestFirstFrame: Use the higher first frame.
        """
        return _btk.btkMergeAcquisitionFilter_GetFirstFrameRule(self)

    def SetFirstFrameRule(self, *args):
        """
        SetFirstFrameRule(self, int)

        Returns the rule for the first frame kept.
        """
        return _btk.btkMergeAcquisitionFilter_SetFirstFrameRule(self, *args)

    def GetInput(self, *args):
        """
        GetInput(self, int) -> btkAcquisition

        Gets the input registered with this process.
        """
        return _btk.btkMergeAcquisitionFilter_GetInput(self, *args)

    def SetInput(self, *args):
        """
        SetInput(self, int, btkAcquisition)

        Sets the input required with this process.
        """
        return _btk.btkMergeAcquisitionFilter_SetInput(self, *args)

    def GetOutput(self):
        """
        GetOutput(self) -> btkAcquisition

        Returns the output created with this process.
        """
        return _btk.btkMergeAcquisitionFilter_GetOutput(self)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkMergeAcquisitionFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkMergeAcquisitionFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkMergeAcquisitionFilter_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkMergeAcquisitionFilter_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkMergeAcquisitionFilter_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkMergeAcquisitionFilter_GetTimestamp(self)

btkMergeAcquisitionFilter_swigregister = _btk.btkMergeAcquisitionFilter_swigregister
btkMergeAcquisitionFilter_swigregister(btkMergeAcquisitionFilter)

class btkSeparateKnownVirtualMarkersFilter(_object):
    """
    Separate a collection of points in five categories to be able to distinguish real markers from the others.

    These categories are:
     - all kind of markers (real and virtual) as stored in the acquisition
     - markers
     - virtual markers used to construct refence frames
     - other virtual markers (CenterOfMass, ...)
     - other points (angle, force, moment, power, ...)

    To select the output corresponding to the chosen category, you can use the method GetOutput() 
    with one of these enum values: AllMarkers, Markers, VirtualReferenceFrames, VirtualMarkers, OtherPoints.

    By default, the list of labels known as virtual markers used for frame is:
     - HED(O|A|L|P): HEDO, HEDA, HEDL, HELP
     - LCL(O|A|L|P)
     - LFE(O|A|L|P)
     - LFO(O|A|L|P)
     - LHN(O|A|L|P)
     - LHU(O|A|L|P)
     - LRA(O|A|L|P)
     - LTI(O|A|L|P)
     - LTO(O|A|L|P)
     - PEL(O|A|L|P)
     - RCL(O|A|L|P)
     - RFE(O|A|L|P)
     - RFO(O|A|L|P)
     - RHN(O|A|L|P)
     - RHU(O|A|L|P)
     - RRA(O|A|L|P)
     - RTI(O|A|L|P)
     - RTO(O|A|L|P)
     - TRX(O|A|L|P)

    By default, the list of labels known as other virtual markers is:
     - CenterOfMass
     - CenterOfMassFloor

    You can also add a prefix for the markers' label by using the method SetLabelPrefix. This prefix will be concatenated to the markers' label during the separation.

    This filter only copies the pointer associated which each point instead of using a deep copy of it.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkSeparateKnownVirtualMarkersFilter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkSeparateKnownVirtualMarkersFilter, name)
    __repr__ = _swig_repr
    AllMarkers = _btk.btkSeparateKnownVirtualMarkersFilter_AllMarkers
    Markers = _btk.btkSeparateKnownVirtualMarkersFilter_Markers
    VirtualReferenceFrames = _btk.btkSeparateKnownVirtualMarkersFilter_VirtualReferenceFrames
    VirtualMarkers = _btk.btkSeparateKnownVirtualMarkersFilter_VirtualMarkers
    OtherPoints = _btk.btkSeparateKnownVirtualMarkersFilter_OtherPoints
    def __init__(self): 
        """
        __init__(self) -> btkSeparateKnownVirtualMarkersFilter

        Separate a collection of points in five categories to be able to distinguish real markers from the others.

        These categories are:
         - all kind of markers (real and virtual) as stored in the acquisition
         - markers
         - virtual markers used to construct refence frames
         - other virtual markers (CenterOfMass, ...)
         - other points (angle, force, moment, power, ...)

        To select the output corresponding to the chosen category, you can use the method GetOutput() 
        with one of these enum values: AllMarkers, Markers, VirtualReferenceFrames, VirtualMarkers, OtherPoints.

        By default, the list of labels known as virtual markers used for frame is:
         - HED(O|A|L|P): HEDO, HEDA, HEDL, HELP
         - LCL(O|A|L|P)
         - LFE(O|A|L|P)
         - LFO(O|A|L|P)
         - LHN(O|A|L|P)
         - LHU(O|A|L|P)
         - LRA(O|A|L|P)
         - LTI(O|A|L|P)
         - LTO(O|A|L|P)
         - PEL(O|A|L|P)
         - RCL(O|A|L|P)
         - RFE(O|A|L|P)
         - RFO(O|A|L|P)
         - RHN(O|A|L|P)
         - RHU(O|A|L|P)
         - RRA(O|A|L|P)
         - RTI(O|A|L|P)
         - RTO(O|A|L|P)
         - TRX(O|A|L|P)

        By default, the list of labels known as other virtual markers is:
         - CenterOfMass
         - CenterOfMassFloor

        You can also add a prefix for the markers' label by using the method SetLabelPrefix. This prefix will be concatenated to the markers' label during the separation.

        This filter only copies the pointer associated which each point instead of using a deep copy of it.
        """
        this = _btk.new_btkSeparateKnownVirtualMarkersFilter()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkSeparateKnownVirtualMarkersFilter_impl *"""
        return _btk.btkSeparateKnownVirtualMarkersFilter___deref__(self)

    __swig_destroy__ = _btk.delete_btkSeparateKnownVirtualMarkersFilter
    __del__ = lambda self : None;
    def AppendVirtualReferenceFrame(self, *args):
        """
        AppendVirtualReferenceFrame(self, string, string, string, string)
        AppendVirtualReferenceFrame(self, btkStringAxes)

        Append a new set of labels for a virtual frame.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_AppendVirtualReferenceFrame(self, *args)

    def AppendVirtualReferenceFrames(self, *args):
        """
        AppendKnownVirtualMarkerLabelForAxes(self, btkStringAxesList)

        Append a list of axes' definition in the category of the virtual markers used to defined frames.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_AppendVirtualReferenceFrames(self, *args)

    def SetVirtualReferenceFrames(self, *args):
        """
        SetKnownVirtualMarkerLabelsForAxes(self, btkStringAxesList)

        Sets the list of labels for the virtual markers used to create frames.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_SetVirtualReferenceFrames(self, *args)

    def GetVirtualReferenceFrames(self):
        """
        GetVirtualReferenceFrames(self) -> btkStringAxesList

        Returns the list of labels for the virtual markers used to create frame.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetVirtualReferenceFrames(self)

    def AppendVirtualMarker(self, *args):
        """
        AppendVirtualMarker(self, string)

        Append a label in the category of the other virtual markers.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_AppendVirtualMarker(self, *args)

    def AppendVirtualMarkers(self, *args):
        """
        AppendVirtualMarkers(self, btkStringList)

        Append a list of labels in the category of the other virtual markers.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_AppendVirtualMarkers(self, *args)

    def SetVirtualMarkers(self, *args):
        """
        SetKnownVirtualMarkerLabelsForOthers(self, btkStringList)

        Sets the list of labels for the virtual markers used in another context than virtual frames. Each label is checked before to be inserted to not have duplication.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_SetVirtualMarkers(self, *args)

    def GetVirtualMarkers(self):
        """
        GetVirtualMarkers(self) -> btkStringList

        Returns the list of labels for the virtual markers used in another context than virtual frames
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetVirtualMarkers(self)

    def SetLabelPrefix(self, *args):
        """
        SetLabelPrefix(self, string)

        Sets the prefix which will be concatenated to the markers' label during the separation.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_SetLabelPrefix(self, *args)

    def GetLabelPrefix(self):
        """
        GetLabelPrefix(self) -> std::string const &

        Returns the prefix which will be concatenated to the markers' label during the separation.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetLabelPrefix(self)

    def GetInput(self):
        """
        GetInput(self) -> btkPointCollection

        Gets the input registered with this process.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetInput(self)

    def SetInput(self, *args):
        """
        SetInput(self, btkAcquisition)

        Sets the input required with this process.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_SetInput(self, *args)

    def GetOutput(self, *args):
        """
        GetOutput(self, int) -> btkPointCollection

        Returns the output created with this process.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetOutput(self, *args)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkSeparateKnownVirtualMarkersFilter_GetTimestamp(self)

btkSeparateKnownVirtualMarkersFilter_swigregister = _btk.btkSeparateKnownVirtualMarkersFilter_swigregister
btkSeparateKnownVirtualMarkersFilter_swigregister(btkSeparateKnownVirtualMarkersFilter)

class btkSpecializedPointsExtractor(_object):
    """
    Extracts only the points corresponding to the given type (without cloning the extracted points).

    The type is set by the SetPointType() method. By default, if no type is set, this filter extract markers.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkSpecializedPointsExtractor, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkSpecializedPointsExtractor, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkSpecializedPointsExtractor

        Extracts only the points corresponding to the given type (without cloning the extracted points).

        The type is set by the SetPointType() method. By default, if no type is set, this filter extract markers.
        """
        this = _btk.new_btkSpecializedPointsExtractor()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkSpecializedPointsExtractor_impl *"""
        return _btk.btkSpecializedPointsExtractor___deref__(self)

    __swig_destroy__ = _btk.delete_btkSpecializedPointsExtractor
    __del__ = lambda self : None;
    def GetInput(self):
        """
        GetInput(self) -> btkAcquisition

        Gets the input registered with this process.
        """
        return _btk.btkSpecializedPointsExtractor_GetInput(self)

    def SetInput(self, *args):
        """
        SetInput(self, input)

        Sets the input required with this process.
        """
        return _btk.btkSpecializedPointsExtractor_SetInput(self, *args)

    def GetOutput(self):
        """
        GetOutput(self) -> btkPointCollection

        Returns the output created with this process.
        """
        return _btk.btkSpecializedPointsExtractor_GetOutput(self)

    def GetPointType(self):
        """
        GetPointType(self) -> btkPoint_impl::Type

        Returns the type of points to extract.
        """
        return _btk.btkSpecializedPointsExtractor_GetPointType(self)

    def SetPointType(self, *args):
        """
        SetPointType(self, btk.btkPoint.Type)

        Sets the type of points to extract.
        """
        return _btk.btkSpecializedPointsExtractor_SetPointType(self, *args)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkSpecializedPointsExtractor_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkSpecializedPointsExtractor_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkSpecializedPointsExtractor_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkSpecializedPointsExtractor_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkSpecializedPointsExtractor_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkSpecializedPointsExtractor_GetTimestamp(self)

btkSpecializedPointsExtractor_swigregister = _btk.btkSpecializedPointsExtractor_swigregister
btkSpecializedPointsExtractor_swigregister(btkSpecializedPointsExtractor)

class btkSubAcquisitionFilter(_object):
    """
    Detect heel strike and toe-off events during gait from vertical ground reaction wrench.

    To fill exactly the detected events, you need to give some extra information to this filter:
     - The value of the first frame of the acquisition where the force platform data were extracted (to be added to the detected frames' index).
     - The acquisition's frequency used by the force platform data (to calculate the time related to the event's frame).
     - The subject's label (optional).
    All these informations have to be given to the method SetAcquisitionInformation().

    To detect the heel strike and toe-off events you can set some options:
     - The threshold value used to known when an event occurred (see SetThresholdValue()).
     - The mapping between the force plates and the side (left, right, general)  of the events detected (see SetForceplateContextMapping()).
     - The region of interest where to detect the events (see SetRegionOfInterest()).

    The algorithm works as following: Based on the region of interest, the maximum is searched. 
    If the maximum is higher than the threshold set, then the frame of the value on the left side of 
    this maximum lower than the threshold is used to create a heel strike event. On the other hand, 
    the value on the right side of the maximum lower than the threshold is used to create a toe-off event.

    Note: The design of this class is not perfect as it cannot be used in a pipeline without 
    to update the part before to know some acquisition's information (first frame, sample frequency, subject's name).
    This class (or the pipeline mechanism) could be modified in a future version of BTK to make up this problem.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkSubAcquisitionFilter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkSubAcquisitionFilter, name)
    __repr__ = _swig_repr
    All = _btk.btkSubAcquisitionFilter_All
    PointsOnly = _btk.btkSubAcquisitionFilter_PointsOnly
    AnalogsOnly = _btk.btkSubAcquisitionFilter_AnalogsOnly
    EventsOnly = _btk.btkSubAcquisitionFilter_EventsOnly
    def __init__(self): 
        """
        __init__(self) -> btkSubAcquisitionFilter

        Detect heel strike and toe-off events during gait from vertical ground reaction wrench.

        To fill exactly the detected events, you need to give some extra information to this filter:
         - The value of the first frame of the acquisition where the force platform data were extracted (to be added to the detected frames' index).
         - The acquisition's frequency used by the force platform data (to calculate the time related to the event's frame).
         - The subject's label (optional).
        All these informations have to be given to the method SetAcquisitionInformation().

        To detect the heel strike and toe-off events you can set some options:
         - The threshold value used to known when an event occurred (see SetThresholdValue()).
         - The mapping between the force plates and the side (left, right, general)  of the events detected (see SetForceplateContextMapping()).
         - The region of interest where to detect the events (see SetRegionOfInterest()).

        The algorithm works as following: Based on the region of interest, the maximum is searched. 
        If the maximum is higher than the threshold set, then the frame of the value on the left side of 
        this maximum lower than the threshold is used to create a heel strike event. On the other hand, 
        the value on the right side of the maximum lower than the threshold is used to create a toe-off event.

        Note: The design of this class is not perfect as it cannot be used in a pipeline without 
        to update the part before to know some acquisition's information (first frame, sample frequency, subject's name).
        This class (or the pipeline mechanism) could be modified in a future version of BTK to make up this problem.
        """
        this = _btk.new_btkSubAcquisitionFilter()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkSubAcquisitionFilter_impl *"""
        return _btk.btkSubAcquisitionFilter___deref__(self)

    def GetExtractionOption(self, *args):
        """
        GetExtractionOption(self) -> btkSubAcquisitionFilter::ExtractionOption
        GetExtractionOption(self, ids) -> btkSubAcquisitionFilter::ExtractionOption
        """
        return _btk.btkSubAcquisitionFilter_GetExtractionOption(self, *args)

    def SetExtractionOption(self, *args):
        """
        SetExtractionOption(self, option)
        SetExtractionOption(self, option, ids)
        """
        return _btk.btkSubAcquisitionFilter_SetExtractionOption(self, *args)

    __swig_destroy__ = _btk.delete_btkSubAcquisitionFilter
    __del__ = lambda self : None;
    def SetInput(self, *args):
        """
        SetInput(self, btkAcquisition)

        Sets the input required with this process.
        """
        return _btk.btkSubAcquisitionFilter_SetInput(self, *args)

    def GetInput(self):
        """
        GetInput(self) -> btkAcquisition

        Gets the input registered with this process.
        """
        return _btk.btkSubAcquisitionFilter_GetInput(self)

    def GetOutput(self):
        """
        GetOutput(self) -> btkAcquisition

        Returns the output created with this process.
        """
        return _btk.btkSubAcquisitionFilter_GetOutput(self)

    def GetFramesIndex(self):
        """
        GetFramesIndex(self) -> int const *

        Returns the index of the frames to extract. The returned array contains two values, where the first one is the low bound while the second value is the high bound.
        The index starts from 0 and correspond to the first frame of the acquisition. By default, all the frames are extracted and boundaries are set to -1.
        """
        return _btk.btkSubAcquisitionFilter_GetFramesIndex(self)

    def SetFramesIndex(self, *args):
        """
        SetFramesIndex(self, lb=-1, ub=-1)
        SetFramesIndex(self, lb=-1)
        SetFramesIndex(self)

        Set the boundaries of the frames to extract. The default values (-1) reset the extraction to take all the frames.
        """
        return _btk.btkSubAcquisitionFilter_SetFramesIndex(self, *args)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkSubAcquisitionFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkSubAcquisitionFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkSubAcquisitionFilter_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkSubAcquisitionFilter_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkSubAcquisitionFilter_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkSubAcquisitionFilter_GetTimestamp(self)

btkSubAcquisitionFilter_swigregister = _btk.btkSubAcquisitionFilter_swigregister
btkSubAcquisitionFilter_swigregister(btkSubAcquisitionFilter)

class btkVerticalGroundReactionForceGaitEventDetector(_object):
    """Proxy of C++ btkVerticalGroundReactionForceGaitEventDetector class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkVerticalGroundReactionForceGaitEventDetector, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkVerticalGroundReactionForceGaitEventDetector, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """__init__(self) -> btkVerticalGroundReactionForceGaitEventDetector"""
        this = _btk.new_btkVerticalGroundReactionForceGaitEventDetector()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkVerticalGroundReactionForceGaitEventDetector_impl *"""
        return _btk.btkVerticalGroundReactionForceGaitEventDetector___deref__(self)

    __swig_destroy__ = _btk.delete_btkVerticalGroundReactionForceGaitEventDetector
    __del__ = lambda self : None;
    def GetInput(self):
        """
        GetInput(self) -> btkWrenchCollection

        Gets the input registered with this process.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetInput(self)

    def SetInput(self, *args):
        """
        SetInput(self, arg2)
        SetInput(self, arg2)

        Sets the input required with this process.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_SetInput(self, *args)

    def GetOutput(self):
        """
        GetOutput(self) -> btkEventCollection

        Gets the output created with this process.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetOutput(self)

    def SetThresholdValue(self, *args):
        """
        SetThresholdValue(self, arg2)

        Sets the threshold used to detect gait events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_SetThresholdValue(self, *args)

    def GetThresholdValue(self):
        """
        GetThresholdValue(self) -> int

        Returns the threshold used to detect gait events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetThresholdValue(self)

    def SetForceplateContextMapping(self, *args):
        """
        SetForceplateContextMapping(self, arg2)

        Sets the mapping between the given wrenches and the side of the detected events. If no mapping is given, then all the detected events will be set as 'General' events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_SetForceplateContextMapping(self, *args)

    def GetForceplateContextMapping(self):
        """
        GetForceplateContextMapping(self) -> btkStringArray

        Returns the mapping between the wrenches in the input and the gait events to detect.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetForceplateContextMapping(self)

    def SetRegionOfInterest(self, *args):
        """
        SetRegionOfInterest(self, lb=-1, ub=-1)
        SetRegionOfInterest(self, lb=-1)
        SetRegionOfInterest(self)

        Sets the region of interest to use to detect gait events.
        WARNING: The boundaries must be set using zero-based indices.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_SetRegionOfInterest(self, *args)

    def GetRegionOfInterest(self):
        """
        GetRegionOfInterest(self) -> int const *

        Returns the region of interest to use to detect gait events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetRegionOfInterest(self)

    def SetAcquisitionInformation(self, *args):
        """
        SetAcquisitionInformation(int& ff, double& sampleRate, string& subjectLabel)

        Set the informations required to set correctly the detected events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_SetAcquisitionInformation(self, *args)

    def GetAcquisitionInformation(self, *args):
        """
        GetAcquisitionInformation(int& ff, double& sampleRate, string& subjectLabel)

        Returns the informations required to set correctly the detected events.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetAcquisitionInformation(self, *args)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkVerticalGroundReactionForceGaitEventDetector_GetTimestamp(self)

btkVerticalGroundReactionForceGaitEventDetector_swigregister = _btk.btkVerticalGroundReactionForceGaitEventDetector_swigregister
btkVerticalGroundReactionForceGaitEventDetector_swigregister(btkVerticalGroundReactionForceGaitEventDetector)

class btkWrenchDirectionAngleFilter(_object):
    """
    Calculate the direction angle of the force vector for each wrench.

    The direction angle is projected on each plane of the global frame in this order:
     - Angle yOz: set in the X component of the output ;
     - Angle xOz: set in the Y component of the output ;
     - Angle xOy: set in the Z component of the output.

    The output angles are expressed in degrees and the range is between 0 and 360 degrees. 
    Then a shift from 360 to 0 is possible if the force turns around itself.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkWrenchDirectionAngleFilter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkWrenchDirectionAngleFilter, name)
    __repr__ = _swig_repr
    def __init__(self): 
        """
        __init__(self) -> btkWrenchDirectionAngleFilter

        Calculate the direction angle of the force vector for each wrench.

        The direction angle is projected on each plane of the global frame in this order:
         - Angle yOz: set in the X component of the output ;
         - Angle xOz: set in the Y component of the output ;
         - Angle xOy: set in the Z component of the output.

        The output angles are expressed in degrees and the range is between 0 and 360 degrees. 
        Then a shift from 360 to 0 is possible if the force turns around itself.
        """
        this = _btk.new_btkWrenchDirectionAngleFilter()
        try: self.this.append(this)
        except: self.this = this
    def __deref__(self):
        """__deref__(self) -> btkWrenchDirectionAngleFilter_impl *"""
        return _btk.btkWrenchDirectionAngleFilter___deref__(self)

    __swig_destroy__ = _btk.delete_btkWrenchDirectionAngleFilter
    __del__ = lambda self : None;
    def GetInput(self):
        """
        GetInput(self) -> btkWrenchCollection

        Gets the input registered with this process.
        """
        return _btk.btkWrenchDirectionAngleFilter_GetInput(self)

    def SetInput(self, *args):
        """
        SetInput(self, input)

        Sets the input required with this process.
        """
        return _btk.btkWrenchDirectionAngleFilter_SetInput(self, *args)

    def GetOutput(self):
        """
        GetOutput(self) -> btkPointCollection

        Returns the output created with this process.
        """
        return _btk.btkWrenchDirectionAngleFilter_GetOutput(self)

    def GetInputNumber(self):
        """
        GetInputNumber(self) -> int

        Returns the number of inputs.
        """
        return _btk.btkWrenchDirectionAngleFilter_GetInputNumber(self)

    def GetValidInputNumber(self):
        """
        GetValidInputNumber(self) -> int

        Returns the number of inputs which are valid (i.e. not null).
        """
        return _btk.btkWrenchDirectionAngleFilter_GetValidInputNumber(self)

    def GetOutputNumber(self):
        """
        GetOutputNumber(self) -> int

        Returns the number of outputs.
        """
        return _btk.btkWrenchDirectionAngleFilter_GetOutputNumber(self)

    def ResetState(self):
        """
        ResetState(self)

        Reset the state of the process. Usefull when an exception was thrown during the generation of the data.
        """
        return _btk.btkWrenchDirectionAngleFilter_ResetState(self)

    def Update(self):
        """
        Update(self)

        Update the pipeline and then all the data inside. Recursive method which
         1) determines the processes to update
         2) generate the data by using the GenerateData() method.
        """
        return _btk.btkWrenchDirectionAngleFilter_Update(self)

    def GetTimestamp(self):
        """
        GetTimestamp(self) -> unsigned long

        Returns the timestamp of the object.
        """
        return _btk.btkWrenchDirectionAngleFilter_GetTimestamp(self)

btkWrenchDirectionAngleFilter_swigregister = _btk.btkWrenchDirectionAngleFilter_swigregister
btkWrenchDirectionAngleFilter_swigregister(btkWrenchDirectionAngleFilter)

class btkStringAxes(_object):
    """
    Workaround to represent the C++ class btk::SeparateKnownVirtualMarkersFilter::StringAxes with SWIG.

    Store four labels corresponding to markers used to define a frame.
    """
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkStringAxes, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkStringAxes, name)
    __repr__ = _swig_repr
    def __init__(self, *args): 
        """
        __init__(self, o, a1, a2, a3) -> btkStringAxes

        Workaround to represent the C++ class btk::SeparateKnownVirtualMarkersFilter::StringAxes with SWIG.

        Store four labels corresponding to markers used to define a frame.
        """
        this = _btk.new_btkStringAxes(*args)
        try: self.this.append(this)
        except: self.this = this
    __swig_setmethods__["Origin"] = _btk.btkStringAxes_Origin_set
    __swig_getmethods__["Origin"] = _btk.btkStringAxes_Origin_get
    if _newclass:Origin = _swig_property(_btk.btkStringAxes_Origin_get, _btk.btkStringAxes_Origin_set)
    __swig_setmethods__["Axis1"] = _btk.btkStringAxes_Axis1_set
    __swig_getmethods__["Axis1"] = _btk.btkStringAxes_Axis1_get
    if _newclass:Axis1 = _swig_property(_btk.btkStringAxes_Axis1_get, _btk.btkStringAxes_Axis1_set)
    __swig_setmethods__["Axis2"] = _btk.btkStringAxes_Axis2_set
    __swig_getmethods__["Axis2"] = _btk.btkStringAxes_Axis2_get
    if _newclass:Axis2 = _swig_property(_btk.btkStringAxes_Axis2_get, _btk.btkStringAxes_Axis2_set)
    __swig_setmethods__["Axis3"] = _btk.btkStringAxes_Axis3_set
    __swig_getmethods__["Axis3"] = _btk.btkStringAxes_Axis3_get
    if _newclass:Axis3 = _swig_property(_btk.btkStringAxes_Axis3_get, _btk.btkStringAxes_Axis3_set)
    __swig_destroy__ = _btk.delete_btkStringAxes
    __del__ = lambda self : None;
btkStringAxes_swigregister = _btk.btkStringAxes_swigregister
btkStringAxes_swigregister(btkStringAxes)

class btkStringAxesList(_object):
    """Proxy of C++ std::list<(btkStringAxes)> class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkStringAxesList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkStringAxesList, name)
    __repr__ = _swig_repr
    def iterator(self):
        """iterator(self) -> SwigPyIterator"""
        return _btk.btkStringAxesList_iterator(self)

    def __iter__(self): return self.iterator()
    def __nonzero__(self):
        """__nonzero__(self) -> bool"""
        return _btk.btkStringAxesList___nonzero__(self)

    def __bool__(self):
        """__bool__(self) -> bool"""
        return _btk.btkStringAxesList___bool__(self)

    def __len__(self):
        """__len__(self) -> std::list< btkStringAxes >::size_type"""
        return _btk.btkStringAxesList___len__(self)

    def pop(self):
        """pop(self) -> btkStringAxes"""
        return _btk.btkStringAxesList_pop(self)

    def __getslice__(self, *args):
        """__getslice__(self, i, j) -> btkStringAxesList"""
        return _btk.btkStringAxesList___getslice__(self, *args)

    def __setslice__(self, *args):
        """
        __setslice__(self, i, j, v=std::list< btkStringAxes,std::allocator< btkStringAxes > >())
        __setslice__(self, i, j)
        """
        return _btk.btkStringAxesList___setslice__(self, *args)

    def __delslice__(self, *args):
        """__delslice__(self, i, j)"""
        return _btk.btkStringAxesList___delslice__(self, *args)

    def __delitem__(self, *args):
        """
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _btk.btkStringAxesList___delitem__(self, *args)

    def __getitem__(self, *args):
        """
        __getitem__(self, slice) -> btkStringAxesList
        __getitem__(self, i) -> btkStringAxes
        """
        return _btk.btkStringAxesList___getitem__(self, *args)

    def __setitem__(self, *args):
        """
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _btk.btkStringAxesList___setitem__(self, *args)

    def append(self, *args):
        """append(self, x)"""
        return _btk.btkStringAxesList_append(self, *args)

    def empty(self):
        """empty(self) -> bool"""
        return _btk.btkStringAxesList_empty(self)

    def size(self):
        """size(self) -> std::list< btkStringAxes >::size_type"""
        return _btk.btkStringAxesList_size(self)

    def clear(self):
        """clear(self)"""
        return _btk.btkStringAxesList_clear(self)

    def swap(self, *args):
        """swap(self, v)"""
        return _btk.btkStringAxesList_swap(self, *args)

    def get_allocator(self):
        """get_allocator(self) -> std::list< btkStringAxes >::allocator_type"""
        return _btk.btkStringAxesList_get_allocator(self)

    def begin(self):
        """begin(self) -> std::list< btkStringAxes >::iterator"""
        return _btk.btkStringAxesList_begin(self)

    def end(self):
        """end(self) -> std::list< btkStringAxes >::iterator"""
        return _btk.btkStringAxesList_end(self)

    def rbegin(self):
        """rbegin(self) -> std::list< btkStringAxes >::reverse_iterator"""
        return _btk.btkStringAxesList_rbegin(self)

    def rend(self):
        """rend(self) -> std::list< btkStringAxes >::reverse_iterator"""
        return _btk.btkStringAxesList_rend(self)

    def pop_back(self):
        """pop_back(self)"""
        return _btk.btkStringAxesList_pop_back(self)

    def erase(self, *args):
        """
        erase(self, pos) -> std::list< btkStringAxes >::iterator
        erase(self, first, last) -> std::list< btkStringAxes >::iterator
        """
        return _btk.btkStringAxesList_erase(self, *args)

    def __init__(self, *args): 
        """
        __init__(self) -> btkStringAxesList
        __init__(self, arg2) -> btkStringAxesList
        __init__(self, size) -> btkStringAxesList
        __init__(self, size, value) -> btkStringAxesList
        """
        this = _btk.new_btkStringAxesList(*args)
        try: self.this.append(this)
        except: self.this = this
    def push_back(self, *args):
        """push_back(self, x)"""
        return _btk.btkStringAxesList_push_back(self, *args)

    def front(self):
        """front(self) -> btkStringAxes"""
        return _btk.btkStringAxesList_front(self)

    def back(self):
        """back(self) -> btkStringAxes"""
        return _btk.btkStringAxesList_back(self)

    def assign(self, *args):
        """assign(self, n, x)"""
        return _btk.btkStringAxesList_assign(self, *args)

    def resize(self, *args):
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _btk.btkStringAxesList_resize(self, *args)

    def insert(self, *args):
        """
        insert(self, pos, x) -> std::list< btkStringAxes >::iterator
        insert(self, pos, n, x)
        """
        return _btk.btkStringAxesList_insert(self, *args)

    def pop_front(self):
        """pop_front(self)"""
        return _btk.btkStringAxesList_pop_front(self)

    def push_front(self, *args):
        """push_front(self, x)"""
        return _btk.btkStringAxesList_push_front(self, *args)

    def reverse(self):
        """reverse(self)"""
        return _btk.btkStringAxesList_reverse(self)

    __swig_destroy__ = _btk.delete_btkStringAxesList
    __del__ = lambda self : None;
btkStringAxesList_swigregister = _btk.btkStringAxesList_swigregister
btkStringAxesList_swigregister(btkStringAxesList)

class btkStringList(_object):
    """Proxy of C++ std::list<(std::string)> class"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, btkStringList, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, btkStringList, name)
    __repr__ = _swig_repr
    def iterator(self):
        """iterator(self) -> SwigPyIterator"""
        return _btk.btkStringList_iterator(self)

    def __iter__(self): return self.iterator()
    def __nonzero__(self):
        """__nonzero__(self) -> bool"""
        return _btk.btkStringList___nonzero__(self)

    def __bool__(self):
        """__bool__(self) -> bool"""
        return _btk.btkStringList___bool__(self)

    def __len__(self):
        """__len__(self) -> std::list< std::string >::size_type"""
        return _btk.btkStringList___len__(self)

    def pop(self):
        """pop(self) -> std::list< std::string >::value_type"""
        return _btk.btkStringList_pop(self)

    def __getslice__(self, *args):
        """__getslice__(self, i, j) -> btkStringList"""
        return _btk.btkStringList___getslice__(self, *args)

    def __setslice__(self, *args):
        """
        __setslice__(self, i, j, v=std::list< std::string,std::allocator< std::string > >())
        __setslice__(self, i, j)
        """
        return _btk.btkStringList___setslice__(self, *args)

    def __delslice__(self, *args):
        """__delslice__(self, i, j)"""
        return _btk.btkStringList___delslice__(self, *args)

    def __delitem__(self, *args):
        """
        __delitem__(self, i)
        __delitem__(self, slice)
        """
        return _btk.btkStringList___delitem__(self, *args)

    def __getitem__(self, *args):
        """
        __getitem__(self, slice) -> btkStringList
        __getitem__(self, i) -> std::list< std::string >::value_type const &
        """
        return _btk.btkStringList___getitem__(self, *args)

    def __setitem__(self, *args):
        """
        __setitem__(self, slice, v)
        __setitem__(self, slice)
        __setitem__(self, i, x)
        """
        return _btk.btkStringList___setitem__(self, *args)

    def append(self, *args):
        """append(self, x)"""
        return _btk.btkStringList_append(self, *args)

    def empty(self):
        """empty(self) -> bool"""
        return _btk.btkStringList_empty(self)

    def size(self):
        """size(self) -> std::list< std::string >::size_type"""
        return _btk.btkStringList_size(self)

    def clear(self):
        """clear(self)"""
        return _btk.btkStringList_clear(self)

    def swap(self, *args):
        """swap(self, v)"""
        return _btk.btkStringList_swap(self, *args)

    def get_allocator(self):
        """get_allocator(self) -> std::list< std::string >::allocator_type"""
        return _btk.btkStringList_get_allocator(self)

    def begin(self):
        """begin(self) -> std::list< std::string >::iterator"""
        return _btk.btkStringList_begin(self)

    def end(self):
        """end(self) -> std::list< std::string >::iterator"""
        return _btk.btkStringList_end(self)

    def rbegin(self):
        """rbegin(self) -> std::list< std::string >::reverse_iterator"""
        return _btk.btkStringList_rbegin(self)

    def rend(self):
        """rend(self) -> std::list< std::string >::reverse_iterator"""
        return _btk.btkStringList_rend(self)

    def pop_back(self):
        """pop_back(self)"""
        return _btk.btkStringList_pop_back(self)

    def erase(self, *args):
        """
        erase(self, pos) -> std::list< std::string >::iterator
        erase(self, first, last) -> std::list< std::string >::iterator
        """
        return _btk.btkStringList_erase(self, *args)

    def __init__(self, *args): 
        """
        __init__(self) -> btkStringList
        __init__(self, arg2) -> btkStringList
        __init__(self, size) -> btkStringList
        __init__(self, size, value) -> btkStringList
        """
        this = _btk.new_btkStringList(*args)
        try: self.this.append(this)
        except: self.this = this
    def push_back(self, *args):
        """push_back(self, x)"""
        return _btk.btkStringList_push_back(self, *args)

    def front(self):
        """front(self) -> std::list< std::string >::value_type const &"""
        return _btk.btkStringList_front(self)

    def back(self):
        """back(self) -> std::list< std::string >::value_type const &"""
        return _btk.btkStringList_back(self)

    def assign(self, *args):
        """assign(self, n, x)"""
        return _btk.btkStringList_assign(self, *args)

    def resize(self, *args):
        """
        resize(self, new_size)
        resize(self, new_size, x)
        """
        return _btk.btkStringList_resize(self, *args)

    def insert(self, *args):
        """
        insert(self, pos, x) -> std::list< std::string >::iterator
        insert(self, pos, n, x)
        """
        return _btk.btkStringList_insert(self, *args)

    def pop_front(self):
        """pop_front(self)"""
        return _btk.btkStringList_pop_front(self)

    def push_front(self, *args):
        """push_front(self, x)"""
        return _btk.btkStringList_push_front(self, *args)

    def reverse(self):
        """reverse(self)"""
        return _btk.btkStringList_reverse(self)

    __swig_destroy__ = _btk.delete_btkStringList
    __del__ = lambda self : None;
btkStringList_swigregister = _btk.btkStringList_swigregister
btkStringList_swigregister(btkStringList)

# This file is compatible with both classic and new-style classes.


