# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
"""
This file contains the exact signatures for all functions in module
PySide6.QtCore, except for defaults which are replaced by "...".
"""

# mypy: disable-error-code="override, overload-overlap"
# Module `PySide6.QtCore`

import PySide6.QtCore

import os
import enum
import typing
import collections.abc
from shiboken6 import Shiboken


PlaceholderType = typing.TypeVar("PlaceholderType", bound=PySide6.QtCore.QObject)


class ClassInfo:

    def __init__(self, /, **info: typing.Dict[str, str]) -> None: ...


class MetaFunction:
    def __call__(self, /, *args: typing.Any) -> typing.Any: ...


class MetaSignal(type):
    def __instancecheck__(self, object: object, /) -> bool: ...


class Property:

    def __init__(self, type: type, /, fget: collections.abc.Callable[[typing.Any], typing.Any] | None = ..., fset: collections.abc.Callable[[typing.Any, typing.Any], None] | None = ..., freset: collections.abc.Callable[[typing.Any, typing.Any], None] | None = ..., doc: str | None = ..., notify: PySide6.QtCore.Signal | None = ..., designable: bool = ..., scriptable: bool = ..., stored: bool = ..., user: bool = ..., constant: bool = ..., final: bool = ...) -> None: ...

    def __call__(self, func: collections.abc.Callable[..., typing.Any], /) -> PySide6.QtCore.Property: ...
    def deleter(self, fdel: collections.abc.Callable[[typing.Any], None], /) -> PySide6.QtCore.Property: ...
    def getter(self, fget: collections.abc.Callable[[typing.Any], typing.Any], /) -> PySide6.QtCore.Property: ...
    def read(self, fget: collections.abc.Callable[[typing.Any], typing.Any], /) -> PySide6.QtCore.Property: ...
    def setter(self, fset: collections.abc.Callable[[typing.Any, typing.Any], None], /) -> PySide6.QtCore.Property: ...
    def write(self, fset: collections.abc.Callable[[typing.Any, typing.Any], None], /) -> PySide6.QtCore.Property: ...


class PyClassProperty(property):

    @classmethod
    def __init__(cls, /, fget: collections.abc.Callable[[typing.Any], typing.Any] | None = ..., fset: collections.abc.Callable[[typing.Any, typing.Any], None] | None = ..., fdel: collections.abc.Callable[[typing.Any], None] | None = ..., doc: str | None = ...) -> None: ...


class QAbstractAnimation(PySide6.QtCore.QObject):

    currentLoopChanged       : typing.ClassVar[Signal] = ... # currentLoopChanged(int)
    directionChanged         : typing.ClassVar[Signal] = ... # directionChanged(QAbstractAnimation::Direction)
    finished                 : typing.ClassVar[Signal] = ... # finished()
    stateChanged             : typing.ClassVar[Signal] = ... # stateChanged(QAbstractAnimation::State,QAbstractAnimation::State)

    class DeletionPolicy(enum.Enum):

        KeepWhenStopped           = 0x0
        DeleteWhenStopped         = 0x1

    class Direction(enum.Enum):

        Forward                   = 0x0
        Backward                  = 0x1

    class State(enum.Enum):

        Stopped                   = 0x0
        Paused                    = 0x1
        Running                   = 0x2


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, state: PySide6.QtCore.QAbstractAnimation.State | None = ..., loopCount: int | None = ..., currentTime: int | None = ..., currentLoop: int | None = ..., direction: PySide6.QtCore.QAbstractAnimation.Direction | None = ..., duration: int | None = ...) -> None: ...

    def currentLoop(self, /) -> int: ...
    def currentLoopTime(self, /) -> int: ...
    def currentTime(self, /) -> int: ...
    def direction(self, /) -> PySide6.QtCore.QAbstractAnimation.Direction: ...
    def duration(self, /) -> int: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def group(self, /) -> PySide6.QtCore.QAnimationGroup: ...
    def loopCount(self, /) -> int: ...
    def pause(self, /) -> None: ...
    def resume(self, /) -> None: ...
    def setCurrentTime(self, msecs: int, /) -> None: ...
    def setDirection(self, direction: PySide6.QtCore.QAbstractAnimation.Direction, /) -> None: ...
    def setLoopCount(self, loopCount: int, /) -> None: ...
    def setPaused(self, arg__1: bool, /) -> None: ...
    def start(self, /, policy: PySide6.QtCore.QAbstractAnimation.DeletionPolicy = ...) -> None: ...
    def state(self, /) -> PySide6.QtCore.QAbstractAnimation.State: ...
    def stop(self, /) -> None: ...
    def totalDuration(self, /) -> int: ...
    def updateCurrentTime(self, currentTime: int, /) -> None: ...
    def updateDirection(self, direction: PySide6.QtCore.QAbstractAnimation.Direction, /) -> None: ...
    def updateState(self, newState: PySide6.QtCore.QAbstractAnimation.State, oldState: PySide6.QtCore.QAbstractAnimation.State, /) -> None: ...


class QAbstractEventDispatcher(PySide6.QtCore.QObject):

    aboutToBlock             : typing.ClassVar[Signal] = ... # aboutToBlock()
    awake                    : typing.ClassVar[Signal] = ... # awake()

    class TimerInfo(Shiboken.Object):

        @typing.overload
        def __init__(self, TimerInfo: PySide6.QtCore.QAbstractEventDispatcher.TimerInfo, /) -> None: ...
        @typing.overload
        def __init__(self, id: int, i: int, t: PySide6.QtCore.Qt.TimerType, /) -> None: ...

        def __copy__(self, /) -> typing.Self: ...


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def closingDown(self, /) -> None: ...
    def filterNativeEvent(self, eventType: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, message: int, /) -> typing.Tuple[bool, int]: ...
    def installNativeEventFilter(self, filterObj: PySide6.QtCore.QAbstractNativeEventFilter, /) -> None: ...
    @staticmethod
    def instance(thread: PySide6.QtCore.QThread | None = ...) -> PySide6.QtCore.QAbstractEventDispatcher: ...
    def interrupt(self, /) -> None: ...
    def processEvents(self, flags: PySide6.QtCore.QEventLoop.ProcessEventsFlag, /) -> bool: ...
    def registerSocketNotifier(self, notifier: PySide6.QtCore.QSocketNotifier, /) -> None: ...
    @typing.overload
    def registerTimer(self, interval: int, timerType: PySide6.QtCore.Qt.TimerType, object: PySide6.QtCore.QObject, /) -> int: ...
    @typing.overload
    def registerTimer(self, timerId: int, interval: int, timerType: PySide6.QtCore.Qt.TimerType, object: PySide6.QtCore.QObject, /) -> None: ...
    def registeredTimers(self, object: PySide6.QtCore.QObject, /) -> typing.List[PySide6.QtCore.QAbstractEventDispatcher.TimerInfo]: ...
    def remainingTime(self, timerId: int, /) -> int: ...
    def removeNativeEventFilter(self, filterObj: PySide6.QtCore.QAbstractNativeEventFilter, /) -> None: ...
    def startingUp(self, /) -> None: ...
    def unregisterSocketNotifier(self, notifier: PySide6.QtCore.QSocketNotifier, /) -> None: ...
    @typing.overload
    def unregisterTimer(self, timerId: PySide6.QtCore.Qt.TimerId, /) -> bool: ...
    @typing.overload
    def unregisterTimer(self, timerId: int, /) -> bool: ...
    def unregisterTimers(self, object: PySide6.QtCore.QObject, /) -> bool: ...
    def wakeUp(self, /) -> None: ...


class QAbstractItemModel(PySide6.QtCore.QObject):

    columnsAboutToBeInserted : typing.ClassVar[Signal] = ... # columnsAboutToBeInserted(QModelIndex,int,int)
    columnsAboutToBeMoved    : typing.ClassVar[Signal] = ... # columnsAboutToBeMoved(QModelIndex,int,int,QModelIndex,int)
    columnsAboutToBeRemoved  : typing.ClassVar[Signal] = ... # columnsAboutToBeRemoved(QModelIndex,int,int)
    columnsInserted          : typing.ClassVar[Signal] = ... # columnsInserted(QModelIndex,int,int)
    columnsMoved             : typing.ClassVar[Signal] = ... # columnsMoved(QModelIndex,int,int,QModelIndex,int)
    columnsRemoved           : typing.ClassVar[Signal] = ... # columnsRemoved(QModelIndex,int,int)
    dataChanged              : typing.ClassVar[Signal] = ... # dataChanged(QModelIndex,QModelIndex,QList<int>); dataChanged(QModelIndex,QModelIndex)
    headerDataChanged        : typing.ClassVar[Signal] = ... # headerDataChanged(Qt::Orientation,int,int)
    layoutAboutToBeChanged   : typing.ClassVar[Signal] = ... # layoutAboutToBeChanged(); layoutAboutToBeChanged(QList<QPersistentModelIndex>,QAbstractItemModel::LayoutChangeHint); layoutAboutToBeChanged(QList<QPersistentModelIndex>)
    layoutChanged            : typing.ClassVar[Signal] = ... # layoutChanged(); layoutChanged(QList<QPersistentModelIndex>,QAbstractItemModel::LayoutChangeHint); layoutChanged(QList<QPersistentModelIndex>)
    modelAboutToBeReset      : typing.ClassVar[Signal] = ... # modelAboutToBeReset()
    modelReset               : typing.ClassVar[Signal] = ... # modelReset()
    rowsAboutToBeInserted    : typing.ClassVar[Signal] = ... # rowsAboutToBeInserted(QModelIndex,int,int)
    rowsAboutToBeMoved       : typing.ClassVar[Signal] = ... # rowsAboutToBeMoved(QModelIndex,int,int,QModelIndex,int)
    rowsAboutToBeRemoved     : typing.ClassVar[Signal] = ... # rowsAboutToBeRemoved(QModelIndex,int,int)
    rowsInserted             : typing.ClassVar[Signal] = ... # rowsInserted(QModelIndex,int,int)
    rowsMoved                : typing.ClassVar[Signal] = ... # rowsMoved(QModelIndex,int,int,QModelIndex,int)
    rowsRemoved              : typing.ClassVar[Signal] = ... # rowsRemoved(QModelIndex,int,int)

    class CheckIndexOption(enum.Flag):

        NoOption                  = 0x0
        IndexIsValid              = 0x1
        DoNotUseParent            = 0x2
        ParentIsInvalid           = 0x4

    class LayoutChangeHint(enum.Enum):

        NoLayoutChangeHint        = 0x0
        VerticalSortHint          = 0x1
        HorizontalSortHint        = 0x2


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def beginInsertColumns(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, first: int, last: int, /) -> None: ...
    def beginInsertRows(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, first: int, last: int, /) -> None: ...
    def beginMoveColumns(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceFirst: int, sourceLast: int, destinationParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destinationColumn: int, /) -> bool: ...
    def beginMoveRows(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceFirst: int, sourceLast: int, destinationParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destinationRow: int, /) -> bool: ...
    def beginRemoveColumns(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, first: int, last: int, /) -> None: ...
    def beginRemoveRows(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, first: int, last: int, /) -> None: ...
    def beginResetModel(self, /) -> None: ...
    def buddy(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def canDropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def canFetchMore(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def changePersistentIndex(self, from_: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, to: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def changePersistentIndexList(self, from_: collections.abc.Sequence[PySide6.QtCore.QModelIndex], to: collections.abc.Sequence[PySide6.QtCore.QModelIndex], /) -> None: ...
    def checkIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, options: PySide6.QtCore.QAbstractItemModel.CheckIndexOption = ...) -> bool: ...
    def clearItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def columnCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    @typing.overload
    def createIndex(self, row: int, column: int, /, id: int | None = ...) -> PySide6.QtCore.QModelIndex: ...
    @typing.overload
    def createIndex(self, row: int, column: int, ptr: object, /) -> PySide6.QtCore.QModelIndex: ...
    def data(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, role: int = ...) -> typing.Any: ...
    def decodeData(self, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, stream: PySide6.QtCore.QDataStream, /) -> bool: ...
    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def encodeData(self, indexes: collections.abc.Sequence[PySide6.QtCore.QModelIndex], stream: PySide6.QtCore.QDataStream, /) -> None: ...
    def endInsertColumns(self, /) -> None: ...
    def endInsertRows(self, /) -> None: ...
    def endMoveColumns(self, /) -> None: ...
    def endMoveRows(self, /) -> None: ...
    def endRemoveColumns(self, /) -> None: ...
    def endRemoveRows(self, /) -> None: ...
    def endResetModel(self, /) -> None: ...
    def fetchMore(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def flags(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def hasChildren(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def hasIndex(self, row: int, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, /, role: int = ...) -> typing.Any: ...
    def index(self, row: int, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> PySide6.QtCore.QModelIndex: ...
    def insertColumn(self, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def insertColumns(self, column: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def insertRow(self, row: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def insertRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def itemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> typing.Dict[int, typing.Any]: ...
    def match(self, start: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, role: int, value: typing.Any, /, hits: int = ..., flags: PySide6.QtCore.Qt.MatchFlag = ...) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def mimeData(self, indexes: collections.abc.Sequence[PySide6.QtCore.QModelIndex], /) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self, /) -> typing.List[str]: ...
    def moveColumn(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceColumn: int, destinationParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destinationChild: int, /) -> bool: ...
    def moveColumns(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceColumn: int, count: int, destinationParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destinationChild: int, /) -> bool: ...
    def moveRow(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceRow: int, destinationParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destinationChild: int, /) -> bool: ...
    def moveRows(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceRow: int, count: int, destinationParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destinationChild: int, /) -> bool: ...
    def multiData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, roleDataSpan: PySide6.QtCore.QModelRoleDataSpan | PySide6.QtCore.QModelRoleData, /) -> None: ...
    @typing.overload
    def parent(self, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def persistentIndexList(self, /) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def removeColumn(self, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def removeColumns(self, column: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def removeRow(self, row: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def removeRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def resetInternalData(self, /) -> None: ...
    def revert(self, /) -> None: ...
    def roleNames(self, /) -> typing.Dict[int, PySide6.QtCore.QByteArray]: ...
    def rowCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def setData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, value: typing.Any, /, role: int = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, value: typing.Any, /, role: int = ...) -> bool: ...
    def setItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, roles: typing.Dict[int, typing.Any], /) -> bool: ...
    def sibling(self, row: int, column: int, idx: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def sort(self, column: int, /, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def span(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QSize: ...
    def submit(self, /) -> bool: ...
    def supportedDragActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...
    def supportedDropActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...


class QAbstractListModel(PySide6.QtCore.QAbstractItemModel):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def columnCount(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> int: ...
    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def flags(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def hasChildren(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def index(self, row: int, /, column: int | None = ..., parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> PySide6.QtCore.QModelIndex: ...
    @typing.overload
    def parent(self, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def sibling(self, row: int, column: int, idx: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...


class QAbstractNativeEventFilter(Shiboken.Object):

    def __init__(self, /) -> None: ...

    def nativeEventFilter(self, eventType: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, message: int, /) -> object: ...


class QAbstractProxyModel(PySide6.QtCore.QAbstractItemModel):

    sourceModelChanged       : typing.ClassVar[Signal] = ... # sourceModelChanged()

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, sourceModel: PySide6.QtCore.QAbstractItemModel | None = ...) -> None: ...

    def buddy(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def canDropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def canFetchMore(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def clearItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def createSourceIndex(self, row: int, col: int, internalPtr: int, /) -> PySide6.QtCore.QModelIndex: ...
    def data(self, proxyIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def fetchMore(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def flags(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def hasChildren(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, /, role: int = ...) -> typing.Any: ...
    def itemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> typing.Dict[int, typing.Any]: ...
    def mapFromSource(self, sourceIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def mapSelectionFromSource(self, selection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtCore.QItemSelection: ...
    def mapSelectionToSource(self, selection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtCore.QItemSelection: ...
    def mapToSource(self, proxyIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def mimeData(self, indexes: collections.abc.Sequence[PySide6.QtCore.QModelIndex], /) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self, /) -> typing.List[str]: ...
    def revert(self, /) -> None: ...
    def roleNames(self, /) -> typing.Dict[int, PySide6.QtCore.QByteArray]: ...
    def setData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, value: typing.Any, /, role: int = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, value: typing.Any, /, role: int = ...) -> bool: ...
    def setItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, roles: typing.Dict[int, typing.Any], /) -> bool: ...
    def setSourceModel(self, sourceModel: PySide6.QtCore.QAbstractItemModel, /) -> None: ...
    def sibling(self, row: int, column: int, idx: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def sort(self, column: int, /, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def sourceModel(self, /) -> PySide6.QtCore.QAbstractItemModel: ...
    def span(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QSize: ...
    def submit(self, /) -> bool: ...
    def supportedDragActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...
    def supportedDropActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...


class QAbstractTableModel(PySide6.QtCore.QAbstractItemModel):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def flags(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def hasChildren(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def index(self, row: int, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> PySide6.QtCore.QModelIndex: ...
    @typing.overload
    def parent(self, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def sibling(self, row: int, column: int, idx: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...


class QAnimationGroup(PySide6.QtCore.QAbstractAnimation):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def addAnimation(self, animation: PySide6.QtCore.QAbstractAnimation, /) -> None: ...
    def animationAt(self, index: int, /) -> PySide6.QtCore.QAbstractAnimation: ...
    def animationCount(self, /) -> int: ...
    def clear(self, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def indexOfAnimation(self, animation: PySide6.QtCore.QAbstractAnimation, /) -> int: ...
    def insertAnimation(self, index: int, animation: PySide6.QtCore.QAbstractAnimation, /) -> None: ...
    def removeAnimation(self, animation: PySide6.QtCore.QAbstractAnimation, /) -> None: ...
    def takeAnimation(self, index: int, /) -> PySide6.QtCore.QAbstractAnimation: ...


class QBasicMutex(Shiboken.Object):

    def __init__(self, /) -> None: ...

    def lock(self, /) -> None: ...
    def tryLock(self, /) -> bool: ...
    def try_lock(self, /) -> bool: ...
    def unlock(self, /) -> None: ...


class QBasicTimer(Shiboken.Object):

    def __init__(self, /) -> None: ...

    def id(self, /) -> PySide6.QtCore.Qt.TimerId: ...
    def isActive(self, /) -> bool: ...
    @typing.overload
    def start(self, msec: int, obj: PySide6.QtCore.QObject, /) -> None: ...
    @typing.overload
    def start(self, msec: int, timerType: PySide6.QtCore.Qt.TimerType, obj: PySide6.QtCore.QObject, /) -> None: ...
    def stop(self, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QBasicTimer, /) -> None: ...
    def timerId(self, /) -> int: ...


class QBitArray(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QBitArray, /) -> None: ...
    @typing.overload
    def __init__(self, size: int, /, val: bool = ...) -> None: ...

    def __and__(self, a2: PySide6.QtCore.QBitArray | int, /) -> PySide6.QtCore.QBitArray: ...
    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QBitArray | int, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __iand__(self, arg__1: PySide6.QtCore.QBitArray | int, /) -> PySide6.QtCore.QBitArray: ...
    def __invert__(self, /) -> PySide6.QtCore.QBitArray: ...
    def __ior__(self, arg__1: PySide6.QtCore.QBitArray | int, /) -> PySide6.QtCore.QBitArray: ...
    def __ixor__(self, arg__1: PySide6.QtCore.QBitArray | int, /) -> PySide6.QtCore.QBitArray: ...
    def __ne__(self, rhs: PySide6.QtCore.QBitArray | int, /) -> bool: ...
    def __or__(self, a2: PySide6.QtCore.QBitArray | int, /) -> PySide6.QtCore.QBitArray: ...
    def __repr__(self, /) -> str: ...
    def __xor__(self, a2: PySide6.QtCore.QBitArray | int, /) -> PySide6.QtCore.QBitArray: ...
    def at(self, i: int, /) -> bool: ...
    def bits(self, /) -> bytes | bytearray | memoryview: ...
    def clear(self, /) -> None: ...
    def clearBit(self, i: int, /) -> None: ...
    @typing.overload
    def count(self, /) -> int: ...
    @typing.overload
    def count(self, on: bool, /) -> int: ...
    @typing.overload
    def fill(self, aval: bool, /, asize: int = ...) -> bool: ...
    @typing.overload
    def fill(self, val: bool, first: int, last: int, /) -> None: ...
    @staticmethod
    def fromBits(data: bytes | bytearray | memoryview, len: int, /) -> PySide6.QtCore.QBitArray: ...
    def isEmpty(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def resize(self, size: int, /) -> None: ...
    @typing.overload
    def setBit(self, i: int, /) -> None: ...
    @typing.overload
    def setBit(self, i: int, val: bool, /) -> None: ...
    def size(self, /) -> int: ...
    def swap(self, other: PySide6.QtCore.QBitArray | int, /) -> None: ...
    def testBit(self, i: int, /) -> bool: ...
    def toUInt32(self, endianness: PySide6.QtCore.QSysInfo.Endian, /) -> typing.Tuple[int, bool]: ...
    def toggleBit(self, i: int, /) -> bool: ...
    def truncate(self, pos: int, /) -> None: ...


class QBluetoothPermission(Shiboken.Object):

    class CommunicationMode(enum.Flag):

        Access                    = 0x1
        Advertise                 = 0x2
        Default                   = 0x3


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QBluetoothPermission, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def communicationModes(self, /) -> PySide6.QtCore.QBluetoothPermission.CommunicationMode: ...
    def setCommunicationModes(self, modes: PySide6.QtCore.QBluetoothPermission.CommunicationMode, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QBluetoothPermission, /) -> None: ...


class QBuffer(PySide6.QtCore.QIODevice):

    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, buf: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def atEnd(self, /) -> bool: ...
    def buffer(self, /) -> PySide6.QtCore.QByteArray: ...
    def canReadLine(self, /) -> bool: ...
    def close(self, /) -> None: ...
    def connectNotify(self, arg__1: PySide6.QtCore.QMetaMethod, /) -> None: ...
    def data(self, /) -> PySide6.QtCore.QByteArray: ...
    def disconnectNotify(self, arg__1: PySide6.QtCore.QMetaMethod, /) -> None: ...
    def open(self, openMode: PySide6.QtCore.QIODeviceBase.OpenModeFlag, /) -> bool: ...
    def pos(self, /) -> int: ...
    def readData(self, maxlen: int, /) -> object: ...
    def seek(self, off: int, /) -> bool: ...
    def setBuffer(self, a: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    def setData(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    def size(self, /) -> int: ...
    def writeData(self, data: bytes | bytearray | memoryview, len: int, /) -> int: ...


class QByteArray(Shiboken.Object):

    class Base64DecodingStatus(enum.Enum):

        Ok                        = 0x0
        IllegalInputLength        = 0x1
        IllegalCharacter          = 0x2
        IllegalPadding            = 0x3

    class Base64Option(enum.Flag):

        Base64Encoding            = 0x0
        IgnoreBase64DecodingErrors = 0x0
        KeepTrailingEquals        = 0x0
        Base64UrlEncoding         = 0x1
        OmitTrailingEquals        = 0x2
        AbortOnBase64DecodingErrors = 0x4

    class FromBase64Result(Shiboken.Object):

        @typing.overload
        def __init__(self, /) -> None: ...
        @typing.overload
        def __init__(self, FromBase64Result: PySide6.QtCore.QByteArray.FromBase64Result, /) -> None: ...

        def __copy__(self, /) -> typing.Self: ...
        def __eq__(self, rhs: PySide6.QtCore.QByteArray.FromBase64Result, /) -> bool: ...
        def __hash__(self, /) -> int: ...
        def __ne__(self, rhs: PySide6.QtCore.QByteArray.FromBase64Result, /) -> bool: ...
        def swap(self, other: PySide6.QtCore.QByteArray.FromBase64Result, /) -> None: ...


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QByteArray, /) -> None: ...
    @typing.overload
    def __init__(self, data: bytearray, /) -> None: ...
    @typing.overload
    def __init__(self, data: bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: bytes | bytearray | memoryview, /, size: int = ...) -> None: ...
    @typing.overload
    def __init__(self, v: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    def __init__(self, size: int, c: int, /) -> None: ...

    @typing.overload
    def __add__(self, arg__1: bytearray, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def __add__(self, s: str, /) -> str: ...
    @typing.overload
    def __add__(self, arg__1: bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def __add__(self, a2: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def __add__(self, a2: int, /) -> PySide6.QtCore.QByteArray: ...
    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, arg__1: str, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    @typing.overload
    def __ge__(self, arg__1: str, /) -> bool: ...
    @typing.overload
    def __ge__(self, rhs: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    @typing.overload
    def __gt__(self, arg__1: str, /) -> bool: ...
    @typing.overload
    def __gt__(self, rhs: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    @typing.overload  # type: ignore[misc]
    def __iadd__(self, arg__1: bytearray, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def __iadd__(self, a: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def __iadd__(self, c: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def __le__(self, arg__1: str, /) -> bool: ...
    @typing.overload
    def __le__(self, rhs: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    @typing.overload
    def __lt__(self, arg__1: str, /) -> bool: ...
    @typing.overload
    def __lt__(self, rhs: bytes | bytearray | memoryview, /) -> bool: ...
    @typing.overload
    def __lt__(self, rhs: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    @typing.overload
    def __ne__(self, arg__1: str, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def __str__(self, /) -> str: ...
    @typing.overload
    def append(self, s: bytes | bytearray | memoryview, len: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def append(self, a: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def append(self, c: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def append(self, count: int, c: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def assign(self, v: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def assign(self, n: int, c: int, /) -> PySide6.QtCore.QByteArray: ...
    def at(self, i: int, /) -> int: ...
    def back(self, /) -> int: ...
    def capacity(self, /) -> int: ...
    def cbegin(self, /) -> bytes | bytearray | memoryview: ...
    def cend(self, /) -> bytes | bytearray | memoryview: ...
    def chop(self, n: int, /) -> None: ...
    def chopped(self, len: int, /) -> PySide6.QtCore.QByteArray: ...
    def clear(self, /) -> None: ...
    def compare(self, a: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, cs: PySide6.QtCore.Qt.CaseSensitivity = ...) -> int: ...
    @typing.overload
    def contains(self, bv: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    @typing.overload
    def contains(self, c: int, /) -> bool: ...
    @typing.overload
    def count(self, /) -> int: ...
    @typing.overload
    def count(self, bv: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> int: ...
    @typing.overload
    def count(self, c: int, /) -> int: ...
    def data(self, /) -> bytes | bytearray | memoryview: ...
    @typing.overload
    def endsWith(self, bv: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    @typing.overload
    def endsWith(self, c: int, /) -> bool: ...
    @typing.overload
    def erase(self, it: bytes | bytearray | memoryview, /) -> bytes | bytearray | memoryview: ...
    @typing.overload
    def erase(self, first: bytes | bytearray | memoryview, last: bytes | bytearray | memoryview, /) -> bytes | bytearray | memoryview: ...
    def fill(self, c: int, /, size: int = ...) -> PySide6.QtCore.QByteArray: ...
    def first(self, n: int, /) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def fromBase64(base64: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, options: PySide6.QtCore.QByteArray.Base64Option = ...) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def fromBase64Encoding(base64: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, options: PySide6.QtCore.QByteArray.Base64Option = ...) -> PySide6.QtCore.QByteArray.FromBase64Result: ...
    @staticmethod
    def fromHex(hexEncoded: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def fromPercentEncoding(pctEncoded: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, percent: int = ...) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def fromRawData(data: str, size: int, /) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def fromStdString(s: str, /) -> PySide6.QtCore.QByteArray: ...
    def front(self, /) -> int: ...
    @typing.overload
    def indexOf(self, bv: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, from_: int | None = ...) -> int: ...
    @typing.overload
    def indexOf(self, c: int, /, from_: int | None = ...) -> int: ...
    @typing.overload
    def insert(self, i: int, s: bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def insert(self, i: int, s: bytes | bytearray | memoryview, len: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def insert(self, i: int, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def insert(self, i: int, c: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def insert(self, i: int, count: int, c: int, /) -> PySide6.QtCore.QByteArray: ...
    def isEmpty(self, /) -> bool: ...
    def isLower(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isSharedWith(self, other: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    def isUpper(self, /) -> bool: ...
    def isValidUtf8(self, /) -> bool: ...
    def last(self, n: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def lastIndexOf(self, bv: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> int: ...
    @typing.overload
    def lastIndexOf(self, bv: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, from_: int, /) -> int: ...
    @typing.overload
    def lastIndexOf(self, c: int, /, from_: int = ...) -> int: ...
    def left(self, n: int, /) -> PySide6.QtCore.QByteArray: ...
    def leftJustified(self, width: int, /, fill: int = ..., truncate: bool = ...) -> PySide6.QtCore.QByteArray: ...
    def length(self, /) -> int: ...
    @staticmethod
    def maxSize() -> int: ...
    def max_size(self, /) -> int: ...
    def mid(self, index: int, /, len: int = ...) -> PySide6.QtCore.QByteArray: ...
    def nullTerminate(self, /) -> PySide6.QtCore.QByteArray: ...
    def nullTerminated(self, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def number(arg__1: int, /, base: int = ...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def number(arg__1: float, /, format: int = ..., precision: int = ...) -> PySide6.QtCore.QByteArray: ...
    def percentDecoded(self, /, percent: int = ...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def prepend(self, s: bytes | bytearray | memoryview, len: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def prepend(self, a: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def prepend(self, c: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def prepend(self, count: int, c: int, /) -> PySide6.QtCore.QByteArray: ...
    def push_back(self, a: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    def push_front(self, a: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    def remove(self, index: int, len: int, /) -> PySide6.QtCore.QByteArray: ...
    def removeAt(self, pos: int, /) -> PySide6.QtCore.QByteArray: ...
    def removeFirst(self, /) -> PySide6.QtCore.QByteArray: ...
    def removeLast(self, /) -> PySide6.QtCore.QByteArray: ...
    def repeated(self, times: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before: bytes | bytearray | memoryview, bsize: int, after: bytes | bytearray | memoryview, asize: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, after: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before: int, after: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, before: int, after: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, index: int, len: int, s: bytes | bytearray | memoryview, alen: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def replace(self, index: int, len: int, s: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    def reserve(self, size: int, /) -> None: ...
    @typing.overload
    def resize(self, size: int, /) -> None: ...
    @typing.overload
    def resize(self, size: int, c: int, /) -> None: ...
    def resizeForOverwrite(self, size: int, /) -> None: ...
    def right(self, n: int, /) -> PySide6.QtCore.QByteArray: ...
    def rightJustified(self, width: int, /, fill: int = ..., truncate: bool = ...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def setNum(self, arg__1: int, /, base: int = ...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def setNum(self, arg__1: float, /, format: int = ..., precision: int = ...) -> PySide6.QtCore.QByteArray: ...
    def setRawData(self, a: bytes | bytearray | memoryview, n: int, /) -> PySide6.QtCore.QByteArray: ...
    def shrink_to_fit(self, /) -> None: ...
    def simplified(self, /) -> PySide6.QtCore.QByteArray: ...
    def size(self, /) -> int: ...
    @typing.overload
    def slice(self, pos: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def slice(self, pos: int, n: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def sliced(self, pos: int, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def sliced(self, pos: int, n: int, /) -> PySide6.QtCore.QByteArray: ...
    def split(self, sep: int, /) -> typing.List[PySide6.QtCore.QByteArray]: ...
    def squeeze(self, /) -> None: ...
    @typing.overload
    def startsWith(self, bv: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    @typing.overload
    def startsWith(self, c: int, /) -> bool: ...
    def swap(self, other: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    def toBase64(self, /, options: PySide6.QtCore.QByteArray.Base64Option = ...) -> PySide6.QtCore.QByteArray: ...
    def toDouble(self, /) -> float: ...
    def toFloat(self, /) -> float: ...
    def toHex(self, /, separator: int = ...) -> PySide6.QtCore.QByteArray: ...
    def toInt(self, /, base: int = ...) -> int: ...
    def toLong(self, /, base: int = ...) -> int: ...
    def toLongLong(self, /, base: int = ...) -> int: ...
    def toLower(self, /) -> PySide6.QtCore.QByteArray: ...
    def toPercentEncoding(self, /, exclude: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ..., include: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ..., percent: int = ...) -> PySide6.QtCore.QByteArray: ...
    def toShort(self, /, base: int = ...) -> int: ...
    def toStdString(self, /) -> str: ...
    def toUInt(self, /, base: int = ...) -> int: ...
    def toULong(self, /, base: int = ...) -> int: ...
    def toULongLong(self, /, base: int = ...) -> int: ...
    def toUShort(self, /, base: int = ...) -> int: ...
    def toUpper(self, /) -> PySide6.QtCore.QByteArray: ...
    def trimmed(self, /) -> PySide6.QtCore.QByteArray: ...
    def truncate(self, pos: int, /) -> None: ...


class QByteArrayMatcher(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QByteArrayMatcher, /) -> None: ...
    @typing.overload
    def __init__(self, pattern: bytes | bytearray | memoryview, /, length: int = ...) -> None: ...
    @typing.overload
    def __init__(self, pattern: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def indexIn(self, str: bytes | bytearray | memoryview, len: int, /, from_: int | None = ...) -> int: ...
    @typing.overload
    def indexIn(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, from_: int | None = ...) -> int: ...
    def pattern(self, /) -> PySide6.QtCore.QByteArray: ...
    def setPattern(self, pattern: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...


class QCalendar(Shiboken.Object):

    class System(enum.Enum):

        User                      = -1
        Gregorian                 = 0x0
        Julian                    = 0x8
        Milankovic                = 0x9
        Jalali                    = 0xa
        IslamicCivil              = 0xb
        Last                      = 0xb

    class SystemId(Shiboken.Object):

        def __init__(self, /) -> None: ...

        def index(self, /) -> int: ...
        def isValid(self, /) -> bool: ...

    class YearMonthDay(Shiboken.Object):

        @typing.overload
        def __init__(self, /) -> None: ...
        @typing.overload
        def __init__(self, YearMonthDay: PySide6.QtCore.QCalendar.YearMonthDay, /) -> None: ...
        @typing.overload
        def __init__(self, y: int, /, m: int = ..., d: int = ...) -> None: ...

        def __copy__(self, /) -> typing.Self: ...
        def isValid(self, /) -> bool: ...


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QCalendar: PySide6.QtCore.QCalendar, /) -> None: ...
    @typing.overload
    def __init__(self, system: PySide6.QtCore.QCalendar.System, /) -> None: ...
    @typing.overload
    def __init__(self, id: PySide6.QtCore.QCalendar.SystemId, /) -> None: ...
    @typing.overload
    def __init__(self, name: str, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    @staticmethod
    def availableCalendars() -> typing.List[str]: ...
    @typing.overload
    def dateFromParts(self, year: int, month: int, day: int, /) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def dateFromParts(self, parts: PySide6.QtCore.QCalendar.YearMonthDay | int, /) -> PySide6.QtCore.QDate: ...
    def dateTimeToString(self, format: str, datetime: PySide6.QtCore.QDateTime, dateOnly: PySide6.QtCore.QDate, timeOnly: PySide6.QtCore.QTime, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> str: ...
    def dayOfWeek(self, date: PySide6.QtCore.QDate, /) -> int: ...
    def daysInMonth(self, month: int, /, year: int = ...) -> int: ...
    def daysInYear(self, year: int, /) -> int: ...
    def hasYearZero(self, /) -> bool: ...
    def isDateValid(self, year: int, month: int, day: int, /) -> bool: ...
    def isGregorian(self, /) -> bool: ...
    def isLeapYear(self, year: int, /) -> bool: ...
    def isLunar(self, /) -> bool: ...
    def isLuniSolar(self, /) -> bool: ...
    def isProleptic(self, /) -> bool: ...
    def isSolar(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def matchCenturyToWeekday(self, parts: PySide6.QtCore.QCalendar.YearMonthDay | int, dow: int, /) -> PySide6.QtCore.QDate: ...
    def maximumDaysInMonth(self, /) -> int: ...
    def maximumMonthsInYear(self, /) -> int: ...
    def minimumDaysInMonth(self, /) -> int: ...
    def monthName(self, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, month: int, /, year: int = ..., format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    def monthsInYear(self, year: int, /) -> int: ...
    def name(self, /) -> str: ...
    def partsFromDate(self, date: PySide6.QtCore.QDate, /) -> PySide6.QtCore.QCalendar.YearMonthDay: ...
    def standaloneMonthName(self, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, month: int, /, year: int = ..., format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    def standaloneWeekDayName(self, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, day: int, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    def weekDayName(self, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, day: int, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...


class QCalendarPermission(Shiboken.Object):

    class AccessMode(enum.Enum):

        ReadOnly                  = 0x0
        ReadWrite                 = 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QCalendarPermission, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def accessMode(self, /) -> PySide6.QtCore.QCalendarPermission.AccessMode: ...
    def setAccessMode(self, mode: PySide6.QtCore.QCalendarPermission.AccessMode, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QCalendarPermission, /) -> None: ...


class QCameraPermission(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QCameraPermission, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def swap(self, other: PySide6.QtCore.QCameraPermission, /) -> None: ...


class QCborArray(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QCborArray, /) -> None: ...

    def __add__(self, v: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QCborArray: ...
    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    @typing.overload
    def __ge__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __ge__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    @typing.overload
    def __gt__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __gt__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __iadd__(self, v: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QCborArray: ...
    @typing.overload
    def __le__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __le__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def __lshift__(self, v: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QCborArray: ...
    @typing.overload
    def __lt__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __lt__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def append(self, value: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def at(self, i: int, /) -> PySide6.QtCore.QCborValue: ...
    def clear(self, /) -> None: ...
    def compare(self, other: PySide6.QtCore.QCborArray, /) -> int: ...
    def contains(self, value: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def empty(self, /) -> bool: ...
    def first(self, /) -> PySide6.QtCore.QCborValue: ...
    @staticmethod
    def fromJsonArray(array: PySide6.QtCore.QJsonArray, /) -> PySide6.QtCore.QCborArray: ...
    @staticmethod
    def fromStringList(list: collections.abc.Sequence[str], /) -> PySide6.QtCore.QCborArray: ...
    @staticmethod
    def fromVariantList(list: collections.abc.Sequence[typing.Any], /) -> PySide6.QtCore.QCborArray: ...
    def insert(self, i: int, value: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def isEmpty(self, /) -> bool: ...
    def last(self, /) -> PySide6.QtCore.QCborValue: ...
    def pop_back(self, /) -> None: ...
    def pop_front(self, /) -> None: ...
    def prepend(self, value: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def push_back(self, t: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def push_front(self, t: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def removeAt(self, i: int, /) -> None: ...
    def removeFirst(self, /) -> None: ...
    def removeLast(self, /) -> None: ...
    def size(self, /) -> int: ...
    def swap(self, other: PySide6.QtCore.QCborArray, /) -> None: ...
    def takeAt(self, i: int, /) -> PySide6.QtCore.QCborValue: ...
    def takeFirst(self, /) -> PySide6.QtCore.QCborValue: ...
    def takeLast(self, /) -> PySide6.QtCore.QCborValue: ...
    def toCborValue(self, /) -> PySide6.QtCore.QCborValue: ...
    def toJsonArray(self, /) -> PySide6.QtCore.QJsonArray: ...
    def toVariantList(self, /) -> typing.List[typing.Any]: ...


class QCborError(Shiboken.Object):

    class Code(enum.Enum):

        NoError                   = 0x0
        UnknownError              = 0x1
        AdvancePastEnd            = 0x3
        InputOutputError          = 0x4
        GarbageAtEnd              = 0x100
        EndOfFile                 = 0x101
        UnexpectedBreak           = 0x102
        UnknownType               = 0x103
        IllegalType               = 0x104
        IllegalNumber             = 0x105
        IllegalSimpleType         = 0x106
        InvalidUtf8String         = 0x204
        DataTooLarge              = 0x400
        NestingTooDeep            = 0x401
        UnsupportedType           = 0x402


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QCborError: PySide6.QtCore.QCborError, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def toString(self, /) -> str: ...


class QCborKnownTags(enum.IntEnum):

    DateTimeString            = 0x0
    UnixTime_t                = 0x1
    PositiveBignum            = 0x2
    NegativeBignum            = 0x3
    Decimal                   = 0x4
    Bigfloat                  = 0x5
    COSE_Encrypt0             = 0x10
    COSE_Mac0                 = 0x11
    COSE_Sign1                = 0x12
    ExpectedBase64url         = 0x15
    ExpectedBase64            = 0x16
    ExpectedBase16            = 0x17
    EncodedCbor               = 0x18
    Url                       = 0x20
    Base64url                 = 0x21
    Base64                    = 0x22
    RegularExpression         = 0x23
    MimeMessage               = 0x24
    Uuid                      = 0x25
    COSE_Encrypt              = 0x60
    COSE_Mac                  = 0x61
    COSE_Sign                 = 0x62
    Signature                 = 0xd9f7


class QCborMap(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QCborMap, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    @typing.overload
    def __ge__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __ge__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    @typing.overload
    def __gt__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __gt__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    @typing.overload
    def __le__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __le__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    @typing.overload
    def __lt__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __lt__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def clear(self, /) -> None: ...
    def compare(self, other: PySide6.QtCore.QCborMap, /) -> int: ...
    @typing.overload
    def contains(self, key: str, /) -> bool: ...
    @typing.overload
    def contains(self, key: int, /) -> bool: ...
    @typing.overload
    def contains(self, key: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def empty(self, /) -> bool: ...
    @staticmethod
    def fromJsonObject(o: typing.Dict[str, PySide6.QtCore.QJsonValue], /) -> PySide6.QtCore.QCborMap: ...
    @staticmethod
    def fromVariantHash(hash: typing.Dict[str, typing.Any], /) -> PySide6.QtCore.QCborMap: ...
    @staticmethod
    def fromVariantMap(map: typing.Dict[str, typing.Any], /) -> PySide6.QtCore.QCborMap: ...
    def isEmpty(self, /) -> bool: ...
    def keys(self, /) -> typing.List[PySide6.QtCore.QCborValue]: ...
    @typing.overload
    def remove(self, key: str, /) -> None: ...
    @typing.overload
    def remove(self, key: int, /) -> None: ...
    @typing.overload
    def remove(self, key: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def size(self, /) -> int: ...
    def swap(self, other: PySide6.QtCore.QCborMap, /) -> None: ...
    @typing.overload
    def take(self, key: str, /) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    def take(self, key: int, /) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    def take(self, key: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QCborValue: ...
    def toCborValue(self, /) -> PySide6.QtCore.QCborValue: ...
    def toJsonObject(self, /) -> typing.Dict[str, PySide6.QtCore.QJsonValue]: ...
    def toVariantHash(self, /) -> typing.Dict[str, typing.Any]: ...
    def toVariantMap(self, /) -> typing.Dict[str, typing.Any]: ...
    @typing.overload
    def value(self, key: str, /) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    def value(self, key: int, /) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    def value(self, key: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QCborValue: ...


class QCborParserError(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QCborParserError: PySide6.QtCore.QCborParserError, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def errorString(self, /) -> str: ...


class QCborSimpleType(enum.IntEnum):

    False_                    = 0x14
    True_                     = 0x15
    Null                      = 0x16
    Undefined                 = 0x17


class QCborStreamReader(Shiboken.Object):

    class StringResultCode(enum.Enum):

        Error                     = -1
        EndOfString               = 0x0
        Ok                        = 0x1

    class Type(enum.Enum):

        UnsignedInteger           = 0x0
        NegativeInteger           = 0x20
        ByteArray                 = 0x40
        ByteString                = 0x40
        String                    = 0x60
        TextString                = 0x60
        Array                     = 0x80
        Map                       = 0xa0
        Tag                       = 0xc0
        SimpleType                = 0xe0
        Float16                   = 0xf9
        HalfFloat                 = 0xf9
        Float                     = 0xfa
        Double                    = 0xfb
        Invalid                   = 0xff


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, device: PySide6.QtCore.QIODevice, /) -> None: ...
    @typing.overload
    def __init__(self, data: bytearray, len: int, /) -> None: ...
    @typing.overload
    def __init__(self, data: bytes | bytearray | memoryview, len: int, /) -> None: ...
    @typing.overload
    def __init__(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...

    @typing.overload
    def addData(self, data: bytearray, len: int, /) -> None: ...
    @typing.overload
    def addData(self, data: bytes | bytearray | memoryview, len: int, /) -> None: ...
    @typing.overload
    def addData(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    def clear(self, /) -> None: ...
    def containerDepth(self, /) -> int: ...
    def currentOffset(self, /) -> int: ...
    def currentStringChunkSize(self, /) -> int: ...
    def device(self, /) -> PySide6.QtCore.QIODevice: ...
    def enterContainer(self, /) -> bool: ...
    def hasNext(self, /) -> bool: ...
    def isArray(self, /) -> bool: ...
    def isBool(self, /) -> bool: ...
    def isByteArray(self, /) -> bool: ...
    def isContainer(self, /) -> bool: ...
    def isDouble(self, /) -> bool: ...
    def isFalse(self, /) -> bool: ...
    def isFloat(self, /) -> bool: ...
    def isFloat16(self, /) -> bool: ...
    def isInteger(self, /) -> bool: ...
    def isInvalid(self, /) -> bool: ...
    def isLengthKnown(self, /) -> bool: ...
    def isMap(self, /) -> bool: ...
    def isNegativeInteger(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    @typing.overload
    def isSimpleType(self, /) -> bool: ...
    @typing.overload
    def isSimpleType(self, st: PySide6.QtCore.QCborSimpleType, /) -> bool: ...
    def isString(self, /) -> bool: ...
    def isTag(self, /) -> bool: ...
    def isTrue(self, /) -> bool: ...
    def isUndefined(self, /) -> bool: ...
    def isUnsignedInteger(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def lastError(self, /) -> PySide6.QtCore.QCborError: ...
    def leaveContainer(self, /) -> bool: ...
    def length(self, /) -> int: ...
    def next(self, /, maxRecursion: int = ...) -> bool: ...
    def parentContainerType(self, /) -> PySide6.QtCore.QCborStreamReader.Type: ...
    def readAllByteArray(self, /) -> PySide6.QtCore.QByteArray: ...
    def readAllString(self, /) -> str: ...
    def readAllUtf8String(self, /) -> PySide6.QtCore.QByteArray: ...
    def readAndAppendToByteArray(self, dst: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    def readAndAppendToString(self, dst: str, /) -> bool: ...
    def readAndAppendToUtf8String(self, dst: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    def readByteArray(self, /) -> PySide6.QtCore.QCborStringResultByteArray: ...
    def readString(self, /) -> PySide6.QtCore.QCborStringResultString: ...
    def readUtf8String(self, /) -> PySide6.QtCore.QCborStringResultByteArray: ...
    def reparse(self, /) -> None: ...
    def reset(self, /) -> None: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice, /) -> None: ...
    def toBool(self, /) -> bool: ...
    def toDouble(self, /) -> float: ...
    def toFloat(self, /) -> float: ...
    def toInteger(self, /) -> int: ...
    def toSimpleType(self, /) -> PySide6.QtCore.QCborSimpleType: ...
    def toTag(self, /) -> PySide6.QtCore.QCborTag: ...
    def toUnsignedInteger(self, /) -> int: ...
    def type(self, /) -> PySide6.QtCore.QCborStreamReader.Type: ...


class QCborStreamWriter(Shiboken.Object):

    @typing.overload
    def __init__(self, device: PySide6.QtCore.QIODevice, /) -> None: ...
    @typing.overload
    def __init__(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...

    @typing.overload
    def append(self, tag: PySide6.QtCore.QCborKnownTags, /) -> None: ...
    @typing.overload
    def append(self, st: PySide6.QtCore.QCborSimpleType, /) -> None: ...
    @typing.overload
    def append(self, tag: PySide6.QtCore.QCborTag, /) -> None: ...
    @typing.overload
    def append(self, str: str, /) -> None: ...
    @typing.overload
    def append(self, str: bytes | bytearray | memoryview, /, size: int = ...) -> None: ...
    @typing.overload
    def append(self, ba: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    def append(self, b: bool, /) -> None: ...
    @typing.overload
    def append(self, u: int, /) -> None: ...
    @typing.overload
    def append(self, d: float, /) -> None: ...
    def appendByteString(self, data: bytes | bytearray | memoryview, len: int, /) -> None: ...
    def appendNull(self, /) -> None: ...
    def appendTextString(self, utf8: bytes | bytearray | memoryview, len: int, /) -> None: ...
    def appendUndefined(self, /) -> None: ...
    def device(self, /) -> PySide6.QtCore.QIODevice: ...
    def endArray(self, /) -> bool: ...
    def endMap(self, /) -> bool: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice, /) -> None: ...
    @typing.overload
    def startArray(self, /) -> None: ...
    @typing.overload
    def startArray(self, count: int, /) -> None: ...
    @typing.overload
    def startMap(self, /) -> None: ...
    @typing.overload
    def startMap(self, count: int, /) -> None: ...


class QCborStringResultByteArray(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QCborStringResultByteArray: PySide6.QtCore.QCborStringResultByteArray, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...


class QCborStringResultString(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QCborStringResultString: PySide6.QtCore.QCborStringResultString, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...


class QCborTag(enum.IntEnum): ...  # type: ignore[misc]


class QCborValue(Shiboken.Object):

    class DiagnosticNotationOption(enum.Flag):

        Compact                   = 0x0
        LineWrapped               = 0x1
        ExtendedFormat            = 0x2

    class EncodingOption(enum.Flag):

        NoTransformation          = 0x0
        SortKeysInMaps            = 0x1
        UseFloat                  = 0x2
        UseFloat16                = 0x6
        UseIntegers               = 0x8

    class Type(enum.Enum):

        Invalid                   = -1
        Integer                   = 0x0
        ByteArray                 = 0x40
        String                    = 0x60
        Array                     = 0x80
        Map                       = 0xa0
        Tag                       = 0xc0
        SimpleType                = 0x100
        False_                    = 0x114
        True_                     = 0x115
        Null                      = 0x116
        Undefined                 = 0x117
        Double                    = 0x202
        DateTime                  = 0x10000
        Url                       = 0x10020
        RegularExpression         = 0x10023
        Uuid                      = 0x10025


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, t_: PySide6.QtCore.QCborKnownTags, /, tv: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int= ...) -> None: ...
    @typing.overload
    def __init__(self, st: PySide6.QtCore.QCborSimpleType, /) -> None: ...
    @typing.overload
    def __init__(self, tag: PySide6.QtCore.QCborTag, /, taggedValue: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int= ...) -> None: ...
    @typing.overload
    def __init__(self, a: PySide6.QtCore.QCborArray, /) -> None: ...
    @typing.overload
    def __init__(self, m: PySide6.QtCore.QCborMap, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QCborValue, /) -> None: ...
    @typing.overload
    def __init__(self, dt: PySide6.QtCore.QDateTime, /) -> None: ...
    @typing.overload
    def __init__(self, uuid: PySide6.QtCore.QUuid, /) -> None: ...
    @typing.overload
    def __init__(self, t_: PySide6.QtCore.QCborValue.Type, /) -> None: ...
    @typing.overload
    def __init__(self, s: str, /) -> None: ...
    @typing.overload
    def __init__(self, rx: PySide6.QtCore.QRegularExpression | str, /) -> None: ...
    @typing.overload
    def __init__(self, url: PySide6.QtCore.QUrl | str, /) -> None: ...
    @typing.overload
    def __init__(self, s: bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    def __init__(self, ba: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    def __init__(self, b_: bool, /) -> None: ...
    @typing.overload
    def __init__(self, u: int, /) -> None: ...
    @typing.overload
    def __init__(self, v: float, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    @typing.overload
    def __ge__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __ge__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __ge__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    @typing.overload
    def __gt__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __gt__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __gt__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    @typing.overload
    def __le__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __le__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __le__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    @typing.overload
    def __lt__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __lt__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __lt__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QCborArray, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QCborMap, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def compare(self, other: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> int: ...
    @typing.overload
    @staticmethod
    def fromCbor(reader: PySide6.QtCore.QCborStreamReader, /) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    @staticmethod
    def fromCbor(data: bytearray, len: int, /, error: PySide6.QtCore.QCborParserError | None = ...) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    @staticmethod
    def fromCbor(data: bytes | bytearray | memoryview, len: int, /, error: PySide6.QtCore.QCborParserError | None = ...) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    @staticmethod
    def fromCbor(ba: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, error: PySide6.QtCore.QCborParserError | None = ...) -> PySide6.QtCore.QCborValue: ...
    @staticmethod
    def fromJsonValue(v: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QCborValue: ...
    @staticmethod
    def fromVariant(variant: typing.Any, /) -> PySide6.QtCore.QCborValue: ...
    def isArray(self, /) -> bool: ...
    def isBool(self, /) -> bool: ...
    def isByteArray(self, /) -> bool: ...
    def isContainer(self, /) -> bool: ...
    def isDateTime(self, /) -> bool: ...
    def isDouble(self, /) -> bool: ...
    def isFalse(self, /) -> bool: ...
    def isInteger(self, /) -> bool: ...
    def isInvalid(self, /) -> bool: ...
    def isMap(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isRegularExpression(self, /) -> bool: ...
    @typing.overload
    def isSimpleType(self, /) -> bool: ...
    @typing.overload
    def isSimpleType(self, st: PySide6.QtCore.QCborSimpleType, /) -> bool: ...
    def isString(self, /) -> bool: ...
    def isTag(self, /) -> bool: ...
    def isTrue(self, /) -> bool: ...
    def isUndefined(self, /) -> bool: ...
    def isUrl(self, /) -> bool: ...
    def isUuid(self, /) -> bool: ...
    def swap(self, other: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def tag(self, /, defaultValue: PySide6.QtCore.QCborTag = ...) -> PySide6.QtCore.QCborTag: ...
    def taggedValue(self, /, defaultValue: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int= ...) -> PySide6.QtCore.QCborValue: ...
    @typing.overload
    def toArray(self, /) -> PySide6.QtCore.QCborArray: ...
    @typing.overload
    def toArray(self, defaultValue: PySide6.QtCore.QCborArray, /) -> PySide6.QtCore.QCborArray: ...
    def toBool(self, /, defaultValue: bool = ...) -> bool: ...
    def toByteArray(self, /, defaultValue: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def toCbor(self, /, opt: PySide6.QtCore.QCborValue.EncodingOption = ...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def toCbor(self, writer: PySide6.QtCore.QCborStreamWriter, /, opt: PySide6.QtCore.QCborValue.EncodingOption = ...) -> None: ...
    def toDateTime(self, /, defaultValue: PySide6.QtCore.QDateTime = ...) -> PySide6.QtCore.QDateTime: ...
    def toDiagnosticNotation(self, /, opts: PySide6.QtCore.QCborValue.DiagnosticNotationOption = ...) -> str: ...
    def toDouble(self, /, defaultValue: float | None = ...) -> float: ...
    def toInteger(self, /, defaultValue: int | None = ...) -> int: ...
    def toJsonValue(self, /) -> PySide6.QtCore.QJsonValue: ...
    @typing.overload
    def toMap(self, /) -> PySide6.QtCore.QCborMap: ...
    @typing.overload
    def toMap(self, defaultValue: PySide6.QtCore.QCborMap, /) -> PySide6.QtCore.QCborMap: ...
    def toRegularExpression(self, /, defaultValue: PySide6.QtCore.QRegularExpression | str= ...) -> PySide6.QtCore.QRegularExpression: ...
    def toSimpleType(self, /, defaultValue: PySide6.QtCore.QCborSimpleType = ...) -> PySide6.QtCore.QCborSimpleType: ...
    def toString(self, /, defaultValue: str = ...) -> str: ...
    def toStringView(self, /, defaultValue: str = ...) -> str: ...
    def toUrl(self, /, defaultValue: PySide6.QtCore.QUrl | str= ...) -> PySide6.QtCore.QUrl: ...
    def toUuid(self, /, defaultValue: PySide6.QtCore.QUuid = ...) -> PySide6.QtCore.QUuid: ...
    def toVariant(self, /) -> typing.Any: ...
    def type(self, /) -> PySide6.QtCore.QCborValue.Type: ...


class QChildEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, child: PySide6.QtCore.QObject, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QChildEvent, /) -> None: ...

    def added(self, /) -> bool: ...
    def child(self, /) -> PySide6.QtCore.QObject: ...
    def clone(self, /) -> PySide6.QtCore.QChildEvent: ...
    def polished(self, /) -> bool: ...
    def removed(self, /) -> bool: ...


class QCollator(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QCollator, /) -> None: ...
    @typing.overload
    def __init__(self, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> None: ...

    def __call__(self, s1: str, s2: str, /) -> bool: ...
    def caseSensitivity(self, /) -> PySide6.QtCore.Qt.CaseSensitivity: ...
    @typing.overload
    def compare(self, s1: str, s2: str, /) -> int: ...
    @typing.overload
    def compare(self, s1: bytes | bytearray | memoryview, len1: int, s2: bytes | bytearray | memoryview, len2: int, /) -> int: ...
    @staticmethod
    def defaultCompare(s1: str, s2: str, /) -> int: ...
    @staticmethod
    def defaultSortKey(key: str, /) -> PySide6.QtCore.QCollatorSortKey: ...
    def ignorePunctuation(self, /) -> bool: ...
    def locale(self, /) -> PySide6.QtCore.QLocale: ...
    def numericMode(self, /) -> bool: ...
    def setCaseSensitivity(self, cs: PySide6.QtCore.Qt.CaseSensitivity, /) -> None: ...
    def setIgnorePunctuation(self, on: bool, /) -> None: ...
    def setLocale(self, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> None: ...
    def setNumericMode(self, on: bool, /) -> None: ...
    def sortKey(self, string: str, /) -> PySide6.QtCore.QCollatorSortKey: ...
    def swap(self, other: PySide6.QtCore.QCollator, /) -> None: ...


class QCollatorSortKey(Shiboken.Object):

    def __init__(self, other: PySide6.QtCore.QCollatorSortKey, /) -> None: ...

    def __lt__(self, rhs: PySide6.QtCore.QCollatorSortKey, /) -> bool: ...
    def compare(self, key: PySide6.QtCore.QCollatorSortKey, /) -> int: ...
    def swap(self, other: PySide6.QtCore.QCollatorSortKey, /) -> None: ...


class QCommandLineOption(Shiboken.Object):

    class Flag(enum.Flag):

        HiddenFromHelp            = 0x1
        ShortOptionStyle          = 0x2
        IgnoreOptionsAfter        = 0x4


    @typing.overload
    def __init__(self, other: PySide6.QtCore.QCommandLineOption, /) -> None: ...
    @typing.overload
    def __init__(self, name: str, /) -> None: ...
    @typing.overload
    def __init__(self, name: str, description: str, /, valueName: str = ..., defaultValue: str = ...) -> None: ...
    @typing.overload
    def __init__(self, names: collections.abc.Sequence[str], /) -> None: ...
    @typing.overload
    def __init__(self, names: collections.abc.Sequence[str], description: str, /, valueName: str = ..., defaultValue: str = ...) -> None: ...

    def defaultValues(self, /) -> typing.List[str]: ...
    def description(self, /) -> str: ...
    def flags(self, /) -> PySide6.QtCore.QCommandLineOption.Flag: ...
    def names(self, /) -> typing.List[str]: ...
    def setDefaultValue(self, defaultValue: str, /) -> None: ...
    def setDefaultValues(self, defaultValues: collections.abc.Sequence[str], /) -> None: ...
    def setDescription(self, description: str, /) -> None: ...
    def setFlags(self, aflags: PySide6.QtCore.QCommandLineOption.Flag, /) -> None: ...
    def setValueName(self, name: str, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QCommandLineOption, /) -> None: ...
    def valueName(self, /) -> str: ...


class QCommandLineParser(Shiboken.Object):

    class MessageType(enum.Enum):

        Information               = 0x0
        Error                     = 0x1

    class OptionsAfterPositionalArgumentsMode(enum.Enum):

        ParseAsOptions            = 0x0
        ParseAsPositionalArguments = 0x1

    class SingleDashWordOptionMode(enum.Enum):

        ParseAsCompactedShortOptions = 0x0
        ParseAsLongOptions        = 0x1


    def __init__(self, /) -> None: ...

    def addHelpOption(self, /) -> PySide6.QtCore.QCommandLineOption: ...
    def addOption(self, commandLineOption: PySide6.QtCore.QCommandLineOption, /) -> bool: ...
    def addOptions(self, options: collections.abc.Sequence[PySide6.QtCore.QCommandLineOption], /) -> bool: ...
    def addPositionalArgument(self, name: str, description: str, /, syntax: str = ...) -> None: ...
    def addVersionOption(self, /) -> PySide6.QtCore.QCommandLineOption: ...
    def applicationDescription(self, /) -> str: ...
    def clearPositionalArguments(self, /) -> None: ...
    def errorText(self, /) -> str: ...
    def helpText(self, /) -> str: ...
    @typing.overload
    def isSet(self, option: PySide6.QtCore.QCommandLineOption, /) -> bool: ...
    @typing.overload
    def isSet(self, name: str, /) -> bool: ...
    def optionNames(self, /) -> typing.List[str]: ...
    def parse(self, arguments: collections.abc.Sequence[str], /) -> bool: ...
    def positionalArguments(self, /) -> typing.List[str]: ...
    @typing.overload
    def process(self, app: PySide6.QtCore.QCoreApplication, /) -> None: ...
    @typing.overload
    def process(self, arguments: collections.abc.Sequence[str], /) -> None: ...
    def setApplicationDescription(self, description: str, /) -> None: ...
    def setOptionsAfterPositionalArgumentsMode(self, mode: PySide6.QtCore.QCommandLineParser.OptionsAfterPositionalArgumentsMode, /) -> None: ...
    def setSingleDashWordOptionMode(self, parsingMode: PySide6.QtCore.QCommandLineParser.SingleDashWordOptionMode, /) -> None: ...
    def showHelp(self, /, exitCode: int | None = ...) -> None: ...
    @staticmethod
    def showMessageAndExit(type: PySide6.QtCore.QCommandLineParser.MessageType, message: str, /, exitCode: int | None = ...) -> None: ...
    def showVersion(self, /) -> None: ...
    def unknownOptionNames(self, /) -> typing.List[str]: ...
    @typing.overload
    def value(self, option: PySide6.QtCore.QCommandLineOption, /) -> str: ...
    @typing.overload
    def value(self, name: str, /) -> str: ...
    @typing.overload
    def values(self, option: PySide6.QtCore.QCommandLineOption, /) -> typing.List[str]: ...
    @typing.overload
    def values(self, name: str, /) -> typing.List[str]: ...


class QConcatenateTablesProxyModel(PySide6.QtCore.QAbstractItemModel):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def addSourceModel(self, sourceModel: PySide6.QtCore.QAbstractItemModel, /) -> None: ...
    def canDropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def columnCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def data(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def flags(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def headerData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, /, role: int = ...) -> typing.Any: ...
    def index(self, row: int, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> PySide6.QtCore.QModelIndex: ...
    def itemData(self, proxyIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> typing.Dict[int, typing.Any]: ...
    def mapFromSource(self, sourceIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def mapToSource(self, proxyIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def mimeData(self, indexes: collections.abc.Sequence[PySide6.QtCore.QModelIndex], /) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self, /) -> typing.List[str]: ...
    @typing.overload
    def parent(self, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def removeSourceModel(self, sourceModel: PySide6.QtCore.QAbstractItemModel, /) -> None: ...
    def roleNames(self, /) -> typing.Dict[int, PySide6.QtCore.QByteArray]: ...
    def rowCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def setData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, value: typing.Any, /, role: int = ...) -> bool: ...
    def setItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, roles: typing.Dict[int, typing.Any], /) -> bool: ...
    def sourceModels(self, /) -> typing.List[PySide6.QtCore.QAbstractItemModel]: ...
    def span(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QSize: ...


class QContactsPermission(Shiboken.Object):

    class AccessMode(enum.Enum):

        ReadOnly                  = 0x0
        ReadWrite                 = 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QContactsPermission, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def accessMode(self, /) -> PySide6.QtCore.QContactsPermission.AccessMode: ...
    def setAccessMode(self, mode: PySide6.QtCore.QContactsPermission.AccessMode, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QContactsPermission, /) -> None: ...


class QCoreApplication(PySide6.QtCore.QObject):

    aboutToQuit              : typing.ClassVar[Signal] = ... # aboutToQuit()
    applicationNameChanged   : typing.ClassVar[Signal] = ... # applicationNameChanged()
    applicationVersionChanged: typing.ClassVar[Signal] = ... # applicationVersionChanged()
    organizationDomainChanged: typing.ClassVar[Signal] = ... # organizationDomainChanged()
    organizationNameChanged  : typing.ClassVar[Signal] = ... # organizationNameChanged()

    @typing.overload
    def __init__(self, args: collections.abc.Sequence[str], /, *, applicationName: str | None = ..., applicationVersion: str | None = ..., organizationName: str | None = ..., organizationDomain: str | None = ..., quitLockEnabled: bool | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, *, applicationName: str | None = ..., applicationVersion: str | None = ..., organizationName: str | None = ..., organizationDomain: str | None = ..., quitLockEnabled: bool | None = ...) -> None: ...

    @staticmethod
    def addLibraryPath(arg__1: str, /) -> None: ...
    @staticmethod
    def applicationDirPath() -> str: ...
    @staticmethod
    def applicationFilePath() -> str: ...
    @staticmethod
    def applicationName() -> str: ...
    @staticmethod
    def applicationPid() -> int: ...
    @staticmethod
    def applicationVersion() -> str: ...
    @staticmethod
    def arguments() -> typing.List[str]: ...
    @typing.overload
    def checkPermission(self, permission: PySide6.QtCore.QBluetoothPermission, /) -> PySide6.QtCore.Qt.PermissionStatus: ...
    @typing.overload
    def checkPermission(self, permission: PySide6.QtCore.QCalendarPermission, /) -> PySide6.QtCore.Qt.PermissionStatus: ...
    @typing.overload
    def checkPermission(self, permission: PySide6.QtCore.QCameraPermission, /) -> PySide6.QtCore.Qt.PermissionStatus: ...
    @typing.overload
    def checkPermission(self, permission: PySide6.QtCore.QContactsPermission, /) -> PySide6.QtCore.Qt.PermissionStatus: ...
    @typing.overload
    def checkPermission(self, permission: PySide6.QtCore.QLocationPermission, /) -> PySide6.QtCore.Qt.PermissionStatus: ...
    @typing.overload
    def checkPermission(self, permission: PySide6.QtCore.QMicrophonePermission, /) -> PySide6.QtCore.Qt.PermissionStatus: ...
    @typing.overload
    def checkPermission(self, permission: PySide6.QtCore.QPermission, /) -> PySide6.QtCore.Qt.PermissionStatus: ...
    @staticmethod
    def closingDown() -> bool: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    @staticmethod
    def eventDispatcher() -> PySide6.QtCore.QAbstractEventDispatcher: ...
    @staticmethod
    def exec() -> int: ...
    def exec_(self, /) -> int: ...
    @staticmethod
    def exit(retcode: int | None = ...) -> None: ...
    def installNativeEventFilter(self, filterObj: PySide6.QtCore.QAbstractNativeEventFilter, /) -> None: ...
    @staticmethod
    def installTranslator(messageFile: PySide6.QtCore.QTranslator, /) -> bool: ...
    @staticmethod
    def instance() -> PySide6.QtCore.QCoreApplication | None : ...
    @staticmethod
    def instanceExists() -> bool: ...
    @staticmethod
    def isQuitLockEnabled() -> bool: ...
    @staticmethod
    def isSetuidAllowed() -> bool: ...
    @staticmethod
    def libraryPaths() -> typing.List[str]: ...
    def notify(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent, /) -> bool: ...
    @staticmethod
    def organizationDomain() -> str: ...
    @staticmethod
    def organizationName() -> str: ...
    @staticmethod
    def postEvent(receiver: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /, priority: int = ...) -> None: ...
    @typing.overload
    @staticmethod
    def processEvents(flags: PySide6.QtCore.QEventLoop.ProcessEventsFlag = ...) -> None: ...
    @typing.overload
    @staticmethod
    def processEvents(flags: PySide6.QtCore.QEventLoop.ProcessEventsFlag, maxtime: int, /) -> None: ...
    @typing.overload
    @staticmethod
    def processEvents(flags: PySide6.QtCore.QEventLoop.ProcessEventsFlag, deadline: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> None: ...
    @staticmethod
    def quit() -> None: ...
    @staticmethod
    def removeLibraryPath(arg__1: str, /) -> None: ...
    def removeNativeEventFilter(self, filterObj: PySide6.QtCore.QAbstractNativeEventFilter, /) -> None: ...
    @staticmethod
    def removePostedEvents(receiver: PySide6.QtCore.QObject, /, eventType: int | None = ...) -> None: ...
    @staticmethod
    def removeTranslator(messageFile: PySide6.QtCore.QTranslator, /) -> bool: ...
    @typing.overload
    def requestPermission(self, permission: PySide6.QtCore.QBluetoothPermission, context: PySide6.QtCore.QObject, functor: collections.abc.Callable[..., typing.Any], /) -> None: ...
    @typing.overload
    def requestPermission(self, permission: PySide6.QtCore.QCalendarPermission, context: PySide6.QtCore.QObject, functor: collections.abc.Callable[..., typing.Any], /) -> None: ...
    @typing.overload
    def requestPermission(self, permission: PySide6.QtCore.QCameraPermission, context: PySide6.QtCore.QObject, functor: collections.abc.Callable[..., typing.Any], /) -> None: ...
    @typing.overload
    def requestPermission(self, permission: PySide6.QtCore.QContactsPermission, context: PySide6.QtCore.QObject, functor: collections.abc.Callable[..., typing.Any], /) -> None: ...
    @typing.overload
    def requestPermission(self, permission: PySide6.QtCore.QLocationPermission, context: PySide6.QtCore.QObject, functor: collections.abc.Callable[..., typing.Any], /) -> None: ...
    @typing.overload
    def requestPermission(self, permission: PySide6.QtCore.QMicrophonePermission, context: PySide6.QtCore.QObject, functor: collections.abc.Callable[..., typing.Any], /) -> None: ...
    def resolveInterface(self, name: bytes | bytearray | memoryview, revision: int, /) -> int: ...
    @staticmethod
    def sendEvent(receiver: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> bool: ...
    @staticmethod
    def sendPostedEvents(receiver: PySide6.QtCore.QObject | None = ..., event_type: int | None = ...) -> None: ...
    @staticmethod
    def setApplicationName(application: str, /) -> None: ...
    @staticmethod
    def setApplicationVersion(version: str, /) -> None: ...
    @staticmethod
    def setAttribute(attribute: PySide6.QtCore.Qt.ApplicationAttribute, /, on: bool = ...) -> None: ...
    @staticmethod
    def setEventDispatcher(eventDispatcher: PySide6.QtCore.QAbstractEventDispatcher, /) -> None: ...
    @staticmethod
    def setLibraryPaths(arg__1: collections.abc.Sequence[str], /) -> None: ...
    @staticmethod
    def setOrganizationDomain(orgDomain: str, /) -> None: ...
    @staticmethod
    def setOrganizationName(orgName: str, /) -> None: ...
    @staticmethod
    def setQuitLockEnabled(enabled: bool, /) -> None: ...
    @staticmethod
    def setSetuidAllowed(allow: bool, /) -> None: ...
    def shutdown(self, /) -> None: ...
    @staticmethod
    def startingUp() -> bool: ...
    @staticmethod
    def testAttribute(attribute: PySide6.QtCore.Qt.ApplicationAttribute, /) -> bool: ...
    @staticmethod
    def translate(context: str, key: str, /, disambiguation: str | None = ..., n: int = ...) -> str: ...


class QCryptographicHash(Shiboken.Object):

    class Algorithm(enum.Enum):

        Md4                       = 0x0
        Md5                       = 0x1
        Sha1                      = 0x2
        Sha224                    = 0x3
        Sha256                    = 0x4
        Sha384                    = 0x5
        Sha512                    = 0x6
        Keccak_224                = 0x7
        Keccak_256                = 0x8
        Keccak_384                = 0x9
        Keccak_512                = 0xa
        RealSha3_224              = 0xb
        Sha3_224                  = 0xb
        RealSha3_256              = 0xc
        Sha3_256                  = 0xc
        RealSha3_384              = 0xd
        Sha3_384                  = 0xd
        RealSha3_512              = 0xe
        Sha3_512                  = 0xe
        Blake2b_160               = 0xf
        Blake2b_256               = 0x10
        Blake2b_384               = 0x11
        Blake2b_512               = 0x12
        Blake2s_128               = 0x13
        Blake2s_160               = 0x14
        Blake2s_224               = 0x15
        Blake2s_256               = 0x16
        NumAlgorithms             = 0x17


    def __init__(self, method: PySide6.QtCore.QCryptographicHash.Algorithm, /) -> None: ...

    @typing.overload
    def addData(self, device: PySide6.QtCore.QIODevice, /) -> bool: ...
    @typing.overload
    def addData(self, data: bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    def addData(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    def algorithm(self, /) -> PySide6.QtCore.QCryptographicHash.Algorithm: ...
    @staticmethod
    def hash(data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, method: PySide6.QtCore.QCryptographicHash.Algorithm, /) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def hashLength(method: PySide6.QtCore.QCryptographicHash.Algorithm, /) -> int: ...
    def reset(self, /) -> None: ...
    def result(self, /) -> PySide6.QtCore.QByteArray: ...
    def resultView(self, /) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def supportsAlgorithm(method: PySide6.QtCore.QCryptographicHash.Algorithm, /) -> bool: ...
    def swap(self, other: PySide6.QtCore.QCryptographicHash, /) -> None: ...


class QDataStream(PySide6.QtCore.QIODeviceBase):

    class ByteOrder(enum.Enum):

        BigEndian                 = 0x0
        LittleEndian              = 0x1

    class FloatingPointPrecision(enum.Enum):

        SinglePrecision           = 0x0
        DoublePrecision           = 0x1

    class Status(enum.Enum):

        Ok                        = 0x0
        ReadPastEnd               = 0x1
        ReadCorruptData           = 0x2
        WriteFailed               = 0x3
        SizeLimitExceeded         = 0x4

    class Version(enum.IntEnum):

        Qt_1_0                    = 0x1
        Qt_2_0                    = 0x2
        Qt_2_1                    = 0x3
        Qt_3_0                    = 0x4
        Qt_3_1                    = 0x5
        Qt_3_3                    = 0x6
        Qt_4_0                    = 0x7
        Qt_4_1                    = 0x7
        Qt_4_2                    = 0x8
        Qt_4_3                    = 0x9
        Qt_4_4                    = 0xa
        Qt_4_5                    = 0xb
        Qt_4_6                    = 0xc
        Qt_4_7                    = 0xc
        Qt_4_8                    = 0xc
        Qt_4_9                    = 0xc
        Qt_5_0                    = 0xd
        Qt_5_1                    = 0xe
        Qt_5_2                    = 0xf
        Qt_5_3                    = 0xf
        Qt_5_4                    = 0x10
        Qt_5_5                    = 0x10
        Qt_5_10                   = 0x11
        Qt_5_11                   = 0x11
        Qt_5_6                    = 0x11
        Qt_5_7                    = 0x11
        Qt_5_8                    = 0x11
        Qt_5_9                    = 0x11
        Qt_5_12                   = 0x12
        Qt_5_13                   = 0x13
        Qt_5_14                   = 0x13
        Qt_5_15                   = 0x13
        Qt_6_0                    = 0x14
        Qt_6_1                    = 0x14
        Qt_6_2                    = 0x14
        Qt_6_3                    = 0x14
        Qt_6_4                    = 0x14
        Qt_6_5                    = 0x14
        Qt_6_6                    = 0x15
        Qt_6_7                    = 0x16
        Qt_6_8                    = 0x16
        Qt_6_9                    = 0x16
        Qt_6_10                   = 0x17
        Qt_DefaultCompiledVersion = 0x17


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QIODevice, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, flags: PySide6.QtCore.QIODeviceBase.OpenModeFlag, /) -> None: ...

    @typing.overload
    def __lshift__(self, st: PySide6.QtCore.QCborSimpleType, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QCborArray, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QCborMap, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QDate, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QDateTime, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QJsonArray, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QJsonDocument, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QLine, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QRect, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QSize, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QTime, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QUuid, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, version: PySide6.QtCore.QVersionNumber, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, chr: str, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QEasingCurve | PySide6.QtCore.QEasingCurve.Type, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, combination: PySide6.QtCore.QKeyCombination | PySide6.QtCore.Qt.KeyboardModifier | PySide6.QtCore.Qt.Key, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: typing.Dict[str, PySide6.QtCore.QJsonValue], /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, re: PySide6.QtCore.QRegularExpression | str, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QUrl | str, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, i: int, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QBitArray | int, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, arg__2: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __lshift__(self, p: typing.Any, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, st: PySide6.QtCore.QCborSimpleType, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QCborArray, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QCborMap, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QDate, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QDateTime, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QJsonArray, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QJsonDocument, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QLine, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QRect, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QSize, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QTime, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QUuid, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, version: PySide6.QtCore.QVersionNumber, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, chr: str, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QEasingCurve | PySide6.QtCore.QEasingCurve.Type, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, combination: PySide6.QtCore.QKeyCombination | PySide6.QtCore.Qt.KeyboardModifier | PySide6.QtCore.Qt.Key, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: typing.Dict[str, PySide6.QtCore.QJsonValue], /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, re: PySide6.QtCore.QRegularExpression | str, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QUrl | str, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, i: bool, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, i: int, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QBitArray | int, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, arg__2: PySide6.QtCore.QCborValue | PySide6.QtCore.QCborKnownTags | PySide6.QtCore.QCborSimpleType | PySide6.QtCore.QCborTag | PySide6.QtCore.QCborValue.Type | str | bool | PySide6.QtCore.QByteArray | PySide6.QtCore.QCborArray | PySide6.QtCore.QCborMap | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QDataStream: ...
    @typing.overload
    def __rshift__(self, p: typing.Any, /) -> PySide6.QtCore.QDataStream: ...
    def abortTransaction(self, /) -> None: ...
    def atEnd(self, /) -> bool: ...
    def byteOrder(self, /) -> PySide6.QtCore.QDataStream.ByteOrder: ...
    def commitTransaction(self, /) -> bool: ...
    def device(self, /) -> PySide6.QtCore.QIODevice: ...
    def floatingPointPrecision(self, /) -> PySide6.QtCore.QDataStream.FloatingPointPrecision: ...
    def isDeviceTransactionStarted(self, /) -> bool: ...
    def readBool(self, /) -> bool: ...
    def readBytes(self, len: int, /) -> typing.Tuple: ...
    def readDouble(self, /) -> float: ...
    def readFloat(self, /) -> float: ...
    def readInt16(self, /) -> int: ...
    def readInt32(self, /) -> int: ...
    def readInt64(self, /) -> int: ...
    def readInt8(self, /) -> int: ...
    def readQChar(self, /) -> str: ...
    def readQString(self, /) -> str: ...
    def readQStringList(self, /) -> typing.List[str]: ...
    def readQVariant(self, /) -> typing.Any: ...
    def readRawData(self, len: int, /) -> bytes: ...
    def readString(self, /) -> str: ...
    def readUInt16(self, /) -> int: ...
    def readUInt32(self, /) -> int: ...
    def readUInt64(self, /) -> int: ...
    def readUInt8(self, /) -> int: ...
    def resetStatus(self, /) -> None: ...
    def rollbackTransaction(self, /) -> None: ...
    def setByteOrder(self, arg__1: PySide6.QtCore.QDataStream.ByteOrder, /) -> None: ...
    def setDevice(self, arg__1: PySide6.QtCore.QIODevice, /) -> None: ...
    def setFloatingPointPrecision(self, precision: PySide6.QtCore.QDataStream.FloatingPointPrecision, /) -> None: ...
    def setStatus(self, status: PySide6.QtCore.QDataStream.Status, /) -> None: ...
    def setVersion(self, arg__1: int, /) -> None: ...
    def skipRawData(self, len: int, /) -> int: ...
    def startTransaction(self, /) -> None: ...
    def status(self, /) -> PySide6.QtCore.QDataStream.Status: ...
    def version(self, /) -> int: ...
    def writeBool(self, arg__1: bool, /) -> None: ...
    def writeBytes(self, arg__1: bytes | bytearray | memoryview, /) -> PySide6.QtCore.QDataStream: ...
    def writeDouble(self, arg__1: float, /) -> None: ...
    def writeFloat(self, arg__1: float, /) -> None: ...
    def writeInt16(self, arg__1: int, /) -> None: ...
    def writeInt32(self, arg__1: int, /) -> None: ...
    def writeInt64(self, arg__1: int, /) -> None: ...
    def writeInt8(self, arg__1: int, /) -> None: ...
    def writeQChar(self, arg__1: str, /) -> None: ...
    def writeQString(self, arg__1: str, /) -> None: ...
    def writeQStringList(self, arg__1: collections.abc.Sequence[str], /) -> None: ...
    def writeQVariant(self, arg__1: typing.Any, /) -> None: ...
    @typing.overload
    def writeRawData(self, arg__1: str, /) -> int: ...
    @typing.overload
    def writeRawData(self, arg__1: bytes | bytearray | memoryview, /) -> None: ...
    def writeString(self, arg__1: str, /) -> None: ...
    def writeUInt16(self, arg__1: int, /) -> None: ...
    def writeUInt32(self, arg__1: int, /) -> None: ...
    def writeUInt64(self, arg__1: int, /) -> None: ...
    def writeUInt8(self, arg__1: int, /) -> None: ...


class QDate(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QDate: PySide6.QtCore.QDate, /) -> None: ...
    @typing.overload
    def __init__(self, y: int, m: int, d: int, /) -> None: ...
    @typing.overload
    def __init__(self, y: int, m: int, d: int, cal: PySide6.QtCore.QCalendar, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QDate, /) -> bool: ...
    def __ge__(self, rhs: PySide6.QtCore.QDate, /) -> bool: ...
    def __gt__(self, rhs: PySide6.QtCore.QDate, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __le__(self, rhs: PySide6.QtCore.QDate, /) -> bool: ...
    def __lt__(self, rhs: PySide6.QtCore.QDate, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QDate, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def addDays(self, days: int, /) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def addMonths(self, months: int, /) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def addMonths(self, months: int, cal: PySide6.QtCore.QCalendar, /) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def addYears(self, years: int, /) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def addYears(self, years: int, cal: PySide6.QtCore.QCalendar, /) -> PySide6.QtCore.QDate: ...
    @staticmethod
    def currentDate() -> PySide6.QtCore.QDate: ...
    @typing.overload
    def day(self, /) -> int: ...
    @typing.overload
    def day(self, cal: PySide6.QtCore.QCalendar, /) -> int: ...
    @typing.overload
    def dayOfWeek(self, /) -> int: ...
    @typing.overload
    def dayOfWeek(self, cal: PySide6.QtCore.QCalendar, /) -> int: ...
    @typing.overload
    def dayOfYear(self, /) -> int: ...
    @typing.overload
    def dayOfYear(self, cal: PySide6.QtCore.QCalendar, /) -> int: ...
    @typing.overload
    def daysInMonth(self, /) -> int: ...
    @typing.overload
    def daysInMonth(self, cal: PySide6.QtCore.QCalendar, /) -> int: ...
    @typing.overload
    def daysInYear(self, /) -> int: ...
    @typing.overload
    def daysInYear(self, cal: PySide6.QtCore.QCalendar, /) -> int: ...
    def daysTo(self, d: PySide6.QtCore.QDate, /) -> int: ...
    @typing.overload
    def endOfDay(self, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def endOfDay(self, spec: PySide6.QtCore.Qt.TimeSpec, /, offsetSeconds: int | None = ...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def endOfDay(self, zone: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    @staticmethod
    def fromJulianDay(jd_: int, /) -> PySide6.QtCore.QDate: ...
    @typing.overload
    @staticmethod
    def fromString(string: str, /, format: PySide6.QtCore.Qt.DateFormat = ...) -> PySide6.QtCore.QDate: ...
    @typing.overload
    @staticmethod
    def fromString(string: str, format: str, cal: PySide6.QtCore.QCalendar, /) -> PySide6.QtCore.QDate: ...
    @typing.overload
    @staticmethod
    def fromString(string: str, format: str, /, baseYear: int = ...) -> PySide6.QtCore.QDate: ...
    @typing.overload
    @staticmethod
    def fromString(string: str, format: str, baseYear: int, cal: PySide6.QtCore.QCalendar, /) -> PySide6.QtCore.QDate: ...
    def getDate(self, /) -> typing.Tuple[int, int, int]: ...
    @staticmethod
    def isLeapYear(year: int, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def isValid(self, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def isValid(y: int, m: int, d: int, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload
    def month(self, /) -> int: ...
    @typing.overload
    def month(self, cal: PySide6.QtCore.QCalendar, /) -> int: ...
    @typing.overload
    def setDate(self, year: int, month: int, day: int, /) -> bool: ...
    @typing.overload
    def setDate(self, year: int, month: int, day: int, cal: PySide6.QtCore.QCalendar, /) -> bool: ...
    @typing.overload
    def startOfDay(self, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def startOfDay(self, spec: PySide6.QtCore.Qt.TimeSpec, /, offsetSeconds: int | None = ...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def startOfDay(self, zone: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    def toJulianDay(self, /) -> int: ...
    def toPython(self, /) -> object: ...
    @typing.overload
    def toString(self, /, format: PySide6.QtCore.Qt.DateFormat = ...) -> str: ...
    @typing.overload
    def toString(self, format: str, /) -> str: ...
    @typing.overload
    def toString(self, format: str, cal: PySide6.QtCore.QCalendar, /) -> str: ...
    def weekNumber(self, /) -> typing.Tuple[int, int]: ...
    @typing.overload
    def year(self, /) -> int: ...
    @typing.overload
    def year(self, cal: PySide6.QtCore.QCalendar, /) -> int: ...


class QDateTime(Shiboken.Object):

    class TransitionResolution(enum.Enum):

        Reject                    = 0x0
        LegacyBehavior            = 0x1
        RelativeToBefore          = 0x1
        RelativeToAfter           = 0x2
        PreferBefore              = 0x3
        PreferAfter               = 0x4
        PreferStandard            = 0x5
        PreferDaylightSaving      = 0x6

    class YearRange(enum.Enum):

        First                     = -292275056
        Last                      = 0x116bd2d2


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, date: PySide6.QtCore.QDate, time: PySide6.QtCore.QTime, spec: PySide6.QtCore.Qt.TimeSpec, /, offsetSeconds: int | None = ...) -> None: ...
    @typing.overload
    def __init__(self, date: PySide6.QtCore.QDate, time: PySide6.QtCore.QTime, /, resolve: PySide6.QtCore.QDateTime.TransitionResolution = ...) -> None: ...
    @typing.overload
    def __init__(self, date: PySide6.QtCore.QDate, time: PySide6.QtCore.QTime, timeZone: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /, resolve: PySide6.QtCore.QDateTime.TransitionResolution = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QDateTime, /) -> None: ...
    @typing.overload
    def __init__(self, year: int, month: int, day: int, h: int, m: int, s: int, /) -> None: ...
    @typing.overload
    def __init__(self, year: int, month: int, day: int, h: int, m: int, s: int, ms: int, spec: PySide6.QtCore.Qt.TimeSpec, /) -> None: ...
    @typing.overload
    def __init__(self, year: int, month: int, day: int, h: int, m: int, s: int, ms: int, /, spec: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization= ...) -> None: ...
    @typing.overload
    def __init__(self, year: int, month: int, day: int, h: int, m: int, s: int, ms: int, /, spec: int = ...) -> None: ...

    def __add__(self, duration: int, /) -> PySide6.QtCore.QDateTime: ...
    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QDateTime, /) -> bool: ...
    def __ge__(self, rhs: PySide6.QtCore.QDateTime, /) -> bool: ...
    def __gt__(self, rhs: PySide6.QtCore.QDateTime, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __iadd__(self, duration: int, /) -> PySide6.QtCore.QDateTime: ...
    def __isub__(self, duration: int, /) -> PySide6.QtCore.QDateTime: ...  # type: ignore[misc]
    def __le__(self, rhs: PySide6.QtCore.QDateTime, /) -> bool: ...
    def __lt__(self, rhs: PySide6.QtCore.QDateTime, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QDateTime, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    @typing.overload
    def __sub__(self, rhs: PySide6.QtCore.QDateTime, /) -> int: ...
    @typing.overload
    def __sub__(self, duration: int, /) -> PySide6.QtCore.QDateTime: ...
    def addDays(self, days: int, /) -> PySide6.QtCore.QDateTime: ...
    def addDuration(self, msecs: int, /) -> PySide6.QtCore.QDateTime: ...
    def addMSecs(self, msecs: int, /) -> PySide6.QtCore.QDateTime: ...
    def addMonths(self, months: int, /) -> PySide6.QtCore.QDateTime: ...
    def addSecs(self, secs: int, /) -> PySide6.QtCore.QDateTime: ...
    def addYears(self, years: int, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def currentDateTime() -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def currentDateTime(zone: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    @staticmethod
    def currentDateTimeUtc() -> PySide6.QtCore.QDateTime: ...
    @staticmethod
    def currentMSecsSinceEpoch() -> int: ...
    @staticmethod
    def currentSecsSinceEpoch() -> int: ...
    def date(self, /) -> PySide6.QtCore.QDate: ...
    def daysTo(self, arg__1: PySide6.QtCore.QDateTime, /) -> int: ...
    @typing.overload
    @staticmethod
    def fromMSecsSinceEpoch(msecs: int, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromMSecsSinceEpoch(msecs: int, spec: PySide6.QtCore.Qt.TimeSpec, /, offsetFromUtc: int | None = ...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromMSecsSinceEpoch(msecs: int, timeZone: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromSecsSinceEpoch(secs: int, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromSecsSinceEpoch(secs: int, spec: PySide6.QtCore.Qt.TimeSpec, /, offsetFromUtc: int | None = ...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromSecsSinceEpoch(secs: int, timeZone: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromString(string: str, /, format: PySide6.QtCore.Qt.DateFormat = ...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromString(string: str, format: str, cal: PySide6.QtCore.QCalendar, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromString(string: str, format: str, /, baseYear: int = ...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    @staticmethod
    def fromString(string: str, format: str, baseYear: int, cal: PySide6.QtCore.QCalendar, /) -> PySide6.QtCore.QDateTime: ...
    def isDaylightTime(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def msecsTo(self, arg__1: PySide6.QtCore.QDateTime, /) -> int: ...
    def offsetFromUtc(self, /) -> int: ...
    def secsTo(self, arg__1: PySide6.QtCore.QDateTime, /) -> int: ...
    def setDate(self, date: PySide6.QtCore.QDate, /, resolve: PySide6.QtCore.QDateTime.TransitionResolution = ...) -> None: ...
    def setMSecsSinceEpoch(self, msecs: int, /) -> None: ...
    def setOffsetFromUtc(self, offsetSeconds: int, /) -> None: ...
    def setSecsSinceEpoch(self, secs: int, /) -> None: ...
    def setTime(self, time: PySide6.QtCore.QTime, /, resolve: PySide6.QtCore.QDateTime.TransitionResolution = ...) -> None: ...
    def setTimeSpec(self, spec: PySide6.QtCore.Qt.TimeSpec, /) -> None: ...
    def setTimeZone(self, toZone: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /, resolve: PySide6.QtCore.QDateTime.TransitionResolution = ...) -> None: ...
    def swap(self, other: PySide6.QtCore.QDateTime, /) -> None: ...
    def time(self, /) -> PySide6.QtCore.QTime: ...
    def timeRepresentation(self, /) -> PySide6.QtCore.QTimeZone: ...
    def timeSpec(self, /) -> PySide6.QtCore.Qt.TimeSpec: ...
    def timeZone(self, /) -> PySide6.QtCore.QTimeZone: ...
    def timeZoneAbbreviation(self, /) -> str: ...
    def toLocalTime(self, /) -> PySide6.QtCore.QDateTime: ...
    def toMSecsSinceEpoch(self, /) -> int: ...
    def toOffsetFromUtc(self, offsetSeconds: int, /) -> PySide6.QtCore.QDateTime: ...
    def toPython(self, /) -> object: ...
    def toSecsSinceEpoch(self, /) -> int: ...
    @typing.overload
    def toString(self, /, format: PySide6.QtCore.Qt.DateFormat = ...) -> str: ...
    @typing.overload
    def toString(self, format: str, /) -> str: ...
    @typing.overload
    def toString(self, format: str, cal: PySide6.QtCore.QCalendar, /) -> str: ...
    def toTimeSpec(self, spec: PySide6.QtCore.Qt.TimeSpec, /) -> PySide6.QtCore.QDateTime: ...
    def toTimeZone(self, toZone: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    def toUTC(self, /) -> PySide6.QtCore.QDateTime: ...


class QDeadlineTimer(Shiboken.Object):

    Forever                   = 0x0

    class ForeverConstant(enum.Enum):

        Forever                   = 0x0


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QDeadlineTimer.ForeverConstant, /, type_: PySide6.QtCore.Qt.TimerType = ...) -> None: ...
    @typing.overload
    def __init__(self, QDeadlineTimer: PySide6.QtCore.QDeadlineTimer, /) -> None: ...
    @typing.overload
    def __init__(self, type_: PySide6.QtCore.Qt.TimerType, /) -> None: ...
    @typing.overload
    def __init__(self, msecs: int, /, type: PySide6.QtCore.Qt.TimerType = ...) -> None: ...

    def __add__(self, msecs: int, /) -> PySide6.QtCore.QDeadlineTimer: ...
    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> bool: ...
    def __ge__(self, rhs: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> bool: ...
    def __gt__(self, rhs: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> bool: ...
    def __iadd__(self, msecs: int, /) -> PySide6.QtCore.QDeadlineTimer: ...
    def __isub__(self, msecs: int, /) -> PySide6.QtCore.QDeadlineTimer: ...  # type: ignore[misc]
    def __le__(self, rhs: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> bool: ...
    def __lt__(self, rhs: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> bool: ...
    @typing.overload
    def __sub__(self, msecs: int, /) -> PySide6.QtCore.QDeadlineTimer: ...
    @typing.overload
    def __sub__(self, dt2: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> int: ...
    @staticmethod
    def addNSecs(dt: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, nsecs: int, /) -> PySide6.QtCore.QDeadlineTimer: ...
    @staticmethod
    def current(timerType: PySide6.QtCore.Qt.TimerType = ...) -> PySide6.QtCore.QDeadlineTimer: ...
    def deadline(self, /) -> int: ...
    def deadlineNSecs(self, /) -> int: ...
    def hasExpired(self, /) -> bool: ...
    def isForever(self, /) -> bool: ...
    def remainingTime(self, /) -> int: ...
    def remainingTimeNSecs(self, /) -> int: ...
    def setDeadline(self, msecs: int, /, timerType: PySide6.QtCore.Qt.TimerType = ...) -> None: ...
    def setPreciseDeadline(self, secs: int, /, nsecs: int | None = ..., type: PySide6.QtCore.Qt.TimerType = ...) -> None: ...
    def setPreciseRemainingTime(self, secs: int, /, nsecs: int | None = ..., type: PySide6.QtCore.Qt.TimerType = ...) -> None: ...
    def setRemainingTime(self, msecs: int, /, type: PySide6.QtCore.Qt.TimerType = ...) -> None: ...
    def setTimerType(self, type: PySide6.QtCore.Qt.TimerType, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> None: ...
    def timerType(self, /) -> PySide6.QtCore.Qt.TimerType: ...


class QDir(Shiboken.Object):

    class Filter(enum.Flag):

        NoFilter                  = -1
        Dirs                      = 0x1
        Files                     = 0x2
        Drives                    = 0x4
        AllEntries                = 0x7
        NoSymLinks                = 0x8
        TypeMask                  = 0xf
        Readable                  = 0x10
        Writable                  = 0x20
        Executable                = 0x40
        PermissionMask            = 0x70
        Modified                  = 0x80
        Hidden                    = 0x100
        System                    = 0x200
        AccessMask                = 0x3f0
        AllDirs                   = 0x400
        CaseSensitive             = 0x800
        NoDot                     = 0x2000
        NoDotDot                  = 0x4000
        NoDotAndDotDot            = 0x6000

    class SortFlag(enum.Flag):

        NoSort                    = -1
        Name                      = 0x0
        Time                      = 0x1
        Size                      = 0x2
        SortByMask                = 0x3
        Unsorted                  = 0x3
        DirsFirst                 = 0x4
        Reversed                  = 0x8
        IgnoreCase                = 0x10
        DirsLast                  = 0x20
        LocaleAware               = 0x40
        Type                      = 0x80


    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QDir, /) -> None: ...
    @typing.overload
    def __init__(self, path: str | bytes | os.PathLike[str], nameFilter: str, /, sort: PySide6.QtCore.QDir.SortFlag = ..., filter: PySide6.QtCore.QDir.Filter = ...) -> None: ...
    @typing.overload
    def __init__(self, /, path: str | bytes | os.PathLike[str] | None= ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QDir, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QDir, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def absoluteFilePath(self, fileName: str, /) -> str: ...
    def absolutePath(self, /) -> str: ...
    @staticmethod
    def addSearchPath(prefix: str, path: str | bytes | os.PathLike[str], /) -> None: ...
    def canonicalPath(self, /) -> str: ...
    def cd(self, dirName: str, /) -> bool: ...
    def cdUp(self, /) -> bool: ...
    @staticmethod
    def cleanPath(path: str, /) -> str: ...
    def count(self, /) -> int: ...
    @staticmethod
    def current() -> PySide6.QtCore.QDir: ...
    @staticmethod
    def currentPath() -> str: ...
    def dirName(self, /) -> str: ...
    @staticmethod
    def drives() -> typing.List[PySide6.QtCore.QFileInfo]: ...
    @typing.overload
    def entryInfoList(self, /, filters: PySide6.QtCore.QDir.Filter = ..., sort: PySide6.QtCore.QDir.SortFlag = ...) -> typing.List[PySide6.QtCore.QFileInfo]: ...
    @typing.overload
    def entryInfoList(self, nameFilters: collections.abc.Sequence[str], /, filters: PySide6.QtCore.QDir.Filter = ..., sort: PySide6.QtCore.QDir.SortFlag = ...) -> typing.List[PySide6.QtCore.QFileInfo]: ...
    @typing.overload
    def entryList(self, /, filters: PySide6.QtCore.QDir.Filter = ..., sort: PySide6.QtCore.QDir.SortFlag = ...) -> typing.List[str]: ...
    @typing.overload
    def entryList(self, nameFilters: collections.abc.Sequence[str], /, filters: PySide6.QtCore.QDir.Filter = ..., sort: PySide6.QtCore.QDir.SortFlag = ...) -> typing.List[str]: ...
    @typing.overload
    def exists(self, /) -> bool: ...
    @typing.overload
    def exists(self, name: str, /) -> bool: ...
    def filePath(self, fileName: str, /) -> str: ...
    def filter(self, /) -> PySide6.QtCore.QDir.Filter: ...
    @staticmethod
    def fromNativeSeparators(pathName: str, /) -> str: ...
    @staticmethod
    def home() -> PySide6.QtCore.QDir: ...
    @staticmethod
    def homePath() -> str: ...
    def isAbsolute(self, /) -> bool: ...
    @staticmethod
    def isAbsolutePath(path: str, /) -> bool: ...
    def isEmpty(self, /, filters: PySide6.QtCore.QDir.Filter = ...) -> bool: ...
    def isReadable(self, /) -> bool: ...
    def isRelative(self, /) -> bool: ...
    @staticmethod
    def isRelativePath(path: str, /) -> bool: ...
    def isRoot(self, /) -> bool: ...
    @staticmethod
    def listSeparator() -> str: ...
    def makeAbsolute(self, /) -> bool: ...
    @typing.overload
    @staticmethod
    def match(filter: str, fileName: str, /) -> bool: ...
    @typing.overload
    @staticmethod
    def match(filters: collections.abc.Sequence[str], fileName: str, /) -> bool: ...
    @typing.overload
    def mkdir(self, arg__1: str, /) -> bool: ...
    @typing.overload
    def mkdir(self, arg__1: str, arg__2: PySide6.QtCore.QFileDevice.Permission, /) -> bool: ...
    @typing.overload
    def mkpath(self, arg__1: str, /) -> bool: ...
    @typing.overload
    def mkpath(self, arg__1: str, arg__2: PySide6.QtCore.QFileDevice.Permission, /) -> bool: ...
    def nameFilters(self, /) -> typing.List[str]: ...
    @staticmethod
    def nameFiltersFromString(nameFilter: str, /) -> typing.List[str]: ...
    def path(self, /) -> str: ...
    def refresh(self, /) -> None: ...
    def relativeFilePath(self, fileName: str, /) -> str: ...
    def remove(self, fileName: str, /) -> bool: ...
    def removeRecursively(self, /) -> bool: ...
    def rename(self, oldName: str, newName: str, /) -> bool: ...
    def rmdir(self, dirName: str, /) -> bool: ...
    def rmpath(self, dirPath: str, /) -> bool: ...
    @staticmethod
    def root() -> PySide6.QtCore.QDir: ...
    @staticmethod
    def rootPath() -> str: ...
    @staticmethod
    def searchPaths(prefix: str, /) -> typing.List[str]: ...
    @staticmethod
    def separator() -> str: ...
    @staticmethod
    def setCurrent(path: str, /) -> bool: ...
    def setFilter(self, filter: PySide6.QtCore.QDir.Filter, /) -> None: ...
    def setNameFilters(self, nameFilters: collections.abc.Sequence[str], /) -> None: ...
    def setPath(self, path: str | bytes | os.PathLike[str], /) -> None: ...
    @staticmethod
    def setSearchPaths(prefix: str, searchPaths: collections.abc.Sequence[str], /) -> None: ...
    def setSorting(self, sort: PySide6.QtCore.QDir.SortFlag, /) -> None: ...
    def sorting(self, /) -> PySide6.QtCore.QDir.SortFlag: ...
    def swap(self, other: PySide6.QtCore.QDir, /) -> None: ...
    @staticmethod
    def temp() -> PySide6.QtCore.QDir: ...
    @staticmethod
    def tempPath() -> str: ...
    @staticmethod
    def toNativeSeparators(pathName: str, /) -> str: ...


class QDirIterator(Shiboken.Object):

    class IteratorFlag(enum.Flag):

        NoIteratorFlags           = 0x0
        FollowSymlinks            = 0x1
        Subdirectories            = 0x2


    @typing.overload
    def __init__(self, dir: PySide6.QtCore.QDir, /, flags: PySide6.QtCore.QDirIterator.IteratorFlag = ...) -> None: ...
    @typing.overload
    def __init__(self, path: str, filter: PySide6.QtCore.QDir.Filter, /, flags: PySide6.QtCore.QDirIterator.IteratorFlag = ...) -> None: ...
    @typing.overload
    def __init__(self, path: str, /, flags: PySide6.QtCore.QDirIterator.IteratorFlag = ...) -> None: ...
    @typing.overload
    def __init__(self, path: str, nameFilters: collections.abc.Sequence[str], /, filters: PySide6.QtCore.QDir.Filter = ..., flags: PySide6.QtCore.QDirIterator.IteratorFlag = ...) -> None: ...

    def fileInfo(self, /) -> PySide6.QtCore.QFileInfo: ...
    def fileName(self, /) -> str: ...
    def filePath(self, /) -> str: ...
    def hasNext(self, /) -> bool: ...
    def next(self, /) -> str: ...
    def nextFileInfo(self, /) -> PySide6.QtCore.QFileInfo: ...
    def path(self, /) -> str: ...


class QDirListing(Shiboken.Object):

    class DirEntry(Shiboken.Object):

        @typing.overload
        def __init__(self, /) -> None: ...
        @typing.overload
        def __init__(self, DirEntry: PySide6.QtCore.QDirListing.DirEntry, /) -> None: ...

        def __copy__(self, /) -> typing.Self: ...
        def __repr__(self, /) -> str: ...
        def absoluteFilePath(self, /) -> str: ...
        def absolutePath(self, /) -> str: ...
        def baseName(self, /) -> str: ...
        def birthTime(self, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
        def bundleName(self, /) -> str: ...
        def canonicalFilePath(self, /) -> str: ...
        def completeBaseName(self, /) -> str: ...
        def completeSuffix(self, /) -> str: ...
        def exists(self, /) -> bool: ...
        def fileInfo(self, /) -> PySide6.QtCore.QFileInfo: ...
        def fileName(self, /) -> str: ...
        def filePath(self, /) -> str: ...
        def fileTime(self, type: PySide6.QtCore.QFileDevice.FileTime, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
        def isDir(self, /) -> bool: ...
        def isExecutable(self, /) -> bool: ...
        def isFile(self, /) -> bool: ...
        def isHidden(self, /) -> bool: ...
        def isReadable(self, /) -> bool: ...
        def isSymLink(self, /) -> bool: ...
        def isWritable(self, /) -> bool: ...
        def lastModified(self, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
        def lastRead(self, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
        def metadataChangeTime(self, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
        def size(self, /) -> int: ...
        def suffix(self, /) -> str: ...

    class IteratorFlag(enum.Flag):

        Default                   = 0x0
        ExcludeFiles              = 0x4
        ExcludeDirs               = 0x8
        ExcludeOther              = 0x10
        ExcludeSpecial            = 0x10
        DirsOnly                  = 0x14
        FilesOnly                 = 0x18
        ResolveSymlinks           = 0x20
        IncludeHidden             = 0x40
        IncludeDotAndDotDot       = 0x80
        CaseSensitive             = 0x100
        Recursive                 = 0x400
        FollowDirSymlinks         = 0x800


    @typing.overload
    def __init__(self, path: str, /, flags: PySide6.QtCore.QDirListing.IteratorFlag = ...) -> None: ...
    @typing.overload
    def __init__(self, path: str, nameFilters: collections.abc.Sequence[str], /, flags: PySide6.QtCore.QDirListing.IteratorFlag = ...) -> None: ...

    def __iter__(self, /) -> object: ...
    def iteratorFlags(self, /) -> PySide6.QtCore.QDirListing.IteratorFlag: ...
    def iteratorPath(self, /) -> str: ...
    def nameFilters(self, /) -> typing.List[str]: ...
    def swap(self, other: PySide6.QtCore.QDirListing, /) -> None: ...


class QDirListingIterator(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, dl: PySide6.QtCore.QDirListing, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QDirListingIterator, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __iter__(self, /) -> object: ...
    def __next__(self, /) -> object: ...
    def atEnd(self, /) -> bool: ...
    def next(self, /) -> bool: ...
    def value(self, /) -> PySide6.QtCore.QDirListing.DirEntry: ...


class QDynamicPropertyChangeEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QDynamicPropertyChangeEvent, /) -> None: ...
    @typing.overload
    def __init__(self, name: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...

    def clone(self, /) -> PySide6.QtCore.QDynamicPropertyChangeEvent: ...
    def propertyName(self, /) -> PySide6.QtCore.QByteArray: ...


class QEasingCurve(Shiboken.Object):

    class Type(enum.Enum):

        Linear                    = 0x0
        InQuad                    = 0x1
        OutQuad                   = 0x2
        InOutQuad                 = 0x3
        OutInQuad                 = 0x4
        InCubic                   = 0x5
        OutCubic                  = 0x6
        InOutCubic                = 0x7
        OutInCubic                = 0x8
        InQuart                   = 0x9
        OutQuart                  = 0xa
        InOutQuart                = 0xb
        OutInQuart                = 0xc
        InQuint                   = 0xd
        OutQuint                  = 0xe
        InOutQuint                = 0xf
        OutInQuint                = 0x10
        InSine                    = 0x11
        OutSine                   = 0x12
        InOutSine                 = 0x13
        OutInSine                 = 0x14
        InExpo                    = 0x15
        OutExpo                   = 0x16
        InOutExpo                 = 0x17
        OutInExpo                 = 0x18
        InCirc                    = 0x19
        OutCirc                   = 0x1a
        InOutCirc                 = 0x1b
        OutInCirc                 = 0x1c
        InElastic                 = 0x1d
        OutElastic                = 0x1e
        InOutElastic              = 0x1f
        OutInElastic              = 0x20
        InBack                    = 0x21
        OutBack                   = 0x22
        InOutBack                 = 0x23
        OutInBack                 = 0x24
        InBounce                  = 0x25
        OutBounce                 = 0x26
        InOutBounce               = 0x27
        OutInBounce               = 0x28
        InCurve                   = 0x29
        OutCurve                  = 0x2a
        SineCurve                 = 0x2b
        CosineCurve               = 0x2c
        BezierSpline              = 0x2d
        TCBSpline                 = 0x2e
        Custom                    = 0x2f
        NCurveTypes               = 0x30


    @typing.overload
    def __init__(self, other: PySide6.QtCore.QEasingCurve, /) -> None: ...
    @typing.overload
    def __init__(self, /, type: PySide6.QtCore.QEasingCurve.Type = ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QEasingCurve | PySide6.QtCore.QEasingCurve.Type, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QEasingCurve | PySide6.QtCore.QEasingCurve.Type, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def addCubicBezierSegment(self, c1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, c2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, endPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def addTCBSegment(self, nextPoint: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, t: float, c: float, b: float, /) -> None: ...
    def amplitude(self, /) -> float: ...
    def customType(self, /) -> object: ...
    def overshoot(self, /) -> float: ...
    def period(self, /) -> float: ...
    def setAmplitude(self, amplitude: float, /) -> None: ...
    def setCustomType(self, callable: object, /) -> None: ...
    def setOvershoot(self, overshoot: float, /) -> None: ...
    def setPeriod(self, period: float, /) -> None: ...
    def setType(self, type: PySide6.QtCore.QEasingCurve.Type, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QEasingCurve | PySide6.QtCore.QEasingCurve.Type, /) -> None: ...
    def toCubicSpline(self, /) -> typing.List[PySide6.QtCore.QPointF]: ...
    def type(self, /) -> PySide6.QtCore.QEasingCurve.Type: ...
    def valueForProgress(self, progress: float, /) -> float: ...


class QElapsedTimer(Shiboken.Object):

    class ClockType(enum.Enum):

        SystemTime                = 0x0
        MonotonicClock            = 0x1
        TickCounter               = 0x2
        MachAbsoluteTime          = 0x3
        PerformanceCounter        = 0x4


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QElapsedTimer: PySide6.QtCore.QElapsedTimer, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QElapsedTimer, /) -> bool: ...
    def __ge__(self, rhs: PySide6.QtCore.QElapsedTimer, /) -> bool: ...
    def __gt__(self, rhs: PySide6.QtCore.QElapsedTimer, /) -> bool: ...
    def __le__(self, rhs: PySide6.QtCore.QElapsedTimer, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QElapsedTimer, /) -> bool: ...
    @staticmethod
    def clockType() -> PySide6.QtCore.QElapsedTimer.ClockType: ...
    def elapsed(self, /) -> int: ...
    def hasExpired(self, timeout: int, /) -> bool: ...
    def invalidate(self, /) -> None: ...
    @staticmethod
    def isMonotonic() -> bool: ...
    def isValid(self, /) -> bool: ...
    def msecsSinceReference(self, /) -> int: ...
    def msecsTo(self, other: PySide6.QtCore.QElapsedTimer, /) -> int: ...
    def nsecsElapsed(self, /) -> int: ...
    def restart(self, /) -> int: ...
    def secsTo(self, other: PySide6.QtCore.QElapsedTimer, /) -> int: ...
    def start(self, /) -> None: ...


class QEvent(Shiboken.Object):

    class Type(enum.IntEnum):

        None_                     = 0x0
        Timer                     = 0x1
        MouseButtonPress          = 0x2
        MouseButtonRelease        = 0x3
        MouseButtonDblClick       = 0x4
        MouseMove                 = 0x5
        KeyPress                  = 0x6
        KeyRelease                = 0x7
        FocusIn                   = 0x8
        FocusOut                  = 0x9
        Enter                     = 0xa
        Leave                     = 0xb
        Paint                     = 0xc
        Move                      = 0xd
        Resize                    = 0xe
        Create                    = 0xf
        Destroy                   = 0x10
        Show                      = 0x11
        Hide                      = 0x12
        Close                     = 0x13
        Quit                      = 0x14
        ParentChange              = 0x15
        ThreadChange              = 0x16
        FocusAboutToChange        = 0x17
        WindowActivate            = 0x18
        WindowDeactivate          = 0x19
        ShowToParent              = 0x1a
        HideToParent              = 0x1b
        Wheel                     = 0x1f
        WindowTitleChange         = 0x21
        WindowIconChange          = 0x22
        ApplicationWindowIconChange = 0x23
        ApplicationFontChange     = 0x24
        ApplicationLayoutDirectionChange = 0x25
        ApplicationPaletteChange  = 0x26
        PaletteChange             = 0x27
        Clipboard                 = 0x28
        Speech                    = 0x2a
        MetaCall                  = 0x2b
        SockAct                   = 0x32
        ShortcutOverride          = 0x33
        DeferredDelete            = 0x34
        DragEnter                 = 0x3c
        DragMove                  = 0x3d
        DragLeave                 = 0x3e
        Drop                      = 0x3f
        DragResponse              = 0x40
        ChildAdded                = 0x44
        ChildPolished             = 0x45
        ChildRemoved              = 0x47
        ShowWindowRequest         = 0x49
        PolishRequest             = 0x4a
        Polish                    = 0x4b
        LayoutRequest             = 0x4c
        UpdateRequest             = 0x4d
        UpdateLater               = 0x4e
        EmbeddingControl          = 0x4f
        ActivateControl           = 0x50
        DeactivateControl         = 0x51
        ContextMenu               = 0x52
        InputMethod               = 0x53
        TabletMove                = 0x57
        LocaleChange              = 0x58
        LanguageChange            = 0x59
        LayoutDirectionChange     = 0x5a
        Style                     = 0x5b
        TabletPress               = 0x5c
        TabletRelease             = 0x5d
        OkRequest                 = 0x5e
        HelpRequest               = 0x5f
        IconDrag                  = 0x60
        FontChange                = 0x61
        EnabledChange             = 0x62
        ActivationChange          = 0x63
        StyleChange               = 0x64
        IconTextChange            = 0x65
        ModifiedChange            = 0x66
        WindowBlocked             = 0x67
        WindowUnblocked           = 0x68
        WindowStateChange         = 0x69
        ReadOnlyChange            = 0x6a
        MouseTrackingChange       = 0x6d
        ToolTip                   = 0x6e
        WhatsThis                 = 0x6f
        StatusTip                 = 0x70
        ActionChanged             = 0x71
        ActionAdded               = 0x72
        ActionRemoved             = 0x73
        FileOpen                  = 0x74
        Shortcut                  = 0x75
        WhatsThisClicked          = 0x76
        ToolBarChange             = 0x78
        ApplicationActivate       = 0x79
        ApplicationActivated      = 0x79
        ApplicationDeactivate     = 0x7a
        ApplicationDeactivated    = 0x7a
        QueryWhatsThis            = 0x7b
        EnterWhatsThisMode        = 0x7c
        LeaveWhatsThisMode        = 0x7d
        ZOrderChange              = 0x7e
        HoverEnter                = 0x7f
        HoverLeave                = 0x80
        HoverMove                 = 0x81
        ParentAboutToChange       = 0x83
        WinEventAct               = 0x84
        AcceptDropsChange         = 0x98
        ZeroTimerEvent            = 0x9a
        GraphicsSceneMouseMove    = 0x9b
        GraphicsSceneMousePress   = 0x9c
        GraphicsSceneMouseRelease = 0x9d
        GraphicsSceneMouseDoubleClick = 0x9e
        GraphicsSceneContextMenu  = 0x9f
        GraphicsSceneHoverEnter   = 0xa0
        GraphicsSceneHoverMove    = 0xa1
        GraphicsSceneHoverLeave   = 0xa2
        GraphicsSceneHelp         = 0xa3
        GraphicsSceneDragEnter    = 0xa4
        GraphicsSceneDragMove     = 0xa5
        GraphicsSceneDragLeave    = 0xa6
        GraphicsSceneDrop         = 0xa7
        GraphicsSceneWheel        = 0xa8
        KeyboardLayoutChange      = 0xa9
        DynamicPropertyChange     = 0xaa
        TabletEnterProximity      = 0xab
        TabletLeaveProximity      = 0xac
        NonClientAreaMouseMove    = 0xad
        NonClientAreaMouseButtonPress = 0xae
        NonClientAreaMouseButtonRelease = 0xaf
        NonClientAreaMouseButtonDblClick = 0xb0
        MacSizeChange             = 0xb1
        ContentsRectChange        = 0xb2
        MacGLWindowChange         = 0xb3
        FutureCallOut             = 0xb4
        GraphicsSceneResize       = 0xb5
        GraphicsSceneMove         = 0xb6
        CursorChange              = 0xb7
        ToolTipChange             = 0xb8
        NetworkReplyUpdated       = 0xb9
        GrabMouse                 = 0xba
        UngrabMouse               = 0xbb
        GrabKeyboard              = 0xbc
        UngrabKeyboard            = 0xbd
        StateMachineSignal        = 0xc0
        StateMachineWrapped       = 0xc1
        TouchBegin                = 0xc2
        TouchUpdate               = 0xc3
        TouchEnd                  = 0xc4
        NativeGesture             = 0xc5
        Gesture                   = 0xc6
        RequestSoftwareInputPanel = 0xc7
        CloseSoftwareInputPanel   = 0xc8
        GestureOverride           = 0xca
        WinIdChange               = 0xcb
        ScrollPrepare             = 0xcc
        Scroll                    = 0xcd
        Expose                    = 0xce
        InputMethodQuery          = 0xcf
        OrientationChange         = 0xd0
        TouchCancel               = 0xd1
        ThemeChange               = 0xd2
        SockClose                 = 0xd3
        PlatformPanel             = 0xd4
        StyleAnimationUpdate      = 0xd5
        ApplicationStateChange    = 0xd6
        WindowChangeInternal      = 0xd7
        ScreenChangeInternal      = 0xd8
        PlatformSurface           = 0xd9
        Pointer                   = 0xda
        TabletTrackingChange      = 0xdb
        GraphicsSceneLeave        = 0xdc
        WindowAboutToChangeInternal = 0xdd
        DevicePixelRatioChange    = 0xde
        ChildWindowAdded          = 0xdf
        ChildWindowRemoved        = 0xe0
        ParentWindowAboutToChange = 0xe1
        ParentWindowChange        = 0xe2
        SafeAreaMarginsChange     = 0xe3
        User                      = 0x3e8
        MaxUser                   = 0xffff


    @typing.overload
    def __init__(self, type: PySide6.QtCore.QEvent.Type, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QEvent, /) -> None: ...

    def __repr__(self, /) -> str: ...
    def accept(self, /) -> None: ...
    def clone(self, /) -> PySide6.QtCore.QEvent: ...
    def ignore(self, /) -> None: ...
    def isAccepted(self, /) -> bool: ...
    def isInputEvent(self, /) -> bool: ...
    def isPointerEvent(self, /) -> bool: ...
    def isSinglePointEvent(self, /) -> bool: ...
    @staticmethod
    def registerEventType(hint: int = ...) -> int: ...
    def setAccepted(self, accepted: bool, /) -> None: ...
    def spontaneous(self, /) -> bool: ...
    def type(self, /) -> PySide6.QtCore.QEvent.Type: ...


class QEventLoop(PySide6.QtCore.QObject):

    class ProcessEventsFlag(enum.Flag):

        AllEvents                 = 0x0
        ExcludeUserInputEvents    = 0x1
        ExcludeSocketNotifiers    = 0x2
        WaitForMoreEvents         = 0x4
        X11ExcludeTimers          = 0x8
        EventLoopExec             = 0x20
        DialogExec                = 0x40
        ApplicationExec           = 0x80


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def exec(self, /, flags: PySide6.QtCore.QEventLoop.ProcessEventsFlag = ...) -> int: ...
    def exec_(self, /, flags: PySide6.QtCore.QEventLoop.ProcessEventsFlag = ...) -> int: ...
    def exit(self, /, returnCode: int | None = ...) -> None: ...
    def isRunning(self, /) -> bool: ...
    @typing.overload
    def processEvents(self, /, flags: PySide6.QtCore.QEventLoop.ProcessEventsFlag = ...) -> bool: ...
    @typing.overload
    def processEvents(self, flags: PySide6.QtCore.QEventLoop.ProcessEventsFlag, maximumTime: int, /) -> None: ...
    @typing.overload
    def processEvents(self, flags: PySide6.QtCore.QEventLoop.ProcessEventsFlag, deadline: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> None: ...
    def quit(self, /) -> None: ...
    def wakeUp(self, /) -> None: ...


class QFactoryInterface(Shiboken.Object):

    def __init__(self, /) -> None: ...

    def keys(self, /) -> typing.List[str]: ...


class QFile(PySide6.QtCore.QFileDevice):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject, /) -> None: ...
    @typing.overload
    def __init__(self, name: str | bytes | os.PathLike[str], /) -> None: ...
    @typing.overload
    def __init__(self, name: str | bytes | os.PathLike[str], parent: PySide6.QtCore.QObject, /) -> None: ...

    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def copy(self, newName: str | bytes | os.PathLike[str], /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def copy(fileName: str, newName: str, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload
    @staticmethod
    def decodeName(localFileName: bytes | bytearray | memoryview, /) -> str: ...
    @typing.overload
    @staticmethod
    def decodeName(localFileName: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> str: ...
    @staticmethod
    def encodeName(fileName: str, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def exists(self, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def exists(fileName: str, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    def fileName(self, /) -> str: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def link(self, newName: str | bytes | os.PathLike[str], /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def link(fileName: str, newName: str, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def moveToTrash(self, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def moveToTrash(fileName: str, /) -> typing.Tuple[bool, str]: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload
    def open(self, flags: PySide6.QtCore.QIODeviceBase.OpenModeFlag, /) -> bool: ...
    @typing.overload
    def open(self, flags: PySide6.QtCore.QIODeviceBase.OpenModeFlag, permissions: PySide6.QtCore.QFileDevice.Permission, /) -> bool: ...
    @typing.overload
    def open(self, fd: int, ioFlags: PySide6.QtCore.QIODeviceBase.OpenModeFlag, /, handleFlags: PySide6.QtCore.QFileDevice.FileHandleFlag = ...) -> bool: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def permissions(self, /) -> PySide6.QtCore.QFileDevice.Permission: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def permissions(filename: str | bytes | os.PathLike[str], /) -> PySide6.QtCore.QFileDevice.Permission: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def remove(self, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def remove(fileName: str, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def rename(self, newName: str | bytes | os.PathLike[str], /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def rename(oldName: str, newName: str, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def resize(self, sz: int, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def resize(filename: str, sz: int, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    def setFileName(self, name: str | bytes | os.PathLike[str], /) -> None: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def setPermissions(self, permissionSpec: PySide6.QtCore.QFileDevice.Permission, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def setPermissions(filename: str | bytes | os.PathLike[str], permissionSpec: PySide6.QtCore.QFileDevice.Permission, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    def size(self, /) -> int: ...
    @staticmethod
    def supportsMoveToTrash() -> bool: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def symLinkTarget(self, /) -> str: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def symLinkTarget(fileName: str, /) -> str: ...  # type: ignore[misc, overload-cannot-match]


class QFileDevice(PySide6.QtCore.QIODevice):

    class FileError(enum.Enum):

        NoError                   = 0x0
        ReadError                 = 0x1
        WriteError                = 0x2
        FatalError                = 0x3
        ResourceError             = 0x4
        OpenError                 = 0x5
        AbortError                = 0x6
        TimeOutError              = 0x7
        UnspecifiedError          = 0x8
        RemoveError               = 0x9
        RenameError               = 0xa
        PositionError             = 0xb
        ResizeError               = 0xc
        PermissionsError          = 0xd
        CopyError                 = 0xe

    class FileHandleFlag(enum.Flag):

        DontCloseHandle           = 0x0
        AutoCloseHandle           = 0x1

    class FileTime(enum.Enum):

        FileAccessTime            = 0x0
        FileBirthTime             = 0x1
        FileMetadataChangeTime    = 0x2
        FileModificationTime      = 0x3

    class MemoryMapFlag(enum.Flag):

        NoOptions                 = 0x0
        MapPrivateOption          = 0x1

    class Permission(enum.Flag):

        ExeOther                  = 0x1
        WriteOther                = 0x2
        ReadOther                 = 0x4
        ExeGroup                  = 0x10
        WriteGroup                = 0x20
        ReadGroup                 = 0x40
        ExeUser                   = 0x100
        WriteUser                 = 0x200
        ReadUser                  = 0x400
        ExeOwner                  = 0x1000
        WriteOwner                = 0x2000
        ReadOwner                 = 0x4000


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject, /) -> None: ...

    def atEnd(self, /) -> bool: ...
    def close(self, /) -> None: ...
    def error(self, /) -> PySide6.QtCore.QFileDevice.FileError: ...
    def fileName(self, /) -> str: ...
    def fileTime(self, time: PySide6.QtCore.QFileDevice.FileTime, /) -> PySide6.QtCore.QDateTime: ...
    def flush(self, /) -> bool: ...
    def handle(self, /) -> int: ...
    def isSequential(self, /) -> bool: ...
    def map(self, offset: int, size: int, /, flags: PySide6.QtCore.QFileDevice.MemoryMapFlag = ...) -> object: ...
    def permissions(self, /) -> PySide6.QtCore.QFileDevice.Permission: ...
    def pos(self, /) -> int: ...
    def readData(self, maxlen: int, /) -> object: ...
    def readLineData(self, maxlen: int, /) -> object: ...
    def resize(self, sz: int, /) -> bool: ...
    def seek(self, offset: int, /) -> bool: ...
    def setFileTime(self, newDate: PySide6.QtCore.QDateTime, fileTime: PySide6.QtCore.QFileDevice.FileTime, /) -> bool: ...
    def setPermissions(self, permissionSpec: PySide6.QtCore.QFileDevice.Permission, /) -> bool: ...
    def size(self, /) -> int: ...
    def unmap(self, address: bytes | bytearray | memoryview, /) -> bool: ...
    def unsetError(self, /) -> None: ...
    def writeData(self, data: bytes | bytearray | memoryview, len: int, /) -> int: ...


class QFileInfo(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, file: PySide6.QtCore.QFileDevice, /) -> None: ...
    @typing.overload
    def __init__(self, dir: PySide6.QtCore.QDir, file: str | bytes | os.PathLike[str], /) -> None: ...
    @typing.overload
    def __init__(self, fileinfo: PySide6.QtCore.QFileInfo, /) -> None: ...
    @typing.overload
    def __init__(self, file: str | bytes | os.PathLike[str], /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QFileInfo, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QFileInfo, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def absoluteDir(self, /) -> PySide6.QtCore.QDir: ...
    def absoluteFilePath(self, /) -> str: ...
    def absolutePath(self, /) -> str: ...
    def baseName(self, /) -> str: ...
    @typing.overload
    def birthTime(self, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def birthTime(self, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    def bundleName(self, /) -> str: ...
    def caching(self, /) -> bool: ...
    def canonicalFilePath(self, /) -> str: ...
    def canonicalPath(self, /) -> str: ...
    def completeBaseName(self, /) -> str: ...
    def completeSuffix(self, /) -> str: ...
    def dir(self, /) -> PySide6.QtCore.QDir: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def exists(self, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def exists(file: str, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    def fileName(self, /) -> str: ...
    def filePath(self, /) -> str: ...
    @typing.overload
    def fileTime(self, time: PySide6.QtCore.QFileDevice.FileTime, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def fileTime(self, time: PySide6.QtCore.QFileDevice.FileTime, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    def group(self, /) -> str: ...
    def groupId(self, /) -> int: ...
    def isAbsolute(self, /) -> bool: ...
    def isAlias(self, /) -> bool: ...
    def isBundle(self, /) -> bool: ...
    def isDir(self, /) -> bool: ...
    def isExecutable(self, /) -> bool: ...
    def isFile(self, /) -> bool: ...
    def isHidden(self, /) -> bool: ...
    def isJunction(self, /) -> bool: ...
    def isNativePath(self, /) -> bool: ...
    def isOther(self, /) -> bool: ...
    def isReadable(self, /) -> bool: ...
    def isRelative(self, /) -> bool: ...
    def isRoot(self, /) -> bool: ...
    def isShortcut(self, /) -> bool: ...
    def isSymLink(self, /) -> bool: ...
    def isSymbolicLink(self, /) -> bool: ...
    def isWritable(self, /) -> bool: ...
    def junctionTarget(self, /) -> str: ...
    @typing.overload
    def lastModified(self, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def lastModified(self, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def lastRead(self, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def lastRead(self, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    def makeAbsolute(self, /) -> bool: ...
    @typing.overload
    def metadataChangeTime(self, /) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def metadataChangeTime(self, tz: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> PySide6.QtCore.QDateTime: ...
    def owner(self, /) -> str: ...
    def ownerId(self, /) -> int: ...
    def path(self, /) -> str: ...
    def permission(self, permissions: PySide6.QtCore.QFileDevice.Permission, /) -> bool: ...
    def permissions(self, /) -> PySide6.QtCore.QFileDevice.Permission: ...
    def readSymLink(self, /) -> str: ...
    def refresh(self, /) -> None: ...
    def setCaching(self, on: bool, /) -> None: ...
    @typing.overload
    def setFile(self, file: PySide6.QtCore.QFileDevice, /) -> None: ...
    @typing.overload
    def setFile(self, dir: PySide6.QtCore.QDir, file: str, /) -> None: ...
    @typing.overload
    def setFile(self, file: str | bytes | os.PathLike[str], /) -> None: ...
    def size(self, /) -> int: ...
    def stat(self, /) -> None: ...
    def suffix(self, /) -> str: ...
    def swap(self, other: PySide6.QtCore.QFileInfo, /) -> None: ...
    def symLinkTarget(self, /) -> str: ...


class QFileSelector(PySide6.QtCore.QObject):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def allSelectors(self, /) -> typing.List[str]: ...
    def extraSelectors(self, /) -> typing.List[str]: ...
    @typing.overload
    def select(self, filePath: str, /) -> str: ...
    @typing.overload
    def select(self, filePath: PySide6.QtCore.QUrl | str, /) -> PySide6.QtCore.QUrl: ...
    def setExtraSelectors(self, list: collections.abc.Sequence[str], /) -> None: ...


class QFileSystemWatcher(PySide6.QtCore.QObject):

    directoryChanged         : typing.ClassVar[Signal] = ... # directoryChanged(QString)
    fileChanged              : typing.ClassVar[Signal] = ... # fileChanged(QString)

    @typing.overload
    def __init__(self, paths: collections.abc.Sequence[str], /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def addPath(self, file: str, /) -> bool: ...
    def addPaths(self, files: collections.abc.Sequence[str], /) -> typing.List[str]: ...
    def directories(self, /) -> typing.List[str]: ...
    def files(self, /) -> typing.List[str]: ...
    def removePath(self, file: str, /) -> bool: ...
    def removePaths(self, files: collections.abc.Sequence[str], /) -> typing.List[str]: ...


class QFutureInterfaceBase(Shiboken.Object):

    class CancelMode(enum.Enum):

        CancelOnly                = 0x0
        CancelAndFinish           = 0x1

    class ContinuationType(enum.Enum):

        Unknown                   = 0x0
        Then                      = 0x1
        OnFailed                  = 0x2
        OnCanceled                = 0x3

    class State(enum.Enum):

        NoState                   = 0x0
        Running                   = 0x1
        Started                   = 0x2
        Finished                  = 0x4
        Canceled                  = 0x8
        Suspending                = 0x10
        Suspended                 = 0x20
        Throttled                 = 0x40
        Pending                   = 0x80


    @typing.overload
    def __init__(self, other: PySide6.QtCore.QFutureInterfaceBase, /) -> None: ...
    @typing.overload
    def __init__(self, /, initialState: PySide6.QtCore.QFutureInterfaceBase.State = ...) -> None: ...

    def __eq__(self, other: PySide6.QtCore.QFutureInterfaceBase, /) -> bool: ...
    def __ne__(self, other: PySide6.QtCore.QFutureInterfaceBase, /) -> bool: ...
    @typing.overload
    def cancel(self, /) -> None: ...
    @typing.overload
    def cancel(self, mode: PySide6.QtCore.QFutureInterfaceBase.CancelMode, /) -> None: ...
    def cancelAndFinish(self, /) -> None: ...
    @typing.overload
    def cancelChain(self, /) -> None: ...
    @typing.overload
    def cancelChain(self, mode: PySide6.QtCore.QFutureInterfaceBase.CancelMode, /) -> None: ...
    def cleanContinuation(self, /) -> None: ...
    def derefT(self, /) -> bool: ...
    def expectedResultCount(self, /) -> int: ...
    def hasException(self, /) -> bool: ...
    def isCanceled(self, /) -> bool: ...
    def isChainCanceled(self, /) -> bool: ...
    def isFinished(self, /) -> bool: ...
    def isPaused(self, /) -> bool: ...
    def isProgressUpdateNeeded(self, /) -> bool: ...
    def isResultReadyAt(self, index: int, /) -> bool: ...
    def isRunning(self, /) -> bool: ...
    def isRunningOrPending(self, /) -> bool: ...
    def isStarted(self, /) -> bool: ...
    def isSuspended(self, /) -> bool: ...
    def isSuspending(self, /) -> bool: ...
    def isThrottled(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def launchAsync(self, /) -> bool: ...
    def loadState(self, /) -> int: ...
    def mutex(self, /) -> PySide6.QtCore.QMutex: ...
    def progressMaximum(self, /) -> int: ...
    def progressMinimum(self, /) -> int: ...
    def progressText(self, /) -> str: ...
    def progressValue(self, /) -> int: ...
    def queryState(self, state: PySide6.QtCore.QFutureInterfaceBase.State, /) -> bool: ...
    def refT(self, /) -> bool: ...
    def reportCanceled(self, /) -> None: ...
    def reportFinished(self, /) -> None: ...
    def reportResultsReady(self, beginIndex: int, endIndex: int, /) -> None: ...
    def reportStarted(self, /) -> None: ...
    def reportSuspended(self, /) -> None: ...
    def reset(self, /) -> None: ...
    def resultCount(self, /) -> int: ...
    def rethrowPossibleException(self, /) -> None: ...
    def runContinuation(self, /) -> None: ...
    def setExpectedResultCount(self, resultCount: int, /) -> None: ...
    def setFilterMode(self, enable: bool, /) -> None: ...
    def setLaunchAsync(self, value: bool, /) -> None: ...
    def setPaused(self, paused: bool, /) -> None: ...
    def setProgressRange(self, minimum: int, maximum: int, /) -> None: ...
    def setProgressValue(self, progressValue: int, /) -> None: ...
    def setProgressValueAndText(self, progressValue: int, progressText: str, /) -> None: ...
    def setRunnable(self, runnable: PySide6.QtCore.QRunnable, /) -> None: ...
    def setSuspended(self, suspend: bool, /) -> None: ...
    def setThreadPool(self, pool: PySide6.QtCore.QThreadPool, /) -> None: ...
    def setThrottled(self, enable: bool, /) -> None: ...
    def suspendIfRequested(self, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QFutureInterfaceBase, /) -> None: ...
    def threadPool(self, /) -> PySide6.QtCore.QThreadPool: ...
    def togglePaused(self, /) -> None: ...
    def toggleSuspended(self, /) -> None: ...
    def waitForFinished(self, /) -> None: ...
    def waitForNextResult(self, /) -> bool: ...
    def waitForResult(self, resultIndex: int, /) -> None: ...
    def waitForResume(self, /) -> None: ...


class QGenericArgument(Shiboken.Object):

    @typing.overload
    def __init__(self, QGenericArgument: PySide6.QtCore.QGenericArgument, /) -> None: ...
    @typing.overload
    def __init__(self, /, aName: bytes | bytearray | memoryview | None= ..., aData: int | None = ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def data(self, /) -> int: ...
    def name(self, /) -> bytes | bytearray | memoryview: ...


class QGenericArgumentHolder(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QGenericArgumentHolder, /) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, aData: int, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def data(self, /) -> int: ...
    def metaType(self, /) -> PySide6.QtCore.QMetaType: ...
    def toGenericArgument(self, /) -> PySide6.QtCore.QGenericArgument: ...


class QGenericReturnArgument(PySide6.QtCore.QGenericArgument):

    @typing.overload
    def __init__(self, QGenericReturnArgument: PySide6.QtCore.QGenericReturnArgument, /) -> None: ...
    @typing.overload
    def __init__(self, /, aName: bytes | bytearray | memoryview | None= ..., aData: int | None = ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...


class QGenericReturnArgumentHolder(Shiboken.Object):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QGenericReturnArgumentHolder, /) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, aData: int, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def data(self, /) -> int: ...
    def metaType(self, /) -> PySide6.QtCore.QMetaType: ...
    def toGenericReturnArgument(self, /) -> PySide6.QtCore.QGenericReturnArgument: ...


class QHashSeed(Shiboken.Object):

    @typing.overload
    def __init__(self, QHashSeed: PySide6.QtCore.QHashSeed, /) -> None: ...
    @typing.overload
    def __init__(self, /, d: int | None = ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    @staticmethod
    def globalSeed() -> PySide6.QtCore.QHashSeed: ...
    @staticmethod
    def resetRandomGlobalSeed() -> None: ...
    @staticmethod
    def setDeterministicGlobalSeed() -> None: ...


class QIODevice(PySide6.QtCore.QObject, PySide6.QtCore.QIODeviceBase):

    aboutToClose             : typing.ClassVar[Signal] = ... # aboutToClose()
    bytesWritten             : typing.ClassVar[Signal] = ... # bytesWritten(qlonglong)
    channelBytesWritten      : typing.ClassVar[Signal] = ... # channelBytesWritten(int,qlonglong)
    channelReadyRead         : typing.ClassVar[Signal] = ... # channelReadyRead(int)
    readChannelFinished      : typing.ClassVar[Signal] = ... # readChannelFinished()
    readyRead                : typing.ClassVar[Signal] = ... # readyRead()

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject, /) -> None: ...

    def atEnd(self, /) -> bool: ...
    def bytesAvailable(self, /) -> int: ...
    def bytesToWrite(self, /) -> int: ...
    def canReadLine(self, /) -> bool: ...
    def close(self, /) -> None: ...
    def commitTransaction(self, /) -> None: ...
    def currentReadChannel(self, /) -> int: ...
    def currentWriteChannel(self, /) -> int: ...
    def errorString(self, /) -> str: ...
    def getChar(self, /) -> bool: ...
    def isOpen(self, /) -> bool: ...
    def isReadable(self, /) -> bool: ...
    def isSequential(self, /) -> bool: ...
    def isTextModeEnabled(self, /) -> bool: ...
    def isTransactionStarted(self, /) -> bool: ...
    def isWritable(self, /) -> bool: ...
    def open(self, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag, /) -> bool: ...
    def openMode(self, /) -> PySide6.QtCore.QIODeviceBase.OpenModeFlag: ...
    @typing.overload
    def peek(self, buffer: bytearray, maxlen: int, /) -> int: ...
    @typing.overload
    def peek(self, maxlen: int, /) -> PySide6.QtCore.QByteArray: ...
    def pos(self, /) -> int: ...
    def putChar(self, c: int, /) -> bool: ...
    @typing.overload
    def read(self, buffer: bytearray, maxlen: int, /) -> int: ...
    @typing.overload
    def read(self, maxlen: int, /) -> PySide6.QtCore.QByteArray: ...
    def readAll(self, /) -> PySide6.QtCore.QByteArray: ...
    def readChannelCount(self, /) -> int: ...
    def readData(self, maxlen: int, /) -> object: ...
    @typing.overload
    def readLine(self, buffer: bytearray, maxlen: int, /) -> int: ...
    @typing.overload
    def readLine(self, /, maxlen: int | None = ...) -> PySide6.QtCore.QByteArray: ...
    def readLineData(self, maxlen: int, /) -> object: ...
    def readLineInto(self, result: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, maxlen: int | None = ...) -> bool: ...
    def reset(self, /) -> bool: ...
    def rollbackTransaction(self, /) -> None: ...
    def seek(self, pos: int, /) -> bool: ...
    def setCurrentReadChannel(self, channel: int, /) -> None: ...
    def setCurrentWriteChannel(self, channel: int, /) -> None: ...
    def setErrorString(self, errorString: str, /) -> None: ...
    def setOpenMode(self, openMode: PySide6.QtCore.QIODeviceBase.OpenModeFlag, /) -> None: ...
    def setTextModeEnabled(self, enabled: bool, /) -> None: ...
    def size(self, /) -> int: ...
    def skip(self, maxSize: int, /) -> int: ...
    def skipData(self, maxSize: int, /) -> int: ...
    def startTransaction(self, /) -> None: ...
    def ungetChar(self, c: int, /) -> None: ...
    def waitForBytesWritten(self, msecs: int, /) -> bool: ...
    def waitForReadyRead(self, msecs: int, /) -> bool: ...
    def write(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> int: ...
    def writeChannelCount(self, /) -> int: ...
    def writeData(self, data: bytes | bytearray | memoryview, len: int, /) -> int: ...


class QIODeviceBase(Shiboken.Object):

    class OpenModeFlag(enum.Flag):

        NotOpen                   = 0x0
        ReadOnly                  = 0x1
        WriteOnly                 = 0x2
        ReadWrite                 = 0x3
        Append                    = 0x4
        Truncate                  = 0x8
        Text                      = 0x10
        Unbuffered                = 0x20
        NewOnly                   = 0x40
        ExistingOnly              = 0x80


    def __init__(self, /) -> None: ...


class QIOPipe(PySide6.QtCore.QObject):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def end1(self, /) -> PySide6.QtCore.QIODevice: ...
    def end2(self, /) -> PySide6.QtCore.QIODevice: ...
    def open(self, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag, /) -> bool: ...


class QIdentityProxyModel(PySide6.QtCore.QAbstractProxyModel):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def columnCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def handleSourceDataChanges(self, /) -> bool: ...
    def handleSourceLayoutChanges(self, /) -> bool: ...
    def headerData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, /, role: int = ...) -> typing.Any: ...
    def index(self, row: int, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> PySide6.QtCore.QModelIndex: ...
    def insertColumns(self, column: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def insertRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def mapFromSource(self, sourceIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def mapSelectionFromSource(self, selection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtCore.QItemSelection: ...
    def mapSelectionToSource(self, selection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtCore.QItemSelection: ...
    def mapToSource(self, proxyIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def match(self, start: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, role: int, value: typing.Any, /, hits: int = ..., flags: PySide6.QtCore.Qt.MatchFlag = ...) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def moveColumns(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceColumn: int, count: int, destinationParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destinationChild: int, /) -> bool: ...
    def moveRows(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceRow: int, count: int, destinationParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destinationChild: int, /) -> bool: ...
    @typing.overload
    def parent(self, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def removeColumns(self, column: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def removeRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def rowCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def setHandleSourceDataChanges(self, arg__1: bool, /) -> None: ...
    def setHandleSourceLayoutChanges(self, arg__1: bool, /) -> None: ...
    def setSourceModel(self, sourceModel: PySide6.QtCore.QAbstractItemModel, /) -> None: ...
    def sibling(self, row: int, column: int, idx: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...


class QIntList: ...


class QItemSelection(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QItemSelection: PySide6.QtCore.QItemSelection, /) -> None: ...
    @typing.overload
    def __init__(self, topLeft: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, bottomRight: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...

    def __add__(self, arg__1: PySide6.QtCore.QItemSelection, /) -> PySide6.QtCore.QItemSelection: ...
    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, arg__1: PySide6.QtCore.QItemSelection, /) -> bool: ...
    def __iadd__(self, l: collections.abc.Sequence[PySide6.QtCore.QItemSelectionRange], /) -> typing.List[PySide6.QtCore.QItemSelectionRange]: ...  # type: ignore[misc]
    def __lshift__(self, l: collections.abc.Sequence[PySide6.QtCore.QItemSelectionRange], /) -> typing.List[PySide6.QtCore.QItemSelectionRange]: ...
    def __ne__(self, arg__1: PySide6.QtCore.QItemSelection, /) -> bool: ...
    @typing.overload
    def append(self, arg__1: PySide6.QtCore.QItemSelectionRange, /) -> None: ...
    @typing.overload
    def append(self, l: collections.abc.Sequence[PySide6.QtCore.QItemSelectionRange], /) -> None: ...
    def at(self, i: int, /) -> PySide6.QtCore.QItemSelectionRange: ...
    def back(self, /) -> PySide6.QtCore.QItemSelectionRange: ...
    def capacity(self, /) -> int: ...
    def clear(self, /) -> None: ...
    def constData(self, /) -> PySide6.QtCore.QItemSelectionRange: ...
    def constFirst(self, /) -> PySide6.QtCore.QItemSelectionRange: ...
    def constLast(self, /) -> PySide6.QtCore.QItemSelectionRange: ...
    def contains(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def count(self, /) -> int: ...
    def data(self, /) -> PySide6.QtCore.QItemSelectionRange: ...
    def empty(self, /) -> bool: ...
    @typing.overload
    def first(self, /) -> PySide6.QtCore.QItemSelectionRange: ...
    @typing.overload
    def first(self, n: int, /) -> typing.List[PySide6.QtCore.QItemSelectionRange]: ...
    @staticmethod
    def fromList(list: collections.abc.Sequence[PySide6.QtCore.QItemSelectionRange], /) -> typing.List[PySide6.QtCore.QItemSelectionRange]: ...
    @staticmethod
    def fromVector(vector: collections.abc.Sequence[PySide6.QtCore.QItemSelectionRange], /) -> typing.List[PySide6.QtCore.QItemSelectionRange]: ...
    def front(self, /) -> PySide6.QtCore.QItemSelectionRange: ...
    def indexes(self, /) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def insert(self, arg__1: int, arg__2: PySide6.QtCore.QItemSelectionRange, /) -> None: ...
    def isEmpty(self, /) -> bool: ...
    def isSharedWith(self, other: collections.abc.Sequence[PySide6.QtCore.QItemSelectionRange], /) -> bool: ...
    @typing.overload
    def last(self, /) -> PySide6.QtCore.QItemSelectionRange: ...
    @typing.overload
    def last(self, n: int, /) -> typing.List[PySide6.QtCore.QItemSelectionRange]: ...
    def length(self, /) -> int: ...
    @staticmethod
    def maxSize() -> int: ...
    def max_size(self, /) -> int: ...
    def merge(self, other: PySide6.QtCore.QItemSelection, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def mid(self, pos: int, /, len: int = ...) -> typing.List[PySide6.QtCore.QItemSelectionRange]: ...
    def move(self, from_: int, to: int, /) -> None: ...
    def pop_back(self, /) -> None: ...
    def pop_front(self, /) -> None: ...
    def prepend(self, arg__1: PySide6.QtCore.QItemSelectionRange, /) -> None: ...
    def push_back(self, arg__1: PySide6.QtCore.QItemSelectionRange, /) -> None: ...
    def push_front(self, arg__1: PySide6.QtCore.QItemSelectionRange, /) -> None: ...
    def remove(self, i: int, /, n: int = ...) -> None: ...
    def removeAll(self, arg__1: PySide6.QtCore.QItemSelectionRange, /) -> None: ...
    def removeAt(self, i: int, /) -> None: ...
    def removeFirst(self, /) -> None: ...
    def removeLast(self, /) -> None: ...
    def removeOne(self, arg__1: PySide6.QtCore.QItemSelectionRange, /) -> None: ...
    def reserve(self, size: int, /) -> None: ...
    def resize(self, size: int, /) -> None: ...
    def resizeForOverwrite(self, size: int, /) -> None: ...
    def select(self, topLeft: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, bottomRight: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def shrink_to_fit(self, /) -> None: ...
    def size(self, /) -> int: ...
    @typing.overload
    def sliced(self, pos: int, /) -> typing.List[PySide6.QtCore.QItemSelectionRange]: ...
    @typing.overload
    def sliced(self, pos: int, n: int, /) -> typing.List[PySide6.QtCore.QItemSelectionRange]: ...
    @staticmethod
    def split(range: PySide6.QtCore.QItemSelectionRange, other: PySide6.QtCore.QItemSelectionRange, result: PySide6.QtCore.QItemSelection, /) -> None: ...
    def squeeze(self, /) -> None: ...
    def swap(self, other: collections.abc.Sequence[PySide6.QtCore.QItemSelectionRange], /) -> None: ...
    def swapItemsAt(self, i: int, j: int, /) -> None: ...
    def takeAt(self, i: int, /) -> PySide6.QtCore.QItemSelectionRange: ...
    def toList(self, /) -> typing.List[PySide6.QtCore.QItemSelectionRange]: ...
    def toVector(self, /) -> typing.List[PySide6.QtCore.QItemSelectionRange]: ...
    def value(self, i: int, /) -> PySide6.QtCore.QItemSelectionRange: ...


class QItemSelectionModel(PySide6.QtCore.QObject):

    currentChanged           : typing.ClassVar[Signal] = ... # currentChanged(QModelIndex,QModelIndex)
    currentColumnChanged     : typing.ClassVar[Signal] = ... # currentColumnChanged(QModelIndex,QModelIndex)
    currentRowChanged        : typing.ClassVar[Signal] = ... # currentRowChanged(QModelIndex,QModelIndex)
    modelChanged             : typing.ClassVar[Signal] = ... # modelChanged(QAbstractItemModel*)
    selectionChanged         : typing.ClassVar[Signal] = ... # selectionChanged(QItemSelection,QItemSelection)

    class SelectionFlag(enum.Flag):

        NoUpdate                  = 0x0
        Clear                     = 0x1
        Select                    = 0x2
        ClearAndSelect            = 0x3
        Deselect                  = 0x4
        Toggle                    = 0x8
        Current                   = 0x10
        SelectCurrent             = 0x12
        ToggleCurrent             = 0x18
        Rows                      = 0x20
        Columns                   = 0x40


    @typing.overload
    def __init__(self, model: PySide6.QtCore.QAbstractItemModel, parent: PySide6.QtCore.QObject, /, *, hasSelection: bool | None = ..., currentIndex: PySide6.QtCore.QModelIndex | None = ..., selection: PySide6.QtCore.QItemSelection | None = ..., selectedIndexes: collections.abc.Sequence[PySide6.QtCore.QModelIndex] | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, model: PySide6.QtCore.QAbstractItemModel | None = ..., *, hasSelection: bool | None = ..., currentIndex: PySide6.QtCore.QModelIndex | None = ..., selection: PySide6.QtCore.QItemSelection | None = ..., selectedIndexes: collections.abc.Sequence[PySide6.QtCore.QModelIndex] | None = ...) -> None: ...

    def clear(self, /) -> None: ...
    def clearCurrentIndex(self, /) -> None: ...
    def clearSelection(self, /) -> None: ...
    def columnIntersectsSelection(self, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def currentIndex(self, /) -> PySide6.QtCore.QModelIndex: ...
    def emitSelectionChanged(self, newSelection: PySide6.QtCore.QItemSelection, oldSelection: PySide6.QtCore.QItemSelection, /) -> None: ...
    def hasSelection(self, /) -> bool: ...
    def isColumnSelected(self, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def isRowSelected(self, row: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def isSelected(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def model(self, /) -> PySide6.QtCore.QAbstractItemModel: ...
    def reset(self, /) -> None: ...
    def rowIntersectsSelection(self, row: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    @typing.overload
    def select(self, selection: PySide6.QtCore.QItemSelection, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    @typing.overload
    def select(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def selectedColumns(self, /, row: int | None = ...) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def selectedIndexes(self, /) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def selectedRows(self, /, column: int | None = ...) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def selection(self, /) -> PySide6.QtCore.QItemSelection: ...
    def setCurrentIndex(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag, /) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel, /) -> None: ...


class QItemSelectionRange(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QItemSelectionRange: PySide6.QtCore.QItemSelectionRange, /) -> None: ...
    @typing.overload
    def __init__(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    @typing.overload
    def __init__(self, topL: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, bottomR: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QItemSelectionRange, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QItemSelectionRange, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def bottom(self, /) -> int: ...
    def bottomRight(self, /) -> PySide6.QtCore.QPersistentModelIndex: ...
    @typing.overload
    def contains(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    @typing.overload
    def contains(self, row: int, column: int, parentIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def height(self, /) -> int: ...
    def indexes(self, /) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def intersected(self, other: PySide6.QtCore.QItemSelectionRange, /) -> PySide6.QtCore.QItemSelectionRange: ...
    def intersects(self, other: PySide6.QtCore.QItemSelectionRange, /) -> bool: ...
    def isEmpty(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def left(self, /) -> int: ...
    def model(self, /) -> PySide6.QtCore.QAbstractItemModel: ...
    def parent(self, /) -> PySide6.QtCore.QModelIndex: ...
    def right(self, /) -> int: ...
    def swap(self, other: PySide6.QtCore.QItemSelectionRange, /) -> None: ...
    def top(self, /) -> int: ...
    def topLeft(self, /) -> PySide6.QtCore.QPersistentModelIndex: ...
    def width(self, /) -> int: ...


class QJsonArray(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QJsonArray, /) -> None: ...

    def __add__(self, v: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QJsonArray: ...
    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QJsonArray, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __iadd__(self, v: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QJsonArray: ...
    def __lshift__(self, v: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> PySide6.QtCore.QJsonArray: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QJsonArray, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def append(self, value: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def at(self, i: int, /) -> PySide6.QtCore.QJsonValue: ...
    def contains(self, element: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def count(self, /) -> int: ...
    def empty(self, /) -> bool: ...
    def first(self, /) -> PySide6.QtCore.QJsonValue: ...
    @staticmethod
    def fromStringList(list: collections.abc.Sequence[str], /) -> PySide6.QtCore.QJsonArray: ...
    @staticmethod
    def fromVariantList(list: collections.abc.Sequence[typing.Any], /) -> PySide6.QtCore.QJsonArray: ...
    def insert(self, i: int, value: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def isEmpty(self, /) -> bool: ...
    def last(self, /) -> PySide6.QtCore.QJsonValue: ...
    def pop_back(self, /) -> None: ...
    def pop_front(self, /) -> None: ...
    def prepend(self, value: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def push_back(self, t: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def push_front(self, t: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def removeAt(self, i: int, /) -> None: ...
    def removeFirst(self, /) -> None: ...
    def removeLast(self, /) -> None: ...
    def replace(self, i: int, value: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> None: ...
    def size(self, /) -> int: ...
    def swap(self, other: PySide6.QtCore.QJsonArray, /) -> None: ...
    def takeAt(self, i: int, /) -> PySide6.QtCore.QJsonValue: ...
    def toVariantList(self, /) -> typing.List[typing.Any]: ...


class QJsonDocument(Shiboken.Object):

    class JsonFormat(enum.Enum):

        Indented                  = 0x0
        Compact                   = 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, array: PySide6.QtCore.QJsonArray, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QJsonDocument, /) -> None: ...
    @typing.overload
    def __init__(self, object: typing.Dict[str, PySide6.QtCore.QJsonValue], /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QJsonDocument, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QJsonDocument, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def array(self, /) -> PySide6.QtCore.QJsonArray: ...
    @staticmethod
    def fromJson(json: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, error: PySide6.QtCore.QJsonParseError | None = ...) -> PySide6.QtCore.QJsonDocument: ...
    @staticmethod
    def fromVariant(variant: typing.Any, /) -> PySide6.QtCore.QJsonDocument: ...
    def isArray(self, /) -> bool: ...
    def isEmpty(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isObject(self, /) -> bool: ...
    def object(self, /) -> typing.Dict[str, PySide6.QtCore.QJsonValue]: ...
    def setArray(self, array: PySide6.QtCore.QJsonArray, /) -> None: ...
    def setObject(self, object: typing.Dict[str, PySide6.QtCore.QJsonValue], /) -> None: ...
    def swap(self, other: PySide6.QtCore.QJsonDocument, /) -> None: ...
    def toJson(self, /, format: PySide6.QtCore.QJsonDocument.JsonFormat = ...) -> PySide6.QtCore.QByteArray: ...
    def toVariant(self, /) -> typing.Any: ...


class QJsonParseError(Shiboken.Object):

    class ParseError(enum.Enum):

        NoError                   = 0x0
        UnterminatedObject        = 0x1
        MissingNameSeparator      = 0x2
        UnterminatedArray         = 0x3
        MissingValueSeparator     = 0x4
        IllegalValue              = 0x5
        TerminationByNumber       = 0x6
        IllegalNumber             = 0x7
        IllegalEscapeSequence     = 0x8
        IllegalUTF8String         = 0x9
        UnterminatedString        = 0xa
        MissingObject             = 0xb
        DeepNesting               = 0xc
        DocumentTooLarge          = 0xd
        GarbageAtEnd              = 0xe


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QJsonParseError: PySide6.QtCore.QJsonParseError, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def errorString(self, /) -> str: ...


class QJsonValue(Shiboken.Object):

    class Type(enum.Enum):

        Null                      = 0x0
        Bool                      = 0x1
        Double                    = 0x2
        String                    = 0x3
        Array                     = 0x4
        Object                    = 0x5
        Undefined                 = 0x80


    @typing.overload
    def __init__(self, a: PySide6.QtCore.QJsonArray, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QJsonValue, /) -> None: ...
    @typing.overload
    def __init__(self, /, arg__1: PySide6.QtCore.QJsonValue.Type = ...) -> None: ...
    @typing.overload
    def __init__(self, s: str, /) -> None: ...
    @typing.overload
    def __init__(self, o: typing.Dict[str, PySide6.QtCore.QJsonValue], /) -> None: ...
    @typing.overload
    def __init__(self, s: bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    def __init__(self, b: bool, /) -> None: ...
    @typing.overload
    def __init__(self, v: int, /) -> None: ...
    @typing.overload
    def __init__(self, n: float, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QJsonArray, /) -> bool: ...
    @typing.overload
    def __eq__(self, lhs: typing.Dict[str, PySide6.QtCore.QJsonValue], /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QJsonArray, /) -> bool: ...
    @typing.overload
    def __ne__(self, lhs: typing.Dict[str, PySide6.QtCore.QJsonValue], /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    @staticmethod
    def fromJson(json: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, error: PySide6.QtCore.QJsonParseError | None = ...) -> PySide6.QtCore.QJsonValue: ...
    @staticmethod
    def fromVariant(variant: typing.Any, /) -> PySide6.QtCore.QJsonValue: ...
    def isArray(self, /) -> bool: ...
    def isBool(self, /) -> bool: ...
    def isDouble(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isObject(self, /) -> bool: ...
    def isString(self, /) -> bool: ...
    def isUndefined(self, /) -> bool: ...
    def swap(self, other: PySide6.QtCore.QJsonValue | PySide6.QtCore.QJsonValue.Type | str | bool | PySide6.QtCore.QJsonArray | typing.Dict[str, PySide6.QtCore.QJsonValue] | bytes | bytearray | memoryview | float | int, /) -> None: ...
    @typing.overload
    def toArray(self, /) -> PySide6.QtCore.QJsonArray: ...
    @typing.overload
    def toArray(self, defaultValue: PySide6.QtCore.QJsonArray, /) -> PySide6.QtCore.QJsonArray: ...
    def toBool(self, /, defaultValue: bool = ...) -> bool: ...
    def toDouble(self, /, defaultValue: float | None = ...) -> float: ...
    def toInt(self, /, defaultValue: int | None = ...) -> int: ...
    def toInteger(self, /, defaultValue: int | None = ...) -> int: ...
    def toJson(self, /, format: PySide6.QtCore.QJsonDocument.JsonFormat = ...) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    def toObject(self, /) -> typing.Dict[str, PySide6.QtCore.QJsonValue]: ...
    @typing.overload
    def toObject(self, defaultValue: typing.Dict[str, PySide6.QtCore.QJsonValue], /) -> typing.Dict[str, PySide6.QtCore.QJsonValue]: ...
    @typing.overload
    def toString(self, /) -> str: ...
    @typing.overload
    def toString(self, defaultValue: str, /) -> str: ...
    def toStringView(self, /, defaultValue: str = ...) -> str: ...
    def toVariant(self, /) -> typing.Any: ...
    def type(self, /) -> PySide6.QtCore.QJsonValue.Type: ...


class QKeyCombination(Shiboken.Object):

    @typing.overload
    def __init__(self, /, key: PySide6.QtCore.Qt.Key = ...) -> None: ...
    @typing.overload
    def __init__(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier, /, key: PySide6.QtCore.Qt.Key = ...) -> None: ...
    @typing.overload
    def __init__(self, modifiers: PySide6.QtCore.Qt.Modifier, key: PySide6.QtCore.Qt.Key, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QKeyCombination, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QKeyCombination | PySide6.QtCore.Qt.KeyboardModifier | PySide6.QtCore.Qt.Key, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __ne__(self, rhs: PySide6.QtCore.QKeyCombination | PySide6.QtCore.Qt.KeyboardModifier | PySide6.QtCore.Qt.Key, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    @staticmethod
    def fromCombined(combined: int, /) -> PySide6.QtCore.QKeyCombination: ...
    def key(self, /) -> PySide6.QtCore.Qt.Key: ...
    def keyboardModifiers(self, /) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def toCombined(self, /) -> int: ...


class QLibrary(PySide6.QtCore.QObject):

    class LoadHint(enum.Flag):

        ResolveAllSymbolsHint     = 0x1
        ExportExternalSymbolsHint = 0x2
        LoadArchiveMemberHint     = 0x4
        PreventUnloadHint         = 0x8
        DeepBindHint              = 0x10


    @typing.overload
    def __init__(self, fileName: str, version: str, /, parent: PySide6.QtCore.QObject | None = ..., *, loadHints: PySide6.QtCore.QLibrary.LoadHint | None = ...) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, /, parent: PySide6.QtCore.QObject | None = ..., *, loadHints: PySide6.QtCore.QLibrary.LoadHint | None = ...) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, verNum: int, /, parent: PySide6.QtCore.QObject | None = ..., *, loadHints: PySide6.QtCore.QLibrary.LoadHint | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, fileName: str | None = ..., loadHints: PySide6.QtCore.QLibrary.LoadHint | None = ...) -> None: ...

    def errorString(self, /) -> str: ...
    def fileName(self, /) -> str: ...
    @staticmethod
    def isLibrary(fileName: str, /) -> bool: ...
    def isLoaded(self, /) -> bool: ...
    def load(self, /) -> bool: ...
    def loadHints(self, /) -> PySide6.QtCore.QLibrary.LoadHint: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def resolve(self, symbol: bytes | bytearray | memoryview, /) -> int: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def resolve(fileName: str, version: str, symbol: bytes | bytearray | memoryview, /) -> int: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def resolve(fileName: str, symbol: bytes | bytearray | memoryview, /) -> int: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def resolve(fileName: str, verNum: int, symbol: bytes | bytearray | memoryview, /) -> int: ...  # type: ignore[misc, overload-cannot-match]
    def setFileName(self, fileName: str, /) -> None: ...
    @typing.overload
    def setFileNameAndVersion(self, fileName: str, version: str, /) -> None: ...
    @typing.overload
    def setFileNameAndVersion(self, fileName: str, verNum: int, /) -> None: ...
    def setLoadHints(self, hints: PySide6.QtCore.QLibrary.LoadHint, /) -> None: ...
    def unload(self, /) -> bool: ...


class QLibraryInfo(Shiboken.Object):

    class LibraryPath(enum.Enum):

        PrefixPath                = 0x0
        DocumentationPath         = 0x1
        HeadersPath               = 0x2
        LibrariesPath             = 0x3
        LibraryExecutablesPath    = 0x4
        BinariesPath              = 0x5
        PluginsPath               = 0x6
        Qml2ImportsPath           = 0x7
        QmlImportsPath            = 0x7
        ArchDataPath              = 0x8
        DataPath                  = 0x9
        TranslationsPath          = 0xa
        ExamplesPath              = 0xb
        TestsPath                 = 0xc
        SettingsPath              = 0x64


    @staticmethod
    def build() -> bytes | bytearray | memoryview: ...
    @staticmethod
    def isDebugBuild() -> bool: ...
    @staticmethod
    def isSharedBuild() -> bool: ...
    @staticmethod
    def location(location: PySide6.QtCore.QLibraryInfo.LibraryPath, /) -> str: ...
    @staticmethod
    def path(p: PySide6.QtCore.QLibraryInfo.LibraryPath, /) -> str: ...
    @staticmethod
    def paths(p: PySide6.QtCore.QLibraryInfo.LibraryPath, /) -> typing.List[str]: ...
    @staticmethod
    def platformPluginArguments(platformName: str, /) -> typing.List[str]: ...
    @staticmethod
    def version() -> PySide6.QtCore.QVersionNumber: ...


class QLine(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QLine: PySide6.QtCore.QLine, /) -> None: ...
    @typing.overload
    def __init__(self, pt1: PySide6.QtCore.QPoint, pt2: PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def __init__(self, x1: int, y1: int, x2: int, y2: int, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QLine, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QLine, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def center(self, /) -> PySide6.QtCore.QPoint: ...
    def dx(self, /) -> int: ...
    def dy(self, /) -> int: ...
    def isNull(self, /) -> bool: ...
    def p1(self, /) -> PySide6.QtCore.QPoint: ...
    def p2(self, /) -> PySide6.QtCore.QPoint: ...
    def setLine(self, x1: int, y1: int, x2: int, y2: int, /) -> None: ...
    def setP1(self, p1: PySide6.QtCore.QPoint, /) -> None: ...
    def setP2(self, p2: PySide6.QtCore.QPoint, /) -> None: ...
    def setPoints(self, p1: PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPoint, /) -> None: ...
    def toLineF(self, /) -> PySide6.QtCore.QLineF: ...
    def toTuple(self, /) -> typing.Tuple[int, int, int, int]: ...
    @typing.overload
    def translate(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def translate(self, dx: int, dy: int, /) -> None: ...
    @typing.overload
    def translated(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QLine: ...
    @typing.overload
    def translated(self, dx: int, dy: int, /) -> PySide6.QtCore.QLine: ...
    def x1(self, /) -> int: ...
    def x2(self, /) -> int: ...
    def y1(self, /) -> int: ...
    def y2(self, /) -> int: ...


class QLineF(Shiboken.Object):

    class IntersectionType(enum.Enum):

        NoIntersection            = 0x0
        BoundedIntersection       = 0x1
        UnboundedIntersection     = 0x2


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, line: PySide6.QtCore.QLine, /) -> None: ...
    @typing.overload
    def __init__(self, QLineF: PySide6.QtCore.QLineF, /) -> None: ...
    @typing.overload
    def __init__(self, pt1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, pt2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QLine, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QLine, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def angle(self, /) -> float: ...
    def angleTo(self, l: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, /) -> float: ...
    def center(self, /) -> PySide6.QtCore.QPointF: ...
    def dx(self, /) -> float: ...
    def dy(self, /) -> float: ...
    @staticmethod
    def fromPolar(length: float, angle: float, /) -> PySide6.QtCore.QLineF: ...
    def intersects(self, l: PySide6.QtCore.QLineF | PySide6.QtCore.QLine, /) -> typing.Tuple[PySide6.QtCore.QLineF.IntersectionType, PySide6.QtCore.QPointF]: ...
    def isNull(self, /) -> bool: ...
    def length(self, /) -> float: ...
    def normalVector(self, /) -> PySide6.QtCore.QLineF: ...
    def p1(self, /) -> PySide6.QtCore.QPointF: ...
    def p2(self, /) -> PySide6.QtCore.QPointF: ...
    def pointAt(self, t: float, /) -> PySide6.QtCore.QPointF: ...
    def setAngle(self, angle: float, /) -> None: ...
    def setLength(self, len: float, /) -> None: ...
    def setLine(self, x1: float, y1: float, x2: float, y2: float, /) -> None: ...
    def setP1(self, p1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def setP2(self, p2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def setPoints(self, p1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def toLine(self, /) -> PySide6.QtCore.QLine: ...
    def toTuple(self, /) -> typing.Tuple[float, float, float, float]: ...
    @typing.overload
    def translate(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def translate(self, dx: float, dy: float, /) -> None: ...
    @typing.overload
    def translated(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QLineF: ...
    @typing.overload
    def translated(self, dx: float, dy: float, /) -> PySide6.QtCore.QLineF: ...
    def unitVector(self, /) -> PySide6.QtCore.QLineF: ...
    def x1(self, /) -> float: ...
    def x2(self, /) -> float: ...
    def y1(self, /) -> float: ...
    def y2(self, /) -> float: ...


class QLocale(Shiboken.Object):

    class Country(enum.Enum):

        AnyCountry                = 0x0
        AnyTerritory              = 0x0
        Afghanistan               = 0x1
        AlandIslands              = 0x2
        Albania                   = 0x3
        Algeria                   = 0x4
        AmericanSamoa             = 0x5
        Andorra                   = 0x6
        Angola                    = 0x7
        Anguilla                  = 0x8
        Antarctica                = 0x9
        AntiguaAndBarbuda         = 0xa
        Argentina                 = 0xb
        Armenia                   = 0xc
        Aruba                     = 0xd
        AscensionIsland           = 0xe
        Australia                 = 0xf
        Austria                   = 0x10
        Azerbaijan                = 0x11
        Bahamas                   = 0x12
        Bahrain                   = 0x13
        Bangladesh                = 0x14
        Barbados                  = 0x15
        Belarus                   = 0x16
        Belgium                   = 0x17
        Belize                    = 0x18
        Benin                     = 0x19
        Bermuda                   = 0x1a
        Bhutan                    = 0x1b
        Bolivia                   = 0x1c
        BosniaAndHerzegovina      = 0x1d
        BosniaAndHerzegowina      = 0x1d
        Botswana                  = 0x1e
        BouvetIsland              = 0x1f
        Brazil                    = 0x20
        BritishIndianOceanTerritory = 0x21
        BritishVirginIslands      = 0x22
        Brunei                    = 0x23
        Bulgaria                  = 0x24
        BurkinaFaso               = 0x25
        Burundi                   = 0x26
        Cambodia                  = 0x27
        Cameroon                  = 0x28
        Canada                    = 0x29
        CanaryIslands             = 0x2a
        CapeVerde                 = 0x2b
        Bonaire                   = 0x2c
        CaribbeanNetherlands      = 0x2c
        CaymanIslands             = 0x2d
        CentralAfricanRepublic    = 0x2e
        CeutaAndMelilla           = 0x2f
        Chad                      = 0x30
        Chile                     = 0x31
        China                     = 0x32
        ChristmasIsland           = 0x33
        ClippertonIsland          = 0x34
        CocosIslands              = 0x35
        Colombia                  = 0x36
        Comoros                   = 0x37
        CongoBrazzaville          = 0x38
        PeoplesRepublicOfCongo    = 0x38
        CongoKinshasa             = 0x39
        DemocraticRepublicOfCongo = 0x39
        CookIslands               = 0x3a
        CostaRica                 = 0x3b
        Croatia                   = 0x3c
        Cuba                      = 0x3d
        CuraSao                   = 0x3e
        Curacao                   = 0x3e
        Cyprus                    = 0x3f
        CzechRepublic             = 0x40
        Czechia                   = 0x40
        Denmark                   = 0x41
        DiegoGarcia               = 0x42
        Djibouti                  = 0x43
        Dominica                  = 0x44
        DominicanRepublic         = 0x45
        Ecuador                   = 0x46
        Egypt                     = 0x47
        ElSalvador                = 0x48
        EquatorialGuinea          = 0x49
        Eritrea                   = 0x4a
        Estonia                   = 0x4b
        Eswatini                  = 0x4c
        Swaziland                 = 0x4c
        Ethiopia                  = 0x4d
        Europe                    = 0x4e
        EuropeanUnion             = 0x4f
        FalklandIslands           = 0x50
        FaroeIslands              = 0x51
        Fiji                      = 0x52
        Finland                   = 0x53
        France                    = 0x54
        FrenchGuiana              = 0x55
        FrenchPolynesia           = 0x56
        FrenchSouthernTerritories = 0x57
        Gabon                     = 0x58
        Gambia                    = 0x59
        Georgia                   = 0x5a
        Germany                   = 0x5b
        Ghana                     = 0x5c
        Gibraltar                 = 0x5d
        Greece                    = 0x5e
        Greenland                 = 0x5f
        Grenada                   = 0x60
        Guadeloupe                = 0x61
        Guam                      = 0x62
        Guatemala                 = 0x63
        Guernsey                  = 0x64
        GuineaBissau              = 0x65
        Guinea                    = 0x66
        Guyana                    = 0x67
        Haiti                     = 0x68
        HeardAndMcDonaldIslands   = 0x69
        Honduras                  = 0x6a
        HongKong                  = 0x6b
        Hungary                   = 0x6c
        Iceland                   = 0x6d
        India                     = 0x6e
        Indonesia                 = 0x6f
        Iran                      = 0x70
        Iraq                      = 0x71
        Ireland                   = 0x72
        IsleOfMan                 = 0x73
        Israel                    = 0x74
        Italy                     = 0x75
        IvoryCoast                = 0x76
        Jamaica                   = 0x77
        Japan                     = 0x78
        Jersey                    = 0x79
        Jordan                    = 0x7a
        Kazakhstan                = 0x7b
        Kenya                     = 0x7c
        Kiribati                  = 0x7d
        Kosovo                    = 0x7e
        Kuwait                    = 0x7f
        Kyrgyzstan                = 0x80
        Laos                      = 0x81
        LatinAmerica              = 0x82
        LatinAmericaAndTheCaribbean = 0x82
        Latvia                    = 0x83
        Lebanon                   = 0x84
        Lesotho                   = 0x85
        Liberia                   = 0x86
        Libya                     = 0x87
        Liechtenstein             = 0x88
        Lithuania                 = 0x89
        Luxembourg                = 0x8a
        Macao                     = 0x8b
        Macau                     = 0x8b
        Macedonia                 = 0x8c
        Madagascar                = 0x8d
        Malawi                    = 0x8e
        Malaysia                  = 0x8f
        Maldives                  = 0x90
        Mali                      = 0x91
        Malta                     = 0x92
        MarshallIslands           = 0x93
        Martinique                = 0x94
        Mauritania                = 0x95
        Mauritius                 = 0x96
        Mayotte                   = 0x97
        Mexico                    = 0x98
        Micronesia                = 0x99
        Moldova                   = 0x9a
        Monaco                    = 0x9b
        Mongolia                  = 0x9c
        Montenegro                = 0x9d
        Montserrat                = 0x9e
        Morocco                   = 0x9f
        Mozambique                = 0xa0
        Myanmar                   = 0xa1
        Namibia                   = 0xa2
        NauruCountry              = 0xa3
        NauruTerritory            = 0xa3
        Nepal                     = 0xa4
        Netherlands               = 0xa5
        NewCaledonia              = 0xa6
        NewZealand                = 0xa7
        Nicaragua                 = 0xa8
        Nigeria                   = 0xa9
        Niger                     = 0xaa
        Niue                      = 0xab
        NorfolkIsland             = 0xac
        NorthernMarianaIslands    = 0xad
        DemocraticRepublicOfKorea = 0xae
        NorthKorea                = 0xae
        Norway                    = 0xaf
        Oman                      = 0xb0
        OutlyingOceania           = 0xb1
        Pakistan                  = 0xb2
        Palau                     = 0xb3
        PalestinianTerritories    = 0xb4
        Panama                    = 0xb5
        PapuaNewGuinea            = 0xb6
        Paraguay                  = 0xb7
        Peru                      = 0xb8
        Philippines               = 0xb9
        Pitcairn                  = 0xba
        Poland                    = 0xbb
        Portugal                  = 0xbc
        PuertoRico                = 0xbd
        Qatar                     = 0xbe
        Reunion                   = 0xbf
        Romania                   = 0xc0
        Russia                    = 0xc1
        RussianFederation         = 0xc1
        Rwanda                    = 0xc2
        SaintBarthelemy           = 0xc3
        SaintHelena               = 0xc4
        SaintKittsAndNevis        = 0xc5
        SaintLucia                = 0xc6
        SaintMartin               = 0xc7
        SaintPierreAndMiquelon    = 0xc8
        SaintVincentAndGrenadines = 0xc9
        SaintVincentAndTheGrenadines = 0xc9
        Samoa                     = 0xca
        SanMarino                 = 0xcb
        SaoTomeAndPrincipe        = 0xcc
        SaudiArabia               = 0xcd
        Senegal                   = 0xce
        Serbia                    = 0xcf
        Seychelles                = 0xd0
        SierraLeone               = 0xd1
        Singapore                 = 0xd2
        SintMaarten               = 0xd3
        Slovakia                  = 0xd4
        Slovenia                  = 0xd5
        SolomonIslands            = 0xd6
        Somalia                   = 0xd7
        SouthAfrica               = 0xd8
        SouthGeorgiaAndSouthSandwichIslands = 0xd9
        SouthGeorgiaAndTheSouthSandwichIslands = 0xd9
        RepublicOfKorea           = 0xda
        SouthKorea                = 0xda
        SouthSudan                = 0xdb
        Spain                     = 0xdc
        SriLanka                  = 0xdd
        Sudan                     = 0xde
        Suriname                  = 0xdf
        SvalbardAndJanMayen       = 0xe0
        SvalbardAndJanMayenIslands = 0xe0
        Sweden                    = 0xe1
        Switzerland               = 0xe2
        Syria                     = 0xe3
        SyrianArabRepublic        = 0xe3
        Taiwan                    = 0xe4
        Tajikistan                = 0xe5
        Tanzania                  = 0xe6
        Thailand                  = 0xe7
        EastTimor                 = 0xe8
        TimorLeste                = 0xe8
        Togo                      = 0xe9
        TokelauCountry            = 0xea
        TokelauTerritory          = 0xea
        Tonga                     = 0xeb
        TrinidadAndTobago         = 0xec
        TristanDaCunha            = 0xed
        Tunisia                   = 0xee
        Turkey                    = 0xef
        Turkmenistan              = 0xf0
        TurksAndCaicosIslands     = 0xf1
        TuvaluCountry             = 0xf2
        TuvaluTerritory           = 0xf2
        Uganda                    = 0xf3
        Ukraine                   = 0xf4
        UnitedArabEmirates        = 0xf5
        UnitedKingdom             = 0xf6
        UnitedStatesMinorOutlyingIslands = 0xf7
        UnitedStatesOutlyingIslands = 0xf7
        UnitedStates              = 0xf8
        UnitedStatesVirginIslands = 0xf9
        Uruguay                   = 0xfa
        Uzbekistan                = 0xfb
        Vanuatu                   = 0xfc
        VaticanCity               = 0xfd
        VaticanCityState          = 0xfd
        Venezuela                 = 0xfe
        Vietnam                   = 0xff
        WallisAndFutuna           = 0x100
        WallisAndFutunaIslands    = 0x100
        WesternSahara             = 0x101
        World                     = 0x102
        Yemen                     = 0x103
        Zambia                    = 0x104
        LastCountry               = 0x105
        LastTerritory             = 0x105
        Zimbabwe                  = 0x105

    class CurrencySymbolFormat(enum.Enum):

        CurrencyIsoCode           = 0x0
        CurrencySymbol            = 0x1
        CurrencyDisplayName       = 0x2

    class DataSizeFormat(enum.Flag):

        DataSizeIecFormat         = 0x0
        DataSizeBase1000          = 0x1
        DataSizeSIQuantifiers     = 0x2
        DataSizeTraditionalFormat = 0x2
        DataSizeSIFormat          = 0x3

    class FloatingPointPrecisionOption(enum.IntEnum):

        FloatingPointShortest     = -128

    class FormatType(enum.Enum):

        LongFormat                = 0x0
        ShortFormat               = 0x1
        NarrowFormat              = 0x2

    class Language(enum.Enum):

        AnyLanguage               = 0x0
        C                         = 0x1
        Abkhazian                 = 0x2
        Afar                      = 0x3
        Afrikaans                 = 0x4
        Aghem                     = 0x5
        Akan                      = 0x6
        Akkadian                  = 0x7
        Akoose                    = 0x8
        Albanian                  = 0x9
        AmericanSignLanguage      = 0xa
        Amharic                   = 0xb
        AncientEgyptian           = 0xc
        AncientGreek              = 0xd
        Arabic                    = 0xe
        Aragonese                 = 0xf
        Aramaic                   = 0x10
        Armenian                  = 0x11
        Assamese                  = 0x12
        Asturian                  = 0x13
        Asu                       = 0x14
        Atsam                     = 0x15
        Avaric                    = 0x16
        Avestan                   = 0x17
        Aymara                    = 0x18
        Azerbaijani               = 0x19
        Bafia                     = 0x1a
        Balinese                  = 0x1b
        Bambara                   = 0x1c
        Bamun                     = 0x1d
        Bangla                    = 0x1e
        Bengali                   = 0x1e
        Basaa                     = 0x1f
        Bashkir                   = 0x20
        Basque                    = 0x21
        BatakToba                 = 0x22
        Belarusian                = 0x23
        Byelorussian              = 0x23
        Bemba                     = 0x24
        Bena                      = 0x25
        Bhojpuri                  = 0x26
        Bislama                   = 0x27
        Blin                      = 0x28
        Bodo                      = 0x29
        Bosnian                   = 0x2a
        Breton                    = 0x2b
        Buginese                  = 0x2c
        Bulgarian                 = 0x2d
        Burmese                   = 0x2e
        Cantonese                 = 0x2f
        Catalan                   = 0x30
        Cebuano                   = 0x31
        CentralAtlasTamazight     = 0x32
        CentralMoroccoTamazight   = 0x32
        CentralKurdish            = 0x33
        Chakma                    = 0x34
        Chamorro                  = 0x35
        Chechen                   = 0x36
        Cherokee                  = 0x37
        Chickasaw                 = 0x38
        Chiga                     = 0x39
        Chinese                   = 0x3a
        Church                    = 0x3b
        Chuvash                   = 0x3c
        Colognian                 = 0x3d
        Coptic                    = 0x3e
        Cornish                   = 0x3f
        Corsican                  = 0x40
        Cree                      = 0x41
        Croatian                  = 0x42
        Czech                     = 0x43
        Danish                    = 0x44
        Divehi                    = 0x45
        Dogri                     = 0x46
        Duala                     = 0x47
        Dutch                     = 0x48
        Bhutani                   = 0x49
        Dzongkha                  = 0x49
        Embu                      = 0x4a
        English                   = 0x4b
        Erzya                     = 0x4c
        Esperanto                 = 0x4d
        Estonian                  = 0x4e
        Ewe                       = 0x4f
        Ewondo                    = 0x50
        Faroese                   = 0x51
        Fijian                    = 0x52
        Filipino                  = 0x53
        Finnish                   = 0x54
        French                    = 0x55
        Friulian                  = 0x56
        Fulah                     = 0x57
        Gaelic                    = 0x58
        Ga                        = 0x59
        Galician                  = 0x5a
        Ganda                     = 0x5b
        Geez                      = 0x5c
        Georgian                  = 0x5d
        German                    = 0x5e
        Gothic                    = 0x5f
        Greek                     = 0x60
        Guarani                   = 0x61
        Gujarati                  = 0x62
        Gusii                     = 0x63
        Haitian                   = 0x64
        Hausa                     = 0x65
        Hawaiian                  = 0x66
        Hebrew                    = 0x67
        Herero                    = 0x68
        Hindi                     = 0x69
        HiriMotu                  = 0x6a
        Hungarian                 = 0x6b
        Icelandic                 = 0x6c
        Ido                       = 0x6d
        Igbo                      = 0x6e
        InariSami                 = 0x6f
        Indonesian                = 0x70
        Ingush                    = 0x71
        Interlingua               = 0x72
        Interlingue               = 0x73
        Inuktitut                 = 0x74
        Inupiak                   = 0x75
        Inupiaq                   = 0x75
        Irish                     = 0x76
        Italian                   = 0x77
        Japanese                  = 0x78
        Javanese                  = 0x79
        Jju                       = 0x7a
        JolaFonyi                 = 0x7b
        Kabuverdianu              = 0x7c
        Kabyle                    = 0x7d
        Kako                      = 0x7e
        Greenlandic               = 0x7f
        Kalaallisut               = 0x7f
        Kalenjin                  = 0x80
        Kamba                     = 0x81
        Kannada                   = 0x82
        Kanuri                    = 0x83
        Kashmiri                  = 0x84
        Kazakh                    = 0x85
        Kenyang                   = 0x86
        Cambodian                 = 0x87
        Khmer                     = 0x87
        Kiche                     = 0x88
        Kikuyu                    = 0x89
        Kinyarwanda               = 0x8a
        Komi                      = 0x8b
        Kongo                     = 0x8c
        Konkani                   = 0x8d
        Korean                    = 0x8e
        Koro                      = 0x8f
        KoyraboroSenni            = 0x90
        KoyraChiini               = 0x91
        Kpelle                    = 0x92
        Kuanyama                  = 0x93
        Kwanyama                  = 0x93
        Kurdish                   = 0x94
        Kwasio                    = 0x95
        Kirghiz                   = 0x96
        Kyrgyz                    = 0x96
        Lakota                    = 0x97
        Langi                     = 0x98
        Lao                       = 0x99
        Latin                     = 0x9a
        Latvian                   = 0x9b
        Lezghian                  = 0x9c
        Limburgish                = 0x9d
        Lingala                   = 0x9e
        LiteraryChinese           = 0x9f
        Lithuanian                = 0xa0
        Lojban                    = 0xa1
        LowerSorbian              = 0xa2
        LowGerman                 = 0xa3
        LubaKatanga               = 0xa4
        LuleSami                  = 0xa5
        Luo                       = 0xa6
        Luxembourgish             = 0xa7
        Luyia                     = 0xa8
        Macedonian                = 0xa9
        Machame                   = 0xaa
        Maithili                  = 0xab
        MakhuwaMeetto             = 0xac
        Makonde                   = 0xad
        Malagasy                  = 0xae
        Malayalam                 = 0xaf
        Malay                     = 0xb0
        Maltese                   = 0xb1
        Mandingo                  = 0xb2
        Manipuri                  = 0xb3
        Manx                      = 0xb4
        Maori                     = 0xb5
        Mapuche                   = 0xb6
        Marathi                   = 0xb7
        Marshallese               = 0xb8
        Masai                     = 0xb9
        Mazanderani               = 0xba
        Mende                     = 0xbb
        Meru                      = 0xbc
        Meta                      = 0xbd
        Mohawk                    = 0xbe
        Mongolian                 = 0xbf
        Morisyen                  = 0xc0
        Mundang                   = 0xc1
        Muscogee                  = 0xc2
        Nama                      = 0xc3
        NauruLanguage             = 0xc4
        Navaho                    = 0xc5
        Navajo                    = 0xc5
        Ndonga                    = 0xc6
        Nepali                    = 0xc7
        Newari                    = 0xc8
        Ngiemboon                 = 0xc9
        Ngomba                    = 0xca
        NigerianPidgin            = 0xcb
        Nko                       = 0xcc
        NorthernLuri              = 0xcd
        NorthernSami              = 0xce
        NorthernSotho             = 0xcf
        NorthNdebele              = 0xd0
        NorwegianBokmal           = 0xd1
        NorwegianNynorsk          = 0xd2
        Nuer                      = 0xd3
        Chewa                     = 0xd4
        Nyanja                    = 0xd4
        Nyankole                  = 0xd5
        Occitan                   = 0xd6
        Odia                      = 0xd7
        Oriya                     = 0xd7
        Ojibwa                    = 0xd8
        OldIrish                  = 0xd9
        OldNorse                  = 0xda
        OldPersian                = 0xdb
        Afan                      = 0xdc
        Oromo                     = 0xdc
        Osage                     = 0xdd
        Ossetic                   = 0xde
        Pahlavi                   = 0xdf
        Palauan                   = 0xe0
        Pali                      = 0xe1
        Papiamento                = 0xe2
        Pashto                    = 0xe3
        Persian                   = 0xe4
        Phoenician                = 0xe5
        Polish                    = 0xe6
        Portuguese                = 0xe7
        Prussian                  = 0xe8
        Punjabi                   = 0xe9
        Quechua                   = 0xea
        Romanian                  = 0xeb
        RhaetoRomance             = 0xec
        Romansh                   = 0xec
        Rombo                     = 0xed
        Kurundi                   = 0xee
        Rundi                     = 0xee
        Russian                   = 0xef
        Rwa                       = 0xf0
        Saho                      = 0xf1
        Sakha                     = 0xf2
        Samburu                   = 0xf3
        Samoan                    = 0xf4
        Sango                     = 0xf5
        Sangu                     = 0xf6
        Sanskrit                  = 0xf7
        Santali                   = 0xf8
        Sardinian                 = 0xf9
        Saurashtra                = 0xfa
        Sena                      = 0xfb
        Serbian                   = 0xfc
        Shambala                  = 0xfd
        Shona                     = 0xfe
        SichuanYi                 = 0xff
        Sicilian                  = 0x100
        Sidamo                    = 0x101
        Silesian                  = 0x102
        Sindhi                    = 0x103
        Sinhala                   = 0x104
        SkoltSami                 = 0x105
        Slovak                    = 0x106
        Slovenian                 = 0x107
        Soga                      = 0x108
        Somali                    = 0x109
        SouthernKurdish           = 0x10a
        SouthernSami              = 0x10b
        SouthernSotho             = 0x10c
        SouthNdebele              = 0x10d
        Spanish                   = 0x10e
        StandardMoroccanTamazight = 0x10f
        Sundanese                 = 0x110
        Swahili                   = 0x111
        Swati                     = 0x112
        Swedish                   = 0x113
        SwissGerman               = 0x114
        Syriac                    = 0x115
        Tachelhit                 = 0x116
        Tahitian                  = 0x117
        TaiDam                    = 0x118
        Taita                     = 0x119
        Tajik                     = 0x11a
        Tamil                     = 0x11b
        Taroko                    = 0x11c
        Tasawaq                   = 0x11d
        Tatar                     = 0x11e
        Telugu                    = 0x11f
        Teso                      = 0x120
        Thai                      = 0x121
        Tibetan                   = 0x122
        Tigre                     = 0x123
        Tigrinya                  = 0x124
        TokelauLanguage           = 0x125
        TokPisin                  = 0x126
        Tongan                    = 0x127
        Tsonga                    = 0x128
        Tswana                    = 0x129
        Turkish                   = 0x12a
        Turkmen                   = 0x12b
        TuvaluLanguage            = 0x12c
        Tyap                      = 0x12d
        Ugaritic                  = 0x12e
        Ukrainian                 = 0x12f
        UpperSorbian              = 0x130
        Urdu                      = 0x131
        Uighur                    = 0x132
        Uigur                     = 0x132
        Uyghur                    = 0x132
        Uzbek                     = 0x133
        Vai                       = 0x134
        Venda                     = 0x135
        Vietnamese                = 0x136
        Volapuk                   = 0x137
        Vunjo                     = 0x138
        Walloon                   = 0x139
        Walser                    = 0x13a
        Warlpiri                  = 0x13b
        Welsh                     = 0x13c
        WesternBalochi            = 0x13d
        Frisian                   = 0x13e
        WesternFrisian            = 0x13e
        Walamo                    = 0x13f
        Wolaytta                  = 0x13f
        Wolof                     = 0x140
        Xhosa                     = 0x141
        Yangben                   = 0x142
        Yiddish                   = 0x143
        Yoruba                    = 0x144
        Zarma                     = 0x145
        Zhuang                    = 0x146
        Zulu                      = 0x147
        Kaingang                  = 0x148
        Nheengatu                 = 0x149
        Haryanvi                  = 0x14a
        NorthernFrisian           = 0x14b
        Rajasthani                = 0x14c
        Moksha                    = 0x14d
        TokiPona                  = 0x14e
        Pijin                     = 0x14f
        Obolo                     = 0x150
        Baluchi                   = 0x151
        Ligurian                  = 0x152
        Rohingya                  = 0x153
        Torwali                   = 0x154
        Anii                      = 0x155
        Kangri                    = 0x156
        Venetian                  = 0x157
        Kuvi                      = 0x158
        KaraKalpak                = 0x159
        LastLanguage              = 0x15a
        SwampyCree                = 0x15a

    class LanguageCodeType(enum.IntFlag):

        AnyLanguageCode           = -1
        ISO639Alpha2              = 0x1
        ISO639Part1               = 0x1
        ISO639Part2B              = 0x2
        ISO639Part2T              = 0x4
        ISO639Part2               = 0x6
        ISO639Part3               = 0x8
        ISO639Alpha3              = 0xe
        ISO639                    = 0xf
        LegacyLanguageCode        = 0x8000

    class MeasurementSystem(enum.Enum):

        MetricSystem              = 0x0
        ImperialSystem            = 0x1
        ImperialUSSystem          = 0x1
        ImperialUKSystem          = 0x2

    class NumberOption(enum.Flag):

        DefaultNumberOptions      = 0x0
        OmitGroupSeparator        = 0x1
        RejectGroupSeparator      = 0x2
        OmitLeadingZeroInExponent = 0x4
        RejectLeadingZeroInExponent = 0x8
        IncludeTrailingZeroesAfterDot = 0x10
        RejectTrailingZeroesAfterDot = 0x20

    class QuotationStyle(enum.Enum):

        StandardQuotation         = 0x0
        AlternateQuotation        = 0x1

    class Script(enum.Enum):

        AnyScript                 = 0x0
        AdlamScript               = 0x1
        AhomScript                = 0x2
        AnatolianHieroglyphsScript = 0x3
        ArabicScript              = 0x4
        ArmenianScript            = 0x5
        AvestanScript             = 0x6
        BalineseScript            = 0x7
        BamumScript               = 0x8
        BanglaScript              = 0x9
        BengaliScript             = 0x9
        BassaVahScript            = 0xa
        BatakScript               = 0xb
        BhaiksukiScript           = 0xc
        BopomofoScript            = 0xd
        BrahmiScript              = 0xe
        BrailleScript             = 0xf
        BugineseScript            = 0x10
        BuhidScript               = 0x11
        CanadianAboriginalScript  = 0x12
        CarianScript              = 0x13
        CaucasianAlbanianScript   = 0x14
        ChakmaScript              = 0x15
        ChamScript                = 0x16
        CherokeeScript            = 0x17
        CopticScript              = 0x18
        CuneiformScript           = 0x19
        CypriotScript             = 0x1a
        CyrillicScript            = 0x1b
        DeseretScript             = 0x1c
        DevanagariScript          = 0x1d
        DuployanScript            = 0x1e
        EgyptianHieroglyphsScript = 0x1f
        ElbasanScript             = 0x20
        EthiopicScript            = 0x21
        FraserScript              = 0x22
        GeorgianScript            = 0x23
        GlagoliticScript          = 0x24
        GothicScript              = 0x25
        GranthaScript             = 0x26
        GreekScript               = 0x27
        GujaratiScript            = 0x28
        GurmukhiScript            = 0x29
        HangulScript              = 0x2a
        HanScript                 = 0x2b
        HanunooScript             = 0x2c
        HanWithBopomofoScript     = 0x2d
        HatranScript              = 0x2e
        HebrewScript              = 0x2f
        HiraganaScript            = 0x30
        ImperialAramaicScript     = 0x31
        InscriptionalPahlaviScript = 0x32
        InscriptionalParthianScript = 0x33
        JamoScript                = 0x34
        JapaneseScript            = 0x35
        JavaneseScript            = 0x36
        KaithiScript              = 0x37
        KannadaScript             = 0x38
        KatakanaScript            = 0x39
        KayahLiScript             = 0x3a
        KharoshthiScript          = 0x3b
        KhmerScript               = 0x3c
        KhojkiScript              = 0x3d
        KhudawadiScript           = 0x3e
        KoreanScript              = 0x3f
        LannaScript               = 0x40
        LaoScript                 = 0x41
        LatinScript               = 0x42
        LepchaScript              = 0x43
        LimbuScript               = 0x44
        LinearAScript             = 0x45
        LinearBScript             = 0x46
        LycianScript              = 0x47
        LydianScript              = 0x48
        MahajaniScript            = 0x49
        MalayalamScript           = 0x4a
        MandaeanScript            = 0x4b
        ManichaeanScript          = 0x4c
        MarchenScript             = 0x4d
        MeiteiMayekScript         = 0x4e
        MendeKikakuiScript        = 0x4f
        MendeScript               = 0x4f
        MeroiticCursiveScript     = 0x50
        MeroiticScript            = 0x51
        ModiScript                = 0x52
        MongolianScript           = 0x53
        MroScript                 = 0x54
        MultaniScript             = 0x55
        MyanmarScript             = 0x56
        NabataeanScript           = 0x57
        NewaScript                = 0x58
        NewTaiLueScript           = 0x59
        NkoScript                 = 0x5a
        OdiaScript                = 0x5b
        OriyaScript               = 0x5b
        OghamScript               = 0x5c
        OlChikiScript             = 0x5d
        OldHungarianScript        = 0x5e
        OldItalicScript           = 0x5f
        OldNorthArabianScript     = 0x60
        OldPermicScript           = 0x61
        OldPersianScript          = 0x62
        OldSouthArabianScript     = 0x63
        OrkhonScript              = 0x64
        OsageScript               = 0x65
        OsmanyaScript             = 0x66
        PahawhHmongScript         = 0x67
        PalmyreneScript           = 0x68
        PauCinHauScript           = 0x69
        PhagsPaScript             = 0x6a
        PhoenicianScript          = 0x6b
        PollardPhoneticScript     = 0x6c
        PsalterPahlaviScript      = 0x6d
        RejangScript              = 0x6e
        RunicScript               = 0x6f
        SamaritanScript           = 0x70
        SaurashtraScript          = 0x71
        SharadaScript             = 0x72
        ShavianScript             = 0x73
        SiddhamScript             = 0x74
        SignWritingScript         = 0x75
        SimplifiedChineseScript   = 0x76
        SimplifiedHanScript       = 0x76
        SinhalaScript             = 0x77
        SoraSompengScript         = 0x78
        SundaneseScript           = 0x79
        SylotiNagriScript         = 0x7a
        SyriacScript              = 0x7b
        TagalogScript             = 0x7c
        TagbanwaScript            = 0x7d
        TaiLeScript               = 0x7e
        TaiVietScript             = 0x7f
        TakriScript               = 0x80
        TamilScript               = 0x81
        TangutScript              = 0x82
        TeluguScript              = 0x83
        ThaanaScript              = 0x84
        ThaiScript                = 0x85
        TibetanScript             = 0x86
        TifinaghScript            = 0x87
        TirhutaScript             = 0x88
        TraditionalChineseScript  = 0x89
        TraditionalHanScript      = 0x89
        UgariticScript            = 0x8a
        VaiScript                 = 0x8b
        VarangKshitiScript        = 0x8c
        YiScript                  = 0x8d
        HanifiScript              = 0x8e
        LastScript                = 0x8e

    class TagSeparator(enum.Enum):

        Dash                      = 0x2d
        Underscore                = 0x5f


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, language: PySide6.QtCore.QLocale.Language, territory: PySide6.QtCore.QLocale.Country, /) -> None: ...
    @typing.overload
    def __init__(self, language: PySide6.QtCore.QLocale.Language, /, script: PySide6.QtCore.QLocale.Script = ..., territory: PySide6.QtCore.QLocale.Country = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QLocale, /) -> None: ...
    @typing.overload
    def __init__(self, name: str, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, lhs: PySide6.QtCore.QLocale.Language, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    @typing.overload
    def __ne__(self, lhs: PySide6.QtCore.QLocale.Language, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def amText(self, /) -> str: ...
    def bcp47Name(self, /, separator: PySide6.QtCore.QLocale.TagSeparator = ...) -> str: ...
    @staticmethod
    def c() -> PySide6.QtCore.QLocale: ...
    @staticmethod
    def codeToCountry(countryCode: str, /) -> PySide6.QtCore.QLocale.Country: ...
    @staticmethod
    def codeToLanguage(languageCode: str, /, codeTypes: PySide6.QtCore.QLocale.LanguageCodeType = ...) -> PySide6.QtCore.QLocale.Language: ...
    @staticmethod
    def codeToScript(scriptCode: str, /) -> PySide6.QtCore.QLocale.Script: ...
    @staticmethod
    def codeToTerritory(territoryCode: str, /) -> PySide6.QtCore.QLocale.Country: ...
    def collation(self, /) -> PySide6.QtCore.QLocale: ...
    @staticmethod
    def countriesForLanguage(lang: PySide6.QtCore.QLocale.Language, /) -> typing.List[PySide6.QtCore.QLocale.Country]: ...
    def country(self, /) -> PySide6.QtCore.QLocale.Country: ...
    @staticmethod
    def countryToCode(country: PySide6.QtCore.QLocale.Country, /) -> str: ...
    @staticmethod
    def countryToString(country: PySide6.QtCore.QLocale.Country, /) -> str: ...
    def createSeparatedList(self, strl: collections.abc.Sequence[str], /) -> str: ...
    def currencySymbol(self, /, arg__1: PySide6.QtCore.QLocale.CurrencySymbolFormat = ...) -> str: ...
    def dateFormat(self, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    def dateTimeFormat(self, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    def dayName(self, arg__1: int, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    def decimalPoint(self, /) -> str: ...
    def exponential(self, /) -> str: ...
    def firstDayOfWeek(self, /) -> PySide6.QtCore.Qt.DayOfWeek: ...
    def formattedDataSize(self, bytes: int, /, precision: int = ..., format: PySide6.QtCore.QLocale.DataSizeFormat = ...) -> str: ...
    def groupSeparator(self, /) -> str: ...
    def language(self, /) -> PySide6.QtCore.QLocale.Language: ...
    @staticmethod
    def languageToCode(language: PySide6.QtCore.QLocale.Language, /, codeTypes: PySide6.QtCore.QLocale.LanguageCodeType = ...) -> str: ...
    @staticmethod
    def languageToString(language: PySide6.QtCore.QLocale.Language, /) -> str: ...
    @staticmethod
    def matchingLocales(language: PySide6.QtCore.QLocale.Language, script: PySide6.QtCore.QLocale.Script, territory: PySide6.QtCore.QLocale.Country, /) -> typing.List[PySide6.QtCore.QLocale]: ...
    def measurementSystem(self, /) -> PySide6.QtCore.QLocale.MeasurementSystem: ...
    def monthName(self, arg__1: int, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    def name(self, /, separator: PySide6.QtCore.QLocale.TagSeparator = ...) -> str: ...
    def nativeCountryName(self, /) -> str: ...
    def nativeLanguageName(self, /) -> str: ...
    def nativeTerritoryName(self, /) -> str: ...
    def negativeSign(self, /) -> str: ...
    def numberOptions(self, /) -> PySide6.QtCore.QLocale.NumberOption: ...
    def percent(self, /) -> str: ...
    def pmText(self, /) -> str: ...
    def positiveSign(self, /) -> str: ...
    def quoteString(self, str: str, /, style: PySide6.QtCore.QLocale.QuotationStyle = ...) -> str: ...
    def script(self, /) -> PySide6.QtCore.QLocale.Script: ...
    @staticmethod
    def scriptToCode(script: PySide6.QtCore.QLocale.Script, /) -> str: ...
    @staticmethod
    def scriptToString(script: PySide6.QtCore.QLocale.Script, /) -> str: ...
    @staticmethod
    def setDefault(locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> None: ...
    def setNumberOptions(self, options: PySide6.QtCore.QLocale.NumberOption, /) -> None: ...
    def standaloneDayName(self, arg__1: int, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    def standaloneMonthName(self, arg__1: int, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    def swap(self, other: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> None: ...
    @staticmethod
    def system() -> PySide6.QtCore.QLocale: ...
    def territory(self, /) -> PySide6.QtCore.QLocale.Country: ...
    @staticmethod
    def territoryToCode(territory: PySide6.QtCore.QLocale.Country, /) -> str: ...
    @staticmethod
    def territoryToString(territory: PySide6.QtCore.QLocale.Country, /) -> str: ...
    def textDirection(self, /) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def timeFormat(self, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1: int, /, symbol: str = ...) -> str: ...
    @typing.overload
    def toCurrencyString(self, arg__1: float, /, symbol: str = ..., precision: int = ...) -> str: ...
    @typing.overload
    def toDate(self, string: str, format: PySide6.QtCore.QLocale.FormatType, cal: PySide6.QtCore.QCalendar, /, baseYear: int = ...) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def toDate(self, string: str, /, format: PySide6.QtCore.QLocale.FormatType = ..., baseYear: int = ...) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def toDate(self, string: str, format: str, cal: PySide6.QtCore.QCalendar, /, baseYear: int = ...) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def toDate(self, string: str, format: str, /, baseYear: int = ...) -> PySide6.QtCore.QDate: ...
    @typing.overload
    def toDateTime(self, string: str, format: PySide6.QtCore.QLocale.FormatType, cal: PySide6.QtCore.QCalendar, /, baseYear: int = ...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def toDateTime(self, string: str, /, format: PySide6.QtCore.QLocale.FormatType = ..., baseYear: int = ...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def toDateTime(self, string: str, format: str, cal: PySide6.QtCore.QCalendar, /, baseYear: int = ...) -> PySide6.QtCore.QDateTime: ...
    @typing.overload
    def toDateTime(self, string: str, format: str, /, baseYear: int = ...) -> PySide6.QtCore.QDateTime: ...
    def toDouble(self, s: str, /) -> typing.Tuple[float, bool]: ...
    def toFloat(self, s: str, /) -> typing.Tuple[float, bool]: ...
    def toInt(self, s: str, /) -> typing.Tuple[int, bool]: ...
    def toLong(self, s: str, /) -> typing.Tuple[int, bool]: ...
    def toLongLong(self, s: str, /) -> typing.Tuple[int, bool]: ...
    def toLower(self, str: str, /) -> str: ...
    def toShort(self, s: str, /) -> typing.Tuple[int, bool]: ...
    @typing.overload
    def toString(self, date: PySide6.QtCore.QDate, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    @typing.overload
    def toString(self, date: PySide6.QtCore.QDate, format: PySide6.QtCore.QLocale.FormatType, cal: PySide6.QtCore.QCalendar, /) -> str: ...
    @typing.overload
    def toString(self, date: PySide6.QtCore.QDate, format: str, /) -> str: ...
    @typing.overload
    def toString(self, dateTime: PySide6.QtCore.QDateTime, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    @typing.overload
    def toString(self, dateTime: PySide6.QtCore.QDateTime, format: PySide6.QtCore.QLocale.FormatType, cal: PySide6.QtCore.QCalendar, /) -> str: ...
    @typing.overload
    def toString(self, dateTime: PySide6.QtCore.QDateTime, format: str, /) -> str: ...
    @typing.overload
    def toString(self, time: PySide6.QtCore.QTime, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> str: ...
    @typing.overload
    def toString(self, time: PySide6.QtCore.QTime, format: str, /) -> str: ...
    @typing.overload
    def toString(self, i: int, /) -> str: ...
    @typing.overload
    def toString(self, f: float, /, format: str = ..., precision: int = ...) -> str: ...
    @typing.overload
    def toTime(self, string: str, /, format: PySide6.QtCore.QLocale.FormatType = ...) -> PySide6.QtCore.QTime: ...
    @typing.overload
    def toTime(self, string: str, format: str, /) -> PySide6.QtCore.QTime: ...
    def toUInt(self, s: str, /) -> typing.Tuple[int, bool]: ...
    def toULong(self, s: str, /) -> typing.Tuple[int, bool]: ...
    def toULongLong(self, s: str, /) -> typing.Tuple[int, bool]: ...
    def toUShort(self, s: str, /) -> typing.Tuple[int, bool]: ...
    def toUpper(self, str: str, /) -> str: ...
    def uiLanguages(self, /, separator: PySide6.QtCore.QLocale.TagSeparator = ...) -> typing.List[str]: ...
    def weekdays(self, /) -> typing.List[PySide6.QtCore.Qt.DayOfWeek]: ...
    def zeroDigit(self, /) -> str: ...


class QLocationPermission(Shiboken.Object):

    class Accuracy(enum.Enum):

        Approximate               = 0x0
        Precise                   = 0x1

    class Availability(enum.Enum):

        WhenInUse                 = 0x0
        Always                    = 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QLocationPermission, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def accuracy(self, /) -> PySide6.QtCore.QLocationPermission.Accuracy: ...
    def availability(self, /) -> PySide6.QtCore.QLocationPermission.Availability: ...
    def setAccuracy(self, accuracy: PySide6.QtCore.QLocationPermission.Accuracy, /) -> None: ...
    def setAvailability(self, availability: PySide6.QtCore.QLocationPermission.Availability, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QLocationPermission, /) -> None: ...


class QLockFile(Shiboken.Object):

    class LockError(enum.Enum):

        NoError                   = 0x0
        LockFailedError           = 0x1
        PermissionError           = 0x2
        UnknownError              = 0x3


    def __init__(self, fileName: str, /) -> None: ...

    def error(self, /) -> PySide6.QtCore.QLockFile.LockError: ...
    def fileName(self, /) -> str: ...
    def getLockInfo(self, /) -> typing.Tuple[int, str, str]: ...
    def isLocked(self, /) -> bool: ...
    def lock(self, /) -> bool: ...
    def removeStaleLockFile(self, /) -> bool: ...
    def setStaleLockTime(self, arg__1: int, /) -> None: ...
    def staleLockTime(self, /) -> int: ...
    def staleLockTimeAsDuration(self, /) -> int: ...
    def tryLock(self, timeout: int, /) -> bool: ...
    def unlock(self, /) -> None: ...


class QLoggingCategory(Shiboken.Object):

    def __init__(self, category: bytes | bytearray | memoryview, /, severityLevel: PySide6.QtCore.QtMsgType = ...) -> None: ...

    def __call__(self, /) -> PySide6.QtCore.QLoggingCategory: ...
    def categoryName(self, /) -> bytes | bytearray | memoryview: ...
    @staticmethod
    def defaultCategory() -> PySide6.QtCore.QLoggingCategory: ...
    def isCriticalEnabled(self, /) -> bool: ...
    def isDebugEnabled(self, /) -> bool: ...
    def isEnabled(self, type: PySide6.QtCore.QtMsgType, /) -> bool: ...
    def isInfoEnabled(self, /) -> bool: ...
    def isWarningEnabled(self, /) -> bool: ...
    def setEnabled(self, type: PySide6.QtCore.QtMsgType, enable: bool, /) -> None: ...
    @staticmethod
    def setFilterRules(rules: str, /) -> None: ...


class QMargins(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QMargins: PySide6.QtCore.QMargins, /) -> None: ...
    @typing.overload
    def __init__(self, left: int, top: int, right: int, bottom: int, /) -> None: ...

    @typing.overload
    def __add__(self, m2: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __add__(self, lhs: int, /) -> PySide6.QtCore.QMargins: ...
    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QMargins, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> bool: ...
    @typing.overload  # type: ignore[misc]
    def __iadd__(self, margins: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __iadd__(self, arg__1: int, /) -> PySide6.QtCore.QMargins: ...
    @typing.overload  # type: ignore[misc]
    def __imul__(self, arg__1: int, /) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __imul__(self, arg__1: float, /) -> PySide6.QtCore.QMargins: ...
    @typing.overload  # type: ignore[misc]
    def __isub__(self, margins: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __isub__(self, arg__1: int, /) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __mul__(self, factor: int, /) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __mul__(self, factor: float, /) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QMargins, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> bool: ...
    def __neg__(self, /) -> PySide6.QtCore.QMargins: ...
    def __or__(self, m2: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QMargins: ...
    def __pos__(self, /) -> PySide6.QtCore.QMargins: ...
    def __repr__(self, /) -> str: ...
    @typing.overload
    def __sub__(self, m2: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QMargins: ...
    @typing.overload
    def __sub__(self, rhs: int, /) -> PySide6.QtCore.QMargins: ...
    def bottom(self, /) -> int: ...
    def isNull(self, /) -> bool: ...
    def left(self, /) -> int: ...
    def right(self, /) -> int: ...
    def setBottom(self, bottom: int, /) -> None: ...
    def setLeft(self, left: int, /) -> None: ...
    def setRight(self, right: int, /) -> None: ...
    def setTop(self, top: int, /) -> None: ...
    def toMarginsF(self, /) -> PySide6.QtCore.QMarginsF: ...
    def top(self, /) -> int: ...


class QMarginsF(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, margins: PySide6.QtCore.QMargins, /) -> None: ...
    @typing.overload
    def __init__(self, QMarginsF: PySide6.QtCore.QMarginsF, /) -> None: ...
    @typing.overload
    def __init__(self, left: float, top: float, right: float, bottom: float, /) -> None: ...

    @typing.overload
    def __add__(self, rhs: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __add__(self, lhs: float, /) -> PySide6.QtCore.QMarginsF: ...
    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QMargins, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> bool: ...
    @typing.overload  # type: ignore[misc]
    def __iadd__(self, margins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __iadd__(self, addend: float, /) -> PySide6.QtCore.QMarginsF: ...
    def __imul__(self, factor: float, /) -> PySide6.QtCore.QMarginsF: ...  # type: ignore[misc]
    @typing.overload  # type: ignore[misc]
    def __isub__(self, margins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __isub__(self, subtrahend: float, /) -> PySide6.QtCore.QMarginsF: ...
    def __mul__(self, lhs: float, /) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QMargins, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> bool: ...
    def __neg__(self, /) -> PySide6.QtCore.QMarginsF: ...
    def __or__(self, m2: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QMarginsF: ...
    def __pos__(self, /) -> PySide6.QtCore.QMarginsF: ...
    def __repr__(self, /) -> str: ...
    @typing.overload
    def __sub__(self, rhs: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QMarginsF: ...
    @typing.overload
    def __sub__(self, rhs: float, /) -> PySide6.QtCore.QMarginsF: ...
    def bottom(self, /) -> float: ...
    def isNull(self, /) -> bool: ...
    def left(self, /) -> float: ...
    def right(self, /) -> float: ...
    def setBottom(self, abottom: float, /) -> None: ...
    def setLeft(self, aleft: float, /) -> None: ...
    def setRight(self, aright: float, /) -> None: ...
    def setTop(self, atop: float, /) -> None: ...
    def toMargins(self, /) -> PySide6.QtCore.QMargins: ...
    def top(self, /) -> float: ...


class QMessageAuthenticationCode(Shiboken.Object):

    def __init__(self, method: PySide6.QtCore.QCryptographicHash.Algorithm, /, key: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ...) -> None: ...

    @typing.overload
    def addData(self, device: PySide6.QtCore.QIODevice, /) -> bool: ...
    @typing.overload
    def addData(self, data: bytes | bytearray | memoryview, length: int, /) -> None: ...
    @typing.overload
    def addData(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    @staticmethod
    def hash(message: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, key: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, method: PySide6.QtCore.QCryptographicHash.Algorithm, /) -> PySide6.QtCore.QByteArray: ...
    def reset(self, /) -> None: ...
    def result(self, /) -> PySide6.QtCore.QByteArray: ...
    def resultView(self, /) -> PySide6.QtCore.QByteArray: ...
    def setKey(self, key: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QMessageAuthenticationCode, /) -> None: ...


class QMessageLogContext(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, fileName: bytes | bytearray | memoryview, lineNumber: int, functionName: bytes | bytearray | memoryview, categoryName: bytes | bytearray | memoryview, /) -> None: ...


class QMessageLogger(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, file: bytes | bytearray | memoryview, line: int, function: bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    def __init__(self, file: bytes | bytearray | memoryview, line: int, function: bytes | bytearray | memoryview, category: bytes | bytearray | memoryview, /) -> None: ...

    @typing.overload
    def critical(self, cat: PySide6.QtCore.QLoggingCategory, msg: str, /) -> None: ...
    @typing.overload
    def critical(self, msg: str, /) -> None: ...
    @typing.overload
    def debug(self, cat: PySide6.QtCore.QLoggingCategory, msg: str, /) -> None: ...
    @typing.overload
    def debug(self, msg: str, /) -> None: ...
    @typing.overload
    def fatal(self, cat: PySide6.QtCore.QLoggingCategory, msg: str, /) -> None: ...
    @typing.overload
    def fatal(self, msg: str, /) -> None: ...
    @typing.overload
    def info(self, cat: PySide6.QtCore.QLoggingCategory, msg: str, /) -> None: ...
    @typing.overload
    def info(self, msg: str, /) -> None: ...
    def noDebug(self, arg__1: str, /) -> None: ...
    @typing.overload
    def warning(self, cat: PySide6.QtCore.QLoggingCategory, msg: str, /) -> None: ...
    @typing.overload
    def warning(self, msg: str, /) -> None: ...


class QMetaClassInfo(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QMetaClassInfo: PySide6.QtCore.QMetaClassInfo, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def name(self, /) -> bytes | bytearray | memoryview: ...
    def value(self, /) -> bytes | bytearray | memoryview: ...


class QMetaEnum(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QMetaEnum: PySide6.QtCore.QMetaEnum, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def enumName(self, /) -> bytes | bytearray | memoryview: ...
    def is64Bit(self, /) -> bool: ...
    def isFlag(self, /) -> bool: ...
    def isScoped(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def key(self, index: int, /) -> bytes | bytearray | memoryview: ...
    def keyCount(self, /) -> int: ...
    def keyToValue(self, key: bytes | bytearray | memoryview, /) -> typing.Tuple: ...
    def keysToValue(self, keys: bytes | bytearray | memoryview, /) -> typing.Tuple: ...
    def metaType(self, /) -> PySide6.QtCore.QMetaType: ...
    def name(self, /) -> bytes | bytearray | memoryview: ...
    def scope(self, /) -> bytes | bytearray | memoryview: ...
    def value(self, index: int, /) -> int: ...
    def valueToKey(self, value: int, /) -> bytes | bytearray | memoryview: ...
    def valueToKeys(self, value: int, /) -> PySide6.QtCore.QByteArray: ...


class QMetaMethod(Shiboken.Object):

    class Access(enum.Enum):

        Private                   = 0x0
        Protected                 = 0x1
        Public                    = 0x2

    class MethodType(enum.Enum):

        Method                    = 0x0
        Signal                    = 0x1
        Slot                      = 0x2
        Constructor               = 0x3


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QMetaMethod: PySide6.QtCore.QMetaMethod, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QMetaMethod, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QMetaMethod, /) -> bool: ...
    def access(self, /) -> PySide6.QtCore.QMetaMethod.Access: ...
    def enclosingMetaObject(self, /) -> PySide6.QtCore.QMetaObject: ...
    @staticmethod
    def fromSignal(signal: PySide6.QtCore.SignalInstance, /) -> PySide6.QtCore.QMetaMethod: ...
    @typing.overload
    def invoke(self, object: PySide6.QtCore.QObject, returnValue: PySide6.QtCore.QGenericReturnArgument, /, val0: PySide6.QtCore.QGenericArgument = ..., val1: PySide6.QtCore.QGenericArgument = ..., val2: PySide6.QtCore.QGenericArgument = ..., val3: PySide6.QtCore.QGenericArgument = ..., val4: PySide6.QtCore.QGenericArgument = ..., val5: PySide6.QtCore.QGenericArgument = ..., val6: PySide6.QtCore.QGenericArgument = ..., val7: PySide6.QtCore.QGenericArgument = ..., val8: PySide6.QtCore.QGenericArgument = ..., val9: PySide6.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    def invoke(self, object: PySide6.QtCore.QObject, connectionType: PySide6.QtCore.Qt.ConnectionType, returnValue: PySide6.QtCore.QGenericReturnArgument, /, val0: PySide6.QtCore.QGenericArgument = ..., val1: PySide6.QtCore.QGenericArgument = ..., val2: PySide6.QtCore.QGenericArgument = ..., val3: PySide6.QtCore.QGenericArgument = ..., val4: PySide6.QtCore.QGenericArgument = ..., val5: PySide6.QtCore.QGenericArgument = ..., val6: PySide6.QtCore.QGenericArgument = ..., val7: PySide6.QtCore.QGenericArgument = ..., val8: PySide6.QtCore.QGenericArgument = ..., val9: PySide6.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    def invoke(self, object: PySide6.QtCore.QObject, connectionType: PySide6.QtCore.Qt.ConnectionType, val0: PySide6.QtCore.QGenericArgument, /, val1: PySide6.QtCore.QGenericArgument = ..., val2: PySide6.QtCore.QGenericArgument = ..., val3: PySide6.QtCore.QGenericArgument = ..., val4: PySide6.QtCore.QGenericArgument = ..., val5: PySide6.QtCore.QGenericArgument = ..., val6: PySide6.QtCore.QGenericArgument = ..., val7: PySide6.QtCore.QGenericArgument = ..., val8: PySide6.QtCore.QGenericArgument = ..., val9: PySide6.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    def invoke(self, object: PySide6.QtCore.QObject, type: PySide6.QtCore.Qt.ConnectionType, /, val0: PySide6.QtCore.QGenericArgumentHolder = ..., val1: PySide6.QtCore.QGenericArgumentHolder = ..., val2: PySide6.QtCore.QGenericArgumentHolder = ..., val3: PySide6.QtCore.QGenericArgumentHolder = ..., val4: PySide6.QtCore.QGenericArgumentHolder = ..., val5: PySide6.QtCore.QGenericArgumentHolder = ..., val6: PySide6.QtCore.QGenericArgumentHolder = ..., val7: PySide6.QtCore.QGenericArgumentHolder = ..., val8: PySide6.QtCore.QGenericArgumentHolder = ..., val9: PySide6.QtCore.QGenericArgumentHolder = ...) -> object: ...
    @typing.overload
    def invoke(self, object: PySide6.QtCore.QObject, type: PySide6.QtCore.Qt.ConnectionType, ret: PySide6.QtCore.QGenericReturnArgumentHolder, /, val0: PySide6.QtCore.QGenericArgumentHolder = ..., val1: PySide6.QtCore.QGenericArgumentHolder = ..., val2: PySide6.QtCore.QGenericArgumentHolder = ..., val3: PySide6.QtCore.QGenericArgumentHolder = ..., val4: PySide6.QtCore.QGenericArgumentHolder = ..., val5: PySide6.QtCore.QGenericArgumentHolder = ..., val6: PySide6.QtCore.QGenericArgumentHolder = ..., val7: PySide6.QtCore.QGenericArgumentHolder = ..., val8: PySide6.QtCore.QGenericArgumentHolder = ..., val9: PySide6.QtCore.QGenericArgumentHolder = ...) -> object: ...
    @typing.overload
    def invoke(self, object: PySide6.QtCore.QObject, val0: PySide6.QtCore.QGenericArgument, /, val1: PySide6.QtCore.QGenericArgument = ..., val2: PySide6.QtCore.QGenericArgument = ..., val3: PySide6.QtCore.QGenericArgument = ..., val4: PySide6.QtCore.QGenericArgument = ..., val5: PySide6.QtCore.QGenericArgument = ..., val6: PySide6.QtCore.QGenericArgument = ..., val7: PySide6.QtCore.QGenericArgument = ..., val8: PySide6.QtCore.QGenericArgument = ..., val9: PySide6.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    def invoke(self, object: PySide6.QtCore.QObject, /, val0: PySide6.QtCore.QGenericArgumentHolder = ..., val1: PySide6.QtCore.QGenericArgumentHolder = ..., val2: PySide6.QtCore.QGenericArgumentHolder = ..., val3: PySide6.QtCore.QGenericArgumentHolder = ..., val4: PySide6.QtCore.QGenericArgumentHolder = ..., val5: PySide6.QtCore.QGenericArgumentHolder = ..., val6: PySide6.QtCore.QGenericArgumentHolder = ..., val7: PySide6.QtCore.QGenericArgumentHolder = ..., val8: PySide6.QtCore.QGenericArgumentHolder = ..., val9: PySide6.QtCore.QGenericArgumentHolder = ...) -> object: ...
    @typing.overload
    def invoke(self, object: PySide6.QtCore.QObject, ret: PySide6.QtCore.QGenericReturnArgumentHolder, /, val0: PySide6.QtCore.QGenericArgumentHolder = ..., val1: PySide6.QtCore.QGenericArgumentHolder = ..., val2: PySide6.QtCore.QGenericArgumentHolder = ..., val3: PySide6.QtCore.QGenericArgumentHolder = ..., val4: PySide6.QtCore.QGenericArgumentHolder = ..., val5: PySide6.QtCore.QGenericArgumentHolder = ..., val6: PySide6.QtCore.QGenericArgumentHolder = ..., val7: PySide6.QtCore.QGenericArgumentHolder = ..., val8: PySide6.QtCore.QGenericArgumentHolder = ..., val9: PySide6.QtCore.QGenericArgumentHolder = ...) -> object: ...
    @typing.overload
    def invokeOnGadget(self, gadget: int, returnValue: PySide6.QtCore.QGenericReturnArgument, /, val0: PySide6.QtCore.QGenericArgument = ..., val1: PySide6.QtCore.QGenericArgument = ..., val2: PySide6.QtCore.QGenericArgument = ..., val3: PySide6.QtCore.QGenericArgument = ..., val4: PySide6.QtCore.QGenericArgument = ..., val5: PySide6.QtCore.QGenericArgument = ..., val6: PySide6.QtCore.QGenericArgument = ..., val7: PySide6.QtCore.QGenericArgument = ..., val8: PySide6.QtCore.QGenericArgument = ..., val9: PySide6.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    def invokeOnGadget(self, gadget: int, val0: PySide6.QtCore.QGenericArgument, /, val1: PySide6.QtCore.QGenericArgument = ..., val2: PySide6.QtCore.QGenericArgument = ..., val3: PySide6.QtCore.QGenericArgument = ..., val4: PySide6.QtCore.QGenericArgument = ..., val5: PySide6.QtCore.QGenericArgument = ..., val6: PySide6.QtCore.QGenericArgument = ..., val7: PySide6.QtCore.QGenericArgument = ..., val8: PySide6.QtCore.QGenericArgument = ..., val9: PySide6.QtCore.QGenericArgument = ...) -> bool: ...
    def isConst(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def methodIndex(self, /) -> int: ...
    def methodSignature(self, /) -> PySide6.QtCore.QByteArray: ...
    def methodType(self, /) -> PySide6.QtCore.QMetaMethod.MethodType: ...
    def name(self, /) -> PySide6.QtCore.QByteArray: ...
    def nameView(self, /) -> PySide6.QtCore.QByteArray: ...
    def parameterCount(self, /) -> int: ...
    def parameterMetaType(self, index: int, /) -> PySide6.QtCore.QMetaType: ...
    def parameterNames(self, /) -> typing.List[PySide6.QtCore.QByteArray]: ...
    def parameterType(self, index: int, /) -> int: ...
    def parameterTypeName(self, index: int, /) -> PySide6.QtCore.QByteArray: ...
    def parameterTypes(self, /) -> typing.List[PySide6.QtCore.QByteArray]: ...
    def relativeMethodIndex(self, /) -> int: ...
    def returnMetaType(self, /) -> PySide6.QtCore.QMetaType: ...
    def returnType(self, /) -> int: ...
    def revision(self, /) -> int: ...
    def tag(self, /) -> bytes | bytearray | memoryview: ...
    def typeName(self, /) -> bytes | bytearray | memoryview: ...


class QMetaObject(Shiboken.Object):

    class Call(enum.Enum):

        InvokeMetaMethod          = 0x0
        ReadProperty              = 0x1
        WriteProperty             = 0x2
        ResetProperty             = 0x3
        CreateInstance            = 0x4
        IndexOfMethod             = 0x5
        RegisterPropertyMetaType  = 0x6
        RegisterMethodArgumentMetaType = 0x7
        BindableProperty          = 0x8
        CustomCall                = 0x9
        ConstructInPlace          = 0xa

    class Connection(Shiboken.Object):

        @typing.overload
        def __init__(self, /) -> None: ...
        @typing.overload
        def __init__(self, other: PySide6.QtCore.QMetaObject.Connection, /) -> None: ...

        def __copy__(self, /) -> typing.Self: ...
        def swap(self, other: PySide6.QtCore.QMetaObject.Connection, /) -> None: ...


    def __init__(self, /) -> None: ...

    def __repr__(self, /) -> str: ...
    def cast(self, obj: PySide6.QtCore.QObject, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    @staticmethod
    def checkConnectArgs(signal: PySide6.QtCore.QMetaMethod, method: PySide6.QtCore.QMetaMethod, /) -> bool: ...
    @typing.overload
    @staticmethod
    def checkConnectArgs(signal: bytes | bytearray | memoryview, method: bytes | bytearray | memoryview, /) -> bool: ...
    def classInfo(self, index: int, /) -> PySide6.QtCore.QMetaClassInfo: ...
    def classInfoCount(self, /) -> int: ...
    def classInfoOffset(self, /) -> int: ...
    def className(self, /) -> bytes | bytearray | memoryview: ...
    @staticmethod
    def connectSlotsByName(o: PySide6.QtCore.QObject, /) -> None: ...
    def constructor(self, index: int, /) -> PySide6.QtCore.QMetaMethod: ...
    def constructorCount(self, /) -> int: ...
    @staticmethod
    def disconnect(sender: PySide6.QtCore.QObject, signal_index: int, receiver: PySide6.QtCore.QObject, method_index: int, /) -> bool: ...
    @staticmethod
    def disconnectOne(sender: PySide6.QtCore.QObject, signal_index: int, receiver: PySide6.QtCore.QObject, method_index: int, /) -> bool: ...
    def enumerator(self, index: int, /) -> PySide6.QtCore.QMetaEnum: ...
    def enumeratorCount(self, /) -> int: ...
    def enumeratorOffset(self, /) -> int: ...
    def indexOfClassInfo(self, name: str, /) -> int: ...
    def indexOfConstructor(self, constructor: str, /) -> int: ...
    def indexOfEnumerator(self, name: str, /) -> int: ...
    def indexOfMethod(self, method: str, /) -> int: ...
    def indexOfProperty(self, name: str, /) -> int: ...
    def indexOfSignal(self, signal: str, /) -> int: ...
    def indexOfSlot(self, slot: str, /) -> int: ...
    def inherits(self, metaObject: PySide6.QtCore.QMetaObject, /) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, ret: PySide6.QtCore.QGenericReturnArgument, /, val0: PySide6.QtCore.QGenericArgument = ..., val1: PySide6.QtCore.QGenericArgument = ..., val2: PySide6.QtCore.QGenericArgument = ..., val3: PySide6.QtCore.QGenericArgument = ..., val4: PySide6.QtCore.QGenericArgument = ..., val5: PySide6.QtCore.QGenericArgument = ..., val6: PySide6.QtCore.QGenericArgument = ..., val7: PySide6.QtCore.QGenericArgument = ..., val8: PySide6.QtCore.QGenericArgument = ..., val9: PySide6.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, arg__3: PySide6.QtCore.Qt.ConnectionType, ret: PySide6.QtCore.QGenericReturnArgument, /, val0: PySide6.QtCore.QGenericArgument = ..., val1: PySide6.QtCore.QGenericArgument = ..., val2: PySide6.QtCore.QGenericArgument = ..., val3: PySide6.QtCore.QGenericArgument = ..., val4: PySide6.QtCore.QGenericArgument = ..., val5: PySide6.QtCore.QGenericArgument = ..., val6: PySide6.QtCore.QGenericArgument = ..., val7: PySide6.QtCore.QGenericArgument = ..., val8: PySide6.QtCore.QGenericArgument = ..., val9: PySide6.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, type: PySide6.QtCore.Qt.ConnectionType, val0: PySide6.QtCore.QGenericArgument, /, val1: PySide6.QtCore.QGenericArgument = ..., val2: PySide6.QtCore.QGenericArgument = ..., val3: PySide6.QtCore.QGenericArgument = ..., val4: PySide6.QtCore.QGenericArgument = ..., val5: PySide6.QtCore.QGenericArgument = ..., val6: PySide6.QtCore.QGenericArgument = ..., val7: PySide6.QtCore.QGenericArgument = ..., val8: PySide6.QtCore.QGenericArgument = ..., val9: PySide6.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(object: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, type: PySide6.QtCore.Qt.ConnectionType, /, val0: PySide6.QtCore.QGenericArgumentHolder = ..., val1: PySide6.QtCore.QGenericArgumentHolder = ..., val2: PySide6.QtCore.QGenericArgumentHolder = ..., val3: PySide6.QtCore.QGenericArgumentHolder = ..., val4: PySide6.QtCore.QGenericArgumentHolder = ..., val5: PySide6.QtCore.QGenericArgumentHolder = ..., val6: PySide6.QtCore.QGenericArgumentHolder = ..., val7: PySide6.QtCore.QGenericArgumentHolder = ..., val8: PySide6.QtCore.QGenericArgumentHolder = ..., val9: PySide6.QtCore.QGenericArgumentHolder = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(object: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, type: PySide6.QtCore.Qt.ConnectionType, ret: PySide6.QtCore.QGenericReturnArgumentHolder, /, val0: PySide6.QtCore.QGenericArgumentHolder = ..., val1: PySide6.QtCore.QGenericArgumentHolder = ..., val2: PySide6.QtCore.QGenericArgumentHolder = ..., val3: PySide6.QtCore.QGenericArgumentHolder = ..., val4: PySide6.QtCore.QGenericArgumentHolder = ..., val5: PySide6.QtCore.QGenericArgumentHolder = ..., val6: PySide6.QtCore.QGenericArgumentHolder = ..., val7: PySide6.QtCore.QGenericArgumentHolder = ..., val8: PySide6.QtCore.QGenericArgumentHolder = ..., val9: PySide6.QtCore.QGenericArgumentHolder = ...) -> object: ...
    @typing.overload
    @staticmethod
    def invokeMethod(obj: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, val0: PySide6.QtCore.QGenericArgument, /, val1: PySide6.QtCore.QGenericArgument = ..., val2: PySide6.QtCore.QGenericArgument = ..., val3: PySide6.QtCore.QGenericArgument = ..., val4: PySide6.QtCore.QGenericArgument = ..., val5: PySide6.QtCore.QGenericArgument = ..., val6: PySide6.QtCore.QGenericArgument = ..., val7: PySide6.QtCore.QGenericArgument = ..., val8: PySide6.QtCore.QGenericArgument = ..., val9: PySide6.QtCore.QGenericArgument = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(object: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /, val0: PySide6.QtCore.QGenericArgumentHolder = ..., val1: PySide6.QtCore.QGenericArgumentHolder = ..., val2: PySide6.QtCore.QGenericArgumentHolder = ..., val3: PySide6.QtCore.QGenericArgumentHolder = ..., val4: PySide6.QtCore.QGenericArgumentHolder = ..., val5: PySide6.QtCore.QGenericArgumentHolder = ..., val6: PySide6.QtCore.QGenericArgumentHolder = ..., val7: PySide6.QtCore.QGenericArgumentHolder = ..., val8: PySide6.QtCore.QGenericArgumentHolder = ..., val9: PySide6.QtCore.QGenericArgumentHolder = ...) -> bool: ...
    @typing.overload
    @staticmethod
    def invokeMethod(object: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, ret: PySide6.QtCore.QGenericReturnArgumentHolder, /, val0: PySide6.QtCore.QGenericArgumentHolder = ..., val1: PySide6.QtCore.QGenericArgumentHolder = ..., val2: PySide6.QtCore.QGenericArgumentHolder = ..., val3: PySide6.QtCore.QGenericArgumentHolder = ..., val4: PySide6.QtCore.QGenericArgumentHolder = ..., val5: PySide6.QtCore.QGenericArgumentHolder = ..., val6: PySide6.QtCore.QGenericArgumentHolder = ..., val7: PySide6.QtCore.QGenericArgumentHolder = ..., val8: PySide6.QtCore.QGenericArgumentHolder = ..., val9: PySide6.QtCore.QGenericArgumentHolder = ...) -> object: ...
    def metaType(self, /) -> PySide6.QtCore.QMetaType: ...
    def method(self, index: int, /) -> PySide6.QtCore.QMetaMethod: ...
    def methodCount(self, /) -> int: ...
    def methodOffset(self, /) -> int: ...
    def newInstance(self, val0: PySide6.QtCore.QGenericArgument, /, val1: PySide6.QtCore.QGenericArgument = ..., val2: PySide6.QtCore.QGenericArgument = ..., val3: PySide6.QtCore.QGenericArgument = ..., val4: PySide6.QtCore.QGenericArgument = ..., val5: PySide6.QtCore.QGenericArgument = ..., val6: PySide6.QtCore.QGenericArgument = ..., val7: PySide6.QtCore.QGenericArgument = ..., val8: PySide6.QtCore.QGenericArgument = ..., val9: PySide6.QtCore.QGenericArgument = ...) -> PySide6.QtCore.QObject: ...
    @staticmethod
    def normalizedSignature(method: bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def normalizedType(type: bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    def property(self, index: int, /) -> PySide6.QtCore.QMetaProperty: ...
    def propertyCount(self, /) -> int: ...
    def propertyOffset(self, /) -> int: ...
    def superClass(self, /) -> PySide6.QtCore.QMetaObject: ...
    def userProperty(self, /) -> PySide6.QtCore.QMetaProperty: ...


class QMetaProperty(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QMetaProperty: PySide6.QtCore.QMetaProperty, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def enumerator(self, /) -> PySide6.QtCore.QMetaEnum: ...
    def hasNotifySignal(self, /) -> bool: ...
    def hasStdCppSet(self, /) -> bool: ...
    def isAlias(self, /) -> bool: ...
    def isBindable(self, /) -> bool: ...
    def isConstant(self, /) -> bool: ...
    def isDesignable(self, /) -> bool: ...
    def isEnumType(self, /) -> bool: ...
    def isFinal(self, /) -> bool: ...
    def isFlagType(self, /) -> bool: ...
    def isReadable(self, /) -> bool: ...
    def isRequired(self, /) -> bool: ...
    def isResettable(self, /) -> bool: ...
    def isScriptable(self, /) -> bool: ...
    def isStored(self, /) -> bool: ...
    def isUser(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def isWritable(self, /) -> bool: ...
    def metaType(self, /) -> PySide6.QtCore.QMetaType: ...
    def name(self, /) -> bytes | bytearray | memoryview: ...
    def notifySignal(self, /) -> PySide6.QtCore.QMetaMethod: ...
    def notifySignalIndex(self, /) -> int: ...
    def propertyIndex(self, /) -> int: ...
    def read(self, obj: PySide6.QtCore.QObject, /) -> typing.Any: ...
    def readOnGadget(self, gadget: int, /) -> typing.Any: ...
    def relativePropertyIndex(self, /) -> int: ...
    def reset(self, obj: PySide6.QtCore.QObject, /) -> bool: ...
    def resetOnGadget(self, gadget: int, /) -> bool: ...
    def revision(self, /) -> int: ...
    def typeId(self, /) -> int: ...
    def typeName(self, /) -> bytes | bytearray | memoryview: ...
    def userType(self, /) -> int: ...
    def write(self, obj: PySide6.QtCore.QObject, value: typing.Any, /) -> bool: ...
    def writeOnGadget(self, gadget: int, value: typing.Any, /) -> bool: ...


class QMetaType(Shiboken.Object):

    class Type(enum.IntEnum):

        UnknownType               = 0x0
        Bool                      = 0x1
        FirstCoreType             = 0x1
        Int                       = 0x2
        UInt                      = 0x3
        LongLong                  = 0x4
        ULongLong                 = 0x5
        Double                    = 0x6
        QReal                     = 0x6
        QChar                     = 0x7
        QVariantMap               = 0x8
        QVariantList              = 0x9
        QString                   = 0xa
        QStringList               = 0xb
        QByteArray                = 0xc
        QBitArray                 = 0xd
        QDate                     = 0xe
        QTime                     = 0xf
        QDateTime                 = 0x10
        QUrl                      = 0x11
        QLocale                   = 0x12
        QRect                     = 0x13
        QRectF                    = 0x14
        QSize                     = 0x15
        QSizeF                    = 0x16
        QLine                     = 0x17
        QLineF                    = 0x18
        QPoint                    = 0x19
        QPointF                   = 0x1a
        QVariantHash              = 0x1c
        QEasingCurve              = 0x1d
        QUuid                     = 0x1e
        VoidStar                  = 0x1f
        Long                      = 0x20
        Short                     = 0x21
        Char                      = 0x22
        ULong                     = 0x23
        UShort                    = 0x24
        UChar                     = 0x25
        Float                     = 0x26
        QObjectStar               = 0x27
        SChar                     = 0x28
        QVariant                  = 0x29
        QModelIndex               = 0x2a
        Void                      = 0x2b
        QRegularExpression        = 0x2c
        QJsonValue                = 0x2d
        QJsonObject               = 0x2e
        QJsonArray                = 0x2f
        QJsonDocument             = 0x30
        QByteArrayList            = 0x31
        QPersistentModelIndex     = 0x32
        Nullptr                   = 0x33
        QCborSimpleType           = 0x34
        QCborValue                = 0x35
        QCborArray                = 0x36
        QCborMap                  = 0x37
        Char16                    = 0x38
        Char32                    = 0x39
        QVariantPair              = 0x3a
        Float16                   = 0x3f
        LastCoreType              = 0x3f
        FirstGuiType              = 0x1000
        QFont                     = 0x1000
        QPixmap                   = 0x1001
        QBrush                    = 0x1002
        QColor                    = 0x1003
        QPalette                  = 0x1004
        QIcon                     = 0x1005
        QImage                    = 0x1006
        QPolygon                  = 0x1007
        QRegion                   = 0x1008
        QBitmap                   = 0x1009
        QCursor                   = 0x100a
        QKeySequence              = 0x100b
        QPen                      = 0x100c
        QTextLength               = 0x100d
        QTextFormat               = 0x100e
        QTransform                = 0x1010
        QMatrix4x4                = 0x1011
        QVector2D                 = 0x1012
        QVector3D                 = 0x1013
        QVector4D                 = 0x1014
        QQuaternion               = 0x1015
        QPolygonF                 = 0x1016
        LastGuiType               = 0x1017
        QColorSpace               = 0x1017
        FirstWidgetsType          = 0x2000
        HighestInternalId         = 0x2000
        LastWidgetsType           = 0x2000
        QSizePolicy               = 0x2000
        User                      = 0x10000

    class TypeFlag(enum.Flag):

        NeedsConstruction         = 0x1
        NeedsDestruction          = 0x2
        MovableType               = 0x4
        RelocatableType           = 0x4
        PointerToQObject          = 0x8
        IsEnumeration             = 0x10
        SharedPointerToQObject    = 0x20
        WeakPointerToQObject      = 0x40
        TrackingPointerToQObject  = 0x80
        IsUnsignedEnumeration     = 0x100
        IsGadget                  = 0x200
        PointerToGadget           = 0x400
        IsPointer                 = 0x800
        IsQmlList                 = 0x1000
        IsConst                   = 0x2000
        NeedsCopyConstruction     = 0x4000
        NeedsMoveConstruction     = 0x8000


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QMetaType.Type, /) -> None: ...
    @typing.overload
    def __init__(self, QMetaType: PySide6.QtCore.QMetaType, /) -> None: ...
    @typing.overload
    def __init__(self, py_type: type, /) -> None: ...
    @typing.overload
    def __init__(self, type: int, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __ne__(self, rhs: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, /) -> bool: ...
    def alignOf(self, /) -> int: ...
    @staticmethod
    def canConvert(fromType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, toType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, /) -> bool: ...
    @staticmethod
    def canView(fromType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, toType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, /) -> bool: ...
    @staticmethod
    def compare(lhs: int, rhs: int, typeId: int, /) -> typing.Tuple[bool, int]: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def construct(self, where: int, /, copy: int | None = ...) -> int: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def construct(type: int, where: int, copy: int, /) -> int: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload
    @staticmethod
    def convert(fromType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, from_: int, toType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, to: int, /) -> bool: ...
    @typing.overload
    @staticmethod
    def convert(from_: int, fromTypeId: int, to: int, toTypeId: int, /) -> bool: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def create(self, /, copy: int | None = ...) -> int: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def create(type: int, /, copy: int | None = ...) -> int: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def destroy(self, data: int, /) -> None: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def destroy(type: int, data: int, /) -> None: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def destruct(self, data: int, /) -> None: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def destruct(type: int, where: int, /) -> None: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def equals(self, lhs: int, rhs: int, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def equals(lhs: int, rhs: int, typeId: int, /) -> typing.Tuple[bool, int]: ...  # type: ignore[misc, overload-cannot-match]
    def flags(self, /) -> PySide6.QtCore.QMetaType.TypeFlag: ...
    @staticmethod
    def fromName(name: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QMetaType: ...
    @staticmethod
    def hasRegisteredConverterFunction(fromType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, toType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, /) -> bool: ...
    def hasRegisteredDataStreamOperators(self, /) -> bool: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def hasRegisteredDebugStreamOperator(self, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def hasRegisteredDebugStreamOperator(typeId: int, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def hasRegisteredMutableViewFunction(fromType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, toType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, /) -> bool: ...
    def id(self, /, arg__1: int | None = ...) -> int: ...
    def isCopyConstructible(self, /) -> bool: ...
    def isDefaultConstructible(self, /) -> bool: ...
    def isDestructible(self, /) -> bool: ...
    def isEqualityComparable(self, /) -> bool: ...
    def isMoveConstructible(self, /) -> bool: ...
    def isOrdered(self, /) -> bool: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def isRegistered(self, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def isRegistered(type: int, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    def isValid(self, /) -> bool: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def load(stream: PySide6.QtCore.QDataStream, type: int, data: int, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def load(self, stream: PySide6.QtCore.QDataStream, data: int, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def metaObjectForType(type: int, /) -> PySide6.QtCore.QMetaObject: ...
    def name(self, /) -> bytes | bytearray | memoryview: ...
    @staticmethod
    def registerNormalizedTypedef(normalizedTypeName: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, type: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, /) -> None: ...
    def registerType(self, /) -> None: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def save(stream: PySide6.QtCore.QDataStream, type: int, data: int, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def save(self, stream: PySide6.QtCore.QDataStream, data: int, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def sizeOf(self, /) -> int: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def sizeOf(type: int, /) -> int: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload
    @staticmethod
    def type(typeName: bytes | bytearray | memoryview, /) -> int: ...
    @typing.overload
    @staticmethod
    def type(typeName: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> int: ...
    @staticmethod
    def typeFlags(type: int, /) -> PySide6.QtCore.QMetaType.TypeFlag: ...
    @staticmethod
    def typeName(type: int, /) -> bytes | bytearray | memoryview: ...
    def underlyingType(self, /) -> PySide6.QtCore.QMetaType: ...
    @staticmethod
    def unregisterConverterFunction(from_: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, to: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, /) -> None: ...
    @staticmethod
    def unregisterMetaType(type: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, /) -> None: ...
    @staticmethod
    def unregisterMutableViewFunction(from_: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, to: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, /) -> None: ...
    @staticmethod
    def view(fromType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, from_: int, toType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, to: int, /) -> bool: ...


class QMicrophonePermission(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QMicrophonePermission, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def swap(self, other: PySide6.QtCore.QMicrophonePermission, /) -> None: ...


class QMimeData(PySide6.QtCore.QObject):

    def __init__(self, /) -> None: ...

    def clear(self, /) -> None: ...
    def colorData(self, /) -> typing.Any: ...
    def data(self, mimetype: str, /) -> PySide6.QtCore.QByteArray: ...
    def formats(self, /) -> typing.List[str]: ...
    def hasColor(self, /) -> bool: ...
    def hasFormat(self, mimetype: str, /) -> bool: ...
    def hasHtml(self, /) -> bool: ...
    def hasImage(self, /) -> bool: ...
    def hasText(self, /) -> bool: ...
    def hasUrls(self, /) -> bool: ...
    def html(self, /) -> str: ...
    def imageData(self, /) -> typing.Any: ...
    def removeFormat(self, mimetype: str, /) -> None: ...
    def retrieveData(self, mimetype: str, preferredType: PySide6.QtCore.QMetaType | PySide6.QtCore.QMetaType.Type, /) -> typing.Any: ...
    def setColorData(self, color: typing.Any, /) -> None: ...
    def setData(self, mimetype: str, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    def setHtml(self, html: str, /) -> None: ...
    def setImageData(self, image: typing.Any, /) -> None: ...
    def setText(self, text: str, /) -> None: ...
    def setUrls(self, urls: collections.abc.Sequence[PySide6.QtCore.QUrl], /) -> None: ...
    def text(self, /) -> str: ...
    def urls(self, /) -> typing.List[PySide6.QtCore.QUrl]: ...


class QMimeDatabase(Shiboken.Object):

    class MatchMode(enum.Enum):

        MatchDefault              = 0x0
        MatchExtension            = 0x1
        MatchContent              = 0x2


    def __init__(self, /) -> None: ...

    def allMimeTypes(self, /) -> typing.List[PySide6.QtCore.QMimeType]: ...
    @typing.overload
    def mimeTypeForData(self, device: PySide6.QtCore.QIODevice, /) -> PySide6.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForData(self, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFile(self, fileInfo: PySide6.QtCore.QFileInfo, /, mode: PySide6.QtCore.QMimeDatabase.MatchMode = ...) -> PySide6.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFile(self, fileName: str, /, mode: PySide6.QtCore.QMimeDatabase.MatchMode = ...) -> PySide6.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFileNameAndData(self, fileName: str, device: PySide6.QtCore.QIODevice, /) -> PySide6.QtCore.QMimeType: ...
    @typing.overload
    def mimeTypeForFileNameAndData(self, fileName: str, data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QMimeType: ...
    def mimeTypeForName(self, nameOrAlias: str, /) -> PySide6.QtCore.QMimeType: ...
    def mimeTypeForUrl(self, url: PySide6.QtCore.QUrl | str, /) -> PySide6.QtCore.QMimeType: ...
    def mimeTypesForFileName(self, fileName: str, /) -> typing.List[PySide6.QtCore.QMimeType]: ...
    def suffixForFileName(self, fileName: str, /) -> str: ...


class QMimeType(Shiboken.Object):

    @typing.overload
    def __init__(self, other: PySide6.QtCore.QMimeType, /, *, valid: bool | None = ..., isDefault: bool | None = ..., name: str | None = ..., comment: str | None = ..., genericIconName: str | None = ..., iconName: str | None = ..., globPatterns: collections.abc.Sequence[str] | None = ..., parentMimeTypes: collections.abc.Sequence[str] | None = ..., allAncestors: collections.abc.Sequence[str] | None = ..., aliases: collections.abc.Sequence[str] | None = ..., suffixes: collections.abc.Sequence[str] | None = ..., preferredSuffix: str | None = ..., filterString: str | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, *, valid: bool | None = ..., isDefault: bool | None = ..., name: str | None = ..., comment: str | None = ..., genericIconName: str | None = ..., iconName: str | None = ..., globPatterns: collections.abc.Sequence[str] | None = ..., parentMimeTypes: collections.abc.Sequence[str] | None = ..., allAncestors: collections.abc.Sequence[str] | None = ..., aliases: collections.abc.Sequence[str] | None = ..., suffixes: collections.abc.Sequence[str] | None = ..., preferredSuffix: str | None = ..., filterString: str | None = ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QMimeType, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __ne__(self, rhs: PySide6.QtCore.QMimeType, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def aliases(self, /) -> typing.List[str]: ...
    def allAncestors(self, /) -> typing.List[str]: ...
    def comment(self, /) -> str: ...
    def filterString(self, /) -> str: ...
    def genericIconName(self, /) -> str: ...
    def globPatterns(self, /) -> typing.List[str]: ...
    def iconName(self, /) -> str: ...
    def inherits(self, mimeTypeName: str, /) -> bool: ...
    def isDefault(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def name(self, /) -> str: ...
    def parentMimeTypes(self, /) -> typing.List[str]: ...
    def preferredSuffix(self, /) -> str: ...
    def suffixes(self, /) -> typing.List[str]: ...
    def swap(self, other: PySide6.QtCore.QMimeType, /) -> None: ...


class QModelIndex(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QModelIndex: PySide6.QtCore.QModelIndex, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __ge__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __gt__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __le__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __lt__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def column(self, /) -> int: ...
    def constInternalPointer(self, /) -> int: ...
    def data(self, /, role: int = ...) -> typing.Any: ...
    def flags(self, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def internalId(self, /) -> int: ...
    def internalPointer(self, /) -> typing.Any: ...
    def isValid(self, /) -> bool: ...
    def model(self, /) -> PySide6.QtCore.QAbstractItemModel: ...
    def multiData(self, roleDataSpan: PySide6.QtCore.QModelRoleDataSpan | PySide6.QtCore.QModelRoleData, /) -> None: ...
    def parent(self, /) -> PySide6.QtCore.QModelIndex: ...
    def row(self, /) -> int: ...
    def sibling(self, row: int, column: int, /) -> PySide6.QtCore.QModelIndex: ...
    def siblingAtColumn(self, column: int, /) -> PySide6.QtCore.QModelIndex: ...
    def siblingAtRow(self, row: int, /) -> PySide6.QtCore.QModelIndex: ...


class QModelRoleData(Shiboken.Object):

    @typing.overload
    def __init__(self, QModelRoleData: PySide6.QtCore.QModelRoleData, /) -> None: ...
    @typing.overload
    def __init__(self, role: int, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def clearData(self, /) -> None: ...
    def data(self, /) -> typing.Any: ...
    def role(self, /) -> int: ...
    def setData(self, data: typing.Any, /) -> None: ...


class QModelRoleDataSpan(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, modelRoleData: PySide6.QtCore.QModelRoleData, /) -> None: ...
    @typing.overload
    def __init__(self, modelRoleData: PySide6.QtCore.QModelRoleData, len: int, /) -> None: ...
    @typing.overload
    def __init__(self, QModelRoleDataSpan: PySide6.QtCore.QModelRoleDataSpan, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def begin(self, /) -> PySide6.QtCore.QModelRoleData: ...
    def data(self, /) -> PySide6.QtCore.QModelRoleData: ...
    def end(self, /) -> PySide6.QtCore.QModelRoleData: ...
    def length(self, /) -> int: ...
    def size(self, /) -> int: ...


class QMutex(PySide6.QtCore.QBasicMutex):

    def __init__(self, /) -> None: ...

    @typing.overload
    def tryLock(self, /) -> bool: ...
    @typing.overload
    def tryLock(self, timeout: int, /) -> bool: ...
    @typing.overload
    def tryLock(self, timeout: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> bool: ...
    def try_lock(self, /) -> bool: ...


class QMutexLocker(Shiboken.Object):

    @typing.overload
    def __init__(self, m: PySide6.QtCore.QMutex, /) -> None: ...
    @typing.overload
    def __init__(self, m: PySide6.QtCore.QRecursiveMutex, /) -> None: ...

    def __enter__(self, /) -> PySide6.QtCore.QMutexLocker: ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object, /) -> None: ...
    def mutex(self, /) -> PySide6.QtCore.QMutex: ...
    def recursiveMutex(self, /) -> PySide6.QtCore.QRecursiveMutex: ...
    def relock(self, /) -> None: ...
    def unlock(self, /) -> None: ...


class QNativeIpcKey(Shiboken.Object):

    DefaultTypeForOs          = 0x100

    class Type(enum.Enum):

        SystemV                   = 0x51
        PosixRealtime             = 0x100
        Windows                   = 0x101


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QNativeIpcKey, /) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QNativeIpcKey.Type, /) -> None: ...
    @typing.overload
    def __init__(self, k: str, /, type: PySide6.QtCore.QNativeIpcKey.Type = ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QNativeIpcKey | str, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __ne__(self, rhs: PySide6.QtCore.QNativeIpcKey | str, /) -> bool: ...
    @staticmethod
    def fromString(string: str, /) -> PySide6.QtCore.QNativeIpcKey: ...
    def isEmpty(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    @staticmethod
    def legacyDefaultTypeForOs() -> PySide6.QtCore.QNativeIpcKey.Type: ...
    def nativeKey(self, /) -> str: ...
    def setNativeKey(self, newKey: str, /) -> None: ...
    def setType(self, type: PySide6.QtCore.QNativeIpcKey.Type, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QNativeIpcKey | str, /) -> None: ...
    def toString(self, /) -> str: ...
    def type(self, /) -> PySide6.QtCore.QNativeIpcKey.Type: ...


class QObject(Shiboken.Object):

    destroyed                : typing.ClassVar[Signal] = ... # destroyed(); destroyed(QObject*)
    objectNameChanged        : typing.ClassVar[Signal] = ... # objectNameChanged(QString)

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, objectName: str | None = ...) -> None: ...

    def __repr__(self, /) -> str: ...
    def blockSignals(self, b: bool, /) -> bool: ...
    def childEvent(self, event: PySide6.QtCore.QChildEvent, /) -> None: ...
    def children(self, /) -> typing.List[PySide6.QtCore.QObject]: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def connect(sender: PySide6.QtCore.QObject, signal: PySide6.QtCore.QMetaMethod, receiver: PySide6.QtCore.QObject, method: PySide6.QtCore.QMetaMethod, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtCore.QMetaObject.Connection: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def connect(sender: PySide6.QtCore.QObject, signal: str, receiver: PySide6.QtCore.QObject, member: str, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtCore.QMetaObject.Connection: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def connect(sender: PySide6.QtCore.QObject, signal: str, context: PySide6.QtCore.QObject, functor: collections.abc.Callable[..., typing.Any], /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtCore.QMetaObject.Connection: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def connect(sender: PySide6.QtCore.QObject, signal: str, functor: collections.abc.Callable[..., typing.Any], /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtCore.QMetaObject.Connection: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def connect(self, sender: PySide6.QtCore.QObject, signal: str, member: str, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtCore.QMetaObject.Connection: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def connect(self, signal: str, receiver: PySide6.QtCore.QObject, method: str, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtCore.QMetaObject.Connection: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def connect(self, signal: str, functor: collections.abc.Callable[..., typing.Any], /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtCore.QMetaObject.Connection: ...  # type: ignore[misc, overload-cannot-match]
    def connectNotify(self, signal: PySide6.QtCore.QMetaMethod, /) -> None: ...
    def customEvent(self, event: PySide6.QtCore.QEvent, /) -> None: ...
    def deleteLater(self, /) -> None: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def disconnect(connection: PySide6.QtCore.QMetaObject.Connection, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def disconnect(sender: PySide6.QtCore.QObject, signal: PySide6.QtCore.QMetaMethod, receiver: PySide6.QtCore.QObject, member: PySide6.QtCore.QMetaMethod, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def disconnect(sender: PySide6.QtCore.QObject, signal: str, receiver: PySide6.QtCore.QObject, member: str, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def disconnect(sender: PySide6.QtCore.QObject, signal: str, functor: collections.abc.Callable[..., typing.Any], /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def disconnect(self, receiver: PySide6.QtCore.QObject, /, member: str | None = ...) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def disconnect(self, signal: str, receiver: PySide6.QtCore.QObject, member: str, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def disconnect(self, signal: str, functor: collections.abc.Callable[..., typing.Any], /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    def disconnectNotify(self, signal: PySide6.QtCore.QMetaMethod, /) -> None: ...
    def dumpObjectInfo(self, /) -> None: ...
    def dumpObjectTree(self, /) -> None: ...
    def dynamicPropertyNames(self, /) -> typing.List[PySide6.QtCore.QByteArray]: ...
    def emit(self, signal: bytes | bytearray | memoryview, /, *args: None) -> bool: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, watched: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def findChild(self, type: typing.Type[PlaceholderType], /, name: str = ..., options: PySide6.QtCore.Qt.FindChildOption = ...) -> PlaceholderType | None : ...
    @typing.overload
    def findChildren(self, type: typing.Type[PlaceholderType], /, name: str = ..., options: PySide6.QtCore.Qt.FindChildOption = ...) -> typing.List[PlaceholderType]: ...
    @typing.overload
    def findChildren(self, type: typing.Type[PlaceholderType], pattern: PySide6.QtCore.QRegularExpression | str, /, options: PySide6.QtCore.Qt.FindChildOption = ...) -> typing.List[PlaceholderType]: ...
    def inherits(self, classname: str, /) -> bool: ...
    def installEventFilter(self, filterObj: PySide6.QtCore.QObject, /) -> None: ...
    def isQuickItemType(self, /) -> bool: ...
    def isSignalConnected(self, signal: PySide6.QtCore.QMetaMethod, /) -> bool: ...
    def isWidgetType(self, /) -> bool: ...
    def isWindowType(self, /) -> bool: ...
    @typing.overload
    def killTimer(self, id: PySide6.QtCore.Qt.TimerId, /) -> None: ...
    @typing.overload
    def killTimer(self, id: int, /) -> None: ...
    def metaObject(self, /) -> PySide6.QtCore.QMetaObject: ...
    def moveToThread(self, thread: PySide6.QtCore.QThread, /) -> bool: ...
    def objectName(self, /) -> str: ...
    def parent(self, /) -> PySide6.QtCore.QObject: ...
    def property(self, name: str, /) -> typing.Any: ...
    def receivers(self, signal: str, /) -> int: ...
    def removeEventFilter(self, obj: PySide6.QtCore.QObject, /) -> None: ...
    def sender(self, /) -> PySide6.QtCore.QObject: ...
    def senderSignalIndex(self, /) -> int: ...
    def setObjectName(self, name: str, /) -> None: ...
    def setParent(self, parent: PySide6.QtCore.QObject | None , /) -> None: ...
    def setProperty(self, name: str, value: typing.Any, /) -> bool: ...
    def signalsBlocked(self, /) -> bool: ...
    def startTimer(self, interval: int, /, timerType: PySide6.QtCore.Qt.TimerType = ...) -> int: ...
    def thread(self, /) -> PySide6.QtCore.QThread: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def tr(self, sourceText: str, /, disambiguation: str | None = ..., n: int = ...) -> str: ...


class QOperatingSystemVersion(PySide6.QtCore.QOperatingSystemVersionBase):

    Android10                 = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    Android11                 = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    Android12                 = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Android12L                = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Android13                 = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    AndroidJellyBean          = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    AndroidJellyBean_MR1      = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    AndroidJellyBean_MR2      = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    AndroidKitKat             = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    AndroidLollipop           = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    AndroidLollipop_MR1       = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    AndroidMarshmallow        = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    AndroidNougat             = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    AndroidNougat_MR1         = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    AndroidOreo               = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    AndroidOreo_MR1           = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    AndroidPie                = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    MacOSBigSur               = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    MacOSCatalina             = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    MacOSHighSierra           = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    MacOSMojave               = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    MacOSMonterey             = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    MacOSSierra               = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    MacOSVentura              = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    OSXElCapitan              = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    OSXMavericks              = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    OSXYosemite               = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    Windows10                 = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    Windows10_1809            = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Windows10_1903            = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Windows10_1909            = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Windows10_2004            = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Windows10_20H2            = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Windows10_21H1            = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Windows10_21H2            = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Windows10_22H2            = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Windows11                 = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Windows11_21H2            = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Windows11_22H2            = ...  # type: PySide6.QtCore.QOperatingSystemVersionBase
    Windows7                  = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    Windows8                  = ...  # type: PySide6.QtCore.QOperatingSystemVersion
    Windows8_1                = ...  # type: PySide6.QtCore.QOperatingSystemVersion

    class OSType(enum.Enum):

        Unknown                   = 0x0
        Windows                   = 0x1
        MacOS                     = 0x2
        IOS                       = 0x3
        TvOS                      = 0x4
        WatchOS                   = 0x5
        Android                   = 0x6
        VisionOS                  = 0x7


    @typing.overload
    def __init__(self, QOperatingSystemVersion: PySide6.QtCore.QOperatingSystemVersion, /) -> None: ...
    @typing.overload
    def __init__(self, osType: PySide6.QtCore.QOperatingSystemVersion.OSType, vmajor: int, /, vminor: int = ..., vmicro: int = ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __repr__(self, /) -> str: ...
    @staticmethod
    def currentType() -> PySide6.QtCore.QOperatingSystemVersion.OSType: ...
    def type(self, /) -> PySide6.QtCore.QOperatingSystemVersion.OSType: ...


class QOperatingSystemVersionBase(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QOperatingSystemVersionBase: PySide6.QtCore.QOperatingSystemVersionBase, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __ge__(self, rhs: PySide6.QtCore.QOperatingSystemVersionBase, /) -> bool: ...
    def __gt__(self, rhs: PySide6.QtCore.QOperatingSystemVersionBase, /) -> bool: ...
    def __le__(self, rhs: PySide6.QtCore.QOperatingSystemVersionBase, /) -> bool: ...
    def __lt__(self, rhs: PySide6.QtCore.QOperatingSystemVersionBase, /) -> bool: ...
    @staticmethod
    def compare(v1: PySide6.QtCore.QOperatingSystemVersionBase, v2: PySide6.QtCore.QOperatingSystemVersionBase, /) -> int: ...
    @staticmethod
    def current() -> PySide6.QtCore.QOperatingSystemVersionBase: ...
    def majorVersion(self, /) -> int: ...
    def microVersion(self, /) -> int: ...
    def minorVersion(self, /) -> int: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def name(osversion: PySide6.QtCore.QOperatingSystemVersionBase, /) -> str: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def name(self, /) -> str: ...  # type: ignore[misc, overload-cannot-match]
    def segmentCount(self, /) -> int: ...
    def version(self, /) -> PySide6.QtCore.QVersionNumber: ...


class QParallelAnimationGroup(PySide6.QtCore.QAnimationGroup):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def duration(self, /) -> int: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def updateCurrentTime(self, currentTime: int, /) -> None: ...
    def updateDirection(self, direction: PySide6.QtCore.QAbstractAnimation.Direction, /) -> None: ...
    def updateState(self, newState: PySide6.QtCore.QAbstractAnimation.State, oldState: PySide6.QtCore.QAbstractAnimation.State, /) -> None: ...


class QPauseAnimation(PySide6.QtCore.QAbstractAnimation):

    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, duration: int | None = ...) -> None: ...
    @typing.overload
    def __init__(self, msecs: int, /, parent: PySide6.QtCore.QObject | None = ..., *, duration: int | None = ...) -> None: ...

    def duration(self, /) -> int: ...
    def event(self, e: PySide6.QtCore.QEvent, /) -> bool: ...
    def setDuration(self, msecs: int, /) -> None: ...
    def updateCurrentTime(self, arg__1: int, /) -> None: ...


class QPermission(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QPermission: PySide6.QtCore.QPermission, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def status(self, /) -> PySide6.QtCore.Qt.PermissionStatus: ...
    def type(self, /) -> PySide6.QtCore.QMetaType: ...


class QPersistentModelIndex(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    @typing.overload
    def __init__(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __ge__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __gt__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __le__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __lt__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def column(self, /) -> int: ...
    def data(self, /, role: int = ...) -> typing.Any: ...
    def flags(self, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def internalId(self, /) -> int: ...
    def internalPointer(self, /) -> typing.Any: ...
    def isValid(self, /) -> bool: ...
    def model(self, /) -> PySide6.QtCore.QAbstractItemModel: ...
    def multiData(self, roleDataSpan: PySide6.QtCore.QModelRoleDataSpan | PySide6.QtCore.QModelRoleData, /) -> None: ...
    def parent(self, /) -> PySide6.QtCore.QModelIndex: ...
    def row(self, /) -> int: ...
    def sibling(self, row: int, column: int, /) -> PySide6.QtCore.QModelIndex: ...
    def swap(self, other: PySide6.QtCore.QPersistentModelIndex | PySide6.QtCore.QModelIndex, /) -> None: ...


class QPluginLoader(PySide6.QtCore.QObject):

    @typing.overload
    def __init__(self, fileName: str, /, parent: PySide6.QtCore.QObject | None = ..., *, loadHints: PySide6.QtCore.QLibrary.LoadHint | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, fileName: str | None = ..., loadHints: PySide6.QtCore.QLibrary.LoadHint | None = ...) -> None: ...

    def errorString(self, /) -> str: ...
    def fileName(self, /) -> str: ...
    def instance(self, /) -> PySide6.QtCore.QObject: ...
    def isLoaded(self, /) -> bool: ...
    def load(self, /) -> bool: ...
    def loadHints(self, /) -> PySide6.QtCore.QLibrary.LoadHint: ...
    def metaData(self, /) -> typing.Dict[str, PySide6.QtCore.QJsonValue]: ...
    def setFileName(self, fileName: str, /) -> None: ...
    def setLoadHints(self, loadHints: PySide6.QtCore.QLibrary.LoadHint, /) -> None: ...
    @staticmethod
    def staticInstances() -> typing.List[PySide6.QtCore.QObject]: ...
    def unload(self, /) -> bool: ...


class QPoint(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QPoint: PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def __init__(self, xpos: int, ypos: int, /) -> None: ...

    def __add__(self, p2: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPoint: ...
    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QPoint, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __iadd__(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPoint: ...  # type: ignore[misc]
    @typing.overload
    def __imul__(self, factor: int, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def __imul__(self, factor: float, /) -> PySide6.QtCore.QPoint: ...
    def __isub__(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPoint: ...  # type: ignore[misc]
    @typing.overload
    def __mul__(self, factor: int, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def __mul__(self, factor: float, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QPoint, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> bool: ...
    def __neg__(self, /) -> PySide6.QtCore.QPoint: ...
    def __pos__(self, /) -> PySide6.QtCore.QPoint: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def __sub__(self, p2: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPoint: ...
    @staticmethod
    def dotProduct(p1: PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPoint, /) -> int: ...
    def isNull(self, /) -> bool: ...
    def manhattanLength(self, /) -> int: ...
    def setX(self, x: int, /) -> None: ...
    def setY(self, y: int, /) -> None: ...
    def toPointF(self, /) -> PySide6.QtCore.QPointF: ...
    def toTuple(self, /) -> typing.Tuple[int, int]: ...
    def transposed(self, /) -> PySide6.QtCore.QPoint: ...
    def x(self, /) -> int: ...
    def y(self, /) -> int: ...


class QPointF(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def __init__(self, QPointF: PySide6.QtCore.QPointF, /) -> None: ...
    @typing.overload
    def __init__(self, xpos: float, ypos: float, /) -> None: ...

    def __add__(self, p2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPointF: ...
    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QPoint, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> bool: ...
    def __iadd__(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPointF: ...  # type: ignore[misc]
    def __imul__(self, c: float, /) -> PySide6.QtCore.QPointF: ...
    def __isub__(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPointF: ...  # type: ignore[misc]
    def __mul__(self, c: float, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QPoint, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> bool: ...
    def __neg__(self, /) -> PySide6.QtCore.QPointF: ...
    def __pos__(self, /) -> PySide6.QtCore.QPointF: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def __sub__(self, p2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QPointF: ...
    @staticmethod
    def dotProduct(p1: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> float: ...
    def isNull(self, /) -> bool: ...
    def manhattanLength(self, /) -> float: ...
    def setX(self, x: float, /) -> None: ...
    def setY(self, y: float, /) -> None: ...
    def toPoint(self, /) -> PySide6.QtCore.QPoint: ...
    def toTuple(self, /) -> typing.Tuple[float, float]: ...
    def transposed(self, /) -> PySide6.QtCore.QPointF: ...
    def x(self, /) -> float: ...
    def y(self, /) -> float: ...


class QPointFList: ...


class QPointList: ...


class QProcess(PySide6.QtCore.QIODevice):

    errorOccurred            : typing.ClassVar[Signal] = ... # errorOccurred(QProcess::ProcessError)
    finished                 : typing.ClassVar[Signal] = ... # finished(int,QProcess::ExitStatus); finished(int)
    readyReadStandardError   : typing.ClassVar[Signal] = ... # readyReadStandardError()
    readyReadStandardOutput  : typing.ClassVar[Signal] = ... # readyReadStandardOutput()
    started                  : typing.ClassVar[Signal] = ... # started()
    stateChanged             : typing.ClassVar[Signal] = ... # stateChanged(QProcess::ProcessState)

    class ExitStatus(enum.Enum):

        NormalExit                = 0x0
        CrashExit                 = 0x1

    class InputChannelMode(enum.Enum):

        ManagedInputChannel       = 0x0
        ForwardedInputChannel     = 0x1

    class ProcessChannel(enum.Enum):

        StandardOutput            = 0x0
        StandardError             = 0x1

    class ProcessChannelMode(enum.Enum):

        SeparateChannels          = 0x0
        MergedChannels            = 0x1
        ForwardedChannels         = 0x2
        ForwardedOutputChannel    = 0x3
        ForwardedErrorChannel     = 0x4

    class ProcessError(enum.Enum):

        FailedToStart             = 0x0
        Crashed                   = 0x1
        Timedout                  = 0x2
        ReadError                 = 0x3
        WriteError                = 0x4
        UnknownError              = 0x5

    class ProcessState(enum.Enum):

        NotRunning                = 0x0
        Starting                  = 0x1
        Running                   = 0x2

    class UnixProcessFlag(enum.Flag):

        ResetSignalHandlers       = 0x1
        IgnoreSigPipe             = 0x2
        CloseFileDescriptors      = 0x10
        UseVFork                  = 0x20
        CreateNewSession          = 0x40
        DisconnectControllingTerminal = 0x80
        ResetIds                  = 0x100
        DisableCoreDumps          = 0x200

    class UnixProcessParameters(Shiboken.Object):

        @typing.overload
        def __init__(self, /) -> None: ...
        @typing.overload
        def __init__(self, UnixProcessParameters: PySide6.QtCore.QProcess.UnixProcessParameters, /) -> None: ...

        def __copy__(self, /) -> typing.Self: ...


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def arguments(self, /) -> typing.List[str]: ...
    def bytesToWrite(self, /) -> int: ...
    def close(self, /) -> None: ...
    def closeReadChannel(self, channel: PySide6.QtCore.QProcess.ProcessChannel, /) -> None: ...
    def closeWriteChannel(self, /) -> None: ...
    def environment(self, /) -> typing.List[str]: ...
    def error(self, /) -> PySide6.QtCore.QProcess.ProcessError: ...
    @staticmethod
    def execute(program: str, /, arguments: collections.abc.Sequence[str] = ...) -> int: ...
    def exitCode(self, /) -> int: ...
    def exitStatus(self, /) -> PySide6.QtCore.QProcess.ExitStatus: ...
    def failChildProcessModifier(self, description: bytes | bytearray | memoryview, /, error: int | None = ...) -> None: ...
    def inputChannelMode(self, /) -> PySide6.QtCore.QProcess.InputChannelMode: ...
    def isSequential(self, /) -> bool: ...
    def kill(self, /) -> None: ...
    @staticmethod
    def nullDevice() -> str: ...
    def open(self, /, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> bool: ...
    def processChannelMode(self, /) -> PySide6.QtCore.QProcess.ProcessChannelMode: ...
    def processEnvironment(self, /) -> PySide6.QtCore.QProcessEnvironment: ...
    def processId(self, /) -> int: ...
    def program(self, /) -> str: ...
    def readAllStandardError(self, /) -> PySide6.QtCore.QByteArray: ...
    def readAllStandardOutput(self, /) -> PySide6.QtCore.QByteArray: ...
    def readChannel(self, /) -> PySide6.QtCore.QProcess.ProcessChannel: ...
    def readData(self, maxlen: int, /) -> object: ...
    def setArguments(self, arguments: collections.abc.Sequence[str], /) -> None: ...
    def setEnvironment(self, environment: collections.abc.Sequence[str], /) -> None: ...
    def setInputChannelMode(self, mode: PySide6.QtCore.QProcess.InputChannelMode, /) -> None: ...
    def setProcessChannelMode(self, mode: PySide6.QtCore.QProcess.ProcessChannelMode, /) -> None: ...
    def setProcessEnvironment(self, environment: PySide6.QtCore.QProcessEnvironment | PySide6.QtCore.QProcessEnvironment.Initialization, /) -> None: ...
    def setProcessState(self, state: PySide6.QtCore.QProcess.ProcessState, /) -> None: ...
    def setProgram(self, program: str, /) -> None: ...
    def setReadChannel(self, channel: PySide6.QtCore.QProcess.ProcessChannel, /) -> None: ...
    def setStandardErrorFile(self, fileName: str, /, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> None: ...
    def setStandardInputFile(self, fileName: str, /) -> None: ...
    def setStandardOutputFile(self, fileName: str, /, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> None: ...
    def setStandardOutputProcess(self, destination: PySide6.QtCore.QProcess, /) -> None: ...
    @typing.overload
    def setUnixProcessParameters(self, flagsOnly: PySide6.QtCore.QProcess.UnixProcessFlag, /) -> None: ...
    @typing.overload
    def setUnixProcessParameters(self, params: PySide6.QtCore.QProcess.UnixProcessParameters, /) -> None: ...
    def setWorkingDirectory(self, dir: str, /) -> None: ...
    @staticmethod
    def splitCommand(command: str, /) -> typing.List[str]: ...
    @typing.overload
    def start(self, /, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> None: ...
    @typing.overload
    def start(self, program: str, /, arguments: collections.abc.Sequence[str] = ..., mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> None: ...
    def startCommand(self, command: str, /, mode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> None: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def startDetached(self, /) -> typing.Tuple[bool, int]: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def startDetached(program: str, /, arguments: collections.abc.Sequence[str] = ..., workingDirectory: str = ...) -> typing.Tuple[bool, int]: ...  # type: ignore[misc, overload-cannot-match]
    def state(self, /) -> PySide6.QtCore.QProcess.ProcessState: ...
    @staticmethod
    def systemEnvironment() -> typing.List[str]: ...
    def terminate(self, /) -> None: ...
    def unixProcessParameters(self, /) -> PySide6.QtCore.QProcess.UnixProcessParameters: ...
    def waitForBytesWritten(self, /, msecs: int = ...) -> bool: ...
    def waitForFinished(self, /, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, /, msecs: int = ...) -> bool: ...
    def waitForStarted(self, /, msecs: int = ...) -> bool: ...
    def workingDirectory(self, /) -> str: ...
    def writeData(self, data: bytes | bytearray | memoryview, len: int, /) -> int: ...


class QProcessEnvironment(Shiboken.Object):

    class Initialization(enum.Enum):

        InheritFromParent         = 0x0


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QProcessEnvironment.Initialization, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QProcessEnvironment, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QProcessEnvironment | PySide6.QtCore.QProcessEnvironment.Initialization, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QProcessEnvironment | PySide6.QtCore.QProcessEnvironment.Initialization, /) -> bool: ...
    def clear(self, /) -> None: ...
    def contains(self, name: str, /) -> bool: ...
    def inheritsFromParent(self, /) -> bool: ...
    @typing.overload
    def insert(self, name: str, value: str, /) -> None: ...
    @typing.overload
    def insert(self, e: PySide6.QtCore.QProcessEnvironment | PySide6.QtCore.QProcessEnvironment.Initialization, /) -> None: ...
    def isEmpty(self, /) -> bool: ...
    def keys(self, /) -> typing.List[str]: ...
    def remove(self, name: str, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QProcessEnvironment | PySide6.QtCore.QProcessEnvironment.Initialization, /) -> None: ...
    @staticmethod
    def systemEnvironment() -> PySide6.QtCore.QProcessEnvironment: ...
    def toStringList(self, /) -> typing.List[str]: ...
    def value(self, name: str, /, defaultValue: str = ...) -> str: ...


class QPropertyAnimation(PySide6.QtCore.QVariantAnimation):

    @typing.overload
    def __init__(self, target: PySide6.QtCore.QObject, propertyName: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, parent: PySide6.QtCore.QObject | None = ..., *, targetObject: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, propertyName: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview | None= ..., targetObject: PySide6.QtCore.QObject | None = ...) -> None: ...

    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def propertyName(self, /) -> PySide6.QtCore.QByteArray: ...
    def setPropertyName(self, propertyName: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    def setTargetObject(self, target: PySide6.QtCore.QObject, /) -> None: ...
    def targetObject(self, /) -> PySide6.QtCore.QObject: ...
    def updateCurrentValue(self, value: typing.Any, /) -> None: ...
    def updateState(self, newState: PySide6.QtCore.QAbstractAnimation.State, oldState: PySide6.QtCore.QAbstractAnimation.State, /) -> None: ...


class QRandomGenerator(Shiboken.Object):

    @typing.overload
    def __init__(self, other: PySide6.QtCore.QRandomGenerator, /) -> None: ...
    @typing.overload
    def __init__(self, /, seedValue: int = ...) -> None: ...
    @typing.overload
    def __init__(self, seedBuffer: int, len: int, /) -> None: ...

    def __ne__(self, rng2: PySide6.QtCore.QRandomGenerator, /) -> bool: ...
    @typing.overload
    def bounded(self, highest: int, /) -> int: ...
    @typing.overload
    def bounded(self, lowest: int, highest: int, /) -> int: ...
    @typing.overload
    def bounded(self, highest: float, /) -> float: ...
    def discard(self, z: int, /) -> None: ...
    def generate(self, /) -> int: ...
    def generate64(self, /) -> int: ...
    def generateDouble(self, /) -> float: ...
    @staticmethod
    def global_() -> PySide6.QtCore.QRandomGenerator: ...
    @staticmethod
    def max() -> int: ...
    @staticmethod
    def min() -> int: ...
    @staticmethod
    def securelySeeded() -> PySide6.QtCore.QRandomGenerator: ...
    def seed(self, /, s: int = ...) -> None: ...
    @staticmethod
    def system() -> PySide6.QtCore.QRandomGenerator: ...


class QRandomGenerator64(PySide6.QtCore.QRandomGenerator):

    @typing.overload
    def __init__(self, other: PySide6.QtCore.QRandomGenerator, /) -> None: ...
    @typing.overload
    def __init__(self, /, seedValue: int = ...) -> None: ...
    @typing.overload
    def __init__(self, seedBuffer: int, len: int, /) -> None: ...

    def discard(self, z: int, /) -> None: ...
    def generate(self, /) -> int: ...
    @staticmethod
    def global_() -> PySide6.QtCore.QRandomGenerator64: ...
    @staticmethod
    def max() -> int: ...
    @staticmethod
    def min() -> int: ...
    @staticmethod
    def securelySeeded() -> PySide6.QtCore.QRandomGenerator64: ...
    @staticmethod
    def system() -> PySide6.QtCore.QRandomGenerator64: ...


class QRangeModel(PySide6.QtCore.QAbstractItemModel):

    roleNamesChanged         : typing.ClassVar[Signal] = ... # roleNamesChanged()

    class RowCategory(enum.Enum):

        Default                   = 0x0
        MultiRoleItem             = 0x1


    @typing.overload
    def __init__(self, data: collections.abc.Sequence[typing.Any], /, parent: PySide6.QtCore.QObject | None = ..., *, roleNames: typing.Dict[int, PySide6.QtCore.QByteArray] | None = ...) -> None: ...
    @typing.overload
    def __init__(self, list: collections.abc.Iterable, /, parent: PySide6.QtCore.QObject | None = ..., *, roleNames: typing.Dict[int, PySide6.QtCore.QByteArray] | None = ...) -> None: ...

    def buddy(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def canDropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def canFetchMore(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def clearItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def columnCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def data(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent, /) -> bool: ...
    def fetchMore(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def flags(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def hasChildren(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, /, role: int = ...) -> typing.Any: ...
    def index(self, row: int, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> PySide6.QtCore.QModelIndex: ...
    def insertColumns(self, column: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def insertRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def itemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> typing.Dict[int, typing.Any]: ...
    def match(self, start: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, role: int, value: typing.Any, hits: int, flags: PySide6.QtCore.Qt.MatchFlag, /) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def mimeData(self, indexes: collections.abc.Sequence[PySide6.QtCore.QModelIndex], /) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self, /) -> typing.List[str]: ...
    def moveColumns(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceColumn: int, count: int, destParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destColumn: int, /) -> bool: ...
    def moveRows(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceRow: int, count: int, destParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destRow: int, /) -> bool: ...
    def multiData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, roleDataSpan: PySide6.QtCore.QModelRoleDataSpan | PySide6.QtCore.QModelRoleData, /) -> None: ...
    @typing.overload
    def parent(self, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def removeColumns(self, column: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def removeRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def resetInternalData(self, /) -> None: ...
    def resetRoleNames(self, /) -> None: ...
    def roleNames(self, /) -> typing.Dict[int, PySide6.QtCore.QByteArray]: ...
    def rowCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def setData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, data: typing.Any, /, role: int = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, data: typing.Any, /, role: int = ...) -> bool: ...
    def setItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, data: typing.Dict[int, typing.Any], /) -> bool: ...
    def setRoleNames(self, names: typing.Dict[int, PySide6.QtCore.QByteArray], /) -> None: ...
    def sibling(self, row: int, column: int, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def sort(self, column: int, /, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def span(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QSize: ...
    def supportedDragActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...
    def supportedDropActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...


class QReadLocker(Shiboken.Object):

    def __init__(self, readWriteLock: PySide6.QtCore.QReadWriteLock, /) -> None: ...

    def __enter__(self, /) -> PySide6.QtCore.QReadLocker: ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object, /) -> None: ...
    def readWriteLock(self, /) -> PySide6.QtCore.QReadWriteLock: ...
    def relock(self, /) -> None: ...
    def unlock(self, /) -> None: ...


class QReadWriteLock(Shiboken.Object):

    class RecursionMode(enum.Enum):

        NonRecursive              = 0x0
        Recursive                 = 0x1


    def __init__(self, /, recursionMode: PySide6.QtCore.QReadWriteLock.RecursionMode = ...) -> None: ...

    def lockForRead(self, /) -> None: ...
    def lockForWrite(self, /) -> None: ...
    @typing.overload
    def tryLockForRead(self, timeout: int, /) -> bool: ...
    @typing.overload
    def tryLockForRead(self, /, timeout: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int= ...) -> bool: ...
    @typing.overload
    def tryLockForWrite(self, timeout: int, /) -> bool: ...
    @typing.overload
    def tryLockForWrite(self, /, timeout: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int= ...) -> bool: ...
    def unlock(self, /) -> None: ...


class QRect(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, topleft: PySide6.QtCore.QPoint, bottomright: PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def __init__(self, topleft: PySide6.QtCore.QPoint, size: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def __init__(self, QRect: PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def __init__(self, left: int, top: int, width: int, height: int, /) -> None: ...

    def __add__(self, margins: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRect: ...
    def __and__(self, r: PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRect: ...
    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QRect, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __iadd__(self, margins: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRect: ...
    def __iand__(self, r: PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRect: ...
    def __ior__(self, r: PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRect: ...
    def __isub__(self, margins: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRect: ...  # type: ignore[misc]
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QRect, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> bool: ...
    def __or__(self, r: PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRect: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def __sub__(self, rhs: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRect: ...
    def adjust(self, x1: int, y1: int, x2: int, y2: int, /) -> None: ...
    def adjusted(self, x1: int, y1: int, x2: int, y2: int, /) -> PySide6.QtCore.QRect: ...
    def bottom(self, /) -> int: ...
    def bottomLeft(self, /) -> PySide6.QtCore.QPoint: ...
    def bottomRight(self, /) -> PySide6.QtCore.QPoint: ...
    def center(self, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def contains(self, p: PySide6.QtCore.QPoint, /, proper: bool = ...) -> bool: ...
    @typing.overload
    def contains(self, r: PySide6.QtCore.QRect, /, proper: bool = ...) -> bool: ...
    @typing.overload
    def contains(self, x: int, y: int, /) -> bool: ...
    @typing.overload
    def contains(self, x: int, y: int, proper: bool, /) -> bool: ...
    def getCoords(self, /) -> object: ...
    def getRect(self, /) -> object: ...
    def height(self, /) -> int: ...
    def intersected(self, other: PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRect: ...
    def intersects(self, r: PySide6.QtCore.QRect, /) -> bool: ...
    def isEmpty(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def left(self, /) -> int: ...
    def marginsAdded(self, margins: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRect: ...
    def marginsRemoved(self, margins: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRect: ...
    def moveBottom(self, pos: int, /) -> None: ...
    def moveBottomLeft(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    def moveBottomRight(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    def moveCenter(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    def moveLeft(self, pos: int, /) -> None: ...
    def moveRight(self, pos: int, /) -> None: ...
    @typing.overload
    def moveTo(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def moveTo(self, x: int, t: int, /) -> None: ...
    def moveTop(self, pos: int, /) -> None: ...
    def moveTopLeft(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    def moveTopRight(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    def normalized(self, /) -> PySide6.QtCore.QRect: ...
    def right(self, /) -> int: ...
    def setBottom(self, pos: int, /) -> None: ...
    def setBottomLeft(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    def setBottomRight(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    def setCoords(self, x1: int, y1: int, x2: int, y2: int, /) -> None: ...
    def setHeight(self, h: int, /) -> None: ...
    def setLeft(self, pos: int, /) -> None: ...
    def setRect(self, x: int, y: int, w: int, h: int, /) -> None: ...
    def setRight(self, pos: int, /) -> None: ...
    def setSize(self, s: PySide6.QtCore.QSize, /) -> None: ...
    def setTop(self, pos: int, /) -> None: ...
    def setTopLeft(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    def setTopRight(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    def setWidth(self, w: int, /) -> None: ...
    def setX(self, x: int, /) -> None: ...
    def setY(self, y: int, /) -> None: ...
    def size(self, /) -> PySide6.QtCore.QSize: ...
    @staticmethod
    def span(p1: PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QRect: ...
    def toRectF(self, /) -> PySide6.QtCore.QRectF: ...
    def top(self, /) -> int: ...
    def topLeft(self, /) -> PySide6.QtCore.QPoint: ...
    def topRight(self, /) -> PySide6.QtCore.QPoint: ...
    @typing.overload
    def translate(self, p: PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def translate(self, dx: int, dy: int, /) -> None: ...
    @typing.overload
    def translated(self, p: PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QRect: ...
    @typing.overload
    def translated(self, dx: int, dy: int, /) -> PySide6.QtCore.QRect: ...
    def transposed(self, /) -> PySide6.QtCore.QRect: ...
    def united(self, other: PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRect: ...
    def width(self, /) -> int: ...
    def x(self, /) -> int: ...
    def y(self, /) -> int: ...


class QRectF(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, rect: PySide6.QtCore.QRect, /) -> None: ...
    @typing.overload
    def __init__(self, QRectF: PySide6.QtCore.QRectF, /) -> None: ...
    @typing.overload
    def __init__(self, topleft: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, bottomRight: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def __init__(self, topleft: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, size: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def __init__(self, left: float, top: float, width: float, height: float, /) -> None: ...

    def __add__(self, lhs: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRectF: ...
    def __and__(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QRect, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> bool: ...
    def __iadd__(self, margins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRectF: ...  # type: ignore[misc]
    def __iand__(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    def __ior__(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    def __isub__(self, margins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRectF: ...  # type: ignore[misc]
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QRect, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> bool: ...
    def __or__(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def __sub__(self, rhs: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRectF: ...
    def adjust(self, x1: float, y1: float, x2: float, y2: float, /) -> None: ...
    def adjusted(self, x1: float, y1: float, x2: float, y2: float, /) -> PySide6.QtCore.QRectF: ...
    def bottom(self, /) -> float: ...
    def bottomLeft(self, /) -> PySide6.QtCore.QPointF: ...
    def bottomRight(self, /) -> PySide6.QtCore.QPointF: ...
    def center(self, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def contains(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> bool: ...
    @typing.overload
    def contains(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> bool: ...
    @typing.overload
    def contains(self, x: float, y: float, /) -> bool: ...
    def getCoords(self, /) -> object: ...
    def getRect(self, /) -> object: ...
    def height(self, /) -> float: ...
    def intersected(self, other: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    def intersects(self, r: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> bool: ...
    def isEmpty(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def left(self, /) -> float: ...
    def marginsAdded(self, margins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRectF: ...
    def marginsRemoved(self, margins: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QRectF: ...
    def moveBottom(self, pos: float, /) -> None: ...
    def moveBottomLeft(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def moveBottomRight(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def moveCenter(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def moveLeft(self, pos: float, /) -> None: ...
    def moveRight(self, pos: float, /) -> None: ...
    @typing.overload
    def moveTo(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def moveTo(self, x: float, y: float, /) -> None: ...
    def moveTop(self, pos: float, /) -> None: ...
    def moveTopLeft(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def moveTopRight(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def normalized(self, /) -> PySide6.QtCore.QRectF: ...
    def right(self, /) -> float: ...
    def setBottom(self, pos: float, /) -> None: ...
    def setBottomLeft(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def setBottomRight(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def setCoords(self, x1: float, y1: float, x2: float, y2: float, /) -> None: ...
    def setHeight(self, h: float, /) -> None: ...
    def setLeft(self, pos: float, /) -> None: ...
    def setRect(self, x: float, y: float, w: float, h: float, /) -> None: ...
    def setRight(self, pos: float, /) -> None: ...
    def setSize(self, s: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> None: ...
    def setTop(self, pos: float, /) -> None: ...
    def setTopLeft(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def setTopRight(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    def setWidth(self, w: float, /) -> None: ...
    def setX(self, pos: float, /) -> None: ...
    def setY(self, pos: float, /) -> None: ...
    def size(self, /) -> PySide6.QtCore.QSizeF: ...
    def toAlignedRect(self, /) -> PySide6.QtCore.QRect: ...
    def toRect(self, /) -> PySide6.QtCore.QRect: ...
    def top(self, /) -> float: ...
    def topLeft(self, /) -> PySide6.QtCore.QPointF: ...
    def topRight(self, /) -> PySide6.QtCore.QPointF: ...
    @typing.overload
    def translate(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> None: ...
    @typing.overload
    def translate(self, dx: float, dy: float, /) -> None: ...
    @typing.overload
    def translated(self, p: PySide6.QtCore.QPointF | PySide6.QtCore.QPoint, /) -> PySide6.QtCore.QRectF: ...
    @typing.overload
    def translated(self, dx: float, dy: float, /) -> PySide6.QtCore.QRectF: ...
    def transposed(self, /) -> PySide6.QtCore.QRectF: ...
    def united(self, other: PySide6.QtCore.QRectF | PySide6.QtCore.QRect, /) -> PySide6.QtCore.QRectF: ...
    def width(self, /) -> float: ...
    def x(self, /) -> float: ...
    def y(self, /) -> float: ...


class QRecursiveMutex(Shiboken.Object):

    def __init__(self, /) -> None: ...

    def lock(self, /) -> None: ...
    @typing.overload
    def tryLock(self, timeout: int, /) -> bool: ...
    @typing.overload
    def tryLock(self, /, timer: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int= ...) -> bool: ...
    def try_lock(self, /) -> bool: ...
    def unlock(self, /) -> None: ...


class QRegularExpression(Shiboken.Object):

    class MatchOption(enum.Flag):

        NoMatchOption             = 0x0
        AnchorAtOffsetMatchOption = 0x1
        AnchoredMatchOption       = 0x1
        DontCheckSubjectStringMatchOption = 0x2

    class MatchType(enum.Enum):

        NormalMatch               = 0x0
        PartialPreferCompleteMatch = 0x1
        PartialPreferFirstMatch   = 0x2
        NoMatch                   = 0x3

    class PatternOption(enum.Flag):

        NoPatternOption           = 0x0
        CaseInsensitiveOption     = 0x1
        DotMatchesEverythingOption = 0x2
        MultilineOption           = 0x4
        ExtendedPatternSyntaxOption = 0x8
        InvertedGreedinessOption  = 0x10
        DontCaptureOption         = 0x20
        UseUnicodePropertiesOption = 0x40

    class WildcardConversionOption(enum.Flag):

        DefaultWildcardConversion = 0x0
        UnanchoredWildcardConversion = 0x1
        NonPathWildcardConversion = 0x2


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, re: PySide6.QtCore.QRegularExpression, /) -> None: ...
    @typing.overload
    def __init__(self, pattern: str, /, options: PySide6.QtCore.QRegularExpression.PatternOption = ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QRegularExpression | str, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __ne__(self, rhs: PySide6.QtCore.QRegularExpression | str, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    @staticmethod
    def anchoredPattern(expression: str, /) -> str: ...
    def captureCount(self, /) -> int: ...
    def errorString(self, /) -> str: ...
    @staticmethod
    def escape(str: str, /) -> str: ...
    @staticmethod
    def fromWildcard(pattern: str, /, cs: PySide6.QtCore.Qt.CaseSensitivity = ..., options: PySide6.QtCore.QRegularExpression.WildcardConversionOption = ...) -> PySide6.QtCore.QRegularExpression: ...
    def globalMatch(self, subject: str, /, offset: int | None = ..., matchType: PySide6.QtCore.QRegularExpression.MatchType = ..., matchOptions: PySide6.QtCore.QRegularExpression.MatchOption = ...) -> PySide6.QtCore.QRegularExpressionMatchIterator: ...
    def globalMatchView(self, subjectView: str, /, offset: int | None = ..., matchType: PySide6.QtCore.QRegularExpression.MatchType = ..., matchOptions: PySide6.QtCore.QRegularExpression.MatchOption = ...) -> PySide6.QtCore.QRegularExpressionMatchIterator: ...
    def isValid(self, /) -> bool: ...
    def match(self, subject: str, /, offset: int | None = ..., matchType: PySide6.QtCore.QRegularExpression.MatchType = ..., matchOptions: PySide6.QtCore.QRegularExpression.MatchOption = ...) -> PySide6.QtCore.QRegularExpressionMatch: ...
    def matchView(self, subjectView: str, /, offset: int | None = ..., matchType: PySide6.QtCore.QRegularExpression.MatchType = ..., matchOptions: PySide6.QtCore.QRegularExpression.MatchOption = ...) -> PySide6.QtCore.QRegularExpressionMatch: ...
    def namedCaptureGroups(self, /) -> typing.List[str]: ...
    def optimize(self, /) -> None: ...
    def pattern(self, /) -> str: ...
    def patternErrorOffset(self, /) -> int: ...
    def patternOptions(self, /) -> PySide6.QtCore.QRegularExpression.PatternOption: ...
    def setPattern(self, pattern: str, /) -> None: ...
    def setPatternOptions(self, options: PySide6.QtCore.QRegularExpression.PatternOption, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QRegularExpression | str, /) -> None: ...
    @staticmethod
    def wildcardToRegularExpression(str: str, /, options: PySide6.QtCore.QRegularExpression.WildcardConversionOption = ...) -> str: ...


class QRegularExpressionMatch(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, match: PySide6.QtCore.QRegularExpressionMatch, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __repr__(self, /) -> str: ...
    @typing.overload
    def captured(self, name: str, /) -> str: ...
    @typing.overload
    def captured(self, /, nth: int | None = ...) -> str: ...
    @typing.overload
    def capturedEnd(self, name: str, /) -> int: ...
    @typing.overload
    def capturedEnd(self, /, nth: int | None = ...) -> int: ...
    @typing.overload
    def capturedLength(self, name: str, /) -> int: ...
    @typing.overload
    def capturedLength(self, /, nth: int | None = ...) -> int: ...
    @typing.overload
    def capturedStart(self, name: str, /) -> int: ...
    @typing.overload
    def capturedStart(self, /, nth: int | None = ...) -> int: ...
    def capturedTexts(self, /) -> typing.List[str]: ...
    @typing.overload
    def capturedView(self, name: str, /) -> str: ...
    @typing.overload
    def capturedView(self, /, nth: int | None = ...) -> str: ...
    @typing.overload
    def hasCaptured(self, name: str, /) -> bool: ...
    @typing.overload
    def hasCaptured(self, nth: int, /) -> bool: ...
    def hasMatch(self, /) -> bool: ...
    def hasPartialMatch(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def lastCapturedIndex(self, /) -> int: ...
    def matchOptions(self, /) -> PySide6.QtCore.QRegularExpression.MatchOption: ...
    def matchType(self, /) -> PySide6.QtCore.QRegularExpression.MatchType: ...
    def regularExpression(self, /) -> PySide6.QtCore.QRegularExpression: ...
    def swap(self, other: PySide6.QtCore.QRegularExpressionMatch, /) -> None: ...


class QRegularExpressionMatchIterator(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, iterator: PySide6.QtCore.QRegularExpressionMatchIterator, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def hasNext(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def matchOptions(self, /) -> PySide6.QtCore.QRegularExpression.MatchOption: ...
    def matchType(self, /) -> PySide6.QtCore.QRegularExpression.MatchType: ...
    def next(self, /) -> PySide6.QtCore.QRegularExpressionMatch: ...
    def peekNext(self, /) -> PySide6.QtCore.QRegularExpressionMatch: ...
    def regularExpression(self, /) -> PySide6.QtCore.QRegularExpression: ...
    def swap(self, other: PySide6.QtCore.QRegularExpressionMatchIterator, /) -> None: ...


class QResource(Shiboken.Object):

    class Compression(enum.Enum):

        NoCompression             = 0x0
        ZlibCompression           = 0x1
        ZstdCompression           = 0x2


    def __init__(self, /, file: str = ..., locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language= ...) -> None: ...

    def absoluteFilePath(self, /) -> str: ...
    def children(self, /) -> typing.List[str]: ...
    def compressionAlgorithm(self, /) -> PySide6.QtCore.QResource.Compression: ...
    def data(self, /) -> object: ...
    def fileName(self, /) -> str: ...
    def isDir(self, /) -> bool: ...
    def isFile(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def lastModified(self, /) -> PySide6.QtCore.QDateTime: ...
    def locale(self, /) -> PySide6.QtCore.QLocale: ...
    @staticmethod
    def registerResource(rccFilename: str, /, resourceRoot: str = ...) -> bool: ...
    @staticmethod
    def registerResourceData(rccData: bytes | bytearray | memoryview, /, resourceRoot: str = ...) -> bool: ...
    def setFileName(self, file: str, /) -> None: ...
    def setLocale(self, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> None: ...
    def size(self, /) -> int: ...
    def uncompressedData(self, /) -> PySide6.QtCore.QByteArray: ...
    def uncompressedSize(self, /) -> int: ...
    @staticmethod
    def unregisterResource(rccFilename: str, /, resourceRoot: str = ...) -> bool: ...
    @staticmethod
    def unregisterResourceData(rccData: bytes | bytearray | memoryview, /, resourceRoot: str = ...) -> bool: ...


class QRunnable(Shiboken.Object):

    def __init__(self, /) -> None: ...

    def autoDelete(self, /) -> bool: ...
    @staticmethod
    def create(functionToRun: object, /) -> PySide6.QtCore.QRunnable: ...
    def run(self, /) -> None: ...
    def setAutoDelete(self, autoDelete: bool, /) -> None: ...


class QSaveFile(PySide6.QtCore.QFileDevice):

    @typing.overload
    def __init__(self, name: str, /) -> None: ...
    @typing.overload
    def __init__(self, name: str, parent: PySide6.QtCore.QObject, /) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def cancelWriting(self, /) -> None: ...
    def close(self, /) -> None: ...
    def commit(self, /) -> bool: ...
    def directWriteFallback(self, /) -> bool: ...
    def fileName(self, /) -> str: ...
    def open(self, flags: PySide6.QtCore.QIODeviceBase.OpenModeFlag, /) -> bool: ...
    def setDirectWriteFallback(self, enabled: bool, /) -> None: ...
    def setFileName(self, name: str, /) -> None: ...
    def writeData(self, data: bytes | bytearray | memoryview, len: int, /) -> int: ...


class QSemaphore(Shiboken.Object):

    def __init__(self, /, n: int | None = ...) -> None: ...

    def acquire(self, /, n: int = ...) -> None: ...
    def available(self, /) -> int: ...
    def release(self, /, n: int = ...) -> None: ...
    @typing.overload
    def tryAcquire(self, /, n: int = ...) -> bool: ...
    @typing.overload
    def tryAcquire(self, n: int, timeout: int, /) -> bool: ...
    @typing.overload
    def tryAcquire(self, n: int, timeout: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int, /) -> bool: ...


class QSemaphoreReleaser(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, sem: PySide6.QtCore.QSemaphore, /, n: int = ...) -> None: ...

    def cancel(self, /) -> PySide6.QtCore.QSemaphore: ...
    def semaphore(self, /) -> PySide6.QtCore.QSemaphore: ...
    def swap(self, other: PySide6.QtCore.QSemaphoreReleaser, /) -> None: ...


class QSequentialAnimationGroup(PySide6.QtCore.QAnimationGroup):

    currentAnimationChanged  : typing.ClassVar[Signal] = ... # currentAnimationChanged(QAbstractAnimation*)

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, currentAnimation: PySide6.QtCore.QAbstractAnimation | None = ...) -> None: ...

    def addPause(self, msecs: int, /) -> PySide6.QtCore.QPauseAnimation: ...
    def currentAnimation(self, /) -> PySide6.QtCore.QAbstractAnimation: ...
    def duration(self, /) -> int: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def insertPause(self, index: int, msecs: int, /) -> PySide6.QtCore.QPauseAnimation: ...
    def updateCurrentTime(self, arg__1: int, /) -> None: ...
    def updateDirection(self, direction: PySide6.QtCore.QAbstractAnimation.Direction, /) -> None: ...
    def updateState(self, newState: PySide6.QtCore.QAbstractAnimation.State, oldState: PySide6.QtCore.QAbstractAnimation.State, /) -> None: ...


class QSettings(PySide6.QtCore.QObject):

    class Format(enum.Enum):

        NativeFormat              = 0x0
        IniFormat                 = 0x1
        InvalidFormat             = 0x10
        CustomFormat1             = 0x11
        CustomFormat2             = 0x12
        CustomFormat3             = 0x13
        CustomFormat4             = 0x14
        CustomFormat5             = 0x15
        CustomFormat6             = 0x16
        CustomFormat7             = 0x17
        CustomFormat8             = 0x18
        CustomFormat9             = 0x19
        CustomFormat10            = 0x1a
        CustomFormat11            = 0x1b
        CustomFormat12            = 0x1c
        CustomFormat13            = 0x1d
        CustomFormat14            = 0x1e
        CustomFormat15            = 0x1f
        CustomFormat16            = 0x20

    class Scope(enum.Enum):

        UserScope                 = 0x0
        SystemScope               = 0x1

    class Status(enum.Enum):

        NoError                   = 0x0
        AccessError               = 0x1
        FormatError               = 0x2


    @typing.overload
    def __init__(self, format: PySide6.QtCore.QSettings.Format, scope: PySide6.QtCore.QSettings.Scope, organization: str, /, application: str = ..., parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, scope: PySide6.QtCore.QSettings.Scope, organization: str, /, application: str = ..., parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, scope: PySide6.QtCore.QSettings.Scope, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, fileName: str, format: PySide6.QtCore.QSettings.Format, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, organization: str, /, application: str = ..., parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def allKeys(self, /) -> typing.List[str]: ...
    def applicationName(self, /) -> str: ...
    def beginGroup(self, prefix: str, /) -> None: ...
    def beginReadArray(self, prefix: str, /) -> int: ...
    def beginWriteArray(self, prefix: str, /, size: int = ...) -> None: ...
    def childGroups(self, /) -> typing.List[str]: ...
    def childKeys(self, /) -> typing.List[str]: ...
    def clear(self, /) -> None: ...
    def contains(self, key: str, /) -> bool: ...
    @staticmethod
    def defaultFormat() -> PySide6.QtCore.QSettings.Format: ...
    def endArray(self, /) -> None: ...
    def endGroup(self, /) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def fallbacksEnabled(self, /) -> bool: ...
    def fileName(self, /) -> str: ...
    def format(self, /) -> PySide6.QtCore.QSettings.Format: ...
    def group(self, /) -> str: ...
    def isAtomicSyncRequired(self, /) -> bool: ...
    def isWritable(self, /) -> bool: ...
    def organizationName(self, /) -> str: ...
    def remove(self, key: str, /) -> None: ...
    def scope(self, /) -> PySide6.QtCore.QSettings.Scope: ...
    def setArrayIndex(self, i: int, /) -> None: ...
    def setAtomicSyncRequired(self, enable: bool, /) -> None: ...
    @staticmethod
    def setDefaultFormat(format: PySide6.QtCore.QSettings.Format, /) -> None: ...
    def setFallbacksEnabled(self, b: bool, /) -> None: ...
    @staticmethod
    def setPath(format: PySide6.QtCore.QSettings.Format, scope: PySide6.QtCore.QSettings.Scope, path: str, /) -> None: ...
    def setValue(self, key: str, value: typing.Any, /) -> None: ...
    def status(self, /) -> PySide6.QtCore.QSettings.Status: ...
    def sync(self, /) -> None: ...
    @typing.overload
    def value(self, key: str, /) -> typing.Any: ...
    @typing.overload
    def value(self, arg__1: str, /, defaultValue: typing.Any = ..., type: object | None = ...) -> object: ...


class QSharedMemory(PySide6.QtCore.QObject):

    class AccessMode(enum.Enum):

        ReadOnly                  = 0x0
        ReadWrite                 = 0x1

    class SharedMemoryError(enum.Enum):

        NoError                   = 0x0
        PermissionDenied          = 0x1
        InvalidSize               = 0x2
        KeyError                  = 0x3
        AlreadyExists             = 0x4
        NotFound                  = 0x5
        LockError                 = 0x6
        OutOfResources            = 0x7
        UnknownError              = 0x8


    @typing.overload
    def __init__(self, key: str, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, key: PySide6.QtCore.QNativeIpcKey | str, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def attach(self, /, mode: PySide6.QtCore.QSharedMemory.AccessMode = ...) -> bool: ...
    def constData(self, /) -> int: ...
    def create(self, size: int, /, mode: PySide6.QtCore.QSharedMemory.AccessMode = ...) -> bool: ...
    def data(self, /) -> int: ...
    def detach(self, /) -> bool: ...
    def error(self, /) -> PySide6.QtCore.QSharedMemory.SharedMemoryError: ...
    def errorString(self, /) -> str: ...
    def isAttached(self, /) -> bool: ...
    @staticmethod
    def isKeyTypeSupported(type: PySide6.QtCore.QNativeIpcKey.Type, /) -> bool: ...
    def key(self, /) -> str: ...
    @staticmethod
    def legacyNativeKey(key: str, /, type: PySide6.QtCore.QNativeIpcKey.Type = ...) -> PySide6.QtCore.QNativeIpcKey: ...
    def lock(self, /) -> bool: ...
    def nativeIpcKey(self, /) -> PySide6.QtCore.QNativeIpcKey: ...
    def nativeKey(self, /) -> str: ...
    @staticmethod
    def platformSafeKey(key: str, /, type: PySide6.QtCore.QNativeIpcKey.Type = ...) -> PySide6.QtCore.QNativeIpcKey: ...
    def setKey(self, key: str, /) -> None: ...
    @typing.overload
    def setNativeKey(self, key: str, /, type: PySide6.QtCore.QNativeIpcKey.Type = ...) -> None: ...
    @typing.overload
    def setNativeKey(self, key: PySide6.QtCore.QNativeIpcKey | str, /) -> None: ...
    def size(self, /) -> int: ...
    def unlock(self, /) -> bool: ...


class QSignalBlocker(Shiboken.Object):

    def __init__(self, o: PySide6.QtCore.QObject, /) -> None: ...

    def __enter__(self, /) -> PySide6.QtCore.QSignalBlocker: ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object, /) -> None: ...
    def dismiss(self, /) -> None: ...
    def reblock(self, /) -> None: ...
    def unblock(self, /) -> None: ...


class QSignalMapper(PySide6.QtCore.QObject):

    mappedInt                : typing.ClassVar[Signal] = ... # mappedInt(int)
    mappedObject             : typing.ClassVar[Signal] = ... # mappedObject(QObject*)
    mappedString             : typing.ClassVar[Signal] = ... # mappedString(QString)

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    @typing.overload
    def map(self, /) -> None: ...
    @typing.overload
    def map(self, sender: PySide6.QtCore.QObject, /) -> None: ...
    @typing.overload
    def mapping(self, object: PySide6.QtCore.QObject, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def mapping(self, text: str, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def mapping(self, id: int, /) -> PySide6.QtCore.QObject: ...
    def removeMappings(self, sender: PySide6.QtCore.QObject, /) -> None: ...
    @typing.overload
    def setMapping(self, sender: PySide6.QtCore.QObject, object: PySide6.QtCore.QObject, /) -> None: ...
    @typing.overload
    def setMapping(self, sender: PySide6.QtCore.QObject, text: str, /) -> None: ...
    @typing.overload
    def setMapping(self, sender: PySide6.QtCore.QObject, id: int, /) -> None: ...


class QSize(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QSize: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def __init__(self, w: int, h: int, /) -> None: ...

    def __add__(self, s2: PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSize: ...
    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QSize, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __iadd__(self, arg__1: PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSize: ...  # type: ignore[misc]
    def __imul__(self, c: float, /) -> PySide6.QtCore.QSize: ...
    def __isub__(self, arg__1: PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSize: ...  # type: ignore[misc]
    def __mul__(self, c: float, /) -> PySide6.QtCore.QSize: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QSize, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def __sub__(self, s2: PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSize: ...
    def boundedTo(self, arg__1: PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSize: ...
    def expandedTo(self, arg__1: PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSize: ...
    def grownBy(self, m: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QSize: ...
    def height(self, /) -> int: ...
    def isEmpty(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    @typing.overload
    def scale(self, s: PySide6.QtCore.QSize, mode: PySide6.QtCore.Qt.AspectRatioMode, /) -> None: ...
    @typing.overload
    def scale(self, w: int, h: int, mode: PySide6.QtCore.Qt.AspectRatioMode, /) -> None: ...
    @typing.overload
    def scaled(self, s: PySide6.QtCore.QSize, mode: PySide6.QtCore.Qt.AspectRatioMode, /) -> PySide6.QtCore.QSize: ...
    @typing.overload
    def scaled(self, w: int, h: int, mode: PySide6.QtCore.Qt.AspectRatioMode, /) -> PySide6.QtCore.QSize: ...
    def setHeight(self, h: int, /) -> None: ...
    def setWidth(self, w: int, /) -> None: ...
    def shrunkBy(self, m: PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QSize: ...
    def toSizeF(self, /) -> PySide6.QtCore.QSizeF: ...
    def toTuple(self, /) -> typing.Tuple[int, int]: ...
    def transpose(self, /) -> None: ...
    def transposed(self, /) -> PySide6.QtCore.QSize: ...
    def width(self, /) -> int: ...


class QSizeF(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, sz: PySide6.QtCore.QSize, /) -> None: ...
    @typing.overload
    def __init__(self, QSizeF: PySide6.QtCore.QSizeF, /) -> None: ...
    @typing.overload
    def __init__(self, w: float, h: float, /) -> None: ...

    def __add__(self, s2: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSizeF: ...
    def __copy__(self, /) -> typing.Self: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QSize, /) -> bool: ...
    @typing.overload
    def __eq__(self, rhs: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> bool: ...
    def __iadd__(self, arg__1: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSizeF: ...  # type: ignore[misc]
    def __imul__(self, c: float, /) -> PySide6.QtCore.QSizeF: ...
    def __isub__(self, arg__1: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSizeF: ...  # type: ignore[misc]
    def __mul__(self, c: float, /) -> PySide6.QtCore.QSizeF: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QSize, /) -> bool: ...
    @typing.overload
    def __ne__(self, rhs: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def __sub__(self, s2: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSizeF: ...
    def boundedTo(self, arg__1: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSizeF: ...
    def expandedTo(self, arg__1: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, /) -> PySide6.QtCore.QSizeF: ...
    def grownBy(self, m: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QSizeF: ...
    def height(self, /) -> float: ...
    def isEmpty(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    @typing.overload
    def scale(self, s: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, mode: PySide6.QtCore.Qt.AspectRatioMode, /) -> None: ...
    @typing.overload
    def scale(self, w: float, h: float, mode: PySide6.QtCore.Qt.AspectRatioMode, /) -> None: ...
    @typing.overload
    def scaled(self, s: PySide6.QtCore.QSizeF | PySide6.QtCore.QSize, mode: PySide6.QtCore.Qt.AspectRatioMode, /) -> PySide6.QtCore.QSizeF: ...
    @typing.overload
    def scaled(self, w: float, h: float, mode: PySide6.QtCore.Qt.AspectRatioMode, /) -> PySide6.QtCore.QSizeF: ...
    def setHeight(self, h: float, /) -> None: ...
    def setWidth(self, w: float, /) -> None: ...
    def shrunkBy(self, m: PySide6.QtCore.QMarginsF | PySide6.QtCore.QMargins, /) -> PySide6.QtCore.QSizeF: ...
    def toSize(self, /) -> PySide6.QtCore.QSize: ...
    def toTuple(self, /) -> typing.Tuple[float, float]: ...
    def transpose(self, /) -> None: ...
    def transposed(self, /) -> PySide6.QtCore.QSizeF: ...
    def width(self, /) -> float: ...


class QSocketDescriptor(Shiboken.Object):

    @typing.overload
    def __init__(self, QSocketDescriptor: PySide6.QtCore.QSocketDescriptor, /) -> None: ...
    @typing.overload
    def __init__(self, /, descriptor: int = ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QSocketDescriptor | int, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QSocketDescriptor | int, /) -> bool: ...
    def isValid(self, /) -> bool: ...


class QSocketNotifier(PySide6.QtCore.QObject):

    activated                : typing.ClassVar[Signal] = ... # activated(QSocketDescriptor,QSocketNotifier::Type); activated(QSocketDescriptor); activated(int)

    class Type(enum.Enum):

        Read                      = 0x0
        Write                     = 0x1
        Exception                 = 0x2


    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QSocketNotifier.Type, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, socket: int, arg__2: PySide6.QtCore.QSocketNotifier.Type, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, arg__1: object, arg__2: PySide6.QtCore.QSocketNotifier.Type, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def event(self, arg__1: PySide6.QtCore.QEvent, /) -> bool: ...
    def isEnabled(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def setEnabled(self, arg__1: bool, /) -> None: ...
    def setSocket(self, socket: int, /) -> None: ...
    def socket(self, /) -> int: ...
    def type(self, /) -> PySide6.QtCore.QSocketNotifier.Type: ...


class QSortFilterProxyModel(PySide6.QtCore.QAbstractProxyModel):

    autoAcceptChildRowsChanged: typing.ClassVar[Signal] = ... # autoAcceptChildRowsChanged(bool)
    dynamicSortFilterChanged : typing.ClassVar[Signal] = ... # dynamicSortFilterChanged(bool)
    filterCaseSensitivityChanged: typing.ClassVar[Signal] = ... # filterCaseSensitivityChanged(Qt::CaseSensitivity)
    filterRoleChanged        : typing.ClassVar[Signal] = ... # filterRoleChanged(int)
    recursiveFilteringEnabledChanged: typing.ClassVar[Signal] = ... # recursiveFilteringEnabledChanged(bool)
    sortCaseSensitivityChanged: typing.ClassVar[Signal] = ... # sortCaseSensitivityChanged(Qt::CaseSensitivity)
    sortLocaleAwareChanged   : typing.ClassVar[Signal] = ... # sortLocaleAwareChanged(bool)
    sortRoleChanged          : typing.ClassVar[Signal] = ... # sortRoleChanged(int)

    class Direction(enum.Flag):

        Rows                      = 0x1
        Columns                   = 0x2
        Both                      = 0x3


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, filterRegularExpression: PySide6.QtCore.QRegularExpression | None = ..., filterKeyColumn: int | None = ..., dynamicSortFilter: bool | None = ..., filterCaseSensitivity: PySide6.QtCore.Qt.CaseSensitivity | None = ..., sortCaseSensitivity: PySide6.QtCore.Qt.CaseSensitivity | None = ..., isSortLocaleAware: bool | None = ..., sortRole: int | None = ..., filterRole: int | None = ..., recursiveFilteringEnabled: bool | None = ..., autoAcceptChildRows: bool | None = ...) -> None: ...

    def autoAcceptChildRows(self, /) -> bool: ...
    def beginFilterChange(self, /) -> None: ...
    def buddy(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def canFetchMore(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def columnCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def data(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, role: int = ...) -> typing.Any: ...
    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def dynamicSortFilter(self, /) -> bool: ...
    def endFilterChange(self, /, directions: PySide6.QtCore.QSortFilterProxyModel.Direction = ...) -> None: ...
    def fetchMore(self, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> None: ...
    def filterAcceptsColumn(self, source_column: int, source_parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def filterAcceptsRow(self, source_row: int, source_parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def filterCaseSensitivity(self, /) -> PySide6.QtCore.Qt.CaseSensitivity: ...
    def filterKeyColumn(self, /) -> int: ...
    def filterRegularExpression(self, /) -> PySide6.QtCore.QRegularExpression: ...
    def filterRole(self, /) -> int: ...
    def flags(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def hasChildren(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, /, role: int = ...) -> typing.Any: ...
    def index(self, row: int, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> PySide6.QtCore.QModelIndex: ...
    def insertColumns(self, column: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def insertRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def invalidate(self, /) -> None: ...
    def invalidateColumnsFilter(self, /) -> None: ...
    def invalidateFilter(self, /) -> None: ...
    def invalidateRowsFilter(self, /) -> None: ...
    def isRecursiveFilteringEnabled(self, /) -> bool: ...
    def isSortLocaleAware(self, /) -> bool: ...
    def lessThan(self, source_left: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, source_right: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def mapFromSource(self, sourceIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def mapSelectionFromSource(self, sourceSelection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtCore.QItemSelection: ...
    def mapSelectionToSource(self, proxySelection: PySide6.QtCore.QItemSelection, /) -> PySide6.QtCore.QItemSelection: ...
    def mapToSource(self, proxyIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def match(self, start: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, role: int, value: typing.Any, /, hits: int = ..., flags: PySide6.QtCore.Qt.MatchFlag = ...) -> typing.List[PySide6.QtCore.QModelIndex]: ...
    def mimeData(self, indexes: collections.abc.Sequence[PySide6.QtCore.QModelIndex], /) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self, /) -> typing.List[str]: ...
    @typing.overload
    def parent(self, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, child: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def removeColumns(self, column: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def removeRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def rowCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def setAutoAcceptChildRows(self, accept: bool, /) -> None: ...
    def setData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, value: typing.Any, /, role: int = ...) -> bool: ...
    def setDynamicSortFilter(self, enable: bool, /) -> None: ...
    def setFilterCaseSensitivity(self, cs: PySide6.QtCore.Qt.CaseSensitivity, /) -> None: ...
    def setFilterFixedString(self, pattern: str, /) -> None: ...
    def setFilterKeyColumn(self, column: int, /) -> None: ...
    @typing.overload
    def setFilterRegularExpression(self, pattern: str, /) -> None: ...
    @typing.overload
    def setFilterRegularExpression(self, regularExpression: PySide6.QtCore.QRegularExpression | str, /) -> None: ...
    def setFilterRole(self, role: int, /) -> None: ...
    def setFilterWildcard(self, pattern: str, /) -> None: ...
    def setHeaderData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, value: typing.Any, /, role: int = ...) -> bool: ...
    def setRecursiveFilteringEnabled(self, recursive: bool, /) -> None: ...
    def setSortCaseSensitivity(self, cs: PySide6.QtCore.Qt.CaseSensitivity, /) -> None: ...
    def setSortLocaleAware(self, on: bool, /) -> None: ...
    def setSortRole(self, role: int, /) -> None: ...
    def setSourceModel(self, sourceModel: PySide6.QtCore.QAbstractItemModel, /) -> None: ...
    def sibling(self, row: int, column: int, idx: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def sort(self, column: int, /, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def sortCaseSensitivity(self, /) -> PySide6.QtCore.Qt.CaseSensitivity: ...
    def sortColumn(self, /) -> int: ...
    def sortOrder(self, /) -> PySide6.QtCore.Qt.SortOrder: ...
    def sortRole(self, /) -> int: ...
    def span(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QSize: ...
    def supportedDropActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...


class QStandardPaths(Shiboken.Object):

    class LocateOption(enum.Flag):

        LocateFile                = 0x0
        LocateDirectory           = 0x1

    class StandardLocation(enum.Enum):

        DesktopLocation           = 0x0
        DocumentsLocation         = 0x1
        FontsLocation             = 0x2
        ApplicationsLocation      = 0x3
        MusicLocation             = 0x4
        MoviesLocation            = 0x5
        PicturesLocation          = 0x6
        TempLocation              = 0x7
        HomeLocation              = 0x8
        AppLocalDataLocation      = 0x9
        CacheLocation             = 0xa
        GenericDataLocation       = 0xb
        RuntimeLocation           = 0xc
        ConfigLocation            = 0xd
        DownloadLocation          = 0xe
        GenericCacheLocation      = 0xf
        GenericConfigLocation     = 0x10
        AppDataLocation           = 0x11
        AppConfigLocation         = 0x12
        PublicShareLocation       = 0x13
        TemplatesLocation         = 0x14
        StateLocation             = 0x15
        GenericStateLocation      = 0x16


    @staticmethod
    def displayName(type: PySide6.QtCore.QStandardPaths.StandardLocation, /) -> str: ...
    @staticmethod
    def findExecutable(executableName: str, /, paths: collections.abc.Sequence[str] = ...) -> str: ...
    @staticmethod
    def isTestModeEnabled() -> bool: ...
    @staticmethod
    def locate(type: PySide6.QtCore.QStandardPaths.StandardLocation, fileName: str, /, options: PySide6.QtCore.QStandardPaths.LocateOption = ...) -> str: ...
    @staticmethod
    def locateAll(type: PySide6.QtCore.QStandardPaths.StandardLocation, fileName: str, /, options: PySide6.QtCore.QStandardPaths.LocateOption = ...) -> typing.List[str]: ...
    @staticmethod
    def setTestModeEnabled(testMode: bool, /) -> None: ...
    @staticmethod
    def standardLocations(type: PySide6.QtCore.QStandardPaths.StandardLocation, /) -> typing.List[str]: ...
    @staticmethod
    def writableLocation(type: PySide6.QtCore.QStandardPaths.StandardLocation, /) -> str: ...


class QStorageInfo(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, dir: PySide6.QtCore.QDir, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QStorageInfo, /) -> None: ...
    @typing.overload
    def __init__(self, path: str, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QStorageInfo, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QStorageInfo, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def blockSize(self, /) -> int: ...
    def bytesAvailable(self, /) -> int: ...
    def bytesFree(self, /) -> int: ...
    def bytesTotal(self, /) -> int: ...
    def device(self, /) -> PySide6.QtCore.QByteArray: ...
    def displayName(self, /) -> str: ...
    def fileSystemType(self, /) -> PySide6.QtCore.QByteArray: ...
    def isReadOnly(self, /) -> bool: ...
    def isReady(self, /) -> bool: ...
    def isRoot(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    @staticmethod
    def mountedVolumes() -> typing.List[PySide6.QtCore.QStorageInfo]: ...
    def name(self, /) -> str: ...
    def refresh(self, /) -> None: ...
    @staticmethod
    def root() -> PySide6.QtCore.QStorageInfo: ...
    def rootPath(self, /) -> str: ...
    def setPath(self, path: str, /) -> None: ...
    def subvolume(self, /) -> PySide6.QtCore.QByteArray: ...
    def swap(self, other: PySide6.QtCore.QStorageInfo, /) -> None: ...


class QStringConverter(PySide6.QtCore.QStringConverterBase):

    class Encoding(enum.Enum):

        Utf8                      = 0x0
        Utf16                     = 0x1
        Utf16LE                   = 0x2
        Utf16BE                   = 0x3
        Utf32                     = 0x4
        Utf32LE                   = 0x5
        Utf32BE                   = 0x6
        Latin1                    = 0x7
        LastEncoding              = 0x8
        System                    = 0x8


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, encoding: PySide6.QtCore.QStringConverter.Encoding, f: PySide6.QtCore.QStringConverterBase.Flag, /) -> None: ...
    @typing.overload
    def __init__(self, name: str, f: PySide6.QtCore.QStringConverterBase.Flag, /) -> None: ...

    @staticmethod
    def availableCodecs() -> typing.List[str]: ...
    def hasError(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def name(self, /) -> bytes | bytearray | memoryview: ...
    @staticmethod
    def nameForEncoding(e: PySide6.QtCore.QStringConverter.Encoding, /) -> bytes | bytearray | memoryview: ...
    def resetState(self, /) -> None: ...


class QStringConverterBase(Shiboken.Object):

    class Flag(enum.Flag):

        Default                   = 0x0
        Stateless                 = 0x1
        ConvertInvalidToNull      = 0x2
        WriteBom                  = 0x4
        ConvertInitialBom         = 0x8
        UsesIcu                   = 0x10

    class State(Shiboken.Object):

        def __init__(self, /, f: PySide6.QtCore.QStringConverterBase.Flag = ...) -> None: ...

        def clear(self, /) -> None: ...
        def reset(self, /) -> None: ...


    def __init__(self, /) -> None: ...


class QStringDecoder(PySide6.QtCore.QStringConverter):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, encoding: PySide6.QtCore.QStringConverter.Encoding, /, flags: PySide6.QtCore.QStringConverterBase.Flag = ...) -> None: ...
    @typing.overload
    def __init__(self, name: str, /, f: PySide6.QtCore.QStringConverterBase.Flag = ...) -> None: ...

    def appendToBuffer(self, out: bytes | bytearray | memoryview, ba: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bytes | bytearray | memoryview: ...
    @staticmethod
    def decoderForHtml(data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QStringDecoder: ...
    def requiredSpace(self, inputLength: int, /) -> int: ...


class QStringEncoder(PySide6.QtCore.QStringConverter):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, encoding: PySide6.QtCore.QStringConverter.Encoding, /, flags: PySide6.QtCore.QStringConverterBase.Flag = ...) -> None: ...
    @typing.overload
    def __init__(self, name: str, /, flags: PySide6.QtCore.QStringConverterBase.Flag = ...) -> None: ...

    def requiredSpace(self, inputLength: int, /) -> int: ...


class QStringListModel(PySide6.QtCore.QAbstractListModel):

    @typing.overload
    def __init__(self, strings: collections.abc.Sequence[str], /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...
    @typing.overload
    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def clearItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> bool: ...
    def data(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /, role: int = ...) -> typing.Any: ...
    def flags(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.Qt.ItemFlag: ...
    def insertRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def itemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> typing.Dict[int, typing.Any]: ...
    def moveRows(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceRow: int, count: int, destinationParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destinationChild: int, /) -> bool: ...
    def removeRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def rowCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def setData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, value: typing.Any, /, role: int = ...) -> bool: ...
    def setItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, roles: typing.Dict[int, typing.Any], /) -> bool: ...
    def setStringList(self, strings: collections.abc.Sequence[str], /) -> None: ...
    def sibling(self, row: int, column: int, idx: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def sort(self, column: int, /, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def stringList(self, /) -> typing.List[str]: ...
    def supportedDropActions(self, /) -> PySide6.QtCore.Qt.DropAction: ...


class QSysInfo(Shiboken.Object):

    class Endian(enum.Enum):

        BigEndian                 = 0x0
        ByteOrder                 = 0x1
        LittleEndian              = 0x1

    class Sizes(enum.Enum):

        WordSize                  = 0x40


    def __init__(self, /) -> None: ...

    @staticmethod
    def bootUniqueId() -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def buildAbi() -> str: ...
    @staticmethod
    def buildCpuArchitecture() -> str: ...
    @staticmethod
    def currentCpuArchitecture() -> str: ...
    @staticmethod
    def kernelType() -> str: ...
    @staticmethod
    def kernelVersion() -> str: ...
    @staticmethod
    def machineHostName() -> str: ...
    @staticmethod
    def machineUniqueId() -> PySide6.QtCore.QByteArray: ...
    @staticmethod
    def prettyProductName() -> str: ...
    @staticmethod
    def productType() -> str: ...
    @staticmethod
    def productVersion() -> str: ...


class QSystemSemaphore(Shiboken.Object):

    class AccessMode(enum.Enum):

        Open                      = 0x0
        Create                    = 0x1

    class SystemSemaphoreError(enum.Enum):

        NoError                   = 0x0
        PermissionDenied          = 0x1
        KeyError                  = 0x2
        AlreadyExists             = 0x3
        NotFound                  = 0x4
        OutOfResources            = 0x5
        UnknownError              = 0x6


    @typing.overload
    def __init__(self, key: str, /, initialValue: int | None = ..., mode: PySide6.QtCore.QSystemSemaphore.AccessMode = ...) -> None: ...
    @typing.overload
    def __init__(self, key: PySide6.QtCore.QNativeIpcKey | str, /, initialValue: int | None = ..., arg__3: PySide6.QtCore.QSystemSemaphore.AccessMode = ...) -> None: ...

    def acquire(self, /) -> bool: ...
    def error(self, /) -> PySide6.QtCore.QSystemSemaphore.SystemSemaphoreError: ...
    def errorString(self, /) -> str: ...
    @staticmethod
    def isKeyTypeSupported(type: PySide6.QtCore.QNativeIpcKey.Type, /) -> bool: ...
    def key(self, /) -> str: ...
    @staticmethod
    def legacyNativeKey(key: str, /, type: PySide6.QtCore.QNativeIpcKey.Type = ...) -> PySide6.QtCore.QNativeIpcKey: ...
    def nativeIpcKey(self, /) -> PySide6.QtCore.QNativeIpcKey: ...
    @staticmethod
    def platformSafeKey(key: str, /, type: PySide6.QtCore.QNativeIpcKey.Type = ...) -> PySide6.QtCore.QNativeIpcKey: ...
    def release(self, /, n: int = ...) -> bool: ...
    def setKey(self, key: str, /, initialValue: int | None = ..., mode: PySide6.QtCore.QSystemSemaphore.AccessMode = ...) -> None: ...
    @typing.overload
    def setNativeKey(self, key: str, /, initialValue: int | None = ..., mode: PySide6.QtCore.QSystemSemaphore.AccessMode = ..., type: PySide6.QtCore.QNativeIpcKey.Type = ...) -> None: ...
    @typing.overload
    def setNativeKey(self, key: PySide6.QtCore.QNativeIpcKey | str, /, initialValue: int | None = ..., arg__3: PySide6.QtCore.QSystemSemaphore.AccessMode = ...) -> None: ...


class QTemporaryDir(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, templateName: str, /) -> None: ...

    def autoRemove(self, /) -> bool: ...
    def errorString(self, /) -> str: ...
    def filePath(self, fileName: str, /) -> str: ...
    def isValid(self, /) -> bool: ...
    def path(self, /) -> str: ...
    def remove(self, /) -> bool: ...
    def setAutoRemove(self, b: bool, /) -> None: ...
    def swap(self, other: PySide6.QtCore.QTemporaryDir, /) -> None: ...


class QTemporaryFile(PySide6.QtCore.QFile):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, parent: PySide6.QtCore.QObject, /) -> None: ...
    @typing.overload
    def __init__(self, templateName: str, /) -> None: ...
    @typing.overload
    def __init__(self, templateName: str, parent: PySide6.QtCore.QObject, /) -> None: ...

    def autoRemove(self, /) -> bool: ...
    @typing.overload
    @staticmethod
    def createNativeFile(file: PySide6.QtCore.QFile, /) -> PySide6.QtCore.QTemporaryFile: ...
    @typing.overload
    @staticmethod
    def createNativeFile(fileName: str, /) -> PySide6.QtCore.QTemporaryFile: ...
    def fileName(self, /) -> str: ...
    def fileTemplate(self, /) -> str: ...
    @typing.overload
    def open(self, /) -> bool: ...
    @typing.overload
    def open(self, flags: PySide6.QtCore.QIODeviceBase.OpenModeFlag, /) -> bool: ...
    def rename(self, newName: str | bytes | os.PathLike[str], /) -> bool: ...
    def setAutoRemove(self, b: bool, /) -> None: ...
    def setFileTemplate(self, name: str, /) -> None: ...


class QTextBoundaryFinder(Shiboken.Object):

    class BoundaryReason(enum.Flag):

        NotAtBoundary             = 0x0
        BreakOpportunity          = 0x1f
        StartOfItem               = 0x20
        EndOfItem                 = 0x40
        MandatoryBreak            = 0x80
        SoftHyphen                = 0x100

    class BoundaryType(enum.Enum):

        Grapheme                  = 0x0
        Word                      = 0x1
        Sentence                  = 0x2
        Line                      = 0x3


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QTextBoundaryFinder.BoundaryType, string: str, /) -> None: ...
    @typing.overload
    def __init__(self, type: PySide6.QtCore.QTextBoundaryFinder.BoundaryType, str: str, /, buffer: bytes | bytearray | memoryview | None= ..., bufferSize: int | None = ...) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QTextBoundaryFinder, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def boundaryReasons(self, /) -> PySide6.QtCore.QTextBoundaryFinder.BoundaryReason: ...
    def isAtBoundary(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def position(self, /) -> int: ...
    def setPosition(self, position: int, /) -> None: ...
    def string(self, /) -> str: ...
    def toEnd(self, /) -> None: ...
    def toNextBoundary(self, /) -> int: ...
    def toPreviousBoundary(self, /) -> int: ...
    def toStart(self, /) -> None: ...
    def type(self, /) -> PySide6.QtCore.QTextBoundaryFinder.BoundaryType: ...


class QTextStream(PySide6.QtCore.QIODeviceBase):

    class FieldAlignment(enum.Enum):

        AlignLeft                 = 0x0
        AlignRight                = 0x1
        AlignCenter               = 0x2
        AlignAccountingStyle      = 0x3

    class NumberFlag(enum.Flag):

        ShowBase                  = 0x1
        ForcePoint                = 0x2
        ForceSign                 = 0x4
        UppercaseBase             = 0x8
        UppercaseDigits           = 0x10

    class RealNumberNotation(enum.Enum):

        SmartNotation             = 0x0
        FixedNotation             = 0x1
        ScientificNotation        = 0x2

    class Status(enum.Enum):

        Ok                        = 0x0
        ReadPastEnd               = 0x1
        ReadCorruptData           = 0x2
        WriteFailed               = 0x3


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, device: PySide6.QtCore.QIODevice, /) -> None: ...
    @typing.overload
    def __init__(self, array: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, openMode: PySide6.QtCore.QIODeviceBase.OpenModeFlag = ...) -> None: ...

    @typing.overload
    def __lshift__(self, m: PySide6.QtCore.QTextStreamManipulator, /) -> PySide6.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, ch: str, /) -> PySide6.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, array: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, ch: int, /) -> PySide6.QtCore.QTextStream: ...
    @typing.overload
    def __lshift__(self, f: float, /) -> PySide6.QtCore.QTextStream: ...
    def __rshift__(self, array: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QTextStream: ...
    def atEnd(self, /) -> bool: ...
    def autoDetectUnicode(self, /) -> bool: ...
    def device(self, /) -> PySide6.QtCore.QIODevice: ...
    def encoding(self, /) -> PySide6.QtCore.QStringConverter.Encoding: ...
    def fieldAlignment(self, /) -> PySide6.QtCore.QTextStream.FieldAlignment: ...
    def fieldWidth(self, /) -> int: ...
    def flush(self, /) -> None: ...
    def generateByteOrderMark(self, /) -> bool: ...
    def integerBase(self, /) -> int: ...
    def locale(self, /) -> PySide6.QtCore.QLocale: ...
    def numberFlags(self, /) -> PySide6.QtCore.QTextStream.NumberFlag: ...
    def padChar(self, /) -> str: ...
    def pos(self, /) -> int: ...
    def read(self, maxlen: int, /) -> str: ...
    def readAll(self, /) -> str: ...
    def readLine(self, /, maxlen: int | None = ...) -> str: ...
    def readLineInto(self, /, maxlen: int | None = ...) -> typing.Tuple[bool, str]: ...
    def realNumberNotation(self, /) -> PySide6.QtCore.QTextStream.RealNumberNotation: ...
    def realNumberPrecision(self, /) -> int: ...
    def reset(self, /) -> None: ...
    def resetStatus(self, /) -> None: ...
    def seek(self, pos: int, /) -> bool: ...
    def setAutoDetectUnicode(self, enabled: bool, /) -> None: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice, /) -> None: ...
    def setEncoding(self, encoding: PySide6.QtCore.QStringConverter.Encoding, /) -> None: ...
    def setFieldAlignment(self, alignment: PySide6.QtCore.QTextStream.FieldAlignment, /) -> None: ...
    def setFieldWidth(self, width: int, /) -> None: ...
    def setGenerateByteOrderMark(self, generate: bool, /) -> None: ...
    def setIntegerBase(self, base: int, /) -> None: ...
    def setLocale(self, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, /) -> None: ...
    def setNumberFlags(self, flags: PySide6.QtCore.QTextStream.NumberFlag, /) -> None: ...
    def setPadChar(self, ch: str, /) -> None: ...
    def setRealNumberNotation(self, notation: PySide6.QtCore.QTextStream.RealNumberNotation, /) -> None: ...
    def setRealNumberPrecision(self, precision: int, /) -> None: ...
    def setStatus(self, status: PySide6.QtCore.QTextStream.Status, /) -> None: ...
    def skipWhiteSpace(self, /) -> None: ...
    def status(self, /) -> PySide6.QtCore.QTextStream.Status: ...
    def string(self, /) -> typing.List[str]: ...


class QTextStreamManipulator(Shiboken.Object):

    def __init__(self, QTextStreamManipulator: PySide6.QtCore.QTextStreamManipulator, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def exec(self, s: PySide6.QtCore.QTextStream, /) -> None: ...
    def exec_(self, arg__1: PySide6.QtCore.QTextStream, /) -> None: ...


class QThread(PySide6.QtCore.QObject):

    finished                 : typing.ClassVar[Signal] = ... # finished()
    started                  : typing.ClassVar[Signal] = ... # started()

    class Priority(enum.Enum):

        IdlePriority              = 0x0
        LowestPriority            = 0x1
        LowPriority               = 0x2
        NormalPriority            = 0x3
        HighPriority              = 0x4
        HighestPriority           = 0x5
        TimeCriticalPriority      = 0x6
        InheritPriority           = 0x7

    class QualityOfService(enum.Enum):

        Auto                      = 0x0
        High                      = 0x1
        Eco                       = 0x2


    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    @staticmethod
    def currentThread() -> PySide6.QtCore.QThread: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def eventDispatcher(self, /) -> PySide6.QtCore.QAbstractEventDispatcher: ...
    def exec(self, /) -> int: ...
    def exec_(self, /) -> int: ...
    def exit(self, /, retcode: int | None = ...) -> None: ...
    @staticmethod
    def idealThreadCount() -> int: ...
    def isCurrentThread(self, /) -> bool: ...
    def isFinished(self, /) -> bool: ...
    def isInterruptionRequested(self, /) -> bool: ...
    @staticmethod
    def isMainThread() -> bool: ...
    def isRunning(self, /) -> bool: ...
    def loopLevel(self, /) -> int: ...
    @staticmethod
    def msleep(arg__1: int, /) -> None: ...
    def priority(self, /) -> PySide6.QtCore.QThread.Priority: ...
    def quit(self, /) -> None: ...
    def requestInterruption(self, /) -> None: ...
    def run(self, /) -> None: ...
    def serviceLevel(self, /) -> PySide6.QtCore.QThread.QualityOfService: ...
    def setEventDispatcher(self, eventDispatcher: PySide6.QtCore.QAbstractEventDispatcher, /) -> None: ...
    def setPriority(self, priority: PySide6.QtCore.QThread.Priority, /) -> None: ...
    def setServiceLevel(self, serviceLevel: PySide6.QtCore.QThread.QualityOfService, /) -> None: ...
    def setStackSize(self, stackSize: int, /) -> None: ...
    @staticmethod
    def setTerminationEnabled(enabled: bool = ...) -> None: ...
    @staticmethod
    def sleep(arg__1: int, /) -> None: ...
    def stackSize(self, /) -> int: ...
    def start(self, /, priority: PySide6.QtCore.QThread.Priority = ...) -> None: ...
    def terminate(self, /) -> None: ...
    @staticmethod
    def usleep(arg__1: int, /) -> None: ...
    @typing.overload
    def wait(self, time: int, /) -> bool: ...
    @typing.overload
    def wait(self, /, deadline: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int= ...) -> bool: ...
    @staticmethod
    def yieldCurrentThread() -> None: ...


class QThreadPool(PySide6.QtCore.QObject):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, expiryTimeout: int | None = ..., maxThreadCount: int | None = ..., activeThreadCount: int | None = ..., stackSize: int | None = ..., threadPriority: PySide6.QtCore.QThread.Priority | None = ...) -> None: ...

    def activeThreadCount(self, /) -> int: ...
    def clear(self, /) -> None: ...
    def contains(self, thread: PySide6.QtCore.QThread, /) -> bool: ...
    def expiryTimeout(self, /) -> int: ...
    @staticmethod
    def globalInstance() -> PySide6.QtCore.QThreadPool: ...
    def maxThreadCount(self, /) -> int: ...
    def releaseThread(self, /) -> None: ...
    def reserveThread(self, /) -> None: ...
    def serviceLevel(self, /) -> PySide6.QtCore.QThread.QualityOfService: ...
    def setExpiryTimeout(self, expiryTimeout: int, /) -> None: ...
    def setMaxThreadCount(self, maxThreadCount: int, /) -> None: ...
    def setServiceLevel(self, serviceLevel: PySide6.QtCore.QThread.QualityOfService, /) -> None: ...
    def setStackSize(self, stackSize: int, /) -> None: ...
    def setThreadPriority(self, priority: PySide6.QtCore.QThread.Priority, /) -> None: ...
    def stackSize(self, /) -> int: ...
    @typing.overload
    def start(self, runnable: PySide6.QtCore.QRunnable, /, priority: int | None = ...) -> None: ...
    @typing.overload
    def start(self, arg__1: collections.abc.Callable[..., typing.Any], /, priority: int | None = ...) -> None: ...
    def startOnReservedThread(self, runnable: PySide6.QtCore.QRunnable, /) -> None: ...
    def threadPriority(self, /) -> PySide6.QtCore.QThread.Priority: ...
    @typing.overload
    def tryStart(self, runnable: PySide6.QtCore.QRunnable, /) -> bool: ...
    @typing.overload
    def tryStart(self, callable: collections.abc.Callable[..., typing.Any], /) -> bool: ...
    def tryTake(self, runnable: PySide6.QtCore.QRunnable, /) -> bool: ...
    @typing.overload
    def waitForDone(self, msecs: int, /) -> bool: ...
    @typing.overload
    def waitForDone(self, /, deadline: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int= ...) -> bool: ...


class QTime(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QTime: PySide6.QtCore.QTime, /) -> None: ...
    @typing.overload
    def __init__(self, h: int, m: int, /, s: int | None = ..., ms: int | None = ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QTime, /) -> bool: ...
    def __ge__(self, rhs: PySide6.QtCore.QTime, /) -> bool: ...
    def __gt__(self, rhs: PySide6.QtCore.QTime, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __le__(self, rhs: PySide6.QtCore.QTime, /) -> bool: ...
    def __lt__(self, rhs: PySide6.QtCore.QTime, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QTime, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def addMSecs(self, ms: int, /) -> PySide6.QtCore.QTime: ...
    def addSecs(self, secs: int, /) -> PySide6.QtCore.QTime: ...
    @staticmethod
    def currentTime() -> PySide6.QtCore.QTime: ...
    @staticmethod
    def fromMSecsSinceStartOfDay(msecs: int, /) -> PySide6.QtCore.QTime: ...
    @typing.overload
    @staticmethod
    def fromString(string: str, /, format: PySide6.QtCore.Qt.DateFormat = ...) -> PySide6.QtCore.QTime: ...
    @typing.overload
    @staticmethod
    def fromString(string: str, format: str, /) -> PySide6.QtCore.QTime: ...
    def hour(self, /) -> int: ...
    def isNull(self, /) -> bool: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def isValid(self, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def isValid(h: int, m: int, s: int, /, ms: int | None = ...) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    def minute(self, /) -> int: ...
    def msec(self, /) -> int: ...
    def msecsSinceStartOfDay(self, /) -> int: ...
    def msecsTo(self, t: PySide6.QtCore.QTime, /) -> int: ...
    def second(self, /) -> int: ...
    def secsTo(self, t: PySide6.QtCore.QTime, /) -> int: ...
    def setHMS(self, h: int, m: int, s: int, /, ms: int | None = ...) -> bool: ...
    def toPython(self, /) -> object: ...
    @typing.overload
    def toString(self, /, f: PySide6.QtCore.Qt.DateFormat = ...) -> str: ...
    @typing.overload
    def toString(self, format: str, /) -> str: ...


class QTimeLine(PySide6.QtCore.QObject):

    finished                 : typing.ClassVar[Signal] = ... # finished()
    frameChanged             : typing.ClassVar[Signal] = ... # frameChanged(int)
    stateChanged             : typing.ClassVar[Signal] = ... # stateChanged(QTimeLine::State)
    valueChanged             : typing.ClassVar[Signal] = ... # valueChanged(double)

    class Direction(enum.Enum):

        Forward                   = 0x0
        Backward                  = 0x1

    class State(enum.Enum):

        NotRunning                = 0x0
        Paused                    = 0x1
        Running                   = 0x2


    def __init__(self, /, duration: int = ..., parent: PySide6.QtCore.QObject | None = ..., *, updateInterval: int | None = ..., currentTime: int | None = ..., direction: PySide6.QtCore.QTimeLine.Direction | None = ..., loopCount: int | None = ..., easingCurve: PySide6.QtCore.QEasingCurve | None = ...) -> None: ...

    def currentFrame(self, /) -> int: ...
    def currentTime(self, /) -> int: ...
    def currentValue(self, /) -> float: ...
    def direction(self, /) -> PySide6.QtCore.QTimeLine.Direction: ...
    def duration(self, /) -> int: ...
    def easingCurve(self, /) -> PySide6.QtCore.QEasingCurve: ...
    def endFrame(self, /) -> int: ...
    def frameForTime(self, msec: int, /) -> int: ...
    def loopCount(self, /) -> int: ...
    def resume(self, /) -> None: ...
    def setCurrentTime(self, msec: int, /) -> None: ...
    def setDirection(self, direction: PySide6.QtCore.QTimeLine.Direction, /) -> None: ...
    def setDuration(self, duration: int, /) -> None: ...
    def setEasingCurve(self, curve: PySide6.QtCore.QEasingCurve | PySide6.QtCore.QEasingCurve.Type, /) -> None: ...
    def setEndFrame(self, frame: int, /) -> None: ...
    def setFrameRange(self, startFrame: int, endFrame: int, /) -> None: ...
    def setLoopCount(self, count: int, /) -> None: ...
    def setPaused(self, paused: bool, /) -> None: ...
    def setStartFrame(self, frame: int, /) -> None: ...
    def setUpdateInterval(self, interval: int, /) -> None: ...
    def start(self, /) -> None: ...
    def startFrame(self, /) -> int: ...
    def state(self, /) -> PySide6.QtCore.QTimeLine.State: ...
    def stop(self, /) -> None: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def toggleDirection(self, /) -> None: ...
    def updateInterval(self, /) -> int: ...
    def valueForTime(self, msec: int, /) -> float: ...


class QTimeZone(Shiboken.Object):

    class Initialization(enum.Enum):

        LocalTime                 = 0x0
        UTC                       = 0x1

    class NameType(enum.Enum):

        DefaultName               = 0x0
        LongName                  = 0x1
        ShortName                 = 0x2
        OffsetName                = 0x3

    class OffsetData(Shiboken.Object):

        @typing.overload
        def __init__(self, /) -> None: ...
        @typing.overload
        def __init__(self, OffsetData: PySide6.QtCore.QTimeZone.OffsetData, /) -> None: ...

        def __copy__(self, /) -> typing.Self: ...

    class TimeType(enum.Enum):

        StandardTime              = 0x0
        DaylightTime              = 0x1
        GenericTime               = 0x2


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, spec: PySide6.QtCore.QTimeZone.Initialization, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QTimeZone, /) -> None: ...
    @typing.overload
    def __init__(self, ianaId: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    def __init__(self, zoneId: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, offsetSeconds: int, name: str, abbreviation: str, /, territory: PySide6.QtCore.QLocale.Country = ..., comment: str = ...) -> None: ...
    @typing.overload
    def __init__(self, offsetSeconds: int, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    def abbreviation(self, atDateTime: PySide6.QtCore.QDateTime, /) -> str: ...
    def asBackendZone(self, /) -> PySide6.QtCore.QTimeZone: ...
    @typing.overload
    @staticmethod
    def availableTimeZoneIds() -> typing.List[PySide6.QtCore.QByteArray]: ...
    @typing.overload
    @staticmethod
    def availableTimeZoneIds(territory: PySide6.QtCore.QLocale.Country, /) -> typing.List[PySide6.QtCore.QByteArray]: ...
    @typing.overload
    @staticmethod
    def availableTimeZoneIds(offsetSeconds: int, /) -> typing.List[PySide6.QtCore.QByteArray]: ...
    def comment(self, /) -> str: ...
    def country(self, /) -> PySide6.QtCore.QLocale.Country: ...
    def daylightTimeOffset(self, atDateTime: PySide6.QtCore.QDateTime, /) -> int: ...
    @typing.overload
    def displayName(self, atDateTime: PySide6.QtCore.QDateTime, /, nameType: PySide6.QtCore.QTimeZone.NameType = ..., locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language= ...) -> str: ...
    @typing.overload
    def displayName(self, timeType: PySide6.QtCore.QTimeZone.TimeType, /, nameType: PySide6.QtCore.QTimeZone.NameType = ..., locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language= ...) -> str: ...
    def fixedSecondsAheadOfUtc(self, /) -> int: ...
    @staticmethod
    def fromDurationAheadOfUtc(offset: int, /) -> PySide6.QtCore.QTimeZone: ...
    @staticmethod
    def fromSecondsAheadOfUtc(offset: int, /) -> PySide6.QtCore.QTimeZone: ...
    def hasAlternativeName(self, alias: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    def hasDaylightTime(self, /) -> bool: ...
    def hasTransitions(self, /) -> bool: ...
    @staticmethod
    def ianaIdToWindowsId(ianaId: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    def id(self, /) -> PySide6.QtCore.QByteArray: ...
    def isDaylightTime(self, atDateTime: PySide6.QtCore.QDateTime, /) -> bool: ...
    @staticmethod
    def isTimeZoneIdAvailable(ianaId: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> bool: ...
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    @staticmethod
    def isUtcOrFixedOffset(spec: PySide6.QtCore.Qt.TimeSpec, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    @typing.overload  # type: ignore[misc, overload-cannot-match]
    def isUtcOrFixedOffset(self, /) -> bool: ...  # type: ignore[misc, overload-cannot-match]
    def isValid(self, /) -> bool: ...
    def nextTransition(self, afterDateTime: PySide6.QtCore.QDateTime, /) -> PySide6.QtCore.QTimeZone.OffsetData: ...
    def offsetData(self, forDateTime: PySide6.QtCore.QDateTime, /) -> PySide6.QtCore.QTimeZone.OffsetData: ...
    def offsetFromUtc(self, atDateTime: PySide6.QtCore.QDateTime, /) -> int: ...
    def previousTransition(self, beforeDateTime: PySide6.QtCore.QDateTime, /) -> PySide6.QtCore.QTimeZone.OffsetData: ...
    def standardTimeOffset(self, atDateTime: PySide6.QtCore.QDateTime, /) -> int: ...
    def swap(self, other: PySide6.QtCore.QTimeZone | PySide6.QtCore.QTimeZone.Initialization, /) -> None: ...
    @staticmethod
    def systemTimeZone() -> PySide6.QtCore.QTimeZone: ...
    @staticmethod
    def systemTimeZoneId() -> PySide6.QtCore.QByteArray: ...
    def territory(self, /) -> PySide6.QtCore.QLocale.Country: ...
    def timeSpec(self, /) -> PySide6.QtCore.Qt.TimeSpec: ...
    def transitions(self, fromDateTime: PySide6.QtCore.QDateTime, toDateTime: PySide6.QtCore.QDateTime, /) -> typing.List[PySide6.QtCore.QTimeZone.OffsetData]: ...
    @staticmethod
    def utc() -> PySide6.QtCore.QTimeZone: ...
    @typing.overload
    @staticmethod
    def windowsIdToDefaultIanaId(windowsId: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def windowsIdToDefaultIanaId(windowsId: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, territory: PySide6.QtCore.QLocale.Country, /) -> PySide6.QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def windowsIdToIanaIds(windowsId: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> typing.List[PySide6.QtCore.QByteArray]: ...
    @typing.overload
    @staticmethod
    def windowsIdToIanaIds(windowsId: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, territory: PySide6.QtCore.QLocale.Country, /) -> typing.List[PySide6.QtCore.QByteArray]: ...


class QTimer(PySide6.QtCore.QObject):

    timeout                  : typing.ClassVar[Signal] = ... # timeout()

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, singleShot: bool | None = ..., interval: int | None = ..., remainingTime: int | None = ..., timerType: PySide6.QtCore.Qt.TimerType | None = ..., active: bool | None = ...) -> None: ...

    def id(self, /) -> PySide6.QtCore.Qt.TimerId: ...
    def interval(self, /) -> int: ...
    def intervalAsDuration(self, /) -> int: ...
    def isActive(self, /) -> bool: ...
    def isSingleShot(self, /) -> bool: ...
    def killTimer(self, arg__1: int, /) -> None: ...
    def remainingTime(self, /) -> int: ...
    def remainingTimeAsDuration(self, /) -> int: ...
    def setInterval(self, msec: int, /) -> None: ...
    def setSingleShot(self, singleShot: bool, /) -> None: ...
    def setTimerType(self, atype: PySide6.QtCore.Qt.TimerType, /) -> None: ...
    @typing.overload
    @staticmethod
    def singleShot(msec: int, context: PySide6.QtCore.QObject, functor: collections.abc.Callable[..., typing.Any], /) -> None: ...
    @typing.overload
    @staticmethod
    def singleShot(msec: int, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    @staticmethod
    def singleShot(msec: int, timerType: PySide6.QtCore.Qt.TimerType, receiver: PySide6.QtCore.QObject, member: bytes | bytearray | memoryview, /) -> None: ...
    @typing.overload
    @staticmethod
    def singleShot(msec: int, functor: collections.abc.Callable[..., typing.Any], /) -> None: ...
    @typing.overload
    def start(self, /) -> None: ...
    @typing.overload
    def start(self, msec: int, /) -> None: ...
    def stop(self, /) -> None: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent, /) -> None: ...
    def timerId(self, /) -> int: ...
    def timerType(self, /) -> PySide6.QtCore.Qt.TimerType: ...


class QTimerEvent(PySide6.QtCore.QEvent):

    @typing.overload
    def __init__(self, arg__1: PySide6.QtCore.QTimerEvent, /) -> None: ...
    @typing.overload
    def __init__(self, timerId: PySide6.QtCore.Qt.TimerId, /) -> None: ...
    @typing.overload
    def __init__(self, timerId: int, /) -> None: ...

    def clone(self, /) -> PySide6.QtCore.QTimerEvent: ...
    def id(self, /) -> PySide6.QtCore.Qt.TimerId: ...
    def matches(self, timer: PySide6.QtCore.QBasicTimer, /) -> bool: ...
    def timerId(self, /) -> int: ...


class QTranslator(PySide6.QtCore.QObject):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def filePath(self, /) -> str: ...
    def isEmpty(self, /) -> bool: ...
    def language(self, /) -> str: ...
    @typing.overload
    def load(self, filename: str, /, directory: str = ..., search_delimiters: str = ..., suffix: str = ...) -> bool: ...
    @typing.overload
    def load(self, locale: PySide6.QtCore.QLocale | PySide6.QtCore.QLocale.Language, filename: str, /, prefix: str = ..., directory: str = ..., suffix: str = ...) -> bool: ...
    @typing.overload
    def load(self, data: bytes | bytearray | memoryview, /, directory: str = ...) -> bool: ...
    def translate(self, context: str, sourceText: str, /, disambiguation: str | None = ..., n: int = ...) -> str: ...


class QTransposeProxyModel(PySide6.QtCore.QAbstractProxyModel):

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ...) -> None: ...

    def columnCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def headerData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, /, role: int = ...) -> typing.Any: ...
    def index(self, row: int, column: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> PySide6.QtCore.QModelIndex: ...
    def insertColumns(self, column: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def insertRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def itemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> typing.Dict[int, typing.Any]: ...
    def mapFromSource(self, sourceIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def mapToSource(self, proxyIndex: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def moveColumns(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceColumn: int, count: int, destinationParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destinationChild: int, /) -> bool: ...
    def moveRows(self, sourceParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, sourceRow: int, count: int, destinationParent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, destinationChild: int, /) -> bool: ...
    @typing.overload
    def parent(self, /) -> PySide6.QtCore.QObject: ...
    @typing.overload
    def parent(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QModelIndex: ...
    def removeColumns(self, column: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def removeRows(self, row: int, count: int, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> bool: ...
    def rowCount(self, /, parent: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex= ...) -> int: ...
    def setHeaderData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, value: typing.Any, /, role: int = ...) -> bool: ...
    def setItemData(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, roles: typing.Dict[int, typing.Any], /) -> bool: ...
    def setSourceModel(self, newSourceModel: PySide6.QtCore.QAbstractItemModel, /) -> None: ...
    def sort(self, column: int, /, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def span(self, index: PySide6.QtCore.QModelIndex | PySide6.QtCore.QPersistentModelIndex, /) -> PySide6.QtCore.QSize: ...


class QUrl(Shiboken.Object):

    class AceProcessingOption(enum.Flag):

        IgnoreIDNWhitelist        = 0x1
        AceTransitionalProcessing = 0x2

    class ComponentFormattingOption(enum.IntFlag):

        PrettyDecoded             = 0x0
        EncodeSpaces              = 0x100000
        EncodeUnicode             = 0x200000
        EncodeDelimiters          = 0xc00000
        EncodeReserved            = 0x1000000
        FullyEncoded              = 0x1f00000
        DecodeReserved            = 0x2000000
        FullyDecoded              = 0x7f00000

    class ParsingMode(enum.Enum):

        TolerantMode              = 0x0
        StrictMode                = 0x1
        DecodedMode               = 0x2

    class UrlFormattingOption(enum.IntFlag):

        None_                     = 0x0
        RemoveScheme              = 0x1
        RemovePassword            = 0x2
        RemoveUserInfo            = 0x6
        RemovePort                = 0x8
        RemoveAuthority           = 0x1e
        RemovePath                = 0x20
        RemoveQuery               = 0x40
        RemoveFragment            = 0x80
        PreferLocalFile           = 0x200
        StripTrailingSlash        = 0x400
        RemoveFilename            = 0x800
        NormalizePathSegments     = 0x1000

    class UserInputResolutionOption(enum.Flag):

        DefaultResolution         = 0x0
        AssumeLocalFile           = 0x1


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, copy: PySide6.QtCore.QUrl, /) -> None: ...
    @typing.overload
    def __init__(self, url: str, /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QUrl | str, /) -> bool: ...
    def __ge__(self, rhs: PySide6.QtCore.QUrl | str, /) -> bool: ...
    def __gt__(self, rhs: PySide6.QtCore.QUrl | str, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __le__(self, rhs: PySide6.QtCore.QUrl | str, /) -> bool: ...
    def __lt__(self, rhs: PySide6.QtCore.QUrl | str, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QUrl | str, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    def adjusted(self, options: PySide6.QtCore.QUrl.ComponentFormattingOption, /) -> PySide6.QtCore.QUrl: ...
    def authority(self, /, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def clear(self, /) -> None: ...
    def errorString(self, /) -> str: ...
    def fileName(self, /, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def fragment(self, /, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    @staticmethod
    def fromAce(domain: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, options: PySide6.QtCore.QUrl.AceProcessingOption = ...) -> str: ...
    @staticmethod
    def fromEncoded(input: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> PySide6.QtCore.QUrl: ...
    @staticmethod
    def fromLocalFile(localfile: str | bytes | os.PathLike[str], /) -> PySide6.QtCore.QUrl: ...
    @staticmethod
    def fromPercentEncoding(arg__1: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> str: ...
    @staticmethod
    def fromStringList(uris: collections.abc.Sequence[str], /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> typing.List[PySide6.QtCore.QUrl]: ...
    @staticmethod
    def fromUserInput(userInput: str, /, workingDirectory: str = ..., options: PySide6.QtCore.QUrl.UserInputResolutionOption = ...) -> PySide6.QtCore.QUrl: ...
    def hasFragment(self, /) -> bool: ...
    def hasQuery(self, /) -> bool: ...
    def host(self, /, arg__1: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    @staticmethod
    def idnWhitelist() -> typing.List[str]: ...
    def isEmpty(self, /) -> bool: ...
    def isLocalFile(self, /) -> bool: ...
    def isParentOf(self, url: PySide6.QtCore.QUrl | str, /) -> bool: ...
    def isRelative(self, /) -> bool: ...
    def isValid(self, /) -> bool: ...
    def matches(self, url: PySide6.QtCore.QUrl | str, options: PySide6.QtCore.QUrl.ComponentFormattingOption, /) -> bool: ...
    def password(self, /, arg__1: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def path(self, /, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def port(self, /, defaultPort: int = ...) -> int: ...
    def query(self, /, arg__1: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def resolved(self, relative: PySide6.QtCore.QUrl | str, /) -> PySide6.QtCore.QUrl: ...
    def scheme(self, /) -> str: ...
    def setAuthority(self, authority: str, /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...
    def setFragment(self, fragment: str, /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...
    def setHost(self, host: str, /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...
    @staticmethod
    def setIdnWhitelist(arg__1: collections.abc.Sequence[str], /) -> None: ...
    def setPassword(self, password: str, /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...
    def setPath(self, path: str, /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...
    def setPort(self, port: int, /) -> None: ...
    @typing.overload
    def setQuery(self, query: PySide6.QtCore.QUrlQuery, /) -> None: ...
    @typing.overload
    def setQuery(self, query: str, /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...
    def setScheme(self, scheme: str, /) -> None: ...
    def setUrl(self, url: str, /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...
    def setUserInfo(self, userInfo: str, /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...
    def setUserName(self, userName: str, /, mode: PySide6.QtCore.QUrl.ParsingMode = ...) -> None: ...
    def swap(self, other: PySide6.QtCore.QUrl | str, /) -> None: ...
    @staticmethod
    def toAce(domain: str, /, options: PySide6.QtCore.QUrl.AceProcessingOption = ...) -> PySide6.QtCore.QByteArray: ...
    def toDisplayString(self, /, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def toEncoded(self, /, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> PySide6.QtCore.QByteArray: ...
    def toLocalFile(self, /) -> str: ...
    @staticmethod
    def toPercentEncoding(arg__1: str, /, exclude: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ..., include: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview= ...) -> PySide6.QtCore.QByteArray: ...
    def toString(self, /, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    @staticmethod
    def toStringList(uris: collections.abc.Sequence[PySide6.QtCore.QUrl], /, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> typing.List[str]: ...
    def url(self, /, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def userInfo(self, /, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def userName(self, /, options: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...


class QUrlQuery(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, other: PySide6.QtCore.QUrlQuery, /) -> None: ...
    @typing.overload
    def __init__(self, queryString: str, /) -> None: ...
    @typing.overload
    def __init__(self, url: PySide6.QtCore.QUrl | str, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QUrlQuery, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __ne__(self, rhs: PySide6.QtCore.QUrlQuery, /) -> bool: ...
    def addQueryItem(self, key: str, value: str, /) -> None: ...
    def allQueryItemValues(self, key: str, /, encoding: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> typing.List[str]: ...
    def clear(self, /) -> None: ...
    def hasQueryItem(self, key: str, /) -> bool: ...
    def isEmpty(self, /) -> bool: ...
    def query(self, /, encoding: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def queryItemValue(self, key: str, /, encoding: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...
    def queryItems(self, /, encoding: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> typing.List[typing.Tuple[str, str]]: ...
    def queryPairDelimiter(self, /) -> str: ...
    def queryValueDelimiter(self, /) -> str: ...
    def removeAllQueryItems(self, key: str, /) -> None: ...
    def removeQueryItem(self, key: str, /) -> None: ...
    def setQuery(self, queryString: str, /) -> None: ...
    def setQueryDelimiters(self, valueDelimiter: str, pairDelimiter: str, /) -> None: ...
    def setQueryItems(self, query: collections.abc.Sequence[typing.Tuple[str, str]], /) -> None: ...
    def swap(self, other: PySide6.QtCore.QUrlQuery, /) -> None: ...
    def toString(self, /, encoding: PySide6.QtCore.QUrl.ComponentFormattingOption = ...) -> str: ...


class QUuid(Shiboken.Object):

    class StringFormat(enum.Enum):

        WithBraces                = 0x0
        WithoutBraces             = 0x1
        Id128                     = 0x3

    class Variant(enum.Enum):

        VarUnknown                = -1
        NCS                       = 0x0
        DCE                       = 0x2
        Microsoft                 = 0x6
        Reserved                  = 0x7

    class Version(enum.Enum):

        VerUnknown                = -1
        Time                      = 0x1
        EmbeddedPOSIX             = 0x2
        Md5                       = 0x3
        Name                      = 0x3
        Random                    = 0x4
        Sha1                      = 0x5
        UnixEpoch                 = 0x7


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QUuid: PySide6.QtCore.QUuid, /) -> None: ...
    @typing.overload
    def __init__(self, string: str, /) -> None: ...
    @typing.overload
    def __init__(self, l: int, w1: int, w2: int, b1: int, b2: int, b3: int, b4: int, b5: int, b6: int, b7: int, b8: int, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QUuid, /) -> bool: ...
    def __ge__(self, rhs: PySide6.QtCore.QUuid, /) -> bool: ...
    def __gt__(self, rhs: PySide6.QtCore.QUuid, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __le__(self, rhs: PySide6.QtCore.QUuid, /) -> bool: ...
    def __lt__(self, rhs: PySide6.QtCore.QUuid, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QUuid, /) -> bool: ...
    def __reduce__(self, /) -> str: ...
    def __repr__(self, /) -> str: ...
    @staticmethod
    def createUuid() -> PySide6.QtCore.QUuid: ...
    @staticmethod
    def createUuidV3(ns: PySide6.QtCore.QUuid, baseData: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QUuid: ...
    @staticmethod
    def createUuidV5(ns: PySide6.QtCore.QUuid, baseData: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QUuid: ...
    @staticmethod
    def createUuidV7() -> PySide6.QtCore.QUuid: ...
    @staticmethod
    def fromBytes(bytes: int, /, order: PySide6.QtCore.QSysInfo.Endian = ...) -> PySide6.QtCore.QUuid: ...
    @staticmethod
    def fromRfc4122(arg__1: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QUuid: ...
    @staticmethod
    def fromString(string: str, /) -> PySide6.QtCore.QUuid: ...
    def isNull(self, /) -> bool: ...
    def toByteArray(self, /, mode: PySide6.QtCore.QUuid.StringFormat = ...) -> PySide6.QtCore.QByteArray: ...
    def toRfc4122(self, /) -> PySide6.QtCore.QByteArray: ...
    def toString(self, /, mode: PySide6.QtCore.QUuid.StringFormat = ...) -> str: ...
    def variant(self, /) -> PySide6.QtCore.QUuid.Variant: ...
    def version(self, /) -> PySide6.QtCore.QUuid.Version: ...


class QVariantAnimation(PySide6.QtCore.QAbstractAnimation):

    valueChanged             : typing.ClassVar[Signal] = ... # valueChanged(QVariant)

    def __init__(self, /, parent: PySide6.QtCore.QObject | None = ..., *, startValue: typing.Any | None = ..., endValue: typing.Any | None = ..., currentValue: typing.Any | None = ..., duration: int | None = ..., easingCurve: PySide6.QtCore.QEasingCurve | None = ...) -> None: ...

    def currentValue(self, /) -> typing.Any: ...
    def duration(self, /) -> int: ...
    def easingCurve(self, /) -> PySide6.QtCore.QEasingCurve: ...
    def endValue(self, /) -> typing.Any: ...
    def event(self, event: PySide6.QtCore.QEvent, /) -> bool: ...
    def interpolated(self, from_: typing.Any, to: typing.Any, progress: float, /) -> typing.Any: ...
    def keyValueAt(self, step: float, /) -> typing.Any: ...
    def keyValues(self, /) -> typing.List[typing.Tuple[float, typing.Any]]: ...
    def setDuration(self, msecs: int, /) -> None: ...
    def setEasingCurve(self, easing: PySide6.QtCore.QEasingCurve | PySide6.QtCore.QEasingCurve.Type, /) -> None: ...
    def setEndValue(self, value: typing.Any, /) -> None: ...
    def setKeyValueAt(self, step: float, value: typing.Any, /) -> None: ...
    def setKeyValues(self, values: collections.abc.Sequence[typing.Tuple[float, typing.Any]], /) -> None: ...
    def setStartValue(self, value: typing.Any, /) -> None: ...
    def startValue(self, /) -> typing.Any: ...
    def updateCurrentTime(self, arg__1: int, /) -> None: ...
    def updateCurrentValue(self, value: typing.Any, /) -> None: ...
    def updateState(self, newState: PySide6.QtCore.QAbstractAnimation.State, oldState: PySide6.QtCore.QAbstractAnimation.State, /) -> None: ...


class QVersionNumber(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QVersionNumber: PySide6.QtCore.QVersionNumber, /) -> None: ...
    @typing.overload
    def __init__(self, maj: int, /) -> None: ...
    @typing.overload
    def __init__(self, maj: int, min: int, /) -> None: ...
    @typing.overload
    def __init__(self, maj: int, min: int, mic: int, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QVersionNumber, /) -> bool: ...
    def __ge__(self, rhs: PySide6.QtCore.QVersionNumber, /) -> bool: ...
    def __gt__(self, rhs: PySide6.QtCore.QVersionNumber, /) -> bool: ...
    def __hash__(self, /) -> int: ...
    def __le__(self, rhs: PySide6.QtCore.QVersionNumber, /) -> bool: ...
    def __lt__(self, rhs: PySide6.QtCore.QVersionNumber, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QVersionNumber, /) -> bool: ...
    def __repr__(self, /) -> str: ...
    @staticmethod
    def commonPrefix(v1: PySide6.QtCore.QVersionNumber, v2: PySide6.QtCore.QVersionNumber, /) -> PySide6.QtCore.QVersionNumber: ...
    @staticmethod
    def compare(v1: PySide6.QtCore.QVersionNumber, v2: PySide6.QtCore.QVersionNumber, /) -> int: ...
    @staticmethod
    def fromString(string: str, /) -> PySide6.QtCore.QVersionNumber: ...
    def isNormalized(self, /) -> bool: ...
    def isNull(self, /) -> bool: ...
    def isPrefixOf(self, other: PySide6.QtCore.QVersionNumber, /) -> bool: ...
    def majorVersion(self, /) -> int: ...
    def microVersion(self, /) -> int: ...
    def minorVersion(self, /) -> int: ...
    def normalized(self, /) -> PySide6.QtCore.QVersionNumber: ...
    def segmentAt(self, index: int, /) -> int: ...
    def segmentCount(self, /) -> int: ...
    def segments(self, /) -> typing.List[int]: ...
    def toString(self, /) -> str: ...


class QWaitCondition(Shiboken.Object):

    def __init__(self, /) -> None: ...

    def notify_all(self, /) -> None: ...
    def notify_one(self, /) -> None: ...
    @typing.overload
    def wait(self, lockedMutex: PySide6.QtCore.QMutex, time: int, /) -> bool: ...
    @typing.overload
    def wait(self, lockedMutex: PySide6.QtCore.QMutex, /, deadline: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int= ...) -> bool: ...
    @typing.overload
    def wait(self, lockedReadWriteLock: PySide6.QtCore.QReadWriteLock, time: int, /) -> bool: ...
    @typing.overload
    def wait(self, lockedReadWriteLock: PySide6.QtCore.QReadWriteLock, /, deadline: PySide6.QtCore.QDeadlineTimer | PySide6.QtCore.QDeadlineTimer.ForeverConstant | int= ...) -> bool: ...
    def wakeAll(self, /) -> None: ...
    def wakeOne(self, /) -> None: ...


class QWriteLocker(Shiboken.Object):

    def __init__(self, readWriteLock: PySide6.QtCore.QReadWriteLock, /) -> None: ...

    def __enter__(self, /) -> PySide6.QtCore.QWriteLocker: ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object, /) -> None: ...
    def readWriteLock(self, /) -> PySide6.QtCore.QReadWriteLock: ...
    def relock(self, /) -> None: ...
    def unlock(self, /) -> None: ...


class QXmlStreamAttribute(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QXmlStreamAttribute: PySide6.QtCore.QXmlStreamAttribute, /) -> None: ...
    @typing.overload
    def __init__(self, qualifiedName: str, value: str, /) -> None: ...
    @typing.overload
    def __init__(self, namespaceUri: str, name: str, value: str, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QXmlStreamAttribute, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QXmlStreamAttribute, /) -> bool: ...
    def isDefault(self, /) -> bool: ...
    def name(self, /) -> str: ...
    def namespaceUri(self, /) -> str: ...
    def prefix(self, /) -> str: ...
    def qualifiedName(self, /) -> str: ...
    def value(self, /) -> str: ...


class QXmlStreamAttributes(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QXmlStreamAttributes: PySide6.QtCore.QXmlStreamAttributes, /) -> None: ...

    def __add__(self, l: collections.abc.Sequence[PySide6.QtCore.QXmlStreamAttribute], /) -> typing.List[PySide6.QtCore.QXmlStreamAttribute]: ...
    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, arg__1: PySide6.QtCore.QXmlStreamAttributes, /) -> bool: ...
    def __lshift__(self, l: collections.abc.Sequence[PySide6.QtCore.QXmlStreamAttribute], /) -> typing.List[PySide6.QtCore.QXmlStreamAttribute]: ...
    def __ne__(self, arg__1: PySide6.QtCore.QXmlStreamAttributes, /) -> bool: ...
    @typing.overload
    def append(self, arg__1: PySide6.QtCore.QXmlStreamAttribute, /) -> None: ...
    @typing.overload
    def append(self, qualifiedName: str, value: str, /) -> None: ...
    @typing.overload
    def append(self, namespaceUri: str, name: str, value: str, /) -> None: ...
    @typing.overload
    def append(self, l: collections.abc.Sequence[PySide6.QtCore.QXmlStreamAttribute], /) -> None: ...
    def at(self, i: int, /) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def back(self, /) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def capacity(self, /) -> int: ...
    def clear(self, /) -> None: ...
    def constData(self, /) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def constFirst(self, /) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def constLast(self, /) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def count(self, /) -> int: ...
    def data(self, /) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def empty(self, /) -> bool: ...
    @typing.overload
    def first(self, /) -> PySide6.QtCore.QXmlStreamAttribute: ...
    @typing.overload
    def first(self, n: int, /) -> typing.List[PySide6.QtCore.QXmlStreamAttribute]: ...
    @staticmethod
    def fromVector(vector: collections.abc.Sequence[PySide6.QtCore.QXmlStreamAttribute], /) -> typing.List[PySide6.QtCore.QXmlStreamAttribute]: ...
    def front(self, /) -> PySide6.QtCore.QXmlStreamAttribute: ...
    @typing.overload
    def hasAttribute(self, qualifiedName: str, /) -> bool: ...
    @typing.overload
    def hasAttribute(self, namespaceUri: str, name: str, /) -> bool: ...
    def insert(self, arg__1: int, arg__2: PySide6.QtCore.QXmlStreamAttribute, /) -> None: ...
    def isEmpty(self, /) -> bool: ...
    def isSharedWith(self, other: collections.abc.Sequence[PySide6.QtCore.QXmlStreamAttribute], /) -> bool: ...
    @typing.overload
    def last(self, /) -> PySide6.QtCore.QXmlStreamAttribute: ...
    @typing.overload
    def last(self, n: int, /) -> typing.List[PySide6.QtCore.QXmlStreamAttribute]: ...
    def length(self, /) -> int: ...
    @staticmethod
    def maxSize() -> int: ...
    def max_size(self, /) -> int: ...
    def mid(self, pos: int, /, len: int = ...) -> typing.List[PySide6.QtCore.QXmlStreamAttribute]: ...
    def move(self, from_: int, to: int, /) -> None: ...
    def prepend(self, arg__1: PySide6.QtCore.QXmlStreamAttribute, /) -> None: ...
    def push_back(self, arg__1: PySide6.QtCore.QXmlStreamAttribute, /) -> None: ...
    def push_front(self, arg__1: PySide6.QtCore.QXmlStreamAttribute, /) -> None: ...
    def remove(self, i: int, /, n: int = ...) -> None: ...
    def removeAll(self, arg__1: PySide6.QtCore.QXmlStreamAttribute, /) -> None: ...
    def removeAt(self, i: int, /) -> None: ...
    def removeFirst(self, /) -> None: ...
    def removeLast(self, /) -> None: ...
    def removeOne(self, arg__1: PySide6.QtCore.QXmlStreamAttribute, /) -> None: ...
    def reserve(self, size: int, /) -> None: ...
    def resize(self, size: int, /) -> None: ...
    def resizeForOverwrite(self, size: int, /) -> None: ...
    def shrink_to_fit(self, /) -> None: ...
    def size(self, /) -> int: ...
    @typing.overload
    def sliced(self, pos: int, /) -> typing.List[PySide6.QtCore.QXmlStreamAttribute]: ...
    @typing.overload
    def sliced(self, pos: int, n: int, /) -> typing.List[PySide6.QtCore.QXmlStreamAttribute]: ...
    def squeeze(self, /) -> None: ...
    def swap(self, other: collections.abc.Sequence[PySide6.QtCore.QXmlStreamAttribute], /) -> None: ...
    def swapItemsAt(self, i: int, j: int, /) -> None: ...
    def takeAt(self, i: int, /) -> PySide6.QtCore.QXmlStreamAttribute: ...
    def toVector(self, /) -> typing.List[PySide6.QtCore.QXmlStreamAttribute]: ...
    @typing.overload
    def value(self, qualifiedName: str, /) -> str: ...
    @typing.overload
    def value(self, namespaceUri: str, name: str, /) -> str: ...


class QXmlStreamEntityDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QXmlStreamEntityDeclaration: PySide6.QtCore.QXmlStreamEntityDeclaration, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QXmlStreamEntityDeclaration, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QXmlStreamEntityDeclaration, /) -> bool: ...
    def name(self, /) -> str: ...
    def notationName(self, /) -> str: ...
    def publicId(self, /) -> str: ...
    def systemId(self, /) -> str: ...
    def value(self, /) -> str: ...


class QXmlStreamEntityResolver(Shiboken.Object):

    def __init__(self, /) -> None: ...

    def resolveEntity(self, publicId: str, systemId: str, /) -> str: ...
    def resolveUndeclaredEntity(self, name: str, /) -> str: ...


class QXmlStreamNamespaceDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QXmlStreamNamespaceDeclaration: PySide6.QtCore.QXmlStreamNamespaceDeclaration, /) -> None: ...
    @typing.overload
    def __init__(self, prefix: str, namespaceUri: str, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QXmlStreamNamespaceDeclaration, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QXmlStreamNamespaceDeclaration, /) -> bool: ...
    def namespaceUri(self, /) -> str: ...
    def prefix(self, /) -> str: ...


class QXmlStreamNotationDeclaration(Shiboken.Object):

    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, QXmlStreamNotationDeclaration: PySide6.QtCore.QXmlStreamNotationDeclaration, /) -> None: ...

    def __copy__(self, /) -> typing.Self: ...
    def __eq__(self, rhs: PySide6.QtCore.QXmlStreamNotationDeclaration, /) -> bool: ...
    def __ne__(self, rhs: PySide6.QtCore.QXmlStreamNotationDeclaration, /) -> bool: ...
    def name(self, /) -> str: ...
    def publicId(self, /) -> str: ...
    def systemId(self, /) -> str: ...


class QXmlStreamReader(Shiboken.Object):

    class Error(enum.Enum):

        NoError                   = 0x0
        UnexpectedElementError    = 0x1
        CustomError               = 0x2
        NotWellFormedError        = 0x3
        PrematureEndOfDocumentError = 0x4

    class ReadElementTextBehaviour(enum.Enum):

        ErrorOnUnexpectedElement  = 0x0
        IncludeChildElements      = 0x1
        SkipChildElements         = 0x2

    class TokenType(enum.Enum):

        NoToken                   = 0x0
        Invalid                   = 0x1
        StartDocument             = 0x2
        EndDocument               = 0x3
        StartElement              = 0x4
        EndElement                = 0x5
        Characters                = 0x6
        Comment                   = 0x7
        DTD                       = 0x8
        EntityReference           = 0x9
        ProcessingInstruction     = 0xa


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, device: PySide6.QtCore.QIODevice, /) -> None: ...
    @typing.overload
    def __init__(self, data: str, /) -> None: ...

    def addData(self, data: str, /) -> None: ...
    def addExtraNamespaceDeclaration(self, extraNamespaceDeclaraction: PySide6.QtCore.QXmlStreamNamespaceDeclaration, /) -> None: ...
    def addExtraNamespaceDeclarations(self, extraNamespaceDeclaractions: collections.abc.Sequence[PySide6.QtCore.QXmlStreamNamespaceDeclaration], /) -> None: ...
    def atEnd(self, /) -> bool: ...
    def attributes(self, /) -> PySide6.QtCore.QXmlStreamAttributes: ...
    def characterOffset(self, /) -> int: ...
    def clear(self, /) -> None: ...
    def columnNumber(self, /) -> int: ...
    def device(self, /) -> PySide6.QtCore.QIODevice: ...
    def documentEncoding(self, /) -> str: ...
    def documentVersion(self, /) -> str: ...
    def dtdName(self, /) -> str: ...
    def dtdPublicId(self, /) -> str: ...
    def dtdSystemId(self, /) -> str: ...
    def entityDeclarations(self, /) -> typing.List[PySide6.QtCore.QXmlStreamEntityDeclaration]: ...
    def entityExpansionLimit(self, /) -> int: ...
    def entityResolver(self, /) -> PySide6.QtCore.QXmlStreamEntityResolver: ...
    def error(self, /) -> PySide6.QtCore.QXmlStreamReader.Error: ...
    def errorString(self, /) -> str: ...
    def hasError(self, /) -> bool: ...
    def hasStandaloneDeclaration(self, /) -> bool: ...
    def isCDATA(self, /) -> bool: ...
    def isCharacters(self, /) -> bool: ...
    def isComment(self, /) -> bool: ...
    def isDTD(self, /) -> bool: ...
    def isEndDocument(self, /) -> bool: ...
    def isEndElement(self, /) -> bool: ...
    def isEntityReference(self, /) -> bool: ...
    def isProcessingInstruction(self, /) -> bool: ...
    def isStandaloneDocument(self, /) -> bool: ...
    def isStartDocument(self, /) -> bool: ...
    def isStartElement(self, /) -> bool: ...
    def isWhitespace(self, /) -> bool: ...
    def lineNumber(self, /) -> int: ...
    def name(self, /) -> str: ...
    def namespaceDeclarations(self, /) -> typing.List[PySide6.QtCore.QXmlStreamNamespaceDeclaration]: ...
    def namespaceProcessing(self, /) -> bool: ...
    def namespaceUri(self, /) -> str: ...
    def notationDeclarations(self, /) -> typing.List[PySide6.QtCore.QXmlStreamNotationDeclaration]: ...
    def prefix(self, /) -> str: ...
    def processingInstructionData(self, /) -> str: ...
    def processingInstructionTarget(self, /) -> str: ...
    def qualifiedName(self, /) -> str: ...
    def raiseError(self, /, message: str = ...) -> None: ...
    def readElementText(self, /, behaviour: PySide6.QtCore.QXmlStreamReader.ReadElementTextBehaviour = ...) -> str: ...
    def readNext(self, /) -> PySide6.QtCore.QXmlStreamReader.TokenType: ...
    def readNextStartElement(self, /) -> bool: ...
    def readRawInnerData(self, /) -> str: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice, /) -> None: ...
    def setEntityExpansionLimit(self, limit: int, /) -> None: ...
    def setEntityResolver(self, resolver: PySide6.QtCore.QXmlStreamEntityResolver, /) -> None: ...
    def setNamespaceProcessing(self, arg__1: bool, /) -> None: ...
    def skipCurrentElement(self, /) -> None: ...
    def text(self, /) -> str: ...
    def tokenString(self, /) -> str: ...
    def tokenType(self, /) -> PySide6.QtCore.QXmlStreamReader.TokenType: ...


class QXmlStreamWriter(Shiboken.Object):

    class Error(enum.Enum):

        None_                     = 0x0
        IO                        = 0x1
        Encoding                  = 0x2
        InvalidCharacter          = 0x3
        Custom                    = 0x4


    @typing.overload
    def __init__(self, /) -> None: ...
    @typing.overload
    def __init__(self, device: PySide6.QtCore.QIODevice, /) -> None: ...
    @typing.overload
    def __init__(self, array: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> None: ...

    def autoFormatting(self, /) -> bool: ...
    def autoFormattingIndent(self, /) -> int: ...
    def device(self, /) -> PySide6.QtCore.QIODevice: ...
    def error(self, /) -> PySide6.QtCore.QXmlStreamWriter.Error: ...
    def errorString(self, /) -> str: ...
    def hasError(self, /) -> bool: ...
    def raiseError(self, message: str, /) -> None: ...
    def setAutoFormatting(self, arg__1: bool, /) -> None: ...
    def setAutoFormattingIndent(self, spacesOrTabs: int, /) -> None: ...
    def setDevice(self, device: PySide6.QtCore.QIODevice, /) -> None: ...
    def setStopWritingOnError(self, stop: bool, /) -> None: ...
    def stopWritingOnError(self, /) -> bool: ...
    @typing.overload
    def writeAttribute(self, attribute: PySide6.QtCore.QXmlStreamAttribute, /) -> None: ...
    @typing.overload
    def writeAttribute(self, qualifiedName: str, value: str, /) -> None: ...
    @typing.overload
    def writeAttribute(self, namespaceUri: str, name: str, value: str, /) -> None: ...
    def writeAttributes(self, attributes: PySide6.QtCore.QXmlStreamAttributes, /) -> None: ...
    def writeCDATA(self, text: str, /) -> None: ...
    def writeCharacters(self, text: str, /) -> None: ...
    def writeComment(self, text: str, /) -> None: ...
    def writeCurrentToken(self, reader: PySide6.QtCore.QXmlStreamReader, /) -> None: ...
    def writeDTD(self, dtd: str, /) -> None: ...
    def writeDefaultNamespace(self, namespaceUri: str, /) -> None: ...
    @typing.overload
    def writeEmptyElement(self, qualifiedName: str, /) -> None: ...
    @typing.overload
    def writeEmptyElement(self, namespaceUri: str, name: str, /) -> None: ...
    def writeEndDocument(self, /) -> None: ...
    def writeEndElement(self, /) -> None: ...
    def writeEntityReference(self, name: str, /) -> None: ...
    def writeNamespace(self, namespaceUri: str, /, prefix: str = ...) -> None: ...
    def writeProcessingInstruction(self, target: str, /, data: str = ...) -> None: ...
    @typing.overload
    def writeStartDocument(self, /) -> None: ...
    @typing.overload
    def writeStartDocument(self, version: str, /) -> None: ...
    @typing.overload
    def writeStartDocument(self, version: str, standalone: bool, /) -> None: ...
    @typing.overload
    def writeStartElement(self, qualifiedName: str, /) -> None: ...
    @typing.overload
    def writeStartElement(self, namespaceUri: str, name: str, /) -> None: ...
    @typing.overload
    def writeTextElement(self, qualifiedName: str, text: str, /) -> None: ...
    @typing.overload
    def writeTextElement(self, namespaceUri: str, name: str, text: str, /) -> None: ...


class Qt(Shiboken.Object):

    class AlignmentFlag(enum.IntFlag):

        AlignLeading              = 0x1
        AlignLeft                 = 0x1
        AlignRight                = 0x2
        AlignTrailing             = 0x2
        AlignHCenter              = 0x4
        AlignJustify              = 0x8
        AlignAbsolute             = 0x10
        AlignHorizontal_Mask      = 0x1f
        AlignTop                  = 0x20
        AlignBottom               = 0x40
        AlignVCenter              = 0x80
        AlignCenter               = 0x84
        AlignBaseline             = 0x100
        AlignVertical_Mask        = 0x1e0

    class AnchorPoint(enum.Enum):

        AnchorLeft                = 0x0
        AnchorHorizontalCenter    = 0x1
        AnchorRight               = 0x2
        AnchorTop                 = 0x3
        AnchorVerticalCenter      = 0x4
        AnchorBottom              = 0x5

    class ApplicationAttribute(enum.Enum):

        AA_QtQuickUseDefaultSizePolicy = 0x1
        AA_DontShowIconsInMenus   = 0x2
        AA_NativeWindows          = 0x3
        AA_DontCreateNativeWidgetSiblings = 0x4
        AA_PluginApplication      = 0x5
        AA_DontUseNativeMenuBar   = 0x6
        AA_MacDontSwapCtrlAndMeta = 0x7
        AA_Use96Dpi               = 0x8
        AA_DisableNativeVirtualKeyboard = 0x9
        AA_DontUseNativeMenuWindows = 0xa
        AA_SynthesizeTouchForUnhandledMouseEvents = 0xb
        AA_SynthesizeMouseForUnhandledTouchEvents = 0xc
        AA_UseHighDpiPixmaps      = 0xd
        AA_ForceRasterWidgets     = 0xe
        AA_UseDesktopOpenGL       = 0xf
        AA_UseOpenGLES            = 0x10
        AA_UseSoftwareOpenGL      = 0x11
        AA_ShareOpenGLContexts    = 0x12
        AA_SetPalette             = 0x13
        AA_EnableHighDpiScaling   = 0x14
        AA_DisableHighDpiScaling  = 0x15
        AA_UseStyleSheetPropagationInWidgetStyles = 0x16
        AA_DontUseNativeDialogs   = 0x17
        AA_SynthesizeMouseForUnhandledTabletEvents = 0x18
        AA_CompressHighFrequencyEvents = 0x19
        AA_DontCheckOpenGLContextThreadAffinity = 0x1a
        AA_DisableShaderDiskCache = 0x1b
        AA_DontShowShortcutsInContextMenus = 0x1c
        AA_CompressTabletEvents   = 0x1d
        AA_DisableSessionManager  = 0x1f
        AA_AttributeCount         = 0x20

    class ApplicationState(enum.Flag):

        ApplicationSuspended      = 0x0
        ApplicationHidden         = 0x1
        ApplicationInactive       = 0x2
        ApplicationActive         = 0x4

    class ArrowType(enum.Enum):

        NoArrow                   = 0x0
        UpArrow                   = 0x1
        DownArrow                 = 0x2
        LeftArrow                 = 0x3
        RightArrow                = 0x4

    class AspectRatioMode(enum.Enum):

        IgnoreAspectRatio         = 0x0
        KeepAspectRatio           = 0x1
        KeepAspectRatioByExpanding = 0x2

    class Axis(enum.Enum):

        XAxis                     = 0x0
        YAxis                     = 0x1
        ZAxis                     = 0x2

    class BGMode(enum.Enum):

        TransparentMode           = 0x0
        OpaqueMode                = 0x1

    class BrushStyle(enum.Enum):

        NoBrush                   = 0x0
        SolidPattern              = 0x1
        Dense1Pattern             = 0x2
        Dense2Pattern             = 0x3
        Dense3Pattern             = 0x4
        Dense4Pattern             = 0x5
        Dense5Pattern             = 0x6
        Dense6Pattern             = 0x7
        Dense7Pattern             = 0x8
        HorPattern                = 0x9
        VerPattern                = 0xa
        CrossPattern              = 0xb
        BDiagPattern              = 0xc
        FDiagPattern              = 0xd
        DiagCrossPattern          = 0xe
        LinearGradientPattern     = 0xf
        RadialGradientPattern     = 0x10
        ConicalGradientPattern    = 0x11
        TexturePattern            = 0x18

    class CaseSensitivity(enum.Enum):

        CaseInsensitive           = 0x0
        CaseSensitive             = 0x1

    class CheckState(enum.Enum):

        Unchecked                 = 0x0
        PartiallyChecked          = 0x1
        Checked                   = 0x2

    class ChecksumType(enum.Enum):

        ChecksumIso3309           = 0x0
        ChecksumItuV41            = 0x1

    class ClipOperation(enum.Enum):

        NoClip                    = 0x0
        ReplaceClip               = 0x1
        IntersectClip             = 0x2

    class ColorScheme(enum.Enum):

        Unknown                   = 0x0
        Light                     = 0x1
        Dark                      = 0x2

    class ConnectionType(enum.Enum):

        AutoConnection            = 0x0
        DirectConnection          = 0x1
        QueuedConnection          = 0x2
        BlockingQueuedConnection  = 0x3
        UniqueConnection          = 0x80
        SingleShotConnection      = 0x100

    class ContextMenuPolicy(enum.Enum):

        NoContextMenu             = 0x0
        DefaultContextMenu        = 0x1
        ActionsContextMenu        = 0x2
        CustomContextMenu         = 0x3
        PreventContextMenu        = 0x4

    class ContextMenuTrigger(enum.Enum):

        Press                     = 0x0
        Release                   = 0x1

    class ContrastPreference(enum.Enum):

        NoPreference              = 0x0
        HighContrast              = 0x1

    class CoordinateSystem(enum.Enum):

        DeviceCoordinates         = 0x0
        LogicalCoordinates        = 0x1

    class Corner(enum.Enum):

        TopLeftCorner             = 0x0
        TopRightCorner            = 0x1
        BottomLeftCorner          = 0x2
        BottomRightCorner         = 0x3

    class CursorMoveStyle(enum.Enum):

        LogicalMoveStyle          = 0x0
        VisualMoveStyle           = 0x1

    class CursorShape(enum.Enum):

        ArrowCursor               = 0x0
        UpArrowCursor             = 0x1
        CrossCursor               = 0x2
        WaitCursor                = 0x3
        IBeamCursor               = 0x4
        SizeVerCursor             = 0x5
        SizeHorCursor             = 0x6
        SizeBDiagCursor           = 0x7
        SizeFDiagCursor           = 0x8
        SizeAllCursor             = 0x9
        BlankCursor               = 0xa
        SplitVCursor              = 0xb
        SplitHCursor              = 0xc
        PointingHandCursor        = 0xd
        ForbiddenCursor           = 0xe
        WhatsThisCursor           = 0xf
        BusyCursor                = 0x10
        OpenHandCursor            = 0x11
        ClosedHandCursor          = 0x12
        DragCopyCursor            = 0x13
        DragMoveCursor            = 0x14
        DragLinkCursor            = 0x15
        LastCursor                = 0x15
        BitmapCursor              = 0x18
        CustomCursor              = 0x19

    class DateFormat(enum.Enum):

        TextDate                  = 0x0
        ISODate                   = 0x1
        RFC2822Date               = 0x8
        ISODateWithMs             = 0x9

    class DayOfWeek(enum.Enum):

        Monday                    = 0x1
        Tuesday                   = 0x2
        Wednesday                 = 0x3
        Thursday                  = 0x4
        Friday                    = 0x5
        Saturday                  = 0x6
        Sunday                    = 0x7

    class DockWidgetArea(enum.Flag):

        NoDockWidgetArea          = 0x0
        LeftDockWidgetArea        = 0x1
        RightDockWidgetArea       = 0x2
        TopDockWidgetArea         = 0x4
        BottomDockWidgetArea      = 0x8
        AllDockWidgetAreas        = 0xf
        DockWidgetArea_Mask       = 0xf

    class DockWidgetAreaSizes(enum.Enum):

        NDockWidgetAreas          = 0x4

    class DropAction(enum.Flag):

        IgnoreAction              = 0x0
        CopyAction                = 0x1
        MoveAction                = 0x2
        LinkAction                = 0x4
        ActionMask                = 0xff
        TargetMoveAction          = 0x8002

    class Edge(enum.Flag):

        TopEdge                   = 0x1
        LeftEdge                  = 0x2
        RightEdge                 = 0x4
        BottomEdge                = 0x8

    class EnterKeyType(enum.Enum):

        EnterKeyDefault           = 0x0
        EnterKeyReturn            = 0x1
        EnterKeyDone              = 0x2
        EnterKeyGo                = 0x3
        EnterKeySend              = 0x4
        EnterKeySearch            = 0x5
        EnterKeyNext              = 0x6
        EnterKeyPrevious          = 0x7

    class EventPriority(enum.Enum):

        LowEventPriority          = -1
        NormalEventPriority       = 0x0
        HighEventPriority         = 0x1

    class FillRule(enum.Enum):

        OddEvenFill               = 0x0
        WindingFill               = 0x1

    class FindChildOption(enum.Flag):

        FindDirectChildrenOnly    = 0x0
        FindChildrenRecursively   = 0x1

    class FocusPolicy(enum.IntFlag):

        NoFocus                   = 0x0
        TabFocus                  = 0x1
        ClickFocus                = 0x2
        StrongFocus               = 0xb
        WheelFocus                = 0xf

    class FocusReason(enum.Enum):

        MouseFocusReason          = 0x0
        TabFocusReason            = 0x1
        BacktabFocusReason        = 0x2
        ActiveWindowFocusReason   = 0x3
        PopupFocusReason          = 0x4
        ShortcutFocusReason       = 0x5
        MenuBarFocusReason        = 0x6
        OtherFocusReason          = 0x7
        NoFocusReason             = 0x8

    class GestureFlag(enum.Flag):

        DontStartGestureOnChildren = 0x1
        ReceivePartialGestures    = 0x2
        IgnoredGesturesPropagateToParent = 0x4

    class GestureState(enum.Enum):

        NoGesture                 = 0x0
        GestureStarted            = 0x1
        GestureUpdated            = 0x2
        GestureFinished           = 0x3
        GestureCanceled           = 0x4

    class GestureType(enum.IntEnum):

        TapGesture                = 0x1
        TapAndHoldGesture         = 0x2
        PanGesture                = 0x3
        PinchGesture              = 0x4
        SwipeGesture              = 0x5
        CustomGesture             = 0x100
        LastGestureType           = 0xffffffff

    class GlobalColor(enum.Enum):

        color0                    = 0x0
        color1                    = 0x1
        black                     = 0x2
        white                     = 0x3
        darkGray                  = 0x4
        gray                      = 0x5
        lightGray                 = 0x6
        red                       = 0x7
        green                     = 0x8
        blue                      = 0x9
        cyan                      = 0xa
        magenta                   = 0xb
        yellow                    = 0xc
        darkRed                   = 0xd
        darkGreen                 = 0xe
        darkBlue                  = 0xf
        darkCyan                  = 0x10
        darkMagenta               = 0x11
        darkYellow                = 0x12
        transparent               = 0x13

    class HighDpiScaleFactorRoundingPolicy(enum.Enum):

        Unset                     = 0x0
        Round                     = 0x1
        Ceil                      = 0x2
        Floor                     = 0x3
        RoundPreferFloor          = 0x4
        PassThrough               = 0x5

    class HitTestAccuracy(enum.Enum):

        ExactHit                  = 0x0
        FuzzyHit                  = 0x1

    class ImageConversionFlag(enum.Flag):

        AutoColor                 = 0x0
        AutoDither                = 0x0
        DiffuseDither             = 0x0
        ThresholdAlphaDither      = 0x0
        MonoOnly                  = 0x2
        ColorMode_Mask            = 0x3
        ColorOnly                 = 0x3
        OrderedAlphaDither        = 0x4
        DiffuseAlphaDither        = 0x8
        AlphaDither_Mask          = 0xc
        NoAlpha                   = 0xc
        OrderedDither             = 0x10
        ThresholdDither           = 0x20
        Dither_Mask               = 0x30
        PreferDither              = 0x40
        AvoidDither               = 0x80
        DitherMode_Mask           = 0xc0
        NoOpaqueDetection         = 0x100
        NoFormatConversion        = 0x200

    class InputMethodHint(enum.Flag):

        ImhNone                   = 0x0
        ImhHiddenText             = 0x1
        ImhSensitiveData          = 0x2
        ImhNoAutoUppercase        = 0x4
        ImhPreferNumbers          = 0x8
        ImhPreferUppercase        = 0x10
        ImhPreferLowercase        = 0x20
        ImhNoPredictiveText       = 0x40
        ImhDate                   = 0x80
        ImhTime                   = 0x100
        ImhPreferLatin            = 0x200
        ImhMultiLine              = 0x400
        ImhNoEditMenu             = 0x800
        ImhNoTextHandles          = 0x1000
        ImhDigitsOnly             = 0x10000
        ImhFormattedNumbersOnly   = 0x20000
        ImhUppercaseOnly          = 0x40000
        ImhLowercaseOnly          = 0x80000
        ImhDialableCharactersOnly = 0x100000
        ImhEmailCharactersOnly    = 0x200000
        ImhUrlCharactersOnly      = 0x400000
        ImhLatinOnly              = 0x800000
        ImhExclusiveInputMask     = 0xffff0000

    class InputMethodQuery(enum.Flag):

        ImEnabled                 = 0x1
        ImCursorRectangle         = 0x2
        ImFont                    = 0x4
        ImCursorPosition          = 0x8
        ImSurroundingText         = 0x10
        ImCurrentSelection        = 0x20
        ImMaximumTextLength       = 0x40
        ImAnchorPosition          = 0x80
        ImHints                   = 0x100
        ImPreferredLanguage       = 0x200
        ImAbsolutePosition        = 0x400
        ImTextBeforeCursor        = 0x800
        ImTextAfterCursor         = 0x1000
        ImEnterKeyType            = 0x2000
        ImAnchorRectangle         = 0x4000
        ImQueryInput              = 0x40ba
        ImInputItemClipRectangle  = 0x8000
        ImReadOnly                = 0x10000
        ImPlatformData            = 0x80000000
        ImQueryAll                = 0xffffffff

    class ItemDataRole(enum.IntEnum):

        DisplayRole               = 0x0
        DecorationRole            = 0x1
        EditRole                  = 0x2
        ToolTipRole               = 0x3
        StatusTipRole             = 0x4
        WhatsThisRole             = 0x5
        FontRole                  = 0x6
        TextAlignmentRole         = 0x7
        BackgroundRole            = 0x8
        ForegroundRole            = 0x9
        CheckStateRole            = 0xa
        AccessibleTextRole        = 0xb
        AccessibleDescriptionRole = 0xc
        SizeHintRole              = 0xd
        InitialSortOrderRole      = 0xe
        DisplayPropertyRole       = 0x1b
        DecorationPropertyRole    = 0x1c
        ToolTipPropertyRole       = 0x1d
        StatusTipPropertyRole     = 0x1e
        WhatsThisPropertyRole     = 0x1f
        RangeModelDataRole        = 0x28
        FileInfoRole              = 0xfc
        RemoteObjectsCacheRole    = 0xff
        StandardItemFlagsRole     = 0xff
        UserRole                  = 0x100

    class ItemFlag(enum.Flag):

        NoItemFlags               = 0x0
        ItemIsSelectable          = 0x1
        ItemIsEditable            = 0x2
        ItemIsDragEnabled         = 0x4
        ItemIsDropEnabled         = 0x8
        ItemIsUserCheckable       = 0x10
        ItemIsEnabled             = 0x20
        ItemIsAutoTristate        = 0x40
        ItemNeverHasChildren      = 0x80
        ItemIsUserTristate        = 0x100

    class ItemSelectionMode(enum.Enum):

        ContainsItemShape         = 0x0
        IntersectsItemShape       = 0x1
        ContainsItemBoundingRect  = 0x2
        IntersectsItemBoundingRect = 0x3

    class ItemSelectionOperation(enum.Enum):

        ReplaceSelection          = 0x0
        AddToSelection            = 0x1

    class Key(enum.IntEnum):

        Key_Any                   = 0x20
        Key_Space                 = 0x20
        Key_Exclam                = 0x21
        Key_QuoteDbl              = 0x22
        Key_NumberSign            = 0x23
        Key_Dollar                = 0x24
        Key_Percent               = 0x25
        Key_Ampersand             = 0x26
        Key_Apostrophe            = 0x27
        Key_ParenLeft             = 0x28
        Key_ParenRight            = 0x29
        Key_Asterisk              = 0x2a
        Key_Plus                  = 0x2b
        Key_Comma                 = 0x2c
        Key_Minus                 = 0x2d
        Key_Period                = 0x2e
        Key_Slash                 = 0x2f
        Key_0                     = 0x30
        Key_1                     = 0x31
        Key_2                     = 0x32
        Key_3                     = 0x33
        Key_4                     = 0x34
        Key_5                     = 0x35
        Key_6                     = 0x36
        Key_7                     = 0x37
        Key_8                     = 0x38
        Key_9                     = 0x39
        Key_Colon                 = 0x3a
        Key_Semicolon             = 0x3b
        Key_Less                  = 0x3c
        Key_Equal                 = 0x3d
        Key_Greater               = 0x3e
        Key_Question              = 0x3f
        Key_At                    = 0x40
        Key_A                     = 0x41
        Key_B                     = 0x42
        Key_C                     = 0x43
        Key_D                     = 0x44
        Key_E                     = 0x45
        Key_F                     = 0x46
        Key_G                     = 0x47
        Key_H                     = 0x48
        Key_I                     = 0x49
        Key_J                     = 0x4a
        Key_K                     = 0x4b
        Key_L                     = 0x4c
        Key_M                     = 0x4d
        Key_N                     = 0x4e
        Key_O                     = 0x4f
        Key_P                     = 0x50
        Key_Q                     = 0x51
        Key_R                     = 0x52
        Key_S                     = 0x53
        Key_T                     = 0x54
        Key_U                     = 0x55
        Key_V                     = 0x56
        Key_W                     = 0x57
        Key_X                     = 0x58
        Key_Y                     = 0x59
        Key_Z                     = 0x5a
        Key_BracketLeft           = 0x5b
        Key_Backslash             = 0x5c
        Key_BracketRight          = 0x5d
        Key_AsciiCircum           = 0x5e
        Key_Underscore            = 0x5f
        Key_QuoteLeft             = 0x60
        Key_BraceLeft             = 0x7b
        Key_Bar                   = 0x7c
        Key_BraceRight            = 0x7d
        Key_AsciiTilde            = 0x7e
        Key_nobreakspace          = 0xa0
        Key_exclamdown            = 0xa1
        Key_cent                  = 0xa2
        Key_sterling              = 0xa3
        Key_currency              = 0xa4
        Key_yen                   = 0xa5
        Key_brokenbar             = 0xa6
        Key_section               = 0xa7
        Key_diaeresis             = 0xa8
        Key_copyright             = 0xa9
        Key_ordfeminine           = 0xaa
        Key_guillemotleft         = 0xab
        Key_notsign               = 0xac
        Key_hyphen                = 0xad
        Key_registered            = 0xae
        Key_macron                = 0xaf
        Key_degree                = 0xb0
        Key_plusminus             = 0xb1
        Key_twosuperior           = 0xb2
        Key_threesuperior         = 0xb3
        Key_acute                 = 0xb4
        Key_micro                 = 0xb5
        Key_mu                    = 0xb5
        Key_paragraph             = 0xb6
        Key_periodcentered        = 0xb7
        Key_cedilla               = 0xb8
        Key_onesuperior           = 0xb9
        Key_masculine             = 0xba
        Key_guillemotright        = 0xbb
        Key_onequarter            = 0xbc
        Key_onehalf               = 0xbd
        Key_threequarters         = 0xbe
        Key_questiondown          = 0xbf
        Key_Agrave                = 0xc0
        Key_Aacute                = 0xc1
        Key_Acircumflex           = 0xc2
        Key_Atilde                = 0xc3
        Key_Adiaeresis            = 0xc4
        Key_Aring                 = 0xc5
        Key_AE                    = 0xc6
        Key_Ccedilla              = 0xc7
        Key_Egrave                = 0xc8
        Key_Eacute                = 0xc9
        Key_Ecircumflex           = 0xca
        Key_Ediaeresis            = 0xcb
        Key_Igrave                = 0xcc
        Key_Iacute                = 0xcd
        Key_Icircumflex           = 0xce
        Key_Idiaeresis            = 0xcf
        Key_ETH                   = 0xd0
        Key_Ntilde                = 0xd1
        Key_Ograve                = 0xd2
        Key_Oacute                = 0xd3
        Key_Ocircumflex           = 0xd4
        Key_Otilde                = 0xd5
        Key_Odiaeresis            = 0xd6
        Key_multiply              = 0xd7
        Key_Ooblique              = 0xd8
        Key_Ugrave                = 0xd9
        Key_Uacute                = 0xda
        Key_Ucircumflex           = 0xdb
        Key_Udiaeresis            = 0xdc
        Key_Yacute                = 0xdd
        Key_THORN                 = 0xde
        Key_ssharp                = 0xdf
        Key_division              = 0xf7
        Key_ydiaeresis            = 0xff
        Key_Escape                = 0x1000000
        Key_Tab                   = 0x1000001
        Key_Backtab               = 0x1000002
        Key_Backspace             = 0x1000003
        Key_Return                = 0x1000004
        Key_Enter                 = 0x1000005
        Key_Insert                = 0x1000006
        Key_Delete                = 0x1000007
        Key_Pause                 = 0x1000008
        Key_Print                 = 0x1000009
        Key_SysReq                = 0x100000a
        Key_Clear                 = 0x100000b
        Key_Home                  = 0x1000010
        Key_End                   = 0x1000011
        Key_Left                  = 0x1000012
        Key_Up                    = 0x1000013
        Key_Right                 = 0x1000014
        Key_Down                  = 0x1000015
        Key_PageUp                = 0x1000016
        Key_PageDown              = 0x1000017
        Key_Shift                 = 0x1000020
        Key_Control               = 0x1000021
        Key_Meta                  = 0x1000022
        Key_Alt                   = 0x1000023
        Key_CapsLock              = 0x1000024
        Key_NumLock               = 0x1000025
        Key_ScrollLock            = 0x1000026
        Key_F1                    = 0x1000030
        Key_F2                    = 0x1000031
        Key_F3                    = 0x1000032
        Key_F4                    = 0x1000033
        Key_F5                    = 0x1000034
        Key_F6                    = 0x1000035
        Key_F7                    = 0x1000036
        Key_F8                    = 0x1000037
        Key_F9                    = 0x1000038
        Key_F10                   = 0x1000039
        Key_F11                   = 0x100003a
        Key_F12                   = 0x100003b
        Key_F13                   = 0x100003c
        Key_F14                   = 0x100003d
        Key_F15                   = 0x100003e
        Key_F16                   = 0x100003f
        Key_F17                   = 0x1000040
        Key_F18                   = 0x1000041
        Key_F19                   = 0x1000042
        Key_F20                   = 0x1000043
        Key_F21                   = 0x1000044
        Key_F22                   = 0x1000045
        Key_F23                   = 0x1000046
        Key_F24                   = 0x1000047
        Key_F25                   = 0x1000048
        Key_F26                   = 0x1000049
        Key_F27                   = 0x100004a
        Key_F28                   = 0x100004b
        Key_F29                   = 0x100004c
        Key_F30                   = 0x100004d
        Key_F31                   = 0x100004e
        Key_F32                   = 0x100004f
        Key_F33                   = 0x1000050
        Key_F34                   = 0x1000051
        Key_F35                   = 0x1000052
        Key_Super_L               = 0x1000053
        Key_Super_R               = 0x1000054
        Key_Menu                  = 0x1000055
        Key_Hyper_L               = 0x1000056
        Key_Hyper_R               = 0x1000057
        Key_Help                  = 0x1000058
        Key_Direction_L           = 0x1000059
        Key_Direction_R           = 0x1000060
        Key_Back                  = 0x1000061
        Key_Forward               = 0x1000062
        Key_Stop                  = 0x1000063
        Key_Refresh               = 0x1000064
        Key_VolumeDown            = 0x1000070
        Key_VolumeMute            = 0x1000071
        Key_VolumeUp              = 0x1000072
        Key_BassBoost             = 0x1000073
        Key_BassUp                = 0x1000074
        Key_BassDown              = 0x1000075
        Key_TrebleUp              = 0x1000076
        Key_TrebleDown            = 0x1000077
        Key_MediaPlay             = 0x1000080
        Key_MediaStop             = 0x1000081
        Key_MediaPrevious         = 0x1000082
        Key_MediaNext             = 0x1000083
        Key_MediaRecord           = 0x1000084
        Key_MediaPause            = 0x1000085
        Key_MediaTogglePlayPause  = 0x1000086
        Key_HomePage              = 0x1000090
        Key_Favorites             = 0x1000091
        Key_Search                = 0x1000092
        Key_Standby               = 0x1000093
        Key_OpenUrl               = 0x1000094
        Key_LaunchMail            = 0x10000a0
        Key_LaunchMedia           = 0x10000a1
        Key_Launch0               = 0x10000a2
        Key_Launch1               = 0x10000a3
        Key_Launch2               = 0x10000a4
        Key_Launch3               = 0x10000a5
        Key_Launch4               = 0x10000a6
        Key_Launch5               = 0x10000a7
        Key_Launch6               = 0x10000a8
        Key_Launch7               = 0x10000a9
        Key_Launch8               = 0x10000aa
        Key_Launch9               = 0x10000ab
        Key_LaunchA               = 0x10000ac
        Key_LaunchB               = 0x10000ad
        Key_LaunchC               = 0x10000ae
        Key_LaunchD               = 0x10000af
        Key_LaunchE               = 0x10000b0
        Key_LaunchF               = 0x10000b1
        Key_MonBrightnessUp       = 0x10000b2
        Key_MonBrightnessDown     = 0x10000b3
        Key_KeyboardLightOnOff    = 0x10000b4
        Key_KeyboardBrightnessUp  = 0x10000b5
        Key_KeyboardBrightnessDown = 0x10000b6
        Key_PowerOff              = 0x10000b7
        Key_WakeUp                = 0x10000b8
        Key_Eject                 = 0x10000b9
        Key_ScreenSaver           = 0x10000ba
        Key_WWW                   = 0x10000bb
        Key_Memo                  = 0x10000bc
        Key_LightBulb             = 0x10000bd
        Key_Shop                  = 0x10000be
        Key_History               = 0x10000bf
        Key_AddFavorite           = 0x10000c0
        Key_HotLinks              = 0x10000c1
        Key_BrightnessAdjust      = 0x10000c2
        Key_Finance               = 0x10000c3
        Key_Community             = 0x10000c4
        Key_AudioRewind           = 0x10000c5
        Key_BackForward           = 0x10000c6
        Key_ApplicationLeft       = 0x10000c7
        Key_ApplicationRight      = 0x10000c8
        Key_Book                  = 0x10000c9
        Key_CD                    = 0x10000ca
        Key_Calculator            = 0x10000cb
        Key_ToDoList              = 0x10000cc
        Key_ClearGrab             = 0x10000cd
        Key_Close                 = 0x10000ce
        Key_Copy                  = 0x10000cf
        Key_Cut                   = 0x10000d0
        Key_Display               = 0x10000d1
        Key_DOS                   = 0x10000d2
        Key_Documents             = 0x10000d3
        Key_Excel                 = 0x10000d4
        Key_Explorer              = 0x10000d5
        Key_Game                  = 0x10000d6
        Key_Go                    = 0x10000d7
        Key_iTouch                = 0x10000d8
        Key_LogOff                = 0x10000d9
        Key_Market                = 0x10000da
        Key_Meeting               = 0x10000db
        Key_MenuKB                = 0x10000dc
        Key_MenuPB                = 0x10000dd
        Key_MySites               = 0x10000de
        Key_News                  = 0x10000df
        Key_OfficeHome            = 0x10000e0
        Key_Option                = 0x10000e1
        Key_Paste                 = 0x10000e2
        Key_Phone                 = 0x10000e3
        Key_Calendar              = 0x10000e4
        Key_Reply                 = 0x10000e5
        Key_Reload                = 0x10000e6
        Key_RotateWindows         = 0x10000e7
        Key_RotationPB            = 0x10000e8
        Key_RotationKB            = 0x10000e9
        Key_Save                  = 0x10000ea
        Key_Send                  = 0x10000eb
        Key_Spell                 = 0x10000ec
        Key_SplitScreen           = 0x10000ed
        Key_Support               = 0x10000ee
        Key_TaskPane              = 0x10000ef
        Key_Terminal              = 0x10000f0
        Key_Tools                 = 0x10000f1
        Key_Travel                = 0x10000f2
        Key_Video                 = 0x10000f3
        Key_Word                  = 0x10000f4
        Key_Xfer                  = 0x10000f5
        Key_ZoomIn                = 0x10000f6
        Key_ZoomOut               = 0x10000f7
        Key_Away                  = 0x10000f8
        Key_Messenger             = 0x10000f9
        Key_WebCam                = 0x10000fa
        Key_MailForward           = 0x10000fb
        Key_Pictures              = 0x10000fc
        Key_Music                 = 0x10000fd
        Key_Battery               = 0x10000fe
        Key_Bluetooth             = 0x10000ff
        Key_WLAN                  = 0x1000100
        Key_UWB                   = 0x1000101
        Key_AudioForward          = 0x1000102
        Key_AudioRepeat           = 0x1000103
        Key_AudioRandomPlay       = 0x1000104
        Key_Subtitle              = 0x1000105
        Key_AudioCycleTrack       = 0x1000106
        Key_Time                  = 0x1000107
        Key_Hibernate             = 0x1000108
        Key_View                  = 0x1000109
        Key_TopMenu               = 0x100010a
        Key_PowerDown             = 0x100010b
        Key_Suspend               = 0x100010c
        Key_ContrastAdjust        = 0x100010d
        Key_LaunchG               = 0x100010e
        Key_LaunchH               = 0x100010f
        Key_TouchpadToggle        = 0x1000110
        Key_TouchpadOn            = 0x1000111
        Key_TouchpadOff           = 0x1000112
        Key_MicMute               = 0x1000113
        Key_Red                   = 0x1000114
        Key_Green                 = 0x1000115
        Key_Yellow                = 0x1000116
        Key_Blue                  = 0x1000117
        Key_ChannelUp             = 0x1000118
        Key_ChannelDown           = 0x1000119
        Key_Guide                 = 0x100011a
        Key_Info                  = 0x100011b
        Key_Settings              = 0x100011c
        Key_MicVolumeUp           = 0x100011d
        Key_MicVolumeDown         = 0x100011e
        Key_Keyboard              = 0x100011f
        Key_New                   = 0x1000120
        Key_Open                  = 0x1000121
        Key_Find                  = 0x1000122
        Key_Undo                  = 0x1000123
        Key_Redo                  = 0x1000124
        Key_AltGr                 = 0x1001103
        Key_Multi_key             = 0x1001120
        Key_Kanji                 = 0x1001121
        Key_Muhenkan              = 0x1001122
        Key_Henkan                = 0x1001123
        Key_Romaji                = 0x1001124
        Key_Hiragana              = 0x1001125
        Key_Katakana              = 0x1001126
        Key_Hiragana_Katakana     = 0x1001127
        Key_Zenkaku               = 0x1001128
        Key_Hankaku               = 0x1001129
        Key_Zenkaku_Hankaku       = 0x100112a
        Key_Touroku               = 0x100112b
        Key_Massyo                = 0x100112c
        Key_Kana_Lock             = 0x100112d
        Key_Kana_Shift            = 0x100112e
        Key_Eisu_Shift            = 0x100112f
        Key_Eisu_toggle           = 0x1001130
        Key_Hangul                = 0x1001131
        Key_Hangul_Start          = 0x1001132
        Key_Hangul_End            = 0x1001133
        Key_Hangul_Hanja          = 0x1001134
        Key_Hangul_Jamo           = 0x1001135
        Key_Hangul_Romaja         = 0x1001136
        Key_Codeinput             = 0x1001137
        Key_Hangul_Jeonja         = 0x1001138
        Key_Hangul_Banja          = 0x1001139
        Key_Hangul_PreHanja       = 0x100113a
        Key_Hangul_PostHanja      = 0x100113b
        Key_SingleCandidate       = 0x100113c
        Key_MultipleCandidate     = 0x100113d
        Key_PreviousCandidate     = 0x100113e
        Key_Hangul_Special        = 0x100113f
        Key_Mode_switch           = 0x100117e
        Key_Dead_Grave            = 0x1001250
        Key_Dead_Acute            = 0x1001251
        Key_Dead_Circumflex       = 0x1001252
        Key_Dead_Tilde            = 0x1001253
        Key_Dead_Macron           = 0x1001254
        Key_Dead_Breve            = 0x1001255
        Key_Dead_Abovedot         = 0x1001256
        Key_Dead_Diaeresis        = 0x1001257
        Key_Dead_Abovering        = 0x1001258
        Key_Dead_Doubleacute      = 0x1001259
        Key_Dead_Caron            = 0x100125a
        Key_Dead_Cedilla          = 0x100125b
        Key_Dead_Ogonek           = 0x100125c
        Key_Dead_Iota             = 0x100125d
        Key_Dead_Voiced_Sound     = 0x100125e
        Key_Dead_Semivoiced_Sound = 0x100125f
        Key_Dead_Belowdot         = 0x1001260
        Key_Dead_Hook             = 0x1001261
        Key_Dead_Horn             = 0x1001262
        Key_Dead_Stroke           = 0x1001263
        Key_Dead_Abovecomma       = 0x1001264
        Key_Dead_Abovereversedcomma = 0x1001265
        Key_Dead_Doublegrave      = 0x1001266
        Key_Dead_Belowring        = 0x1001267
        Key_Dead_Belowmacron      = 0x1001268
        Key_Dead_Belowcircumflex  = 0x1001269
        Key_Dead_Belowtilde       = 0x100126a
        Key_Dead_Belowbreve       = 0x100126b
        Key_Dead_Belowdiaeresis   = 0x100126c
        Key_Dead_Invertedbreve    = 0x100126d
        Key_Dead_Belowcomma       = 0x100126e
        Key_Dead_Currency         = 0x100126f
        Key_Dead_a                = 0x1001280
        Key_Dead_A                = 0x1001281
        Key_Dead_e                = 0x1001282
        Key_Dead_E                = 0x1001283
        Key_Dead_i                = 0x1001284
        Key_Dead_I                = 0x1001285
        Key_Dead_o                = 0x1001286
        Key_Dead_O                = 0x1001287
        Key_Dead_u                = 0x1001288
        Key_Dead_U                = 0x1001289
        Key_Dead_Small_Schwa      = 0x100128a
        Key_Dead_Capital_Schwa    = 0x100128b
        Key_Dead_Greek            = 0x100128c
        Key_Dead_Lowline          = 0x1001290
        Key_Dead_Aboveverticalline = 0x1001291
        Key_Dead_Belowverticalline = 0x1001292
        Key_Dead_Longsolidusoverlay = 0x1001293
        Key_MediaLast             = 0x100ffff
        Key_Select                = 0x1010000
        Key_Yes                   = 0x1010001
        Key_No                    = 0x1010002
        Key_Cancel                = 0x1020001
        Key_Printer               = 0x1020002
        Key_Execute               = 0x1020003
        Key_Sleep                 = 0x1020004
        Key_Play                  = 0x1020005
        Key_Zoom                  = 0x1020006
        Key_Exit                  = 0x102000a
        Key_Context1              = 0x1100000
        Key_Context2              = 0x1100001
        Key_Context3              = 0x1100002
        Key_Context4              = 0x1100003
        Key_Call                  = 0x1100004
        Key_Hangup                = 0x1100005
        Key_Flip                  = 0x1100006
        Key_ToggleCallHangup      = 0x1100007
        Key_VoiceDial             = 0x1100008
        Key_LastNumberRedial      = 0x1100009
        Key_Camera                = 0x1100020
        Key_CameraFocus           = 0x1100021
        Key_unknown               = 0x1ffffff

    class KeyboardModifier(enum.Flag):

        NoModifier                = 0x0
        ShiftModifier             = 0x2000000
        ControlModifier           = 0x4000000
        AltModifier               = 0x8000000
        MetaModifier              = 0x10000000
        KeypadModifier            = 0x20000000
        GroupSwitchModifier       = 0x40000000
        KeyboardModifierMask      = 0xfe000000

    class LayoutDirection(enum.Enum):

        LeftToRight               = 0x0
        RightToLeft               = 0x1
        LayoutDirectionAuto       = 0x2

    class MaskMode(enum.Enum):

        MaskInColor               = 0x0
        MaskOutColor              = 0x1

    class MatchFlag(enum.Flag):

        MatchExactly              = 0x0
        MatchContains             = 0x1
        MatchStartsWith           = 0x2
        MatchEndsWith             = 0x3
        MatchRegularExpression    = 0x4
        MatchWildcard             = 0x5
        MatchFixedString          = 0x8
        MatchTypeMask             = 0xf
        MatchCaseSensitive        = 0x10
        MatchWrap                 = 0x20
        MatchRecursive            = 0x40

    class Modifier(enum.Flag):

        SHIFT                     = 0x2000000
        CTRL                      = 0x4000000
        ALT                       = 0x8000000
        META                      = 0x10000000
        MODIFIER_MASK             = 0xfe000000

    class MouseButton(enum.Flag):

        NoButton                  = 0x0
        LeftButton                = 0x1
        RightButton               = 0x2
        MiddleButton              = 0x4
        BackButton                = 0x8
        ExtraButton1              = 0x8
        XButton1                  = 0x8
        ExtraButton2              = 0x10
        ForwardButton             = 0x10
        XButton2                  = 0x10
        ExtraButton3              = 0x20
        TaskButton                = 0x20
        ExtraButton4              = 0x40
        ExtraButton5              = 0x80
        ExtraButton6              = 0x100
        ExtraButton7              = 0x200
        ExtraButton8              = 0x400
        ExtraButton9              = 0x800
        ExtraButton10             = 0x1000
        ExtraButton11             = 0x2000
        ExtraButton12             = 0x4000
        ExtraButton13             = 0x8000
        ExtraButton14             = 0x10000
        ExtraButton15             = 0x20000
        ExtraButton16             = 0x40000
        ExtraButton17             = 0x80000
        ExtraButton18             = 0x100000
        ExtraButton19             = 0x200000
        ExtraButton20             = 0x400000
        ExtraButton21             = 0x800000
        ExtraButton22             = 0x1000000
        ExtraButton23             = 0x2000000
        ExtraButton24             = 0x4000000
        MaxMouseButton            = 0x4000000
        AllButtons                = 0x7ffffff
        MouseButtonMask           = 0xffffffff

    class MouseEventFlag(enum.Flag):

        NoMouseEventFlag          = 0x0
        MouseEventCreatedDoubleClick = 0x1
        MouseEventFlagMask        = 0xff

    class MouseEventSource(enum.Enum):

        MouseEventNotSynthesized  = 0x0
        MouseEventSynthesizedBySystem = 0x1
        MouseEventSynthesizedByQt = 0x2
        MouseEventSynthesizedByApplication = 0x3

    class NativeGestureType(enum.Enum):

        BeginNativeGesture        = 0x0
        EndNativeGesture          = 0x1
        PanNativeGesture          = 0x2
        ZoomNativeGesture         = 0x3
        SmartZoomNativeGesture    = 0x4
        RotateNativeGesture       = 0x5
        SwipeNativeGesture        = 0x6

    class NavigationMode(enum.Enum):

        NavigationModeNone        = 0x0
        NavigationModeKeypadTabOrder = 0x1
        NavigationModeKeypadDirectional = 0x2
        NavigationModeCursorAuto  = 0x3
        NavigationModeCursorForceVisible = 0x4

    class Orientation(enum.Flag):

        Horizontal                = 0x1
        Vertical                  = 0x2

    class PenCapStyle(enum.Enum):

        FlatCap                   = 0x0
        SquareCap                 = 0x10
        RoundCap                  = 0x20
        MPenCapStyle              = 0x30

    class PenJoinStyle(enum.Enum):

        MiterJoin                 = 0x0
        BevelJoin                 = 0x40
        RoundJoin                 = 0x80
        SvgMiterJoin              = 0x100
        MPenJoinStyle             = 0x1c0

    class PenStyle(enum.Enum):

        NoPen                     = 0x0
        SolidLine                 = 0x1
        DashLine                  = 0x2
        DotLine                   = 0x3
        DashDotLine               = 0x4
        DashDotDotLine            = 0x5
        CustomDashLine            = 0x6
        MPenStyle                 = 0xf

    class PermissionStatus(enum.Enum):

        Undetermined              = 0x0
        Granted                   = 0x1
        Denied                    = 0x2

    class ReturnByValueConstant(enum.Enum):

        ReturnByValue             = 0x0

    class ScreenOrientation(enum.Flag):

        PrimaryOrientation        = 0x0
        PortraitOrientation       = 0x1
        LandscapeOrientation      = 0x2
        InvertedPortraitOrientation = 0x4
        InvertedLandscapeOrientation = 0x8

    class ScrollBarPolicy(enum.Enum):

        ScrollBarAsNeeded         = 0x0
        ScrollBarAlwaysOff        = 0x1
        ScrollBarAlwaysOn         = 0x2

    class ScrollPhase(enum.Enum):

        NoScrollPhase             = 0x0
        ScrollBegin               = 0x1
        ScrollUpdate              = 0x2
        ScrollEnd                 = 0x3
        ScrollMomentum            = 0x4

    class ShortcutContext(enum.Enum):

        WidgetShortcut            = 0x0
        WindowShortcut            = 0x1
        ApplicationShortcut       = 0x2
        WidgetWithChildrenShortcut = 0x3

    class SizeHint(enum.Enum):

        MinimumSize               = 0x0
        PreferredSize             = 0x1
        MaximumSize               = 0x2
        MinimumDescent            = 0x3
        NSizeHints                = 0x4

    class SizeMode(enum.Enum):

        AbsoluteSize              = 0x0
        RelativeSize              = 0x1

    class SortOrder(enum.Enum):

        AscendingOrder            = 0x0
        DescendingOrder           = 0x1

    class SplitBehaviorFlags(enum.Flag):

        KeepEmptyParts            = 0x0
        SkipEmptyParts            = 0x1

    class TabFocusBehavior(enum.Enum):

        NoTabFocus                = 0x0
        TabFocusTextControls      = 0x1
        TabFocusListControls      = 0x2
        TabFocusAllControls       = 0xff

    class TextElideMode(enum.Enum):

        ElideLeft                 = 0x0
        ElideRight                = 0x1
        ElideMiddle               = 0x2
        ElideNone                 = 0x3

    class TextFlag(enum.IntFlag):

        TextSingleLine            = 0x100
        TextDontClip              = 0x200
        TextExpandTabs            = 0x400
        TextShowMnemonic          = 0x800
        TextWordWrap              = 0x1000
        TextWrapAnywhere          = 0x2000
        TextDontPrint             = 0x4000
        TextHideMnemonic          = 0x8000
        TextJustificationForced   = 0x10000
        TextForceLeftToRight      = 0x20000
        TextForceRightToLeft      = 0x40000
        TextLongestVariant        = 0x80000
        TextIncludeTrailingSpaces = 0x8000000

    class TextFormat(enum.Enum):

        PlainText                 = 0x0
        RichText                  = 0x1
        AutoText                  = 0x2
        MarkdownText              = 0x3

    class TextInteractionFlag(enum.Flag):

        NoTextInteraction         = 0x0
        TextSelectableByMouse     = 0x1
        TextSelectableByKeyboard  = 0x2
        LinksAccessibleByMouse    = 0x4
        LinksAccessibleByKeyboard = 0x8
        TextBrowserInteraction    = 0xd
        TextEditable              = 0x10
        TextEditorInteraction     = 0x13

    class TileRule(enum.Enum):

        StretchTile               = 0x0
        RepeatTile                = 0x1
        RoundTile                 = 0x2

    class TimeSpec(enum.Enum):

        LocalTime                 = 0x0
        UTC                       = 0x1
        OffsetFromUTC             = 0x2
        TimeZone                  = 0x3

    class TimerId(enum.Enum):

        Invalid                   = 0x0

    class TimerType(enum.Enum):

        PreciseTimer              = 0x0
        CoarseTimer               = 0x1
        VeryCoarseTimer           = 0x2

    class ToolBarArea(enum.Flag):

        NoToolBarArea             = 0x0
        LeftToolBarArea           = 0x1
        RightToolBarArea          = 0x2
        TopToolBarArea            = 0x4
        BottomToolBarArea         = 0x8
        AllToolBarAreas           = 0xf
        ToolBarArea_Mask          = 0xf

    class ToolBarAreaSizes(enum.Enum):

        NToolBarAreas             = 0x4

    class ToolButtonStyle(enum.Enum):

        ToolButtonIconOnly        = 0x0
        ToolButtonTextOnly        = 0x1
        ToolButtonTextBesideIcon  = 0x2
        ToolButtonTextUnderIcon   = 0x3
        ToolButtonFollowStyle     = 0x4

    class TouchPointState(enum.Flag):

        TouchPointUnknownState    = 0x0
        TouchPointPressed         = 0x1
        TouchPointMoved           = 0x2
        TouchPointStationary      = 0x4
        TouchPointReleased        = 0x8

    class TransformationMode(enum.Enum):

        FastTransformation        = 0x0
        SmoothTransformation      = 0x1

    class UIEffect(enum.Enum):

        UI_General                = 0x0
        UI_AnimateMenu            = 0x1
        UI_FadeMenu               = 0x2
        UI_AnimateCombo           = 0x3
        UI_AnimateTooltip         = 0x4
        UI_FadeTooltip            = 0x5
        UI_AnimateToolBox         = 0x6

    class WhiteSpaceMode(enum.Enum):

        WhiteSpaceModeUndefined   = -1
        WhiteSpaceNormal          = 0x0
        WhiteSpacePre             = 0x1
        WhiteSpaceNoWrap          = 0x2

    class WidgetAttribute(enum.Enum):

        WA_Disabled               = 0x0
        WA_UnderMouse             = 0x1
        WA_MouseTracking          = 0x2
        WA_OpaquePaintEvent       = 0x4
        WA_StaticContents         = 0x5
        WA_LaidOut                = 0x7
        WA_PaintOnScreen          = 0x8
        WA_NoSystemBackground     = 0x9
        WA_UpdatesDisabled        = 0xa
        WA_Mapped                 = 0xb
        WA_InputMethodEnabled     = 0xe
        WA_WState_Visible         = 0xf
        WA_WState_Hidden          = 0x10
        WA_ForceDisabled          = 0x20
        WA_KeyCompression         = 0x21
        WA_PendingMoveEvent       = 0x22
        WA_PendingResizeEvent     = 0x23
        WA_SetPalette             = 0x24
        WA_SetFont                = 0x25
        WA_SetCursor              = 0x26
        WA_NoChildEventsFromChildren = 0x27
        WA_WindowModified         = 0x29
        WA_Resized                = 0x2a
        WA_Moved                  = 0x2b
        WA_PendingUpdate          = 0x2c
        WA_InvalidSize            = 0x2d
        WA_CustomWhatsThis        = 0x2f
        WA_LayoutOnEntireRect     = 0x30
        WA_OutsideWSRange         = 0x31
        WA_GrabbedShortcut        = 0x32
        WA_TransparentForMouseEvents = 0x33
        WA_PaintUnclipped         = 0x34
        WA_SetWindowIcon          = 0x35
        WA_NoMouseReplay          = 0x36
        WA_DeleteOnClose          = 0x37
        WA_RightToLeft            = 0x38
        WA_SetLayoutDirection     = 0x39
        WA_NoChildEventsForParent = 0x3a
        WA_ForceUpdatesDisabled   = 0x3b
        WA_WState_Created         = 0x3c
        WA_WState_CompressKeys    = 0x3d
        WA_WState_InPaintEvent    = 0x3e
        WA_WState_Reparented      = 0x3f
        WA_WState_ConfigPending   = 0x40
        WA_WState_Polished        = 0x42
        WA_WState_OwnSizePolicy   = 0x44
        WA_WState_ExplicitShowHide = 0x45
        WA_ShowModal              = 0x46
        WA_MouseNoMask            = 0x47
        WA_NoMousePropagation     = 0x49
        WA_Hover                  = 0x4a
        WA_InputMethodTransparent = 0x4b
        WA_QuitOnClose            = 0x4c
        WA_KeyboardFocusChange    = 0x4d
        WA_AcceptDrops            = 0x4e
        WA_DropSiteRegistered     = 0x4f
        WA_WindowPropagation      = 0x50
        WA_NoX11EventCompression  = 0x51
        WA_TintedBackground       = 0x52
        WA_X11OpenGLOverlay       = 0x53
        WA_AlwaysShowToolTips     = 0x54
        WA_MacOpaqueSizeGrip      = 0x55
        WA_SetStyle               = 0x56
        WA_SetLocale              = 0x57
        WA_MacShowFocusRect       = 0x58
        WA_MacNormalSize          = 0x59
        WA_MacSmallSize           = 0x5a
        WA_MacMiniSize            = 0x5b
        WA_LayoutUsesWidgetRect   = 0x5c
        WA_StyledBackground       = 0x5d
        WA_CanHostQMdiSubWindowTitleBar = 0x5f
        WA_MacAlwaysShowToolWindow = 0x60
        WA_StyleSheet             = 0x61
        WA_ShowWithoutActivating  = 0x62
        WA_X11BypassTransientForHint = 0x63
        WA_NativeWindow           = 0x64
        WA_DontCreateNativeAncestors = 0x65
        WA_DontShowOnScreen       = 0x67
        WA_X11NetWmWindowTypeDesktop = 0x68
        WA_X11NetWmWindowTypeDock = 0x69
        WA_X11NetWmWindowTypeToolBar = 0x6a
        WA_X11NetWmWindowTypeMenu = 0x6b
        WA_X11NetWmWindowTypeUtility = 0x6c
        WA_X11NetWmWindowTypeSplash = 0x6d
        WA_X11NetWmWindowTypeDialog = 0x6e
        WA_X11NetWmWindowTypeDropDownMenu = 0x6f
        WA_X11NetWmWindowTypePopupMenu = 0x70
        WA_X11NetWmWindowTypeToolTip = 0x71
        WA_X11NetWmWindowTypeNotification = 0x72
        WA_X11NetWmWindowTypeCombo = 0x73
        WA_X11NetWmWindowTypeDND  = 0x74
        WA_SetWindowModality      = 0x76
        WA_WState_WindowOpacitySet = 0x77
        WA_TranslucentBackground  = 0x78
        WA_AcceptTouchEvents      = 0x79
        WA_WState_AcceptedTouchBeginEvent = 0x7a
        WA_TouchPadAcceptSingleTouchEvents = 0x7b
        WA_X11DoNotAcceptFocus    = 0x7e
        WA_AlwaysStackOnTop       = 0x80
        WA_TabletTracking         = 0x81
        WA_ContentsMarginsRespectsSafeArea = 0x82
        WA_StyleSheetTarget       = 0x83
        WA_AttributeCount         = 0x84

    class WindowFrameSection(enum.Enum):

        NoSection                 = 0x0
        LeftSection               = 0x1
        TopLeftSection            = 0x2
        TopSection                = 0x3
        TopRightSection           = 0x4
        RightSection              = 0x5
        BottomRightSection        = 0x6
        BottomSection             = 0x7
        BottomLeftSection         = 0x8
        TitleBarArea              = 0x9

    class WindowModality(enum.Enum):

        NonModal                  = 0x0
        WindowModal               = 0x1
        ApplicationModal          = 0x2

    class WindowState(enum.Flag):

        WindowNoState             = 0x0
        WindowMinimized           = 0x1
        WindowMaximized           = 0x2
        WindowFullScreen          = 0x4
        WindowActive              = 0x8

    class WindowType(enum.IntFlag):

        Widget                    = 0x0
        Window                    = 0x1
        Dialog                    = 0x3
        Sheet                     = 0x5
        Drawer                    = 0x7
        Popup                     = 0x9
        Tool                      = 0xb
        ToolTip                   = 0xd
        SplashScreen              = 0xf
        Desktop                   = 0x11
        SubWindow                 = 0x12
        ForeignWindow             = 0x21
        CoverWindow               = 0x41
        WindowType_Mask           = 0xff
        MSWindowsFixedSizeDialogHint = 0x100
        MSWindowsOwnDC            = 0x200
        BypassWindowManagerHint   = 0x400
        X11BypassWindowManagerHint = 0x400
        FramelessWindowHint       = 0x800
        WindowTitleHint           = 0x1000
        WindowSystemMenuHint      = 0x2000
        WindowMinimizeButtonHint  = 0x4000
        WindowMaximizeButtonHint  = 0x8000
        WindowMinMaxButtonsHint   = 0xc000
        WindowContextHelpButtonHint = 0x10000
        WindowShadeButtonHint     = 0x20000
        WindowStaysOnTopHint      = 0x40000
        WindowTransparentForInput = 0x80000
        WindowOverridesSystemGestures = 0x100000
        WindowDoesNotAcceptFocus  = 0x200000
        ExpandedClientAreaHint    = 0x400000
        MaximizeUsingFullscreenGeometryHint = 0x400000
        NoTitleBarBackgroundHint  = 0x800000
        CustomizeWindowHint       = 0x2000000
        WindowStaysOnBottomHint   = 0x4000000
        WindowCloseButtonHint     = 0x8000000
        MacWindowToolBarButtonHint = 0x10000000
        BypassGraphicsProxyWidget = 0x20000000
        NoDropShadowWindowHint    = 0x40000000
        WindowFullscreenButtonHint = 0x80000000


    @staticmethod
    def beginPropertyUpdateGroup() -> None: ...
    @staticmethod
    def bin(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def bom(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def center(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def dec(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def endPropertyUpdateGroup() -> None: ...
    @staticmethod
    def endl(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def fixed(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def flush(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def forcepoint(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def forcesign(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def hex(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def left(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def lowercasebase(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def lowercasedigits(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def noforcepoint(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def noforcesign(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def noshowbase(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def oct(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def reset(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def right(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def scientific(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def showbase(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def uppercasebase(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def uppercasedigits(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...
    @staticmethod
    def ws(s: PySide6.QtCore.QTextStream, /) -> PySide6.QtCore.QTextStream: ...


class QtMsgType(enum.IntEnum):

    QtDebugMsg                = 0x0
    QtWarningMsg              = 0x1
    QtCriticalMsg             = 0x2
    QtSystemMsg               = 0x2
    QtFatalMsg                = 0x3
    QtInfoMsg                 = 0x4


class Signal:

    def __init__(self, /, *types: type, name: str | None = ..., arguments: typing.List[str] | None = ...) -> None: ...

    @typing.overload
    def __get__(self, instance: PySide6.QtCore.QObject, owner: typing.Any | None , /) -> PySide6.QtCore.SignalInstance: ...
    @typing.overload
    def __get__(self, instance: None, owner: typing.Any | None , /) -> PySide6.QtCore.Signal: ...


class SignalInstance:
    def __repr__(self, /) -> str: ...
    def connect(self, slot: object, /, type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtCore.QMetaObject.Connection: ...
    def disconnect(self, /, slot: object | None = ...) -> bool: ...
    def emit(self, /, *args: typing.Any) -> None: ...


class Slot:

    def __init__(self, /, *types: type, name: str | None = ..., result: type | None = ...) -> None: ...

    def __call__(self, function: collections.abc.Callable[..., typing.Any], /) -> typing.Any: ...


def QEnum(arg__1: object, /) -> object: ...
def QFlag(arg__1: object, /) -> object: ...
def QT_TRANSLATE_NOOP(context: object, message: object, /) -> object: ...
def QT_TRANSLATE_NOOP3(context: object, message: object, disambiguation: object, /) -> object: ...
def QT_TRANSLATE_NOOP_UTF8(message: object, /) -> object: ...
def QT_TR_NOOP(message: object, /) -> object: ...
def QT_TR_NOOP_UTF8(message: object, /) -> object: ...
def Q_ARG(type: object, value: object, /) -> PySide6.QtCore.QGenericArgumentHolder: ...
def Q_RETURN_ARG(type: object, /) -> PySide6.QtCore.QGenericReturnArgumentHolder: ...
def SIGNAL(signature: str, /) -> str: ...
def SLOT(signature: str, /) -> str: ...
def __init_feature__() -> None: ...
def __moduleShutdown() -> None: ...
def qAbs(arg__1: float, /) -> float: ...
def qAddPostRoutine(callable: object, /) -> None: ...
def qCCritical(logging_category: PySide6.QtCore.QLoggingCategory, message: bytes | bytearray | memoryview, /) -> None: ...
def qCDebug(logging_category: PySide6.QtCore.QLoggingCategory, message: bytes | bytearray | memoryview, /) -> None: ...
def qCInfo(logging_category: PySide6.QtCore.QLoggingCategory, message: bytes | bytearray | memoryview, /) -> None: ...
def qCWarning(logging_category: PySide6.QtCore.QLoggingCategory, message: bytes | bytearray | memoryview, /) -> None: ...
@typing.overload
def qCompress(data: bytes | bytearray | memoryview, nbytes: int, /, compressionLevel: int = ...) -> PySide6.QtCore.QByteArray: ...
@typing.overload
def qCompress(data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /, compressionLevel: int = ...) -> PySide6.QtCore.QByteArray: ...
def qCritical(message: str, /) -> None: ...
def qDebug(message: str, /) -> None: ...
def qFastCos(x: float, /) -> float: ...
def qFastSin(x: float, /) -> float: ...
def qFatal(message: str, /) -> None: ...
def qFormatLogMessage(type: PySide6.QtCore.QtMsgType, context: PySide6.QtCore.QMessageLogContext, buf: str, /) -> str: ...
def qFuzzyCompare(p1: float, p2: float, /) -> bool: ...
def qFuzzyIsNull(d: float, /) -> bool: ...
def qInfo(message: str, /) -> None: ...
def qInstallMessageHandler(callable: object, /) -> object: ...
def qIsFinite(d: float, /) -> bool: ...
def qIsInf(d: float, /) -> bool: ...
def qIsNaN(d: float, /) -> bool: ...
def qIsNull(d: float, /) -> bool: ...
def qRegisterResourceData(arg__1: int, arg__2: bytes | bytearray | memoryview, arg__3: bytes | bytearray | memoryview, arg__4: bytes | bytearray | memoryview, /) -> bool: ...
def qSetMessagePattern(messagePattern: str, /) -> None: ...
@typing.overload
def qUncompress(data: bytes | bytearray | memoryview, nbytes: int, /) -> PySide6.QtCore.QByteArray: ...
@typing.overload
def qUncompress(data: PySide6.QtCore.QByteArray | bytes | bytearray | memoryview, /) -> PySide6.QtCore.QByteArray: ...
def qUnregisterResourceData(arg__1: int, arg__2: bytes | bytearray | memoryview, arg__3: bytes | bytearray | memoryview, arg__4: bytes | bytearray | memoryview, /) -> bool: ...
def qVersion() -> str: ...
def qWarning(message: str, /) -> None: ...
def qtTrId(id: str, /, n: int = ...) -> str: ...


# eof
