# coding: utf-8

"""
    CredentialIssuanceService

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0.0
    Contact: info@affinidi.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr
from affinidi_tdk_credential_issuance_client.models.start_issuance_input_data_inner_meta_data import StartIssuanceInputDataInnerMetaData

class StartIssuanceInputDataInner(BaseModel):
    """
    Data to be included in issued credential  # noqa: E501
    """
    credential_type_id: StrictStr = Field(default=..., alias="credentialTypeId", description="It is a String that identifies a Credential that is being requested to be issued.")
    credential_data: Dict[str, Any] = Field(default=..., alias="credentialData", description="Object of data to be included in the issued credential ,should  match the credential type")
    meta_data: Optional[StartIssuanceInputDataInnerMetaData] = Field(default=None, alias="metaData")
    __properties = ["credentialTypeId", "credentialData", "metaData"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StartIssuanceInputDataInner:
        """Create an instance of StartIssuanceInputDataInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of meta_data
        if self.meta_data:
            _dict['metaData'] = self.meta_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StartIssuanceInputDataInner:
        """Create an instance of StartIssuanceInputDataInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StartIssuanceInputDataInner.parse_obj(obj)

        _obj = StartIssuanceInputDataInner.parse_obj({
            "credential_type_id": obj.get("credentialTypeId"),
            "credential_data": obj.get("credentialData"),
            "meta_data": StartIssuanceInputDataInnerMetaData.from_dict(obj.get("metaData")) if obj.get("metaData") is not None else None
        })
        return _obj


