import { Node } from "constructs";
/**
 * A utility to load context values into a construct node.
 *
 * If you want to use this utility in your own construct, make sure to invoke it
 * before you create any child constructs.
 */
export declare class ContextLoader {
    /**
     * Parses JSON file contents, then provides the values to a Node's context.
     *
     * @param filename - The JSON file with an object to use as context values.
     * @param node - The constructs node to receive the context values.
     */
    static loadContext(filename: string, node: Node): void;
}
