"""This module is responsible for handling BIDS and CAPS datasets.

It provides models and utilities to interact with these datasets.
"""

from ._dataset_type import DatasetType, check_dataset, get_dataset_type
from ._visit import Visit
from .bids import (
    BIDS_VERSION,
    BIDSDatasetDescription,
    BIDSFileName,
    BIDSLabel,
    BIDSReadme,
    check_bids_dataset,
    get_bids_version,
    get_paths_to_subjects_in_bids_dataset,
    get_sessions_for_subject_in_bids_dataset,
    get_subjects_from_bids_dataset,
)
from .caps import (
    CAPS_VERSION,
    CAPSDatasetDescription,
    build_caps_dataset_description,
    check_caps_dataset,
    write_caps_dataset_description,
)

__all__ = [
    "DatasetType",
    "Visit",
    "BIDS_VERSION",
    "CAPS_VERSION",
    "BIDSReadme",
    "BIDSDatasetDescription",
    "BIDSLabel",
    "BIDSFileName",
    "check_dataset",
    "check_bids_dataset",
    "check_caps_dataset",
    "get_bids_version",
    "get_dataset_type",
    "get_subjects_from_bids_dataset",
    "get_paths_to_subjects_in_bids_dataset",
    "get_sessions_for_subject_in_bids_dataset",
    "CAPSDatasetDescription",
    "write_caps_dataset_description",
    "build_caps_dataset_description",
]
