# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstancePoolInstanceArgs', 'InstancePoolInstance']

@pulumi.input_type
class InstancePoolInstanceArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 instance_pool_id: pulumi.Input[str],
                 auto_terminate_instance_on_delete: Optional[pulumi.Input[bool]] = None,
                 decrement_size_on_delete: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a InstancePoolInstance resource.
        :param pulumi.Input[str] instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
        :param pulumi.Input[str] instance_pool_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance pool.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_pool_id", instance_pool_id)
        if auto_terminate_instance_on_delete is not None:
            pulumi.set(__self__, "auto_terminate_instance_on_delete", auto_terminate_instance_on_delete)
        if decrement_size_on_delete is not None:
            pulumi.set(__self__, "decrement_size_on_delete", decrement_size_on_delete)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance pool.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "instance_pool_id")

    @instance_pool_id.setter
    def instance_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_pool_id", value)

    @property
    @pulumi.getter(name="autoTerminateInstanceOnDelete")
    def auto_terminate_instance_on_delete(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "auto_terminate_instance_on_delete")

    @auto_terminate_instance_on_delete.setter
    def auto_terminate_instance_on_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_terminate_instance_on_delete", value)

    @property
    @pulumi.getter(name="decrementSizeOnDelete")
    def decrement_size_on_delete(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "decrement_size_on_delete")

    @decrement_size_on_delete.setter
    def decrement_size_on_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "decrement_size_on_delete", value)


@pulumi.input_type
class _InstancePoolInstanceState:
    def __init__(__self__, *,
                 auto_terminate_instance_on_delete: Optional[pulumi.Input[bool]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 decrement_size_on_delete: Optional[pulumi.Input[bool]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_pool_id: Optional[pulumi.Input[str]] = None,
                 load_balancer_backends: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolInstanceLoadBalancerBackendArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InstancePoolInstance resources.
        :param pulumi.Input[str] availability_domain: The availability domain the instance is running in.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the instance.
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] fault_domain: The fault domain the instance is running in.
        :param pulumi.Input[str] instance_configuration_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance configuration used to create the instance.
        :param pulumi.Input[str] instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
        :param pulumi.Input[str] instance_pool_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance pool.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['InstancePoolInstanceLoadBalancerBackendArgs']]] load_balancer_backends: The load balancer backends that are configured for the instance pool instance.
        :param pulumi.Input[str] region: The region that contains the availability domain the instance is running in.
        :param pulumi.Input[str] shape: The shape of an instance. The shape determines the number of CPUs, amount of memory, and other resources allocated to the instance.
        :param pulumi.Input[str] state: The lifecycle state of the instance. Refer to `lifecycleState` in the [Instance](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance) resource.
        :param pulumi.Input[str] time_created: The date and time the instance pool instance was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        if auto_terminate_instance_on_delete is not None:
            pulumi.set(__self__, "auto_terminate_instance_on_delete", auto_terminate_instance_on_delete)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if decrement_size_on_delete is not None:
            pulumi.set(__self__, "decrement_size_on_delete", decrement_size_on_delete)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_pool_id is not None:
            pulumi.set(__self__, "instance_pool_id", instance_pool_id)
        if load_balancer_backends is not None:
            pulumi.set(__self__, "load_balancer_backends", load_balancer_backends)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="autoTerminateInstanceOnDelete")
    def auto_terminate_instance_on_delete(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "auto_terminate_instance_on_delete")

    @auto_terminate_instance_on_delete.setter
    def auto_terminate_instance_on_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_terminate_instance_on_delete", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain the instance is running in.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the instance.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="decrementSizeOnDelete")
    def decrement_size_on_delete(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "decrement_size_on_delete")

    @decrement_size_on_delete.setter
    def decrement_size_on_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "decrement_size_on_delete", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The fault domain the instance is running in.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance configuration used to create the instance.
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance pool.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "instance_pool_id")

    @instance_pool_id.setter
    def instance_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_pool_id", value)

    @property
    @pulumi.getter(name="loadBalancerBackends")
    def load_balancer_backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolInstanceLoadBalancerBackendArgs']]]]:
        """
        The load balancer backends that are configured for the instance pool instance.
        """
        return pulumi.get(self, "load_balancer_backends")

    @load_balancer_backends.setter
    def load_balancer_backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePoolInstanceLoadBalancerBackendArgs']]]]):
        pulumi.set(self, "load_balancer_backends", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region that contains the availability domain the instance is running in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The shape of an instance. The shape determines the number of CPUs, amount of memory, and other resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The lifecycle state of the instance. Refer to `lifecycleState` in the [Instance](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance) resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the instance pool instance was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class InstancePoolInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_terminate_instance_on_delete: Optional[pulumi.Input[bool]] = None,
                 decrement_size_on_delete: Optional[pulumi.Input[bool]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_pool_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Instance Pool Instance resource in Oracle Cloud Infrastructure Core service.

        Attaches an instance to an instance pool. For information about the prerequisites
        that an instance must meet before you can attach it to a pool, see
        [Attaching an Instance to an Instance Pool](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/updatinginstancepool.htm#attach-instance).

        Using this resource will impact the size of the instance pool, attach will increment the size of the pool

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_instance_pool_instance = oci.core.InstancePoolInstance("testInstancePoolInstance",
            instance_id=oci_core_instance["test_instance"]["id"],
            instance_pool_id=oci_core_instance_pool["test_instance_pool"]["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        InstancePoolInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/instancePoolInstance:InstancePoolInstance test_instance_pool_instance "instancePools/{instancePoolId}/instances/compartmentId/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
        :param pulumi.Input[str] instance_pool_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance pool.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstancePoolInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Instance Pool Instance resource in Oracle Cloud Infrastructure Core service.

        Attaches an instance to an instance pool. For information about the prerequisites
        that an instance must meet before you can attach it to a pool, see
        [Attaching an Instance to an Instance Pool](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/updatinginstancepool.htm#attach-instance).

        Using this resource will impact the size of the instance pool, attach will increment the size of the pool

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_instance_pool_instance = oci.core.InstancePoolInstance("testInstancePoolInstance",
            instance_id=oci_core_instance["test_instance"]["id"],
            instance_pool_id=oci_core_instance_pool["test_instance_pool"]["id"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        InstancePoolInstances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/instancePoolInstance:InstancePoolInstance test_instance_pool_instance "instancePools/{instancePoolId}/instances/compartmentId/{compartmentId}"
        ```

        :param str resource_name: The name of the resource.
        :param InstancePoolInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstancePoolInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_terminate_instance_on_delete: Optional[pulumi.Input[bool]] = None,
                 decrement_size_on_delete: Optional[pulumi.Input[bool]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_pool_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstancePoolInstanceArgs.__new__(InstancePoolInstanceArgs)

            __props__.__dict__["auto_terminate_instance_on_delete"] = auto_terminate_instance_on_delete
            __props__.__dict__["decrement_size_on_delete"] = decrement_size_on_delete
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if instance_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_pool_id'")
            __props__.__dict__["instance_pool_id"] = instance_pool_id
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["fault_domain"] = None
            __props__.__dict__["instance_configuration_id"] = None
            __props__.__dict__["load_balancer_backends"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(InstancePoolInstance, __self__).__init__(
            'oci:Core/instancePoolInstance:InstancePoolInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_terminate_instance_on_delete: Optional[pulumi.Input[bool]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            decrement_size_on_delete: Optional[pulumi.Input[bool]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            fault_domain: Optional[pulumi.Input[str]] = None,
            instance_configuration_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            instance_pool_id: Optional[pulumi.Input[str]] = None,
            load_balancer_backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolInstanceLoadBalancerBackendArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'InstancePoolInstance':
        """
        Get an existing InstancePoolInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain the instance is running in.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the instance.
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] fault_domain: The fault domain the instance is running in.
        :param pulumi.Input[str] instance_configuration_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance configuration used to create the instance.
        :param pulumi.Input[str] instance_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
        :param pulumi.Input[str] instance_pool_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance pool.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstancePoolInstanceLoadBalancerBackendArgs']]]] load_balancer_backends: The load balancer backends that are configured for the instance pool instance.
        :param pulumi.Input[str] region: The region that contains the availability domain the instance is running in.
        :param pulumi.Input[str] shape: The shape of an instance. The shape determines the number of CPUs, amount of memory, and other resources allocated to the instance.
        :param pulumi.Input[str] state: The lifecycle state of the instance. Refer to `lifecycleState` in the [Instance](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance) resource.
        :param pulumi.Input[str] time_created: The date and time the instance pool instance was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstancePoolInstanceState.__new__(_InstancePoolInstanceState)

        __props__.__dict__["auto_terminate_instance_on_delete"] = auto_terminate_instance_on_delete
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["decrement_size_on_delete"] = decrement_size_on_delete
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fault_domain"] = fault_domain
        __props__.__dict__["instance_configuration_id"] = instance_configuration_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_pool_id"] = instance_pool_id
        __props__.__dict__["load_balancer_backends"] = load_balancer_backends
        __props__.__dict__["region"] = region
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return InstancePoolInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoTerminateInstanceOnDelete")
    def auto_terminate_instance_on_delete(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "auto_terminate_instance_on_delete")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain the instance is running in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the instance.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="decrementSizeOnDelete")
    def decrement_size_on_delete(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "decrement_size_on_delete")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> pulumi.Output[str]:
        """
        The fault domain the instance is running in.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance configuration used to create the instance.
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instancePoolId")
    def instance_pool_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the instance pool.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "instance_pool_id")

    @property
    @pulumi.getter(name="loadBalancerBackends")
    def load_balancer_backends(self) -> pulumi.Output[Sequence['outputs.InstancePoolInstanceLoadBalancerBackend']]:
        """
        The load balancer backends that are configured for the instance pool instance.
        """
        return pulumi.get(self, "load_balancer_backends")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region that contains the availability domain the instance is running in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        The shape of an instance. The shape determines the number of CPUs, amount of memory, and other resources allocated to the instance.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The lifecycle state of the instance. Refer to `lifecycleState` in the [Instance](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Instance) resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the instance pool instance was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

