# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetWorkspaceExportRequestResult',
    'AwaitableGetWorkspaceExportRequestResult',
    'get_workspace_export_request',
    'get_workspace_export_request_output',
]

@pulumi.output_type
class GetWorkspaceExportRequestResult:
    """
    A collection of values returned by getWorkspaceExportRequest.
    """
    def __init__(__self__, are_references_included=None, bucket=None, created_by=None, error_messages=None, export_request_key=None, exported_items=None, file_name=None, filters=None, id=None, is_object_overwrite_enabled=None, key=None, name=None, object_keys=None, object_storage_region=None, object_storage_tenancy_id=None, referenced_items=None, status=None, time_ended_in_millis=None, time_started_in_millis=None, total_exported_object_count=None, workspace_id=None):
        if are_references_included and not isinstance(are_references_included, bool):
            raise TypeError("Expected argument 'are_references_included' to be a bool")
        pulumi.set(__self__, "are_references_included", are_references_included)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if error_messages and not isinstance(error_messages, dict):
            raise TypeError("Expected argument 'error_messages' to be a dict")
        pulumi.set(__self__, "error_messages", error_messages)
        if export_request_key and not isinstance(export_request_key, str):
            raise TypeError("Expected argument 'export_request_key' to be a str")
        pulumi.set(__self__, "export_request_key", export_request_key)
        if exported_items and not isinstance(exported_items, list):
            raise TypeError("Expected argument 'exported_items' to be a list")
        pulumi.set(__self__, "exported_items", exported_items)
        if file_name and not isinstance(file_name, str):
            raise TypeError("Expected argument 'file_name' to be a str")
        pulumi.set(__self__, "file_name", file_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_object_overwrite_enabled and not isinstance(is_object_overwrite_enabled, bool):
            raise TypeError("Expected argument 'is_object_overwrite_enabled' to be a bool")
        pulumi.set(__self__, "is_object_overwrite_enabled", is_object_overwrite_enabled)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if object_keys and not isinstance(object_keys, list):
            raise TypeError("Expected argument 'object_keys' to be a list")
        pulumi.set(__self__, "object_keys", object_keys)
        if object_storage_region and not isinstance(object_storage_region, str):
            raise TypeError("Expected argument 'object_storage_region' to be a str")
        pulumi.set(__self__, "object_storage_region", object_storage_region)
        if object_storage_tenancy_id and not isinstance(object_storage_tenancy_id, str):
            raise TypeError("Expected argument 'object_storage_tenancy_id' to be a str")
        pulumi.set(__self__, "object_storage_tenancy_id", object_storage_tenancy_id)
        if referenced_items and not isinstance(referenced_items, str):
            raise TypeError("Expected argument 'referenced_items' to be a str")
        pulumi.set(__self__, "referenced_items", referenced_items)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if time_ended_in_millis and not isinstance(time_ended_in_millis, str):
            raise TypeError("Expected argument 'time_ended_in_millis' to be a str")
        pulumi.set(__self__, "time_ended_in_millis", time_ended_in_millis)
        if time_started_in_millis and not isinstance(time_started_in_millis, str):
            raise TypeError("Expected argument 'time_started_in_millis' to be a str")
        pulumi.set(__self__, "time_started_in_millis", time_started_in_millis)
        if total_exported_object_count and not isinstance(total_exported_object_count, int):
            raise TypeError("Expected argument 'total_exported_object_count' to be a int")
        pulumi.set(__self__, "total_exported_object_count", total_exported_object_count)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="areReferencesIncluded")
    def are_references_included(self) -> bool:
        """
        Controls if the references will be exported along with the objects
        """
        return pulumi.get(self, "are_references_included")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the Object Storage Bucket where the objects will be exported to
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        Name of the user who initiated export request.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Mapping[str, Any]:
        """
        Contains key of the error
        """
        return pulumi.get(self, "error_messages")

    @property
    @pulumi.getter(name="exportRequestKey")
    def export_request_key(self) -> str:
        return pulumi.get(self, "export_request_key")

    @property
    @pulumi.getter(name="exportedItems")
    def exported_items(self) -> Sequence['outputs.GetWorkspaceExportRequestExportedItemResult']:
        """
        The array of exported object details.
        """
        return pulumi.get(self, "exported_items")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> str:
        """
        Name of the exported zip file.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter
    def filters(self) -> Sequence[str]:
        """
        Export multiple objects based on filters.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isObjectOverwriteEnabled")
    def is_object_overwrite_enabled(self) -> bool:
        """
        Flag to control whether to overwrite the object if it is already present at the provided object storage location.
        """
        return pulumi.get(self, "is_object_overwrite_enabled")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Export object request key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the export request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectKeys")
    def object_keys(self) -> Sequence[str]:
        """
        The list of the objects to be exported
        """
        return pulumi.get(self, "object_keys")

    @property
    @pulumi.getter(name="objectStorageRegion")
    def object_storage_region(self) -> str:
        """
        Region of the object storage (if using object storage of different region)
        """
        return pulumi.get(self, "object_storage_region")

    @property
    @pulumi.getter(name="objectStorageTenancyId")
    def object_storage_tenancy_id(self) -> str:
        """
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        """
        return pulumi.get(self, "object_storage_tenancy_id")

    @property
    @pulumi.getter(name="referencedItems")
    def referenced_items(self) -> str:
        """
        The array of exported referenced objects.
        """
        return pulumi.get(self, "referenced_items")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Export Objects request status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeEndedInMillis")
    def time_ended_in_millis(self) -> str:
        """
        Time at which the request was completely processed.
        """
        return pulumi.get(self, "time_ended_in_millis")

    @property
    @pulumi.getter(name="timeStartedInMillis")
    def time_started_in_millis(self) -> str:
        """
        Time at which the request started getting processed.
        """
        return pulumi.get(self, "time_started_in_millis")

    @property
    @pulumi.getter(name="totalExportedObjectCount")
    def total_exported_object_count(self) -> int:
        """
        Number of objects that are exported.
        """
        return pulumi.get(self, "total_exported_object_count")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        return pulumi.get(self, "workspace_id")


class AwaitableGetWorkspaceExportRequestResult(GetWorkspaceExportRequestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceExportRequestResult(
            are_references_included=self.are_references_included,
            bucket=self.bucket,
            created_by=self.created_by,
            error_messages=self.error_messages,
            export_request_key=self.export_request_key,
            exported_items=self.exported_items,
            file_name=self.file_name,
            filters=self.filters,
            id=self.id,
            is_object_overwrite_enabled=self.is_object_overwrite_enabled,
            key=self.key,
            name=self.name,
            object_keys=self.object_keys,
            object_storage_region=self.object_storage_region,
            object_storage_tenancy_id=self.object_storage_tenancy_id,
            referenced_items=self.referenced_items,
            status=self.status,
            time_ended_in_millis=self.time_ended_in_millis,
            time_started_in_millis=self.time_started_in_millis,
            total_exported_object_count=self.total_exported_object_count,
            workspace_id=self.workspace_id)


def get_workspace_export_request(export_request_key: Optional[str] = None,
                                 workspace_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceExportRequestResult:
    """
    This data source provides details about a specific Workspace Export Request resource in Oracle Cloud Infrastructure Data Integration service.

    This endpoint can be used to get the summary/details of object being exported.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_export_request = oci.DataIntegration.get_workspace_export_request(export_request_key=var["workspace_export_request_export_request_key"],
        workspace_id=oci_dataintegration_workspace["test_workspace"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str export_request_key: The key of the object export object request
    :param str workspace_id: The workspace ID.
    """
    __args__ = dict()
    __args__['exportRequestKey'] = export_request_key
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataIntegration/getWorkspaceExportRequest:getWorkspaceExportRequest', __args__, opts=opts, typ=GetWorkspaceExportRequestResult).value

    return AwaitableGetWorkspaceExportRequestResult(
        are_references_included=pulumi.get(__ret__, 'are_references_included'),
        bucket=pulumi.get(__ret__, 'bucket'),
        created_by=pulumi.get(__ret__, 'created_by'),
        error_messages=pulumi.get(__ret__, 'error_messages'),
        export_request_key=pulumi.get(__ret__, 'export_request_key'),
        exported_items=pulumi.get(__ret__, 'exported_items'),
        file_name=pulumi.get(__ret__, 'file_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_object_overwrite_enabled=pulumi.get(__ret__, 'is_object_overwrite_enabled'),
        key=pulumi.get(__ret__, 'key'),
        name=pulumi.get(__ret__, 'name'),
        object_keys=pulumi.get(__ret__, 'object_keys'),
        object_storage_region=pulumi.get(__ret__, 'object_storage_region'),
        object_storage_tenancy_id=pulumi.get(__ret__, 'object_storage_tenancy_id'),
        referenced_items=pulumi.get(__ret__, 'referenced_items'),
        status=pulumi.get(__ret__, 'status'),
        time_ended_in_millis=pulumi.get(__ret__, 'time_ended_in_millis'),
        time_started_in_millis=pulumi.get(__ret__, 'time_started_in_millis'),
        total_exported_object_count=pulumi.get(__ret__, 'total_exported_object_count'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))


@_utilities.lift_output_func(get_workspace_export_request)
def get_workspace_export_request_output(export_request_key: Optional[pulumi.Input[str]] = None,
                                        workspace_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkspaceExportRequestResult]:
    """
    This data source provides details about a specific Workspace Export Request resource in Oracle Cloud Infrastructure Data Integration service.

    This endpoint can be used to get the summary/details of object being exported.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_export_request = oci.DataIntegration.get_workspace_export_request(export_request_key=var["workspace_export_request_export_request_key"],
        workspace_id=oci_dataintegration_workspace["test_workspace"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str export_request_key: The key of the object export object request
    :param str workspace_id: The workspace ID.
    """
    ...
