# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SqlCollectionArgs', 'SqlCollection']

@pulumi.input_type
class SqlCollectionArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 db_user_name: pulumi.Input[str],
                 target_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 generate_sql_firewall_policy_trigger: Optional[pulumi.Input[bool]] = None,
                 purge_logs_trigger: Optional[pulumi.Input[bool]] = None,
                 refresh_log_insights_trigger: Optional[pulumi.Input[bool]] = None,
                 sql_level: Optional[pulumi.Input[str]] = None,
                 start_trigger: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stop_trigger: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a SqlCollection resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the SQL collection.
        :param pulumi.Input[str] db_user_name: The database user name.
        :param pulumi.Input[str] target_id: The OCID of the target corresponding to the security policy deployment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the SQL collection.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the SQL collection. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] generate_sql_firewall_policy_trigger: (Updatable) An optional property when incremented triggers Generate Sql Firewall Policy. Could be set to any integer value.
        :param pulumi.Input[bool] purge_logs_trigger: (Updatable) An optional property when incremented triggers Purge Logs. Could be set to any integer value.
        :param pulumi.Input[bool] refresh_log_insights_trigger: (Updatable) An optional property when incremented triggers Refresh Log Insights. Could be set to any integer value.
        :param pulumi.Input[str] sql_level: Specifies the level of SQL that will be collected. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        :param pulumi.Input[bool] start_trigger: (Updatable) An optional property when incremented triggers Start. Could be set to any integer value.
        :param pulumi.Input[str] status: Specifies if the SqlCollection has to be started after creation. Enabled indicates that the SqlCollection will be started after creation.
        :param pulumi.Input[bool] stop_trigger: (Updatable) An optional property when incremented triggers Stop. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_user_name", db_user_name)
        pulumi.set(__self__, "target_id", target_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if generate_sql_firewall_policy_trigger is not None:
            pulumi.set(__self__, "generate_sql_firewall_policy_trigger", generate_sql_firewall_policy_trigger)
        if purge_logs_trigger is not None:
            pulumi.set(__self__, "purge_logs_trigger", purge_logs_trigger)
        if refresh_log_insights_trigger is not None:
            pulumi.set(__self__, "refresh_log_insights_trigger", refresh_log_insights_trigger)
        if sql_level is not None:
            pulumi.set(__self__, "sql_level", sql_level)
        if start_trigger is not None:
            pulumi.set(__self__, "start_trigger", start_trigger)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stop_trigger is not None:
            pulumi.set(__self__, "stop_trigger", stop_trigger)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment containing the SQL collection.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> pulumi.Input[str]:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user_name")

    @db_user_name.setter
    def db_user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_user_name", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[str]:
        """
        The OCID of the target corresponding to the security policy deployment.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the SQL collection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the SQL collection. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="generateSqlFirewallPolicyTrigger")
    def generate_sql_firewall_policy_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when incremented triggers Generate Sql Firewall Policy. Could be set to any integer value.
        """
        return pulumi.get(self, "generate_sql_firewall_policy_trigger")

    @generate_sql_firewall_policy_trigger.setter
    def generate_sql_firewall_policy_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "generate_sql_firewall_policy_trigger", value)

    @property
    @pulumi.getter(name="purgeLogsTrigger")
    def purge_logs_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when incremented triggers Purge Logs. Could be set to any integer value.
        """
        return pulumi.get(self, "purge_logs_trigger")

    @purge_logs_trigger.setter
    def purge_logs_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "purge_logs_trigger", value)

    @property
    @pulumi.getter(name="refreshLogInsightsTrigger")
    def refresh_log_insights_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when incremented triggers Refresh Log Insights. Could be set to any integer value.
        """
        return pulumi.get(self, "refresh_log_insights_trigger")

    @refresh_log_insights_trigger.setter
    def refresh_log_insights_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "refresh_log_insights_trigger", value)

    @property
    @pulumi.getter(name="sqlLevel")
    def sql_level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the level of SQL that will be collected. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        """
        return pulumi.get(self, "sql_level")

    @sql_level.setter
    def sql_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_level", value)

    @property
    @pulumi.getter(name="startTrigger")
    def start_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when incremented triggers Start. Could be set to any integer value.
        """
        return pulumi.get(self, "start_trigger")

    @start_trigger.setter
    def start_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_trigger", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies if the SqlCollection has to be started after creation. Enabled indicates that the SqlCollection will be started after creation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="stopTrigger")
    def stop_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when incremented triggers Stop. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "stop_trigger")

    @stop_trigger.setter
    def stop_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stop_trigger", value)


@pulumi.input_type
class _SqlCollectionState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 db_user_name: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 generate_sql_firewall_policy_trigger: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 purge_logs_trigger: Optional[pulumi.Input[bool]] = None,
                 refresh_log_insights_trigger: Optional[pulumi.Input[bool]] = None,
                 sql_level: Optional[pulumi.Input[str]] = None,
                 start_trigger: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stop_trigger: Optional[pulumi.Input[bool]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_last_started: Optional[pulumi.Input[str]] = None,
                 time_last_stopped: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SqlCollection resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the SQL collection.
        :param pulumi.Input[str] db_user_name: The database user name.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the SQL collection.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the SQL collection. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] generate_sql_firewall_policy_trigger: (Updatable) An optional property when incremented triggers Generate Sql Firewall Policy. Could be set to any integer value.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the SQL collection in Data Safe.
        :param pulumi.Input[bool] purge_logs_trigger: (Updatable) An optional property when incremented triggers Purge Logs. Could be set to any integer value.
        :param pulumi.Input[bool] refresh_log_insights_trigger: (Updatable) An optional property when incremented triggers Refresh Log Insights. Could be set to any integer value.
        :param pulumi.Input[str] sql_level: Specifies the level of SQL that will be collected. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        :param pulumi.Input[bool] start_trigger: (Updatable) An optional property when incremented triggers Start. Could be set to any integer value.
        :param pulumi.Input[str] state: The current state of the SQL collection.
        :param pulumi.Input[str] status: Specifies if the SqlCollection has to be started after creation. Enabled indicates that the SqlCollection will be started after creation.
        :param pulumi.Input[bool] stop_trigger: (Updatable) An optional property when incremented triggers Stop. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the target corresponding to the security policy deployment.
        :param pulumi.Input[str] time_created: The time that the SQL collection was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_last_started: The timestamp of the most recent SqlCollection start operation, in the format defined by RFC3339.
        :param pulumi.Input[str] time_last_stopped: The timestamp of the most recent SqlCollection stop operation, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The last date and time the SQL collection was updated, in the format defined by RFC3339.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if db_user_name is not None:
            pulumi.set(__self__, "db_user_name", db_user_name)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if generate_sql_firewall_policy_trigger is not None:
            pulumi.set(__self__, "generate_sql_firewall_policy_trigger", generate_sql_firewall_policy_trigger)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if purge_logs_trigger is not None:
            pulumi.set(__self__, "purge_logs_trigger", purge_logs_trigger)
        if refresh_log_insights_trigger is not None:
            pulumi.set(__self__, "refresh_log_insights_trigger", refresh_log_insights_trigger)
        if sql_level is not None:
            pulumi.set(__self__, "sql_level", sql_level)
        if start_trigger is not None:
            pulumi.set(__self__, "start_trigger", start_trigger)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stop_trigger is not None:
            pulumi.set(__self__, "stop_trigger", stop_trigger)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_started is not None:
            pulumi.set(__self__, "time_last_started", time_last_started)
        if time_last_stopped is not None:
            pulumi.set(__self__, "time_last_stopped", time_last_stopped)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment containing the SQL collection.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user_name")

    @db_user_name.setter
    def db_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_user_name", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the SQL collection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the SQL collection. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="generateSqlFirewallPolicyTrigger")
    def generate_sql_firewall_policy_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when incremented triggers Generate Sql Firewall Policy. Could be set to any integer value.
        """
        return pulumi.get(self, "generate_sql_firewall_policy_trigger")

    @generate_sql_firewall_policy_trigger.setter
    def generate_sql_firewall_policy_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "generate_sql_firewall_policy_trigger", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the current state of the SQL collection in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="purgeLogsTrigger")
    def purge_logs_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when incremented triggers Purge Logs. Could be set to any integer value.
        """
        return pulumi.get(self, "purge_logs_trigger")

    @purge_logs_trigger.setter
    def purge_logs_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "purge_logs_trigger", value)

    @property
    @pulumi.getter(name="refreshLogInsightsTrigger")
    def refresh_log_insights_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when incremented triggers Refresh Log Insights. Could be set to any integer value.
        """
        return pulumi.get(self, "refresh_log_insights_trigger")

    @refresh_log_insights_trigger.setter
    def refresh_log_insights_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "refresh_log_insights_trigger", value)

    @property
    @pulumi.getter(name="sqlLevel")
    def sql_level(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the level of SQL that will be collected. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        """
        return pulumi.get(self, "sql_level")

    @sql_level.setter
    def sql_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql_level", value)

    @property
    @pulumi.getter(name="startTrigger")
    def start_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when incremented triggers Start. Could be set to any integer value.
        """
        return pulumi.get(self, "start_trigger")

    @start_trigger.setter
    def start_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "start_trigger", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the SQL collection.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies if the SqlCollection has to be started after creation. Enabled indicates that the SqlCollection will be started after creation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="stopTrigger")
    def stop_trigger(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) An optional property when incremented triggers Stop. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "stop_trigger")

    @stop_trigger.setter
    def stop_trigger(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "stop_trigger", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the target corresponding to the security policy deployment.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time that the SQL collection was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of the most recent SqlCollection start operation, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_started")

    @time_last_started.setter
    def time_last_started(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_started", value)

    @property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of the most recent SqlCollection stop operation, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_stopped")

    @time_last_stopped.setter
    def time_last_stopped(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_stopped", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The last date and time the SQL collection was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class SqlCollection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 db_user_name: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 generate_sql_firewall_policy_trigger: Optional[pulumi.Input[bool]] = None,
                 purge_logs_trigger: Optional[pulumi.Input[bool]] = None,
                 refresh_log_insights_trigger: Optional[pulumi.Input[bool]] = None,
                 sql_level: Optional[pulumi.Input[str]] = None,
                 start_trigger: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stop_trigger: Optional[pulumi.Input[bool]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Sql Collection resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new SQL collection resource.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_sql_collection = oci.data_safe.SqlCollection("testSqlCollection",
            compartment_id=var["compartment_id"],
            db_user_name=oci_identity_user["test_user"]["name"],
            target_id=oci_cloud_guard_target["test_target"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["sql_collection_description"],
            display_name=var["sql_collection_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            sql_level=var["sql_collection_sql_level"],
            status=var["sql_collection_status"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        SqlCollections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/sqlCollection:SqlCollection test_sql_collection "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the SQL collection.
        :param pulumi.Input[str] db_user_name: The database user name.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the SQL collection.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the SQL collection. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] generate_sql_firewall_policy_trigger: (Updatable) An optional property when incremented triggers Generate Sql Firewall Policy. Could be set to any integer value.
        :param pulumi.Input[bool] purge_logs_trigger: (Updatable) An optional property when incremented triggers Purge Logs. Could be set to any integer value.
        :param pulumi.Input[bool] refresh_log_insights_trigger: (Updatable) An optional property when incremented triggers Refresh Log Insights. Could be set to any integer value.
        :param pulumi.Input[str] sql_level: Specifies the level of SQL that will be collected. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        :param pulumi.Input[bool] start_trigger: (Updatable) An optional property when incremented triggers Start. Could be set to any integer value.
        :param pulumi.Input[str] status: Specifies if the SqlCollection has to be started after creation. Enabled indicates that the SqlCollection will be started after creation.
        :param pulumi.Input[bool] stop_trigger: (Updatable) An optional property when incremented triggers Stop. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] target_id: The OCID of the target corresponding to the security policy deployment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlCollectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Sql Collection resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new SQL collection resource.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_sql_collection = oci.data_safe.SqlCollection("testSqlCollection",
            compartment_id=var["compartment_id"],
            db_user_name=oci_identity_user["test_user"]["name"],
            target_id=oci_cloud_guard_target["test_target"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["sql_collection_description"],
            display_name=var["sql_collection_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            sql_level=var["sql_collection_sql_level"],
            status=var["sql_collection_status"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        SqlCollections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/sqlCollection:SqlCollection test_sql_collection "id"
        ```

        :param str resource_name: The name of the resource.
        :param SqlCollectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlCollectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 db_user_name: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 generate_sql_firewall_policy_trigger: Optional[pulumi.Input[bool]] = None,
                 purge_logs_trigger: Optional[pulumi.Input[bool]] = None,
                 refresh_log_insights_trigger: Optional[pulumi.Input[bool]] = None,
                 sql_level: Optional[pulumi.Input[str]] = None,
                 start_trigger: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stop_trigger: Optional[pulumi.Input[bool]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlCollectionArgs.__new__(SqlCollectionArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if db_user_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_user_name'")
            __props__.__dict__["db_user_name"] = db_user_name
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["generate_sql_firewall_policy_trigger"] = generate_sql_firewall_policy_trigger
            __props__.__dict__["purge_logs_trigger"] = purge_logs_trigger
            __props__.__dict__["refresh_log_insights_trigger"] = refresh_log_insights_trigger
            __props__.__dict__["sql_level"] = sql_level
            __props__.__dict__["start_trigger"] = start_trigger
            __props__.__dict__["status"] = status
            __props__.__dict__["stop_trigger"] = stop_trigger
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_started"] = None
            __props__.__dict__["time_last_stopped"] = None
            __props__.__dict__["time_updated"] = None
        super(SqlCollection, __self__).__init__(
            'oci:DataSafe/sqlCollection:SqlCollection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            db_user_name: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            generate_sql_firewall_policy_trigger: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            purge_logs_trigger: Optional[pulumi.Input[bool]] = None,
            refresh_log_insights_trigger: Optional[pulumi.Input[bool]] = None,
            sql_level: Optional[pulumi.Input[str]] = None,
            start_trigger: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            stop_trigger: Optional[pulumi.Input[bool]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_last_started: Optional[pulumi.Input[str]] = None,
            time_last_stopped: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'SqlCollection':
        """
        Get an existing SqlCollection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment containing the SQL collection.
        :param pulumi.Input[str] db_user_name: The database user name.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the SQL collection.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the SQL collection. The name does not have to be unique, and it is changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] generate_sql_firewall_policy_trigger: (Updatable) An optional property when incremented triggers Generate Sql Firewall Policy. Could be set to any integer value.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the SQL collection in Data Safe.
        :param pulumi.Input[bool] purge_logs_trigger: (Updatable) An optional property when incremented triggers Purge Logs. Could be set to any integer value.
        :param pulumi.Input[bool] refresh_log_insights_trigger: (Updatable) An optional property when incremented triggers Refresh Log Insights. Could be set to any integer value.
        :param pulumi.Input[str] sql_level: Specifies the level of SQL that will be collected. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        :param pulumi.Input[bool] start_trigger: (Updatable) An optional property when incremented triggers Start. Could be set to any integer value.
        :param pulumi.Input[str] state: The current state of the SQL collection.
        :param pulumi.Input[str] status: Specifies if the SqlCollection has to be started after creation. Enabled indicates that the SqlCollection will be started after creation.
        :param pulumi.Input[bool] stop_trigger: (Updatable) An optional property when incremented triggers Stop. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the target corresponding to the security policy deployment.
        :param pulumi.Input[str] time_created: The time that the SQL collection was created, in the format defined by RFC3339.
        :param pulumi.Input[str] time_last_started: The timestamp of the most recent SqlCollection start operation, in the format defined by RFC3339.
        :param pulumi.Input[str] time_last_stopped: The timestamp of the most recent SqlCollection stop operation, in the format defined by RFC3339.
        :param pulumi.Input[str] time_updated: The last date and time the SQL collection was updated, in the format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlCollectionState.__new__(_SqlCollectionState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["db_user_name"] = db_user_name
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["generate_sql_firewall_policy_trigger"] = generate_sql_firewall_policy_trigger
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["purge_logs_trigger"] = purge_logs_trigger
        __props__.__dict__["refresh_log_insights_trigger"] = refresh_log_insights_trigger
        __props__.__dict__["sql_level"] = sql_level
        __props__.__dict__["start_trigger"] = start_trigger
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["stop_trigger"] = stop_trigger
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_started"] = time_last_started
        __props__.__dict__["time_last_stopped"] = time_last_stopped
        __props__.__dict__["time_updated"] = time_updated
        return SqlCollection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment containing the SQL collection.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> pulumi.Output[str]:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the SQL collection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the SQL collection. The name does not have to be unique, and it is changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="generateSqlFirewallPolicyTrigger")
    def generate_sql_firewall_policy_trigger(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) An optional property when incremented triggers Generate Sql Firewall Policy. Could be set to any integer value.
        """
        return pulumi.get(self, "generate_sql_firewall_policy_trigger")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the current state of the SQL collection in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="purgeLogsTrigger")
    def purge_logs_trigger(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) An optional property when incremented triggers Purge Logs. Could be set to any integer value.
        """
        return pulumi.get(self, "purge_logs_trigger")

    @property
    @pulumi.getter(name="refreshLogInsightsTrigger")
    def refresh_log_insights_trigger(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) An optional property when incremented triggers Refresh Log Insights. Could be set to any integer value.
        """
        return pulumi.get(self, "refresh_log_insights_trigger")

    @property
    @pulumi.getter(name="sqlLevel")
    def sql_level(self) -> pulumi.Output[str]:
        """
        Specifies the level of SQL that will be collected. USER_ISSUED_SQL - User issued SQL statements only. ALL_SQL - Includes all SQL statements including SQL statement issued inside PL/SQL units.
        """
        return pulumi.get(self, "sql_level")

    @property
    @pulumi.getter(name="startTrigger")
    def start_trigger(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) An optional property when incremented triggers Start. Could be set to any integer value.
        """
        return pulumi.get(self, "start_trigger")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the SQL collection.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Specifies if the SqlCollection has to be started after creation. Enabled indicates that the SqlCollection will be started after creation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stopTrigger")
    def stop_trigger(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) An optional property when incremented triggers Stop. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "stop_trigger")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        The OCID of the target corresponding to the security policy deployment.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time that the SQL collection was created, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastStarted")
    def time_last_started(self) -> pulumi.Output[str]:
        """
        The timestamp of the most recent SqlCollection start operation, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_started")

    @property
    @pulumi.getter(name="timeLastStopped")
    def time_last_stopped(self) -> pulumi.Output[str]:
        """
        The timestamp of the most recent SqlCollection stop operation, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_last_stopped")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The last date and time the SQL collection was updated, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

