# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BuildPipelineStageArgs', 'BuildPipelineStage']

@pulumi.input_type
class BuildPipelineStageArgs:
    def __init__(__self__, *,
                 build_pipeline_id: pulumi.Input[str],
                 build_pipeline_stage_predecessor_collection: pulumi.Input['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs'],
                 build_pipeline_stage_type: pulumi.Input[str],
                 build_runner_shape_config: Optional[pulumi.Input['BuildPipelineStageBuildRunnerShapeConfigArgs']] = None,
                 build_source_collection: Optional[pulumi.Input['BuildPipelineStageBuildSourceCollectionArgs']] = None,
                 build_spec_file: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deliver_artifact_collection: Optional[pulumi.Input['BuildPipelineStageDeliverArtifactCollectionArgs']] = None,
                 deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 is_pass_all_parameters_enabled: Optional[pulumi.Input[bool]] = None,
                 primary_build_source: Optional[pulumi.Input[str]] = None,
                 private_access_config: Optional[pulumi.Input['BuildPipelineStagePrivateAccessConfigArgs']] = None,
                 stage_execution_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 wait_criteria: Optional[pulumi.Input['BuildPipelineStageWaitCriteriaArgs']] = None):
        """
        The set of arguments for constructing a BuildPipelineStage resource.
        :param pulumi.Input[str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs'] build_pipeline_stage_predecessor_collection: (Updatable) The collection containing the predecessors of a stage.
        :param pulumi.Input[str] build_pipeline_stage_type: (Updatable) Defines the stage type, which is one of the following: BUILD, DELIVER_ARTIFACT, WAIT, and TRIGGER_DEPLOYMENT_PIPELINE.
        :param pulumi.Input['BuildPipelineStageBuildRunnerShapeConfigArgs'] build_runner_shape_config: (Updatable) The information about build runner.
        :param pulumi.Input['BuildPipelineStageBuildSourceCollectionArgs'] build_source_collection: (Updatable) Collection of build sources.
        :param pulumi.Input[str] build_spec_file: (Updatable) The path to the build specification file for this environment. The default location of the file if not specified is build_spec.yaml.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input['BuildPipelineStageDeliverArtifactCollectionArgs'] deliver_artifact_collection: (Updatable) Specifies an array of artifacts that need to be pushed to the artifactory stores.
        :param pulumi.Input[str] deploy_pipeline_id: (Updatable) A target deployment pipeline OCID that will run in this stage.
        :param pulumi.Input[str] description: (Updatable) Optional description about the stage.
        :param pulumi.Input[str] display_name: (Updatable) Stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] image: (Updatable) Image name for the build environment
        :param pulumi.Input[bool] is_pass_all_parameters_enabled: (Updatable) A boolean flag that specifies whether all the parameters must be passed when the deployment is triggered.
        :param pulumi.Input[str] primary_build_source: (Updatable) Name of the build source where the build_spec.yml file is located. If not specified, the first entry in the build source collection is chosen as primary build source.
        :param pulumi.Input['BuildPipelineStagePrivateAccessConfigArgs'] private_access_config: (Updatable) Specifies the configuration needed when the target Oracle Cloud Infrastructure resource, i.e., OKE cluster, resides in customer's private network.
        :param pulumi.Input[int] stage_execution_timeout_in_seconds: (Updatable) Timeout for the build stage execution. Specify value in seconds.
        :param pulumi.Input['BuildPipelineStageWaitCriteriaArgs'] wait_criteria: (Updatable) Specifies wait criteria for the Wait stage.
        """
        pulumi.set(__self__, "build_pipeline_id", build_pipeline_id)
        pulumi.set(__self__, "build_pipeline_stage_predecessor_collection", build_pipeline_stage_predecessor_collection)
        pulumi.set(__self__, "build_pipeline_stage_type", build_pipeline_stage_type)
        if build_runner_shape_config is not None:
            pulumi.set(__self__, "build_runner_shape_config", build_runner_shape_config)
        if build_source_collection is not None:
            pulumi.set(__self__, "build_source_collection", build_source_collection)
        if build_spec_file is not None:
            pulumi.set(__self__, "build_spec_file", build_spec_file)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deliver_artifact_collection is not None:
            pulumi.set(__self__, "deliver_artifact_collection", deliver_artifact_collection)
        if deploy_pipeline_id is not None:
            pulumi.set(__self__, "deploy_pipeline_id", deploy_pipeline_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if is_pass_all_parameters_enabled is not None:
            pulumi.set(__self__, "is_pass_all_parameters_enabled", is_pass_all_parameters_enabled)
        if primary_build_source is not None:
            pulumi.set(__self__, "primary_build_source", primary_build_source)
        if private_access_config is not None:
            pulumi.set(__self__, "private_access_config", private_access_config)
        if stage_execution_timeout_in_seconds is not None:
            pulumi.set(__self__, "stage_execution_timeout_in_seconds", stage_execution_timeout_in_seconds)
        if wait_criteria is not None:
            pulumi.set(__self__, "wait_criteria", wait_criteria)

    @property
    @pulumi.getter(name="buildPipelineId")
    def build_pipeline_id(self) -> pulumi.Input[str]:
        """
        The OCID of the build pipeline.
        """
        return pulumi.get(self, "build_pipeline_id")

    @build_pipeline_id.setter
    def build_pipeline_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "build_pipeline_id", value)

    @property
    @pulumi.getter(name="buildPipelineStagePredecessorCollection")
    def build_pipeline_stage_predecessor_collection(self) -> pulumi.Input['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs']:
        """
        (Updatable) The collection containing the predecessors of a stage.
        """
        return pulumi.get(self, "build_pipeline_stage_predecessor_collection")

    @build_pipeline_stage_predecessor_collection.setter
    def build_pipeline_stage_predecessor_collection(self, value: pulumi.Input['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs']):
        pulumi.set(self, "build_pipeline_stage_predecessor_collection", value)

    @property
    @pulumi.getter(name="buildPipelineStageType")
    def build_pipeline_stage_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Defines the stage type, which is one of the following: BUILD, DELIVER_ARTIFACT, WAIT, and TRIGGER_DEPLOYMENT_PIPELINE.
        """
        return pulumi.get(self, "build_pipeline_stage_type")

    @build_pipeline_stage_type.setter
    def build_pipeline_stage_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "build_pipeline_stage_type", value)

    @property
    @pulumi.getter(name="buildRunnerShapeConfig")
    def build_runner_shape_config(self) -> Optional[pulumi.Input['BuildPipelineStageBuildRunnerShapeConfigArgs']]:
        """
        (Updatable) The information about build runner.
        """
        return pulumi.get(self, "build_runner_shape_config")

    @build_runner_shape_config.setter
    def build_runner_shape_config(self, value: Optional[pulumi.Input['BuildPipelineStageBuildRunnerShapeConfigArgs']]):
        pulumi.set(self, "build_runner_shape_config", value)

    @property
    @pulumi.getter(name="buildSourceCollection")
    def build_source_collection(self) -> Optional[pulumi.Input['BuildPipelineStageBuildSourceCollectionArgs']]:
        """
        (Updatable) Collection of build sources.
        """
        return pulumi.get(self, "build_source_collection")

    @build_source_collection.setter
    def build_source_collection(self, value: Optional[pulumi.Input['BuildPipelineStageBuildSourceCollectionArgs']]):
        pulumi.set(self, "build_source_collection", value)

    @property
    @pulumi.getter(name="buildSpecFile")
    def build_spec_file(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The path to the build specification file for this environment. The default location of the file if not specified is build_spec.yaml.
        """
        return pulumi.get(self, "build_spec_file")

    @build_spec_file.setter
    def build_spec_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_spec_file", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deliverArtifactCollection")
    def deliver_artifact_collection(self) -> Optional[pulumi.Input['BuildPipelineStageDeliverArtifactCollectionArgs']]:
        """
        (Updatable) Specifies an array of artifacts that need to be pushed to the artifactory stores.
        """
        return pulumi.get(self, "deliver_artifact_collection")

    @deliver_artifact_collection.setter
    def deliver_artifact_collection(self, value: Optional[pulumi.Input['BuildPipelineStageDeliverArtifactCollectionArgs']]):
        pulumi.set(self, "deliver_artifact_collection", value)

    @property
    @pulumi.getter(name="deployPipelineId")
    def deploy_pipeline_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A target deployment pipeline OCID that will run in this stage.
        """
        return pulumi.get(self, "deploy_pipeline_id")

    @deploy_pipeline_id.setter
    def deploy_pipeline_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_pipeline_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional description about the stage.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Image name for the build environment
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="isPassAllParametersEnabled")
    def is_pass_all_parameters_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag that specifies whether all the parameters must be passed when the deployment is triggered.
        """
        return pulumi.get(self, "is_pass_all_parameters_enabled")

    @is_pass_all_parameters_enabled.setter
    def is_pass_all_parameters_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_pass_all_parameters_enabled", value)

    @property
    @pulumi.getter(name="primaryBuildSource")
    def primary_build_source(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the build source where the build_spec.yml file is located. If not specified, the first entry in the build source collection is chosen as primary build source.
        """
        return pulumi.get(self, "primary_build_source")

    @primary_build_source.setter
    def primary_build_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_build_source", value)

    @property
    @pulumi.getter(name="privateAccessConfig")
    def private_access_config(self) -> Optional[pulumi.Input['BuildPipelineStagePrivateAccessConfigArgs']]:
        """
        (Updatable) Specifies the configuration needed when the target Oracle Cloud Infrastructure resource, i.e., OKE cluster, resides in customer's private network.
        """
        return pulumi.get(self, "private_access_config")

    @private_access_config.setter
    def private_access_config(self, value: Optional[pulumi.Input['BuildPipelineStagePrivateAccessConfigArgs']]):
        pulumi.set(self, "private_access_config", value)

    @property
    @pulumi.getter(name="stageExecutionTimeoutInSeconds")
    def stage_execution_timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Timeout for the build stage execution. Specify value in seconds.
        """
        return pulumi.get(self, "stage_execution_timeout_in_seconds")

    @stage_execution_timeout_in_seconds.setter
    def stage_execution_timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stage_execution_timeout_in_seconds", value)

    @property
    @pulumi.getter(name="waitCriteria")
    def wait_criteria(self) -> Optional[pulumi.Input['BuildPipelineStageWaitCriteriaArgs']]:
        """
        (Updatable) Specifies wait criteria for the Wait stage.
        """
        return pulumi.get(self, "wait_criteria")

    @wait_criteria.setter
    def wait_criteria(self, value: Optional[pulumi.Input['BuildPipelineStageWaitCriteriaArgs']]):
        pulumi.set(self, "wait_criteria", value)


@pulumi.input_type
class _BuildPipelineStageState:
    def __init__(__self__, *,
                 build_pipeline_id: Optional[pulumi.Input[str]] = None,
                 build_pipeline_stage_predecessor_collection: Optional[pulumi.Input['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs']] = None,
                 build_pipeline_stage_type: Optional[pulumi.Input[str]] = None,
                 build_runner_shape_config: Optional[pulumi.Input['BuildPipelineStageBuildRunnerShapeConfigArgs']] = None,
                 build_source_collection: Optional[pulumi.Input['BuildPipelineStageBuildSourceCollectionArgs']] = None,
                 build_spec_file: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deliver_artifact_collection: Optional[pulumi.Input['BuildPipelineStageDeliverArtifactCollectionArgs']] = None,
                 deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 is_pass_all_parameters_enabled: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 primary_build_source: Optional[pulumi.Input[str]] = None,
                 private_access_config: Optional[pulumi.Input['BuildPipelineStagePrivateAccessConfigArgs']] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 stage_execution_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 wait_criteria: Optional[pulumi.Input['BuildPipelineStageWaitCriteriaArgs']] = None):
        """
        Input properties used for looking up and filtering BuildPipelineStage resources.
        :param pulumi.Input[str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs'] build_pipeline_stage_predecessor_collection: (Updatable) The collection containing the predecessors of a stage.
        :param pulumi.Input[str] build_pipeline_stage_type: (Updatable) Defines the stage type, which is one of the following: BUILD, DELIVER_ARTIFACT, WAIT, and TRIGGER_DEPLOYMENT_PIPELINE.
        :param pulumi.Input['BuildPipelineStageBuildRunnerShapeConfigArgs'] build_runner_shape_config: (Updatable) The information about build runner.
        :param pulumi.Input['BuildPipelineStageBuildSourceCollectionArgs'] build_source_collection: (Updatable) Collection of build sources.
        :param pulumi.Input[str] build_spec_file: (Updatable) The path to the build specification file for this environment. The default location of the file if not specified is build_spec.yaml.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment where the pipeline is created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input['BuildPipelineStageDeliverArtifactCollectionArgs'] deliver_artifact_collection: (Updatable) Specifies an array of artifacts that need to be pushed to the artifactory stores.
        :param pulumi.Input[str] deploy_pipeline_id: (Updatable) A target deployment pipeline OCID that will run in this stage.
        :param pulumi.Input[str] description: (Updatable) Optional description about the stage.
        :param pulumi.Input[str] display_name: (Updatable) Stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] image: (Updatable) Image name for the build environment
        :param pulumi.Input[bool] is_pass_all_parameters_enabled: (Updatable) A boolean flag that specifies whether all the parameters must be passed when the deployment is triggered.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] primary_build_source: (Updatable) Name of the build source where the build_spec.yml file is located. If not specified, the first entry in the build source collection is chosen as primary build source.
        :param pulumi.Input['BuildPipelineStagePrivateAccessConfigArgs'] private_access_config: (Updatable) Specifies the configuration needed when the target Oracle Cloud Infrastructure resource, i.e., OKE cluster, resides in customer's private network.
        :param pulumi.Input[str] project_id: The OCID of the DevOps project.
        :param pulumi.Input[int] stage_execution_timeout_in_seconds: (Updatable) Timeout for the build stage execution. Specify value in seconds.
        :param pulumi.Input[str] state: The current state of the stage.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the stage was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: The time the stage was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input['BuildPipelineStageWaitCriteriaArgs'] wait_criteria: (Updatable) Specifies wait criteria for the Wait stage.
        """
        if build_pipeline_id is not None:
            pulumi.set(__self__, "build_pipeline_id", build_pipeline_id)
        if build_pipeline_stage_predecessor_collection is not None:
            pulumi.set(__self__, "build_pipeline_stage_predecessor_collection", build_pipeline_stage_predecessor_collection)
        if build_pipeline_stage_type is not None:
            pulumi.set(__self__, "build_pipeline_stage_type", build_pipeline_stage_type)
        if build_runner_shape_config is not None:
            pulumi.set(__self__, "build_runner_shape_config", build_runner_shape_config)
        if build_source_collection is not None:
            pulumi.set(__self__, "build_source_collection", build_source_collection)
        if build_spec_file is not None:
            pulumi.set(__self__, "build_spec_file", build_spec_file)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deliver_artifact_collection is not None:
            pulumi.set(__self__, "deliver_artifact_collection", deliver_artifact_collection)
        if deploy_pipeline_id is not None:
            pulumi.set(__self__, "deploy_pipeline_id", deploy_pipeline_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if is_pass_all_parameters_enabled is not None:
            pulumi.set(__self__, "is_pass_all_parameters_enabled", is_pass_all_parameters_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if primary_build_source is not None:
            pulumi.set(__self__, "primary_build_source", primary_build_source)
        if private_access_config is not None:
            pulumi.set(__self__, "private_access_config", private_access_config)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if stage_execution_timeout_in_seconds is not None:
            pulumi.set(__self__, "stage_execution_timeout_in_seconds", stage_execution_timeout_in_seconds)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if wait_criteria is not None:
            pulumi.set(__self__, "wait_criteria", wait_criteria)

    @property
    @pulumi.getter(name="buildPipelineId")
    def build_pipeline_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the build pipeline.
        """
        return pulumi.get(self, "build_pipeline_id")

    @build_pipeline_id.setter
    def build_pipeline_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_pipeline_id", value)

    @property
    @pulumi.getter(name="buildPipelineStagePredecessorCollection")
    def build_pipeline_stage_predecessor_collection(self) -> Optional[pulumi.Input['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs']]:
        """
        (Updatable) The collection containing the predecessors of a stage.
        """
        return pulumi.get(self, "build_pipeline_stage_predecessor_collection")

    @build_pipeline_stage_predecessor_collection.setter
    def build_pipeline_stage_predecessor_collection(self, value: Optional[pulumi.Input['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs']]):
        pulumi.set(self, "build_pipeline_stage_predecessor_collection", value)

    @property
    @pulumi.getter(name="buildPipelineStageType")
    def build_pipeline_stage_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Defines the stage type, which is one of the following: BUILD, DELIVER_ARTIFACT, WAIT, and TRIGGER_DEPLOYMENT_PIPELINE.
        """
        return pulumi.get(self, "build_pipeline_stage_type")

    @build_pipeline_stage_type.setter
    def build_pipeline_stage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_pipeline_stage_type", value)

    @property
    @pulumi.getter(name="buildRunnerShapeConfig")
    def build_runner_shape_config(self) -> Optional[pulumi.Input['BuildPipelineStageBuildRunnerShapeConfigArgs']]:
        """
        (Updatable) The information about build runner.
        """
        return pulumi.get(self, "build_runner_shape_config")

    @build_runner_shape_config.setter
    def build_runner_shape_config(self, value: Optional[pulumi.Input['BuildPipelineStageBuildRunnerShapeConfigArgs']]):
        pulumi.set(self, "build_runner_shape_config", value)

    @property
    @pulumi.getter(name="buildSourceCollection")
    def build_source_collection(self) -> Optional[pulumi.Input['BuildPipelineStageBuildSourceCollectionArgs']]:
        """
        (Updatable) Collection of build sources.
        """
        return pulumi.get(self, "build_source_collection")

    @build_source_collection.setter
    def build_source_collection(self, value: Optional[pulumi.Input['BuildPipelineStageBuildSourceCollectionArgs']]):
        pulumi.set(self, "build_source_collection", value)

    @property
    @pulumi.getter(name="buildSpecFile")
    def build_spec_file(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The path to the build specification file for this environment. The default location of the file if not specified is build_spec.yaml.
        """
        return pulumi.get(self, "build_spec_file")

    @build_spec_file.setter
    def build_spec_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_spec_file", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment where the pipeline is created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deliverArtifactCollection")
    def deliver_artifact_collection(self) -> Optional[pulumi.Input['BuildPipelineStageDeliverArtifactCollectionArgs']]:
        """
        (Updatable) Specifies an array of artifacts that need to be pushed to the artifactory stores.
        """
        return pulumi.get(self, "deliver_artifact_collection")

    @deliver_artifact_collection.setter
    def deliver_artifact_collection(self, value: Optional[pulumi.Input['BuildPipelineStageDeliverArtifactCollectionArgs']]):
        pulumi.set(self, "deliver_artifact_collection", value)

    @property
    @pulumi.getter(name="deployPipelineId")
    def deploy_pipeline_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A target deployment pipeline OCID that will run in this stage.
        """
        return pulumi.get(self, "deploy_pipeline_id")

    @deploy_pipeline_id.setter
    def deploy_pipeline_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_pipeline_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional description about the stage.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Image name for the build environment
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="isPassAllParametersEnabled")
    def is_pass_all_parameters_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag that specifies whether all the parameters must be passed when the deployment is triggered.
        """
        return pulumi.get(self, "is_pass_all_parameters_enabled")

    @is_pass_all_parameters_enabled.setter
    def is_pass_all_parameters_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_pass_all_parameters_enabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="primaryBuildSource")
    def primary_build_source(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the build source where the build_spec.yml file is located. If not specified, the first entry in the build source collection is chosen as primary build source.
        """
        return pulumi.get(self, "primary_build_source")

    @primary_build_source.setter
    def primary_build_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_build_source", value)

    @property
    @pulumi.getter(name="privateAccessConfig")
    def private_access_config(self) -> Optional[pulumi.Input['BuildPipelineStagePrivateAccessConfigArgs']]:
        """
        (Updatable) Specifies the configuration needed when the target Oracle Cloud Infrastructure resource, i.e., OKE cluster, resides in customer's private network.
        """
        return pulumi.get(self, "private_access_config")

    @private_access_config.setter
    def private_access_config(self, value: Optional[pulumi.Input['BuildPipelineStagePrivateAccessConfigArgs']]):
        pulumi.set(self, "private_access_config", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the DevOps project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="stageExecutionTimeoutInSeconds")
    def stage_execution_timeout_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Timeout for the build stage execution. Specify value in seconds.
        """
        return pulumi.get(self, "stage_execution_timeout_in_seconds")

    @stage_execution_timeout_in_seconds.setter
    def stage_execution_timeout_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "stage_execution_timeout_in_seconds", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the stage.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the stage was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the stage was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="waitCriteria")
    def wait_criteria(self) -> Optional[pulumi.Input['BuildPipelineStageWaitCriteriaArgs']]:
        """
        (Updatable) Specifies wait criteria for the Wait stage.
        """
        return pulumi.get(self, "wait_criteria")

    @wait_criteria.setter
    def wait_criteria(self, value: Optional[pulumi.Input['BuildPipelineStageWaitCriteriaArgs']]):
        pulumi.set(self, "wait_criteria", value)


class BuildPipelineStage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_pipeline_id: Optional[pulumi.Input[str]] = None,
                 build_pipeline_stage_predecessor_collection: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs']]] = None,
                 build_pipeline_stage_type: Optional[pulumi.Input[str]] = None,
                 build_runner_shape_config: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageBuildRunnerShapeConfigArgs']]] = None,
                 build_source_collection: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageBuildSourceCollectionArgs']]] = None,
                 build_spec_file: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deliver_artifact_collection: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageDeliverArtifactCollectionArgs']]] = None,
                 deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 is_pass_all_parameters_enabled: Optional[pulumi.Input[bool]] = None,
                 primary_build_source: Optional[pulumi.Input[str]] = None,
                 private_access_config: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStagePrivateAccessConfigArgs']]] = None,
                 stage_execution_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 wait_criteria: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageWaitCriteriaArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Build Pipeline Stage resource in Oracle Cloud Infrastructure Devops service.

        Creates a new stage.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_build_pipeline_stage = oci.dev_ops.BuildPipelineStage("testBuildPipelineStage",
            build_pipeline_id=oci_devops_build_pipeline["test_build_pipeline"]["id"],
            build_pipeline_stage_predecessor_collection=oci.dev_ops.BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs(
                items=[oci.dev_ops.BuildPipelineStageBuildPipelineStagePredecessorCollectionItemArgs(
                    id=var["build_pipeline_stage_build_pipeline_stage_predecessor_collection_items_id"],
                )],
            ),
            build_pipeline_stage_type=var["build_pipeline_stage_build_pipeline_stage_type"],
            build_runner_shape_config=oci.dev_ops.BuildPipelineStageBuildRunnerShapeConfigArgs(
                build_runner_type=var["build_pipeline_stage_build_runner_shape_config_build_runner_type"],
                memory_in_gbs=var["build_pipeline_stage_build_runner_shape_config_memory_in_gbs"],
                ocpus=var["build_pipeline_stage_build_runner_shape_config_ocpus"],
            ),
            build_source_collection=oci.dev_ops.BuildPipelineStageBuildSourceCollectionArgs(
                items=[oci.dev_ops.BuildPipelineStageBuildSourceCollectionItemArgs(
                    connection_type=var["build_pipeline_stage_build_source_collection_items_connection_type"],
                    branch=var["build_pipeline_stage_build_source_collection_items_branch"],
                    connection_id=oci_devops_connection["test_connection"]["id"],
                    name=var["build_pipeline_stage_build_source_collection_items_name"],
                    repository_id=oci_artifacts_repository["test_repository"]["id"],
                    repository_url=var["build_pipeline_stage_build_source_collection_items_repository_url"],
                )],
            ),
            build_spec_file=var["build_pipeline_stage_build_spec_file"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            deliver_artifact_collection=oci.dev_ops.BuildPipelineStageDeliverArtifactCollectionArgs(
                items=[oci.dev_ops.BuildPipelineStageDeliverArtifactCollectionItemArgs(
                    artifact_id=oci_devops_artifact["test_artifact"]["id"],
                    artifact_name=var["build_pipeline_stage_deliver_artifact_collection_items_artifact_name"],
                )],
            ),
            deploy_pipeline_id=oci_devops_deploy_pipeline["test_deploy_pipeline"]["id"],
            description=var["build_pipeline_stage_description"],
            display_name=var["build_pipeline_stage_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            image=var["build_pipeline_stage_image"],
            is_pass_all_parameters_enabled=var["build_pipeline_stage_is_pass_all_parameters_enabled"],
            primary_build_source=var["build_pipeline_stage_primary_build_source"],
            private_access_config=oci.dev_ops.BuildPipelineStagePrivateAccessConfigArgs(
                network_channel_type=var["build_pipeline_stage_private_access_config_network_channel_type"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                nsg_ids=var["build_pipeline_stage_private_access_config_nsg_ids"],
            ),
            stage_execution_timeout_in_seconds=var["build_pipeline_stage_stage_execution_timeout_in_seconds"],
            wait_criteria=oci.dev_ops.BuildPipelineStageWaitCriteriaArgs(
                wait_duration=var["build_pipeline_stage_wait_criteria_wait_duration"],
                wait_type=var["build_pipeline_stage_wait_criteria_wait_type"],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        BuildPipelineStages can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/buildPipelineStage:BuildPipelineStage test_build_pipeline_stage "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input[pulumi.InputType['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs']] build_pipeline_stage_predecessor_collection: (Updatable) The collection containing the predecessors of a stage.
        :param pulumi.Input[str] build_pipeline_stage_type: (Updatable) Defines the stage type, which is one of the following: BUILD, DELIVER_ARTIFACT, WAIT, and TRIGGER_DEPLOYMENT_PIPELINE.
        :param pulumi.Input[pulumi.InputType['BuildPipelineStageBuildRunnerShapeConfigArgs']] build_runner_shape_config: (Updatable) The information about build runner.
        :param pulumi.Input[pulumi.InputType['BuildPipelineStageBuildSourceCollectionArgs']] build_source_collection: (Updatable) Collection of build sources.
        :param pulumi.Input[str] build_spec_file: (Updatable) The path to the build specification file for this environment. The default location of the file if not specified is build_spec.yaml.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[pulumi.InputType['BuildPipelineStageDeliverArtifactCollectionArgs']] deliver_artifact_collection: (Updatable) Specifies an array of artifacts that need to be pushed to the artifactory stores.
        :param pulumi.Input[str] deploy_pipeline_id: (Updatable) A target deployment pipeline OCID that will run in this stage.
        :param pulumi.Input[str] description: (Updatable) Optional description about the stage.
        :param pulumi.Input[str] display_name: (Updatable) Stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] image: (Updatable) Image name for the build environment
        :param pulumi.Input[bool] is_pass_all_parameters_enabled: (Updatable) A boolean flag that specifies whether all the parameters must be passed when the deployment is triggered.
        :param pulumi.Input[str] primary_build_source: (Updatable) Name of the build source where the build_spec.yml file is located. If not specified, the first entry in the build source collection is chosen as primary build source.
        :param pulumi.Input[pulumi.InputType['BuildPipelineStagePrivateAccessConfigArgs']] private_access_config: (Updatable) Specifies the configuration needed when the target Oracle Cloud Infrastructure resource, i.e., OKE cluster, resides in customer's private network.
        :param pulumi.Input[int] stage_execution_timeout_in_seconds: (Updatable) Timeout for the build stage execution. Specify value in seconds.
        :param pulumi.Input[pulumi.InputType['BuildPipelineStageWaitCriteriaArgs']] wait_criteria: (Updatable) Specifies wait criteria for the Wait stage.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BuildPipelineStageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Build Pipeline Stage resource in Oracle Cloud Infrastructure Devops service.

        Creates a new stage.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_build_pipeline_stage = oci.dev_ops.BuildPipelineStage("testBuildPipelineStage",
            build_pipeline_id=oci_devops_build_pipeline["test_build_pipeline"]["id"],
            build_pipeline_stage_predecessor_collection=oci.dev_ops.BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs(
                items=[oci.dev_ops.BuildPipelineStageBuildPipelineStagePredecessorCollectionItemArgs(
                    id=var["build_pipeline_stage_build_pipeline_stage_predecessor_collection_items_id"],
                )],
            ),
            build_pipeline_stage_type=var["build_pipeline_stage_build_pipeline_stage_type"],
            build_runner_shape_config=oci.dev_ops.BuildPipelineStageBuildRunnerShapeConfigArgs(
                build_runner_type=var["build_pipeline_stage_build_runner_shape_config_build_runner_type"],
                memory_in_gbs=var["build_pipeline_stage_build_runner_shape_config_memory_in_gbs"],
                ocpus=var["build_pipeline_stage_build_runner_shape_config_ocpus"],
            ),
            build_source_collection=oci.dev_ops.BuildPipelineStageBuildSourceCollectionArgs(
                items=[oci.dev_ops.BuildPipelineStageBuildSourceCollectionItemArgs(
                    connection_type=var["build_pipeline_stage_build_source_collection_items_connection_type"],
                    branch=var["build_pipeline_stage_build_source_collection_items_branch"],
                    connection_id=oci_devops_connection["test_connection"]["id"],
                    name=var["build_pipeline_stage_build_source_collection_items_name"],
                    repository_id=oci_artifacts_repository["test_repository"]["id"],
                    repository_url=var["build_pipeline_stage_build_source_collection_items_repository_url"],
                )],
            ),
            build_spec_file=var["build_pipeline_stage_build_spec_file"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            deliver_artifact_collection=oci.dev_ops.BuildPipelineStageDeliverArtifactCollectionArgs(
                items=[oci.dev_ops.BuildPipelineStageDeliverArtifactCollectionItemArgs(
                    artifact_id=oci_devops_artifact["test_artifact"]["id"],
                    artifact_name=var["build_pipeline_stage_deliver_artifact_collection_items_artifact_name"],
                )],
            ),
            deploy_pipeline_id=oci_devops_deploy_pipeline["test_deploy_pipeline"]["id"],
            description=var["build_pipeline_stage_description"],
            display_name=var["build_pipeline_stage_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            image=var["build_pipeline_stage_image"],
            is_pass_all_parameters_enabled=var["build_pipeline_stage_is_pass_all_parameters_enabled"],
            primary_build_source=var["build_pipeline_stage_primary_build_source"],
            private_access_config=oci.dev_ops.BuildPipelineStagePrivateAccessConfigArgs(
                network_channel_type=var["build_pipeline_stage_private_access_config_network_channel_type"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                nsg_ids=var["build_pipeline_stage_private_access_config_nsg_ids"],
            ),
            stage_execution_timeout_in_seconds=var["build_pipeline_stage_stage_execution_timeout_in_seconds"],
            wait_criteria=oci.dev_ops.BuildPipelineStageWaitCriteriaArgs(
                wait_duration=var["build_pipeline_stage_wait_criteria_wait_duration"],
                wait_type=var["build_pipeline_stage_wait_criteria_wait_type"],
            ))
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        BuildPipelineStages can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DevOps/buildPipelineStage:BuildPipelineStage test_build_pipeline_stage "id"
        ```

        :param str resource_name: The name of the resource.
        :param BuildPipelineStageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BuildPipelineStageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_pipeline_id: Optional[pulumi.Input[str]] = None,
                 build_pipeline_stage_predecessor_collection: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs']]] = None,
                 build_pipeline_stage_type: Optional[pulumi.Input[str]] = None,
                 build_runner_shape_config: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageBuildRunnerShapeConfigArgs']]] = None,
                 build_source_collection: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageBuildSourceCollectionArgs']]] = None,
                 build_spec_file: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deliver_artifact_collection: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageDeliverArtifactCollectionArgs']]] = None,
                 deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 is_pass_all_parameters_enabled: Optional[pulumi.Input[bool]] = None,
                 primary_build_source: Optional[pulumi.Input[str]] = None,
                 private_access_config: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStagePrivateAccessConfigArgs']]] = None,
                 stage_execution_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
                 wait_criteria: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageWaitCriteriaArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BuildPipelineStageArgs.__new__(BuildPipelineStageArgs)

            if build_pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'build_pipeline_id'")
            __props__.__dict__["build_pipeline_id"] = build_pipeline_id
            if build_pipeline_stage_predecessor_collection is None and not opts.urn:
                raise TypeError("Missing required property 'build_pipeline_stage_predecessor_collection'")
            __props__.__dict__["build_pipeline_stage_predecessor_collection"] = build_pipeline_stage_predecessor_collection
            if build_pipeline_stage_type is None and not opts.urn:
                raise TypeError("Missing required property 'build_pipeline_stage_type'")
            __props__.__dict__["build_pipeline_stage_type"] = build_pipeline_stage_type
            __props__.__dict__["build_runner_shape_config"] = build_runner_shape_config
            __props__.__dict__["build_source_collection"] = build_source_collection
            __props__.__dict__["build_spec_file"] = build_spec_file
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["deliver_artifact_collection"] = deliver_artifact_collection
            __props__.__dict__["deploy_pipeline_id"] = deploy_pipeline_id
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["image"] = image
            __props__.__dict__["is_pass_all_parameters_enabled"] = is_pass_all_parameters_enabled
            __props__.__dict__["primary_build_source"] = primary_build_source
            __props__.__dict__["private_access_config"] = private_access_config
            __props__.__dict__["stage_execution_timeout_in_seconds"] = stage_execution_timeout_in_seconds
            __props__.__dict__["wait_criteria"] = wait_criteria
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(BuildPipelineStage, __self__).__init__(
            'oci:DevOps/buildPipelineStage:BuildPipelineStage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            build_pipeline_id: Optional[pulumi.Input[str]] = None,
            build_pipeline_stage_predecessor_collection: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs']]] = None,
            build_pipeline_stage_type: Optional[pulumi.Input[str]] = None,
            build_runner_shape_config: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageBuildRunnerShapeConfigArgs']]] = None,
            build_source_collection: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageBuildSourceCollectionArgs']]] = None,
            build_spec_file: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            deliver_artifact_collection: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageDeliverArtifactCollectionArgs']]] = None,
            deploy_pipeline_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            image: Optional[pulumi.Input[str]] = None,
            is_pass_all_parameters_enabled: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            primary_build_source: Optional[pulumi.Input[str]] = None,
            private_access_config: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStagePrivateAccessConfigArgs']]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            stage_execution_timeout_in_seconds: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            wait_criteria: Optional[pulumi.Input[pulumi.InputType['BuildPipelineStageWaitCriteriaArgs']]] = None) -> 'BuildPipelineStage':
        """
        Get an existing BuildPipelineStage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] build_pipeline_id: The OCID of the build pipeline.
        :param pulumi.Input[pulumi.InputType['BuildPipelineStageBuildPipelineStagePredecessorCollectionArgs']] build_pipeline_stage_predecessor_collection: (Updatable) The collection containing the predecessors of a stage.
        :param pulumi.Input[str] build_pipeline_stage_type: (Updatable) Defines the stage type, which is one of the following: BUILD, DELIVER_ARTIFACT, WAIT, and TRIGGER_DEPLOYMENT_PIPELINE.
        :param pulumi.Input[pulumi.InputType['BuildPipelineStageBuildRunnerShapeConfigArgs']] build_runner_shape_config: (Updatable) The information about build runner.
        :param pulumi.Input[pulumi.InputType['BuildPipelineStageBuildSourceCollectionArgs']] build_source_collection: (Updatable) Collection of build sources.
        :param pulumi.Input[str] build_spec_file: (Updatable) The path to the build specification file for this environment. The default location of the file if not specified is build_spec.yaml.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment where the pipeline is created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[pulumi.InputType['BuildPipelineStageDeliverArtifactCollectionArgs']] deliver_artifact_collection: (Updatable) Specifies an array of artifacts that need to be pushed to the artifactory stores.
        :param pulumi.Input[str] deploy_pipeline_id: (Updatable) A target deployment pipeline OCID that will run in this stage.
        :param pulumi.Input[str] description: (Updatable) Optional description about the stage.
        :param pulumi.Input[str] display_name: (Updatable) Stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] image: (Updatable) Image name for the build environment
        :param pulumi.Input[bool] is_pass_all_parameters_enabled: (Updatable) A boolean flag that specifies whether all the parameters must be passed when the deployment is triggered.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] primary_build_source: (Updatable) Name of the build source where the build_spec.yml file is located. If not specified, the first entry in the build source collection is chosen as primary build source.
        :param pulumi.Input[pulumi.InputType['BuildPipelineStagePrivateAccessConfigArgs']] private_access_config: (Updatable) Specifies the configuration needed when the target Oracle Cloud Infrastructure resource, i.e., OKE cluster, resides in customer's private network.
        :param pulumi.Input[str] project_id: The OCID of the DevOps project.
        :param pulumi.Input[int] stage_execution_timeout_in_seconds: (Updatable) Timeout for the build stage execution. Specify value in seconds.
        :param pulumi.Input[str] state: The current state of the stage.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the stage was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[str] time_updated: The time the stage was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        :param pulumi.Input[pulumi.InputType['BuildPipelineStageWaitCriteriaArgs']] wait_criteria: (Updatable) Specifies wait criteria for the Wait stage.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BuildPipelineStageState.__new__(_BuildPipelineStageState)

        __props__.__dict__["build_pipeline_id"] = build_pipeline_id
        __props__.__dict__["build_pipeline_stage_predecessor_collection"] = build_pipeline_stage_predecessor_collection
        __props__.__dict__["build_pipeline_stage_type"] = build_pipeline_stage_type
        __props__.__dict__["build_runner_shape_config"] = build_runner_shape_config
        __props__.__dict__["build_source_collection"] = build_source_collection
        __props__.__dict__["build_spec_file"] = build_spec_file
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deliver_artifact_collection"] = deliver_artifact_collection
        __props__.__dict__["deploy_pipeline_id"] = deploy_pipeline_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["image"] = image
        __props__.__dict__["is_pass_all_parameters_enabled"] = is_pass_all_parameters_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["primary_build_source"] = primary_build_source
        __props__.__dict__["private_access_config"] = private_access_config
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["stage_execution_timeout_in_seconds"] = stage_execution_timeout_in_seconds
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["wait_criteria"] = wait_criteria
        return BuildPipelineStage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="buildPipelineId")
    def build_pipeline_id(self) -> pulumi.Output[str]:
        """
        The OCID of the build pipeline.
        """
        return pulumi.get(self, "build_pipeline_id")

    @property
    @pulumi.getter(name="buildPipelineStagePredecessorCollection")
    def build_pipeline_stage_predecessor_collection(self) -> pulumi.Output['outputs.BuildPipelineStageBuildPipelineStagePredecessorCollection']:
        """
        (Updatable) The collection containing the predecessors of a stage.
        """
        return pulumi.get(self, "build_pipeline_stage_predecessor_collection")

    @property
    @pulumi.getter(name="buildPipelineStageType")
    def build_pipeline_stage_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Defines the stage type, which is one of the following: BUILD, DELIVER_ARTIFACT, WAIT, and TRIGGER_DEPLOYMENT_PIPELINE.
        """
        return pulumi.get(self, "build_pipeline_stage_type")

    @property
    @pulumi.getter(name="buildRunnerShapeConfig")
    def build_runner_shape_config(self) -> pulumi.Output['outputs.BuildPipelineStageBuildRunnerShapeConfig']:
        """
        (Updatable) The information about build runner.
        """
        return pulumi.get(self, "build_runner_shape_config")

    @property
    @pulumi.getter(name="buildSourceCollection")
    def build_source_collection(self) -> pulumi.Output['outputs.BuildPipelineStageBuildSourceCollection']:
        """
        (Updatable) Collection of build sources.
        """
        return pulumi.get(self, "build_source_collection")

    @property
    @pulumi.getter(name="buildSpecFile")
    def build_spec_file(self) -> pulumi.Output[str]:
        """
        (Updatable) The path to the build specification file for this environment. The default location of the file if not specified is build_spec.yaml.
        """
        return pulumi.get(self, "build_spec_file")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment where the pipeline is created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deliverArtifactCollection")
    def deliver_artifact_collection(self) -> pulumi.Output['outputs.BuildPipelineStageDeliverArtifactCollection']:
        """
        (Updatable) Specifies an array of artifacts that need to be pushed to the artifactory stores.
        """
        return pulumi.get(self, "deliver_artifact_collection")

    @property
    @pulumi.getter(name="deployPipelineId")
    def deploy_pipeline_id(self) -> pulumi.Output[str]:
        """
        (Updatable) A target deployment pipeline OCID that will run in this stage.
        """
        return pulumi.get(self, "deploy_pipeline_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Optional description about the stage.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Stage display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output[str]:
        """
        (Updatable) Image name for the build environment
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="isPassAllParametersEnabled")
    def is_pass_all_parameters_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag that specifies whether all the parameters must be passed when the deployment is triggered.
        """
        return pulumi.get(self, "is_pass_all_parameters_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="primaryBuildSource")
    def primary_build_source(self) -> pulumi.Output[str]:
        """
        (Updatable) Name of the build source where the build_spec.yml file is located. If not specified, the first entry in the build source collection is chosen as primary build source.
        """
        return pulumi.get(self, "primary_build_source")

    @property
    @pulumi.getter(name="privateAccessConfig")
    def private_access_config(self) -> pulumi.Output['outputs.BuildPipelineStagePrivateAccessConfig']:
        """
        (Updatable) Specifies the configuration needed when the target Oracle Cloud Infrastructure resource, i.e., OKE cluster, resides in customer's private network.
        """
        return pulumi.get(self, "private_access_config")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The OCID of the DevOps project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="stageExecutionTimeoutInSeconds")
    def stage_execution_timeout_in_seconds(self) -> pulumi.Output[int]:
        """
        (Updatable) Timeout for the build stage execution. Specify value in seconds.
        """
        return pulumi.get(self, "stage_execution_timeout_in_seconds")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the stage.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the stage was created. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the stage was updated. Format defined by [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="waitCriteria")
    def wait_criteria(self) -> pulumi.Output['outputs.BuildPipelineStageWaitCriteria']:
        """
        (Updatable) Specifies wait criteria for the Wait stage.
        """
        return pulumi.get(self, "wait_criteria")

