# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InvokeFunctionArgs', 'InvokeFunction']

@pulumi.input_type
class InvokeFunctionArgs:
    def __init__(__self__, *,
                 function_id: pulumi.Input[str],
                 base64_encode_content: Optional[pulumi.Input[bool]] = None,
                 fn_intent: Optional[pulumi.Input[str]] = None,
                 fn_invoke_type: Optional[pulumi.Input[str]] = None,
                 input_body_source_path: Optional[pulumi.Input[str]] = None,
                 invoke_function_body: Optional[pulumi.Input[str]] = None,
                 invoke_function_body_base64_encoded: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a InvokeFunction resource.
        :param pulumi.Input[str] function_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this function.
        :param pulumi.Input[str] fn_intent: An optional intent header that indicates to the FDK the way the event should be interpreted. E.g. 'httprequest', 'cloudevent'.
        :param pulumi.Input[str] fn_invoke_type: Indicates whether Oracle Functions should execute the request and return the result ('sync') of the execution,  or whether Oracle Functions should return as soon as processing has begun ('detached') and leave result handling to the function.
        :param pulumi.Input[str] input_body_source_path: An absolute path to a file on the local system that contains the input to be provided to the function. Cannot be defined if `invoke_function_body` or `invoke_function_body_base64_encoded` is defined. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] invoke_function_body: The body of the function invocation. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit. Cannot be defined if `input_body_source_path` or `invoke_function_body_base64_encoded` is defined.
        """
        pulumi.set(__self__, "function_id", function_id)
        if base64_encode_content is not None:
            pulumi.set(__self__, "base64_encode_content", base64_encode_content)
        if fn_intent is not None:
            pulumi.set(__self__, "fn_intent", fn_intent)
        if fn_invoke_type is not None:
            pulumi.set(__self__, "fn_invoke_type", fn_invoke_type)
        if input_body_source_path is not None:
            pulumi.set(__self__, "input_body_source_path", input_body_source_path)
        if invoke_function_body is not None:
            pulumi.set(__self__, "invoke_function_body", invoke_function_body)
        if invoke_function_body_base64_encoded is not None:
            pulumi.set(__self__, "invoke_function_body_base64_encoded", invoke_function_body_base64_encoded)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this function.
        """
        return pulumi.get(self, "function_id")

    @function_id.setter
    def function_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_id", value)

    @property
    @pulumi.getter(name="base64EncodeContent")
    def base64_encode_content(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "base64_encode_content")

    @base64_encode_content.setter
    def base64_encode_content(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "base64_encode_content", value)

    @property
    @pulumi.getter(name="fnIntent")
    def fn_intent(self) -> Optional[pulumi.Input[str]]:
        """
        An optional intent header that indicates to the FDK the way the event should be interpreted. E.g. 'httprequest', 'cloudevent'.
        """
        return pulumi.get(self, "fn_intent")

    @fn_intent.setter
    def fn_intent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fn_intent", value)

    @property
    @pulumi.getter(name="fnInvokeType")
    def fn_invoke_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether Oracle Functions should execute the request and return the result ('sync') of the execution,  or whether Oracle Functions should return as soon as processing has begun ('detached') and leave result handling to the function.
        """
        return pulumi.get(self, "fn_invoke_type")

    @fn_invoke_type.setter
    def fn_invoke_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fn_invoke_type", value)

    @property
    @pulumi.getter(name="inputBodySourcePath")
    def input_body_source_path(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute path to a file on the local system that contains the input to be provided to the function. Cannot be defined if `invoke_function_body` or `invoke_function_body_base64_encoded` is defined. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "input_body_source_path")

    @input_body_source_path.setter
    def input_body_source_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_body_source_path", value)

    @property
    @pulumi.getter(name="invokeFunctionBody")
    def invoke_function_body(self) -> Optional[pulumi.Input[str]]:
        """
        The body of the function invocation. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit. Cannot be defined if `input_body_source_path` or `invoke_function_body_base64_encoded` is defined.
        """
        return pulumi.get(self, "invoke_function_body")

    @invoke_function_body.setter
    def invoke_function_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invoke_function_body", value)

    @property
    @pulumi.getter(name="invokeFunctionBodyBase64Encoded")
    def invoke_function_body_base64_encoded(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "invoke_function_body_base64_encoded")

    @invoke_function_body_base64_encoded.setter
    def invoke_function_body_base64_encoded(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invoke_function_body_base64_encoded", value)


@pulumi.input_type
class _InvokeFunctionState:
    def __init__(__self__, *,
                 base64_encode_content: Optional[pulumi.Input[bool]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 fn_intent: Optional[pulumi.Input[str]] = None,
                 fn_invoke_type: Optional[pulumi.Input[str]] = None,
                 function_id: Optional[pulumi.Input[str]] = None,
                 input_body_source_path: Optional[pulumi.Input[str]] = None,
                 invoke_endpoint: Optional[pulumi.Input[str]] = None,
                 invoke_function_body: Optional[pulumi.Input[str]] = None,
                 invoke_function_body_base64_encoded: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering InvokeFunction resources.
        :param pulumi.Input[str] content: Content of the response string, if any. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        :param pulumi.Input[str] fn_intent: An optional intent header that indicates to the FDK the way the event should be interpreted. E.g. 'httprequest', 'cloudevent'.
        :param pulumi.Input[str] fn_invoke_type: Indicates whether Oracle Functions should execute the request and return the result ('sync') of the execution,  or whether Oracle Functions should return as soon as processing has begun ('detached') and leave result handling to the function.
        :param pulumi.Input[str] function_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this function.
        :param pulumi.Input[str] input_body_source_path: An absolute path to a file on the local system that contains the input to be provided to the function. Cannot be defined if `invoke_function_body` or `invoke_function_body_base64_encoded` is defined. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] invoke_function_body: The body of the function invocation. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit. Cannot be defined if `input_body_source_path` or `invoke_function_body_base64_encoded` is defined.
        """
        if base64_encode_content is not None:
            pulumi.set(__self__, "base64_encode_content", base64_encode_content)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if fn_intent is not None:
            pulumi.set(__self__, "fn_intent", fn_intent)
        if fn_invoke_type is not None:
            pulumi.set(__self__, "fn_invoke_type", fn_invoke_type)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)
        if input_body_source_path is not None:
            pulumi.set(__self__, "input_body_source_path", input_body_source_path)
        if invoke_endpoint is not None:
            pulumi.set(__self__, "invoke_endpoint", invoke_endpoint)
        if invoke_function_body is not None:
            pulumi.set(__self__, "invoke_function_body", invoke_function_body)
        if invoke_function_body_base64_encoded is not None:
            pulumi.set(__self__, "invoke_function_body_base64_encoded", invoke_function_body_base64_encoded)

    @property
    @pulumi.getter(name="base64EncodeContent")
    def base64_encode_content(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "base64_encode_content")

    @base64_encode_content.setter
    def base64_encode_content(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "base64_encode_content", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        Content of the response string, if any. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="fnIntent")
    def fn_intent(self) -> Optional[pulumi.Input[str]]:
        """
        An optional intent header that indicates to the FDK the way the event should be interpreted. E.g. 'httprequest', 'cloudevent'.
        """
        return pulumi.get(self, "fn_intent")

    @fn_intent.setter
    def fn_intent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fn_intent", value)

    @property
    @pulumi.getter(name="fnInvokeType")
    def fn_invoke_type(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether Oracle Functions should execute the request and return the result ('sync') of the execution,  or whether Oracle Functions should return as soon as processing has begun ('detached') and leave result handling to the function.
        """
        return pulumi.get(self, "fn_invoke_type")

    @fn_invoke_type.setter
    def fn_invoke_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fn_invoke_type", value)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this function.
        """
        return pulumi.get(self, "function_id")

    @function_id.setter
    def function_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_id", value)

    @property
    @pulumi.getter(name="inputBodySourcePath")
    def input_body_source_path(self) -> Optional[pulumi.Input[str]]:
        """
        An absolute path to a file on the local system that contains the input to be provided to the function. Cannot be defined if `invoke_function_body` or `invoke_function_body_base64_encoded` is defined. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "input_body_source_path")

    @input_body_source_path.setter
    def input_body_source_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_body_source_path", value)

    @property
    @pulumi.getter(name="invokeEndpoint")
    def invoke_endpoint(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "invoke_endpoint")

    @invoke_endpoint.setter
    def invoke_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invoke_endpoint", value)

    @property
    @pulumi.getter(name="invokeFunctionBody")
    def invoke_function_body(self) -> Optional[pulumi.Input[str]]:
        """
        The body of the function invocation. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit. Cannot be defined if `input_body_source_path` or `invoke_function_body_base64_encoded` is defined.
        """
        return pulumi.get(self, "invoke_function_body")

    @invoke_function_body.setter
    def invoke_function_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invoke_function_body", value)

    @property
    @pulumi.getter(name="invokeFunctionBodyBase64Encoded")
    def invoke_function_body_base64_encoded(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "invoke_function_body_base64_encoded")

    @invoke_function_body_base64_encoded.setter
    def invoke_function_body_base64_encoded(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "invoke_function_body_base64_encoded", value)


class InvokeFunction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base64_encode_content: Optional[pulumi.Input[bool]] = None,
                 fn_intent: Optional[pulumi.Input[str]] = None,
                 fn_invoke_type: Optional[pulumi.Input[str]] = None,
                 function_id: Optional[pulumi.Input[str]] = None,
                 input_body_source_path: Optional[pulumi.Input[str]] = None,
                 invoke_function_body: Optional[pulumi.Input[str]] = None,
                 invoke_function_body_base64_encoded: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Invoke Function resource in Oracle Cloud Infrastructure Functions service.

        Invokes a function

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_invoke_function = oci.functions.InvokeFunction("testInvokeFunction",
            function_id=oci_functions_function["test_function"]["id"],
            invoke_function_body=var["invoke_function_invoke_function_body"],
            fn_intent=var["invoke_function_fn_intent"],
            fn_invoke_type=var["invoke_function_fn_invoke_type"],
            base64_encode_content=False)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] fn_intent: An optional intent header that indicates to the FDK the way the event should be interpreted. E.g. 'httprequest', 'cloudevent'.
        :param pulumi.Input[str] fn_invoke_type: Indicates whether Oracle Functions should execute the request and return the result ('sync') of the execution,  or whether Oracle Functions should return as soon as processing has begun ('detached') and leave result handling to the function.
        :param pulumi.Input[str] function_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this function.
        :param pulumi.Input[str] input_body_source_path: An absolute path to a file on the local system that contains the input to be provided to the function. Cannot be defined if `invoke_function_body` or `invoke_function_body_base64_encoded` is defined. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] invoke_function_body: The body of the function invocation. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit. Cannot be defined if `input_body_source_path` or `invoke_function_body_base64_encoded` is defined.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InvokeFunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Invoke Function resource in Oracle Cloud Infrastructure Functions service.

        Invokes a function

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_invoke_function = oci.functions.InvokeFunction("testInvokeFunction",
            function_id=oci_functions_function["test_function"]["id"],
            invoke_function_body=var["invoke_function_invoke_function_body"],
            fn_intent=var["invoke_function_fn_intent"],
            fn_invoke_type=var["invoke_function_fn_invoke_type"],
            base64_encode_content=False)
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param InvokeFunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InvokeFunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base64_encode_content: Optional[pulumi.Input[bool]] = None,
                 fn_intent: Optional[pulumi.Input[str]] = None,
                 fn_invoke_type: Optional[pulumi.Input[str]] = None,
                 function_id: Optional[pulumi.Input[str]] = None,
                 input_body_source_path: Optional[pulumi.Input[str]] = None,
                 invoke_function_body: Optional[pulumi.Input[str]] = None,
                 invoke_function_body_base64_encoded: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InvokeFunctionArgs.__new__(InvokeFunctionArgs)

            __props__.__dict__["base64_encode_content"] = base64_encode_content
            __props__.__dict__["fn_intent"] = fn_intent
            __props__.__dict__["fn_invoke_type"] = fn_invoke_type
            if function_id is None and not opts.urn:
                raise TypeError("Missing required property 'function_id'")
            __props__.__dict__["function_id"] = function_id
            __props__.__dict__["input_body_source_path"] = input_body_source_path
            __props__.__dict__["invoke_function_body"] = invoke_function_body
            __props__.__dict__["invoke_function_body_base64_encoded"] = invoke_function_body_base64_encoded
            __props__.__dict__["content"] = None
            __props__.__dict__["invoke_endpoint"] = None
        super(InvokeFunction, __self__).__init__(
            'oci:Functions/invokeFunction:InvokeFunction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base64_encode_content: Optional[pulumi.Input[bool]] = None,
            content: Optional[pulumi.Input[str]] = None,
            fn_intent: Optional[pulumi.Input[str]] = None,
            fn_invoke_type: Optional[pulumi.Input[str]] = None,
            function_id: Optional[pulumi.Input[str]] = None,
            input_body_source_path: Optional[pulumi.Input[str]] = None,
            invoke_endpoint: Optional[pulumi.Input[str]] = None,
            invoke_function_body: Optional[pulumi.Input[str]] = None,
            invoke_function_body_base64_encoded: Optional[pulumi.Input[str]] = None) -> 'InvokeFunction':
        """
        Get an existing InvokeFunction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content: Content of the response string, if any. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        :param pulumi.Input[str] fn_intent: An optional intent header that indicates to the FDK the way the event should be interpreted. E.g. 'httprequest', 'cloudevent'.
        :param pulumi.Input[str] fn_invoke_type: Indicates whether Oracle Functions should execute the request and return the result ('sync') of the execution,  or whether Oracle Functions should return as soon as processing has begun ('detached') and leave result handling to the function.
        :param pulumi.Input[str] function_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this function.
        :param pulumi.Input[str] input_body_source_path: An absolute path to a file on the local system that contains the input to be provided to the function. Cannot be defined if `invoke_function_body` or `invoke_function_body_base64_encoded` is defined. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] invoke_function_body: The body of the function invocation. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit. Cannot be defined if `input_body_source_path` or `invoke_function_body_base64_encoded` is defined.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InvokeFunctionState.__new__(_InvokeFunctionState)

        __props__.__dict__["base64_encode_content"] = base64_encode_content
        __props__.__dict__["content"] = content
        __props__.__dict__["fn_intent"] = fn_intent
        __props__.__dict__["fn_invoke_type"] = fn_invoke_type
        __props__.__dict__["function_id"] = function_id
        __props__.__dict__["input_body_source_path"] = input_body_source_path
        __props__.__dict__["invoke_endpoint"] = invoke_endpoint
        __props__.__dict__["invoke_function_body"] = invoke_function_body
        __props__.__dict__["invoke_function_body_base64_encoded"] = invoke_function_body_base64_encoded
        return InvokeFunction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="base64EncodeContent")
    def base64_encode_content(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "base64_encode_content")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[str]:
        """
        Content of the response string, if any. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="fnIntent")
    def fn_intent(self) -> pulumi.Output[str]:
        """
        An optional intent header that indicates to the FDK the way the event should be interpreted. E.g. 'httprequest', 'cloudevent'.
        """
        return pulumi.get(self, "fn_intent")

    @property
    @pulumi.getter(name="fnInvokeType")
    def fn_invoke_type(self) -> pulumi.Output[str]:
        """
        Indicates whether Oracle Functions should execute the request and return the result ('sync') of the execution,  or whether Oracle Functions should return as soon as processing has begun ('detached') and leave result handling to the function.
        """
        return pulumi.get(self, "fn_invoke_type")

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of this function.
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter(name="inputBodySourcePath")
    def input_body_source_path(self) -> pulumi.Output[Optional[str]]:
        """
        An absolute path to a file on the local system that contains the input to be provided to the function. Cannot be defined if `invoke_function_body` or `invoke_function_body_base64_encoded` is defined. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "input_body_source_path")

    @property
    @pulumi.getter(name="invokeEndpoint")
    def invoke_endpoint(self) -> pulumi.Output[str]:
        return pulumi.get(self, "invoke_endpoint")

    @property
    @pulumi.getter(name="invokeFunctionBody")
    def invoke_function_body(self) -> pulumi.Output[str]:
        """
        The body of the function invocation. Note: The maximum size of the request is limited. This limit is currently 6MB and the endpoint will not accept requests that are bigger than this limit. Cannot be defined if `input_body_source_path` or `invoke_function_body_base64_encoded` is defined.
        """
        return pulumi.get(self, "invoke_function_body")

    @property
    @pulumi.getter(name="invokeFunctionBodyBase64Encoded")
    def invoke_function_body_base64_encoded(self) -> pulumi.Output[str]:
        return pulumi.get(self, "invoke_function_body_base64_encoded")

