# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMessagesResult',
    'AwaitableGetMessagesResult',
    'get_messages',
    'get_messages_output',
]

@pulumi.output_type
class GetMessagesResult:
    """
    A collection of values returned by getMessages.
    """
    def __init__(__self__, deployment_id=None, deployment_messages_collections=None, filters=None, id=None):
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if deployment_messages_collections and not isinstance(deployment_messages_collections, list):
            raise TypeError("Expected argument 'deployment_messages_collections' to be a list")
        pulumi.set(__self__, "deployment_messages_collections", deployment_messages_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> str:
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="deploymentMessagesCollections")
    def deployment_messages_collections(self) -> Sequence['outputs.GetMessagesDeploymentMessagesCollectionResult']:
        """
        The list of deployment_messages_collection.
        """
        return pulumi.get(self, "deployment_messages_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMessagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetMessagesResult(GetMessagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMessagesResult(
            deployment_id=self.deployment_id,
            deployment_messages_collections=self.deployment_messages_collections,
            filters=self.filters,
            id=self.id)


def get_messages(deployment_id: Optional[str] = None,
                 filters: Optional[Sequence[pulumi.InputType['GetMessagesFilterArgs']]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMessagesResult:
    """
    This data source provides the list of Messages in Oracle Cloud Infrastructure Golden Gate service.

    Lists the DeploymentMessages for a deployment. The sorting order is not important. By default first will be Upgrade message, next Exception message and then Storage Utilization message.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_messages = oci.GoldenGate.get_messages(deployment_id=oci_golden_gate_deployment["test_deployment"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str deployment_id: A unique Deployment identifier.
    """
    __args__ = dict()
    __args__['deploymentId'] = deployment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getMessages:getMessages', __args__, opts=opts, typ=GetMessagesResult).value

    return AwaitableGetMessagesResult(
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        deployment_messages_collections=pulumi.get(__ret__, 'deployment_messages_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_messages)
def get_messages_output(deployment_id: Optional[pulumi.Input[str]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMessagesFilterArgs']]]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMessagesResult]:
    """
    This data source provides the list of Messages in Oracle Cloud Infrastructure Golden Gate service.

    Lists the DeploymentMessages for a deployment. The sorting order is not important. By default first will be Upgrade message, next Exception message and then Storage Utilization message.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_messages = oci.GoldenGate.get_messages(deployment_id=oci_golden_gate_deployment["test_deployment"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str deployment_id: A unique Deployment identifier.
    """
    ...
