# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagementAgentsResult',
    'AwaitableGetManagementAgentsResult',
    'get_management_agents',
    'get_management_agents_output',
]

@pulumi.output_type
class GetManagementAgentsResult:
    """
    A collection of values returned by getManagementAgents.
    """
    def __init__(__self__, access_level=None, availability_status=None, compartment_id=None, compartment_id_in_subtree=None, data_source_names=None, data_source_type=None, display_name=None, filters=None, gateway_ids=None, host_id=None, id=None, install_type=None, is_customer_deployed=None, management_agents=None, platform_types=None, plugin_names=None, state=None, versions=None, wait_for_host_id=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if availability_status and not isinstance(availability_status, str):
            raise TypeError("Expected argument 'availability_status' to be a str")
        pulumi.set(__self__, "availability_status", availability_status)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if data_source_names and not isinstance(data_source_names, list):
            raise TypeError("Expected argument 'data_source_names' to be a list")
        pulumi.set(__self__, "data_source_names", data_source_names)
        if data_source_type and not isinstance(data_source_type, str):
            raise TypeError("Expected argument 'data_source_type' to be a str")
        pulumi.set(__self__, "data_source_type", data_source_type)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if gateway_ids and not isinstance(gateway_ids, list):
            raise TypeError("Expected argument 'gateway_ids' to be a list")
        pulumi.set(__self__, "gateway_ids", gateway_ids)
        if host_id and not isinstance(host_id, str):
            raise TypeError("Expected argument 'host_id' to be a str")
        pulumi.set(__self__, "host_id", host_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if install_type and not isinstance(install_type, str):
            raise TypeError("Expected argument 'install_type' to be a str")
        pulumi.set(__self__, "install_type", install_type)
        if is_customer_deployed and not isinstance(is_customer_deployed, bool):
            raise TypeError("Expected argument 'is_customer_deployed' to be a bool")
        pulumi.set(__self__, "is_customer_deployed", is_customer_deployed)
        if management_agents and not isinstance(management_agents, list):
            raise TypeError("Expected argument 'management_agents' to be a list")
        pulumi.set(__self__, "management_agents", management_agents)
        if platform_types and not isinstance(platform_types, list):
            raise TypeError("Expected argument 'platform_types' to be a list")
        pulumi.set(__self__, "platform_types", platform_types)
        if plugin_names and not isinstance(plugin_names, list):
            raise TypeError("Expected argument 'plugin_names' to be a list")
        pulumi.set(__self__, "plugin_names", plugin_names)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)
        if wait_for_host_id and not isinstance(wait_for_host_id, int):
            raise TypeError("Expected argument 'wait_for_host_id' to be a int")
        pulumi.set(__self__, "wait_for_host_id", wait_for_host_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> Optional[str]:
        """
        The current availability status of managementAgent
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment Identifier
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="dataSourceNames")
    def data_source_names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "data_source_names")

    @property
    @pulumi.getter(name="dataSourceType")
    def data_source_type(self) -> Optional[str]:
        return pulumi.get(self, "data_source_type")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Management Agent Name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagementAgentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="gatewayIds")
    def gateway_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "gateway_ids")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[str]:
        """
        Host resource ocid
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="installType")
    def install_type(self) -> Optional[str]:
        """
        The install type, either AGENT or GATEWAY
        """
        return pulumi.get(self, "install_type")

    @property
    @pulumi.getter(name="isCustomerDeployed")
    def is_customer_deployed(self) -> Optional[bool]:
        """
        true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
        """
        return pulumi.get(self, "is_customer_deployed")

    @property
    @pulumi.getter(name="managementAgents")
    def management_agents(self) -> Sequence['outputs.GetManagementAgentsManagementAgentResult']:
        """
        The list of management_agents.
        """
        return pulumi.get(self, "management_agents")

    @property
    @pulumi.getter(name="platformTypes")
    def platform_types(self) -> Optional[Sequence[str]]:
        """
        Platform Type
        """
        return pulumi.get(self, "platform_types")

    @property
    @pulumi.getter(name="pluginNames")
    def plugin_names(self) -> Optional[Sequence[str]]:
        """
        Management Agent Plugin Name
        """
        return pulumi.get(self, "plugin_names")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of managementAgent
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def versions(self) -> Optional[Sequence[str]]:
        """
        Management Agent Version
        """
        return pulumi.get(self, "versions")

    @property
    @pulumi.getter(name="waitForHostId")
    def wait_for_host_id(self) -> Optional[int]:
        return pulumi.get(self, "wait_for_host_id")


class AwaitableGetManagementAgentsResult(GetManagementAgentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementAgentsResult(
            access_level=self.access_level,
            availability_status=self.availability_status,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            data_source_names=self.data_source_names,
            data_source_type=self.data_source_type,
            display_name=self.display_name,
            filters=self.filters,
            gateway_ids=self.gateway_ids,
            host_id=self.host_id,
            id=self.id,
            install_type=self.install_type,
            is_customer_deployed=self.is_customer_deployed,
            management_agents=self.management_agents,
            platform_types=self.platform_types,
            plugin_names=self.plugin_names,
            state=self.state,
            versions=self.versions,
            wait_for_host_id=self.wait_for_host_id)


def get_management_agents(access_level: Optional[str] = None,
                          availability_status: Optional[str] = None,
                          compartment_id: Optional[str] = None,
                          compartment_id_in_subtree: Optional[bool] = None,
                          data_source_names: Optional[Sequence[str]] = None,
                          data_source_type: Optional[str] = None,
                          display_name: Optional[str] = None,
                          filters: Optional[Sequence[pulumi.InputType['GetManagementAgentsFilterArgs']]] = None,
                          gateway_ids: Optional[Sequence[str]] = None,
                          host_id: Optional[str] = None,
                          install_type: Optional[str] = None,
                          is_customer_deployed: Optional[bool] = None,
                          platform_types: Optional[Sequence[str]] = None,
                          plugin_names: Optional[Sequence[str]] = None,
                          state: Optional[str] = None,
                          versions: Optional[Sequence[str]] = None,
                          wait_for_host_id: Optional[int] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementAgentsResult:
    """
    This data source provides the list of Management Agents in Oracle Cloud Infrastructure Management Agent service.

    Returns a list of Management Agents.
    If no explicit page size limit is specified, it will default to 1000 when compartmentIdInSubtree is true and 5000 otherwise.
    The response is limited to maximum 1000 records when compartmentIdInSubtree is true.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agents = oci.ManagementAgent.get_management_agents(compartment_id=var["compartment_id"],
        access_level=var["management_agent_access_level"],
        availability_status=var["management_agent_availability_status"],
        compartment_id_in_subtree=var["management_agent_compartment_id_in_subtree"],
        data_source_names=oci_management_agent_management_agent_data_source["test_management_agent_data_source"]["name"],
        data_source_type=var["management_agent_data_source_type"],
        display_name=var["management_agent_display_name"],
        gateway_ids=oci_apigateway_gateway["test_gateway"]["id"],
        host_id=oci_management_agent_host["test_host"]["id"],
        wait_for_host_id=10,
        install_type=var["management_agent_install_type"],
        is_customer_deployed=var["management_agent_is_customer_deployed"],
        platform_types=var["management_agent_platform_type"],
        plugin_names=var["management_agent_plugin_name"],
        state=var["management_agent_state"],
        versions=var["management_agent_version"])
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: When the value is "ACCESSIBLE", insufficient permissions for a compartment will filter out resources in that compartment without rejecting the request.
    :param str availability_status: Filter to return only Management Agents in the particular availability status.
    :param str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param bool compartment_id_in_subtree: if set to true then it fetches resources for all compartments where user has access to else only on the compartment specified.
    :param Sequence[str] data_source_names: Unique name of the dataSource.
    :param str data_source_type: The type of the dataSource.
    :param str display_name: Filter to return only Management Agents having the particular display name.
    :param Sequence[str] gateway_ids: Filter to return only results having the particular gatewayId.
    :param str host_id: Filter to return only Management Agents having the particular agent host id.
    :param str install_type: A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
    :param bool is_customer_deployed: true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
    :param Sequence[str] platform_types: Array of PlatformTypes to return only results having the particular platform types. Example: ["LINUX"]
    :param Sequence[str] plugin_names: Array of pluginName to return only Management Agents having the particular Plugins installed. A special pluginName of 'None' can be provided and this will return only Management Agents having no plugin installed. Example: ["PluginA"]
    :param str state: Filter to return only Management Agents in the particular lifecycle state.
    :param Sequence[str] versions: Array of versions to return only Management Agents having the particular agent versions. Example: ["202020.0101","210201.0513"]
    :param int wait_for_host_id: When host_id argument is set, the data source will wait for the given period of time (in minutes) for this host_id to become available. This can be used when compute instance with Management Agent has been recently created.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['availabilityStatus'] = availability_status
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['dataSourceNames'] = data_source_names
    __args__['dataSourceType'] = data_source_type
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['gatewayIds'] = gateway_ids
    __args__['hostId'] = host_id
    __args__['installType'] = install_type
    __args__['isCustomerDeployed'] = is_customer_deployed
    __args__['platformTypes'] = platform_types
    __args__['pluginNames'] = plugin_names
    __args__['state'] = state
    __args__['versions'] = versions
    __args__['waitForHostId'] = wait_for_host_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getManagementAgents:getManagementAgents', __args__, opts=opts, typ=GetManagementAgentsResult).value

    return AwaitableGetManagementAgentsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        availability_status=pulumi.get(__ret__, 'availability_status'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        data_source_names=pulumi.get(__ret__, 'data_source_names'),
        data_source_type=pulumi.get(__ret__, 'data_source_type'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        gateway_ids=pulumi.get(__ret__, 'gateway_ids'),
        host_id=pulumi.get(__ret__, 'host_id'),
        id=pulumi.get(__ret__, 'id'),
        install_type=pulumi.get(__ret__, 'install_type'),
        is_customer_deployed=pulumi.get(__ret__, 'is_customer_deployed'),
        management_agents=pulumi.get(__ret__, 'management_agents'),
        platform_types=pulumi.get(__ret__, 'platform_types'),
        plugin_names=pulumi.get(__ret__, 'plugin_names'),
        state=pulumi.get(__ret__, 'state'),
        versions=pulumi.get(__ret__, 'versions'),
        wait_for_host_id=pulumi.get(__ret__, 'wait_for_host_id'))


@_utilities.lift_output_func(get_management_agents)
def get_management_agents_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                 availability_status: Optional[pulumi.Input[Optional[str]]] = None,
                                 compartment_id: Optional[pulumi.Input[str]] = None,
                                 compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                 data_source_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 data_source_type: Optional[pulumi.Input[Optional[str]]] = None,
                                 display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagementAgentsFilterArgs']]]]] = None,
                                 gateway_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 host_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 install_type: Optional[pulumi.Input[Optional[str]]] = None,
                                 is_customer_deployed: Optional[pulumi.Input[Optional[bool]]] = None,
                                 platform_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 plugin_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 state: Optional[pulumi.Input[Optional[str]]] = None,
                                 versions: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 wait_for_host_id: Optional[pulumi.Input[Optional[int]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagementAgentsResult]:
    """
    This data source provides the list of Management Agents in Oracle Cloud Infrastructure Management Agent service.

    Returns a list of Management Agents.
    If no explicit page size limit is specified, it will default to 1000 when compartmentIdInSubtree is true and 5000 otherwise.
    The response is limited to maximum 1000 records when compartmentIdInSubtree is true.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agents = oci.ManagementAgent.get_management_agents(compartment_id=var["compartment_id"],
        access_level=var["management_agent_access_level"],
        availability_status=var["management_agent_availability_status"],
        compartment_id_in_subtree=var["management_agent_compartment_id_in_subtree"],
        data_source_names=oci_management_agent_management_agent_data_source["test_management_agent_data_source"]["name"],
        data_source_type=var["management_agent_data_source_type"],
        display_name=var["management_agent_display_name"],
        gateway_ids=oci_apigateway_gateway["test_gateway"]["id"],
        host_id=oci_management_agent_host["test_host"]["id"],
        wait_for_host_id=10,
        install_type=var["management_agent_install_type"],
        is_customer_deployed=var["management_agent_is_customer_deployed"],
        platform_types=var["management_agent_platform_type"],
        plugin_names=var["management_agent_plugin_name"],
        state=var["management_agent_state"],
        versions=var["management_agent_version"])
    ```
    <!--End PulumiCodeChooser -->


    :param str access_level: When the value is "ACCESSIBLE", insufficient permissions for a compartment will filter out resources in that compartment without rejecting the request.
    :param str availability_status: Filter to return only Management Agents in the particular availability status.
    :param str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param bool compartment_id_in_subtree: if set to true then it fetches resources for all compartments where user has access to else only on the compartment specified.
    :param Sequence[str] data_source_names: Unique name of the dataSource.
    :param str data_source_type: The type of the dataSource.
    :param str display_name: Filter to return only Management Agents having the particular display name.
    :param Sequence[str] gateway_ids: Filter to return only results having the particular gatewayId.
    :param str host_id: Filter to return only Management Agents having the particular agent host id.
    :param str install_type: A filter to return either agents or gateway types depending upon install type selected by user. By default both install type will be returned.
    :param bool is_customer_deployed: true, if the agent image is manually downloaded and installed. false, if the agent is deployed as a plugin in Oracle Cloud Agent.
    :param Sequence[str] platform_types: Array of PlatformTypes to return only results having the particular platform types. Example: ["LINUX"]
    :param Sequence[str] plugin_names: Array of pluginName to return only Management Agents having the particular Plugins installed. A special pluginName of 'None' can be provided and this will return only Management Agents having no plugin installed. Example: ["PluginA"]
    :param str state: Filter to return only Management Agents in the particular lifecycle state.
    :param Sequence[str] versions: Array of versions to return only Management Agents having the particular agent versions. Example: ["202020.0101","210201.0513"]
    :param int wait_for_host_id: When host_id argument is set, the data source will wait for the given period of time (in minutes) for this host_id to become available. This can be used when compute instance with Management Agent has been recently created.
    """
    ...
