# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetQueueResult',
    'AwaitableGetQueueResult',
    'get_queue',
    'get_queue_output',
]

@pulumi.output_type
class GetQueueResult:
    """
    A collection of values returned by getQueue.
    """
    def __init__(__self__, channel_consumption_limit=None, compartment_id=None, custom_encryption_key_id=None, dead_letter_queue_delivery_count=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, messages_endpoint=None, purge_queue=None, purge_type=None, queue_id=None, retention_in_seconds=None, state=None, system_tags=None, time_created=None, time_updated=None, timeout_in_seconds=None, visibility_in_seconds=None):
        if channel_consumption_limit and not isinstance(channel_consumption_limit, int):
            raise TypeError("Expected argument 'channel_consumption_limit' to be a int")
        pulumi.set(__self__, "channel_consumption_limit", channel_consumption_limit)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if custom_encryption_key_id and not isinstance(custom_encryption_key_id, str):
            raise TypeError("Expected argument 'custom_encryption_key_id' to be a str")
        pulumi.set(__self__, "custom_encryption_key_id", custom_encryption_key_id)
        if dead_letter_queue_delivery_count and not isinstance(dead_letter_queue_delivery_count, int):
            raise TypeError("Expected argument 'dead_letter_queue_delivery_count' to be a int")
        pulumi.set(__self__, "dead_letter_queue_delivery_count", dead_letter_queue_delivery_count)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if messages_endpoint and not isinstance(messages_endpoint, str):
            raise TypeError("Expected argument 'messages_endpoint' to be a str")
        pulumi.set(__self__, "messages_endpoint", messages_endpoint)
        if purge_queue and not isinstance(purge_queue, bool):
            raise TypeError("Expected argument 'purge_queue' to be a bool")
        pulumi.set(__self__, "purge_queue", purge_queue)
        if purge_type and not isinstance(purge_type, str):
            raise TypeError("Expected argument 'purge_type' to be a str")
        pulumi.set(__self__, "purge_type", purge_type)
        if queue_id and not isinstance(queue_id, str):
            raise TypeError("Expected argument 'queue_id' to be a str")
        pulumi.set(__self__, "queue_id", queue_id)
        if retention_in_seconds and not isinstance(retention_in_seconds, int):
            raise TypeError("Expected argument 'retention_in_seconds' to be a int")
        pulumi.set(__self__, "retention_in_seconds", retention_in_seconds)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if timeout_in_seconds and not isinstance(timeout_in_seconds, int):
            raise TypeError("Expected argument 'timeout_in_seconds' to be a int")
        pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)
        if visibility_in_seconds and not isinstance(visibility_in_seconds, int):
            raise TypeError("Expected argument 'visibility_in_seconds' to be a int")
        pulumi.set(__self__, "visibility_in_seconds", visibility_in_seconds)

    @property
    @pulumi.getter(name="channelConsumptionLimit")
    def channel_consumption_limit(self) -> int:
        """
        The percentage of allocated queue resources that can be consumed by a single channel. For example, if a queue has a storage limit of 2Gb, and a single channel consumption limit is 0.1 (10%), that means data size of a single channel  can't exceed 200Mb. Consumption limit of 100% (default) means that a single channel can consume up-to all allocated queue's resources.
        """
        return pulumi.get(self, "channel_consumption_limit")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the queue.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="customEncryptionKeyId")
    def custom_encryption_key_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom encryption key to be used to encrypt messages content.
        """
        return pulumi.get(self, "custom_encryption_key_id")

    @property
    @pulumi.getter(name="deadLetterQueueDeliveryCount")
    def dead_letter_queue_delivery_count(self) -> int:
        """
        The number of times a message can be delivered to a consumer before being moved to the dead letter queue. A value of 0 indicates that the DLQ is not used.
        """
        return pulumi.get(self, "dead_letter_queue_delivery_count")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name for the queue. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A unique identifier for the queue that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Any additional details about the current state of the queue.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="messagesEndpoint")
    def messages_endpoint(self) -> str:
        """
        The endpoint to use to consume or publish messages in the queue.
        """
        return pulumi.get(self, "messages_endpoint")

    @property
    @pulumi.getter(name="purgeQueue")
    def purge_queue(self) -> bool:
        return pulumi.get(self, "purge_queue")

    @property
    @pulumi.getter(name="purgeType")
    def purge_type(self) -> str:
        return pulumi.get(self, "purge_type")

    @property
    @pulumi.getter(name="queueId")
    def queue_id(self) -> str:
        return pulumi.get(self, "queue_id")

    @property
    @pulumi.getter(name="retentionInSeconds")
    def retention_in_seconds(self) -> int:
        """
        The retention period of the messages in the queue, in seconds.
        """
        return pulumi.get(self, "retention_in_seconds")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the queue.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time that the queue was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time that the queue was updated, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> int:
        """
        The default polling timeout of the messages in the queue, in seconds.
        """
        return pulumi.get(self, "timeout_in_seconds")

    @property
    @pulumi.getter(name="visibilityInSeconds")
    def visibility_in_seconds(self) -> int:
        """
        The default visibility timeout of the messages consumed from the queue, in seconds.
        """
        return pulumi.get(self, "visibility_in_seconds")


class AwaitableGetQueueResult(GetQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueueResult(
            channel_consumption_limit=self.channel_consumption_limit,
            compartment_id=self.compartment_id,
            custom_encryption_key_id=self.custom_encryption_key_id,
            dead_letter_queue_delivery_count=self.dead_letter_queue_delivery_count,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            messages_endpoint=self.messages_endpoint,
            purge_queue=self.purge_queue,
            purge_type=self.purge_type,
            queue_id=self.queue_id,
            retention_in_seconds=self.retention_in_seconds,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            timeout_in_seconds=self.timeout_in_seconds,
            visibility_in_seconds=self.visibility_in_seconds)


def get_queue(queue_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueueResult:
    """
    This data source provides details about a specific Queue resource in Oracle Cloud Infrastructure Queue service.

    Gets a queue by identifier.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_queue = oci.Queue.get_queue(queue_id=oci_queue_queue["test_queue"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str queue_id: The unique queue identifier.
    """
    __args__ = dict()
    __args__['queueId'] = queue_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Queue/getQueue:getQueue', __args__, opts=opts, typ=GetQueueResult).value

    return AwaitableGetQueueResult(
        channel_consumption_limit=pulumi.get(__ret__, 'channel_consumption_limit'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        custom_encryption_key_id=pulumi.get(__ret__, 'custom_encryption_key_id'),
        dead_letter_queue_delivery_count=pulumi.get(__ret__, 'dead_letter_queue_delivery_count'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        messages_endpoint=pulumi.get(__ret__, 'messages_endpoint'),
        purge_queue=pulumi.get(__ret__, 'purge_queue'),
        purge_type=pulumi.get(__ret__, 'purge_type'),
        queue_id=pulumi.get(__ret__, 'queue_id'),
        retention_in_seconds=pulumi.get(__ret__, 'retention_in_seconds'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        timeout_in_seconds=pulumi.get(__ret__, 'timeout_in_seconds'),
        visibility_in_seconds=pulumi.get(__ret__, 'visibility_in_seconds'))


@_utilities.lift_output_func(get_queue)
def get_queue_output(queue_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetQueueResult]:
    """
    This data source provides details about a specific Queue resource in Oracle Cloud Infrastructure Queue service.

    Gets a queue by identifier.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_queue = oci.Queue.get_queue(queue_id=oci_queue_queue["test_queue"]["id"])
    ```
    <!--End PulumiCodeChooser -->


    :param str queue_id: The unique queue identifier.
    """
    ...
