# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetStreamPoolsResult',
    'AwaitableGetStreamPoolsResult',
    'get_stream_pools',
    'get_stream_pools_output',
]

@pulumi.output_type
class GetStreamPoolsResult:
    """
    A collection of values returned by getStreamPools.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, state=None, stream_pools=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_pools and not isinstance(stream_pools, list):
            raise TypeError("Expected argument 'stream_pools' to be a list")
        pulumi.set(__self__, "stream_pools", stream_pools)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment OCID that the pool belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetStreamPoolsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the stream pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the stream pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the stream pool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamPools")
    def stream_pools(self) -> Sequence['outputs.GetStreamPoolsStreamPoolResult']:
        """
        The list of stream_pools.
        """
        return pulumi.get(self, "stream_pools")


class AwaitableGetStreamPoolsResult(GetStreamPoolsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamPoolsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state,
            stream_pools=self.stream_pools)


def get_stream_pools(compartment_id: Optional[str] = None,
                     filters: Optional[Sequence[pulumi.InputType['GetStreamPoolsFilterArgs']]] = None,
                     id: Optional[str] = None,
                     name: Optional[str] = None,
                     state: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamPoolsResult:
    """
    This data source provides the list of Stream Pools in Oracle Cloud Infrastructure Streaming service.

    List the stream pools for a given compartment ID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_pools = oci.Streaming.get_stream_pools(compartment_id=var["compartment_id"],
        id=var["stream_pool_id"],
        name=var["stream_pool_name"],
        state=var["stream_pool_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment.
    :param str id: A filter to return only resources that match the given ID exactly.
    :param str name: A filter to return only resources that match the given name exactly.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Streaming/getStreamPools:getStreamPools', __args__, opts=opts, typ=GetStreamPoolsResult).value

    return AwaitableGetStreamPoolsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        stream_pools=pulumi.get(__ret__, 'stream_pools'))


@_utilities.lift_output_func(get_stream_pools)
def get_stream_pools_output(compartment_id: Optional[pulumi.Input[str]] = None,
                            filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetStreamPoolsFilterArgs']]]]] = None,
                            id: Optional[pulumi.Input[Optional[str]]] = None,
                            name: Optional[pulumi.Input[Optional[str]]] = None,
                            state: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStreamPoolsResult]:
    """
    This data source provides the list of Stream Pools in Oracle Cloud Infrastructure Streaming service.

    List the stream pools for a given compartment ID.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_pools = oci.Streaming.get_stream_pools(compartment_id=var["compartment_id"],
        id=var["stream_pool_id"],
        name=var["stream_pool_name"],
        state=var["stream_pool_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment.
    :param str id: A filter to return only resources that match the given ID exactly.
    :param str name: A filter to return only resources that match the given name exactly.
    :param str state: A filter to only return resources that match the given lifecycle state. The state value is case-insensitive.
    """
    ...
