# Copyright 2023 The KServe Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    KServe

    Python SDK for KServe  # noqa: E501

    The version of the OpenAPI document: v0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kserve.configuration import Configuration


class V1alpha1InferenceGraphSpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'affinity': 'V1Affinity',
        'nodes': 'dict(str, V1alpha1InferenceRouter)',
        'resources': 'V1ResourceRequirements'
    }

    attribute_map = {
        'affinity': 'affinity',
        'nodes': 'nodes',
        'resources': 'resources'
    }

    def __init__(self, affinity=None, nodes=None, resources=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1InferenceGraphSpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._affinity = None
        self._nodes = None
        self._resources = None
        self.discriminator = None

        if affinity is not None:
            self.affinity = affinity
        self.nodes = nodes
        if resources is not None:
            self.resources = resources

    @property
    def affinity(self):
        """Gets the affinity of this V1alpha1InferenceGraphSpec.  # noqa: E501


        :return: The affinity of this V1alpha1InferenceGraphSpec.  # noqa: E501
        :rtype: V1Affinity
        """
        return self._affinity

    @affinity.setter
    def affinity(self, affinity):
        """Sets the affinity of this V1alpha1InferenceGraphSpec.


        :param affinity: The affinity of this V1alpha1InferenceGraphSpec.  # noqa: E501
        :type: V1Affinity
        """

        self._affinity = affinity

    @property
    def nodes(self):
        """Gets the nodes of this V1alpha1InferenceGraphSpec.  # noqa: E501

        Map of InferenceGraph router nodes Each node defines the router which can be different routing types  # noqa: E501

        :return: The nodes of this V1alpha1InferenceGraphSpec.  # noqa: E501
        :rtype: dict(str, V1alpha1InferenceRouter)
        """
        return self._nodes

    @nodes.setter
    def nodes(self, nodes):
        """Sets the nodes of this V1alpha1InferenceGraphSpec.

        Map of InferenceGraph router nodes Each node defines the router which can be different routing types  # noqa: E501

        :param nodes: The nodes of this V1alpha1InferenceGraphSpec.  # noqa: E501
        :type: dict(str, V1alpha1InferenceRouter)
        """
        if self.local_vars_configuration.client_side_validation and nodes is None:  # noqa: E501
            raise ValueError("Invalid value for `nodes`, must not be `None`")  # noqa: E501

        self._nodes = nodes

    @property
    def resources(self):
        """Gets the resources of this V1alpha1InferenceGraphSpec.  # noqa: E501


        :return: The resources of this V1alpha1InferenceGraphSpec.  # noqa: E501
        :rtype: V1ResourceRequirements
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this V1alpha1InferenceGraphSpec.


        :param resources: The resources of this V1alpha1InferenceGraphSpec.  # noqa: E501
        :type: V1ResourceRequirements
        """

        self._resources = resources

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1InferenceGraphSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1InferenceGraphSpec):
            return True

        return self.to_dict() != other.to_dict()
