"""Config flow for Profiler integration."""

from homeassistant.config_entries import ConfigFlow

from .const import DEFAULT_NAME, DOMAIN


class ProfilerConfigFlow(ConfigFlow, domain=DOMAIN):
    """Handle a config flow for Profiler."""

    VERSION = 1

    async def async_step_user(self, user_input=None):
        """Handle the initial step."""
        if self._async_current_entries():
            return self.async_abort(reason="single_instance_allowed")

        if user_input is not None:
            return self.async_create_entry(title=DEFAULT_NAME, data={})

        return self.async_show_form(step_id="user")
