/*
 * Decompiled with CFR 0.152.
 */
package ee.ut.soras.osalau;

import ee.ut.soras.osalau.OsalauSona;
import ee.ut.soras.osalau.SonaMall;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class TekstiFiltreerimine {
    public static List<List<OsalauSona>> eraldaLaused(List<OsalauSona> sonad) {
        ArrayList<List<OsalauSona>> laused = new ArrayList<List<OsalauSona>>();
        int lauseAlgus = 0;
        for (int i = 0; i < sonad.size(); ++i) {
            if (!sonad.get(i).getMorfSona().onLauseLopp()) continue;
            laused.add(sonad.subList(lauseAlgus, i + 1));
            lauseAlgus = i + 1;
        }
        return laused;
    }

    public static List<List<OsalauSona>> jagaKindlatePiirideKohalt(List<List<OsalauSona>> laused) {
        ArrayList<List<OsalauSona>> uusTykeldus = new ArrayList<List<OsalauSona>>();
        for (List<OsalauSona> lause : laused) {
            ArrayList<OsalauSona> osalause = new ArrayList<OsalauSona>();
            for (int i = 0; i < lause.size(); ++i) {
                OsalauSona sona = lause.get(i);
                if (sona.omabMargendit(OsalauSona.MARGEND.KIILU_ALGUS)) {
                    TekstiFiltreerimine.eemaldaOLPiiridAlgusestLopust(osalause);
                    uusTykeldus.add(osalause);
                    osalause = new ArrayList();
                }
                osalause.add(sona);
                if (!sona.omabMargendit(OsalauSona.MARGEND.KINDEL_PIIR) && !sona.omabMargendit(OsalauSona.MARGEND.KIILU_LOPP)) continue;
                TekstiFiltreerimine.eemaldaOLPiiridAlgusestLopust(osalause);
                uusTykeldus.add(osalause);
                osalause = new ArrayList();
            }
            if (osalause.size() <= 0) continue;
            TekstiFiltreerimine.eemaldaOLPiiridAlgusestLopust(osalause);
            uusTykeldus.add(osalause);
        }
        return uusTykeldus;
    }

    public static void eemaldaOLPiiridAlgusestLopust(List<OsalauSona> osalause) {
        if (osalause.isEmpty()) {
            return;
        }
        SonaMall olpiir = new SonaMall(OsalauSona.MARGEND.OLETATAV_PIIR);
        SonaMall komaSonaL6pus = new SonaMall(Pattern.compile("^.*\\p{Alpha}.*,$"));
        try {
            int subListSize = Math.min(osalause.size(), 3);
            List<OsalauSona> prefixList = osalause.subList(0, subListSize);
            List<OsalauSona> suffixList = osalause.subList(osalause.size() - subListSize, osalause.size());
            for (OsalauSona sona : prefixList) {
                if (!olpiir.vastabMallileAND(sona) || komaSonaL6pus.vastabMallileAND(sona)) break;
                sona.eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
            }
            for (int i = suffixList.size() - 1; i > -1 && olpiir.vastabMallileAND(suffixList.get(i)); --i) {
                suffixList.get(i).eemaldaMargend(OsalauSona.MARGEND.OLETATAV_PIIR);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static int eelnebMargendigaSona(List<OsalauSona> lause, int i, SonaMall otsitav, SonaMall keelatud) throws Exception {
        for (int j = i - 1; j >= 0; --j) {
            OsalauSona eelnevSona = lause.get(j);
            if (keelatud != null && keelatud.vastabMallileOR(eelnevSona)) {
                return -1;
            }
            if (!otsitav.vastabMallileAND(eelnevSona)) continue;
            return j;
        }
        return -1;
    }

    public static int eelnebMargendigaSonaOR(List<OsalauSona> lause, int i, SonaMall otsitav, SonaMall keelatud) throws Exception {
        for (int j = i - 1; j >= 0; --j) {
            OsalauSona eelnevSona = lause.get(j);
            if (keelatud != null && keelatud.vastabMallileOR(eelnevSona)) {
                return -1;
            }
            if (!otsitav.vastabMallileOR(eelnevSona)) continue;
            return j;
        }
        return -1;
    }

    public static int jargnebMargendigaSona(List<OsalauSona> lause, int i, SonaMall otsitav, SonaMall keelatud) throws Exception {
        for (int j = i + 1; j < lause.size(); ++j) {
            OsalauSona jargnevSona = lause.get(j);
            if (keelatud != null && keelatud.vastabMallileOR(jargnevSona)) {
                return -1;
            }
            if (!otsitav.vastabMallileAND(jargnevSona)) continue;
            return j;
        }
        return -1;
    }

    public static int jargnebMargendigaSonaOR(List<OsalauSona> lause, int i, SonaMall otsitav, SonaMall keelatud) throws Exception {
        for (int j = i + 1; j < lause.size(); ++j) {
            OsalauSona jargnevSona = lause.get(j);
            if (keelatud != null && keelatud.vastabMallileOR(jargnevSona)) {
                return -1;
            }
            if (!otsitav.vastabMallileOR(jargnevSona)) continue;
            return j;
        }
        return -1;
    }

    public static String debugMargendustegaLause(List<OsalauSona> sonad, boolean kuvaAinultKindlad) {
        StringBuilder sb = new StringBuilder();
        for (OsalauSona osalauSona : sonad) {
            sb.append(osalauSona.getMorfSona().getAlgSona());
            if (kuvaAinultKindlad) {
                if (!osalauSona.getKindladOLPMargendid().isEmpty()) {
                    for (OsalauSona.MARGEND m : osalauSona.getKindladOLPMargendid()) {
                        sb.append((Object)m);
                    }
                }
            } else if (osalauSona.getMargendid() != null) {
                for (OsalauSona.MARGEND m : osalauSona.getMargendid()) {
                    sb.append((Object)m);
                }
            }
            sb.append(" ");
        }
        return sb.toString();
    }
}

