from typing import Any, Dict, List, Optional, Tuple

import requests
from troveclient.apiclient.auth import BaseAuthPlugin
from troveclient.extension import Extension

class HTTPClient(object):
    def __init__(
        self,
        auth_plugin: BaseAuthPlugin,
        region_name=None,
        endpoint_type="publicURL",
        original_ip=None,
        verify=True,
        cert=None,
        timeout=None,
        timings=False,
        keyring_saver=None,
        debug=False,
        user_agent=None,
        http=None,
    ): ...
    def _http_log_req(self, method: str, url: str, kwargs: Dict[str, Any]): ...
    def _http_log_resp(self, resp: requests.Response): ...
    def serialize(self, kwargs: Dict) -> None: ...
    def get_timings(self) -> List[Tuple[str, float, float]]: ...
    def reset_timings(self) -> None: ...
    def request(self, method: str, url: str, **kwargs): ...
    @staticmethod
    def concat_url(endpoint: str, url: str): ...
    def client_request(
        self, client: BaseClient, method: str, url: str, **kwargs
    ) -> requests.Response: ...
    def add_client(self, base_client_instance: BaseClient): ...
    def authenticate(self) -> None: ...

class BaseClient(object):
    def __init__(
        self, http_client: HTTPClient, extensions: Optional[List[Extension]] = None
    ): ...
    def client_request(self, method: str, url: str, **kwargs) -> requests.Response: ...
    def head(self, url: str, **kwargs) -> requests.Response: ...
    def get(self, url: str, **kwargs) -> requests.Response: ...
    def post(self, url: str, **kwargs) -> requests.Response: ...
    def put(self, url: str, **kwargs) -> requests.Response: ...
    def delete(self, url: str, **kwargs) -> requests.Response: ...
    def patch(self, url: str, **kwargs) -> requests.Response: ...
    # TODO: Add BaseClient
    @staticmethod
    def get_class(api_name: str, version: str, version_map: Dict[str, str]) -> Any: ...
